/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.megacore.pcie.model.IPCIETableModel;
import com.altera.megacore.pcie.ui.GroupableTableHeader;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.handler.MWEventHandler;
import com.altera.megawizard2.view.MWText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MWTable
extends JTable
implements MWControl {
    private IPCIETableModel tableModel = null;
    private MWEventHandler mwEventHandler = null;
    private String parameterName = null;
    private List<MWControl> listOfControls;
    private boolean bCurrentlyEnabled = true;

    public MWTable(TableModel dm, String parameterName) {
        super(dm);
        this.parameterName = parameterName;
        this.listOfControls = new Vector<MWControl>();
        this.tableModel = (IPCIETableModel)dm;
        MWControl[][] mWControlArray = this.tableModel.getTableDynamicControls();
        int n = mWControlArray.length;
        for (int i = 0; i < n; ++i) {
            MWControl[] controls;
            for (MWControl control : controls = mWControlArray[i]) {
                if (control == null) continue;
                this.listOfControls.add(control);
            }
        }
        MWText mwText = new MWText();
        this.setRowHeight(mwText.getMinimumSize().height - 2);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
    }

    public JComponent getJComponent() {
        return this;
    }

    public void setMWEventHandler(MWEventHandler handler) {
        this.mwEventHandler = handler;
        this.tableModel.setMWEventHandler(handler);
        for (MWControl controls : this.listOfControls) {
            controls.setMWEventHandler(handler);
        }
    }

    public MWEventHandler getMWEventHandler() {
        return this.mwEventHandler;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Dimension getControlSize() {
        return this.getPreferredSize();
    }

    public void receiveChangeEvent() {
        IParameterDescriptor pd;
        boolean enabled;
        if (this.getParameterName() != null && this.getMWEventHandler() != null && this.bCurrentlyEnabled != (enabled = (pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName())).isEnabled())) {
            this.bCurrentlyEnabled = enabled;
            this.setEnabled(this.bCurrentlyEnabled);
        }
        if (this.bCurrentlyEnabled) {
            this.tableModel.receiveChangeEvent();
        }
        Color foregroundColor = null;
        foregroundColor = this.bCurrentlyEnabled ? UIManager.getColor("TableHeader.foreground") : UIManager.getColor("Label.disabledForeground");
        this.getTableHeader().setForeground(foregroundColor);
        DefaultTableCellRenderer renderer = null;
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            renderer = (DefaultTableCellRenderer)this.getColumnModel().getColumn(i).getCellRenderer();
            renderer.setForeground(foregroundColor);
        }
        this.repaint();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor cellEditor = this.tableModel.getTableCellEditor(row, column);
        if (cellEditor != null) {
            return cellEditor;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null) {
            editor = this.getDefaultEditor(this.getColumnClass(column));
        }
        return editor;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new GroupableTableHeader(this.columnModel);
    }

    public static void EnableDisableContainer(Container c, boolean isEnabled) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(isEnabled);
            if (!(components[i] instanceof Container) || components[i].getName() != null) continue;
            MWTable.EnableDisableContainer((Container)components[i], isEnabled);
        }
    }
}

