/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.megacore.pcie.ui.MWTextArea;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.handler.MWEventHandler;
import com.altera.megawizard2.view.MWButtonGroup;
import com.altera.megawizard2.view.MWPanel;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

public class MWInfoPanel
implements MWControl {
    private HashMap<String, String> headerMap;
    private HashMap<String, String> contentMap;
    private MWTextArea textControl = null;
    private MWPanel panel = null;
    private TitledBorder panelBorder = null;
    private MWButtonGroup buttonGroup = null;
    private MWEventHandler mwEventHandler = null;
    private Boolean bPanelBorder = false;

    public MWInfoPanel(MWButtonGroup buttonGroup, Boolean bPanelBorder) {
        this.buttonGroup = buttonGroup;
        this.bPanelBorder = bPanelBorder;
        if (bPanelBorder.booleanValue()) {
            this.panel = new MWPanel("Default Header");
        } else {
            this.panel = new MWPanel();
            this.panel.getJPanel().setBorder(BorderFactory.createEmptyBorder());
        }
        this.headerMap = new HashMap();
        this.contentMap = new HashMap();
        this.textControl = new MWTextArea();
        this.textControl.setEditable(false);
        this.panel.add((MWControl)this.textControl);
    }

    public void addInfo(String associatedValue, String content) {
        if (!this.contentMap.containsKey(associatedValue)) {
            this.contentMap.put(associatedValue, content);
        }
    }

    public void addDisabledMessage(String content) {
        if (!this.contentMap.containsKey("disabledMessage")) {
            this.contentMap.put("disabledMessage", content);
        }
    }

    public void addInfo(String associatedValue, String header, String content) {
        if (!this.headerMap.containsKey(associatedValue)) {
            this.headerMap.put(associatedValue, header);
        }
        if (!this.contentMap.containsKey(associatedValue)) {
            this.contentMap.put(associatedValue, content);
        }
    }

    public void addDisabledMessage(String header, String content) {
        if (!this.headerMap.containsKey("disabledMessage")) {
            this.headerMap.put("disabledMessage", header);
        }
        if (!this.contentMap.containsKey("disabledMessage")) {
            this.contentMap.put("disabledMessage", content);
        }
    }

    public void finish() {
        this.panel.finish();
    }

    public void finish(int margin) {
        this.panel.finish(margin);
    }

    public MWTextArea getTextControl() {
        return this.textControl;
    }

    public JComponent getJComponent() {
        return this.panel.getJPanel();
    }

    public void setMWEventHandler(MWEventHandler handler) {
        this.mwEventHandler = handler;
    }

    public String getParameterName() {
        return this.buttonGroup.getParameterName();
    }

    public Dimension getControlSize() {
        return this.panel.getJPanel().getPreferredSize();
    }

    private MWEventHandler getMWEventHandler() {
        return this.mwEventHandler;
    }

    public void receiveChangeEvent() {
        IParameterDescriptor pd;
        String paramValue = null;
        if (this.getParameterName() != null && this.getMWEventHandler() != null && (pd = this.getMWEventHandler().getParameterDescriptor(this.buttonGroup.getParameterName())) != null) {
            paramValue = this.getMWEventHandler().getValue(pd.getName(), pd.getType()).toString();
            this.panel.getJPanel().setVisible(true);
            this.textControl.setVisible(true);
            if (this.getMWEventHandler().isModelInError()) {
                this.panel.getJPanel().setEnabled(pd.isRelatedToError());
                this.textControl.setEnabled(pd.isRelatedToError());
            } else if (pd.isEnabled()) {
                this.panel.getJPanel().setEnabled(true);
                this.textControl.setEnabled(true);
                if ((this.headerMap.containsKey(paramValue) || !this.bPanelBorder.booleanValue()) && this.contentMap.containsKey(paramValue)) {
                    this.textControl.setText(this.contentMap.get(paramValue));
                    if (this.bPanelBorder.booleanValue()) {
                        this.panelBorder = (TitledBorder)this.panel.getJPanel().getBorder();
                        this.panelBorder.setTitle(this.headerMap.get(paramValue));
                    }
                    this.panel.getJPanel().repaint();
                }
            } else if ((this.headerMap.containsKey(paramValue) || !this.bPanelBorder.booleanValue()) && this.contentMap.containsKey("disabledMessage")) {
                this.panel.getJPanel().setEnabled(true);
                this.textControl.setEnabled(true);
                this.textControl.setText(this.contentMap.get("disabledMessage"));
                if (this.bPanelBorder.booleanValue()) {
                    this.panelBorder = (TitledBorder)this.panel.getJPanel().getBorder();
                    this.panelBorder.setTitle(this.headerMap.get("disabledMessage"));
                }
                this.panel.getJPanel().repaint();
            } else if ((this.headerMap.containsKey(paramValue) || !this.bPanelBorder.booleanValue()) && this.contentMap.containsKey(paramValue)) {
                this.textControl.setText(this.contentMap.get(paramValue));
                if (this.bPanelBorder.booleanValue()) {
                    this.panelBorder = (TitledBorder)this.panel.getJPanel().getBorder();
                    this.panelBorder.setTitle(this.headerMap.get(paramValue));
                }
                this.panel.getJPanel().repaint();
            }
        }
    }
}

