/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.megacore.pcie.ui.MWFormattedTextField;
import com.altera.megawizard2.utilities.MWParameterDescriptorHelper;
import com.altera.utilities.AltString;
import java.text.ParseException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class MWHexFormattedTextField
extends MWFormattedTextField {
    static final String format_prefix = "0x";
    static final String format_modifier = "H";
    private int hexWidth = 8;

    static String getFormat(int hexWidth) {
        StringBuffer sb = new StringBuffer(format_prefix);
        for (int numberOfModifier = 0; numberOfModifier < hexWidth; ++numberOfModifier) {
            sb.append(format_modifier);
        }
        return sb.toString();
    }

    public MWHexFormattedTextField(String parameterName, int hexWidth) {
        super(parameterName, MWHexFormattedTextField.getFormat(hexWidth));
        this.hexWidth = hexWidth;
    }

    public void setHexWidth(int hexWidth) {
        this.hexWidth = hexWidth;
        MaskFormatter newFormatter = MWHexFormattedTextField.createFormatter(MWHexFormattedTextField.getFormat(this.hexWidth));
        this.setFormatterFactory(new DefaultFormatterFactory(newFormatter));
    }

    @Override
    public void receiveChangeEvent() {
        IParameterDescriptor pd;
        if (this.getParameterName() != null && this.getMWEventHandler() != null && (pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName())) != null) {
            String hexValue = null;
            if (Long.TYPE.equals(pd.getType()) || Long.class.equals((Object)pd.getType())) {
                long longValue = (Long)this.getMWEventHandler().getValue(this.getParameterName(), Long.TYPE);
                String tempHexValue = AltString.longToRadixString((long)longValue, (int)this.hexWidth, (int)16);
                tempHexValue = tempHexValue.toUpperCase();
                hexValue = format_prefix + tempHexValue;
            } else if (Integer.TYPE.equals(pd.getType()) || Integer.class.equals((Object)pd.getType())) {
                int intValue = (Integer)this.getMWEventHandler().getValue(this.getParameterName(), Integer.TYPE);
                String tempHexValue = null;
                if (pd.getName().equals("p_pcie_msix_table_offset") || pd.getName().equals("p_pcie_msix_pba_offset")) {
                    String binaryVal = Integer.toBinaryString(intValue);
                    binaryVal = binaryVal + "000";
                    long theValue = AltString.stringToLong((String)binaryVal, (int)2);
                    tempHexValue = AltString.longToRadixString((long)theValue, (int)this.hexWidth, (int)16);
                } else {
                    tempHexValue = AltString.longToRadixString((long)intValue, (int)this.hexWidth, (int)16);
                }
                tempHexValue = tempHexValue.toUpperCase();
                hexValue = format_prefix + tempHexValue;
            } else {
                Object obj = this.getMWEventHandler().getValue(this.getParameterName(), pd.getType());
                hexValue = obj.toString();
            }
            this.setValue(hexValue);
            this.setVisible(pd.isVisible());
            if (this.getMWEventHandler().isModelInError()) {
                this.setEnabled(pd.isRelatedToError());
            } else {
                this.setEnabled(pd.isEnabled());
            }
        }
    }

    @Override
    public void commitEdit() throws ParseException {
        try {
            super.commitEdit();
            if (this.getParameterName() != null && this.getMWEventHandler() != null && this.isEditValid()) {
                String strValue = this.getText();
                Object objValue = null;
                IParameterDescriptor pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName());
                if (Long.TYPE.equals(pd.getType()) || Long.class.equals((Object)pd.getType()) || Integer.TYPE.equals(pd.getType()) || Integer.class.equals((Object)pd.getType())) {
                    if (strValue.indexOf(format_prefix) > -1) {
                        strValue = strValue.replaceFirst(format_prefix, "");
                    }
                    long value = AltString.stringToLong((String)strValue, (int)16);
                    if (pd.getName().equals("p_pcie_msix_table_offset") || pd.getName().equals("p_pcie_msix_pba_offset")) {
                        String binaryVal = Long.toBinaryString(value);
                        binaryVal = binaryVal.substring(0, binaryVal.length() - 3);
                        binaryVal = "000" + binaryVal;
                        value = AltString.stringToLong((String)binaryVal, (int)2);
                    }
                    objValue = MWParameterDescriptorHelper.validateValue((IParameterDescriptor)pd, (Object)value);
                    this.getMWEventHandler().setValue(this.getParameterName(), objValue);
                } else {
                    this.getMWEventHandler().setValue(this.getParameterName(), (Object)strValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

