/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.handler.IParameterChangedListener;
import com.altera.megawizard2.handler.MWEventHandler;
import com.altera.megawizard2.utilities.MWParameterDescriptorHelper;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class MWHexField
extends JFormattedTextField
implements MWControl,
FocusListener,
KeyListener,
IParameterChangedListener {
    private String committedValue;
    private String parameterName = null;
    private MWEventHandler mwEventHandler = null;

    public MWHexField(JFormattedTextField.AbstractFormatter format, String parameterName) {
        super(format);
        this.setJComponent(this, 80, 20, 200, 22);
        this.init();
        this.committedValue = "";
        this.addFocusListener(this);
        this.addKeyListener(this);
        if (!parameterName.trim().equalsIgnoreCase("")) {
            this.setParameterName(parameterName);
        }
    }

    public MWHexField() {
        this.setJComponent(this, 80, 20, 200, 22);
        this.committedValue = "";
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public void init() {
    }

    private JFormattedTextField getTextComponent() {
        MWHexField result = this;
        return result;
    }

    public void setControlValue(String newValue) {
        this.setValue(newValue);
    }

    private void commitValue() {
        JFormattedTextField t = this.getTextComponent();
        IParameterDescriptor pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName());
        String validValue = this.getText().trim();
        if (this.getParameterName() != null && this.getMWEventHandler() != null) {
            try {
                long newValue = 0L;
                String textValue = this.getText().substring(2, this.getText().length());
                for (int j = 0; j < textValue.length(); ++j) {
                    int digit = this.hexValue(textValue.charAt(j));
                    if (digit == -1) continue;
                    newValue = 16L * newValue + (long)digit;
                }
                if (newValue == -1L || textValue.trim().equalsIgnoreCase("")) {
                    this.uncommitValue();
                    this.setControlValue(this.committedValue);
                } else if (!this.getText().trim().equals("0x")) {
                    String currentControlValue;
                    if (this.getText().trim().charAt(0) != '0' || this.getText().trim().charAt(1) != 'x' && this.getText().trim().charAt(1) != 'X') {
                        validValue = "0x" + this.getText().toString().trim();
                    }
                    validValue = validValue.replaceAll("\\s", "");
                    this.getMWEventHandler().setValue(this.getParameterName(), MWParameterDescriptorHelper.validateValue((IParameterDescriptor)pd, (Object)validValue));
                    this.committedValue = currentControlValue = t.getText();
                    t.select(0, 9999);
                } else {
                    this.uncommitValue();
                    this.setControlValue(this.committedValue);
                }
            }
            catch (Exception e) {
                this.uncommitValue();
            }
        }
    }

    private void uncommitValue() {
        JFormattedTextField t = this.getTextComponent();
        t.setText(this.committedValue);
        t.select(0, 9999);
    }

    @Override
    public void focusGained(FocusEvent e) {
        JFormattedTextField t = this.getTextComponent();
        t.select(0, 9999);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.getJComponent().isEnabled()) {
            this.commitValue();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (c == '\u001a' || c == '\u001b') {
            this.uncommitValue();
        } else if (c == '\r' || c == '\n') {
            this.commitValue();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        JFormattedTextField textComp = (JFormattedTextField)keyEvent.getSource();
        int keyCode = keyEvent.getKeyCode();
        if (keyCode == 127) {
            try {
                if (textComp.getCaretPosition() > 2 && textComp.getCaretPosition() <= textComp.getText().length()) {
                    int icat = textComp.getCaretPosition();
                    textComp.setCaretPosition(icat - 1);
                }
            }
            catch (Exception e) {
                System.out.println(" exception in delete ");
                e.printStackTrace();
            }
        }
    }

    private int hexValue(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    public void setMWEventHandler(MWEventHandler mwEventHandler) {
        this.mwEventHandler = mwEventHandler;
    }

    public MWEventHandler getMWEventHandler() {
        return this.mwEventHandler;
    }

    public void setParameterName(String parameterName) {
        if (!parameterName.trim().equalsIgnoreCase("")) {
            this.parameterName = parameterName;
        }
    }

    public JComponent getJComponent() {
        return this;
    }

    public void setJComponent(JComponent jComponent, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        Dimension minimumSize = jComponent.getMinimumSize();
        Dimension maximumSize = jComponent.getMaximumSize();
        if (minWidth >= 0) {
            minimumSize.width = minWidth;
        }
        if (maxWidth >= 0) {
            maximumSize.width = maxWidth;
        }
        if (minHeight >= 0) {
            minimumSize.height = minHeight;
        }
        if (maxHeight >= 0) {
            maximumSize.height = maxHeight;
        }
        jComponent.setMinimumSize(minimumSize);
        jComponent.setPreferredSize(minimumSize);
        jComponent.setMaximumSize(maximumSize);
    }

    public Dimension getControlSize() {
        return this.getJComponent().getPreferredSize();
    }

    public void receiveChangeEvent() {
        if (this.getParameterName() != null && this.getMWEventHandler() != null) {
            IParameterDescriptor pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName());
            this.setVisible(pd.isVisible());
            if (this.getMWEventHandler().isModelInError()) {
                this.setEnabled(pd.isRelatedToError());
            } else {
                this.setEnabled(pd.isEnabled());
            }
            this.setControlValue(this.getMWEventHandler().getValue(pd.getName(), pd.getType()).toString());
        }
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setDispalyValue(Object value) {
        this.setControlValue(value.toString());
    }
}

