/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.handler.MWEventHandler;
import com.altera.megawizard2.utilities.MWParameterDescriptorHelper;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public class MWFormattedTextField
extends JFormattedTextField
implements MWControl {
    private MWEventHandler mwEventHandler;
    private String parameterName;

    public MWFormattedTextField(String parameterName, String format) {
        super(MWFormattedTextField.createFormatter(format));
        this.parameterName = parameterName;
        this.setJComponent(this, 80, 20, 200, 22);
    }

    public static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
            formatter.setInvalidCharacters("");
            formatter.setPlaceholderCharacter('0');
            formatter.setValueContainsLiteralCharacters(true);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return formatter;
    }

    public void setJComponent(JComponent jComponent, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        Dimension minimumSize = jComponent.getMinimumSize();
        Dimension maximumSize = jComponent.getMaximumSize();
        if (minWidth >= 0) {
            minimumSize.width = minWidth;
        }
        if (maxWidth >= 0) {
            maximumSize.width = maxWidth;
        }
        if (minHeight >= 0) {
            minimumSize.height = minHeight;
        }
        if (maxHeight >= 0) {
            maximumSize.height = maxHeight;
        }
        jComponent.setMinimumSize(minimumSize);
        jComponent.setPreferredSize(minimumSize);
        jComponent.setMaximumSize(maximumSize);
    }

    public JComponent getJComponent() {
        return this;
    }

    public void setMWEventHandler(MWEventHandler handler) {
        this.mwEventHandler = handler;
    }

    protected MWEventHandler getMWEventHandler() {
        return this.mwEventHandler;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public Dimension getControlSize() {
        return this.getPreferredSize();
    }

    public void receiveChangeEvent() {
        IParameterDescriptor pd;
        if (this.getParameterName() != null && this.getMWEventHandler() != null && (pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName())) != null) {
            Object obj = this.getMWEventHandler().getValue(this.getParameterName(), pd.getType());
            this.setValue(obj.toString());
            this.setVisible(pd.isVisible());
            if (this.getMWEventHandler().isModelInError()) {
                this.setEnabled(pd.isRelatedToError());
            } else {
                this.setEnabled(pd.isEnabled());
            }
        }
    }

    @Override
    public void commitEdit() throws ParseException {
        try {
            super.commitEdit();
            if (this.getParameterName() != null && this.getMWEventHandler() != null) {
                Object newValue = this.getValue();
                IParameterDescriptor pd = this.getMWEventHandler().getParameterDescriptor(this.getParameterName());
                Object objValue = MWParameterDescriptorHelper.validateValue((IParameterDescriptor)pd, (Object)newValue);
                this.getMWEventHandler().setValue(this.getParameterName(), objValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

