/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

class HeaderRenderer
extends DefaultTableCellRenderer {
    private Color fgColor = UIManager.getColor("TableHeader.foreground");
    private Color bgColor = UIManager.getColor("TableHeader.background");
    private Border border = UIManager.getBorder("TableHeader.cellBorder");

    public HeaderRenderer() {
        this.setOpaque(true);
    }

    public void setForegroundColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public Color getForegroundColor() {
        return this.fgColor;
    }

    public void setBackgroundColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        HeaderRenderer label = this;
        label.setText(value == null ? "" : " " + value.toString());
        ((JComponent)label).setForeground(this.getForegroundColor());
        ((JComponent)label).setBackground(this.getBackgroundColor());
        ((JComponent)label).setBorder(this.getBorder());
        JTextField wtextfield = new JTextField();
        int rowHeight = wtextfield.getPreferredSize().height;
        label.setPreferredSize(new Dimension(label.getPreferredSize().width, rowHeight));
        this.setEnabled(table == null || table.isEnabled());
        return label;
    }
}

