/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.ui;

import com.altera.megacore.pcie.model.AddressTranslationTableModel;
import com.altera.megacore.pcie.ui.MWComboMappableDisplay;
import com.altera.megacore.pcie.ui.MWInfoPanel;
import com.altera.megacore.pcie.ui.MWScrollPane;
import com.altera.megacore.pcie.ui.MWTable;
import com.altera.megacore.pcie.ui.MWTextArea;
import com.altera.megacore.pcie.ui.PCIuiConstants;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.MWGUIBaseClass;
import com.altera.megawizard2.MWItem;
import com.altera.megawizard2.view.MWButtonGroup;
import com.altera.megawizard2.view.MWCombo;
import com.altera.megawizard2.view.MWPanel;
import com.altera.megawizard2.view.MWRadioButton;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AvalonConfiguration
extends MWGUIBaseClass
implements ActionListener {
    public static final int PANEL_MARGIN = 5;
    static final int LEFT_COLUMN = 343;
    static final int RIGHT_COLUMN = 343;
    private static ResourceBundle Informations = ResourceBundle.getBundle("com.altera.megacore.pcie.ui.AlteraPCIECompilerProperties");
    private static TableColumn column = null;
    private static Integer[] columnWidth = new Integer[]{130, 140, 90};
    private static MWRadioButton mmLiteRadio = null;
    private static MWItem item = null;

    static MWPanel createAvalonConfigurationPanel() {
        MWPanel panelMain = new MWPanel();
        MWPanel panelAddressTranslationTableConfiguration = AvalonConfiguration.createAddressTranslationTableConfigurationPanel();
        MWPanel panelAddressTranslationTableSize = AvalonConfiguration.createAddressTranslationTableSizePanel();
        MWPanel panelTranslationTableContents = AvalonConfiguration.createTranslationTableContentsPanel();
        panelMain.addNestedPanel(panelAddressTranslationTableConfiguration);
        panelMain.addNestedPanel(panelAddressTranslationTableSize);
        panelMain.beginRowsBlock();
        panelMain.addNestedPanel(panelTranslationTableContents);
        panelMain.addNestedPanel(AvalonConfiguration.createAvalonCRAPortPanel());
        panelMain.endBlock();
        panelMain.finish(5);
        return panelMain;
    }

    static MWPanel createAddressTranslationTableConfigurationPanel() {
        MWPanel topPanel = new MWPanel();
        topPanel.beginRowsBlock();
        topPanel.beginColumnsBlock();
        MWPanel panelPCIClockDomains = new MWPanel("Avalon Clock Domain");
        MWButtonGroup btnGrpPCIClockDomains = new MWButtonGroup("p_pci_single_clock");
        panelPCIClockDomains.addRadioButton(Informations.getString("infoIndependentClockHeader"), "true", btnGrpPCIClockDomains).getJComponent().setName("btnIndependentClock");
        panelPCIClockDomains.addRadioButton(Informations.getString("infoSharedClockHeader"), "false", btnGrpPCIClockDomains).getJComponent().setName("btnSharedClock");
        MWRadioButton radio = new MWRadioButton("", "", btnGrpPCIClockDomains);
        panelPCIClockDomains.addSpacer(0, radio.getPreferredSize().height + radio.getPreferredSize().height / 4);
        panelPCIClockDomains.addSpacer(200, 0);
        panelPCIClockDomains.finish(5);
        topPanel.addNestedPanel(panelPCIClockDomains);
        topPanel.endBlock();
        topPanel.beginColumnsBlock();
        MWPanel panelDevMode = new MWPanel("PCIe Peripheral Mode");
        MWButtonGroup btnGrpDevMode = new MWButtonGroup("uiPCIDeviceMode");
        panelDevMode.addRadioButton("Requester/Completer", "masterTarget", btnGrpDevMode).getJComponent().setName("masterTarget");
        panelDevMode.addRadioButton("Completer-Only", "targetOnly", btnGrpDevMode).getJComponent().setName("targetOnly");
        panelDevMode.addRadioButton("Completer-Only single dword", "mmLite", btnGrpDevMode).getJComponent().setName("mmLite");
        panelDevMode.addSpacer(200, 0);
        panelDevMode.finish(5);
        topPanel.addNestedPanel(panelDevMode);
        topPanel.endBlock();
        topPanel.beginColumnsBlock();
        MWPanel panelAddressTranslationTableConfiguration = new MWPanel("Address Translation Table Configuration");
        MWButtonGroup btnGrpAddressTranslationTableConfiguration = new MWButtonGroup("uiFixedTable");
        panelAddressTranslationTableConfiguration.addRadioButton("Dynamic translation table", "false", btnGrpAddressTranslationTableConfiguration).getJComponent().setName("Dynamic translation");
        panelAddressTranslationTableConfiguration.addRadioButton("Fixed translation table", "true", btnGrpAddressTranslationTableConfiguration).getJComponent().setName("Fixed translation");
        radio = new MWRadioButton("", "", btnGrpPCIClockDomains);
        panelAddressTranslationTableConfiguration.addSpacer(0, radio.getPreferredSize().height + radio.getPreferredSize().height / 4);
        panelAddressTranslationTableConfiguration.addSpacer(233, 0);
        panelAddressTranslationTableConfiguration.finish(5);
        topPanel.addNestedPanel(panelAddressTranslationTableConfiguration);
        topPanel.endBlock();
        topPanel.endBlock();
        topPanel.finish();
        return topPanel;
    }

    static MWPanel createAddressTranslationTableSizePanel() {
        MWPanel panelAddressTranslationTableSize = new MWPanel("Address Translation Table Size");
        panelAddressTranslationTableSize.beginRowsBlock();
        panelAddressTranslationTableSize.beginColumnsBlock();
        panelAddressTranslationTableSize.addText("Number of address pages:").setSizeRange(170, -1, 170, -1);
        panelAddressTranslationTableSize.addSpacer(170, 3);
        panelAddressTranslationTableSize.addText("Size of address pages:").setSizeRange(170, -1, 170, -1);
        panelAddressTranslationTableSize.endBlock();
        MWCombo comboNumberOfAddressPages = new MWCombo("uiPaneCount");
        comboNumberOfAddressPages.getJComponent().setName("uiPaneCount");
        MWComboMappableDisplay comboSizeOfAddressPages = new MWComboMappableDisplay("uiPaneSize", PCIuiConstants.mapAddressPageSizeDisplayString);
        comboSizeOfAddressPages.getJComponent().setName("uiPaneSize");
        panelAddressTranslationTableSize.beginColumnsBlock();
        panelAddressTranslationTableSize.add((MWControl)comboNumberOfAddressPages).setSizeRange(140, -1, 140, -1);
        panelAddressTranslationTableSize.addSpacer(170, 3);
        panelAddressTranslationTableSize.add((MWControl)comboSizeOfAddressPages).setSizeRange(140, -1, 140, -1);
        panelAddressTranslationTableSize.endBlock();
        MWTextArea textTranslationTableSizeInfo = new MWTextArea("translationTableSizeInfo", true);
        textTranslationTableSizeInfo.setJComponent(textTranslationTableSizeInfo.getJComponent(), 343, 60, 343, 60);
        panelAddressTranslationTableSize.beginColumnsBlock();
        panelAddressTranslationTableSize.add((MWControl)textTranslationTableSizeInfo);
        panelAddressTranslationTableSize.endBlock();
        panelAddressTranslationTableSize.endBlock();
        panelAddressTranslationTableSize.finish(5);
        return panelAddressTranslationTableSize;
    }

    static MWPanel createTranslationTableContentsPanel() {
        MWPanel panelTranslationTableContents = new MWPanel("Fixed Address Translation Table Contents");
        panelTranslationTableContents.beginColumnsBlock();
        MWTable tableTranslationTableContents = new MWTable((TableModel)new AddressTranslationTableModel(), "uiAvalonTranslationTable");
        tableTranslationTableContents.getJComponent().setName("uiAvalonTranslationTable");
        for (int i = 0; i < columnWidth.length; ++i) {
            column = tableTranslationTableContents.getColumnModel().getColumn(i);
            column.setPreferredWidth(columnWidth[i]);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            if (i == 0) {
                renderer.setBackground(UIManager.getColor("TableHeader.background"));
                renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                renderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            renderer.setHorizontalAlignment(0);
            column.setCellRenderer(renderer);
        }
        int tableWidth = 382;
        int tableHeight = tableTranslationTableContents.getRowHeight() * 4 + tableTranslationTableContents.getTableHeader().getPreferredSize().height + 3;
        MWScrollPane scrollPane = new MWScrollPane(tableTranslationTableContents, "uiAvalonTranslationTable");
        item = panelTranslationTableContents.add((MWControl)scrollPane).setSizeRange(tableWidth, tableHeight, tableWidth, tableHeight);
        panelTranslationTableContents.endBlock();
        panelTranslationTableContents.finish(5);
        return panelTranslationTableContents;
    }

    static MWPanel createAvalonCRAPortPanel() {
        MWPanel panelAvalonCRAPort = new MWPanel("Avalon CRA Port");
        item = panelAvalonCRAPort.addCheckBox("Control Register Access (CRA) Avalon slave port", "p_pci_impl_cra_av_slave_port");
        item.getJControl().setName("p_pci_impl_cra_av_slave_port");
        MWInfoPanel panelInfoCRA = new MWInfoPanel(new MWButtonGroup("uiCRAInfoPanel"), false);
        panelInfoCRA.addInfo("other", Informations.getString("infoCRAContent"));
        panelInfoCRA.addInfo("hostBridge", Informations.getString("infoCRAHostBridgeContent"));
        panelInfoCRA.addInfo("dynamicTable", Informations.getString("infoCRADynamicTableContent"));
        panelInfoCRA.getTextControl().getJComponent().setMinimumSize(new Dimension(282, 65));
        panelInfoCRA.getTextControl().getJComponent().setMaximumSize(new Dimension(282, 65));
        panelInfoCRA.finish(0);
        panelAvalonCRAPort.add((MWControl)panelInfoCRA);
        panelAvalonCRAPort.finish(5);
        return panelAvalonCRAPort;
    }

    public static void main(String[] args) {
        JFrame myframe = new JFrame("MegaWizard2");
        MWPanel panel = AvalonConfiguration.createAvalonConfigurationPanel();
        myframe.setContentPane(panel.getJPanel());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((d.getWidth() - (double)myframe.getWidth()) / 4.0);
        int y = (int)((d.getHeight() - (double)myframe.getHeight()) / 4.0);
        myframe.setLocation(x, y);
        myframe.pack();
        myframe.setVisible(true);
        myframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                System.exit(0);
            }
        });
    }
}

