/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.serializer;

import altera.ipbu.launcher.IPToolbench;
import altera.ipbu.launcher.IPToolbenchController;
import altera.ipbu.launcher.IPToolbenchGenerationMsg;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IModuleGenerateHDL;
import com.altera.entityinterfaces.moduleext.IQuartusSynthLink;
import com.altera.megacore.pcie.AlteraPCIECompiler;
import com.altera.megawizard2.extensions.IMegawizardGenerateQmegawizFiles;
import com.altera.sopcmodel.extensions.IModuleGenerateFromIPTB2;
import com.altera.sopcmodel.util.IModuleGenerateFromIPTB;
import com.altera.sopcmodel.util.ISetQuartusProjectInfo;
import com.altera.sopcmodel.util.Message;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleGenerateHDL
implements IModuleGenerateHDL,
IModuleGenerateFromIPTB2,
ISetQuartusProjectInfo {
    IModule m_module;
    private int iIPTBExitCode = 0;
    private static final int IPTB_GENERATION_PASS_EXITCODE = 4;
    private IModuleGenerateHDL.HDLLanguage language;
    private File reportDir;
    private File outputDir;
    private boolean genSimulationModel = false;
    private IModuleGenerateHDL.HDLLanguage simulationLanguage = null;
    private File fQuartusRootDir = null;
    private String projectName = null;
    private File projectPath = null;
    private File project;
    private Collection<IModuleGenerateFromIPTB.EIPTBFileType> selectedFiles;
    private boolean genGreybox = false;
    private static final String DEFAULT_IPTB_VER = "v1.3.0";

    public ModuleGenerateHDL(IModule m_module) {
        this.m_module = m_module;
    }

    protected IModule getIModule() {
        return this.m_module;
    }

    public void setGenerationLanguage(IModuleGenerateHDL.HDLLanguage language) {
        this.language = language;
    }

    public IModuleGenerateHDL.HDLLanguage getGenerationLanguage() {
        return this.language;
    }

    public void setDestinationPaths(File reportDir, File outputDir) {
        this.reportDir = reportDir;
        this.outputDir = outputDir;
    }

    private String getHDLExtension() {
        switch (this.language) {
            case VERILOG: {
                return ".v";
            }
            case VHDL: {
                return ".vhd";
            }
        }
        return null;
    }

    public void generateHDL(String outputName, IMessageLogger logger, IQuartusSynthLink reporter) {
        String iptbArgs;
        Message info = Message.create((EMessageID)EMessageID.GenerationRelated);
        info.setLevel(EMessageLevel.Info);
        info.setProblemDescription(this.m_module.getName() + ": generating HDL...");
        logger.receiveMessage((IMessage)info);
        this.m_module.setValue("p_pcie_variation_name", (Object)(outputName + "_core"));
        String[] iptbArgArray = new String[]{};
        LinkedList<String> lArgs = new LinkedList<String>();
        Collection paramDescs = this.m_module.getParameterDescriptors();
        for (IParameterDescriptor mypd : paramDescs) {
            if (this.m_module.getValueString(mypd.getName()) == null || "".equals(this.m_module.getValueString(mypd.getName())) || "p_pcie_altgx_keyParameters_used".equals(this.m_module.getValueString(mypd.getName()))) continue;
            lArgs.add("-parameterization." + mypd.getName() + ":" + this.m_module.getValueString(mypd.getName()));
        }
        String debugLevel = ModuleGenerateHDL.ReadlstFile(new File(this.getCoreInstallationPath(true), "/ip_compiler_for_pci_express_wizard.lst"), "debug");
        if (!debugLevel.equalsIgnoreCase("0")) {
            lArgs.add("-debug:" + debugLevel.trim());
        }
        if (this.m_module.hasExtension(IMegawizardGenerateQmegawizFiles.class)) {
            boolean newVariant = false;
            String outputDirectory = null;
            Object var11_14 = null;
            outputDirectory = this.outputDir.getAbsolutePath();
            String string = this.language.toString();
            IMegawizardGenerateQmegawizFiles qmegawizFilesExtension = (IMegawizardGenerateQmegawizFiles)this.m_module.getExtension(IMegawizardGenerateQmegawizFiles.class);
            if (qmegawizFilesExtension != null) {
                qmegawizFilesExtension.executeCommand(qmegawizFilesExtension.getCommandtoRun() + "-silent ", qmegawizFilesExtension.getIPSerdesFile(), new File(outputDirectory), string, logger, qmegawizFilesExtension.getKeyParameters(), newVariant, debugLevel.trim().equalsIgnoreCase("1") || debugLevel.trim().equalsIgnoreCase("2") || debugLevel.trim().equalsIgnoreCase("3"), null);
                lArgs.add("-parameterization.altgx_generated:1");
                lArgs.add("-parameterization.p_pcie_altgx_keyParameters_used:" + qmegawizFilesExtension.getKeyParameters());
            }
        }
        if ((iptbArgs = "-iptb_generator 1") != null) {
            iptbArgArray = iptbArgs.split(";");
        }
        boolean arg = false;
        for (String iptbArg : iptbArgArray) {
            lArgs.add(iptbArg);
        }
        String string = "ip_compiler_for_pci_express";
        String iptbdir = this.getCoreInstallationPath(false);
        String iptbVer = this.getIPTBVersion();
        StringBuffer projectFolder = new StringBuffer(this.outputDir + File.separator + outputName);
        if (!outputName.endsWith(".v") && !outputName.endsWith(".vhd")) {
            projectFolder.append(this.getHDLExtension());
        }
        lArgs.add("-simgen_enable.language:" + this.getSimulationLanguage());
        lArgs.add("-simgen_enable.enabled:" + (this.isGenSimulationModel() ? "1" : "0"));
        lArgs.add("-greybox.gb_enabled:" + (this.genGreybox ? "1" : "0"));
        lArgs.add("-testbench.plugin_worker:1");
        if (this.fQuartusRootDir != null) {
            lArgs.add("-quartus_rootdir:" + this.fQuartusRootDir);
        }
        lArgs.add("-lib_dir:" + this.getCoreLibDir());
        lArgs.add("-flow_dir:" + iptbdir + File.separator + "common" + File.separator + "ip_toolbench" + File.separator + iptbVer + File.separator + "bin");
        if (this.projectName != null) {
            lArgs.add("-projectname:" + this.projectName);
        }
        lArgs.add("-wizard:" + string);
        String simpleDMAEnabled = ModuleGenerateHDL.ReadlstFile(new File(this.getCoreInstallationPath(true), "/ip_compiler_for_pci_express_wizard.lst"), "parameterization.p_pcie_enable_simple_dma");
        if (simpleDMAEnabled != null) {
            lArgs.add("-parameterization.p_pcie_enable_simple_dma:" + simpleDMAEnabled.trim());
        }
        lArgs.add("-silent");
        this.appendProjectDirectory(lArgs);
        lArgs.add(projectFolder.toString());
        if (this.project != null) {
            lArgs.add("-projectpath:" + this.project.getAbsolutePath().substring(0, this.project.getAbsolutePath().lastIndexOf(File.separator)));
            lArgs.add("-projectname:" + this.project.getAbsolutePath().substring(this.project.getAbsolutePath().lastIndexOf(File.separator) + 1, this.project.getAbsolutePath().length()));
        }
        lArgs.add("-limitfiles");
        if (this.selectedFiles != null) {
            for (IModuleGenerateFromIPTB.EIPTBFileType file : this.selectedFiles) {
                if (file.equals((Object)IModuleGenerateFromIPTB.EIPTBFileType.BLACKBOX)) {
                    lArgs.add("-blackbox");
                    continue;
                }
                if (file.equals((Object)IModuleGenerateFromIPTB.EIPTBFileType.REPORT)) {
                    lArgs.add("-report");
                    continue;
                }
                if (file.equals((Object)IModuleGenerateFromIPTB.EIPTBFileType.SYMBOL)) {
                    lArgs.add("-symbol");
                    continue;
                }
                if (!file.equals((Object)IModuleGenerateFromIPTB.EIPTBFileType.COMPONENT)) continue;
                lArgs.add("-component");
            }
        }
        lArgs.add("-devicefamily:" + ((AlteraPCIECompiler)this.m_module).getDeviceFamily().getDisplayName());
        lArgs.add("-alterppf:0");
        for (String arg1 : lArgs) {
        }
        try {
            String[] args = lArgs.toArray(new String[1]);
            WaitingThread waitingThread = new WaitingThread(args, logger);
            waitingThread.start();
            waitingThread.join();
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        Message infoAfterGeneration = Message.create((EMessageID)EMessageID.GenerationRelated);
        infoAfterGeneration.setLevel(EMessageLevel.Info);
        if (this.iIPTBExitCode == 4) {
            infoAfterGeneration.setProblemDescription(this.m_module.getName() + ": HDL generated");
            logger.receiveMessage((IMessage)infoAfterGeneration);
        } else {
            infoAfterGeneration.setLevel(EMessageLevel.Error);
            infoAfterGeneration.setProblemDescription(this.m_module.getName() + ": HDL generation failed");
            logger.receiveMessage((IMessage)infoAfterGeneration);
        }
    }

    public static String ReadlstFile(File lstFile, String privateName) {
        LineNumberReader lineReader = null;
        try {
            lineReader = new LineNumberReader(new FileReader(lstFile));
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                if (!line.contains("-" + privateName)) continue;
                return line.substring(line.indexOf(privateName) + privateName.length() + 1, line.indexOf(privateName) + privateName.length() + line.indexOf(" "));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    private void appendProjectDirectory(List<String> lArgs) {
        if (this.projectPath != null) {
            try {
                String strProjectPath = this.projectPath.getCanonicalPath();
                lArgs.add("-projectpath:" + strProjectPath.replace("\\", "/"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getCoreInstallationPath(boolean isLibPath) {
        String strMyLocation = null;
        try {
            strMyLocation = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        strMyLocation = strMyLocation.replace("file:", "");
        if (strMyLocation.indexOf(".jar") > 0) {
            File myLocation = new File(strMyLocation);
            if (!myLocation.exists()) {
                return null;
            }
            File fCoreLibIPToolBench = new File(myLocation.getParent());
            File fCoreLib = new File(fCoreLibIPToolBench.getParent());
            File fCore = new File(fCoreLib.getParent());
            if (isLibPath) {
                return fCoreLib.getPath();
            }
            return fCore.getParent();
        }
        String megacoreRoot = null;
        String os = System.getProperty("os.name").toLowerCase();
        megacoreRoot = os.startsWith("linux") || os.startsWith("sunos") ? "/tools/altera/8.1/current.quartus.linux/linux32/ip/altera" : "c:/altera/81/ip/altera";
        return megacoreRoot;
    }

    protected String getIPTBVersion() {
        URL iptbURL = this.getClass().getClassLoader().getResource("altera/ipbu/launcher/IPToolbench.class");
        if (iptbURL == null) {
            return DEFAULT_IPTB_VER;
        }
        String strIPTBLocation = iptbURL.getFile();
        strIPTBLocation = strIPTBLocation.replace("jar:file:/", "");
        Pattern pattern = Pattern.compile(".*common[\\\\\\/]ip_toolbench[\\\\\\/](v[\\d\\.]*)[\\\\\\/].*");
        Matcher matcher = pattern.matcher(strIPTBLocation);
        if (matcher.matches()) {
            String iptbVersion = matcher.group(1);
            return iptbVersion;
        }
        return DEFAULT_IPTB_VER;
    }

    public static void main(String[] args) {
        String coreInstallationPath = new ModuleGenerateHDL(null).getCoreInstallationPath(false);
        System.out.println(coreInstallationPath);
        String iptbVersion = new ModuleGenerateHDL(null).getIPTBVersion();
        System.out.println(iptbVersion);
    }

    public void setQuartusProject(File project) {
        this.project = project;
    }

    public void setQuartusRootdir(File rootDir) {
        this.fQuartusRootDir = rootDir;
    }

    public void setFilesToGenerate(Collection<IModuleGenerateFromIPTB.EIPTBFileType> selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public boolean cancelGeneration() {
        IMegawizardGenerateQmegawizFiles qmegawizFilesExtension;
        if (this.m_module.hasExtension(IMegawizardGenerateQmegawizFiles.class) && (qmegawizFilesExtension = (IMegawizardGenerateQmegawizFiles)this.m_module.getExtension(IMegawizardGenerateQmegawizFiles.class)) != null) {
            qmegawizFilesExtension.PerformCleanUp(true);
        }
        return true;
    }

    public void setSimulationOutput(boolean genModel, IModuleGenerateHDL.HDLLanguage language) {
        this.genSimulationModel = genModel;
        this.simulationLanguage = language;
    }

    protected boolean isGenSimulationModel() {
        return this.genSimulationModel;
    }

    protected IModuleGenerateHDL.HDLLanguage getSimulationLanguage() {
        if (this.simulationLanguage == null) {
            return this.language;
        }
        return this.simulationLanguage;
    }

    public void setProjectName(String name) {
        this.projectName = name;
    }

    public void setProjectDirectory(File projectPath) {
        this.projectPath = projectPath;
    }

    public void setQuartusRootDir(File directory) {
        this.fQuartusRootDir = directory;
    }

    public File getQuartusRootDir() {
        return this.fQuartusRootDir;
    }

    public void enableGreybox(boolean genGreybox) {
        this.genGreybox = genGreybox;
    }

    protected String getCoreLibDir() {
        String strMyLocation = null;
        try {
            strMyLocation = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        strMyLocation = strMyLocation.replace("file:", "");
        if (strMyLocation.indexOf(".jar") > 0) {
            File myLocation = new File(strMyLocation);
            if (!myLocation.exists()) {
                return null;
            }
            File fCoreLibIPToolBench = new File(myLocation.getParent());
            return fCoreLibIPToolBench.getParent();
        }
        String megacoreRoot = null;
        String os = System.getProperty("os.name").toLowerCase();
        megacoreRoot = os.startsWith("linux") || os.startsWith("sunos") ? "/tools/altera/8.1/current.quartus.linux/linux32/ip/altera/ip_compiler_for_pci_express/lib" : "c:/altera/81/ip/altera/ip_compiler_for_pci_express/lib";
        return megacoreRoot;
    }

    class WaitingThread
    extends Thread
    implements IPToolbenchController,
    IPToolbenchGenerationMsg {
        String[] args;
        IPToolbench iptb;
        private IMessageLogger logger;

        public WaitingThread(String[] args, IMessageLogger logger) {
            this.args = args;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate(int exitCode) {
            try {
                ModuleGenerateHDL.this.iIPTBExitCode = exitCode;
                WaitingThread waitingThread = this;
                synchronized (waitingThread) {
                    this.notifyAll();
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.iptb = IPToolbench.iptb_service_main((String[])this.args, (Object)this);
                this.iptb.runService("generate");
                try {
                    WaitingThread waitingThread = this;
                    synchronized (waitingThread) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }

        public void receiveGenerateTimeMessages(String arg0) {
            Message info = Message.create((EMessageID)EMessageID.GenerationRelated);
            info.setLevel(EMessageLevel.Info);
            info.setProblemDescription(ModuleGenerateHDL.this.m_module.getName() + ": " + arg0);
            this.logger.receiveMessage((IMessage)info);
        }
    }
}

