/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.serializer;

import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.IPort;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.sopcmodel.ptf.IElementGeneratePTF;
import com.altera.utilities.altNode.AltNode;
import java.util.List;

public class ElementGenerateSimulationPTF
implements IElementGeneratePTF {
    private IModule m_model;

    public ElementGenerateSimulationPTF(IModule theModule) {
        this.m_model = theModule;
    }

    public AltNode generatePTF(IMessageLogger receiver) {
        AltNode child = this.plugin_start();
        return child;
    }

    private void addChildModuleName(AltNode rootNode) {
        AltNode child = this.plugin_start();
        rootNode.addChild(child);
    }

    private AltNode createSimulationRootNode(IMessageLogger receiver) {
        return new AltNode("SIMULATION");
    }

    private IModule getModule() {
        return this.m_model;
    }

    private AltNode plugin_start() {
        String instanceName = this.getModule().getName();
        boolean pciSingleClock = (Boolean)this.m_model.getValue("p_pci_single_clock", Boolean.TYPE);
        String sClock = this.m_model.getValueString("clockSource");
        AltNode simNode = new AltNode("SIMULATION");
        AltNode.Builder b = new AltNode.Builder(simNode);
        b.addChild(new AltNode("Module_Name", this.getModule().getName() + "_testbench", 1));
        b.beginSection("PORT_WIRING");
        b.addChild(new AltNode("preserve", "1", 1));
        IConnectionPoint wireConnectionPoint = null;
        List connectionPoints = this.m_model.getConnectionPoints();
        for (IConnectionPoint icpt : connectionPoints) {
            if (!icpt.getName().equalsIgnoreCase("exported_connection")) continue;
            wireConnectionPoint = icpt;
            break;
        }
        if (wireConnectionPoint != null) {
            List ports = wireConnectionPoint.getPorts();
            for (IPort port : ports) {
                IPort.Direction direction = null;
                direction = port.getDirection().equals((Object)IPort.Direction.Input) ? IPort.Direction.Output : (port.getDirection().equals((Object)IPort.Direction.Output) ? IPort.Direction.Input : IPort.Direction.Bidir);
                b.beginSection("PORT", port.getName());
                b.addChild(new AltNode("direction", direction.toString().toLowerCase(), 1));
                b.addChild(new AltNode("width", Integer.toString(port.getWidth()), 1));
                b.addChild(new AltNode("__exclusive_name", port.getName() + "_" + instanceName, 1));
                b.addChild(new AltNode("Is_Enabled", "1", 1));
                b.endSection();
            }
        }
        b.endSection();
        return b.getCurrentNode();
    }
}

