/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.serializer;

import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.connections.ports.PCIEPorts;
import com.altera.sopcmodel.internal.util.Misc;
import com.altera.sopcmodel.ptf.IElementGeneratePTF;
import com.altera.sopcmodel.util.Message;
import com.altera.utilities.altNode.AltNode;
import java.util.List;

public class ElementGeneratePortsPTF
implements IElementGeneratePTF {
    private IModule theModule;
    private String instanceName;
    private final String avlClkName;
    private final String reset_n;
    private final String pcie_core_clk = "pcie_core_clk";

    public ElementGeneratePortsPTF(IModule theModule) {
        this.avlClkName = PCIEPorts.create(PCIEPorts.PCIAvalonClock.class).AvlClk_i.getName();
        this.reset_n = PCIEPorts.create(PCIEPorts.PCI64BitCommonPorts.class).reset_n.getName();
        this.pcie_core_clk = "pcie_core_clk";
        this.theModule = theModule;
        this.instanceName = theModule.getName();
    }

    public AltNode generatePTF(IMessageLogger receiver) {
        AltNode portNode = new AltNode("MODULE");
        String exclusiveName = null;
        Object childIndex = null;
        List points = this.theModule.getConnectionPoints();
        for (IConnectionPoint p : points) {
            if (!p.hasExtension(IElementGeneratePTF.class)) continue;
            IElementGeneratePTF gptf = (IElementGeneratePTF)p.getExtension(IElementGeneratePTF.class);
            AltNode connectionPointA = gptf.generatePTF(receiver);
            AltNode portWiring = connectionPointA.getChild("PORT_WIRING");
            if (portWiring == null) {
                if (connectionPointA.getChildCount() > 0) {
                    AltNode firstChild = connectionPointA.getChild(0);
                    String key = firstChild.getKey();
                    if ("MODULE".equalsIgnoreCase(key)) {
                        connectionPointA = connectionPointA.getChild("MODULE");
                        portWiring = firstChild.getChild("PORT_WIRING");
                        if (portWiring == null) {
                            if (firstChild.getChildCount() > 0) {
                                firstChild = firstChild.getChild(0);
                                key = firstChild.getKey();
                            } else {
                                Message errorModule = Message.create((EMessageID)EMessageID.Other);
                                errorModule.setObject((Object)this.theModule);
                                errorModule.setLevel(EMessageLevel.Error);
                                errorModule.setProblemDescription("Cannot find PORT WIRING for " + p.getName());
                                receiver.receiveMessage((IMessage)errorModule);
                                continue;
                            }
                        }
                    }
                    if (("MASTER".equalsIgnoreCase(key) || "SLAVE".equalsIgnoreCase(key)) && (portWiring = firstChild.getChild("PORT_WIRING")) == null) {
                        Message errorMasterSlave = Message.create((EMessageID)EMessageID.Other);
                        errorMasterSlave.setObject((Object)this.theModule);
                        errorMasterSlave.setLevel(EMessageLevel.Error);
                        errorMasterSlave.setProblemDescription("Cannot find PORT WIRING for " + p.getName());
                        receiver.receiveMessage((IMessage)errorMasterSlave);
                        continue;
                    }
                    if ("Control_Register_Access".equals(firstChild.getValue())) {
                        firstChild.setValue("SYSTEM_BUILDER_INFO/Accepts_Internal_Connections", true);
                    }
                } else {
                    Message error = Message.create((EMessageID)EMessageID.Other);
                    error.setObject((Object)this.theModule);
                    error.setLevel(EMessageLevel.Error);
                    error.setProblemDescription("Cannot find PORT WIRING");
                    receiver.receiveMessage((IMessage)error);
                    continue;
                }
            }
            AltNode[] ports = portWiring.getChildren(new String[]{"PORT"});
            if (p.getName().equalsIgnoreCase("exported_connection")) {
                for (AltNode port : ports) {
                    String portName = port.getValue();
                    exclusiveName = portName + "_" + this.instanceName;
                    port.setValue("_exclusive_name", exclusiveName);
                }
            }
            Misc.mergeAltNodeOntoAltNode((AltNode)portNode, (AltNode)connectionPointA);
        }
        return portNode;
    }
}

