/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.serializer;

import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.serializer.ElementGenerateHDLInfoPTF;
import com.altera.megacore.pcie.serializer.ElementGeneratePortsPTF;
import com.altera.megacore.pcie.serializer.ElementGenerateSimulationPTF;
import com.altera.sopcmodel.ptf.IElementGeneratePTF;
import com.altera.utilities.altNode.AltNode;

public class ElementGeneratePTF
implements IElementGeneratePTF {
    private IModule theModule;

    public ElementGeneratePTF(IModule theModule) {
        this.theModule = theModule;
    }

    public AltNode generatePTF(IMessageLogger receiver) {
        AltNode moduleNode = new AltNode("MODULE " + this.theModule.getName());
        moduleNode.setValue("SYSTEM_BUILDER_INFO.Do_Not_Generate", true);
        moduleNode.setValue("SYSTEM_BUILDER_INFO.Instantiate_In_System_Module", true);
        AltNode portsNode = this.generatePortsNode(receiver);
        for (int index = 0; index < portsNode.getChildCount(); ++index) {
            AltNode childNode = portsNode.getChild(index);
            moduleNode.addChild(childNode);
        }
        AltNode simulationNode = this.generateSimulationNode(receiver);
        moduleNode.addChild(simulationNode);
        AltNode hdlInfoNode = this.generateHDLInfoNode(receiver);
        moduleNode.addChild(hdlInfoNode);
        return moduleNode;
    }

    private AltNode generatePortsNode(IMessageLogger receiver) {
        ElementGeneratePortsPTF portsPTF = new ElementGeneratePortsPTF(this.theModule);
        return portsPTF.generatePTF(receiver);
    }

    private AltNode generateSimulationNode(IMessageLogger receiver) {
        ElementGenerateSimulationPTF simulationPTF = new ElementGenerateSimulationPTF(this.theModule);
        return simulationPTF.generatePTF(receiver);
    }

    private AltNode generateHDLInfoNode(IMessageLogger receiver) {
        ElementGenerateHDLInfoPTF simulationPTF = new ElementGenerateHDLInfoPTF(this.theModule);
        return simulationPTF.generatePTF(receiver);
    }
}

