/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.serializer;

import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IModuleGenerateHDL;
import com.altera.megacore.pcie.serializer.ModuleGenerateHDL;
import com.altera.megacore.pcie.utilities.RunQuartusCommandHelperUtils;
import com.altera.sopcmodel.ptf.IElementGeneratePTF;
import com.altera.sopcmodel.util.MessageLogger;
import com.altera.utilities.altNode.AltNode;
import java.io.File;

public class ElementGenerateHDLInfoPTF
implements IElementGeneratePTF {
    private IModule m_model;
    private File quartusRoot = null;
    private String quartusEdition = null;

    public ElementGenerateHDLInfoPTF(IModule theModule) {
        this.m_model = theModule;
    }

    public AltNode generatePTF(IMessageLogger receiver) {
        AltNode child = this.plugin_start();
        return child;
    }

    private IModule getModule() {
        return this.m_model;
    }

    private AltNode plugin_start() {
        boolean pciMaster = (Boolean)this.m_model.getValue("p_pci_master", Boolean.TYPE);
        boolean StratixIIGXorArriaGX = ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("Stratix II GX") || ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("Arria GX");
        boolean StratixIVGXorArriaIIGX = ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("Stratix IV GX") || ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("Arria II GX") || ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("Cyclone IV GX") || ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("Arria II GZ") || ((String)this.m_model.getValue("p_pcie_phy", String.class)).equalsIgnoreCase("HardCopy IV GX");
        boolean Gen1Speed = ((String)this.m_model.getValue("p_pcie_rate", String.class)).equalsIgnoreCase("Gen1 (2.5 Gbps)");
        IModuleGenerateHDL.HDLLanguage sLang = IModuleGenerateHDL.HDLLanguage.VERILOG;
        try {
            IModuleGenerateHDL hdlgenerator = (IModuleGenerateHDL)this.m_model.getExtension(IModuleGenerateHDL.class);
            if (hdlgenerator instanceof ModuleGenerateHDL) {
                ModuleGenerateHDL pciHdlGenerator = (ModuleGenerateHDL)hdlgenerator;
                sLang = pciHdlGenerator.getGenerationLanguage();
                this.quartusRoot = pciHdlGenerator.getQuartusRootDir();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AltNode simNode = new AltNode("HDL_INFO");
        AltNode.Builder b = new AltNode.Builder(simNode);
        if (IModuleGenerateHDL.HDLLanguage.VERILOG.equals((Object)sLang)) {
            b.addChild(new AltNode("ModelSim_Inc_Path", "../" + this.getModule().getName() + "_examples/common/testbench ", 1));
            b.addChild(new AltNode("Synthesis_Only_Files", "__PROJECT__DIRECTORY__/" + this.getModule().getName() + ".v", 1));
            b.addChild(new AltNode("Simulation_HDL_Files", "" + this.getModule().getName() + "_core.vo," + this.getModule().getName() + ".v," + (StratixIIGXorArriaGX ? this.getModule().getName() + "_serdes.vo," : "") + (StratixIVGXorArriaIIGX ? this.getModule().getName() + "_serdes.v," : "") + this.getModule().getName() + "_examples/sopc/testbench/altpcietb_bfm_driver.v," + this.getModule().getName() + "_examples/sopc/testbench/" + this.getModule().getName() + "_testbench.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_rs_serdes.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_phasefifo.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_125_250.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_100_125.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_100_250.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy0.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy1_62p5.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy2.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy3_62p5.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy4_62p5.v," + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy5_62p5.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_log_common.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_req_intf_common.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_rp_top_x8_pipen1b.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_rpvar_64b_x8_gen" + (Gen1Speed ? "1" : "2") + "_pipen1b.vo," + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_shmem_common.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_vc_intf.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_pipe_phy.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_rst_clk.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_ltssm_mon.v," + this.getModule().getName() + "_examples/common/testbench/altpcietb_pipe_xtx2yrx.v," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixgx_mf.v," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiigx_hssi_atoms.v," + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_hssi_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_pcie_hip_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_pcie_hip_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_hssi_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_pcie_hip_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_hssi_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_pcie_hip_atoms.v," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_hssi_atoms.v" : ""), 1));
        } else {
            b.addChild(new AltNode("Synthesis_Only_Files", "__PROJECT__DIRECTORY__/" + this.getModule().getName() + ".vhd", 1));
            b.addChild(new AltNode("Simulation_HDL_Files", this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixgx_mf.vhd," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixgx_mf_components.vhd," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiigx_hssi_components.vhd," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiigx_hssi_atoms.vhd," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/altera_primitives_components.vhd," + this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/altera_primitives.vhd," + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_hssi_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_hssi_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_pcie_hip_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/stratixiv_pcie_hip_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_hssi_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_hssi_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_pcie_hip_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/cycloneiv_pcie_hip_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_hssi_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_hssi_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_pcie_hip_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/hardcopyiv_pcie_hip_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_hssi_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_hssi_atoms.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_pcie_hip_components.vhd," : "") + (this.isQuartusFullEdition() ? this.quartusRoot.getPath().replace("\\", "/") + "/eda/sim_lib/arriaii_pcie_hip_atoms.vhd," : "") + "../" + this.getModule().getName() + "_core.vho," + "../" + this.getModule().getName() + ".vhd," + (StratixIIGXorArriaGX ? "../" + this.getModule().getName() + "_serdes.vho," : "") + (StratixIVGXorArriaIIGX ? "../" + this.getModule().getName() + "_serdes.vhd," : "") + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_rs_serdes.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_phasefifo.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_125_250.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_100_125.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_100_250.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy0.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy1_62p5.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy2.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy3_62p5.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy4_62p5.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcie_pll_phy5_62p5.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_constants.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_log.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_common.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_shmem.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_req_intf.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_rdwr.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_configure.vhd," + "../" + this.getModule().getName() + "_examples/sopc/testbench/altpcietb_bfm_driver.vhd," + "../" + this.getModule().getName() + "_examples/sopc/testbench/" + this.getModule().getName() + "_testbench.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_vc_intf.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_rp_top_x8_pipen1b.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_bfm_rpvar_64b_x8_gen" + (Gen1Speed ? "1" : "2") + "_pipen1b.vho," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_pipe_xtx2yrx.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_pipe_phy.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_rst_clk.vhd," + "../" + this.getModule().getName() + "_examples/common/testbench/altpcietb_ltssm_mon.vhd", 1));
        }
        return b.getCurrentNode();
    }

    private boolean isQuartusFullEdition() {
        if (this.quartusEdition != null) {
            return this.quartusEdition.equalsIgnoreCase("Full Version");
        }
        String[] qcmdArray = new String[]{"quartus_sh", "--tcl_eval", "get_quartus_legal_string", "-edition"};
        String cmd = "";
        for (int kk = 0; kk < qcmdArray.length; ++kk) {
            cmd = cmd + qcmdArray[kk];
        }
        MessageLogger messagelogger = MessageLogger.create((boolean)false);
        try {
            RunQuartusCommandHelperUtils.runQuartusTcl(qcmdArray, null, (IMessageLogger)messagelogger, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IMessage returnedString = messagelogger.getMessage(0, new EMessageLevel[]{EMessageLevel.Info});
        if (returnedString != null && returnedString.getProblemDescription().equalsIgnoreCase("Full Version")) {
            this.quartusEdition = "Full Version";
            return true;
        }
        this.quartusEdition = "Web edition";
        return false;
    }
}

