/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.sopcmodel.ensemble.EnsembleWalker;
import com.altera.sopcmodel.util.Message;
import com.altera.utilities.AltString;
import java.util.List;

public class VirtualMasterValidator {
    static String PCI_BAR_SIZE_128B = "128 Bytes - 7 bits";
    static String PCI_BAR_SIZE_256B = "256 Bytes - 8 bits";
    static String PCI_BAR_SIZE_512B = "512 Bytes - 9 bits";
    static String PCI_BAR_SIZE_1K = " 1 KByte - 10 bits";
    static String PCI_BAR_SIZE_2K = " 2 KBytes - 11 bits";
    static String PCI_BAR_SIZE_4K = " 4 KBytes - 12 bits";
    static String PCI_BAR_SIZE_8K = " 8 KBytes - 13 bits";
    static String PCI_BAR_SIZE_16K = " 16 KBytes - 14 bits";
    static String PCI_BAR_SIZE_32K = " 32 KBytes - 15 bits";
    static String PCI_BAR_SIZE_64K = " 64 KBytes - 16 bits";
    static String PCI_BAR_SIZE_128K = " 128 KBytes - 17 bits";
    static String PCI_BAR_SIZE_256K = " 256 KBytes - 18 bits";
    static String PCI_BAR_SIZE_512K = " 512 KBytes - 19 bits";
    static String PCI_BAR_SIZE_1M = " 1 MByte - 20 bits";
    static String PCI_BAR_SIZE_2M = " 2 MBytes - 21 bits";
    static String PCI_BAR_SIZE_4M = " 4 MBytes - 22 bits";
    static String PCI_BAR_SIZE_8M = " 8 MBytes - 23 bits";
    static String PCI_BAR_SIZE_16M = " 16 MBytes - 24 bits";
    static String PCI_BAR_SIZE_32M = " 32 MBytes - 25 bits";
    static String PCI_BAR_SIZE_64M = " 64 MBytes - 26 bits";
    static String PCI_BAR_SIZE_128M = " 128 MBytes - 27 bits";
    static String PCI_BAR_SIZE_256M = " 256 MBytes - 28 bits";
    static String PCI_BAR_SIZE_512M = " 512 MBytes - 29 bits";
    static String PCI_BAR_SIZE_1G = " 1 GByte - 30 bits";
    static String PCI_BAR_SIZE_2G = " 2 GBytes - 31 bits";
    static String PCI_BAR_SIZE_4G = " 4 GBytes - 32 bits";
    private static IMessageLogger logger;
    private static IModule module;

    public static boolean validateAddress(IModule parent, PCIECompilerCoreParameters parameters, IMessageLogger log) {
        boolean result = true;
        module = parameters.getModuleCore();
        logger = log;
        EnsembleWalker walker = EnsembleWalker.create((IModule)parent);
        Object s_coreType = null;
        Boolean s_master = parameters.isP_pci_master();
        List<IConnectionPoint> connectionPoints = parameters.getContext().getConnectionPoints();
        for (int i = 0; i <= 5; ++i) {
            String connectionPointName = null;
            boolean isSingleCycle = !parameters.isP_pci_target_bursts();
            long avalonAddress = VirtualMasterValidator.getBarAvalonAddress(i, parameters);
            int barSize = VirtualMasterValidator.getBarSize(i, parameters);
            boolean isPrefetchable = VirtualMasterValidator.isBarPrefetchable(i, parameters);
            boolean isPCIBARUsed = VirtualMasterValidator.isBarUsed(i, parameters);
            boolean isAutoSized = VirtualMasterValidator.isBarAutoSized(i, parameters);
            boolean is64bitsBAR = false;
            is64bitsBAR = i > 0 && (i == 1 || i == 3 || i == 5) ? VirtualMasterValidator.isBAR64Bit(i - 1, parameters) : VirtualMasterValidator.isBAR64Bit(i, parameters);
            boolean isConnected = false;
            if (is64bitsBAR && (i == 1 || i == 3 || i == 5)) {
                isPCIBARUsed = false;
            }
            if (!isPCIBARUsed) continue;
            Long[] slaveRange = new Long[]{0xFFFFFFFFL, 0L};
            connectionPointName = is64bitsBAR && i == 0 ? (isPrefetchable ? "bar1_0_Prefetchable" : "bar1_0_Non_Prefetchable") : (is64bitsBAR && i == 2 ? (isPrefetchable ? "bar3_2_Prefetchable" : "bar3_2_Non_Prefetchable") : (is64bitsBAR && i == 4 ? (isPrefetchable ? "bar5_4_Prefetchable" : "bar5_4_Non_Prefetchable") : (isPrefetchable ? "bar" + i + "_" + "Prefetchable" : "bar" + i + "_" + "Non_Prefetchable")));
            for (IConnectionPoint cp : connectionPoints) {
                List eis;
                if (cp.getName().equalsIgnoreCase("Tx_Interface")) {
                    eis = walker.getMasterInfos(cp);
                    for (EnsembleWalker.ElementInfo ei : eis) {
                        IConnectionPoint master = ei.getConnectedBy().getStart();
                        String instanceName = cp.getModule().getName();
                        if (!master.getModule().equals(cp.getModule())) continue;
                        VirtualMasterValidator.displayErrorMessage("Tx_Interface cannot be connected to the " + instanceName + " Avalon master");
                    }
                    continue;
                }
                if (!cp.getName().equalsIgnoreCase(connectionPointName)) continue;
                eis = walker.getSlaveInfos(cp);
                for (EnsembleWalker.ElementInfo ei : eis) {
                    long baseAddress = ei.getAddress().longValue();
                    long span = ei.getSpan().longValue();
                    long endAddress = baseAddress + span - 1L;
                    String str = ei.getElement().getName();
                    if (baseAddress < slaveRange[0]) {
                        slaveRange[0] = baseAddress;
                    }
                    if (endAddress <= slaveRange[1]) continue;
                    slaveRange[1] = endAddress;
                }
                if (slaveRange[1] < slaveRange[0]) continue;
                isConnected = true;
                long[] calculatedSlaveAddress = VirtualMasterValidator.calculateBARAvalonAddress(slaveRange[0], slaveRange[1]);
                int calculatedBARSize = Integer.parseInt(Long.toString(calculatedSlaveAddress[1]));
                String strbarSize = VirtualMasterValidator.getVirtualMasterSize(calculatedBARSize);
                VirtualMasterValidator.displayInfoMessage(connectionPointName + ": PCI BAR Size =" + strbarSize + ", Avalon Base Address = " + AltString.longTo0xHexString((long)calculatedSlaveAddress[0], (int)8) + ", Avalon End Address = " + AltString.longTo0xHexString((long)calculatedSlaveAddress[2], (int)8));
                if (calculatedSlaveAddress[1] > 31L && !is64bitsBAR) {
                    VirtualMasterValidator.displayErrorMessage(connectionPointName + ": Maximum allowed BAR size is 2 GBytes - 31 bits. Please reassign avalon slave addresses for this BAR.");
                    result = false;
                } else if (calculatedSlaveAddress[1] > 32L && is64bitsBAR) {
                    VirtualMasterValidator.displayErrorMessage(connectionPointName + ": Maximum allowed BAR size is 4 GBytes - 32 bits. Please reassign avalon slave addresses for this BAR.");
                    result = false;
                }
                if (!isAutoSized) {
                    if (avalonAddress > slaveRange[1] || avalonAddress + (long)Math.pow(2.0, barSize) - 1L < slaveRange[0]) {
                        VirtualMasterValidator.displayErrorMessage(connectionPointName + ": BAR settings cannot access to the mapped Avalon slaves. " + "Avalon size is hardcoded to " + VirtualMasterValidator.getVirtualMasterSize(barSize) + " and Avalon Base Address is " + AltString.longTo0xHexString((long)avalonAddress, (int)8) + " in PCI Express Compiler settings.");
                        result = false;
                    } else if (avalonAddress > slaveRange[0] || avalonAddress + (long)Math.pow(2.0, barSize) - 1L < slaveRange[1]) {
                        VirtualMasterValidator.displayWarningMessage(connectionPointName + ": BAR settings do not allow full access to the mapped Avalon slaves. " + "Avalon size is hardcoded to " + VirtualMasterValidator.getVirtualMasterSize(barSize) + " and Avalon Base Address is " + AltString.longTo0xHexString((long)avalonAddress, (int)8) + " in PCI Express Compiler settings.");
                    }
                    VirtualMasterValidator.setActualBarAddress(i, avalonAddress, parameters);
                    VirtualMasterValidator.setActualBarSize(i, barSize, parameters, false);
                    continue;
                }
                if ((calculatedSlaveAddress[1] > 31L || is64bitsBAR) && (calculatedSlaveAddress[1] > 32L || !is64bitsBAR)) continue;
                VirtualMasterValidator.setActualBarAddress(i, calculatedSlaveAddress[0], parameters);
                VirtualMasterValidator.setActualBarSize(i, calculatedBARSize, parameters, true);
            }
            if (isConnected) continue;
            result = false;
        }
        return result;
    }

    private static boolean isBAR64Bit(int i, PCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.getP_pcie_bar_type_bar_0().substring(0, 2).equalsIgnoreCase("64");
            }
            case 1: {
                return parameters.getP_pcie_bar_type_bar_1().substring(0, 2).equalsIgnoreCase("64");
            }
            case 2: {
                return parameters.getP_pcie_bar_type_bar_2().substring(0, 2).equalsIgnoreCase("64");
            }
            case 3: {
                return parameters.getP_pcie_bar_type_bar_3().substring(0, 2).equalsIgnoreCase("64");
            }
            case 4: {
                return parameters.getP_pcie_bar_type_bar_4().substring(0, 2).equalsIgnoreCase("64");
            }
            case 5: {
                return parameters.getP_pcie_bar_type_bar_5().substring(0, 2).equalsIgnoreCase("64");
            }
        }
        return false;
    }

    private static void setActualBarSize(int i, int calculatedBARSize, PCIECompilerCoreParameters parameters, boolean isAutoAddress) {
        switch (i) {
            case 0: {
                parameters.setActualBAR0Size(calculatedBARSize);
                if (!isAutoAddress) break;
                parameters.setP_pci_bar_0_auto_sized(true);
                break;
            }
            case 1: {
                parameters.setActualBAR1Size(calculatedBARSize);
                if (!isAutoAddress) break;
                parameters.setP_pci_bar_1_auto_sized(true);
                break;
            }
            case 2: {
                parameters.setActualBAR2Size(calculatedBARSize);
                if (!isAutoAddress) break;
                parameters.setP_pci_bar_2_auto_sized(true);
                break;
            }
            case 3: {
                parameters.setActualBAR3Size(calculatedBARSize);
                if (!isAutoAddress) break;
                parameters.setP_pci_bar_3_auto_sized(true);
                break;
            }
            case 4: {
                parameters.setActualBAR4Size(calculatedBARSize);
                if (!isAutoAddress) break;
                parameters.setP_pci_bar_4_auto_sized(true);
                break;
            }
            case 5: {
                parameters.setActualBAR5Size(calculatedBARSize);
                if (!isAutoAddress) break;
                parameters.setP_pci_bar_5_auto_sized(true);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void setActualBarAddress(int i, long address, PCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                parameters.setActualBAR0AvalonAddress(address);
                break;
            }
            case 1: {
                parameters.setActualBAR1AvalonAddress(address);
                break;
            }
            case 2: {
                parameters.setActualBAR2AvalonAddress(address);
                break;
            }
            case 3: {
                parameters.setActualBAR3AvalonAddress(address);
                break;
            }
            case 4: {
                parameters.setActualBAR4AvalonAddress(address);
                break;
            }
            case 5: {
                parameters.setActualBAR5AvalonAddress(address);
                break;
            }
            default: {
                return;
            }
        }
    }

    static boolean isBarAutoSized(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.isP_pci_bar_0_auto_sized();
            }
            case 1: {
                return parameters.isP_pci_bar_1_auto_sized();
            }
            case 2: {
                return parameters.isP_pci_bar_2_auto_sized();
            }
            case 3: {
                return parameters.isP_pci_bar_3_auto_sized();
            }
            case 4: {
                return parameters.isP_pci_bar_4_auto_sized();
            }
            case 5: {
                return parameters.isP_pci_bar_5_auto_sized();
            }
        }
        return false;
    }

    static boolean isBarUsed(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.isP_pcie_bar_used_bar_0();
            }
            case 1: {
                return parameters.isP_pcie_bar_used_bar_1();
            }
            case 2: {
                return parameters.isP_pcie_bar_used_bar_2();
            }
            case 3: {
                return parameters.isP_pcie_bar_used_bar_3();
            }
            case 4: {
                return parameters.isP_pcie_bar_used_bar_4();
            }
            case 5: {
                return parameters.isP_pcie_bar_used_bar_5();
            }
        }
        return false;
    }

    static boolean isBarPrefetchable(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.isP_pci_bar_0_prefetchable();
            }
            case 1: {
                return parameters.isP_pci_bar_1_prefetchable();
            }
            case 2: {
                return parameters.isP_pci_bar_2_prefetchable();
            }
            case 3: {
                return parameters.isP_pci_bar_3_prefetchable();
            }
            case 4: {
                return parameters.isP_pci_bar_4_prefetchable();
            }
            case 5: {
                return parameters.isP_pci_bar_5_prefetchable();
            }
        }
        return false;
    }

    static void setBarPrefetchable(int i, Boolean value) {
        String paramName = "p_pci_bar_" + i + "_prefetchable";
        module.setValue(paramName, (Object)value);
    }

    static Boolean isUiPrefetchable(int i, PCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.isUiBar0Prefetchable();
            }
            case 1: {
                return parameters.isUiBar1Prefetchable();
            }
            case 2: {
                return parameters.isUiBar2Prefetchable();
            }
            case 3: {
                return parameters.isUiBar3Prefetchable();
            }
            case 4: {
                return parameters.isUiBar4Prefetchable();
            }
            case 5: {
                return parameters.isUiBar5Prefetchable();
            }
        }
        return null;
    }

    static int getBarSize(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return VirtualMasterValidator.getBitWidth(parameters.getP_pcie_bar_size_bar_0());
            }
            case 1: {
                return VirtualMasterValidator.getBitWidth(parameters.getP_pcie_bar_size_bar_1());
            }
            case 2: {
                return VirtualMasterValidator.getBitWidth(parameters.getP_pcie_bar_size_bar_2());
            }
            case 3: {
                return VirtualMasterValidator.getBitWidth(parameters.getP_pcie_bar_size_bar_3());
            }
            case 4: {
                return VirtualMasterValidator.getBitWidth(parameters.getP_pcie_bar_size_bar_4());
            }
            case 5: {
                return VirtualMasterValidator.getBitWidth(parameters.getP_pcie_bar_size_bar_5());
            }
        }
        return 0;
    }

    private static int getBitWidth(String value) {
        if (value.equalsIgnoreCase("N/A") || value.equalsIgnoreCase("Auto")) {
            return 0;
        }
        return Integer.parseInt(value.substring(value.length() - 7, value.length() - 5).replaceAll(" ", "0"));
    }

    static long getBarAvalonAddress(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.getP_pci_bar_0_avalon_address();
            }
            case 1: {
                return parameters.getP_pci_bar_1_avalon_address();
            }
            case 2: {
                return parameters.getP_pci_bar_2_avalon_address();
            }
            case 3: {
                return parameters.getP_pci_bar_3_avalon_address();
            }
            case 4: {
                return parameters.getP_pci_bar_4_avalon_address();
            }
            case 5: {
                return parameters.getP_pci_bar_5_avalon_address();
            }
        }
        return 0L;
    }

    private static long[] calculateBARAvalonAddress(long base, long end) {
        long bar = base ^ end;
        long span = VirtualMasterValidator.round_up2(bar);
        if (span < 128L) {
            span = 128L;
        }
        long mask = span - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long base2 = base & mask;
        long span2 = VirtualMasterValidator.bits_to_encode(span - 1L);
        long end2 = base2 + (long)Math.pow(2.0, span2) - 1L;
        long[] result = new long[]{base2, span2, end2};
        return result;
    }

    static String to_hex(long v) {
        String s = Long.toString(v & Integer.MAX_VALUE, 16).toUpperCase();
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s;
    }

    static long round_up2(long value) {
        long b2e = VirtualMasterValidator.bits_to_encode(value);
        return 1L << (int)b2e;
    }

    static long bits_to_encode(long value) {
        long bits = 0L;
        while (value > 0L) {
            value >>= 1;
            ++bits;
        }
        return bits;
    }

    static long str_to_long(String s) {
        long value = 0L;
        try {
            value = Long.parseLong(s, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    private static String getVirtualMasterSize(int pBitWidth) {
        String returnValue = "";
        switch (pBitWidth) {
            case 7: {
                returnValue = PCI_BAR_SIZE_128B;
                break;
            }
            case 8: {
                returnValue = PCI_BAR_SIZE_256B;
                break;
            }
            case 9: {
                returnValue = PCI_BAR_SIZE_512B;
                break;
            }
            case 10: {
                returnValue = PCI_BAR_SIZE_1K;
                break;
            }
            case 11: {
                returnValue = PCI_BAR_SIZE_2K;
                break;
            }
            case 12: {
                returnValue = PCI_BAR_SIZE_4K;
                break;
            }
            case 13: {
                returnValue = PCI_BAR_SIZE_8K;
                break;
            }
            case 14: {
                returnValue = PCI_BAR_SIZE_16K;
                break;
            }
            case 15: {
                returnValue = PCI_BAR_SIZE_32K;
                break;
            }
            case 16: {
                returnValue = PCI_BAR_SIZE_64K;
                break;
            }
            case 17: {
                returnValue = PCI_BAR_SIZE_128K;
                break;
            }
            case 18: {
                returnValue = PCI_BAR_SIZE_256K;
                break;
            }
            case 19: {
                returnValue = PCI_BAR_SIZE_512K;
                break;
            }
            case 20: {
                returnValue = PCI_BAR_SIZE_1M;
                break;
            }
            case 21: {
                returnValue = PCI_BAR_SIZE_2M;
                break;
            }
            case 22: {
                returnValue = PCI_BAR_SIZE_4M;
                break;
            }
            case 23: {
                returnValue = PCI_BAR_SIZE_8M;
                break;
            }
            case 24: {
                returnValue = PCI_BAR_SIZE_16M;
                break;
            }
            case 25: {
                returnValue = PCI_BAR_SIZE_32M;
                break;
            }
            case 26: {
                returnValue = PCI_BAR_SIZE_64M;
                break;
            }
            case 27: {
                returnValue = PCI_BAR_SIZE_128M;
                break;
            }
            case 28: {
                returnValue = PCI_BAR_SIZE_256M;
                break;
            }
            case 29: {
                returnValue = PCI_BAR_SIZE_512M;
                break;
            }
            case 30: {
                returnValue = PCI_BAR_SIZE_1G;
                break;
            }
            case 31: {
                returnValue = PCI_BAR_SIZE_2G;
                break;
            }
            case 32: {
                returnValue = PCI_BAR_SIZE_4G;
                break;
            }
            default: {
                returnValue = "> 32 bits";
            }
        }
        return returnValue;
    }

    public static void setMessageLogger(IMessageLogger messageLogger) {
        logger = messageLogger;
    }

    private static void displayInfoMessage(String msg) {
        Message info = Message.create((EMessageID)EMessageID.Other);
        info.setObject((Object)module);
        info.setLevel(EMessageLevel.Info);
        info.setProblemDescription(msg);
        logger.receiveMessage((IMessage)info);
    }

    private static void displayWarningMessage(String msg) {
        Message warning = Message.create((EMessageID)EMessageID.Other);
        warning.setObject((Object)module);
        warning.setLevel(EMessageLevel.Warning);
        warning.setProblemDescription(msg);
        logger.receiveMessage((IMessage)warning);
    }

    private static void displayErrorMessage(String msg) {
        Message error = Message.create((EMessageID)EMessageID.Other);
        error.setObject((Object)module);
        error.setLevel(EMessageLevel.Error);
        error.setProblemDescription(msg);
        logger.receiveMessage((IMessage)error);
    }

    static {
        module = null;
    }
}

