/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import com.altera.entityinterfaces.elementclassext.IElementClassCoreInfo;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.PCIEMessages;
import com.altera.sopcmodel.util.Message;
import java.util.Collection;

public class SupportedDeviceFamilyValidator {
    public static boolean validateSupportedFamily(IPCIECompilerCoreParameters parameters, IMessageLogger logger) {
        IElementClassCoreInfo coreInfo = (IElementClassCoreInfo)parameters.getModuleCore().getElementClass().getExtension(IElementClassCoreInfo.class);
        if (coreInfo != null) {
            Collection supportedDeviceFamily = coreInfo.getSupportedDeviceFamilies();
            if (supportedDeviceFamily != null) {
                for (IElementClassCoreInfo.DeviceSupportInfo deviceSupport : supportedDeviceFamily) {
                    if (!deviceSupport.getDeviceFamily().getName().equals(parameters.getDeviceFamily().getName())) continue;
                    return true;
                }
            }
            Message msgUnsupported = Message.create((EMessageID)EMessageID.ValidationRelated);
            msgUnsupported.setObject((Object)parameters.getModuleCore());
            msgUnsupported.setProblemDescription(PCIEMessages.UNSUPPORTED_DEVICE.toString());
            logger.receiveMessage((IMessage)msgUnsupported);
            return false;
        }
        return true;
    }
}

