/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import com.altera.entityinterfaces.IConnection;
import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.entityinterfaces.IElement;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.entityinterfaces.moduleext.IElementValidateWithParent;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.SupportedDeviceFamilyValidator;
import com.altera.megacore.pcie.model.validators.VirtualMasterValidator;
import com.altera.sopcmodel.ensemble.DeviceFamily;
import com.altera.sopcmodel.ensemble.EnsembleWalker;
import com.altera.sopcmodel.util.Message;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PCIEValidateWithSOPCParent
implements IElementValidateWithParent {
    IModule parent = null;
    private PCIECompilerCoreParameters parameters;

    public PCIEValidateWithSOPCParent(PCIECompilerCoreParameters parameters) {
        this.parameters = parameters;
    }

    public Collection<IElement> getDependencies(IModule parent) {
        this.parent = parent;
        EnsembleWalker walker = EnsembleWalker.create((IModule)parent);
        String SOPCSystemName = parent.getName();
        if (SOPCSystemName == null || SOPCSystemName.equalsIgnoreCase("")) {
            return null;
        }
        this.parameters.setSOPCSystemName(SOPCSystemName);
        IDeviceFamily deviceFamily = (IDeviceFamily)parent.getExtension(IDeviceFamily.class);
        this.parameters.setDeviceFamily(deviceFamily);
        List<IConnectionPoint> cps = this.parameters.getContext().getConnectionPoints();
        IConnectionPoint cpt = null;
        for (IConnectionPoint cp : cps) {
            if (!"pcie_core_clk".equals(cp.getName())) continue;
            cpt = cp;
        }
        if (this.parameters.getModuleCore().getDeviceFamily().toString().equals(DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.NONE).toString())) {
            this.parameters.getModuleCore().setDeviceFamily(deviceFamily);
        }
        for (IConnectionPoint cp : cps) {
            List eis;
            Iterator iterator;
            if (!"avalon_clk".equals(cp.getName()) || !(iterator = (eis = walker.getMasteringInfos(cp)).iterator()).hasNext()) continue;
            EnsembleWalker.ElementInfo ei = (EnsembleWalker.ElementInfo)iterator.next();
            IConnection clockConnection = ei.getConnectedBy();
            if (this.parameters.isP_pci_single_clock()) {
                if (cpt != null && this.parameters.getModuleCore().getPCIESystemEditor() != null) {
                    clockConnection.setStart(cpt);
                }
                IConnectionPoint clockCP = clockConnection.getStart();
                this.parameters.setClockSource(clockCP.getName());
            } else {
                String clockName = clockConnection.getStart().getModule().getName();
                this.parameters.setClockSource(clockName);
            }
            return null;
        }
        this.parameters.setClockSource(null);
        return null;
    }

    public boolean validateWithParent(Collection<IElement> validatedElements, IMessageLogger logger) {
        boolean result = true;
        if (this.parameters.isP_pcie_underSOPCBuilder()) {
            result &= this.validateClock(logger);
            result &= VirtualMasterValidator.validateAddress(this.parent, this.parameters, logger);
            result &= SupportedDeviceFamilyValidator.validateSupportedFamily(this.parameters, logger);
        }
        return result;
    }

    private boolean validateClock(IMessageLogger logger) {
        if (!this.parameters.isP_pci_single_clock() && (this.parameters.getClockSource() == null || "".equals(this.parameters.getClockSource()))) {
            Message error = Message.create((EMessageID)EMessageID.IllegalValue);
            error.setObject((Object)this.parameters.getModuleCore());
            error.setLevel(EMessageLevel.Error);
            error.setProblemDescription("Invalid clock source");
            return false;
        }
        if (this.parameters.isP_pci_single_clock() && (this.parameters.getClockSource() == null || !"pcie_core_clk".equals(this.parameters.getClockSource()))) {
            Message info = Message.create((EMessageID)EMessageID.Other);
            info.setObject((Object)this.parameters.getModuleCore());
            info.setLevel(EMessageLevel.Error);
            info.setProblemDescription("\"" + this.parameters.getModuleCore().getName() + "." + "pcie_core_clk" + "\" must be connected to \"" + this.parameters.getModuleCore().getName() + "." + "avalon_clk" + "\"");
            logger.receiveMessage((IMessage)info);
            return false;
        }
        return true;
    }
}

