/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import altera.ipbu.flowbase.StaticValues;
import altera.ipbu.flowbase.controls.WPanel;
import altera.ipbu.pci_express.MVCConstants;
import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.entityinterfaces.IParameterDescriptorInstance;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.megacore.pcie.model.ICoreParameterDescriptorRetriever;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.IValidator;
import com.altera.megacore.pcie.ui.PCIEConfiguration;
import com.altera.megawizard2.extensions.IMegawizardGenerateQmegawizFiles;
import com.altera.megawizard2.utilities.MWParameterDescriptorHelper;
import com.altera.sopcmodel.ensemble.DeviceFamily;
import com.altera.sopcmodel.util.Message;
import com.altera.sopcmodel.util.ParameterDescriptor;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PCIEUIValidatorSystemSettings
implements IValidator {
    private IMessageLogger logger;
    private ICoreParameterDescriptorRetriever coreParameterDescriptor = null;
    private IPCIECompilerCoreParameters parameters = null;
    private Document dom = null;

    @Override
    public synchronized boolean validate(IPCIECompilerCoreParameters parameters, ICoreParameterDescriptorRetriever coreParameterDescriptor) {
        if (coreParameterDescriptor == null) {
            return false;
        }
        if (parameters == null) {
            return false;
        }
        this.coreParameterDescriptor = coreParameterDescriptor;
        this.parameters = parameters;
        boolean result = true;
        result &= this.AddSOPCBuilderMessages();
        result &= this.validateALTGX();
        result &= this.updateCoreType();
        result &= this.updateVersion();
        result &= this.updatePhyAndRleatedRanges();
        result &= this.updatePowerSetting();
        result &= this.updatePortTypeAndBARs();
        result &= this.updateInternalClk();
        result &= this.validateReadOnlyRegisters();
        result &= this.updateGeneralCapabilities();
        result &= this.updateBufferSetupPage();
        result &= this.updateApplicationInterface();
        if (MVCConstants.getResourceString("PCIE_Use_Rule_Based_XML").equalsIgnoreCase("1")) {
            result &= this.AddHIPMessages();
        }
        return result;
    }

    private boolean updateVersion() {
        IParameterDescriptorInstance pcie_version_pd = this.getParameterDescriptor("p_pcie_version");
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
            Vector<ParameterDescriptor.Range> rangesVersion = new Vector<ParameterDescriptor.Range>();
            rangesVersion.add(new ParameterDescriptor.Range((Object)"1.0A", (Object)"1.0A"));
            rangesVersion.add(new ParameterDescriptor.Range((Object)"1.1", (Object)"1.1"));
            pcie_version_pd.setLegalRanges(rangesVersion);
            pcie_version_pd.setEnabled(true);
            if (!this.isInRange(this.getParameters().getP_pcie_version().toString(), (IParameterDescriptor)pcie_version_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_version("1.1");
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
            Vector<ParameterDescriptor.Range> rangesVersion = new Vector<ParameterDescriptor.Range>();
            rangesVersion.add(new ParameterDescriptor.Range((Object)"2.1", (Object)"2.1"));
            pcie_version_pd.setLegalRanges(rangesVersion);
            pcie_version_pd.setEnabled(false);
            if (!this.isInRange(this.getParameters().getP_pcie_version().toString(), (IParameterDescriptor)pcie_version_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_version("2.1");
            }
        } else if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)")) {
            Vector<ParameterDescriptor.Range> rangesVersion = new Vector<ParameterDescriptor.Range>();
            rangesVersion.add(new ParameterDescriptor.Range((Object)"2.0", (Object)"2.0"));
            pcie_version_pd.setLegalRanges(rangesVersion);
            pcie_version_pd.setEnabled(false);
            if (!this.isInRange(this.getParameters().getP_pcie_version().toString(), (IParameterDescriptor)pcie_version_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_version("2.0");
            }
        } else {
            Vector<ParameterDescriptor.Range> rangesVersion = new Vector<ParameterDescriptor.Range>();
            rangesVersion.add(new ParameterDescriptor.Range((Object)"1.1", (Object)"1.1"));
            rangesVersion.add(new ParameterDescriptor.Range((Object)"2.0", (Object)"2.0"));
            pcie_version_pd.setLegalRanges(rangesVersion);
            pcie_version_pd.setEnabled(true);
            if (!this.isInRange(this.getParameters().getP_pcie_version().toString(), (IParameterDescriptor)pcie_version_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_version("1.1");
            }
        }
        return true;
    }

    private boolean AddSOPCBuilderMessages() {
        if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_UNDER_SOPC.Message"), EMessageID.ValidationRelated);
            if (!this.getParameters().isP_pci_impl_cra_av_slave_port()) {
                this.addInfoMessage(MVCConstants.getResourceString("PCIE_CRA_PORT.Message"), EMessageID.ValidationRelated);
            }
        }
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0") && ((PCIECompilerCoreParameters)this.parameters).getUiPCIDeviceMode().equals((Object)IPCIECompilerCoreParameters.EPCIDeviceMode.mmLite)) {
            this.addErrorMessage("Avalon-MM Lite is only supported for Hard IP.", EMessageID.ValidationRelated);
        }
        return true;
    }

    private boolean isHiddenDeviceFamily(IDeviceFamily.EDeviceFamily eDeviceFamily) {
        if (this.getParameters().getAllowedDeviceFamilies() != null) {
            for (IDeviceFamily mydeviceFamily : this.getParameters().getAllowedDeviceFamilies()) {
                if (!mydeviceFamily.getDeviceFamily().equals((Object)eDeviceFamily)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean updatePhyAndRleatedRanges() {
        ParameterDescriptor.Range range8b_DDR;
        ParameterDescriptor.Range range156MHZ;
        ParameterDescriptor.Range range125MHZ;
        ParameterDescriptor.Range range100MHZ;
        ParameterDescriptor.Range range250MHZ;
        Vector<ParameterDescriptor.Range> txrxranges;
        ParameterDescriptor.Range range16b_SDR;
        ParameterDescriptor.Range rangex1;
        Vector<ParameterDescriptor.Range> ranges;
        IDeviceFamily family;
        ParameterDescriptor.Range rangeSerial;
        Vector<ParameterDescriptor.Range> phyranges;
        ParameterDescriptor.Range rangex4;
        ParameterDescriptor.Range rangex8;
        ParameterDescriptor.Range rangex42;
        ParameterDescriptor.Range rangex12;
        Vector<ParameterDescriptor.Range> ranges2;
        IDeviceFamily family2;
        ParameterDescriptor.Range rangex13;
        Vector<ParameterDescriptor.Range> ranges3;
        ParameterDescriptor.Range rangeSerial2;
        Vector<ParameterDescriptor.Range> phyranges2;
        Integer count;
        Vector<ParameterDescriptor.Range> rangeChannelNumber;
        String deviceFamily;
        ParameterDescriptor.Range range125MHZ2;
        ParameterDescriptor.Range range100MHZ2;
        Vector<ParameterDescriptor.Range> txrxranges2;
        ParameterDescriptor.Range rangex14;
        Vector<ParameterDescriptor.Range> ranges4;
        Vector<ParameterDescriptor.Range> phyranges3;
        Vector<ParameterDescriptor.Range> ranges5 = new Vector<ParameterDescriptor.Range>();
        ParameterDescriptor.Range rangeExternalPHY = new ParameterDescriptor.Range((Object)"Custom", (Object)"Custom");
        ParameterDescriptor.Range rangeGLPHY = new ParameterDescriptor.Range((Object)"Genesys Logic GL9714", (Object)"Genesys Logic GL9714");
        ParameterDescriptor.Range rangePhilipsPHY = new ParameterDescriptor.Range((Object)"NXP PX1011A", (Object)"NXP PX1011A");
        ParameterDescriptor.Range rangeStratixIIGX = new ParameterDescriptor.Range((Object)"Stratix II GX", (Object)"Stratix II GX");
        ParameterDescriptor.Range rangeStratixIVGX = new ParameterDescriptor.Range((Object)"Stratix IV GX", (Object)"Stratix IV GX");
        ParameterDescriptor.Range rangeStratixVGX = new ParameterDescriptor.Range((Object)"Stratix V GX", (Object)"Stratix V GX");
        ParameterDescriptor.Range rangeStratixVGXCVP = new ParameterDescriptor.Range((Object)"Stratix V GX CVP", (Object)"Stratix V GX CVP");
        ParameterDescriptor.Range rangeArriaIIGZ = new ParameterDescriptor.Range((Object)"Arria II GZ", (Object)"Arria II GZ");
        ParameterDescriptor.Range rangeStratixIIGXLite = new ParameterDescriptor.Range((Object)"Arria GX", (Object)"Arria GX");
        ParameterDescriptor.Range rangeTIPHY = new ParameterDescriptor.Range((Object)"TI XIO1100", (Object)"TI XIO1100");
        ParameterDescriptor.Range rangeArriaII = new ParameterDescriptor.Range((Object)"Arria II GX", (Object)"Arria II GX");
        ParameterDescriptor.Range rangeStratixIVGXES = new ParameterDescriptor.Range((Object)"Stratix IV GX ES", (Object)"Stratix IV GX ES");
        ParameterDescriptor.Range rangeCycloneIIIGX = new ParameterDescriptor.Range((Object)"Cyclone IV GX", (Object)"Cyclone IV GX");
        ParameterDescriptor.Range rangeHardCopyIV = new ParameterDescriptor.Range((Object)"HardCopy IV GX", (Object)"HardCopy IV GX");
        IParameterDescriptorInstance pd = this.getParameterDescriptor("p_pcie_phy");
        if (this.getParameters().getP_pcie_special_phy_gl().equalsIgnoreCase("0") && this.getParameters().getP_pcie_special_phy_px().equalsIgnoreCase("0")) {
            ranges5.add(rangeStratixIIGXLite);
            if (!this.isHiddenDeviceFamily(IDeviceFamily.EDeviceFamily.ARRIAII)) {
                ranges5.add(rangeArriaII);
            }
            ranges5.add(rangeCycloneIIIGX);
            ranges5.add(rangeStratixIVGX);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_pcie_gen2_x8_es().equals("1")) {
                ranges5.add(rangeStratixIVGXES);
                ranges5.add(rangeHardCopyIV);
            }
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges5.add(rangeArriaIIGZ);
            }
            ranges5.add(rangeExternalPHY);
            ranges5.add(rangeTIPHY);
        } else if (this.getParameters().getP_pcie_special_phy_gl().equalsIgnoreCase("0") && !this.getParameters().getP_pcie_special_phy_px().equalsIgnoreCase("0")) {
            if (!this.isHiddenDeviceFamily(IDeviceFamily.EDeviceFamily.ARRIAII)) {
                ranges5.add(rangeArriaII);
            }
            ranges5.add(rangeCycloneIIIGX);
            ranges5.add(rangeStratixIVGX);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_pcie_gen2_x8_es().equals("1")) {
                ranges5.add(rangeStratixIVGXES);
                ranges5.add(rangeStratixIIGX);
                ranges5.add(rangeHardCopyIV);
                ranges5.add(rangeStratixIIGXLite);
            }
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges5.add(rangeArriaIIGZ);
                if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_pcie_gen2_x8_es().equals("1")) {
                    ranges5.add(rangeStratixIVGXES);
                    ranges5.add(rangeStratixVGXCVP);
                }
            }
            ranges5.add(rangeExternalPHY);
            ranges5.add(rangeTIPHY);
            ranges5.add(rangePhilipsPHY);
        } else if (!this.getParameters().getP_pcie_special_phy_gl().equalsIgnoreCase("0") && this.getParameters().getP_pcie_special_phy_px().equalsIgnoreCase("0")) {
            if (!this.isHiddenDeviceFamily(IDeviceFamily.EDeviceFamily.ARRIAII)) {
                ranges5.add(rangeArriaII);
            }
            ranges5.add(rangeCycloneIIIGX);
            ranges5.add(rangeStratixIVGX);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_pcie_gen2_x8_es().equals("1")) {
                ranges5.add(rangeStratixIVGXES);
                ranges5.add(rangeStratixIIGX);
                ranges5.add(rangeHardCopyIV);
                ranges5.add(rangeStratixIIGXLite);
            }
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges5.add(rangeArriaIIGZ);
                if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_pcie_gen2_x8_es().equals("1")) {
                    // empty if block
                }
            }
            ranges5.add(rangeExternalPHY);
            ranges5.add(rangeTIPHY);
            ranges5.add(rangeGLPHY);
        }
        pd.setLegalRanges(ranges5);
        IParameterDescriptorInstance al2gxb_pd = this.getParameterDescriptor("p_pcie_alt2gxb");
        IParameterDescriptorInstance channel_number_pd = this.getParameterDescriptor("p_pcie_channel_number");
        IParameterDescriptorInstance phyInterface_pd = this.getParameterDescriptor("p_pcie_phy_interface");
        IParameterDescriptorInstance lanes_pd = this.getParameterDescriptor("p_pcie_number_of_lanes");
        IParameterDescriptorInstance txrx_clock_pd = this.getParameterDescriptor("p_pcie_txrx_clock");
        IParameterDescriptorInstance enable_fast_recovery_pd = this.getParameterDescriptor("p_pcie_enable_fast_recovery");
        IParameterDescriptorInstance enable_pcie_hip_dprio_pd = this.getParameterDescriptor("p_enable_pcie_hip_dprio");
        IParameterDescriptorInstance pcie_parity_pd = this.getParameterDescriptor("p_pcie_use_parity");
        if (this.getParameters().getP_pcie_phy().equals("Stratix GX")) {
            IDeviceFamily family3;
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            al2gxb_pd.setEnabled(false);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_fast_recovery(false);
            enable_fast_recovery_pd.setEnabled(true);
            phyInterface_pd.setEnabled(false);
            phyranges3 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range rangeSerial3 = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges3.add(rangeSerial3);
            phyInterface_pd.setLegalRanges(phyranges3);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            ranges4 = new Vector<ParameterDescriptor.Range>();
            rangex14 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            ParameterDescriptor.Range rangex43 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            ranges4.add(rangex14);
            ranges4.add(rangex43);
            lanes_pd.setEnabled(true);
            lanes_pd.setLegalRanges(ranges4);
            if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(true);
            txrxranges2 = new Vector<ParameterDescriptor.Range>();
            range100MHZ2 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            range125MHZ2 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
            ParameterDescriptor.Range range156MHZ2 = new ParameterDescriptor.Range((Object)"156.25 MHz", (Object)"156.25 MHz");
            txrxranges2.add(range100MHZ2);
            txrxranges2.add(range125MHZ2);
            txrxranges2.add(range156MHZ2);
            txrx_clock_pd.setLegalRanges(txrxranges2);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (!(family3 = this.getParameters().getModuleCore().getDeviceFamily()).getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STRATIXGX.toString())) {
                String device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", "Stratix GX");
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", "Stratix GX");
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix II GX") || this.getParameters().getP_pcie_phy().equals("Arria GX")) {
            IDeviceFamily family4;
            deviceFamily = this.getParameters().getP_pcie_phy();
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            al2gxb_pd.setEnabled(true);
            enable_fast_recovery_pd.setEnabled(true);
            if (this.getParameters().getP_pcie_phy().equals("Stratix II GX")) {
                channel_number_pd.setEnabled(true);
                rangeChannelNumber = new Vector<ParameterDescriptor.Range>();
                count = 0;
                while (count < 160) {
                    rangeChannelNumber.add(new ParameterDescriptor.Range((Object)count, (Object)count));
                    count = count + 4;
                }
                channel_number_pd.setLegalRanges(rangeChannelNumber);
                if (!this.isInRange(new Integer(this.getParameters().getP_pcie_channel_number()).toString(), (IParameterDescriptor)channel_number_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
                }
            } else {
                channel_number_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            }
            phyInterface_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyranges2 = new Vector<ParameterDescriptor.Range>();
            rangeSerial2 = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges2.add(rangeSerial2);
            phyInterface_pd.setLegalRanges(phyranges2);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            ranges3 = new Vector<ParameterDescriptor.Range>();
            rangex13 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            ParameterDescriptor.Range rangex44 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            ParameterDescriptor.Range rangex82 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x8, (Object)IPCIECompilerCoreParameters.ELaneOptions.x8);
            ranges3.add(rangex13);
            ranges3.add(rangex44);
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder() && this.getParameters().getP_pcie_phy().equals("Stratix II GX")) {
                ranges3.add(rangex82);
            } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            lanes_pd.setEnabled(true);
            lanes_pd.setLegalRanges(ranges3);
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(false);
            Vector<ParameterDescriptor.Range> txrxranges3 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range range100MHZ3 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            txrxranges3.add(range100MHZ3);
            txrx_clock_pd.setLegalRanges(txrxranges3);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (!(family4 = this.getParameters().getModuleCore().getDeviceFamily()).getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STRATIXIIGX.toString()) && !family4.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STRATIXIIGXLITE.toString())) {
                String device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", deviceFamily);
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Arria II GX")) {
            Vector<ParameterDescriptor.Range> dprioranges;
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            deviceFamily = this.getParameters().getP_pcie_phy();
            al2gxb_pd.setEnabled(true);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_fast_recovery(true);
            enable_fast_recovery_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyranges2 = new Vector();
            rangeSerial2 = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges2.add(rangeSerial2);
            phyInterface_pd.setLegalRanges(phyranges2);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            family2 = this.getParameters().getModuleCore().getDeviceFamily();
            ranges2 = new Vector<ParameterDescriptor.Range>();
            rangex12 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            rangex42 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            rangex8 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x8, (Object)IPCIECompilerCoreParameters.ELaneOptions.x8);
            ranges2.add(rangex12);
            ranges2.add(rangex42);
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                    ranges2.add(rangex8);
                }
            } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            lanes_pd.setEnabled(true);
            lanes_pd.setLegalRanges(ranges2);
            if (!this.isInRange(this.getParameters().getP_pcie_number_of_lanes().toString(), (IParameterDescriptor)lanes_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") && !((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                dprioranges = new Vector();
                ParameterDescriptor.Range rangeEnable = new ParameterDescriptor.Range((Object)"Enable", (Object)"Enable");
                ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable", (Object)"Disable");
                dprioranges.add(rangeEnable);
                dprioranges.add(rangeDisable);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(!this.getParameters().getP_pcie_phy().equals("Stratix V GX") && !this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP"));
                if (!this.isInRange(this.getParameters().getP_enable_pcie_hip_dprio().toString(), (IParameterDescriptor)enable_pcie_hip_dprio_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
                if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
            } else {
                dprioranges = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range rangeNA = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
                dprioranges.add(rangeNA);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("N/A");
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(true);
            Vector<ParameterDescriptor.Range> txrxranges4 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range range100MHZ4 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            ParameterDescriptor.Range range125MHZ3 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
            txrxranges4.add(range100MHZ4);
            txrxranges4.add(range125MHZ3);
            txrx_clock_pd.setLegalRanges(txrxranges4);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (!family2.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.ARRIAII.toString())) {
                String device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.ARRIAII).getDisplayName());
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Cyclone IV GX")) {
            Vector<ParameterDescriptor.Range> dprioranges;
            deviceFamily = this.getParameters().getP_pcie_phy();
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            al2gxb_pd.setEnabled(true);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_fast_recovery(true);
            enable_fast_recovery_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyranges2 = new Vector();
            rangeSerial2 = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges2.add(rangeSerial2);
            phyInterface_pd.setLegalRanges(phyranges2);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            family2 = this.getParameters().getModuleCore().getDeviceFamily();
            ranges2 = new Vector();
            rangex12 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            ParameterDescriptor.Range rangex2 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x2, (Object)IPCIECompilerCoreParameters.ELaneOptions.x2);
            rangex4 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            ranges2.add(rangex12);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                ranges2.add(rangex2);
                ranges2.add(rangex4);
            }
            lanes_pd.setEnabled(true);
            lanes_pd.setLegalRanges(ranges2);
            if (!this.isInRange(this.getParameters().getP_pcie_number_of_lanes().toString(), (IParameterDescriptor)lanes_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") ? IPCIECompilerCoreParameters.ELaneOptions.x4 : IPCIECompilerCoreParameters.ELaneOptions.x1);
            }
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") && !((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                dprioranges = new Vector();
                ParameterDescriptor.Range rangeEnable = new ParameterDescriptor.Range((Object)"Enable", (Object)"Enable");
                ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable", (Object)"Disable");
                dprioranges.add(rangeEnable);
                dprioranges.add(rangeDisable);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(!this.getParameters().getP_pcie_phy().equals("Stratix V GX") && !this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP"));
                if (!this.isInRange(this.getParameters().getP_enable_pcie_hip_dprio().toString(), (IParameterDescriptor)enable_pcie_hip_dprio_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
                if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
            } else {
                dprioranges = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range rangeNA = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
                dprioranges.add(rangeNA);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("N/A");
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(true);
            Vector<ParameterDescriptor.Range> txrxranges5 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range range100MHZ5 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            ParameterDescriptor.Range range125MHZ4 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
            txrxranges5.add(range100MHZ5);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                txrxranges5.add(range125MHZ4);
            }
            txrx_clock_pd.setLegalRanges(txrxranges5);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (!family2.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STINGRAY.toString())) {
                String device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.STINGRAY).getDisplayName());
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Arria II GZ") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES")) {
            String device_family_mismatch_msg;
            Vector<ParameterDescriptor.Range> dprioranges;
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_pcie_gen2_x8_es().equals("0") && this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES")) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy("Stratix IV GX");
            }
            deviceFamily = this.getParameters().getP_pcie_phy();
            al2gxb_pd.setEnabled(true);
            channel_number_pd.setEnabled(true);
            rangeChannelNumber = new Vector();
            count = 0;
            while (count < 384) {
                rangeChannelNumber.add(new ParameterDescriptor.Range((Object)count, (Object)count));
                count = count + 4;
            }
            channel_number_pd.setLegalRanges(rangeChannelNumber);
            if (!this.isInRange(new Integer(this.getParameters().getP_pcie_channel_number()).toString(), (IParameterDescriptor)channel_number_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            }
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_fast_recovery(true);
            enable_fast_recovery_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyranges = new Vector<ParameterDescriptor.Range>();
            rangeSerial = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges.add(rangeSerial);
            phyInterface_pd.setLegalRanges(phyranges);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            family = this.getParameters().getModuleCore().getDeviceFamily();
            ranges = new Vector<ParameterDescriptor.Range>();
            rangex1 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            rangex4 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            ParameterDescriptor.Range rangex83 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x8, (Object)IPCIECompilerCoreParameters.ELaneOptions.x8);
            ranges.add(rangex1);
            ranges.add(rangex4);
            lanes_pd.setEnabled(true);
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                    if (this.getParameters().getP_pcie_rate().equals("Gen1 (2.5 Gbps)")) {
                        ranges.add(rangex83);
                    } else if (this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES")) {
                        ranges.add(rangex83);
                    }
                } else if (this.getParameters().getP_pcie_phy().equals("Stratix II GX")) {
                    ranges.add(rangex83);
                } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
                }
            } else if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)")) {
                    ranges.remove(rangex4);
                    lanes_pd.setEnabled(false);
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
                }
            } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            lanes_pd.setLegalRanges(ranges);
            if (!this.isInRange(this.getParameters().getP_pcie_number_of_lanes().toString(), (IParameterDescriptor)lanes_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(true);
            Vector<ParameterDescriptor.Range> txrxranges6 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range range100MHZ6 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            ParameterDescriptor.Range range125MHZ5 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
            txrxranges6.add(range100MHZ6);
            txrxranges6.add(range125MHZ5);
            if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)")) {
                txrxranges6.remove(range125MHZ5);
            }
            txrx_clock_pd.setLegalRanges(txrxranges6);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") && !((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                dprioranges = new Vector();
                ParameterDescriptor.Range rangeEnable = new ParameterDescriptor.Range((Object)"Enable", (Object)"Enable");
                ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable", (Object)"Disable");
                dprioranges.add(rangeEnable);
                dprioranges.add(rangeDisable);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(!this.getParameters().getP_pcie_phy().equals("Stratix V GX") && !this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP"));
                if (!this.isInRange(this.getParameters().getP_enable_pcie_hip_dprio().toString(), (IParameterDescriptor)enable_pcie_hip_dprio_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
                if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
            } else {
                dprioranges = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range rangeNA = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
                dprioranges.add(rangeNA);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("N/A");
            }
            if (this.getParameters().getP_pcie_phy().equals("Arria II GZ") && !family.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.ARRIAIIGZ.toString())) {
                device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.ARRIAIIGZ).getDisplayName());
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            } else if ((this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES")) && !family.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STRATIXIV.toString())) {
                device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.STRATIXIV).getDisplayName());
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
            deviceFamily = this.getParameters().getP_pcie_phy();
            al2gxb_pd.setEnabled(false);
            pcie_parity_pd.setEnabled(true);
            phyInterface_pd.setEnabled(false);
            phyranges2 = new Vector();
            rangeSerial2 = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges2.add(rangeSerial2);
            phyInterface_pd.setLegalRanges(phyranges2);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            family2 = this.getParameters().getModuleCore().getDeviceFamily();
            ranges2 = new Vector();
            rangex12 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            rangex42 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            rangex8 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x8, (Object)IPCIECompilerCoreParameters.ELaneOptions.x8);
            ranges2.add(rangex12);
            ranges2.add(rangex42);
            ranges2.add(rangex8);
            lanes_pd.setEnabled(true);
            lanes_pd.setLegalRanges(ranges2);
            if (!this.isInRange(this.getParameters().getP_pcie_number_of_lanes().toString(), (IParameterDescriptor)lanes_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(true);
            Vector<ParameterDescriptor.Range> txrxranges7 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range range100MHZ7 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            ParameterDescriptor.Range range125MHZ6 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
            txrxranges7.add(range100MHZ7);
            txrxranges7.add(range125MHZ6);
            if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)")) {
                txrxranges7.remove(range125MHZ6);
            }
            txrx_clock_pd.setLegalRanges(txrxranges7);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") && !((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                Vector<ParameterDescriptor.Range> dprioranges = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range rangeEnable = new ParameterDescriptor.Range((Object)"Enable", (Object)"Enable");
                ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable", (Object)"Disable");
                dprioranges.add(rangeEnable);
                dprioranges.add(rangeDisable);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(!this.getParameters().getP_pcie_phy().equals("Stratix V GX") && !this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP"));
                if (!this.isInRange(this.getParameters().getP_enable_pcie_hip_dprio().toString(), (IParameterDescriptor)enable_pcie_hip_dprio_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
                if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
            }
            if (!family2.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STRATIXV.toString())) {
                String device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.STRATIXV).getDisplayName());
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("HardCopy IV GX")) {
            Vector<ParameterDescriptor.Range> dprioranges;
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            deviceFamily = this.getParameters().getP_pcie_phy();
            al2gxb_pd.setEnabled(true);
            channel_number_pd.setEnabled(true);
            rangeChannelNumber = new Vector();
            count = 0;
            while (count < 384) {
                rangeChannelNumber.add(new ParameterDescriptor.Range((Object)count, (Object)count));
                count = count + 4;
            }
            channel_number_pd.setLegalRanges(rangeChannelNumber);
            if (!this.isInRange(new Integer(this.getParameters().getP_pcie_channel_number()).toString(), (IParameterDescriptor)channel_number_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            }
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_fast_recovery(true);
            enable_fast_recovery_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyranges = new Vector();
            rangeSerial = new ParameterDescriptor.Range((Object)"Serial", (Object)"Serial");
            phyranges.add(rangeSerial);
            phyInterface_pd.setLegalRanges(phyranges);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("Serial");
            family = this.getParameters().getModuleCore().getDeviceFamily();
            ranges = new Vector();
            rangex1 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            rangex4 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            ParameterDescriptor.Range rangex84 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x8, (Object)IPCIECompilerCoreParameters.ELaneOptions.x8);
            ranges.add(rangex1);
            ranges.add(rangex4);
            lanes_pd.setEnabled(true);
            if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                    ranges.add(rangex84);
                }
            } else if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)")) {
                    ranges.remove(rangex4);
                    lanes_pd.setEnabled(false);
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
                }
            } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            lanes_pd.setLegalRanges(ranges);
            if (!this.isInRange(this.getParameters().getP_pcie_number_of_lanes().toString(), (IParameterDescriptor)lanes_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_GX_Reference_Clock"));
            txrx_clock_pd.setEnabled(true);
            Vector<ParameterDescriptor.Range> txrxranges8 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range range100MHZ8 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
            ParameterDescriptor.Range range125MHZ7 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
            txrxranges8.add(range100MHZ8);
            txrxranges8.add(range125MHZ7);
            if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)")) {
                txrxranges8.remove(range125MHZ7);
            }
            txrx_clock_pd.setLegalRanges(txrxranges8);
            if (!this.isInRange(this.getParameters().getP_pcie_txrx_clock().toString(), (IParameterDescriptor)txrx_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("100 MHz");
            }
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") && !((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                dprioranges = new Vector();
                ParameterDescriptor.Range rangeEnable = new ParameterDescriptor.Range((Object)"Enable", (Object)"Enable");
                ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable", (Object)"Disable");
                dprioranges.add(rangeEnable);
                dprioranges.add(rangeDisable);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(!this.getParameters().getP_pcie_phy().equals("Stratix V GX") && !this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP"));
                if (!this.isInRange(this.getParameters().getP_enable_pcie_hip_dprio().toString(), (IParameterDescriptor)enable_pcie_hip_dprio_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
                if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("Disable");
                }
            } else {
                dprioranges = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range rangeNA = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
                dprioranges.add(rangeNA);
                enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
                enable_pcie_hip_dprio_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("N/A");
            }
            if (!family.getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.HARDCOPYIV.toString())) {
                String device_family_mismatch_msg = MVCConstants.getResourceString("PCIE_Device_Family_Mismatch.Message").replaceAll("phy_selection", deviceFamily);
                device_family_mismatch_msg = device_family_mismatch_msg.replaceAll("quartus_selection", DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.HARDCOPYIV).getDisplayName());
                this.addWarningMessage(device_family_mismatch_msg, EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("TI XIO1100")) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            al2gxb_pd.setEnabled(false);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            enable_fast_recovery_pd.setEnabled(true);
            phyInterface_pd.setEnabled(true);
            phyranges3 = new Vector();
            range16b_SDR = new ParameterDescriptor.Range((Object)"16 bit SDR w/TxClk", (Object)"16 bit SDR w/TxClk");
            ParameterDescriptor.Range range8b_DDR_SDR = new ParameterDescriptor.Range((Object)"8 bit DDR/SDR w/TxClk", (Object)"8 bit DDR/SDR w/TxClk");
            phyranges3.add(range8b_DDR_SDR);
            phyranges3.add(range16b_SDR);
            phyInterface_pd.setLegalRanges(phyranges3);
            if (!this.isInRange(this.getParameters().getP_pcie_phy_interface().toString(), (IParameterDescriptor)phyInterface_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("16 bit SDR w/TxClk");
            }
            ranges3 = new Vector();
            rangex13 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            ranges3.add(rangex13);
            lanes_pd.setEnabled(false);
            lanes_pd.setLegalRanges(ranges3);
            if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) || this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x4)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_Ext_PHY_Reference_Clock"));
            if (this.getParameters().getP_pcie_phy_interface().equals("8 bit SDR") || this.getParameters().getP_pcie_phy_interface().equals("8 bit SDR w/TxClk")) {
                txrx_clock_pd.setEnabled(false);
                txrxranges2 = new Vector();
                ParameterDescriptor.Range range250MHZ2 = new ParameterDescriptor.Range((Object)"250 MHz", (Object)"250 MHz");
                txrxranges2.add(range250MHZ2);
                txrx_clock_pd.setEnabled(false);
                txrx_clock_pd.setLegalRanges(txrxranges2);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("250 MHz");
            } else {
                txrxranges2 = new Vector();
                range100MHZ2 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
                range125MHZ2 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
                ParameterDescriptor.Range range156MHZ3 = new ParameterDescriptor.Range((Object)"156.25 MHz", (Object)"156.25 MHz");
                txrxranges2.add(range100MHZ2);
                txrxranges2.add(range125MHZ2);
                txrxranges2.add(range156MHZ3);
                txrx_clock_pd.setLegalRanges(txrxranges2);
                txrx_clock_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("125 MHz");
            }
        } else if (this.getParameters().getP_pcie_phy().equals("NXP PX1011A")) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            al2gxb_pd.setEnabled(false);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            enable_fast_recovery_pd.setEnabled(true);
            phyInterface_pd.setEnabled(false);
            phyInterface_pd.setEnabled(false);
            phyranges3 = new Vector();
            ParameterDescriptor.Range range8b_SDR_TX_CLK = new ParameterDescriptor.Range((Object)"8 bit SDR w/TxClk", (Object)"8 bit SDR w/TxClk");
            phyranges3.add(range8b_SDR_TX_CLK);
            phyInterface_pd.setLegalRanges(phyranges3);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("8 bit SDR w/TxClk");
            ranges4 = new Vector();
            rangex14 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            ranges4.add(rangex14);
            lanes_pd.setEnabled(false);
            lanes_pd.setLegalRanges(ranges4);
            if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) || this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x4)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_Ext_PHY_Reference_Clock"));
            if (this.getParameters().getP_pcie_phy_interface().equals("8 bit SDR") || this.getParameters().getP_pcie_phy_interface().equals("8 bit SDR w/TxClk")) {
                txrx_clock_pd.setEnabled(false);
                txrxranges = new Vector<ParameterDescriptor.Range>();
                range250MHZ = new ParameterDescriptor.Range((Object)"250 MHz", (Object)"250 MHz");
                txrxranges.add(range250MHZ);
                txrx_clock_pd.setEnabled(false);
                txrx_clock_pd.setLegalRanges(txrxranges);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("250 MHz");
            } else {
                txrxranges = new Vector();
                range100MHZ = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
                range125MHZ = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
                range156MHZ = new ParameterDescriptor.Range((Object)"156.25 MHz", (Object)"156.25 MHz");
                txrxranges.add(range100MHZ);
                txrxranges.add(range125MHZ);
                txrxranges.add(range156MHZ);
                txrx_clock_pd.setLegalRanges(txrxranges);
                txrx_clock_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("125 MHz");
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Genesys Logic GL9714")) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            al2gxb_pd.setEnabled(false);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            enable_fast_recovery_pd.setEnabled(true);
            phyInterface_pd.setEnabled(true);
            phyranges3 = new Vector();
            range16b_SDR = new ParameterDescriptor.Range((Object)"16 bit SDR", (Object)"16 bit SDR");
            ParameterDescriptor.Range range8b_SDR = new ParameterDescriptor.Range((Object)"8 bit SDR", (Object)"8 bit SDR");
            range8b_DDR = new ParameterDescriptor.Range((Object)"8 bit DDR", (Object)"8 bit DDR");
            phyranges3.add(range8b_SDR);
            phyranges3.add(range8b_DDR);
            phyranges3.add(range16b_SDR);
            phyInterface_pd.setLegalRanges(phyranges3);
            if (!this.isInRange(this.getParameters().getP_pcie_phy_interface().toString(), (IParameterDescriptor)phyInterface_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("8 bit DDR");
            }
            if (this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("16 bit SDR")) {
                lanes_pd.setEnabled(false);
                ranges2 = new Vector();
                rangex12 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
                ranges2.add(rangex12);
                lanes_pd.setLegalRanges(ranges2);
                if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) || this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x4)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
                }
            } else {
                lanes_pd.setEnabled(true);
                ranges2 = new Vector();
                rangex12 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
                rangex42 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
                ranges2.add(rangex12);
                ranges2.add(rangex42);
                if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
                }
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_Ext_PHY_Reference_Clock"));
            if (this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit SDR") || this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit SDR w/TxClk")) {
                txrxranges = new Vector();
                range250MHZ = new ParameterDescriptor.Range((Object)"250 MHz", (Object)"250 MHz");
                txrxranges.add(range250MHZ);
                txrx_clock_pd.setEnabled(false);
                txrx_clock_pd.setLegalRanges(txrxranges);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("250 MHz");
            } else {
                txrxranges = new Vector();
                range100MHZ = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
                range125MHZ = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
                range156MHZ = new ParameterDescriptor.Range((Object)"156.25 MHz", (Object)"156.25 MHz");
                txrxranges.add(range100MHZ);
                txrxranges.add(range125MHZ);
                txrxranges.add(range156MHZ);
                txrx_clock_pd.setLegalRanges(txrxranges);
                txrx_clock_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("125 MHz");
            }
        } else {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_use_parity(false);
            pcie_parity_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            al2gxb_pd.setEnabled(false);
            channel_number_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_channel_number(0);
            enable_fast_recovery_pd.setEnabled(true);
            phyInterface_pd.setEnabled(true);
            phyranges3 = new Vector();
            range16b_SDR = new ParameterDescriptor.Range((Object)"16 bit SDR", (Object)"16 bit SDR");
            ParameterDescriptor.Range range16b_SDR_TX_CLK = new ParameterDescriptor.Range((Object)"16 bit SDR w/TxClk", (Object)"16 bit SDR w/TxClk");
            range8b_DDR = new ParameterDescriptor.Range((Object)"8 bit DDR", (Object)"8 bit DDR");
            ParameterDescriptor.Range range8b_DDR_TX_CLK = new ParameterDescriptor.Range((Object)"8 bit DDR w/TxClk", (Object)"8 bit DDR w/TxClk");
            ParameterDescriptor.Range range8b_DDR_SDR_TX_CLK = new ParameterDescriptor.Range((Object)"8 bit DDR/SDR w/TxClk", (Object)"8 bit DDR/SDR w/TxClk");
            ParameterDescriptor.Range range8b_SDR = new ParameterDescriptor.Range((Object)"8 bit SDR", (Object)"8 bit SDR");
            ParameterDescriptor.Range range8b_SDR_TX_CLK = new ParameterDescriptor.Range((Object)"8 bit SDR w/TxClk", (Object)"8 bit SDR w/TxClk");
            phyranges3.add(range16b_SDR);
            phyranges3.add(range16b_SDR_TX_CLK);
            phyranges3.add(range8b_DDR);
            phyranges3.add(range8b_DDR_TX_CLK);
            phyranges3.add(range8b_DDR_SDR_TX_CLK);
            phyranges3.add(range8b_SDR);
            phyranges3.add(range8b_SDR_TX_CLK);
            phyInterface_pd.setLegalRanges(phyranges3);
            if (!this.isInRange(this.getParameters().getP_pcie_phy_interface().toString(), (IParameterDescriptor)phyInterface_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_phy_interface("8 bit DDR");
            }
            Vector<ParameterDescriptor.Range> ranges6 = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range rangex15 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x1, (Object)IPCIECompilerCoreParameters.ELaneOptions.x1);
            ParameterDescriptor.Range rangex45 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x4, (Object)IPCIECompilerCoreParameters.ELaneOptions.x4);
            ParameterDescriptor.Range rangex85 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ELaneOptions.x8, (Object)IPCIECompilerCoreParameters.ELaneOptions.x8);
            ranges6.add(rangex15);
            ranges6.add(rangex45);
            ranges6.add(rangex85);
            if ((this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit SDR") || this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit DDR")) && !this.getParameters().getP_pcie_custom_phy_x8().equalsIgnoreCase("0")) {
                lanes_pd.setEnabled(true);
                lanes_pd.setLegalRanges(ranges6);
                if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) || this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x4)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
                }
            } else if ((this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit SDR w/TxClk") || this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit DDR w/TxClk")) && !this.getParameters().getP_pcie_custom_phy_x8().equalsIgnoreCase("0")) {
                lanes_pd.setEnabled(true);
                lanes_pd.setLegalRanges(ranges6);
                if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) || this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x4)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x1);
                }
            } else {
                lanes_pd.setEnabled(true);
                ranges6.clear();
                ranges6.add(rangex15);
                ranges6.add(rangex45);
                lanes_pd.setLegalRanges(ranges6);
                if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                    ((PCIECompilerCoreParameters)this.parameters).setP_pcie_number_of_lanes(IPCIECompilerCoreParameters.ELaneOptions.x4);
                }
            }
            PCIEConfiguration.update_xcvr_ref_clk(MVCConstants.getResourceString("PCIE_Ext_PHY_Reference_Clock"));
            if (this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit SDR") || this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit SDR w/TxClk")) {
                txrx_clock_pd.setEnabled(false);
                Vector<ParameterDescriptor.Range> txrxranges9 = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range range250MHZ3 = new ParameterDescriptor.Range((Object)"250 MHz", (Object)"250 MHz");
                txrxranges9.add(range250MHZ3);
                txrx_clock_pd.setEnabled(false);
                txrx_clock_pd.setLegalRanges(txrxranges9);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("250 MHz");
            } else {
                Vector<ParameterDescriptor.Range> txrxranges10 = new Vector<ParameterDescriptor.Range>();
                ParameterDescriptor.Range range100MHZ9 = new ParameterDescriptor.Range((Object)"100 MHz", (Object)"100 MHz");
                ParameterDescriptor.Range range125MHZ8 = new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz");
                ParameterDescriptor.Range range156MHZ4 = new ParameterDescriptor.Range((Object)"156.25 MHz", (Object)"156.25 MHz");
                txrxranges10.add(range100MHZ9);
                txrxranges10.add(range125MHZ8);
                txrxranges10.add(range156MHZ4);
                txrx_clock_pd.setLegalRanges(txrxranges10);
                txrx_clock_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_txrx_clock("125 MHz");
            }
        }
        if (this.getParameters().getP_pcie_phy_interface().equalsIgnoreCase("8 bit DDR/SDR w/TxClk")) {
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_TI_PHY_DDR_SDR.Message"), EMessageID.ValidationRelated);
        }
        if (!this.getParameters().getP_pcie_enable_hip().equals("1")) {
            Vector<ParameterDescriptor.Range> dprioranges = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range rangeNA = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
            dprioranges.add(rangeNA);
            enable_pcie_hip_dprio_pd.setLegalRanges(dprioranges);
            enable_pcie_hip_dprio_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_enable_pcie_hip_dprio("N/A");
        }
        return true;
    }

    private boolean updatePortTypeAndBARs() {
        Vector<ParameterDescriptor.Range> rangesPortType;
        Vector<ParameterDescriptor.Range> rangesMaxRate;
        IParameterDescriptorInstance max_rate_pd = this.getParameterDescriptor("p_pcie_rate");
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
            if (this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Cyclone IV GX")) {
                rangesMaxRate = new Vector();
                rangesMaxRate.add(new ParameterDescriptor.Range((Object)"Gen1 (2.5 Gbps)", (Object)"Gen1 (2.5 Gbps)"));
                max_rate_pd.setLegalRanges(rangesMaxRate);
                max_rate_pd.setEnabled(false);
            } else {
                rangesMaxRate = new Vector();
                rangesMaxRate.add(new ParameterDescriptor.Range((Object)"Gen1 (2.5 Gbps)", (Object)"Gen1 (2.5 Gbps)"));
                rangesMaxRate.add(new ParameterDescriptor.Range((Object)"Gen2 (5.0 Gbps)", (Object)"Gen2 (5.0 Gbps)"));
                max_rate_pd.setLegalRanges(rangesMaxRate);
                max_rate_pd.setEnabled(true);
            }
        } else {
            rangesMaxRate = new Vector<ParameterDescriptor.Range>();
            rangesMaxRate.add(new ParameterDescriptor.Range((Object)"Gen1 (2.5 Gbps)", (Object)"Gen1 (2.5 Gbps)"));
            max_rate_pd.setLegalRanges(rangesMaxRate);
            max_rate_pd.setEnabled(false);
        }
        IParameterDescriptorInstance port_type_pd = this.getParameterDescriptor("p_pcie_port_type");
        if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
            rangesPortType = new Vector<ParameterDescriptor.Range>();
            rangesPortType.add(new ParameterDescriptor.Range((Object)"Native Endpoint", (Object)"Native Endpoint"));
            port_type_pd.setLegalRanges(rangesPortType);
            port_type_pd.setEnabled(false);
            if (!this.isInRange(this.getParameters().getValue("p_pcie_port_type", String.class).toString(), (IParameterDescriptor)port_type_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_port_type("Native Endpoint");
            }
        } else if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
            rangesPortType = new Vector();
            rangesPortType.add(new ParameterDescriptor.Range((Object)"Native Endpoint", (Object)"Native Endpoint"));
            rangesPortType.add(new ParameterDescriptor.Range((Object)"Legacy Endpoint", (Object)"Legacy Endpoint"));
            if (!this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                rangesPortType.add(new ParameterDescriptor.Range((Object)"Root Port", (Object)"Root Port"));
            }
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_root_port_endpoint_mode().equals("1")) {
                rangesPortType.add(new ParameterDescriptor.Range((Object)"Endpoint / Root Port", (Object)"Endpoint / Root Port"));
            }
            port_type_pd.setLegalRanges(rangesPortType);
            port_type_pd.setEnabled(true);
        } else {
            rangesPortType = new Vector();
            rangesPortType.add(new ParameterDescriptor.Range((Object)"Native Endpoint", (Object)"Native Endpoint"));
            rangesPortType.add(new ParameterDescriptor.Range((Object)"Legacy Endpoint", (Object)"Legacy Endpoint"));
            port_type_pd.setLegalRanges(rangesPortType);
            port_type_pd.setEnabled(true);
            if (!this.isInRange(this.getParameters().getValue("p_pcie_port_type", String.class).toString(), (IParameterDescriptor)port_type_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_port_type("Native Endpoint");
            }
        }
        boolean bLegacyEP = this.getParameters().getP_pcie_port_type().equals("Legacy Endpoint");
        boolean bRootPort = this.getParameters().getP_pcie_port_type().equals("Root Port");
        IParameterDescriptorInstance msi_message_pd = this.getParameterDescriptor("p_pcie_msi_message_64bits_address_capable");
        if (bLegacyEP) {
            msi_message_pd.setEnabled(true);
            PCIEConfiguration.update_PCIEBARHeading(false);
        } else if (bRootPort) {
            PCIEConfiguration.update_PCIEBARHeading(true);
        } else {
            PCIEConfiguration.update_PCIEBARHeading(false);
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_NEP_And_PCI_BAR_Type.Message"), EMessageID.ValidationRelated);
            msi_message_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_msi_message_64bits_address_capable(true);
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_Native_Endpoint_And_MSI_64bits.Message"), EMessageID.ValidationRelated);
        }
        ParameterDescriptor.Range rangePrefetchable64 = new ParameterDescriptor.Range((Object)"64-bit Prefetchable Memory", (Object)"64-bit Prefetchable Memory");
        ParameterDescriptor.Range rangePrefetchable32 = new ParameterDescriptor.Range((Object)"32-bit Prefetchable Memory", (Object)"32-bit Prefetchable Memory");
        ParameterDescriptor.Range rangeNonPrefetchable32 = new ParameterDescriptor.Range((Object)"32-bit Non-Prefetchable Memory", (Object)"32-bit Non-Prefetchable Memory");
        ParameterDescriptor.Range rangeIO = new ParameterDescriptor.Range((Object)"I/O Address Space", (Object)"I/O Address Space");
        ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable this and all higher BARs", (Object)"Disable this and all higher BARs");
        ParameterDescriptor.Range rangeDisablethisBAR = new ParameterDescriptor.Range((Object)"Disable this BAR", (Object)"Disable this BAR");
        ParameterDescriptor.Range rangeNA = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
        for (int i = 0; i < 6; ++i) {
            Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
            try {
                IParameterDescriptorInstance pcie_bar_type_pd = this.getParameterDescriptor("p_pcie_bar_type_bar_" + i);
                IParameterDescriptorInstance pcie_bar_used_pd = this.getParameterDescriptor("p_pcie_bar_used_bar_" + i);
                IParameterDescriptorInstance pcie_bar_size_pd = this.getParameterDescriptor("p_pcie_bar_size_bar_" + i);
                pcie_bar_type_pd.setEnabled(false);
                pcie_bar_used_pd.setEnabled(false);
                pcie_bar_size_pd.setEnabled(false);
                if (i < 1) {
                    if (bLegacyEP || bRootPort) {
                        ranges.add(rangePrefetchable64);
                        ranges.add(rangePrefetchable32);
                        ranges.add(rangeNonPrefetchable32);
                        ranges.add(rangeIO);
                    } else {
                        ranges.add(rangePrefetchable64);
                        ranges.add(rangeNonPrefetchable32);
                    }
                    pcie_bar_used_pd.setEnabled(true);
                    pcie_bar_type_pd.setEnabled(true);
                    IParameterDescriptorInstance pcie_next_bar_used_pd = this.getParameterDescriptor("p_pcie_bar_used_bar_" + (i + 1));
                    if (this.getParameters().getValue("p_pcie_bar_used_bar_" + (i + 1), Boolean.class).equals(true) && !pcie_next_bar_used_pd.isEnabled() && !this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("64-bit Prefetchable Memory") && !this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("Disable this and all higher BARs")) {
                        ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_1(this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class));
                        boolean flag = ((PCIECompilerCoreParameters)this.parameters).isP_pci_bar_0_prefetchable();
                        this.parameters.getModuleCore().setValue("p_pci_bar_1_prefetchable", flag);
                    }
                    pcie_bar_type_pd.setLegalRanges(ranges);
                } else if (i % 2 == 0) {
                    IParameterDescriptorInstance pcie_prev_bar_used_pd = this.getParameterDescriptor("p_pcie_bar_used_bar_" + (i - 1));
                    if (bLegacyEP) {
                        ranges.add(rangePrefetchable64);
                        ranges.add(rangePrefetchable32);
                        ranges.add(rangeNonPrefetchable32);
                        ranges.add(rangeIO);
                        ranges.add(rangeDisable);
                    } else if (!bRootPort) {
                        ranges.add(rangePrefetchable64);
                        ranges.add(rangeNonPrefetchable32);
                        ranges.add(rangeDisable);
                    }
                    if (bRootPort) {
                        pcie_bar_used_pd.setEnabled(false);
                        pcie_bar_type_pd.setEnabled(false);
                        if (i == 2) {
                            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_2("Disable this and all higher BARs");
                        } else {
                            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_4("Disable this and all higher BARs");
                        }
                    } else if (this.getParameters().getValue("p_pcie_bar_used_bar_" + (i - 1), Boolean.class).equals(true)) {
                        pcie_bar_used_pd.setEnabled(true);
                        pcie_bar_type_pd.setEnabled(true);
                    } else if (i == 2) {
                        ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_2("N/A");
                    } else {
                        ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_4("N/A");
                    }
                    IParameterDescriptorInstance pcie_next_bar_used_pd = this.getParameterDescriptor("p_pcie_bar_used_bar_" + (i + 1));
                    if (this.getParameters().getValue("p_pcie_bar_used_bar_" + (i + 1), Boolean.class).equals(true) && !pcie_next_bar_used_pd.isEnabled() && !this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("64-bit Prefetchable Memory") && !this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("Disable this and all higher BARs")) {
                        if (i == 2) {
                            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_3(this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class));
                            this.parameters.getModuleCore().setValue("p_pci_bar_3_prefetchable", this.getParameters().getValue("p_pci_bar_" + i + "_prefetchable", Boolean.TYPE));
                        } else {
                            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_bar_type_bar_5(this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class));
                            this.parameters.getModuleCore().setValue("p_pci_bar_5_prefetchable", this.getParameters().getValue("p_pci_bar_" + i + "_prefetchable", Boolean.TYPE));
                        }
                    }
                    pcie_bar_type_pd.setLegalRanges(ranges);
                } else {
                    if (this.getParameters().getValue("p_pcie_bar_used_bar_" + (i - 1), Boolean.class).equals(true) && this.getParameters().getValue("p_pcie_bar_type_bar_" + (i - 1), String.class).equals("64-bit Prefetchable Memory")) {
                        ranges.add(rangeDisable);
                        ranges.add(rangeNA);
                        if (this.getParameters().getValue("p_pcie_bar_used_bar_" + (i - 1), Boolean.class).equals(true)) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_type_bar_" + i, "N/A");
                        } else {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_type_bar_" + i, "Disable this and all higher BARs");
                        }
                    } else {
                        if (bLegacyEP) {
                            ranges.add(rangePrefetchable32);
                            ranges.add(rangeNonPrefetchable32);
                            ranges.add(rangeIO);
                            ranges.add(rangeDisable);
                        } else if (bRootPort) {
                            ranges.add(rangePrefetchable32);
                            ranges.add(rangeNonPrefetchable32);
                            ranges.add(rangeIO);
                            ranges.add(rangeDisable);
                        } else {
                            ranges.add(rangeNonPrefetchable32);
                            ranges.add(rangeDisable);
                        }
                        if (this.getParameters().getValue("p_pcie_bar_used_bar_" + (i - 1), Boolean.class).equals(true)) {
                            pcie_bar_used_pd.setEnabled(true);
                            pcie_bar_type_pd.setEnabled(true);
                        } else {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_type_bar_" + i, "Disable this and all higher BARs");
                        }
                    }
                    pcie_bar_type_pd.setLegalRanges(ranges);
                }
                if (!this.isInRange(this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).toString(), (IParameterDescriptor)pcie_bar_type_pd)) {
                    if (i < 1) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_type_bar_" + i, ((ParameterDescriptor.Range)pcie_bar_type_pd.getLegalRanges().get(0)).getHigh());
                    } else {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_type_bar_" + i, "Disable this and all higher BARs");
                    }
                }
                if (this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("Disable this and all higher BARs")) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_used_bar_" + i, false);
                } else {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_used_bar_" + i, true);
                }
                if (this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("N/A") || this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("Disable this and all higher BARs")) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "N/A");
                    continue;
                }
                if (this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("64-bit Prefetchable Memory")) {
                    if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) && this.getParameters().getP_pcie_enable_hip().equals("0")) {
                        pcie_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_BAR_x8_64BIT_SIZES));
                    } else {
                        pcie_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_BAR_64BIT_SIZES));
                    }
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_bar_size_bar_" + i, String.class).toString(), (IParameterDescriptor)pcie_bar_size_pd)) {
                        if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "Auto");
                        } else {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "256 MBytes - 28 bits");
                        }
                    }
                } else if (this.getParameters().getValue("p_pcie_bar_type_bar_" + i, String.class).equals("I/O Address Space")) {
                    if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) && this.getParameters().getP_pcie_enable_hip().equals("0")) {
                        pcie_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_BAR_x8_IO_SIZES));
                        if (!this.isInRange(this.getParameters().getValue("p_pcie_bar_size_bar_" + i, String.class).toString(), (IParameterDescriptor)pcie_bar_size_pd) || this.getParameters().getValue("p_pcie_bar_size_bar_" + i, String.class).equals("N/A")) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "4 KBytes - 12 bits");
                        }
                    } else {
                        pcie_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_BAR_IO_SIZES));
                        if (!this.isInRange(this.getParameters().getValue("p_pcie_bar_size_bar_" + i, String.class).toString(), (IParameterDescriptor)pcie_bar_size_pd) || this.getParameters().getValue("p_pcie_bar_size_bar_" + i, String.class).equals("N/A")) {
                            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "Auto");
                            } else {
                                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "256 Bytes - 8 bits");
                            }
                        }
                    }
                } else {
                    if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) && this.getParameters().getP_pcie_enable_hip().equals("0")) {
                        pcie_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_BAR_x8_32BIT_SIZES));
                    } else {
                        pcie_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_BAR_32BIT_SIZES));
                    }
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_bar_size_bar_" + i, String.class).toString(), (IParameterDescriptor)pcie_bar_size_pd)) {
                        if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "Auto");
                        } else {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_bar_size_bar_" + i, "256 KBytes - 18 bits");
                        }
                    }
                }
                pcie_bar_size_pd.setEnabled(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        ParameterDescriptor.Range rangeNA2 = new ParameterDescriptor.Range((Object)"N/A", (Object)"N/A");
        IParameterDescriptorInstance pcie_exp_bar_size_pd = this.getParameterDescriptor("p_pcie_exp_rom_bar_size");
        if (this.getParameters().isP_pcie_exp_rom_bar_used()) {
            if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) && this.getParameters().getP_pcie_enable_hip().equals("0")) {
                pcie_exp_bar_size_pd.setEnabled(false);
                pcie_exp_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_x8_SIP_EXP_ROM_BAR_SIZES));
            } else {
                pcie_exp_bar_size_pd.setEnabled(true);
                pcie_exp_bar_size_pd.setLegalRanges((Collection)this.getBarSizeRange(MVCConstants.PCI_EXP_ROM_BAR_SIZES));
            }
            if (!this.isInRange(this.getParameters().getValue("p_pcie_exp_rom_bar_size", String.class).toString(), (IParameterDescriptor)pcie_exp_bar_size_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_exp_rom_bar_size", "4 KBytes - 12 bits");
            }
            if (bRootPort = this.getParameters().getP_pcie_port_type().equals("Root Port")) {
                this.addWarningMessage("Expansion ROM should not be used in Root port mode", EMessageID.ValidationRelated);
            }
        } else {
            pcie_exp_bar_size_pd.setEnabled(false);
            ranges.clear();
            ranges.add(rangeNA2);
            pcie_exp_bar_size_pd.setLegalRanges(ranges);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_exp_rom_bar_size("N/A");
        }
        return true;
    }

    private boolean updateInternalClk() {
        IParameterDescriptorInstance pcie_internal_clock_pd = this.getParameterDescriptor("p_pcie_internal_clock");
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
            if (this.getParameters().getP_pcie_rate().equals("Gen1 (2.5 Gbps)")) {
                pcie_internal_clock_pd.setEnabled(true);
                if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x1.toString())) {
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x1));
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                } else if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x4.toString())) {
                    pcie_internal_clock_pd.setEnabled(false);
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                } else {
                    pcie_internal_clock_pd.setEnabled(false);
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                }
            } else if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x1.toString())) {
                pcie_internal_clock_pd.setEnabled(false);
                pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                }
            } else if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x4.toString())) {
                pcie_internal_clock_pd.setEnabled(false);
                if (this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128.toString())) {
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                } else {
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x8));
                }
            } else {
                pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x8));
            }
        } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x1)) {
            if (this.getParameters().getP_pcie_phy().equals("Stratix II GX") || this.getParameters().getP_pcie_phy().equals("Arria GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Cyclone IV GX") || this.getParameters().getP_pcie_phy().equals("Arria II GZ") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES") || this.getParameters().getP_pcie_phy().equals("HardCopy IV GX")) {
                pcie_internal_clock_pd.setEnabled(false);
                pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                }
            } else if (this.getParameters().getP_pcie_phy().equals("Stratix GX")) {
                IParameterDescriptorInstance pcie_itxrx_clock_pd = this.getParameterDescriptor("p_pcie_txrx_clock");
                if (this.getParameters().getP_pcie_txrx_clock().equals("100 MHz")) {
                    pcie_internal_clock_pd.setEnabled(true);
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x1));
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                } else if (this.getParameters().getP_pcie_txrx_clock().equals("125 MHz")) {
                    pcie_internal_clock_pd.setEnabled(false);
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                } else if (this.getParameters().getP_pcie_txrx_clock().equals("156.25 MHz")) {
                    pcie_internal_clock_pd.setEnabled(false);
                    pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                }
            } else {
                pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x1));
                if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                }
                pcie_internal_clock_pd.setEnabled(true);
            }
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_x1_ORDERING_CODE.Message"), EMessageID.ValidationRelated);
        } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x4)) {
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_x4_ORDERING_CODE.Message"), EMessageID.ValidationRelated);
            pcie_internal_clock_pd.setEnabled(false);
            pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
            if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
            }
        } else if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_x8_ORDERING_CODE.Message"), EMessageID.ValidationRelated);
            pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x8));
            if (!this.isInRange(this.getParameters().getValue("p_pcie_internal_clock", String.class).toString(), (IParameterDescriptor)pcie_internal_clock_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "250 MHz");
            }
            pcie_internal_clock_pd.setEnabled(false);
        }
        return true;
    }

    private boolean updateCoreType() {
        IParameterDescriptorInstance enable_hip_pd = this.getParameterDescriptor("p_pcie_enable_hip");
        IDeviceFamily family = this.getParameters().getModuleCore().getDeviceFamily();
        if (this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES") || this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Cyclone IV GX") || this.getParameters().getP_pcie_phy().equals("HardCopy IV GX")) {
            enable_hip_pd.setEnabled(true);
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Arria II GZ") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("1");
            enable_hip_pd.setEnabled(false);
        } else {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_hip("0");
            enable_hip_pd.setEnabled(false);
        }
        return true;
    }

    private boolean validateALTGX() {
        boolean result = true;
        Map<String, String> myMap = this.getParameters().getP_pcie_altgx_keyParameters_used();
        for (String key : myMap.keySet()) {
            if (myMap.get(key).equalsIgnoreCase(this.getParameters().getModuleCore().getValueString(key))) continue;
            result = false;
            break;
        }
        IMegawizardGenerateQmegawizFiles qmegawizFilesExtension = this.getParameters().getModuleCore().getExtension(IMegawizardGenerateQmegawizFiles.class);
        if (!result) {
            this.addWarningMessage("The transceiver block setting has been reset to default values.", EMessageID.ValidationRelated);
            if (qmegawizFilesExtension != null) {
                qmegawizFilesExtension.forceUpdate(true);
            }
        } else if (qmegawizFilesExtension != null) {
            qmegawizFilesExtension.forceUpdate(false);
        }
        return true;
    }

    private boolean updateApplicationInterface() {
        IParameterDescriptorInstance pcie_app_interface = this.getParameterDescriptor("p_pcie_app_signal_interface");
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        ParameterDescriptor.Range rangeAvalonST256 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256, (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256);
        ParameterDescriptor.Range rangeAvalonST128 = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128, (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128);
        ParameterDescriptor.Range rangeAvalonST = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST, (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST);
        ParameterDescriptor.Range rangeAvalonMM = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonMM, (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonMM);
        ParameterDescriptor.Range rangeLegacy = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.Legacy, (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.Legacy);
        ParameterDescriptor.Range rangeTLBypass = new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.TLBypass, (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.TLBypass);
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                pcie_app_interface.setEnabled(false);
                ranges.add(rangeAvalonMM);
                pcie_app_interface.setLegalRanges(ranges);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonMM);
            } else {
                pcie_app_interface.setEnabled(true);
                ranges.add(rangeAvalonST);
                if (!this.getParameters().getP_pcie_phy().equals("Cyclone IV GX")) {
                    ranges.add(rangeLegacy);
                }
                pcie_app_interface.setLegalRanges(ranges);
                if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.Legacy);
                }
            }
            IParameterDescriptorInstance pcie_test_out_width = this.getParameterDescriptor("p_pcie_test_out_width");
            Vector<ParameterDescriptor.Range> test_out_width_range = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range rangeNone = new ParameterDescriptor.Range((Object)"None", (Object)"None");
            ParameterDescriptor.Range range9bits = new ParameterDescriptor.Range((Object)"9 bits", (Object)"9 bits");
            ParameterDescriptor.Range range128bits = new ParameterDescriptor.Range((Object)"128 bits", (Object)"128 bits");
            ParameterDescriptor.Range range512bits = new ParameterDescriptor.Range((Object)"512 bits", (Object)"512 bits");
            if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x8.toString())) {
                pcie_test_out_width.setEnabled(true);
                test_out_width_range.add(rangeNone);
                test_out_width_range.add(range9bits);
                test_out_width_range.add(range128bits);
                pcie_test_out_width.setLegalRanges(test_out_width_range);
                if (!this.isInRange(this.getParameters().getValue("p_pcie_test_out_width", String.class).toString(), (IParameterDescriptor)pcie_test_out_width)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_test_out_width", "9 bits");
                }
            } else {
                pcie_test_out_width.setEnabled(true);
                test_out_width_range.add(rangeNone);
                test_out_width_range.add(range9bits);
                test_out_width_range.add(range512bits);
                pcie_test_out_width.setLegalRanges(test_out_width_range);
                if (!this.isInRange(this.getParameters().getValue("p_pcie_test_out_width", String.class).toString(), (IParameterDescriptor)pcie_test_out_width)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_test_out_width", "9 bits");
                }
            }
        } else {
            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                pcie_app_interface.setEnabled(false);
                ranges.add(rangeAvalonMM);
                pcie_app_interface.setLegalRanges(ranges);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonMM);
            } else {
                if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_tl_bypass_mode().equals("1")) {
                    ranges.add(rangeTLBypass);
                }
                IParameterDescriptorInstance pcie_internal_clock_pd = this.getParameterDescriptor("p_pcie_internal_clock");
                if (this.getParameters().getP_pcie_rate().equals("Gen1 (2.5 Gbps)")) {
                    if (!this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x8.toString())) {
                        ranges.add(rangeAvalonST);
                        pcie_app_interface.setLegalRanges(ranges);
                        if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST);
                        }
                    } else if (this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Arria II GZ")) {
                        ranges.add(rangeAvalonST128);
                        pcie_app_interface.setLegalRanges(ranges);
                        if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128);
                        }
                    } else {
                        ranges.add(rangeAvalonST);
                        ranges.add(rangeAvalonST128);
                        pcie_app_interface.setLegalRanges(ranges);
                        if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST);
                        }
                        pcie_internal_clock_pd.setEnabled(false);
                        if (this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST.toString())) {
                            pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x8));
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "250 MHz");
                        } else {
                            pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                        }
                    }
                } else if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x1.toString())) {
                    ranges.add(rangeAvalonST);
                    pcie_app_interface.setLegalRanges(ranges);
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST);
                    }
                } else if (this.getParameters().getValue("p_pcie_number_of_lanes", IPCIECompilerCoreParameters.ELaneOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.ELaneOptions.x4.toString())) {
                    if (!this.getParameters().getP_pcie_phy().equals("Arria II GZ")) {
                        ranges.add(rangeAvalonST);
                    }
                    ranges.add(rangeAvalonST128);
                    pcie_app_interface.setLegalRanges(ranges);
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)(!this.getParameters().getP_pcie_phy().equals("Arria II GZ") ? IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST : IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128));
                    }
                } else if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    ranges.add(rangeAvalonST256);
                    ranges.add(rangeAvalonST128);
                    pcie_app_interface.setLegalRanges(ranges);
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256);
                    }
                    if (this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString().equalsIgnoreCase(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256.toString())) {
                        pcie_internal_clock_pd.setLegalRanges((Collection)this.getClkFrequency(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4));
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_internal_clock", "125 MHz");
                    }
                } else {
                    ranges.add(rangeAvalonST128);
                    pcie_app_interface.setLegalRanges(ranges);
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_app_signal_interface", IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.class).toString(), (IParameterDescriptor)pcie_app_interface)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128);
                    }
                }
                if (pcie_app_interface.getLegalRanges().size() > 1) {
                    pcie_app_interface.setEnabled(true);
                } else {
                    pcie_app_interface.setEnabled(false);
                }
            }
            IParameterDescriptorInstance pcie_test_out_width = this.getParameterDescriptor("p_pcie_test_out_width");
            Vector<ParameterDescriptor.Range> test_out_width_range = new Vector<ParameterDescriptor.Range>();
            ParameterDescriptor.Range rangeNone = new ParameterDescriptor.Range((Object)"None", (Object)"None");
            ParameterDescriptor.Range range9bits = new ParameterDescriptor.Range((Object)"9 bits", (Object)"9 bits");
            ParameterDescriptor.Range range64bits = new ParameterDescriptor.Range((Object)"64 bits", (Object)"64 bits");
            pcie_test_out_width.setEnabled(true);
            test_out_width_range.add(rangeNone);
            test_out_width_range.add(range9bits);
            test_out_width_range.add(range64bits);
            pcie_test_out_width.setLegalRanges(test_out_width_range);
            if (!this.isInRange(this.getParameters().getValue("p_pcie_test_out_width", String.class).toString(), (IParameterDescriptor)pcie_test_out_width)) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_test_out_width", "9 bits");
            }
        }
        return true;
    }

    private boolean updateGeneralCapabilities() {
        IParameterDescriptorInstance pcie_tag_supported = this.getParameterDescriptor("p_pcie_tag_supported");
        IParameterDescriptorInstance pcie_enable_completion_timeout_disable = this.getParameterDescriptor("p_pcie_enable_completion_timeout_disable");
        IParameterDescriptorInstance pcie_completion_timeout = this.getParameterDescriptor("p_pcie_completion_timeout");
        IParameterDescriptorInstance pcie_dll_active_report_support = this.getParameterDescriptor("p_pcie_dll_active_report_support");
        IParameterDescriptorInstance pcie_surprise_down_error_support = this.getParameterDescriptor("p_pcie_surprise_down_error_support");
        IParameterDescriptorInstance pcie_use_crc_forwarding = this.getParameterDescriptor("p_pcie_use_crc_forwarding");
        IParameterDescriptorInstance pcie_enable_function_msix_support = this.getParameterDescriptor("p_pcie_enable_function_msix_support");
        IParameterDescriptorInstance pcie_enable_slot_capability = this.getParameterDescriptor("p_pcie_enable_slot_capability");
        boolean bNativeEndpointRootPort = this.getParameters().getP_pcie_port_type().equals("Endpoint / Root Port");
        boolean bLegacyEndpoint = this.getParameters().getP_pcie_port_type().equals("Legacy Endpoint");
        boolean bNativeEndpoint = this.getParameters().getP_pcie_port_type().equals("Native Endpoint");
        boolean bRootPort = this.getParameters().getP_pcie_port_type().equals("Root Port");
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_completion_timeout_disable", false);
            pcie_enable_completion_timeout_disable.setEnabled(false);
            pcie_completion_timeout.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_dll_active_report_support", false);
            pcie_dll_active_report_support.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_surprise_down_error_support", false);
            pcie_surprise_down_error_support.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_use_crc_forwarding", false);
            pcie_use_crc_forwarding.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_function_msix_support", false);
            pcie_enable_function_msix_support.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_slot_capability", false);
            pcie_enable_slot_capability.setEnabled(false);
            if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                pcie_tag_supported.setLegalRanges((Collection)this.getTagOptions(MVCConstants.STRATIX_II_x8_TAG_OPTIONS));
                pcie_tag_supported.setEnabled(true);
                if (!this.isInRange(this.getParameters().getValue("p_pcie_tag_supported", Integer.class).toString(), (IParameterDescriptor)pcie_tag_supported)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_tag_supported", 32);
                }
            } else {
                pcie_tag_supported.setLegalRanges((Collection)this.getTagOptions(MVCConstants.TAG_OPTIONS));
                pcie_tag_supported.setEnabled(true);
            }
        } else {
            IParameterDescriptorInstance pcie_msix_table_bir = this.getParameterDescriptor("ui_pcie_msix_table_bir");
            IParameterDescriptorInstance pcie_msix_pba_bir = this.getParameterDescriptor("ui_pcie_msix_pba_bir");
            if (MVCConstants.getResourceString("PCIE_Use_Rule_Based_XML").equalsIgnoreCase("0")) {
                Vector<ParameterDescriptor.Range> rangesCompTimeout;
                if (bRootPort || bNativeEndpointRootPort) {
                    pcie_dll_active_report_support.setEnabled(true);
                    pcie_surprise_down_error_support.setEnabled(true);
                } else {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_surprise_down_error_support", false);
                    pcie_surprise_down_error_support.setEnabled(false);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_dll_active_report_support", false);
                    pcie_dll_active_report_support.setEnabled(false);
                }
                pcie_tag_supported.setLegalRanges((Collection)this.getTagOptions(MVCConstants.HIP_TAG_OPTIONS));
                pcie_tag_supported.setEnabled(true);
                if (!this.isInRange(this.getParameters().getValue("p_pcie_tag_supported", Integer.class).toString(), (IParameterDescriptor)pcie_tag_supported)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_tag_supported", 32);
                }
                if (this.getParameters().getP_pcie_version().toString().equalsIgnoreCase("2.0") || this.getParameters().getP_pcie_version().toString().equalsIgnoreCase("2.1")) {
                    rangesCompTimeout = new Vector<ParameterDescriptor.Range>();
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"NONE", (Object)"NONE"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"ABCD", (Object)"ABCD"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"BCD", (Object)"BCD"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"ABC", (Object)"ABC"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"BC", (Object)"BC"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"AB", (Object)"AB"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"B", (Object)"B"));
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"A", (Object)"A"));
                    pcie_completion_timeout.setLegalRanges(rangesCompTimeout);
                    pcie_completion_timeout.setEnabled(true);
                    if (bNativeEndpoint || bLegacyEndpoint) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_completion_timeout_disable", true);
                        pcie_enable_completion_timeout_disable.setEnabled(false);
                    } else {
                        pcie_enable_completion_timeout_disable.setEnabled(true);
                    }
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_completion_timeout", String.class).toString(), (IParameterDescriptor)pcie_completion_timeout)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_timeout", "NONE");
                    }
                    if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                        rangesCompTimeout = new Vector();
                        rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"None".toUpperCase(), (Object)"None".toUpperCase()));
                        pcie_completion_timeout.setLegalRanges(rangesCompTimeout);
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_timeout", "None".toUpperCase());
                        pcie_completion_timeout.setEnabled(false);
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_completion_timeout_disable", true);
                        pcie_enable_completion_timeout_disable.setEnabled(false);
                    }
                } else {
                    rangesCompTimeout = new Vector();
                    rangesCompTimeout.add(new ParameterDescriptor.Range((Object)"None".toUpperCase(), (Object)"None".toUpperCase()));
                    pcie_completion_timeout.setLegalRanges(rangesCompTimeout);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_timeout", "None".toUpperCase());
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_completion_timeout_disable", false);
                    pcie_enable_completion_timeout_disable.setEnabled(false);
                    pcie_completion_timeout.setEnabled(false);
                }
                if (this.getParameters().getValue("p_pcie_enable_completion_timeout_disable", Boolean.TYPE).equals(true)) {
                    if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                        pcie_completion_timeout.setEnabled(false);
                    } else {
                        pcie_completion_timeout.setEnabled(true);
                    }
                } else {
                    pcie_completion_timeout.setEnabled(false);
                }
            } else {
                pcie_dll_active_report_support.setEnabled(true);
                pcie_surprise_down_error_support.setEnabled(true);
            }
            if (bRootPort || bNativeEndpointRootPort) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_function_msix_support", false);
                pcie_enable_function_msix_support.setEnabled(false);
                pcie_enable_slot_capability.setEnabled(true);
            } else {
                pcie_enable_function_msix_support.setEnabled(true);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_slot_capability", false);
                pcie_enable_slot_capability.setEnabled(false);
            }
            Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
            for (int i = 0; i <= 5; ++i) {
                boolean isPCIBARUsed = PCIEUIValidatorSystemSettings.isBarUsed(i, this.parameters);
                boolean is64bitsBAR = false;
                is64bitsBAR = i > 0 && (i == 1 || i == 3 || i == 5) ? PCIEUIValidatorSystemSettings.isBAR64Bit(i - 1, this.parameters) : PCIEUIValidatorSystemSettings.isBAR64Bit(i, this.parameters);
                if (is64bitsBAR && (i == 1 || i == 3 || i == 5)) {
                    isPCIBARUsed = false;
                }
                if (!isPCIBARUsed) continue;
                if (is64bitsBAR && i == 0) {
                    ranges.add(new ParameterDescriptor.Range((Object)"1:0", (Object)"1:0"));
                    continue;
                }
                if (is64bitsBAR && i == 2) {
                    ranges.add(new ParameterDescriptor.Range((Object)"3:2", (Object)"3:2"));
                    continue;
                }
                if (is64bitsBAR && i == 4) {
                    ranges.add(new ParameterDescriptor.Range((Object)"5:4", (Object)"5:4"));
                    continue;
                }
                ranges.add(new ParameterDescriptor.Range((Object)Integer.toString(i), (Object)Integer.toString(i)));
            }
            pcie_msix_table_bir.setLegalRanges(ranges);
            if (!this.isInRange(this.getParameters().getValue("ui_pcie_msix_table_bir", String.class).toString(), (IParameterDescriptor)pcie_msix_table_bir)) {
                String defaultValue = null;
                Iterator iterator = ranges.iterator();
                if (iterator.hasNext()) {
                    Object item = iterator.next();
                    defaultValue = ((ParameterDescriptor.Range)item).getLow().toString();
                }
                ((PCIECompilerCoreParameters)this.parameters).setValue("ui_pcie_msix_table_bir", defaultValue);
            }
            pcie_msix_pba_bir.setLegalRanges(ranges);
            if (!this.isInRange(this.getParameters().getValue("ui_pcie_msix_pba_bir", String.class).toString(), (IParameterDescriptor)pcie_msix_pba_bir)) {
                String defaultValue = null;
                Iterator iterator = ranges.iterator();
                if (iterator.hasNext()) {
                    Object item = iterator.next();
                    defaultValue = ((ParameterDescriptor.Range)item).getLow().toString();
                }
                ((PCIECompilerCoreParameters)this.parameters).setValue("ui_pcie_msix_pba_bir", defaultValue);
            }
            if (this.getParameters().isP_pcie_underSOPCBuilder()) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_use_crc_forwarding", false);
                pcie_use_crc_forwarding.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_enable_function_msix_support", false);
                pcie_enable_function_msix_support.setEnabled(false);
            }
        }
        IParameterDescriptorInstance pcie_link_common_clock = this.getParameterDescriptor("p_pcie_link_common_clock");
        if (!this.getParameters().getValue("p_pcie_rate_match_fifo", Boolean.class).booleanValue() && (this.getParameters().getP_pcie_phy().equals("Stratix II GX") || this.getParameters().getP_pcie_phy().equals("Arria GX"))) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_link_common_clock(true);
            pcie_link_common_clock.setEnabled(false);
        } else {
            pcie_link_common_clock.setEnabled(true);
        }
        this.updateSlotCapability();
        IParameterDescriptorInstance pcie_ecrc_check = this.getParameterDescriptor("p_pcie_ecrc_check");
        IParameterDescriptorInstance pcie_ecrc_generation = this.getParameterDescriptor("p_pcie_ecrc_generation");
        if (this.getParameters().isP_pcie_advanced_error_reporting()) {
            pcie_ecrc_check.setEnabled(true);
            pcie_ecrc_generation.setEnabled(true);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1") && !this.getParameters().isP_pcie_underSOPCBuilder()) {
                pcie_use_crc_forwarding.setEnabled(true);
            }
        } else {
            pcie_ecrc_check.setEnabled(false);
            pcie_ecrc_generation.setEnabled(false);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                pcie_use_crc_forwarding.setEnabled(false);
            }
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_ecrc_check", false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_ecrc_generation", false);
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_use_crc_forwarding", false);
            }
        }
        this.updateMSIxCapabilities();
        IParameterDescriptorInstance p_pcie_msi_message_requested = this.getParameterDescriptor("p_pcie_msi_message_requested");
        if (this.getParameters().isP_pcie_underSOPCBuilder()) {
            pcie_tag_supported.setLegalRanges((Collection)this.getTagOptions(MVCConstants.SOPC_TAG_OPTIONS));
            pcie_tag_supported.setEnabled(false);
            p_pcie_msi_message_requested.setEnabled(true);
        }
        return true;
    }

    private boolean updateSlotCapability() {
        IParameterDescriptorInstance pcie_slot_capabilities = this.getParameterDescriptor("p_pcie_slot_capabilities");
        if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_enable_slot_capability()) {
            pcie_slot_capabilities.setEnabled(false);
        } else {
            pcie_slot_capabilities.setEnabled(true);
        }
        return true;
    }

    private boolean updateMSIxCapabilities() {
        IParameterDescriptorInstance pcie_msix_table_bir = this.getParameterDescriptor("ui_pcie_msix_table_bir");
        IParameterDescriptorInstance pcie_msix_table_offset = this.getParameterDescriptor("p_pcie_msix_table_offset");
        IParameterDescriptorInstance pcie_msix_table_size = this.getParameterDescriptor("p_pcie_msix_table_size");
        IParameterDescriptorInstance pcie_msix_pba_bir = this.getParameterDescriptor("ui_pcie_msix_pba_bir");
        IParameterDescriptorInstance pcie_msix_pba_offset = this.getParameterDescriptor("p_pcie_msix_pba_offset");
        if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_enable_function_msix_support()) {
            pcie_msix_table_bir.setEnabled(false);
            pcie_msix_table_offset.setEnabled(false);
            pcie_msix_table_size.setEnabled(false);
            pcie_msix_pba_bir.setEnabled(false);
            pcie_msix_pba_offset.setEnabled(false);
        } else {
            pcie_msix_table_bir.setEnabled(true);
            pcie_msix_table_offset.setEnabled(true);
            pcie_msix_table_size.setEnabled(true);
            pcie_msix_pba_bir.setEnabled(true);
            pcie_msix_pba_offset.setEnabled(true);
        }
        return true;
    }

    private static boolean isBarPrefetchable(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.isP_pci_bar_0_prefetchable();
            }
            case 1: {
                return parameters.isP_pci_bar_1_prefetchable();
            }
            case 2: {
                return parameters.isP_pci_bar_2_prefetchable();
            }
            case 3: {
                return parameters.isP_pci_bar_3_prefetchable();
            }
            case 4: {
                return parameters.isP_pci_bar_4_prefetchable();
            }
            case 5: {
                return parameters.isP_pci_bar_5_prefetchable();
            }
        }
        return false;
    }

    private static boolean isBAR64Bit(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.getP_pcie_bar_type_bar_0().substring(0, 2).equalsIgnoreCase("64");
            }
            case 1: {
                return parameters.getP_pcie_bar_type_bar_1().substring(0, 2).equalsIgnoreCase("64");
            }
            case 2: {
                return parameters.getP_pcie_bar_type_bar_2().substring(0, 2).equalsIgnoreCase("64");
            }
            case 3: {
                return parameters.getP_pcie_bar_type_bar_3().substring(0, 2).equalsIgnoreCase("64");
            }
            case 4: {
                return parameters.getP_pcie_bar_type_bar_4().substring(0, 2).equalsIgnoreCase("64");
            }
            case 5: {
                return parameters.getP_pcie_bar_type_bar_5().substring(0, 2).equalsIgnoreCase("64");
            }
        }
        return false;
    }

    private static boolean isBarUsed(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.isP_pcie_bar_used_bar_0();
            }
            case 1: {
                return parameters.isP_pcie_bar_used_bar_1();
            }
            case 2: {
                return parameters.isP_pcie_bar_used_bar_2();
            }
            case 3: {
                return parameters.isP_pcie_bar_used_bar_3();
            }
            case 4: {
                return parameters.isP_pcie_bar_used_bar_4();
            }
            case 5: {
                return parameters.isP_pcie_bar_used_bar_5();
            }
        }
        return false;
    }

    private boolean validateReadOnlyRegisters() {
        IParameterDescriptorInstance pcie_vendor_id_pd = this.getParameterDescriptor("p_pcie_vendor_id");
        String currentValue = this.getParameters().getValue("p_pcie_vendor_id", String.class);
        if (currentValue.equalsIgnoreCase("0xFFFF")) {
            pcie_vendor_id_pd.setRelatedToError(true);
            this.addErrorMessage("Value specified for " + MVCConstants.getResourceString("PCI_Read_Only_Register_4") + " is out of legal range 0x0000 to 0xFFFE.", EMessageID.ValidationRelated);
        }
        IParameterDescriptorInstance pcie_subsystem_vendor_pd = this.getParameterDescriptor("p_pcie_subsystem_vendor_id");
        currentValue = this.getParameters().getValue("p_pcie_subsystem_vendor_id", String.class);
        if (currentValue.equals("0xFFFF")) {
            pcie_subsystem_vendor_pd.setRelatedToError(true);
            this.addErrorMessage("Value specified for " + MVCConstants.getResourceString("PCI_Read_Only_Register_5") + " is out of legal range 0x0000 to 0xFFFE.", EMessageID.ValidationRelated);
        }
        boolean bRootPort = this.getParameters().getP_pcie_port_type().equals("Root Port");
        boolean bNativeEndpointRootPort = this.getParameters().getP_pcie_port_type().equals("Endpoint / Root Port");
        IParameterDescriptorInstance pcie_subsystem_pd = this.getParameterDescriptor("p_pcie_subsystem_device_id");
        IParameterDescriptorInstance pcie_iobaseAndlimit_pd = this.getParameterDescriptor("p_pcie_io_base_and_limit_register");
        IParameterDescriptorInstance pcie_membaseAndlimit_pd = this.getParameterDescriptor("p_pcie_mem_base_and_limit_register");
        if (!bRootPort) {
            if (!bNativeEndpointRootPort) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_io_base_and_limit_register", (Object)IPCIECompilerCoreParameters.EIORegisterOptions.IODisable);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_mem_base_and_limit_register", (Object)IPCIECompilerCoreParameters.EMemRegisterOptions.MemDisable);
                pcie_iobaseAndlimit_pd.setEnabled(false);
                pcie_membaseAndlimit_pd.setEnabled(false);
            }
            pcie_subsystem_pd.setEnabled(true);
            pcie_subsystem_vendor_pd.setEnabled(true);
        } else {
            pcie_subsystem_pd.setEnabled(false);
            pcie_subsystem_vendor_pd.setEnabled(false);
            pcie_iobaseAndlimit_pd.setEnabled(true);
            pcie_membaseAndlimit_pd.setEnabled(true);
        }
        return true;
    }

    private boolean updateBufferSetupPage() {
        Vector<ParameterDescriptor.Range> range;
        IParameterDescriptorInstance p_pcie_max_payload_size = this.getParameterDescriptor("p_pcie_max_payload_size");
        p_pcie_max_payload_size.setEnabled(true);
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
            if (this.getParameters().isP_pcie_underSOPCBuilder()) {
                ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
            } else {
                ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes", (Object)"512 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 KByte", (Object)"1 KByte"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes", (Object)"2 KBytes"));
            }
        } else if (this.getParameters().isP_pcie_underSOPCBuilder()) {
            ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
        } else if (this.getParameters().getP_pcie_phy().equals("Arria II GX")) {
            ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
        } else if (this.getParameters().getP_pcie_phy().equals("Cyclone IV GX")) {
            ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES") || this.getParameters().getP_pcie_phy().equals("Arria II GZ") || this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
            ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes", (Object)"512 Bytes"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 KByte", (Object)"1 KByte"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes", (Object)"2 KBytes"));
        } else if (this.getParameters().getP_pcie_phy().equals("HardCopy IV GX")) {
            if (this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)") && this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes", (Object)"512 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 KByte", (Object)"1 KByte"));
            } else {
                ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes", (Object)"128 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes", (Object)"256 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes", (Object)"512 Bytes"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 KByte", (Object)"1 KByte"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes", (Object)"2 KBytes"));
            }
        }
        p_pcie_max_payload_size.setLegalRanges(ranges);
        if (!this.isInRange(this.getParameters().getValue("p_pcie_max_payload_size", String.class), (IParameterDescriptor)p_pcie_max_payload_size)) {
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_max_payload_size", "128 Bytes");
        }
        IParameterDescriptorInstance pcie_virutal_channels_pd = this.getParameterDescriptor("p_pcie_virutal_channels");
        if (this.getParameters().isP_pcie_underSOPCBuilder() || this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Cyclone IV GX")) {
            range = new Vector<ParameterDescriptor.Range>();
            range.add(new ParameterDescriptor.Range((Object)1, (Object)1));
            pcie_virutal_channels_pd.setLegalRanges(range);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_virutal_channels", 1);
            pcie_virutal_channels_pd.setEnabled(false);
        } else if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
            pcie_virutal_channels_pd.setEnabled(true);
            if (this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
                range = new Vector();
                range.add(new ParameterDescriptor.Range((Object)1, (Object)1));
                range.add(new ParameterDescriptor.Range((Object)2, (Object)2));
                pcie_virutal_channels_pd.setLegalRanges(range);
                if (!this.isInRange(this.getParameters().getValue("p_pcie_virutal_channels", Integer.class).toString(), (IParameterDescriptor)pcie_virutal_channels_pd)) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_virutal_channels", 1);
                }
            } else {
                range = new Vector();
                range.add(new ParameterDescriptor.Range((Object)1, (Object)1));
                range.add(new ParameterDescriptor.Range((Object)2, (Object)2));
                pcie_virutal_channels_pd.setLegalRanges(range);
            }
        } else if (MVCConstants.getResourceString("PCIE_Use_Rule_Based_XML").equalsIgnoreCase("0")) {
            range = new Vector();
            if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP") || this.getParameters().getP_pcie_phy().equals("Arria II GZ")) {
                range.add(new ParameterDescriptor.Range((Object)1, (Object)1));
                pcie_virutal_channels_pd.setLegalRanges(range);
                pcie_virutal_channels_pd.setEnabled(false);
            } else {
                range.add(new ParameterDescriptor.Range((Object)1, (Object)1));
                range.add(new ParameterDescriptor.Range((Object)2, (Object)2));
                pcie_virutal_channels_pd.setLegalRanges(range);
                pcie_virutal_channels_pd.setEnabled(true);
            }
            if (!this.isInRange(this.getParameters().getValue("p_pcie_virutal_channels", Integer.class).toString(), (IParameterDescriptor)pcie_virutal_channels_pd)) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_virutal_channels", 1);
            }
        }
        IParameterDescriptorInstance pd = this.getParameterDescriptor("p_pcie_auto_configure_retry_buffer");
        IParameterDescriptorInstance pcie_target_performance_preset = this.getParameterDescriptor("p_pcie_target_performance_preset");
        IParameterDescriptorInstance pcie_initiator_performance_preset = this.getParameterDescriptor("p_pcie_initiator_performance_preset");
        IParameterDescriptorInstance pd_retry_buffer_size = this.getParameterDescriptor("p_pcie_retry_buffer_size");
        IParameterDescriptorInstance pd_retry_fifo_depth = this.getParameterDescriptor("p_pcie_retry_fifo_depth");
        IParameterDescriptorInstance pcie_low_priority_virtual_channels_pd = this.getParameterDescriptor("p_pcie_low_priority_virtual_channels");
        pcie_low_priority_virtual_channels_pd.setLegalRanges((Collection)this.get_LPVC_range(this.getParameters().getValue("p_pcie_virutal_channels", Integer.class)));
        if (this.getParameters().getValue("p_pcie_virutal_channels", Integer.class) > 1) {
            pcie_low_priority_virtual_channels_pd.setEnabled(true);
        } else {
            pcie_low_priority_virtual_channels_pd.setEnabled(false);
        }
        if (!this.isInRange(this.getParameters().getValue("p_pcie_low_priority_virtual_channels", Integer.class).toString(), (IParameterDescriptor)pcie_low_priority_virtual_channels_pd)) {
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_low_priority_virtual_channels", 0);
        }
        if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
            if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
                pd.setEnabled(true);
                pd_retry_buffer_size.setEnabled(true);
                pd_retry_fifo_depth.setEnabled(true);
                this.autoSetRetryBufferSize();
                pcie_target_performance_preset.setEnabled(true);
                Vector<ParameterDescriptor.Range> myranges = new Vector<ParameterDescriptor.Range>();
                myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum));
                myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High));
                myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium));
                myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low));
                pcie_target_performance_preset.setLegalRanges(myranges);
                pcie_initiator_performance_preset.setEnabled(true);
                pcie_initiator_performance_preset.setLegalRanges(myranges);
                if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                    myranges = new Vector();
                    if (((PCIECompilerCoreParameters)this.parameters).getUiPCIDeviceMode().equals((Object)IPCIECompilerCoreParameters.EPCIDeviceMode.targetOnly)) {
                        myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low));
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low);
                        pcie_initiator_performance_preset.setEnabled(false);
                    } else {
                        myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum));
                        myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High));
                        myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium));
                        myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low));
                        pcie_initiator_performance_preset.setEnabled(true);
                    }
                    pcie_initiator_performance_preset.setLegalRanges(myranges);
                } else {
                    myranges = new Vector();
                    myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum));
                    myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High));
                    myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium));
                    myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low));
                    pcie_initiator_performance_preset.setLegalRanges(myranges);
                    pcie_initiator_performance_preset.setEnabled(true);
                    pcie_initiator_performance_preset.setLegalRanges(myranges);
                }
                try {
                    this.autoSetRxBufferOptions();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Vector<ParameterDescriptor.Range> myranges;
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_auto_configure_retry_buffer", true);
                pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_buffer_size", "16 KBytes");
                pd_retry_buffer_size.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_fifo_depth", 64);
                pd_retry_fifo_depth.setEnabled(false);
                int nMaxPayloadSize = Integer.parseInt((String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_max_payload_size().toString().trim()));
                if (this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Cyclone IV GX")) {
                    pcie_target_performance_preset.setEnabled(true);
                    myranges = new Vector<ParameterDescriptor.Range>();
                    myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High));
                    pcie_target_performance_preset.setLegalRanges(myranges);
                    if (!this.isInRange(this.getParameters().getValue("p_pcie_target_performance_preset", IPCIECompilerCoreParameters.ERxPerformanceOptions.class).toString(), (IParameterDescriptor)pcie_target_performance_preset)) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_target_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                    }
                    pcie_initiator_performance_preset.setEnabled(false);
                    if (this.parameters.getP_pcie_target_performance_preset().toString().equals(IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum.toString())) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low);
                    } else if (this.parameters.getP_pcie_target_performance_preset().toString().equals(IPCIECompilerCoreParameters.ERxPerformanceOptions.High.toString())) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High);
                    } else if (this.parameters.getP_pcie_target_performance_preset().toString().equals(IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium.toString())) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                    }
                    pcie_target_performance_preset.setEnabled(false);
                    pcie_initiator_performance_preset.setEnabled(false);
                } else if (this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES") || this.getParameters().getP_pcie_phy().equals("Arria II GZ") || this.getParameters().getP_pcie_phy().equals("HardCopy IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                    if (nMaxPayloadSize == 128 || nMaxPayloadSize == 256) {
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_target_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                        ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                        pcie_target_performance_preset.setEnabled(false);
                        pcie_initiator_performance_preset.setEnabled(false);
                    } else if (nMaxPayloadSize == 512 || nMaxPayloadSize == 1024 || nMaxPayloadSize == 2048) {
                        if (nMaxPayloadSize == 512 && !this.getParameters().getP_pcie_phy().equals("HardCopy IV GX")) {
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_target_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                            pcie_target_performance_preset.setEnabled(false);
                            pcie_initiator_performance_preset.setEnabled(false);
                        } else {
                            pcie_target_performance_preset.setEnabled(true);
                            myranges = new Vector();
                            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum));
                            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High));
                            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium));
                            pcie_target_performance_preset.setLegalRanges(myranges);
                            if (!this.isInRange(this.getParameters().getValue("p_pcie_target_performance_preset", IPCIECompilerCoreParameters.ERxPerformanceOptions.class).toString(), (IParameterDescriptor)pcie_target_performance_preset)) {
                                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_target_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                            }
                            pcie_initiator_performance_preset.setEnabled(false);
                            if (this.parameters.getP_pcie_target_performance_preset().toString().equals(IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum.toString())) {
                                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low);
                            } else if (this.parameters.getP_pcie_target_performance_preset().toString().equals(IPCIECompilerCoreParameters.ERxPerformanceOptions.High.toString())) {
                                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High);
                            } else if (this.parameters.getP_pcie_target_performance_preset().toString().equals(IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium.toString())) {
                                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum);
                            }
                        }
                    }
                }
                try {
                    this.autoSetHIPRxBufferOptions();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            pcie_target_performance_preset.setEnabled(true);
            Vector<ParameterDescriptor.Range> myranges = new Vector<ParameterDescriptor.Range>();
            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Maximum));
            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High));
            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Medium));
            myranges.add(new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low, (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.Low));
            pcie_target_performance_preset.setLegalRanges(myranges);
            pcie_initiator_performance_preset.setEnabled(false);
            pcie_initiator_performance_preset.setLegalRanges(myranges);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_initiator_performance_preset", (Object)IPCIECompilerCoreParameters.ERxPerformanceOptions.High);
            try {
                this.autoSetRxBufferOptionsSOPC();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.autoSetRetryBufferSize();
        return true;
    }

    private void autoSetHIPRxBufferOptions() throws Exception {
        Element el;
        int i;
        String target_performance_preset = this.getParameters().getP_pcie_target_performance_preset().toString().trim();
        String initiator_performance_preset = this.getParameters().getP_pcie_initiator_performance_preset().toString().trim();
        String max_payload_size = (String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_max_payload_size().toString().trim());
        String phy_type = this.getParameters().getP_pcie_phy().toString().replaceAll(" ", "");
        if (phy_type.startsWith("Stratix IV GX".replaceAll(" ", ""))) {
            phy_type = "Stratix IV GX".replaceAll(" ", "");
        }
        if (!(this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)") && this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8) || !phy_type.startsWith("HardCopy IV GX".replaceAll(" ", "")))) {
            phy_type = "Stratix IV GX".replaceAll(" ", "");
        }
        String ecrc_forwarding = this.getParameters().isP_pcie_use_crc_forwarding() ? "1" : "0";
        String TargetPerformance = "";
        String InitiatorPerformance = "";
        String PacketSize = "";
        String Phy = "";
        String ecrcForward = "";
        String DatasetId = "";
        InputStream inStream = null;
        if (this.getParameters().getP_pcie_custom_rx_buffer_xml().equals("0") || this.getParameters().getP_pcie_custom_rx_buffer_xml().equals("")) {
            JarFile jarFile = new JarFile(this.getCoreInstallationPath());
            String szFilename = "altera/ipbu/pci_express/" + MVCConstants.getResourceString("PCIE_RxBuffer_HIP_Config_File");
            inStream = jarFile.getInputStream(jarFile.getEntry(szFilename));
            this.parseXmlFile(inStream, false);
        } else {
            File customXMLFile = new File(this.getParameters().getP_pcie_custom_rx_buffer_xml().trim());
            inStream = new FileInputStream(customXMLFile);
            this.parseXmlFile(inStream, true);
        }
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("pcie_config");
        if (nl != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                TargetPerformance = el.getAttribute("target_performance");
                InitiatorPerformance = el.getAttribute("initiator_performance");
                PacketSize = el.getAttribute("max_payload_size");
                Phy = el.getAttribute("phy_type");
                ecrcForward = el.getAttribute("ecrc_forward");
                if (!TargetPerformance.equalsIgnoreCase(target_performance_preset) || !InitiatorPerformance.equalsIgnoreCase(initiator_performance_preset) || !PacketSize.equalsIgnoreCase(max_payload_size) || !Phy.equalsIgnoreCase(phy_type) || !ecrcForward.equalsIgnoreCase(ecrc_forwarding)) continue;
                DatasetId = el.getAttribute("dataset_id");
            }
        }
        if ((nl = docEle.getElementsByTagName("rx_buffer_setting")) != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                if (!el.getAttribute("id").equalsIgnoreCase(DatasetId)) continue;
                for (int j = 0; j < 1; ++j) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_header_credit_vc" + j, Integer.parseInt(el.getAttribute("ph")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("ph")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_data_credit_vc" + j, Integer.parseInt(el.getAttribute("pd")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_data_used_space_vc" + j, Integer.parseInt(el.getAttribute("pd")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_header_credit_vc" + j, Integer.parseInt(el.getAttribute("nph")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("nph")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_data_credit_vc" + j, 0);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_header_credit_vc" + j, Integer.parseInt(el.getAttribute("ch")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("ch")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_data_credit_vc" + j, Integer.parseInt(el.getAttribute("cd")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_data_used_space_vc" + j, Integer.parseInt(el.getAttribute("cd")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_total_header_credit_vc" + j, Integer.parseInt(el.getAttribute("nph")) + Integer.parseInt(el.getAttribute("ph")) + Integer.parseInt(el.getAttribute("ch")));
                    int rxBufferSize = 0;
                    String szRxBufferSize = "";
                    if (ecrc_forwarding.equals("0")) {
                        rxBufferSize = Integer.parseInt(el.getAttribute("ph")) * 16 + Integer.parseInt(el.getAttribute("pd")) * 16 + Integer.parseInt(el.getAttribute("nph")) * 16 + Integer.parseInt(el.getAttribute("ch")) * 16 + Integer.parseInt(el.getAttribute("cd")) * 16;
                        szRxBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get("" + rxBufferSize);
                        if (szRxBufferSize == null) {
                            szRxBufferSize = "" + rxBufferSize + " Bytes";
                        }
                    } else {
                        rxBufferSize = Integer.parseInt(el.getAttribute("ph")) * 24 + Integer.parseInt(el.getAttribute("pd")) * 16 + Integer.parseInt(el.getAttribute("nph")) * 24 + Integer.parseInt(el.getAttribute("ch")) * 16 + Integer.parseInt(el.getAttribute("cd")) * 16;
                        szRxBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get("" + rxBufferSize);
                        if (szRxBufferSize == null) {
                            szRxBufferSize = "" + rxBufferSize + " Bytes";
                        }
                    }
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_rx_buffer_size_vc" + j, rxBufferSize);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_rx_buffer_size_string_vc" + j, szRxBufferSize);
                }
            }
        }
    }

    protected void autoSetRetryBufferSize() {
        int nMaxPayloadSize = Integer.parseInt((String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_max_payload_size().toString().trim()));
        int nRetryBufferSize = Integer.parseInt((String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_retry_buffer_size().toString().trim()));
        IParameterDescriptorInstance pd = this.getParameterDescriptor("p_pcie_retry_buffer_size");
        if (this.getParameters().isP_pcie_auto_configure_retry_buffer()) {
            pd.setEnabled(false);
            String retryBytes = "" + 4 * nMaxPayloadSize;
            if (4 * nMaxPayloadSize < 2048) {
                retryBytes = "2048";
            }
            String retryBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get(retryBytes);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_buffer_size", retryBufferSize);
        } else {
            pd.setEnabled(true);
            if (nRetryBufferSize < nMaxPayloadSize) {
                this.addInfoMessage(MVCConstants.getResourceString("PCIE_Max_Payload_And_Retry_Buffer.Message"), EMessageID.ValidationRelated);
            }
            List rangesRetryBuf = this.getRetryBufferSizeRange(this.getParameters().getP_pcie_max_payload_size().toString().trim());
            pd.setLegalRanges((Collection)rangesRetryBuf);
            if (!this.isInRange(this.getParameters().getP_pcie_retry_buffer_size().toString().trim(), (IParameterDescriptor)pd)) {
                String sRetryBufferSize = "" + 2 * nMaxPayloadSize;
                String retryBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get(sRetryBufferSize);
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_buffer_size", retryBufferSize);
            }
        }
        if (!((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder() && ((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("1")) {
            IParameterDescriptorInstance pd_retry_buffer_size = this.getParameterDescriptor("p_pcie_retry_buffer_size");
            IParameterDescriptorInstance pd_retry_fifo_depth = this.getParameterDescriptor("p_pcie_retry_fifo_depth");
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_auto_configure_retry_buffer", true);
            pd.setEnabled(false);
            if (this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_buffer_size", "8 KBytes");
            } else {
                ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_buffer_size", "16 KBytes");
            }
            pd_retry_buffer_size.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_fifo_depth", 64);
            pd_retry_fifo_depth.setEnabled(false);
        }
        if (this.getParameters().getP_pcie_phy().equals("HardCopy IV GX") && this.getParameters().getP_pcie_rate().equals("Gen2 (5.0 Gbps)") && this.getParameters().getP_pcie_number_of_lanes().equals((Object)IPCIECompilerCoreParameters.ELaneOptions.x8)) {
            IParameterDescriptorInstance pd_auto_retry_buffer_size = this.getParameterDescriptor("p_pcie_auto_configure_retry_buffer");
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_auto_configure_retry_buffer", true);
            pd_auto_retry_buffer_size.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_retry_buffer_size", "8 KBytes");
            pd.setEnabled(false);
        }
    }

    protected void autoSetRxBufferOptionsSOPC() throws Exception {
        Element el;
        int i;
        String target_performance_preset = this.getParameters().getP_pcie_target_performance_preset().toString().trim();
        String initiator_performance_preset = this.getParameters().getP_pcie_initiator_performance_preset().toString().trim();
        String max_payload_size = (String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_max_payload_size().toString().trim());
        String num_lanes = this.getParameters().getP_pcie_number_of_lanes().toString().trim().substring(1);
        String TargetPerformance = "";
        String InitiatorPerformance = "";
        String PacketSize = "";
        String NumLane = "";
        String DatasetId = "";
        InputStream inStream = null;
        if (this.getParameters().getP_pcie_custom_rx_buffer_xml().equals("0") || this.getParameters().getP_pcie_custom_rx_buffer_xml().equals("")) {
            JarFile jarFile = new JarFile(this.getCoreInstallationPath());
            String szFilename = "altera/ipbu/pci_express/" + MVCConstants.getResourceString("PCIE_RxBuffer_SOPC_Config_File");
            inStream = jarFile.getInputStream(jarFile.getEntry(szFilename));
            this.parseXmlFile(inStream, false);
        } else {
            File customXMLFile = new File(this.getParameters().getP_pcie_custom_rx_buffer_xml().trim());
            inStream = new FileInputStream(customXMLFile);
            this.parseXmlFile(inStream, true);
        }
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("pcie_config");
        if (nl != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                TargetPerformance = el.getAttribute("target_performance");
                InitiatorPerformance = el.getAttribute("initiator_performance");
                PacketSize = el.getAttribute("max_payload_size");
                NumLane = el.getAttribute("lanes");
                if (!TargetPerformance.equalsIgnoreCase(target_performance_preset) || !InitiatorPerformance.equalsIgnoreCase(initiator_performance_preset) || !PacketSize.equalsIgnoreCase(max_payload_size) || !NumLane.equalsIgnoreCase(num_lanes)) continue;
                DatasetId = el.getAttribute("dataset_id");
            }
        }
        if ((nl = docEle.getElementsByTagName("rx_buffer_setting")) != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                if (!el.getAttribute("id").equalsIgnoreCase(DatasetId)) continue;
                for (int j = 0; j < 1; ++j) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_header_credit_vc" + j, Integer.parseInt(el.getAttribute("ph")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("ph")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_data_credit_vc" + j, Integer.parseInt(el.getAttribute("pd")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_data_used_space_vc" + j, Integer.parseInt(el.getAttribute("pd")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_header_credit_vc" + j, Integer.parseInt(el.getAttribute("nph")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("nph")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_data_credit_vc" + j, 0);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_header_credit_vc" + j, Integer.parseInt(el.getAttribute("ch")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("ch")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_data_credit_vc" + j, Integer.parseInt(el.getAttribute("cd")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_data_used_space_vc" + j, Integer.parseInt(el.getAttribute("cd")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_total_header_credit_vc" + j, Integer.parseInt(el.getAttribute("nph")) + Integer.parseInt(el.getAttribute("ph")) + Integer.parseInt(el.getAttribute("ch")));
                    int rxBufferSize = Integer.parseInt(el.getAttribute("ph")) * 16 + Integer.parseInt(el.getAttribute("pd")) * 16 + Integer.parseInt(el.getAttribute("nph")) * 16 + Integer.parseInt(el.getAttribute("ch")) * 16 + Integer.parseInt(el.getAttribute("cd")) * 16;
                    String szRxBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get("" + rxBufferSize);
                    if (szRxBufferSize == null) {
                        szRxBufferSize = "" + rxBufferSize + " Bytes";
                    }
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_rx_buffer_size_vc" + j, rxBufferSize);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_rx_buffer_size_string_vc" + j, szRxBufferSize);
                }
            }
        }
    }

    protected void autoSetRxBufferOptions() throws Exception {
        Element el;
        int i;
        String target_performance_preset = this.getParameters().getP_pcie_target_performance_preset().toString().trim();
        String initiator_performance_preset = this.getParameters().getP_pcie_initiator_performance_preset().toString().trim();
        String max_payload_size = (String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_max_payload_size().toString().trim());
        String num_lanes = this.getParameters().getP_pcie_number_of_lanes().toString().trim().substring(1);
        String TargetPerformance = "";
        String InitiatorPerformance = "";
        String PacketSize = "";
        String NumLane = "";
        String DatasetId = "";
        InputStream inStream = null;
        if (this.getParameters().getP_pcie_custom_rx_buffer_xml().equals("0") || this.getParameters().getP_pcie_custom_rx_buffer_xml().equals("")) {
            JarFile jarFile = new JarFile(this.getCoreInstallationPath());
            String szFilename = "altera/ipbu/pci_express/" + MVCConstants.getResourceString("PCIE_RxBuffer_Config_File");
            inStream = jarFile.getInputStream(jarFile.getEntry(szFilename));
            this.parseXmlFile(inStream, false);
        } else {
            File customXMLFile = new File(this.getParameters().getP_pcie_custom_rx_buffer_xml().trim());
            inStream = new FileInputStream(customXMLFile);
            this.parseXmlFile(inStream, true);
        }
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("pcie_config");
        if (nl != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                TargetPerformance = el.getAttribute("target_performance");
                InitiatorPerformance = el.getAttribute("initiator_performance");
                PacketSize = el.getAttribute("max_payload_size");
                NumLane = el.getAttribute("lanes");
                if (!TargetPerformance.equalsIgnoreCase(target_performance_preset) || !InitiatorPerformance.equalsIgnoreCase(initiator_performance_preset) || !PacketSize.equalsIgnoreCase(max_payload_size) || !NumLane.equalsIgnoreCase(num_lanes)) continue;
                DatasetId = el.getAttribute("dataset_id");
            }
        }
        if ((nl = docEle.getElementsByTagName("rx_buffer_setting")) != null && nl.getLength() > 0) {
            for (i = 0; i < nl.getLength(); ++i) {
                el = (Element)nl.item(i);
                if (!el.getAttribute("id").equalsIgnoreCase(DatasetId)) continue;
                for (int j = 0; j < 1; ++j) {
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_header_credit_vc" + j, Integer.parseInt(el.getAttribute("ph")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("ph")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_data_credit_vc" + j, Integer.parseInt(el.getAttribute("pd")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_posted_data_used_space_vc" + j, Integer.parseInt(el.getAttribute("pd")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_header_credit_vc" + j, Integer.parseInt(el.getAttribute("nph")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("nph")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_nonposted_data_credit_vc" + j, 0);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_header_credit_vc" + j, Integer.parseInt(el.getAttribute("ch")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_header_used_space_vc" + j, Integer.parseInt(el.getAttribute("ch")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_data_credit_vc" + j, Integer.parseInt(el.getAttribute("cd")));
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_completion_data_used_space_vc" + j, Integer.parseInt(el.getAttribute("cd")) * 16);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_total_header_credit_vc" + j, Integer.parseInt(el.getAttribute("nph")) + Integer.parseInt(el.getAttribute("ph")) + Integer.parseInt(el.getAttribute("ch")));
                    int rxBufferSize = Integer.parseInt(el.getAttribute("ph")) * 16 + Integer.parseInt(el.getAttribute("pd")) * 16 + Integer.parseInt(el.getAttribute("nph")) * 16 + Integer.parseInt(el.getAttribute("ch")) * 16 + Integer.parseInt(el.getAttribute("cd")) * 16;
                    String szRxBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get("" + rxBufferSize);
                    if (szRxBufferSize == null) {
                        szRxBufferSize = "" + rxBufferSize + " Bytes";
                    }
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_rx_buffer_size_vc" + j, rxBufferSize);
                    ((PCIECompilerCoreParameters)this.parameters).setValue("p_pcie_rx_buffer_size_string_vc" + j, szRxBufferSize);
                }
            }
        }
    }

    private void parseXmlFile(InputStream sInput, boolean bValidate) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setValidating(bValidate);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new MyErrorHandler());
            this.dom = db.parse(sInput);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean updatePowerSetting() {
        IParameterDescriptorInstance pcie_enable_L1_aspm_pd = this.getParameterDescriptor("p_pcie_enable_L1_aspm");
        IParameterDescriptorInstance pcie_endpoint_L1_acceptable_latency_pd = this.getParameterDescriptor("p_pcie_endpoint_L1_acceptable_latency");
        IParameterDescriptorInstance pcie_L1_exit_latency_common_clock_pd = this.getParameterDescriptor("p_pcie_L1_exit_latency_common_clock");
        IParameterDescriptorInstance pcie_L1_exit_latency_separate_clock_pd = this.getParameterDescriptor("p_pcie_L1_exit_latency_separate_clock");
        IParameterDescriptorInstance pcie_threshold_for_L0s_entry_pd = this.getParameterDescriptor("p_pcie_threshold_for_L0s_entry");
        IParameterDescriptorInstance pcie_nfts_common_clock_pd = this.getParameterDescriptor("p_pcie_nfts_common_clock");
        IParameterDescriptorInstance pcie_nfts_separate_clock_pd = this.getParameterDescriptor("p_pcie_nfts_separate_clock");
        IParameterDescriptorInstance pcie_gen2_nfts_same_clock_pd = this.getParameterDescriptor("p_pcie_gen2_nfts_same_clock");
        IParameterDescriptorInstance pcie_gen2_nfts_diff_clock_pd = this.getParameterDescriptor("p_pcie_gen2_nfts_diff_clock");
        IParameterDescriptorInstance pcie_eie_b4_nfts_count_pd = this.getParameterDescriptor("p_pcie_eie_b4_nfts_count");
        if (((PCIECompilerCoreParameters)this.parameters).getP_pcie_enable_hip().equals("0")) {
            pcie_gen2_nfts_same_clock_pd.setEnabled(false);
            pcie_gen2_nfts_diff_clock_pd.setEnabled(false);
            pcie_eie_b4_nfts_count_pd.setEnabled(false);
        } else {
            pcie_gen2_nfts_same_clock_pd.setEnabled(false);
            pcie_gen2_nfts_diff_clock_pd.setEnabled(false);
            pcie_eie_b4_nfts_count_pd.setEnabled(false);
        }
        if (this.getParameters().getP_pcie_phy().equals("Stratix GX") || this.getParameters().getP_pcie_phy().equals("Stratix II GX") || this.getParameters().getP_pcie_phy().equals("Arria GX")) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_L1_aspm(false);
            pcie_enable_L1_aspm_pd.setEnabled(false);
            pcie_endpoint_L1_acceptable_latency_pd.setEnabled(true);
            pcie_L1_exit_latency_common_clock_pd.setEnabled(false);
            pcie_L1_exit_latency_separate_clock_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_L1_exit_latency_common_clock(">64 us");
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_L1_exit_latency_separate_clock(">64 us");
            if (this.getParameters().isP_pcie_enable_fast_recovery() && !this.getParameters().getP_pcie_phy().equals("Stratix GX")) {
                pcie_threshold_for_L0s_entry_pd.setEnabled(true);
                pcie_nfts_common_clock_pd.setEnabled(true);
                pcie_nfts_separate_clock_pd.setEnabled(true);
            } else {
                pcie_threshold_for_L0s_entry_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_threshold_for_L0s_entry(MVCConstants.THRESHOLD_FOR_L0S_OPTIONS[MVCConstants.THRESHOLD_FOR_L0S_OPTIONS.length - 1]);
                pcie_nfts_common_clock_pd.setEnabled(false);
                pcie_nfts_separate_clock_pd.setEnabled(false);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_nfts_common_clock(255);
                ((PCIECompilerCoreParameters)this.parameters).setP_pcie_nfts_separate_clock(255);
            }
            if (this.getParameters().getP_pcie_phy().equals("Stratix GX")) {
                this.addInfoMessage(MVCConstants.getResourceString("PCIE_Stratix_GX_And_PM.Message"), EMessageID.ValidationRelated);
            }
        } else if (this.getParameters().getP_pcie_phy().equals("Stratix IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix IV GX ES") || this.getParameters().getP_pcie_phy().equals("Arria II GZ") || this.getParameters().getP_pcie_phy().equals("Arria II GX") || this.getParameters().getP_pcie_phy().equals("Cyclone IV GX") || this.getParameters().getP_pcie_phy().equals("HardCopy IV GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX") || this.getParameters().getP_pcie_phy().equals("Stratix V GX CVP")) {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_enable_L1_aspm(false);
            pcie_enable_L1_aspm_pd.setEnabled(false);
            pcie_endpoint_L1_acceptable_latency_pd.setEnabled(true);
            pcie_L1_exit_latency_common_clock_pd.setEnabled(false);
            pcie_L1_exit_latency_separate_clock_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_L1_exit_latency_common_clock(">64 us");
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_L1_exit_latency_separate_clock(">64 us");
            pcie_threshold_for_L0s_entry_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_threshold_for_L0s_entry(MVCConstants.THRESHOLD_FOR_L0S_OPTIONS[MVCConstants.THRESHOLD_FOR_L0S_OPTIONS.length - 1]);
            pcie_nfts_common_clock_pd.setEnabled(false);
            pcie_nfts_separate_clock_pd.setEnabled(false);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_nfts_common_clock(255);
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_nfts_separate_clock(255);
        } else {
            pcie_nfts_common_clock_pd.setEnabled(true);
            pcie_nfts_separate_clock_pd.setEnabled(true);
            pcie_threshold_for_L0s_entry_pd.setEnabled(true);
            pcie_enable_L1_aspm_pd.setEnabled(true);
            if (this.getParameters().isP_pcie_enable_L1_aspm()) {
                pcie_endpoint_L1_acceptable_latency_pd.setEnabled(true);
                pcie_L1_exit_latency_common_clock_pd.setEnabled(true);
                pcie_L1_exit_latency_separate_clock_pd.setEnabled(true);
                if (this.getWDSRIndex(MVCConstants.L1_EL_OPTIONS, this.getParameters().getP_pcie_L1_exit_latency_separate_clock()) < this.getWDSRIndex(MVCConstants.L1_EL_OPTIONS, this.getParameters().getP_pcie_L1_exit_latency_common_clock())) {
                    this.addInfoMessage(MVCConstants.getResourceString("PCIE_L1_Exit_Latency_Common_And_Separate_Clock.Message"), EMessageID.ValidationRelated);
                }
            } else {
                pcie_endpoint_L1_acceptable_latency_pd.setEnabled(false);
                pcie_L1_exit_latency_common_clock_pd.setEnabled(false);
                pcie_L1_exit_latency_separate_clock_pd.setEnabled(false);
            }
        }
        if (this.getParameters().getP_pcie_nfts_separate_clock() < this.getParameters().getP_pcie_nfts_common_clock()) {
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_NFTS_Common_And_Separate_Clock.Message"), EMessageID.ValidationRelated);
        }
        if (this.getParameters().getP_pcie_gen2_nfts_diff_clock() < this.getParameters().getP_pcie_gen2_nfts_same_clock()) {
            this.addInfoMessage(MVCConstants.getResourceString("PCIE_NFTS_Common_And_Separate_Clock.Message"), EMessageID.ValidationRelated);
        }
        IParameterDescriptorInstance pcie_disable_L0s_pd = this.getParameterDescriptor("p_pcie_disable_L0s");
        if (this.getParameters().getP_pcie_version().toString().equalsIgnoreCase("2.1")) {
            pcie_disable_L0s_pd.setEnabled(true);
        } else {
            ((PCIECompilerCoreParameters)this.parameters).setP_pcie_disable_L0s(false);
            pcie_disable_L0s_pd.setEnabled(false);
        }
        return true;
    }

    private int getWDSRIndex(String[] range, String value) {
        int i = 0;
        for (String str : range) {
            if (value.equalsIgnoreCase(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List get_LPVC_range(Integer value) {
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        switch (value) {
            case 1: {
                ranges.add(new ParameterDescriptor.Range((Object)0, (Object)0));
                break;
            }
            case 2: {
                ranges.add(new ParameterDescriptor.Range((Object)0, (Object)0));
                ranges.add(new ParameterDescriptor.Range((Object)2, (Object)2));
                break;
            }
            case 3: {
                ranges.add(new ParameterDescriptor.Range((Object)0, (Object)0));
                ranges.add(new ParameterDescriptor.Range((Object)2, (Object)2));
                ranges.add(new ParameterDescriptor.Range((Object)3, (Object)3));
                break;
            }
            case 4: {
                ranges.add(new ParameterDescriptor.Range((Object)0, (Object)0));
                ranges.add(new ParameterDescriptor.Range((Object)2, (Object)2));
                ranges.add(new ParameterDescriptor.Range((Object)3, (Object)3));
                ranges.add(new ParameterDescriptor.Range((Object)4, (Object)4));
                break;
            }
        }
        return ranges;
    }

    private List getTagOptions(int[] constant) {
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        if (constant.equals(MVCConstants.SOPC_TAG_OPTIONS)) {
            ranges.add(new ParameterDescriptor.Range((Object)16, (Object)16));
        }
        if (constant.equals(MVCConstants.STRATIX_II_x8_TAG_OPTIONS)) {
            ranges.add(new ParameterDescriptor.Range((Object)4, (Object)4));
            ranges.add(new ParameterDescriptor.Range((Object)8, (Object)8));
            ranges.add(new ParameterDescriptor.Range((Object)16, (Object)16));
            ranges.add(new ParameterDescriptor.Range((Object)32, (Object)32));
        } else if (constant.equals(MVCConstants.TAG_OPTIONS)) {
            ranges.add(new ParameterDescriptor.Range((Object)4, (Object)4));
            ranges.add(new ParameterDescriptor.Range((Object)8, (Object)8));
            ranges.add(new ParameterDescriptor.Range((Object)16, (Object)16));
            ranges.add(new ParameterDescriptor.Range((Object)32, (Object)32));
            ranges.add(new ParameterDescriptor.Range((Object)64, (Object)64));
            ranges.add(new ParameterDescriptor.Range((Object)128, (Object)128));
            ranges.add(new ParameterDescriptor.Range((Object)256, (Object)256));
        } else if (constant.equals(MVCConstants.HIP_TAG_OPTIONS)) {
            ranges.add(new ParameterDescriptor.Range((Object)32, (Object)32));
            ranges.add(new ParameterDescriptor.Range((Object)64, (Object)64));
        }
        return ranges;
    }

    private List getClkFrequency(String[] constant) {
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        if (constant.equals(MVCConstants.INTERNAL_CLOCK_OPTIONS_x4)) {
            ranges.add(new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz"));
        } else if (constant.equals(MVCConstants.INTERNAL_CLOCK_OPTIONS_x1)) {
            ranges.add(new ParameterDescriptor.Range((Object)"62.5 MHz", (Object)"62.5 MHz"));
            ranges.add(new ParameterDescriptor.Range((Object)"125 MHz", (Object)"125 MHz"));
        } else if (constant.equals(MVCConstants.INTERNAL_CLOCK_OPTIONS_x8)) {
            ranges.add(new ParameterDescriptor.Range((Object)"250 MHz", (Object)"250 MHz"));
        }
        return ranges;
    }

    private List getRetryBufferSizeRange(String constant) {
        int nMaxPayloadSize = Integer.parseInt((String)MVCConstants.BUFFER_SIZE_STRING2BYTES.get(this.getParameters().getP_pcie_max_payload_size().toString().trim()));
        Vector<ParameterDescriptor.Range> rangesRetryBuf = new Vector<ParameterDescriptor.Range>();
        for (int i = 2 * nMaxPayloadSize; i <= 16384; i *= 2) {
            String retryBytes = "" + i;
            String retryBufferSize = (String)MVCConstants.BUFFER_SIZE_BYTES2STRING.get(retryBytes);
            rangesRetryBuf.add(new ParameterDescriptor.Range((Object)retryBufferSize, (Object)retryBufferSize));
        }
        return rangesRetryBuf;
    }

    private List getBarSizeRange(String[] constant) {
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        if (constant.equals(MVCConstants.PCI_BAR_x8_64BIT_SIZES)) {
            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges.add(new ParameterDescriptor.Range((Object)"Auto", (Object)"Auto"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 MBytes - 25 bits", (Object)"32 MBytes - 25 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 MBytes - 26 bits", (Object)"64 MBytes - 26 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 MBytes - 27 bits", (Object)"128 MBytes - 27 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 MBytes - 28 bits", (Object)"256 MBytes - 28 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 MBytes - 29 bits", (Object)"512 MBytes - 29 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 GByte - 30 bits", (Object)"1 GByte - 30 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 GBytes - 31 bits", (Object)"2 GBytes - 31 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 GBytes - 32 bits", (Object)"4 GBytes - 32 bits"));
            } else {
                ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 MBytes - 25 bits", (Object)"32 MBytes - 25 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 MBytes - 26 bits", (Object)"64 MBytes - 26 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 MBytes - 27 bits", (Object)"128 MBytes - 27 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 MBytes - 28 bits", (Object)"256 MBytes - 28 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 MBytes - 29 bits", (Object)"512 MBytes - 29 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 GByte - 30 bits", (Object)"1 GByte - 30 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 GBytes - 31 bits", (Object)"2 GBytes - 31 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 GBytes - 32 bits", (Object)"4 GBytes - 32 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 GBytes - 33 bits", (Object)"8 GBytes - 33 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 GBytes - 34 bits", (Object)"16 GBytes - 34 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 GBytes - 35 bits", (Object)"32 GBytes - 35 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 GBytes - 36 bits", (Object)"64 GBytes - 36 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 GBytes - 37 bits", (Object)"128 GBytes - 37 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 GBytes - 38 bits", (Object)"256 GBytes - 38 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 GBytes - 39 bits", (Object)"512 GBytes - 39 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 TByte - 40 bits", (Object)"1 TByte - 40 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 TBytes - 41 bits", (Object)"2 TBytes - 41 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 TBytes - 42 bits", (Object)"4 TBytes - 42 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 TBytes - 43 bits", (Object)"8 TBytes - 43 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 TBytes - 44 bits", (Object)"16 TBytes - 44 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 TBytes - 45 bits", (Object)"32 TBytes - 45 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 TBytes - 46 bits", (Object)"64 TBytes - 46 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 TBytes - 47 bits", (Object)"128 TBytes - 47 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 TBytes - 48 bits", (Object)"256 TBytes - 48 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 TBytes - 49 bits", (Object)"512 TBytes - 49 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 PByte - 50 bits", (Object)"1 PByte - 50 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 PBytes - 51 bits", (Object)"2 PBytes - 51 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 PBytes - 52 bits", (Object)"4 PBytes - 52 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 PBytes - 53 bits", (Object)"8 PBytes - 53 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 PBytes - 54 bits", (Object)"16 PBytes - 54 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 PBytes - 55 bits", (Object)"32 PBytes - 55 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 PBytes - 56 bits", (Object)"64 PBytes - 56 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 PBytes - 57 bits", (Object)"128 PBytes - 57 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 PBytes - 58 bits", (Object)"256 PBytes - 58 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 PBytes - 59 bits", (Object)"512 PBytes - 59 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 EByte - 60 bits", (Object)"1 EByte - 60 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 EBytes - 61 bits", (Object)"2 EBytes - 61 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 EBytes - 62 bits", (Object)"4 EBytes - 62 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 EBytes - 63 bits", (Object)"8 EBytes - 63 bits"));
            }
        } else if (constant.equals(MVCConstants.PCI_BAR_64BIT_SIZES)) {
            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges.add(new ParameterDescriptor.Range((Object)"Auto", (Object)"Auto"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes - 7 bits", (Object)"128 Bytes - 7 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes - 8 bits", (Object)"256 Bytes - 8 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes - 9 bits", (Object)"512 Bytes - 9 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 KByte - 10 bits", (Object)"1 KByte - 10 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes - 11 bits", (Object)"2 KBytes - 11 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 MBytes - 25 bits", (Object)"32 MBytes - 25 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 MBytes - 26 bits", (Object)"64 MBytes - 26 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 MBytes - 27 bits", (Object)"128 MBytes - 27 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 MBytes - 28 bits", (Object)"256 MBytes - 28 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 MBytes - 29 bits", (Object)"512 MBytes - 29 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 GByte - 30 bits", (Object)"1 GByte - 30 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 GBytes - 31 bits", (Object)"2 GBytes - 31 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 GBytes - 32 bits", (Object)"4 GBytes - 32 bits"));
            } else {
                ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes - 7 bits", (Object)"128 Bytes - 7 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes - 8 bits", (Object)"256 Bytes - 8 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes - 9 bits", (Object)"512 Bytes - 9 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 KByte - 10 bits", (Object)"1 KByte - 10 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes - 11 bits", (Object)"2 KBytes - 11 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 MBytes - 25 bits", (Object)"32 MBytes - 25 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 MBytes - 26 bits", (Object)"64 MBytes - 26 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 MBytes - 27 bits", (Object)"128 MBytes - 27 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 MBytes - 28 bits", (Object)"256 MBytes - 28 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 MBytes - 29 bits", (Object)"512 MBytes - 29 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 GByte - 30 bits", (Object)"1 GByte - 30 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 GBytes - 31 bits", (Object)"2 GBytes - 31 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 GBytes - 32 bits", (Object)"4 GBytes - 32 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 GBytes - 33 bits", (Object)"8 GBytes - 33 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 GBytes - 34 bits", (Object)"16 GBytes - 34 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 GBytes - 35 bits", (Object)"32 GBytes - 35 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 GBytes - 36 bits", (Object)"64 GBytes - 36 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 GBytes - 37 bits", (Object)"128 GBytes - 37 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 GBytes - 38 bits", (Object)"256 GBytes - 38 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 GBytes - 39 bits", (Object)"512 GBytes - 39 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 TByte - 40 bits", (Object)"1 TByte - 40 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 TBytes - 41 bits", (Object)"2 TBytes - 41 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 TBytes - 42 bits", (Object)"4 TBytes - 42 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 TBytes - 43 bits", (Object)"8 TBytes - 43 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 TBytes - 44 bits", (Object)"16 TBytes - 44 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 TBytes - 45 bits", (Object)"32 TBytes - 45 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 TBytes - 46 bits", (Object)"64 TBytes - 46 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 TBytes - 47 bits", (Object)"128 TBytes - 47 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 TBytes - 48 bits", (Object)"256 TBytes - 48 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 TBytes - 49 bits", (Object)"512 TBytes - 49 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 PByte - 50 bits", (Object)"1 PByte - 50 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 PBytes - 51 bits", (Object)"2 PBytes - 51 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 PBytes - 52 bits", (Object)"4 PBytes - 52 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 PBytes - 53 bits", (Object)"8 PBytes - 53 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"16 PBytes - 54 bits", (Object)"16 PBytes - 54 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"32 PBytes - 55 bits", (Object)"32 PBytes - 55 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"64 PBytes - 56 bits", (Object)"64 PBytes - 56 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"128 PBytes - 57 bits", (Object)"128 PBytes - 57 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"256 PBytes - 58 bits", (Object)"256 PBytes - 58 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"512 PBytes - 59 bits", (Object)"512 PBytes - 59 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"1 EByte - 60 bits", (Object)"1 EByte - 60 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"2 EBytes - 61 bits", (Object)"2 EBytes - 61 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"4 EBytes - 62 bits", (Object)"4 EBytes - 62 bits"));
                ranges.add(new ParameterDescriptor.Range((Object)"8 EBytes - 63 bits", (Object)"8 EBytes - 63 bits"));
            }
        } else if (constant.equals(MVCConstants.PCI_BAR_x8_IO_SIZES)) {
            ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
        } else if (constant.equals(MVCConstants.PCI_BAR_IO_SIZES)) {
            ranges.add(new ParameterDescriptor.Range((Object)"16 Bytes - 4 bits", (Object)"16 Bytes - 4 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"32 Bytes - 5 bits", (Object)"32 Bytes - 5 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"64 Bytes - 6 bits", (Object)"64 Bytes - 6 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes - 7 bits", (Object)"128 Bytes - 7 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes - 8 bits", (Object)"256 Bytes - 8 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes - 9 bits", (Object)"512 Bytes - 9 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 KByte - 10 bits", (Object)"1 KByte - 10 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes - 11 bits", (Object)"2 KBytes - 11 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
        } else if (constant.equals(MVCConstants.PCI_BAR_x8_32BIT_SIZES)) {
            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges.add(new ParameterDescriptor.Range((Object)"Auto", (Object)"Auto"));
            }
            ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"32 MBytes - 25 bits", (Object)"32 MBytes - 25 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"64 MBytes - 26 bits", (Object)"64 MBytes - 26 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"128 MBytes - 27 bits", (Object)"128 MBytes - 27 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 MBytes - 28 bits", (Object)"256 MBytes - 28 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 MBytes - 29 bits", (Object)"512 MBytes - 29 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 GByte - 30 bits", (Object)"1 GByte - 30 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 GBytes - 31 bits", (Object)"2 GBytes - 31 bits"));
        } else if (constant.equals(MVCConstants.PCI_BAR_32BIT_SIZES)) {
            if (((PCIECompilerCoreParameters)this.parameters).isP_pcie_underSOPCBuilder()) {
                ranges.add(new ParameterDescriptor.Range((Object)"Auto", (Object)"Auto"));
            }
            ranges.add(new ParameterDescriptor.Range((Object)"128 Bytes - 7 bits", (Object)"128 Bytes - 7 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 Bytes - 8 bits", (Object)"256 Bytes - 8 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 Bytes - 9 bits", (Object)"512 Bytes - 9 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 KByte - 10 bits", (Object)"1 KByte - 10 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 KBytes - 11 bits", (Object)"2 KBytes - 11 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"32 MBytes - 25 bits", (Object)"32 MBytes - 25 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"64 MBytes - 26 bits", (Object)"64 MBytes - 26 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"128 MBytes - 27 bits", (Object)"128 MBytes - 27 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 MBytes - 28 bits", (Object)"256 MBytes - 28 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 MBytes - 29 bits", (Object)"512 MBytes - 29 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 GByte - 30 bits", (Object)"1 GByte - 30 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 GBytes - 31 bits", (Object)"2 GBytes - 31 bits"));
        } else if (constant.equals(MVCConstants.PCI_EXP_ROM_BAR_SIZES)) {
            ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"8 KBytes - 13 bits", (Object)"8 KBytes - 13 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"16 KBytes - 14 bits", (Object)"16 KBytes - 14 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"32 KBytes - 15 bits", (Object)"32 KBytes - 15 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"64 KBytes - 16 bits", (Object)"64 KBytes - 16 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"128 KBytes - 17 bits", (Object)"128 KBytes - 17 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"256 KBytes - 18 bits", (Object)"256 KBytes - 18 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"512 KBytes - 19 bits", (Object)"512 KBytes - 19 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"1 MByte - 20 bits", (Object)"1 MByte - 20 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"2 MBytes - 21 bits", (Object)"2 MBytes - 21 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"4 MBytes - 22 bits", (Object)"4 MBytes - 22 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"8 MBytes - 23 bits", (Object)"8 MBytes - 23 bits"));
            ranges.add(new ParameterDescriptor.Range((Object)"16 MBytes - 24 bits", (Object)"16 MBytes - 24 bits"));
        } else if (constant.equals(MVCConstants.PCI_x8_SIP_EXP_ROM_BAR_SIZES)) {
            ranges.add(new ParameterDescriptor.Range((Object)"4 KBytes - 12 bits", (Object)"4 KBytes - 12 bits"));
        }
        return ranges;
    }

    private void addErrorMessage(String message, EMessageID messageID) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Error);
        m.setObject((Object)this.getParameters());
        m.setObjectName(this.parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    private void addWarningMessage(String message, EMessageID messageID) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Warning);
        m.setObject((Object)this.getParameters());
        m.setObjectName(this.parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    private void addInfoMessage(String message, EMessageID messageID) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Info);
        m.setObject((Object)this.getParameters());
        m.setObjectName(this.parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    @Override
    public void setMessageLogger(IMessageLogger messageLogger) {
        this.logger = messageLogger;
    }

    private void addMessage(IMessage message) {
        if (this.getMessageLogger() != null) {
            IMessageLogger messageLogger = this.getMessageLogger();
            messageLogger.receiveMessage(message);
        }
    }

    IMessageLogger getMessageLogger() {
        return this.logger;
    }

    private IParameterDescriptorInstance getParameterDescriptor(String name) {
        return this.coreParameterDescriptor.getParameterDescriptor(name);
    }

    public IPCIECompilerCoreParameters getParameters() {
        return this.parameters;
    }

    private boolean isInRange(String currentValue, IParameterDescriptor pd) {
        Vector rangeItems = MWParameterDescriptorHelper.enumuraterangetItems((IParameterDescriptor)pd);
        for (Object item : rangeItems) {
            if (!currentValue.equalsIgnoreCase(item.toString())) continue;
            return true;
        }
        return false;
    }

    protected String getCoreInstallationPath() {
        String strMyLocation = null;
        try {
            strMyLocation = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        strMyLocation = strMyLocation.replace("file:", "");
        if (strMyLocation.indexOf(".jar") > 0) {
            File myLocation = new File(strMyLocation);
            if (!myLocation.exists()) {
                return null;
            }
            return myLocation.toString();
        }
        String megacoreRoot = System.getenv("MEGACORE_ROOT");
        return megacoreRoot;
    }

    private boolean AddHIPMessages() {
        IParameterDescriptor pd = this.coreParameterDescriptor.getHIPParameterDescriptor("credit_buffer_allocation_aux");
        Vector rangeItems = MWParameterDescriptorHelper.enumuraterangetItems((IParameterDescriptor)pd);
        IParameterDescriptor pd1 = this.coreParameterDescriptor.getHIPParameterDescriptor("low_priority_vc");
        return true;
    }

    class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            System.out.println("error  : " + e.toString());
            JOptionPane.showMessageDialog((Component)new WPanel(), e.toString() + StaticValues.NL + "Reverting back to default settings for " + MVCConstants.getResourceString("PCIE_Rx_Buffer_Space_Allocation.Title"), "Error while reading  " + PCIEUIValidatorSystemSettings.this.getParameters().getP_pcie_custom_rx_buffer_xml().trim(), 0);
            ((PCIECompilerCoreParameters)PCIEUIValidatorSystemSettings.this.parameters).setP_pcie_custom_rx_buffer_xml("0");
            try {
                PCIEUIValidatorSystemSettings.this.autoSetRxBufferOptions();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void fatalError(SAXParseException e) {
            System.out.println("fatalError  : " + e.toString());
        }

        @Override
        public void warning(SAXParseException e) {
            System.out.println("warning  : " + e.toString());
        }
    }
}

