/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import com.altera.entityinterfaces.IParameterDescriptorInstance;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.model.ICoreParameterDescriptorRetriever;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.IValidator;
import com.altera.sopcmodel.util.Message;
import com.altera.sopcmodel.util.ParameterDescriptor;
import java.util.List;
import java.util.Vector;

public class PCIEUIValidatorBarTable
implements IValidator {
    private IMessageLogger logger;
    private ICoreParameterDescriptorRetriever coreParameterDescriptor = null;
    private final ParameterDescriptor.Range rangePrefetchable64 = new ParameterDescriptor.Range((Object)"64-bit Prefetchable Memory", (Object)"64-bit Prefetchable Memory");
    private final ParameterDescriptor.Range rangePrefetchable32 = new ParameterDescriptor.Range((Object)"32-bit Prefetchable Memory", (Object)"32-bit Prefetchable Memory");
    private final ParameterDescriptor.Range rangeNonPrefetchable32 = new ParameterDescriptor.Range((Object)"32-bit Non-Prefetchable Memory", (Object)"32-bit Non-Prefetchable Memory");
    private final ParameterDescriptor.Range rangeDisable = new ParameterDescriptor.Range((Object)"Disable this and all higher BARs", (Object)"Disable this and all higher BARs");
    private final ParameterDescriptor.Range rangeExpRomDisable = new ParameterDescriptor.Range((Object)"Disable", (Object)"Disable");
    private final ParameterDescriptor.Range rangeExpRomEnable = new ParameterDescriptor.Range((Object)"Enable", (Object)"Enable");
    public static final String MSG_64BITBAR_32BITBUS = "64Bit bar in a non-64Bit PCI Bus";

    @Override
    public boolean validate(IPCIECompilerCoreParameters parameters, ICoreParameterDescriptorRetriever coreParameterDescriptor) {
        if (coreParameterDescriptor == null) {
            return false;
        }
        this.coreParameterDescriptor = coreParameterDescriptor;
        boolean result = true;
        result &= this.validateLegalBarType(parameters);
        result &= this.validateBarType(parameters);
        result &= this.validatePCIAddress(parameters);
        return result &= this.validateAvalonAddress(parameters);
    }

    private boolean validateLegalBarType(IPCIECompilerCoreParameters parameters) {
        for (int barNumber = 0; barNumber < 6; ++barNumber) {
            IParameterDescriptorInstance pd = this.getParameterDescriptor("uiPCIBar" + barNumber + "Type");
            IParameterDescriptorInstance p_pcie_bar_type_bar_num_pd = this.getParameterDescriptor("p_pcie_bar_type_bar_" + barNumber);
            List ranges = new Vector();
            ranges = p_pcie_bar_type_bar_num_pd.getLegalRanges();
            pd.setLegalRanges(ranges);
        }
        IParameterDescriptorInstance pd = this.getParameterDescriptor("uiExpROMType");
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        ranges.add(this.rangeExpRomDisable);
        ranges.add(this.rangeExpRomEnable);
        pd.setLegalRanges(ranges);
        return true;
    }

    private boolean validateBarType(IPCIECompilerCoreParameters parameters) {
        IParameterDescriptorInstance enumValues;
        block6: for (int barNumber = 0; barNumber < 6; ++barNumber) {
            Enum[] enumValues2;
            String barType = parameters.getValue("uiPCIBar" + barNumber + "Type", String.class);
            IParameterDescriptorInstance pd_bar_size = this.getParameterDescriptor("p_pcie_bar_size_bar_" + barNumber);
            IParameterDescriptorInstance pd_avalon_address = this.getParameterDescriptor("p_pci_bar_" + barNumber + "_avalon_address");
            IParameterDescriptorInstance pd_hardwired = this.getParameterDescriptor("p_pci_bar_" + barNumber + "_hardwired");
            IParameterDescriptorInstance pd_pci_address = this.getParameterDescriptor("p_pci_bar_" + barNumber + "_pci_address");
            IParameterDescriptorInstance pd_uiBar0PCIAddress = this.getParameterDescriptor("uiBar" + barNumber + "PCIAddress");
            Enum ebarType = null;
            for (Enum myenum : enumValues2 = (Enum[])EPCIBarType.class.getEnumConstants()) {
                if (!myenum.toString().trim().equalsIgnoreCase(barType)) continue;
                ebarType = Enum.valueOf(EPCIBarType.class, myenum.name());
            }
            switch (1.$SwitchMap$com$altera$megacore$pcie$model$validators$PCIEUIValidatorBarTable$EPCIBarType[ebarType.ordinal()]) {
                case 1: 
                case 2: {
                    pd_bar_size.setEnabled(false);
                    pd_bar_size.setVisible(false);
                    pd_avalon_address.setEnabled(false);
                    pd_avalon_address.setVisible(false);
                    pd_hardwired.setEnabled(false);
                    pd_hardwired.setVisible(false);
                    pd_pci_address.setEnabled(false);
                    pd_pci_address.setVisible(false);
                    pd_uiBar0PCIAddress.setVisible(false);
                    continue block6;
                }
                default: {
                    pd_bar_size.setEnabled(true);
                    pd_bar_size.setVisible(true);
                    pd_avalon_address.setVisible(true);
                    pd_hardwired.setVisible(true);
                    pd_pci_address.setVisible(true);
                    pd_uiBar0PCIAddress.setVisible(true);
                }
            }
        }
        String barType = parameters.getValue("uiExpROMType", String.class);
        Enum expROMbarType = null;
        for (Enum myenum : enumValues = (IParameterDescriptorInstance)EExpROMBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(barType)) continue;
            expROMbarType = Enum.valueOf(EExpROMBarType.class, myenum.name());
        }
        IParameterDescriptorInstance pd = this.getParameterDescriptor("p_pcie_exp_rom_bar_size");
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$validators$PCIEUIValidatorBarTable$EExpROMBarType[expROMbarType.ordinal()]) {
            case 1: 
            case 2: {
                pd.setEnabled(false);
                pd.setVisible(false);
                break;
            }
            default: {
                pd.setEnabled(true);
                pd.setVisible(true);
            }
        }
        return true;
    }

    private boolean validatePCIAddress(IPCIECompilerCoreParameters parameters) {
        for (int barNumber = 0; barNumber < 6; ++barNumber) {
            IParameterDescriptorInstance pd = this.getParameterDescriptor("uiBar" + barNumber + "PCIAddress");
            boolean isHardwired = parameters.getValue("p_pci_bar_" + barNumber + "_hardwired", Boolean.TYPE);
            if (isHardwired) {
                pd.setEnabled(true);
                continue;
            }
            pd.setEnabled(false);
        }
        return true;
    }

    private boolean validateAvalonAddress(IPCIECompilerCoreParameters parameters) {
        for (int barNumber = 0; barNumber < 6; ++barNumber) {
            int barSize = this.getBitWidth(parameters.getValue("p_pcie_bar_size_bar_" + barNumber, String.class));
            if (barSize < 1) {
                this.getParameterDescriptor("p_pci_bar_" + barNumber + "_avalon_address").setEnabled(false);
                this.getParameterDescriptor("p_pci_bar_" + barNumber + "_hardwired").setEnabled(false);
                this.getParameterDescriptor("p_pci_bar_" + barNumber + "_pci_address").setEnabled(false);
                continue;
            }
            this.getParameterDescriptor("p_pci_bar_" + barNumber + "_avalon_address").setEnabled(true);
            this.getParameterDescriptor("p_pci_bar_" + barNumber + "_hardwired").setEnabled(true);
        }
        return true;
    }

    private int getBitWidth(String value) {
        if (value.equalsIgnoreCase("N/A") || value.equalsIgnoreCase("Auto")) {
            return 0;
        }
        return Integer.parseInt(value.substring(value.length() - 7, value.length() - 5).replaceAll(" ", "0"));
    }

    @Override
    public void setMessageLogger(IMessageLogger messageLogger) {
        this.logger = messageLogger;
    }

    private void addErrorMessage(String message, EMessageID messageID, IPCIECompilerCoreParameters parameters) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Error);
        m.setObject((Object)parameters);
        m.setObjectName(parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    private void addMessage(IMessage message) {
        if (this.getMessageLogger() != null) {
            IMessageLogger messageLogger = this.getMessageLogger();
            messageLogger.receiveMessage(message);
        }
    }

    IMessageLogger getMessageLogger() {
        return this.logger;
    }

    private IParameterDescriptorInstance getParameterDescriptor(String name) {
        return this.coreParameterDescriptor.getParameterDescriptor(name);
    }

    private static enum EPCIBarType {
        Prefectable32("32-Bit Prefetchable Memory"),
        NonPrefectable32("32-Bit Non-Prefetchable Memory"),
        Prefectable64("64-Bit Prefetchable Memory"),
        IO("I/O Address Space"),
        Disable("Disable this and all higher BARs"),
        NA("N/A"),
        SelectType("Select Type to Enable");

        private String displayString;

        private EPCIBarType(String displayString) {
            this.displayString = displayString;
        }

        public String toString() {
            return this.displayString;
        }

        public String toStaticDisplayString() {
            switch (this) {
                case Disable: {
                    return "";
                }
            }
            return this.toString();
        }
    }

    private static enum EExpROMBarType {
        Enable("Enable"),
        Enabled("Enabled"),
        Disable("Disable"),
        SelectType("Select to Enable");

        private String displayString;

        private EExpROMBarType(String displayString) {
            this.displayString = displayString;
        }

        public String toString() {
            return this.displayString;
        }

        public String toStaticDisplayString() {
            switch (this) {
                case Disable: {
                    return "";
                }
            }
            return this.toString();
        }
    }
}

