/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import altera.ipbu.flowbase.exceptions.OutOfRangeException;
import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.entityinterfaces.IParameterDescriptorInstance;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.model.ICoreParameterDescriptorRetriever;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.IValidator;
import com.altera.sopcmodel.util.Message;
import com.altera.sopcmodel.util.ParameterDescriptor;
import java.util.List;
import java.util.Vector;

public class PCIEUIValidatorAvalonConfiguration
implements IValidator {
    private IMessageLogger logger;
    private ICoreParameterDescriptorRetriever coreParameterDescriptor = null;
    private IPCIECompilerCoreParameters parameters = null;
    private static List<IParameterDescriptor.Range> ranges32Bit = new Vector<IParameterDescriptor.Range>();
    private static List<IParameterDescriptor.Range> ranges64Bit = new Vector<IParameterDescriptor.Range>();

    @Override
    public boolean validate(IPCIECompilerCoreParameters parameters, ICoreParameterDescriptorRetriever coreParameterDescriptor) {
        if (coreParameterDescriptor == null) {
            return false;
        }
        if (parameters == null) {
            return false;
        }
        this.coreParameterDescriptor = coreParameterDescriptor;
        this.parameters = parameters;
        boolean result = true;
        result &= this.updateAvalonTranslationMainPanel();
        result &= this.updateAvalonTranslationTable();
        result &= this.validatePCIAddressType(this.getParameters());
        return result &= this.validatePCIeBaseAddress(this.getParameters());
    }

    private boolean updateAvalonTranslationMainPanel() {
        if (this.getParameters().isP_pci_master()) {
            this.getParameterDescriptor("uiFixedTable").setEnabled(true);
            this.getParameterDescriptor("uiPaneCount").setEnabled(true);
            this.getParameterDescriptor("uiPaneSize").setEnabled(true);
            this.getParameterDescriptor("translationTableSizeInfo").setEnabled(true);
        } else {
            this.getParameterDescriptor("uiFixedTable").setEnabled(false);
            this.getParameterDescriptor("uiPaneCount").setEnabled(false);
            this.getParameterDescriptor("uiPaneSize").setEnabled(false);
            this.getParameterDescriptor("translationTableSizeInfo").setEnabled(false);
        }
        if (!this.getParameters().isP_avalon_hardwired_address_map() && !this.getParameters().getUiPCIDeviceMode().equals((Object)IPCIECompilerCoreParameters.EPCIDeviceMode.targetOnly) || this.getParameters().isP_pci_host_bridge()) {
            this.getParameterDescriptor("p_pci_impl_cra_av_slave_port").setEnabled(false);
            this.getParameters().getModuleCore().setValue("p_pci_impl_cra_av_slave_port", Boolean.TRUE);
        } else if (this.getParameters().getUiPCIDeviceMode().equals((Object)IPCIECompilerCoreParameters.EPCIDeviceMode.mmLite)) {
            this.getParameterDescriptor("p_pci_impl_cra_av_slave_port").setEnabled(false);
            this.getParameters().getModuleCore().setValue("p_pci_impl_cra_av_slave_port", Boolean.FALSE);
        } else {
            this.getParameterDescriptor("p_pci_impl_cra_av_slave_port").setEnabled(true);
        }
        if (this.getParameters().getUiPCIDeviceMode().equals((Object)IPCIECompilerCoreParameters.EPCIDeviceMode.mmLite)) {
            this.getParameterDescriptor("p_pci_single_clock").setEnabled(false);
            this.getParameters().getModuleCore().setValue("p_pci_single_clock", Boolean.TRUE);
        } else {
            this.getParameterDescriptor("p_pci_single_clock").setEnabled(true);
        }
        return true;
    }

    private boolean updateAvalonTranslationTable() {
        if (!this.getParameters().isP_avalon_hardwired_address_map() || !this.getParameters().isP_pci_master()) {
            this.getParameterDescriptor("uiAvalonTranslationTable").setEnabled(false);
        } else {
            this.getParameterDescriptor("uiAvalonTranslationTable").setEnabled(true);
        }
        return true;
    }

    private boolean validatePCIAddressType(IPCIECompilerCoreParameters parameters) {
        IParameterDescriptorInstance pd = null;
        if (parameters.isP_avalon_hardwired_address_map()) {
            for (int row = 0; row < parameters.getP_avalon_pane_count(); ++row) {
                pd = row < 10 ? this.getParameterDescriptor("p_avalon_hw_pci_address_0" + row + "_type") : this.getParameterDescriptor("p_avalon_hw_pci_address_" + row + "_type");
                if (parameters.isP_pci_64bit_bus()) {
                    pd.setLegalRanges(ranges64Bit);
                    continue;
                }
                pd.setLegalRanges(ranges32Bit);
            }
        }
        return true;
    }

    private boolean validatePCIeBaseAddress(IPCIECompilerCoreParameters parameters) {
        if (parameters.isP_avalon_hardwired_address_map()) {
            for (int row = 0; row < parameters.getP_avalon_pane_count(); ++row) {
                String paramName = row < 10 ? "p_avalon_hw_pci_address_0" + row : "p_avalon_hw_pci_address_" + row;
                try {
                    String value = this.validateValue(this.getParameters().getValue(paramName, String.class));
                    ((PCIECompilerCoreParameters)parameters).setValue(paramName, value);
                    continue;
                }
                catch (OutOfRangeException e) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private String validateValue(Object value) throws OutOfRangeException {
        int digit;
        int i;
        String sValue = value.toString();
        StringBuffer BARMask = new StringBuffer(40);
        String binStartingPCIAddress = "";
        long lStartingPCIAddress = 0L;
        String sStartingPCIAddress = "";
        long lValidStartingAddress = 0L;
        String szeroPattern = "";
        String snewStartingPCIAddress = "";
        long lnewStartingPCIAddress = 0L;
        if (value.toString().length() == 18) {
            sStartingPCIAddress = value.toString().substring(10, value.toString().length());
            sValue = value.toString().substring(0, 10);
        } else if (value.toString().length() == 10) {
            sStartingPCIAddress = value.toString().substring(2, value.toString().length());
            sValue = value.toString().substring(0, 2);
        }
        for (i = 0; i < sStartingPCIAddress.length(); ++i) {
            digit = PCIEUIValidatorAvalonConfiguration.hexValue(sStartingPCIAddress.charAt(i));
            if (digit == -1) continue;
            lStartingPCIAddress = 16L * lStartingPCIAddress + (long)digit;
        }
        while (lStartingPCIAddress > 0L) {
            long remainder = lStartingPCIAddress % 2L;
            lStartingPCIAddress /= 2L;
            binStartingPCIAddress = PCIEUIValidatorAvalonConfiguration.int2String((int)remainder) + binStartingPCIAddress;
        }
        for (i = 0; i < this.getParameters().getP_avalon_pane_size(); ++i) {
            szeroPattern = szeroPattern + "0";
        }
        binStartingPCIAddress = binStartingPCIAddress.trim().equals("") || binStartingPCIAddress.length() < this.getParameters().getP_avalon_pane_size() ? "0" : binStartingPCIAddress.substring(0, binStartingPCIAddress.length() - this.getParameters().getP_avalon_pane_size()) + szeroPattern;
        for (i = 0; i < binStartingPCIAddress.length(); ++i) {
            digit = PCIEUIValidatorAvalonConfiguration.hexValue(binStartingPCIAddress.charAt(i));
            if (digit == -1) continue;
            lnewStartingPCIAddress = 2L * lnewStartingPCIAddress + (long)digit;
        }
        while (lnewStartingPCIAddress > 0L) {
            long remainder = lnewStartingPCIAddress % 16L;
            lnewStartingPCIAddress /= 16L;
            snewStartingPCIAddress = PCIEUIValidatorAvalonConfiguration.int2String((int)remainder) + snewStartingPCIAddress;
        }
        snewStartingPCIAddress = sValue + PCIEUIValidatorAvalonConfiguration.pad(snewStartingPCIAddress, -8, "0");
        return snewStartingPCIAddress;
    }

    @Override
    public void setMessageLogger(IMessageLogger messageLogger) {
        this.logger = messageLogger;
    }

    private void addErrorMessage(String message, EMessageID messageID, IPCIECompilerCoreParameters parameters) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Error);
        m.setObject((Object)parameters);
        m.setObjectName(parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    private void addMessage(IMessage message) {
        if (this.getMessageLogger() != null) {
            IMessageLogger messageLogger = this.getMessageLogger();
            messageLogger.receiveMessage(message);
        }
    }

    IMessageLogger getMessageLogger() {
        return this.logger;
    }

    private IParameterDescriptorInstance getParameterDescriptor(String name) {
        return this.coreParameterDescriptor.getParameterDescriptor(name);
    }

    private IPCIECompilerCoreParameters getParameters() {
        return this.parameters;
    }

    protected static String pad(Object str, int padlen, String pad) {
        String padding = new String();
        int len = Math.abs(padlen) - str.toString().length();
        if (len < 1) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            padding = padding + pad;
        }
        return padlen < 0 ? padding + str : str + padding;
    }

    protected static int hexValue(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    protected static String int2String(int n) {
        String s = "";
        switch (n) {
            case 0: {
                s = "0";
                break;
            }
            case 1: {
                s = "1";
                break;
            }
            case 2: {
                s = "2";
                break;
            }
            case 3: {
                s = "3";
                break;
            }
            case 4: {
                s = "4";
                break;
            }
            case 5: {
                s = "5";
                break;
            }
            case 6: {
                s = "6";
                break;
            }
            case 7: {
                s = "7";
                break;
            }
            case 8: {
                s = "8";
                break;
            }
            case 9: {
                s = "9";
                break;
            }
            case 10: {
                s = "A";
                break;
            }
            case 11: {
                s = "B";
                break;
            }
            case 12: {
                s = "C";
                break;
            }
            case 13: {
                s = "D";
                break;
            }
            case 14: {
                s = "E";
                break;
            }
            case 15: {
                s = "F";
            }
        }
        return s;
    }

    static {
        ranges32Bit.add((IParameterDescriptor.Range)new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit, (Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit));
        ranges64Bit.add((IParameterDescriptor.Range)new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory64Bit, (Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory64Bit));
        ranges64Bit.add((IParameterDescriptor.Range)new ParameterDescriptor.Range((Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit, (Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit));
    }
}

