/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import com.altera.entityinterfaces.IParameterDescriptorInstance;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.model.ICoreParameterDescriptorRetriever;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.IValidator;
import com.altera.sopcmodel.util.Message;
import com.altera.utilities.AltString;

public class PCIEModelValidatorBarAddress
implements IValidator {
    private ICoreParameterDescriptorRetriever coreParameterDescriptor = null;
    private IPCIECompilerCoreParameters parameters = null;
    private IMessageLogger logger;

    @Override
    public boolean validate(IPCIECompilerCoreParameters parameters, ICoreParameterDescriptorRetriever coreParameterDescriptor) {
        if (coreParameterDescriptor == null) {
            return false;
        }
        if (parameters == null) {
            return false;
        }
        this.coreParameterDescriptor = coreParameterDescriptor;
        this.parameters = parameters;
        boolean result = true;
        return result &= this.validateAvalonAddress();
    }

    private boolean validatePCIHardwiredAddress() {
        boolean result = true;
        for (int barIndex = 0; barIndex < 6; ++barIndex) {
            boolean bHardwiredAddress;
            boolean barUsed = this.getParameters().getValue("p_pcie_bar_used_bar_" + barIndex, Boolean.TYPE);
            if (!barUsed || !(bHardwiredAddress = this.getParameters().getValue("p_pci_bar_" + barIndex + "_hardwired", Boolean.TYPE).booleanValue())) continue;
            int iNumAddressBits = this.getBitWidth(this.getParameters().getValue("p_pci_bar_size_bar_" + barIndex, String.class));
            String strHardwiredAddress = this.getParameters().getValue("uiBar" + barIndex + "PCIAddress", String.class);
            try {
                String validate = this.Validate(strHardwiredAddress, iNumAddressBits);
                if (validate.equalsIgnoreCase(strHardwiredAddress)) {
                    result &= true;
                    continue;
                }
                this.addErrorMessage("Invalid PCI address " + strHardwiredAddress + " for BAR " + barIndex + ". " + "Did you mean " + validate + "?", EMessageID.IllegalValue);
                result &= false;
                continue;
            }
            catch (Exception e) {
                this.addErrorMessage("Error in validation of PCI address for BAR " + barIndex, EMessageID.IllegalValue);
                result &= false;
            }
        }
        return result;
    }

    private boolean validateAvalonAddress() {
        boolean result = true;
        for (int barIndex = 0; barIndex < 6; ++barIndex) {
            boolean bAutoAvalonAddress;
            boolean barUsed = this.getParameters().getValue("p_pcie_bar_used_bar_" + barIndex, Boolean.TYPE);
            if (!barUsed || (bAutoAvalonAddress = this.getParameters().getValue("p_pci_bar_" + barIndex + "_auto_avalon_address", Boolean.TYPE).booleanValue())) continue;
            int iNumAddressBits = this.getBitWidth(this.getParameters().getValue("p_pcie_bar_size_bar_" + barIndex, String.class));
            int lAvalonAddress = this.getParameters().getValue("p_pci_bar_" + barIndex + "_avalon_address", Integer.TYPE);
            String strAvalonAddress = AltString.longTo0xHexString((long)lAvalonAddress, (int)8);
            try {
                String validate = this.Validate(strAvalonAddress, iNumAddressBits);
                if (validate.equalsIgnoreCase(strAvalonAddress)) {
                    result &= true;
                    continue;
                }
                this.addErrorMessage("Invalid Avalon address for BAR " + barIndex + ". " + "Did you mean " + validate + "?", EMessageID.IllegalValue);
                result &= false;
                continue;
            }
            catch (Exception e) {
                this.addErrorMessage("Error in validation of Avalon address out of range for BAR " + barIndex, EMessageID.IllegalValue);
                result &= false;
            }
        }
        return result;
    }

    private int getBitWidth(String value) {
        if (value.equalsIgnoreCase("N/A") || value.equalsIgnoreCase("Auto")) {
            return 0;
        }
        return Integer.parseInt(value.substring(value.length() - 7, value.length() - 5).replaceAll(" ", "0"));
    }

    private void addErrorMessage(String message, EMessageID messageID) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Error);
        m.setObject((Object)this.getParameters());
        m.setObjectName(this.parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    private void addInfoMessage(String message, EMessageID messageID) {
        Message m = Message.create((EMessageID)messageID);
        m.setLevel(EMessageLevel.Info);
        m.setObject((Object)this.getParameters());
        m.setObjectName(this.parameters.getModuleCore().getName());
        m.setProblemDescription(message);
        this.addMessage((IMessage)m);
    }

    @Override
    public void setMessageLogger(IMessageLogger messageLogger) {
        this.logger = messageLogger;
    }

    private void addMessage(IMessage message) {
        if (this.getMessageLogger() != null) {
            IMessageLogger messageLogger = this.getMessageLogger();
            messageLogger.receiveMessage(message);
        }
    }

    IMessageLogger getMessageLogger() {
        return this.logger;
    }

    private IParameterDescriptorInstance getParameterDescriptor(String name) {
        return this.coreParameterDescriptor.getParameterDescriptor(name);
    }

    public IPCIECompilerCoreParameters getParameters() {
        return this.parameters;
    }

    private String Validate(String value, long p_Num_Address_Bits) {
        int digit;
        int i;
        String sValue = value.toString();
        StringBuffer BARMask = new StringBuffer(40);
        String binStartingPCIAddress = "";
        long lStartingPCIAddress = 0L;
        String sStartingPCIAddress = "";
        long lValidStartingAddress = 0L;
        String szeroPattern = "";
        String snewStartingPCIAddress = "";
        long lnewStartingPCIAddress = 0L;
        if (value.toString().length() == 18) {
            sStartingPCIAddress = value.toString().substring(10, value.toString().length());
            sValue = value.toString().substring(0, 10);
        } else if (value.toString().length() == 10) {
            sStartingPCIAddress = value.toString().substring(2, value.toString().length());
            sValue = value.toString().substring(0, 2);
        }
        for (i = 0; i < sStartingPCIAddress.length(); ++i) {
            digit = this.hexValue(sStartingPCIAddress.charAt(i));
            if (digit == -1) continue;
            lStartingPCIAddress = 16L * lStartingPCIAddress + (long)digit;
        }
        while (lStartingPCIAddress > 0L) {
            long remainder = lStartingPCIAddress % 2L;
            lStartingPCIAddress /= 2L;
            binStartingPCIAddress = this.int2String((int)remainder) + binStartingPCIAddress;
        }
        i = 0;
        while ((long)i < p_Num_Address_Bits) {
            szeroPattern = szeroPattern + "0";
            ++i;
        }
        binStartingPCIAddress = binStartingPCIAddress.trim().equals("") || (long)binStartingPCIAddress.length() < p_Num_Address_Bits ? "0" : binStartingPCIAddress.substring(0, binStartingPCIAddress.length() - (int)p_Num_Address_Bits) + szeroPattern;
        for (i = 0; i < binStartingPCIAddress.length(); ++i) {
            digit = this.hexValue(binStartingPCIAddress.charAt(i));
            if (digit == -1) continue;
            lnewStartingPCIAddress = 2L * lnewStartingPCIAddress + (long)digit;
        }
        while (lnewStartingPCIAddress > 0L) {
            long remainder = lnewStartingPCIAddress % 16L;
            lnewStartingPCIAddress /= 16L;
            snewStartingPCIAddress = this.int2String((int)remainder) + snewStartingPCIAddress;
        }
        snewStartingPCIAddress = sValue + PCIEModelValidatorBarAddress.pad(snewStartingPCIAddress, -8, "0");
        return snewStartingPCIAddress;
    }

    private String int2String(int pHepHexInt) {
        String s = "";
        switch (pHepHexInt) {
            case 0: {
                s = "0";
                break;
            }
            case 1: {
                s = "1";
                break;
            }
            case 2: {
                s = "2";
                break;
            }
            case 3: {
                s = "3";
                break;
            }
            case 4: {
                s = "4";
                break;
            }
            case 5: {
                s = "5";
                break;
            }
            case 6: {
                s = "6";
                break;
            }
            case 7: {
                s = "7";
                break;
            }
            case 8: {
                s = "8";
                break;
            }
            case 9: {
                s = "9";
                break;
            }
            case 10: {
                s = "A";
                break;
            }
            case 11: {
                s = "B";
                break;
            }
            case 12: {
                s = "C";
                break;
            }
            case 13: {
                s = "D";
                break;
            }
            case 14: {
                s = "E";
                break;
            }
            case 15: {
                s = "F";
            }
        }
        return s;
    }

    private int hexValue(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    private static String pad(Object str, int padlen, String pad) {
        String padding = new String();
        int len = Math.abs(padlen) - str.toString().length();
        if (len < 1) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            padding = padding + pad;
        }
        return padlen < 0 ? padding + str : str + padding;
    }
}

