/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.validators;

import com.altera.entityinterfaces.IParameterDescriptorInstance;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.model.ICoreParameterDescriptorRetriever;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.IValidator;
import com.altera.megacore.pcie.model.validators.PCIEModelValidatorBarAddress;
import com.altera.megacore.pcie.model.validators.PCIEUIValidatorAvalonConfiguration;
import com.altera.megacore.pcie.model.validators.PCIEUIValidatorBarTable;
import com.altera.megacore.pcie.model.validators.PCIEUIValidatorSystemSettings;
import java.util.Collection;
import java.util.Vector;

public class PCIEModelValidator
implements IValidator {
    private IMessageLogger logger;
    private ICoreParameterDescriptorRetriever coreParameterDescriptor = null;
    private Collection<IValidator> validators = new Vector<IValidator>();

    public PCIEModelValidator() {
        this.validators.add(new PCIEModelValidatorBarAddress());
        this.validators.add(new PCIEUIValidatorSystemSettings());
        this.validators.add(new PCIEUIValidatorBarTable());
        this.validators.add(new PCIEUIValidatorAvalonConfiguration());
    }

    @Override
    public boolean validate(IPCIECompilerCoreParameters parameters, ICoreParameterDescriptorRetriever coreParameterDescriptor) {
        this.coreParameterDescriptor = coreParameterDescriptor;
        if (coreParameterDescriptor == null) {
            return false;
        }
        boolean result = true;
        long start = System.currentTimeMillis();
        for (IValidator validator : this.validators) {
            result &= validator.validate(parameters, coreParameterDescriptor);
        }
        long end = System.currentTimeMillis();
        return result;
    }

    @Override
    public void setMessageLogger(IMessageLogger messageLogger) {
        this.logger = messageLogger;
        for (IValidator validator : this.validators) {
            validator.setMessageLogger(messageLogger);
        }
    }

    private void addMessage(IMessage message) {
        if (this.getMessageLogger() != null) {
            IMessageLogger messageLogger = this.getMessageLogger();
            messageLogger.receiveMessage(message);
        }
    }

    IMessageLogger getMessageLogger() {
        return this.logger;
    }

    private IParameterDescriptorInstance getParameterDescriptor(String name) {
        return this.coreParameterDescriptor.getParameterDescriptor(name);
    }
}

