/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model.parametercustomizers;

import com.altera.entityinterfaces.IElement;
import com.altera.megacore.pcie.model.parametercustomizers.IParameterDescriptorCustomizer;
import com.altera.sopcmodel.util.ParameterDescriptor;
import java.util.Map;
import java.util.Vector;

public class PCIECompilerCoreParameterDescriptorCustomizer
implements IParameterDescriptorCustomizer {
    @Override
    public void customize(IElement parameter, Map<String, ParameterDescriptor> parameterDescriptorMap) {
        this.customizeInitialDisplay(parameter, parameterDescriptorMap);
        this.initBarHardwiredBoolean(parameter, parameterDescriptorMap);
        this.initUIPaneCount(parameterDescriptorMap);
    }

    private void customizeInitialDisplay(IElement parameter, Map<String, ParameterDescriptor> parameterDescriptorMap) {
        String[] strBarTableParameters;
        for (String strBarTableParameter : strBarTableParameters = new String[]{"p_pcie_bar_size_bar_1", "p_pcie_bar_size_bar_2", "p_pcie_bar_size_bar_3", "p_pcie_bar_size_bar_4", "p_pcie_bar_size_bar_5", "p_pci_bar_1_avalon_address", "p_pci_bar_2_avalon_address", "p_pci_bar_3_avalon_address", "p_pci_bar_4_avalon_address", "p_pci_bar_5_avalon_address", "p_pci_bar_1_hardwired", "p_pci_bar_2_hardwired", "p_pci_bar_3_hardwired", "p_pci_bar_4_hardwired", "p_pci_bar_5_hardwired", "uiBar1PCIAddress", "uiBar2PCIAddress", "uiBar3PCIAddress", "uiBar4PCIAddress", "uiBar5PCIAddress"}) {
            ParameterDescriptor pd = parameterDescriptorMap.get(strBarTableParameter);
            pd.setEnabled(false);
            pd.setVisible(false);
        }
    }

    private void initBarHardwiredBoolean(IElement parameter, Map<String, ParameterDescriptor> parameterDescriptorMap) {
        ParameterDescriptor.Range rangeBooleanTrue = new ParameterDescriptor.Range((Object)Boolean.TRUE, (Object)Boolean.TRUE);
        ParameterDescriptor.Range rangeBooleanFalse = new ParameterDescriptor.Range((Object)Boolean.FALSE, (Object)Boolean.FALSE);
        for (int barNumber = 0; barNumber < 6; ++barNumber) {
            ParameterDescriptor pd = parameterDescriptorMap.get("p_pci_bar_" + barNumber + "_hardwired");
            Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
            ranges.add(rangeBooleanTrue);
            ranges.add(rangeBooleanFalse);
            pd.setLegalRanges(ranges);
        }
    }

    private void initUIPaneCount(Map<String, ParameterDescriptor> parameterDescriptorMap) {
        Integer[] paneCountChoices;
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>();
        for (Integer i : paneCountChoices = new Integer[]{1, 2, 4, 8, 16}) {
            ranges.add(new ParameterDescriptor.Range((Object)i, (Object)i));
        }
        ParameterDescriptor pd = parameterDescriptorMap.get("uiPaneCount");
        pd.setLegalRanges(ranges);
    }
}

