/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model;

import com.altera.entityinterfaces.IParameterDescriptorInstance;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.sopcmodel.util.ParameterDescriptor;
import java.util.Vector;

public class PCIECompilerParameterHelper {
    private PCIECompilerCoreParameters pciCoreParameters;

    public PCIECompilerParameterHelper(PCIECompilerCoreParameters pciCoreParameters) {
        this.pciCoreParameters = pciCoreParameters;
    }

    private PCIECompilerCoreParameters getCoreParameters() {
        return this.pciCoreParameters;
    }

    private Vector<Integer> getPageNumberVector(boolean bFixedAddressMap) {
        Vector<Integer> vValues;
        if (bFixedAddressMap) {
            vValues = new Vector<Integer>(5);
            vValues.addElement(1);
            vValues.addElement(2);
            vValues.addElement(4);
            vValues.addElement(8);
            vValues.addElement(16);
        } else {
            vValues = new Vector(10);
            vValues.addElement(2);
            vValues.addElement(4);
            vValues.addElement(8);
            vValues.addElement(16);
            vValues.addElement(32);
            vValues.addElement(64);
            vValues.addElement(128);
            vValues.addElement(256);
            vValues.addElement(512);
        }
        return vValues;
    }

    private Vector<Integer> getPageSizeVector(boolean p_avalon_hardwired_address_map) {
        Vector<Integer> vecValues = new Vector<Integer>(20);
        if (p_avalon_hardwired_address_map) {
            for (int i = 12; i < 32; ++i) {
                vecValues.add(i);
            }
        } else {
            for (int i = 12; i < 32; ++i) {
                vecValues.add(i);
            }
        }
        return vecValues;
    }

    private void PupulateComboBox(IParameterDescriptorInstance pd, Vector<Integer> vValues, int inumValues) {
        Vector<ParameterDescriptor.Range> ranges = new Vector<ParameterDescriptor.Range>(vValues.size());
        for (int i = 0; i < vValues.size() - inumValues; ++i) {
            ParameterDescriptor.Range avalonPaneSizeRange = new ParameterDescriptor.Range((Object)vValues.elementAt(i), (Object)vValues.elementAt(i));
            ranges.add(avalonPaneSizeRange);
        }
        pd.setLegalRanges(ranges);
    }

    void populatePageSize(int pciAvalonPaneCount, IParameterDescriptorInstance pd) {
        boolean p_avalon_hardwired_address_map = this.getCoreParameters().isP_avalon_hardwired_address_map();
        Vector<Integer> vValues = this.getPageSizeVector(p_avalon_hardwired_address_map);
        switch (pciAvalonPaneCount) {
            case 1: {
                this.PupulateComboBox(pd, vValues, 0);
                break;
            }
            case 2: {
                this.PupulateComboBox(pd, vValues, 1);
                break;
            }
            case 4: {
                this.PupulateComboBox(pd, vValues, 2);
                break;
            }
            case 8: {
                this.PupulateComboBox(pd, vValues, 3);
                break;
            }
            case 16: {
                this.PupulateComboBox(pd, vValues, 4);
                break;
            }
            case 32: {
                this.PupulateComboBox(pd, vValues, 5);
                break;
            }
            case 64: {
                this.PupulateComboBox(pd, vValues, 6);
                break;
            }
            case 128: {
                this.PupulateComboBox(pd, vValues, 7);
                break;
            }
            case 256: {
                this.PupulateComboBox(pd, vValues, 8);
                break;
            }
            case 512: {
                this.PupulateComboBox(pd, vValues, 9);
                break;
            }
        }
    }

    void AdjustComboValues(boolean bFixedAddressMap, IParameterDescriptorInstance pd) {
        Vector<Integer> vValues = this.getPageNumberVector(bFixedAddressMap);
        this.PupulateComboBox(pd, vValues, 0);
    }

    void Set_PBA_Address_Width(int pane_count, int p_avalon_pane_size) {
        try {
            int i_Cg_Avalon_S_Addr_Width;
            switch (pane_count) {
                case 1: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size;
                    break;
                }
                case 2: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 1;
                    break;
                }
                case 4: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 2;
                    break;
                }
                case 8: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 3;
                    break;
                }
                case 16: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 4;
                    break;
                }
                case 32: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 5;
                    break;
                }
                case 64: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 6;
                    break;
                }
                case 128: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 7;
                    break;
                }
                case 256: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 8;
                    break;
                }
                case 512: {
                    i_Cg_Avalon_S_Addr_Width = p_avalon_pane_size + 9;
                    break;
                }
                default: {
                    throw new Exception("Problem with the Avalon Pane Count");
                }
            }
            boolean b64bitBus = this.getCoreParameters().isP_pci_64bit_bus();
            Integer my_Cg_Avalon_S_Addr_Width = b64bitBus ? new Integer(i_Cg_Avalon_S_Addr_Width - 3) : new Integer(i_Cg_Avalon_S_Addr_Width - 2);
            this.getCoreParameters().setP_pci_bus_access_address_width(my_Cg_Avalon_S_Addr_Width);
            if (b64bitBus) {
                this.getCoreParameters().setP_pci_master_data_width(64);
            } else {
                this.getCoreParameters().setP_pci_master_data_width(32);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void populateTable(int pStartPane, int pEndPane, int pNumBits, PCIECompilerCoreParameters pciParameters) {
        try {
            int i;
            String sStatringAvAddr = null;
            String sStatringPCIAddr = null;
            String avalon_hw_address = null;
            String previous_avalon_hw_address = null;
            String avalon_hw_pci_address = null;
            String avalon_hw_pci_address_type = null;
            for (i = pStartPane; i < pEndPane; ++i) {
                avalon_hw_pci_address = "uiAvalonHWPCIAddress" + i;
                avalon_hw_address = "uiAvalonHWAddress" + i;
                if (i > 0) {
                    previous_avalon_hw_address = "uiAvalonHWAddress" + (i - 1);
                }
                avalon_hw_pci_address_type = i < 10 ? "p_avalon_hw_pci_address_0" + i + "_type" : "p_avalon_hw_pci_address_" + i + "_type";
                IPCIECompilerCoreParameters.EAvalonAddressType sType = IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit;
                if (i == 0) {
                    sStatringAvAddr = "0x00000000";
                    sStatringPCIAddr = "0x00000000";
                } else {
                    sStatringPCIAddr = sStatringAvAddr = PCIECompilerParameterHelper.getNextStartingAddress((String)pciParameters.getValue(previous_avalon_hw_address, String.class), pNumBits, sType, false);
                }
                pciParameters.setValue(avalon_hw_address, sStatringAvAddr);
                pciParameters.setValue(avalon_hw_pci_address, sStatringPCIAddr);
                pciParameters.setValue(avalon_hw_pci_address_type, (Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit);
            }
            for (i = pEndPane; i < 16; ++i) {
                avalon_hw_address = "uiAvalonHWAddress" + i;
                avalon_hw_pci_address = "uiAvalonHWPCIAddress" + i;
                avalon_hw_pci_address_type = i < 10 ? "p_avalon_hw_pci_address_0" + i + "_type" : "p_avalon_hw_pci_address_" + i + "_type";
                pciParameters.setValue(avalon_hw_address, "0x00000000");
                pciParameters.setValue(avalon_hw_pci_address, "0x00000000");
                pciParameters.setValue(avalon_hw_pci_address_type, (Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String getNextStartingAddress(String pStartingAddress, int pNumBits, IPCIECompilerCoreParameters.EAvalonAddressType addrerss_type, boolean pIs64bitBusWidth) {
        long lStartingAddress = 0L;
        String sNextStartingAddress = "";
        long lNextStartingAddress = 0L;
        pStartingAddress = pStartingAddress.substring(2, pStartingAddress.length());
        for (int i = 0; i < pStartingAddress.length(); ++i) {
            int digit = PCIECompilerParameterHelper.hexValue(pStartingAddress.charAt(i));
            if (digit == -1) continue;
            lStartingAddress = 16L * lStartingAddress + (long)digit;
        }
        for (lNextStartingAddress = lStartingAddress + (long)Math.pow(2.0, pNumBits); lNextStartingAddress > 0L; lNextStartingAddress /= 16L) {
            long remainder = lNextStartingAddress % 16L;
            sNextStartingAddress = PCIECompilerParameterHelper.int2String((int)remainder) + sNextStartingAddress;
        }
        sNextStartingAddress = PCIECompilerParameterHelper.pad(sNextStartingAddress, -8, "0");
        sNextStartingAddress = "0x" + sNextStartingAddress;
        return sNextStartingAddress;
    }

    protected static int hexValue(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    protected static String int2String(int n) {
        String s = "";
        switch (n) {
            case 0: {
                s = "0";
                break;
            }
            case 1: {
                s = "1";
                break;
            }
            case 2: {
                s = "2";
                break;
            }
            case 3: {
                s = "3";
                break;
            }
            case 4: {
                s = "4";
                break;
            }
            case 5: {
                s = "5";
                break;
            }
            case 6: {
                s = "6";
                break;
            }
            case 7: {
                s = "7";
                break;
            }
            case 8: {
                s = "8";
                break;
            }
            case 9: {
                s = "9";
                break;
            }
            case 10: {
                s = "A";
                break;
            }
            case 11: {
                s = "B";
                break;
            }
            case 12: {
                s = "C";
                break;
            }
            case 13: {
                s = "D";
                break;
            }
            case 14: {
                s = "E";
                break;
            }
            case 15: {
                s = "F";
            }
        }
        return s;
    }

    protected static String pad(Object str, int padlen, String pad) {
        String padding = new String();
        int len = Math.abs(padlen) - str.toString().length();
        if (len < 1) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            padding = padding + pad;
        }
        return padlen < 0 ? padding + str : str + padding;
    }
}

