/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model;

import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;

public class PCIECompilerBARParameterHelper {
    private PCIECompilerCoreParameters pciCoreParameters;
    boolean moving = false;

    public PCIECompilerBARParameterHelper(PCIECompilerCoreParameters pciCoreParameters) {
        this.pciCoreParameters = pciCoreParameters;
    }

    private PCIECompilerCoreParameters getCoreParameters() {
        return this.pciCoreParameters;
    }

    void validateBar0(PCIECompilerCoreParameters parameters, String uiPCIBar0Type) {
        Enum[] enumValues;
        Enum bar0Type = null;
        for (Enum myenum : enumValues = (Enum[])EPCIBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiPCIBar0Type)) continue;
            bar0Type = Enum.valueOf(EPCIBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EPCIBarType[bar0Type.ordinal()]) {
            case 2: {
                parameters.setP_pcie_bar_used_bar_0(true);
                parameters.setUiBar0Prefetchable(false);
                parameters.setP_pci_64bit_bar(false);
                break;
            }
            case 3: {
                parameters.setP_pcie_bar_used_bar_0(true);
                parameters.setUiBar0Prefetchable(true);
                parameters.setP_pci_64bit_bar(false);
                break;
            }
            case 4: {
                parameters.setP_pcie_bar_used_bar_0(true);
                parameters.setUiBar0Prefetchable(true);
                parameters.setP_pci_64bit_bar(true);
                parameters.setUiPCIBar1Type("32-bit Prefetchable Memory");
                break;
            }
            case 5: {
                parameters.setP_pcie_bar_used_bar_0(true);
                parameters.setUiBar0Prefetchable(false);
                break;
            }
            default: {
                parameters.setP_pcie_bar_used_bar_0(false);
            }
        }
    }

    void validateBar1(PCIECompilerCoreParameters parameters, String uiPCIBar1Type) {
        Enum[] enumValues;
        Enum bar1Type = null;
        for (Enum myenum : enumValues = (Enum[])EPCIBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiPCIBar1Type)) continue;
            bar1Type = Enum.valueOf(EPCIBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EPCIBarType[bar1Type.ordinal()]) {
            case 2: {
                parameters.setP_pcie_bar_used_bar_1(true);
                parameters.setUiBar1Prefetchable(false);
                break;
            }
            case 3: {
                parameters.setP_pcie_bar_used_bar_1(true);
                parameters.setUiBar1Prefetchable(true);
                break;
            }
            case 5: {
                parameters.setP_pcie_bar_used_bar_1(true);
                parameters.setUiBar1Prefetchable(false);
                break;
            }
            case 1: {
                parameters.setP_pcie_bar_size_bar_1("N/A");
                this.moveHigherBarsDownward(1, parameters);
                break;
            }
            default: {
                parameters.setP_pcie_bar_used_bar_1(false);
            }
        }
    }

    void validateBar2(PCIECompilerCoreParameters parameters, String uiPCIBar2Type) {
        Enum[] enumValues;
        Enum bar2Type = null;
        for (Enum myenum : enumValues = (Enum[])EPCIBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiPCIBar2Type)) continue;
            bar2Type = Enum.valueOf(EPCIBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EPCIBarType[bar2Type.ordinal()]) {
            case 2: {
                parameters.setP_pcie_bar_used_bar_2(true);
                parameters.setUiBar2Prefetchable(false);
                break;
            }
            case 3: {
                parameters.setP_pcie_bar_used_bar_2(true);
                parameters.setUiBar2Prefetchable(true);
                break;
            }
            case 4: {
                parameters.setP_pcie_bar_used_bar_2(true);
                parameters.setUiBar2Prefetchable(true);
                parameters.setUiPCIBar3Type("32-bit Prefetchable Memory");
                break;
            }
            case 5: {
                parameters.setP_pcie_bar_used_bar_2(true);
                parameters.setUiBar2Prefetchable(false);
                break;
            }
            case 1: {
                parameters.setP_pcie_bar_size_bar_2("N/A");
                this.moveHigherBarsDownward(2, parameters);
                break;
            }
            default: {
                parameters.setP_pcie_bar_used_bar_2(false);
            }
        }
    }

    void validateBar3(PCIECompilerCoreParameters parameters, String uiPCIBar3Type) {
        Enum[] enumValues;
        Enum bar3Type = null;
        for (Enum myenum : enumValues = (Enum[])EPCIBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiPCIBar3Type)) continue;
            bar3Type = Enum.valueOf(EPCIBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EPCIBarType[bar3Type.ordinal()]) {
            case 2: {
                parameters.setP_pcie_bar_used_bar_3(true);
                parameters.setUiBar3Prefetchable(false);
                break;
            }
            case 3: {
                parameters.setP_pcie_bar_used_bar_3(true);
                parameters.setUiBar3Prefetchable(true);
            }
            case 5: {
                parameters.setP_pcie_bar_used_bar_3(true);
                parameters.setUiBar3Prefetchable(false);
                break;
            }
            case 1: {
                parameters.setP_pcie_bar_size_bar_3("N/A");
                this.moveHigherBarsDownward(3, parameters);
                break;
            }
            default: {
                parameters.setP_pcie_bar_used_bar_3(false);
            }
        }
    }

    void validateBar4(PCIECompilerCoreParameters parameters, String uiPCIBar4Type) {
        Enum[] enumValues;
        Enum bar4Type = null;
        for (Enum myenum : enumValues = (Enum[])EPCIBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiPCIBar4Type)) continue;
            bar4Type = Enum.valueOf(EPCIBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EPCIBarType[bar4Type.ordinal()]) {
            case 2: {
                parameters.setP_pcie_bar_used_bar_4(true);
                parameters.setUiBar4Prefetchable(false);
                break;
            }
            case 3: {
                parameters.setP_pcie_bar_used_bar_4(true);
                parameters.setUiBar4Prefetchable(true);
                break;
            }
            case 4: {
                parameters.setP_pcie_bar_used_bar_4(true);
                parameters.setUiBar4Prefetchable(true);
                parameters.setUiPCIBar5Type("32-bit Prefetchable Memory");
                break;
            }
            case 5: {
                parameters.setP_pcie_bar_used_bar_4(true);
                parameters.setUiBar4Prefetchable(false);
                break;
            }
            case 1: {
                parameters.setP_pcie_bar_size_bar_4("N/A");
                this.moveHigherBarsDownward(4, parameters);
                break;
            }
            default: {
                parameters.setP_pcie_bar_used_bar_4(false);
            }
        }
    }

    void validateBar5(PCIECompilerCoreParameters parameters, String uiPCIBar5Type) {
        Enum[] enumValues;
        Enum bar5Type = null;
        for (Enum myenum : enumValues = (Enum[])EPCIBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiPCIBar5Type)) continue;
            bar5Type = Enum.valueOf(EPCIBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EPCIBarType[bar5Type.ordinal()]) {
            case 2: {
                parameters.setP_pcie_bar_used_bar_5(true);
                parameters.setUiBar5Prefetchable(false);
                break;
            }
            case 3: {
                parameters.setP_pcie_bar_used_bar_5(true);
                parameters.setUiBar5Prefetchable(true);
                break;
            }
            case 5: {
                parameters.setP_pcie_bar_used_bar_5(true);
                parameters.setUiBar5Prefetchable(false);
                break;
            }
            default: {
                parameters.setP_pcie_bar_size_bar_5("N/A");
                parameters.setP_pcie_bar_used_bar_5(false);
            }
        }
    }

    void validateExpRom(PCIECompilerCoreParameters parameters, String uiExpROMType) {
        Enum[] enumValues;
        Enum expROMbarType = null;
        for (Enum myenum : enumValues = (Enum[])EExpROMBarType.class.getEnumConstants()) {
            if (!myenum.toString().trim().equalsIgnoreCase(uiExpROMType)) continue;
            expROMbarType = Enum.valueOf(EExpROMBarType.class, myenum.name());
        }
        switch (1.$SwitchMap$com$altera$megacore$pcie$model$PCIECompilerBARParameterHelper$EExpROMBarType[expROMbarType.ordinal()]) {
            case 2: {
                parameters.setP_pcie_exp_rom_bar_used(true);
                break;
            }
            case 1: {
                parameters.setP_pcie_exp_rom_bar_used(false);
                parameters.setP_pcie_exp_rom_bar_size("N/A");
                break;
            }
            default: {
                parameters.setP_pcie_exp_rom_bar_used(false);
                parameters.setP_pcie_exp_rom_bar_size("N/A");
            }
        }
    }

    private void moveHigherBarsDownward(int barNumberBeingDisabled, PCIECompilerCoreParameters parameters) {
        if (this.moving) {
            return;
        }
        this.moving = true;
        for (int barIndex = barNumberBeingDisabled; barIndex < 6; ++barIndex) {
            String strParamNameUsed = PCIECompilerBARParameterHelper.getParameterNamePCIUsed(barIndex);
            String strParamNameSize = PCIECompilerBARParameterHelper.getParameterNameSize(barIndex);
            String strParamNameType = PCIECompilerBARParameterHelper.getParameterNameType(barIndex);
            parameters.setValue(strParamNameUsed, false);
            parameters.setValue(strParamNameSize, "N/A");
            parameters.setValue(strParamNameType, "Disable this and all higher BARs");
        }
        this.moving = false;
    }

    private void copyBar(int fromBarIndex, int toBarIndex, PCIECompilerCoreParameters parameters) {
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNamePCIUsed(toBarIndex), true);
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNameAutoAvalonAddress(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNameAutoAvalonAddress(fromBarIndex), Boolean.TYPE));
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNameAutoSized(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNameAutoSized(fromBarIndex), Boolean.TYPE));
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNameAvalonAddress(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNameAvalonAddress(fromBarIndex), Long.TYPE));
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNameHardwired(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNameHardwired(fromBarIndex), Boolean.TYPE));
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNamePCIAddress(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNamePCIAddress(fromBarIndex), Long.TYPE));
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNamePrefetchable(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNamePrefetchable(fromBarIndex), Boolean.TYPE));
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNameSize(toBarIndex), parameters.getValue(PCIECompilerBARParameterHelper.getParameterNameSize(fromBarIndex), Integer.TYPE));
    }

    private void resetBar(int barIndex, PCIECompilerCoreParameters parameters) {
        parameters.setValue(PCIECompilerBARParameterHelper.getParameterNamePCIUsed(barIndex), false);
    }

    private static String getParameterNamePCIUsed(int barNumber) {
        return "p_pcie_bar_used_bar_" + barNumber;
    }

    private static String getParameterNameAutoAvalonAddress(int barNumber) {
        return "p_pci_bar_" + barNumber + "_auto_avalon_address";
    }

    private static String getParameterNameAutoSized(int barNumber) {
        return "p_pci_bar_" + barNumber + "_auto_sized";
    }

    private static String getParameterNameAvalonAddress(int barNumber) {
        return "p_pci_bar_" + barNumber + "_avalon_address";
    }

    private static String getParameterNameHardwired(int barNumber) {
        return "p_pci_bar_" + barNumber + "_hardwired";
    }

    private static String getParameterNamePCIAddress(int barNumber) {
        return "p_pci_bar_" + barNumber + "_pci_address";
    }

    private static String getParameterNamePrefetchable(int barNumber) {
        return "uiBar" + barNumber + "Prefetchable";
    }

    private static String getParameterNameSize(int barNumber) {
        return "p_pcie_bar_size_bar_" + barNumber;
    }

    private static String getParameterNameType(int barNumber) {
        return "p_pcie_bar_type_bar_" + barNumber;
    }

    private static enum EPCIBarType {
        Prefectable32("32-Bit Prefetchable Memory"),
        NonPrefectable32("32-Bit Non-Prefetchable Memory"),
        Prefectable64("64-Bit Prefetchable Memory"),
        IO("I/O Address Space"),
        Disable("Disable this and all higher BARs"),
        NA("N/A"),
        SelectType("Select Type to Enable");

        private String displayString;

        private EPCIBarType(String displayString) {
            this.displayString = displayString;
        }

        public String toString() {
            return this.displayString;
        }

        public String toStaticDisplayString() {
            switch (this) {
                case Disable: {
                    return "";
                }
            }
            return this.toString();
        }
    }

    private static enum EExpROMBarType {
        Enable("Enable"),
        Enabled("Enabled"),
        Disable("Disable"),
        SelectType("Select to Enable");

        private String displayString;

        private EExpROMBarType(String displayString) {
            this.displayString = displayString;
        }

        public String toString() {
            return this.displayString;
        }

        public String toStaticDisplayString() {
            switch (this) {
                case Disable: {
                    return "";
                }
            }
            return this.toString();
        }
    }
}

