/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model;

import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.megacore.pcie.model.IPCIETableModel;
import com.altera.megacore.pcie.ui.MWComboMappableDisplay;
import com.altera.megacore.pcie.ui.MWFormattedTextField;
import com.altera.megacore.pcie.ui.MWHexFormattedTextField;
import com.altera.megacore.pcie.ui.PCIuiConstants;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.handler.MWEventHandler;
import com.altera.megawizard2.view.MWCombo;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class PCIEBARsTableModel
extends DefaultTableModel
implements IPCIETableModel {
    private static int MAX_BARTABLE_ROW_INDEX = 5;
    private MWEventHandler mwEventHandler = null;
    MWCombo barTypeCombo0 = new MWCombo("uiPCIBar0Type");
    MWCombo barTypeCombo1 = new MWCombo("uiPCIBar1Type");
    MWCombo barTypeCombo2 = new MWCombo("uiPCIBar2Type");
    MWCombo barTypeCombo3 = new MWCombo("uiPCIBar3Type");
    MWCombo barTypeCombo4 = new MWCombo("uiPCIBar4Type");
    MWCombo barTypeCombo5 = new MWCombo("uiPCIBar5Type");
    MWCombo barSizeCombo0 = new MWComboMappableDisplay("p_pcie_bar_size_bar_0", PCIuiConstants.mapBarSizeDisplayString);
    MWCombo barSizeCombo1 = new MWComboMappableDisplay("p_pcie_bar_size_bar_1", PCIuiConstants.mapBarSizeDisplayString);
    MWCombo barSizeCombo2 = new MWComboMappableDisplay("p_pcie_bar_size_bar_2", PCIuiConstants.mapBarSizeDisplayString);
    MWCombo barSizeCombo3 = new MWComboMappableDisplay("p_pcie_bar_size_bar_3", PCIuiConstants.mapBarSizeDisplayString);
    MWCombo barSizeCombo4 = new MWComboMappableDisplay("p_pcie_bar_size_bar_4", PCIuiConstants.mapBarSizeDisplayString);
    MWCombo barSizeCombo5 = new MWComboMappableDisplay("p_pcie_bar_size_bar_5", PCIuiConstants.mapBarSizeDisplayString);
    MWCombo hardwiredCombo0 = new MWComboMappableDisplay("p_pci_bar_0_hardwired", PCIuiConstants.mapBarHardwiredDisplayString);
    MWCombo hardwiredCombo1 = new MWComboMappableDisplay("p_pci_bar_1_hardwired", PCIuiConstants.mapBarHardwiredDisplayString);
    MWCombo hardwiredCombo2 = new MWComboMappableDisplay("p_pci_bar_2_hardwired", PCIuiConstants.mapBarHardwiredDisplayString);
    MWCombo hardwiredCombo3 = new MWComboMappableDisplay("p_pci_bar_3_hardwired", PCIuiConstants.mapBarHardwiredDisplayString);
    MWCombo hardwiredCombo4 = new MWComboMappableDisplay("p_pci_bar_4_hardwired", PCIuiConstants.mapBarHardwiredDisplayString);
    MWCombo hardwiredCombo5 = new MWComboMappableDisplay("p_pci_bar_5_hardwired", PCIuiConstants.mapBarHardwiredDisplayString);
    MWHexFormattedTextField avalonBaseAddress0 = new MWHexFormattedTextField("p_pci_bar_0_avalon_address", 8);
    MWHexFormattedTextField avalonBaseAddress1 = new MWHexFormattedTextField("p_pci_bar_1_avalon_address", 8);
    MWHexFormattedTextField avalonBaseAddress2 = new MWHexFormattedTextField("p_pci_bar_2_avalon_address", 8);
    MWHexFormattedTextField avalonBaseAddress3 = new MWHexFormattedTextField("p_pci_bar_3_avalon_address", 8);
    MWHexFormattedTextField avalonBaseAddress4 = new MWHexFormattedTextField("p_pci_bar_4_avalon_address", 8);
    MWHexFormattedTextField avalonBaseAddress5 = new MWHexFormattedTextField("p_pci_bar_5_avalon_address", 8);
    MWHexFormattedTextField PCIAddress0 = new MWHexFormattedTextField("uiBar0PCIAddress", 8);
    MWHexFormattedTextField PCIAddress1 = new MWHexFormattedTextField("uiBar1PCIAddress", 8);
    MWHexFormattedTextField PCIAddress2 = new MWHexFormattedTextField("uiBar2PCIAddress", 8);
    MWHexFormattedTextField PCIAddress3 = new MWHexFormattedTextField("uiBar3PCIAddress", 8);
    MWHexFormattedTextField PCIAddress4 = new MWHexFormattedTextField("uiBar4PCIAddress", 8);
    MWHexFormattedTextField PCIAddress5 = new MWHexFormattedTextField("uiBar5PCIAddress", 8);
    DefaultCellEditor cellEditorR0C0 = null;
    DefaultCellEditor cellEditorR1C0 = null;
    DefaultCellEditor cellEditorR2C0 = null;
    DefaultCellEditor cellEditorR3C0 = null;
    DefaultCellEditor cellEditorR4C0 = null;
    DefaultCellEditor cellEditorR5C0 = null;
    DefaultCellEditor cellEditorR0C1 = new DefaultCellEditor((JComboBox<?>)this.barTypeCombo0);
    DefaultCellEditor cellEditorR1C1 = new DefaultCellEditor((JComboBox<?>)this.barTypeCombo1);
    DefaultCellEditor cellEditorR2C1 = new DefaultCellEditor((JComboBox<?>)this.barTypeCombo2);
    DefaultCellEditor cellEditorR3C1 = new DefaultCellEditor((JComboBox<?>)this.barTypeCombo3);
    DefaultCellEditor cellEditorR4C1 = new DefaultCellEditor((JComboBox<?>)this.barTypeCombo4);
    DefaultCellEditor cellEditorR5C1 = new DefaultCellEditor((JComboBox<?>)this.barTypeCombo5);
    DefaultCellEditor cellEditorR0C2 = new DefaultCellEditor((JComboBox<?>)this.barSizeCombo0);
    DefaultCellEditor cellEditorR1C2 = new DefaultCellEditor((JComboBox<?>)this.barSizeCombo1);
    DefaultCellEditor cellEditorR2C2 = new DefaultCellEditor((JComboBox<?>)this.barSizeCombo2);
    DefaultCellEditor cellEditorR3C2 = new DefaultCellEditor((JComboBox<?>)this.barSizeCombo3);
    DefaultCellEditor cellEditorR4C2 = new DefaultCellEditor((JComboBox<?>)this.barSizeCombo4);
    DefaultCellEditor cellEditorR5C2 = new DefaultCellEditor((JComboBox<?>)this.barSizeCombo5);
    DefaultCellEditor cellEditorR0C3 = new DefaultCellEditor(this.avalonBaseAddress0);
    DefaultCellEditor cellEditorR1C3 = new DefaultCellEditor(this.avalonBaseAddress1);
    DefaultCellEditor cellEditorR2C3 = new DefaultCellEditor(this.avalonBaseAddress2);
    DefaultCellEditor cellEditorR3C3 = new DefaultCellEditor(this.avalonBaseAddress3);
    DefaultCellEditor cellEditorR4C3 = new DefaultCellEditor(this.avalonBaseAddress4);
    DefaultCellEditor cellEditorR5C3 = new DefaultCellEditor(this.avalonBaseAddress5);
    MWCombo ExpROMTypeCombo = new MWCombo("uiExpROMType");
    MWCombo ExpROMSizeCombo = new MWComboMappableDisplay("p_pcie_exp_rom_bar_size", PCIuiConstants.mapExpROMSizeDisplayString);
    DefaultCellEditor cellEditorR6C1 = new DefaultCellEditor((JComboBox<?>)this.ExpROMTypeCombo);
    DefaultCellEditor cellEditorR6C2 = new DefaultCellEditor((JComboBox<?>)this.ExpROMSizeCombo);
    private MWControl[][] dynamicControls = new MWControl[][]{{null, this.barTypeCombo0, this.barSizeCombo0, this.avalonBaseAddress0, this.hardwiredCombo0, this.PCIAddress0}, {null, this.barTypeCombo1, this.barSizeCombo1, this.avalonBaseAddress1, this.hardwiredCombo1, this.PCIAddress1}, {null, this.barTypeCombo2, this.barSizeCombo2, this.avalonBaseAddress2, this.hardwiredCombo2, this.PCIAddress2}, {null, this.barTypeCombo3, this.barSizeCombo3, this.avalonBaseAddress3, this.hardwiredCombo3, this.PCIAddress3}, {null, this.barTypeCombo4, this.barSizeCombo4, this.avalonBaseAddress4, this.hardwiredCombo4, this.PCIAddress4}, {null, this.barTypeCombo5, this.barSizeCombo5, this.avalonBaseAddress5, this.hardwiredCombo5, this.PCIAddress5}, {null, this.ExpROMTypeCombo, this.ExpROMSizeCombo, null, null, null}};
    private TableCellEditor[][] cellEditors = new TableCellEditor[][]{{this.cellEditorR0C0, this.cellEditorR0C1, this.cellEditorR0C2, this.cellEditorR0C3}, {this.cellEditorR1C0, this.cellEditorR1C1, this.cellEditorR1C2, this.cellEditorR1C3}, {this.cellEditorR2C0, this.cellEditorR2C1, this.cellEditorR2C2, this.cellEditorR2C3}, {this.cellEditorR3C0, this.cellEditorR3C1, this.cellEditorR3C2, this.cellEditorR3C3}, {this.cellEditorR4C0, this.cellEditorR4C1, this.cellEditorR4C2, this.cellEditorR4C3}, {this.cellEditorR5C0, this.cellEditorR5C1, this.cellEditorR5C2, this.cellEditorR5C3}, {null, this.cellEditorR6C1, this.cellEditorR6C2, null}};
    private boolean[][] rowEditable = new boolean[][]{{true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}};
    private String[] columnNamesStandalone = new String[]{"BAR", "BAR Type", "BAR Size"};
    Object[][] cachedStaticStandalone = new Object[][]{{"0", "32-bit Prefetchable Memory", "Auto"}, {"1", "Select Type to Enable", ""}, {"2", "", ""}, {"3", "", ""}, {"4", "", ""}, {"5", "", ""}, {"EXP-ROM", "Select to Enable", ""}};
    private String[] columnNames = new String[]{"BAR", "BAR Type", "BAR Size", "Avalon Base Address"};
    Object[][] cachedStatic = new Object[][]{{"0", "32-bit Prefetchable Memory", "Auto", "Auto"}, {"1", "Select Type to Enable", "", ""}, {"2", "", "", ""}, {"3", "", "", ""}, {"4", "", "", ""}, {"5", "", "", ""}, {"EXP-ROM", "Select to Enable", "", "N/A"}};
    boolean bar064bit = false;
    boolean bar264bit = false;
    boolean bar464bit = false;

    public PCIEBARsTableModel() {
        this.setDataVector(this.cachedStatic, this.columnNames);
    }

    @Override
    public void SetStandaloneMode(boolean flag) {
        if (flag) {
            this.setDataVector(this.cachedStaticStandalone, this.columnNamesStandalone);
        } else {
            this.setDataVector(this.cachedStatic, this.columnNames);
        }
    }

    @Override
    public MWControl[][] getTableDynamicControls() {
        return this.dynamicControls;
    }

    @Override
    public TableCellEditor getTableCellEditor(int row, int col) {
        TableCellEditor cellEditor = null;
        if (row == 6) {
            switch (col) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    cellEditor = this.cellEditors[row][col];
                }
            }
            return cellEditor;
        }
        int actualRow = this.getActualRow(row);
        if (actualRow > MAX_BARTABLE_ROW_INDEX) {
            return null;
        }
        if (this.rowEditable[actualRow][col]) {
            switch (col) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    cellEditor = this.cellEditors[actualRow][col];
                    break;
                }
                case 5: {
                    cellEditor = this.getBarPCIAddressControl(actualRow);
                }
            }
        }
        return cellEditor;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.cachedStatic[row][col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (row == 6 && col < 3) {
            return this.rowEditable[row][col];
        }
        int actualRow = this.getActualRow(row);
        if (actualRow > MAX_BARTABLE_ROW_INDEX) {
            return false;
        }
        return this.rowEditable[actualRow][col];
    }

    @Override
    public void setMWEventHandler(MWEventHandler mwEventHandler) {
        this.mwEventHandler = mwEventHandler;
    }

    private MWEventHandler getMWEventHandler() {
        return this.mwEventHandler;
    }

    private int getActualRow(int tableRow) {
        switch (tableRow) {
            case 0: {
                return tableRow;
            }
            case 1: {
                if (this.bar064bit) {
                    return tableRow + 1;
                }
                return tableRow;
            }
            case 2: {
                if (!this.bar064bit && !this.bar264bit) {
                    return tableRow;
                }
                if (!this.bar064bit && this.bar264bit) {
                    return tableRow;
                }
                if (this.bar064bit && !this.bar264bit) {
                    return tableRow + 1;
                }
                if (this.bar064bit && this.bar264bit) {
                    return tableRow + 2;
                }
            }
            case 3: {
                if (!(this.bar064bit || this.bar264bit || this.bar464bit)) {
                    return tableRow;
                }
                if (!this.bar064bit && !this.bar264bit && this.bar464bit) {
                    return tableRow;
                }
                if (!this.bar064bit && this.bar264bit && !this.bar464bit) {
                    return tableRow + 1;
                }
                if (!this.bar064bit && this.bar264bit && this.bar464bit) {
                    return tableRow + 1;
                }
                if (this.bar064bit && !this.bar264bit && !this.bar464bit) {
                    return tableRow + 1;
                }
                if (this.bar064bit && !this.bar264bit && this.bar464bit) {
                    return tableRow + 1;
                }
                if (this.bar064bit && this.bar264bit && !this.bar464bit) {
                    return tableRow + 2;
                }
                if (this.bar064bit && this.bar264bit && this.bar464bit) {
                    return tableRow + 3;
                }
            }
            case 4: {
                if (!(this.bar064bit || this.bar264bit || this.bar464bit)) {
                    return tableRow;
                }
                if (!this.bar064bit && !this.bar264bit && this.bar464bit) {
                    return tableRow;
                }
                if (!this.bar064bit && this.bar264bit && !this.bar464bit) {
                    return tableRow + 1;
                }
                if (!this.bar064bit && this.bar264bit && this.bar464bit) {
                    return tableRow + 2;
                }
                if (this.bar064bit && !this.bar264bit && !this.bar464bit) {
                    return tableRow + 1;
                }
                if (this.bar064bit && !this.bar264bit && this.bar464bit) {
                    return tableRow + 2;
                }
                if (this.bar064bit && this.bar264bit && !this.bar464bit) {
                    return tableRow + 2;
                }
                if (this.bar064bit && this.bar264bit && this.bar464bit) {
                    return tableRow + 3;
                }
            }
            case 5: {
                if (!(this.bar064bit || this.bar264bit || this.bar464bit)) {
                    return tableRow;
                }
                if (!this.bar064bit && !this.bar264bit && this.bar464bit) {
                    return tableRow + 1;
                }
                if (!this.bar064bit && this.bar264bit && !this.bar464bit) {
                    return tableRow + 1;
                }
                if (!this.bar064bit && this.bar264bit && this.bar464bit) {
                    return tableRow + 2;
                }
                if (this.bar064bit && !this.bar264bit && !this.bar464bit) {
                    return tableRow + 1;
                }
                if (this.bar064bit && !this.bar264bit && this.bar464bit) {
                    return tableRow + 2;
                }
                if (this.bar064bit && this.bar264bit && !this.bar464bit) {
                    return tableRow + 2;
                }
                if (!this.bar064bit || !this.bar264bit || !this.bar464bit) break;
                return tableRow + 3;
            }
        }
        return tableRow;
    }

    private Object getBarRowHeaderStaticText(int row) {
        String strValue = "";
        boolean bRootPort = ((String)this.getMWEventHandler().getValue("p_pcie_port_type", String.class)).equals("Root Port");
        if (bRootPort) {
            switch (row) {
                case 0: {
                    if (this.bar064bit) {
                        strValue = "1:0";
                        break;
                    }
                    strValue = "0";
                    break;
                }
                case 1: {
                    strValue = String.valueOf(row);
                    break;
                }
                default: {
                    strValue = "N/A";
                    break;
                }
            }
        } else {
            switch (row) {
                case 0: {
                    if (this.bar064bit) {
                        strValue = "1:0";
                        break;
                    }
                    strValue = "0";
                    break;
                }
                case 1: {
                    strValue = String.valueOf(row);
                    break;
                }
                case 2: {
                    if (this.bar264bit) {
                        strValue = "3:2";
                        break;
                    }
                    strValue = "2";
                    break;
                }
                case 3: {
                    strValue = String.valueOf(row);
                    break;
                }
                case 4: {
                    if (this.bar464bit) {
                        strValue = "5:4";
                        break;
                    }
                    strValue = "4";
                    break;
                }
                case 5: {
                    strValue = String.valueOf(row);
                    break;
                }
                default: {
                    strValue = "N/A";
                }
            }
        }
        return strValue;
    }

    private Object getBarTypeStaticText(int row, IParameterDescriptor pd) {
        MWControl dynamicControl = this.dynamicControls[row][1];
        String strValue = "";
        if (dynamicControl instanceof MWCombo) {
            MWCombo combo = (MWCombo)dynamicControl;
            strValue = this.getMWEventHandler().getValue(combo.getParameterName(), pd.getType()).toString();
        }
        if ("Disable this and all higher BARs".equals(strValue)) {
            switch (row) {
                case 0: {
                    this.rowEditable[row][1] = false;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    boolean bRootPort = ((String)this.getMWEventHandler().getValue("p_pcie_port_type", String.class)).equals("Root Port");
                    String previousBar = "p_pcie_bar_used_bar_" + (row - 1);
                    boolean isP_pci_bar_n_used = (Boolean)this.getMWEventHandler().getValue(previousBar, Boolean.TYPE);
                    if (!bRootPort) {
                        if (isP_pci_bar_n_used) {
                            strValue = "Select Type to Enable";
                            this.rowEditable[row][1] = true;
                            break;
                        }
                        strValue = "";
                        this.rowEditable[row][1] = false;
                        break;
                    }
                    if (isP_pci_bar_n_used && row < 2) {
                        strValue = "Select Type to Enable";
                        this.rowEditable[row][1] = true;
                        break;
                    }
                    strValue = "";
                    this.rowEditable[row][1] = false;
                    break;
                }
                default: {
                    strValue = "";
                    break;
                }
            }
        } else {
            this.rowEditable[row][1] = true;
            if (row < 5) {
                this.rowEditable[row + 1][1] = true;
            }
        }
        return strValue;
    }

    private Object getBarSizeStaticText(int row, IParameterDescriptor pd) {
        MWControl dynamicControl = this.dynamicControls[row][2];
        String strValue = "";
        if (pd.isEnabled()) {
            if (dynamicControl instanceof MWComboMappableDisplay) {
                MWComboMappableDisplay combo = (MWComboMappableDisplay)dynamicControl;
                strValue = PCIuiConstants.mapBarSizeDisplayString.get(this.getMWEventHandler().getValue(combo.getParameterName(), Integer.TYPE));
                if (strValue == null) {
                    strValue = PCIuiConstants.mapBarSizeDisplayString.get(this.getMWEventHandler().getValue(combo.getParameterName(), String.class));
                }
            }
            this.rowEditable[row][2] = true;
        } else {
            this.rowEditable[row][2] = false;
        }
        return strValue;
    }

    private Object getBarSizeAvalonAddressStaticText(int row, IParameterDescriptor pd) {
        MWControl dynamicControl = this.dynamicControls[row][3];
        String strValue = "";
        this.rowEditable[row][3] = false;
        if (pd.isVisible()) {
            String strAutoAvalon = "";
            MWControl autoAvalonControl = this.dynamicControls[row][2];
            if (autoAvalonControl instanceof MWComboMappableDisplay) {
                MWComboMappableDisplay combo = (MWComboMappableDisplay)autoAvalonControl;
                strAutoAvalon = PCIuiConstants.mapBarSizeDisplayString.get(this.getMWEventHandler().getValue(combo.getParameterName(), Integer.TYPE));
            }
            if (PCIuiConstants.mapBarSizeDisplayString.get("Auto").equalsIgnoreCase(strAutoAvalon)) {
                strValue = strAutoAvalon;
            } else {
                if (dynamicControl instanceof MWFormattedTextField) {
                    MWFormattedTextField numField = (MWFormattedTextField)dynamicControl;
                    strValue = numField.getText();
                }
                this.rowEditable[row][3] = pd.isEnabled();
            }
        }
        return strValue;
    }

    private Object getBarHardWiredStaticText(int row, IParameterDescriptor pd) {
        MWControl dynamicControl = this.dynamicControls[row][4];
        String strValue = "";
        this.rowEditable[row][4] = false;
        if (pd.isVisible()) {
            if (dynamicControl instanceof MWComboMappableDisplay) {
                MWComboMappableDisplay combo = (MWComboMappableDisplay)dynamicControl;
                strValue = PCIuiConstants.mapBarHardwiredDisplayString.get(this.getMWEventHandler().getValue(combo.getParameterName(), Boolean.TYPE));
            }
            this.rowEditable[row][4] = pd.isEnabled();
        }
        return strValue;
    }

    private TableCellEditor getBarPCIAddressControl(int row) {
        MWControl control = this.dynamicControls[row][5];
        switch (row) {
            case 0: {
                if (!(control instanceof MWHexFormattedTextField)) break;
                MWHexFormattedTextField formatField = (MWHexFormattedTextField)control;
                formatField.setHexWidth(8);
                break;
            }
        }
        return this.cellEditors[row][5];
    }

    private Object getBarPCIAddressStaticText(int row, IParameterDescriptor pd) {
        MWControl control = this.dynamicControls[row][5];
        String strValue = "";
        this.rowEditable[row][5] = false;
        if (pd.isVisible()) {
            switch (row) {
                case 0: {
                    if (!(control instanceof MWHexFormattedTextField)) break;
                    MWHexFormattedTextField formatField = (MWHexFormattedTextField)control;
                    formatField.setHexWidth(8);
                    strValue = formatField.getText();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (!(control instanceof MWHexFormattedTextField)) break;
                    MWHexFormattedTextField numField = (MWHexFormattedTextField)control;
                    strValue = numField.getText();
                    break;
                }
            }
            this.rowEditable[row][5] = pd.isEnabled();
        }
        return strValue;
    }

    private void update64bitState() {
        if (this.getMWEventHandler() != null) {
            this.bar064bit = ((String)this.getMWEventHandler().getValue("uiPCIBar0Type", String.class)).equals("64-bit Prefetchable Memory");
            this.bar264bit = ((String)this.getMWEventHandler().getValue("uiPCIBar2Type", String.class)).equals("64-bit Prefetchable Memory");
            this.bar464bit = ((String)this.getMWEventHandler().getValue("uiPCIBar4Type", String.class)).equals("64-bit Prefetchable Memory");
        }
    }

    @Override
    public void receiveChangeEvent() {
        int col;
        int row;
        this.update64bitState();
        for (row = 0; row <= 6; ++row) {
            for (col = 0; col < 4; ++col) {
                if (this.dynamicControls[row][col] == null) continue;
                this.dynamicControls[row][col].receiveChangeEvent();
            }
        }
        for (row = 0; row <= 6; ++row) {
            for (col = 0; col < 4; ++col) {
                this.cachedStatic[row][col] = this.getComponentValueAt(row, col);
            }
        }
    }

    private Object getExpROMTypeStaticText(IParameterDescriptor pd) {
        String strValue = "";
        String ExpRomBarUsed = "p_pcie_exp_rom_bar_used";
        boolean isP_pci_bar_n_used = (Boolean)this.getMWEventHandler().getValue(ExpRomBarUsed, Boolean.TYPE);
        if (isP_pci_bar_n_used) {
            strValue = "Enabled";
            this.rowEditable[6][1] = true;
        } else {
            strValue = "Select to Enable";
            this.rowEditable[6][1] = true;
        }
        return strValue;
    }

    private Object getExpROMSizeStaticText(IParameterDescriptor pd) {
        MWControl dynamicControl = this.dynamicControls[6][2];
        String strValue = "";
        if (pd.isEnabled()) {
            if (dynamicControl instanceof MWComboMappableDisplay) {
                MWComboMappableDisplay combo = (MWComboMappableDisplay)dynamicControl;
                Object obj = this.getMWEventHandler().getValue(combo.getParameterName(), String.class);
                strValue = PCIuiConstants.mapExpROMSizeDisplayString.get(obj);
            }
            this.rowEditable[6][2] = true;
        } else {
            this.rowEditable[6][2] = false;
        }
        return strValue;
    }

    public Object getComponentValueAt(int row, int col) {
        Object objValue = null;
        if (row == 6) {
            IParameterDescriptor pd = null;
            MWControl control = this.dynamicControls[row][col];
            if (control != null) {
                pd = this.getMWEventHandler().getParameterDescriptor(control.getParameterName());
            }
            switch (col) {
                case 0: {
                    objValue = this.cachedStatic[row][col];
                    break;
                }
                case 1: {
                    objValue = this.getExpROMTypeStaticText(pd);
                    break;
                }
                case 2: {
                    objValue = this.getExpROMSizeStaticText(pd);
                    break;
                }
                default: {
                    objValue = this.cachedStatic[row][col];
                    break;
                }
            }
        } else {
            MWControl control;
            int actualRow = this.getActualRow(row);
            IParameterDescriptor pd = null;
            if (actualRow <= MAX_BARTABLE_ROW_INDEX && (control = this.dynamicControls[actualRow][col]) != null) {
                pd = this.getMWEventHandler().getParameterDescriptor(control.getParameterName());
            }
            switch (col) {
                case 0: {
                    objValue = this.getBarRowHeaderStaticText(actualRow);
                    break;
                }
                case 1: {
                    if (actualRow > MAX_BARTABLE_ROW_INDEX) {
                        return null;
                    }
                    objValue = this.getBarTypeStaticText(actualRow, pd);
                    break;
                }
                case 2: {
                    if (actualRow > MAX_BARTABLE_ROW_INDEX) {
                        return null;
                    }
                    objValue = this.getBarSizeStaticText(actualRow, pd);
                    break;
                }
                case 3: {
                    if (actualRow > MAX_BARTABLE_ROW_INDEX) {
                        return null;
                    }
                    objValue = this.getBarSizeAvalonAddressStaticText(actualRow, pd);
                    break;
                }
                case 4: {
                    if (actualRow > MAX_BARTABLE_ROW_INDEX) {
                        return null;
                    }
                    objValue = this.getBarHardWiredStaticText(actualRow, pd);
                    break;
                }
                case 5: {
                    if (actualRow > MAX_BARTABLE_ROW_INDEX) {
                        return null;
                    }
                    objValue = this.getBarPCIAddressStaticText(actualRow, pd);
                    break;
                }
            }
        }
        return objValue;
    }
}

