/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.model;

import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.IPCIETableModel;
import com.altera.megacore.pcie.ui.MWHexFormattedTextField;
import com.altera.megawizard2.MWControl;
import com.altera.megawizard2.handler.MWEventHandler;
import com.altera.megawizard2.view.MWCombo;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class AddressTranslationTableModel
extends DefaultTableModel
implements IPCIETableModel {
    private static final int MAX_AVALON_ADDRESSES_ROW_INDEX = 15;
    private MWEventHandler mwEventHandler = null;
    private String[] columnNames = new String[]{"Avalon Address Offset", "PCIe Base Address", "Type"};
    MWHexFormattedTextField PCIBaseAddress0 = new MWHexFormattedTextField("uiAvalonHWPCIAddress0", 8);
    MWCombo comboType0 = new MWCombo("p_avalon_hw_pci_address_00_type");
    DefaultCellEditor cellEditorR0C0 = null;
    DefaultCellEditor cellEditorR0C1 = new DefaultCellEditor(this.PCIBaseAddress0);
    DefaultCellEditor cellEditorR0C2 = new DefaultCellEditor((JComboBox<?>)this.comboType0);
    private MWControl[][] dynamicControls = new MWControl[][]{{null, this.PCIBaseAddress0, this.comboType0}};
    Object[][] data = new Object[][]{{"0x00000000", "0x00000000", IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit}};

    public AddressTranslationTableModel() {
        this.setDataVector(this.data, this.columnNames);
    }

    @Override
    public MWControl[][] getTableDynamicControls() {
        return this.dynamicControls;
    }

    @Override
    public TableCellEditor getTableCellEditor(int row, int col) {
        TableCellEditor cellEditor = null;
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                cellEditor = this.getPCIAddressControl(row);
                break;
            }
            case 2: {
                cellEditor = this.getPCIAddressTypeControl(row);
                break;
            }
        }
        return cellEditor;
    }

    private TableCellEditor getPCIAddressControl(int row) {
        String parameterName = this.getNameAvalon_hw_address(row);
        this.PCIBaseAddress0.setParameterName(parameterName);
        int hexWidth = 8;
        IPCIECompilerCoreParameters.EAvalonAddressType addressType = this.getAvalon_hw_pci_address_type(row);
        if (IPCIECompilerCoreParameters.EAvalonAddressType.Memory64Bit.equals((Object)addressType)) {
            hexWidth = 16;
        }
        this.PCIBaseAddress0.setHexWidth(hexWidth);
        this.PCIBaseAddress0.receiveChangeEvent();
        return this.cellEditorR0C1;
    }

    private TableCellEditor getPCIAddressTypeControl(int row) {
        IPCIECompilerCoreParameters.EAvalonAddressType selectedItem = null;
        String parameterName = this.getNameAvalon_hw_pci_address_type(row);
        this.comboType0.setParameterName(parameterName);
        selectedItem = (IPCIECompilerCoreParameters.EAvalonAddressType)((Object)this.getMWEventHandler().getValue(parameterName, IPCIECompilerCoreParameters.EAvalonAddressType.class));
        this.comboType0.removeAllItems();
        this.comboType0.addItem((Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory64Bit);
        this.comboType0.addItem((Object)IPCIECompilerCoreParameters.EAvalonAddressType.Memory32Bit);
        this.comboType0.setSelectedItem((Object)selectedItem);
        this.comboType0.receiveChangeEvent();
        return this.cellEditorR0C2;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setMWEventHandler(MWEventHandler mwEventHandler) {
        this.mwEventHandler = mwEventHandler;
    }

    MWEventHandler getMWEventHandler() {
        return this.mwEventHandler;
    }

    @Override
    public void receiveChangeEvent() {
        this.populateTable();
    }

    private String getNameUiAvalonHWAddress(int row) {
        return "uiAvalonHWAddress" + row;
    }

    private String getUiAvalonHWAddress(int row) {
        String name_avalon_hw_address = this.getNameUiAvalonHWAddress(row);
        String avalon_hw_address = (String)this.getMWEventHandler().getValue(name_avalon_hw_address, String.class);
        return avalon_hw_address;
    }

    private String getNameAvalon_hw_address(int row) {
        return "uiAvalonHWPCIAddress" + row;
    }

    private String getAvalon_hw_address(int row) {
        String name_avalon_hw_pci_address = this.getNameAvalon_hw_address(row);
        String avalon_hw_pci_address = (String)this.getMWEventHandler().getValue(name_avalon_hw_pci_address, String.class);
        return avalon_hw_pci_address;
    }

    private String getNameAvalon_hw_pci_address_type(int row) {
        String name_avalon_hw_pci_address_type = row < 10 ? "p_avalon_hw_pci_address_0" + row + "_type" : "p_avalon_hw_pci_address_" + row + "_type";
        return name_avalon_hw_pci_address_type;
    }

    private IPCIECompilerCoreParameters.EAvalonAddressType getAvalon_hw_pci_address_type(int row) {
        String name_avalon_hw_pci_address_type = this.getNameAvalon_hw_pci_address_type(row);
        IPCIECompilerCoreParameters.EAvalonAddressType avalon_hw_pci_address_type = null;
        try {
            avalon_hw_pci_address_type = IPCIECompilerCoreParameters.EAvalonAddressType.valueOf((String)this.getMWEventHandler().getValue(name_avalon_hw_pci_address_type, String.class));
        }
        catch (Exception e) {
            avalon_hw_pci_address_type = (IPCIECompilerCoreParameters.EAvalonAddressType)((Object)this.getMWEventHandler().getValue(name_avalon_hw_pci_address_type, IPCIECompilerCoreParameters.EAvalonAddressType.class));
        }
        return avalon_hw_pci_address_type;
    }

    private void populateTable() {
        int paneCount = (Integer)this.getMWEventHandler().getValue("p_avalon_pane_count", Integer.TYPE);
        this.removeRows();
        for (int rowIndex = 0; rowIndex < paneCount; ++rowIndex) {
            String avalon_hw_addrss = this.getUiAvalonHWAddress(rowIndex);
            String avalon_hw_pci_address = this.getAvalon_hw_address(rowIndex);
            IPCIECompilerCoreParameters.EAvalonAddressType avalon_hw_pci_address_type = this.getAvalon_hw_pci_address_type(rowIndex);
            Vector<String> vRow = new Vector<String>();
            vRow.add(avalon_hw_addrss);
            vRow.add(avalon_hw_pci_address);
            vRow.add(avalon_hw_pci_address_type.toString());
            this.addRow(vRow);
        }
    }

    private void removeRows() {
        int numrows = this.getRowCount();
        for (int i = numrows - 1; i >= 0; --i) {
            this.removeRow(i);
        }
    }

    @Override
    public void SetStandaloneMode(boolean flag) {
    }
}

