/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.launcher;

import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IModuleGenerateHDL;
import com.altera.entityinterfaces.moduleext.megawizard.EMegaWizardState;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizard;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizardEvent;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizardEventHandler;
import com.altera.megacore.pcie.AlteraPCIECompilerClass;
import com.altera.megawizard2.theme.JRMWThemeManager;
import com.altera.sopcmodel.util.IModuleGenerateFromIPTB;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class PCIELauncher
implements IMessageLogger,
IMegaWizardEventHandler {
    private static IModule m_module;

    public static void main(String[] args) {
        boolean has_mwii_look_and_feel = true;
        boolean has_mwii_navigation_panel = true;
        int fontSize = 11;
        UIDefaults defaults = UIManager.getDefaults();
        String fontName = PCIELauncher.getDefaultSansSerifFontName();
        String plainFontDescription = fontName + "-PLAIN-" + fontSize;
        Font plainFont = Font.decode(plainFontDescription);
        defaults.put("Table.font", plainFont);
        defaults.put("TableHeader.font", plainFont);
        defaults.put("Label.font", plainFont);
        defaults.put("List.font", plainFont);
        defaults.put("Menu.font", plainFont);
        defaults.put("MenuItem.font", plainFont);
        defaults.put("Button.font", plainFont);
        defaults.put("RadioButton.font", plainFont);
        defaults.put("TextArea.font", plainFont);
        defaults.put("TextField.font", plainFont);
        defaults.put("CheckBox.font", plainFont);
        defaults.put("CheckBoxMenuItem.font", plainFont);
        defaults.put("ComboBox.font", plainFont);
        defaults.put("TabbedPane.font", plainFont);
        defaults.put("TitledBorder.font", plainFont);
        JRMWThemeManager.initializeLookAndFeel((boolean)has_mwii_look_and_feel, (boolean)has_mwii_navigation_panel);
        m_module = new AlteraPCIECompilerClass().newInstance();
        IModuleGenerateFromIPTB generator = (IModuleGenerateFromIPTB)m_module.getExtension(IModuleGenerateFromIPTB.class);
        generator.setGenerationLanguage(IModuleGenerateHDL.HDLLanguage.VERILOG);
        generator.setDestinationPaths(new File("c://temp"), new File("c://temp"));
        JFrame myframe = new JFrame("MegaWizard Plug-In Manager");
        IMegaWizard megaWizard = (IMegaWizard)m_module.getExtension(IMegaWizard.class);
        megaWizard.setToolContext(IMegaWizard.EToolContext.STANDALONE);
        PCIELauncher me = new PCIELauncher();
        if (megaWizard != null) {
            Image dummy_icon = Toolkit.getDefaultToolkit().getImage("dummy_path");
            myframe.setIconImage(dummy_icon);
            myframe.setDefaultCloseOperation(3);
            myframe.setContentPane(megaWizard.getMegaWizardRoot((IMessageLogger)me, (IMegaWizardEventHandler)me));
        }
        JPanel[] jpl = megaWizard.getMegaWizardSubPanels((IMessageLogger)me, (IMegaWizardEventHandler)me);
        myframe.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((d.getWidth() - (double)myframe.getWidth()) / 2.0);
        int y = (int)((d.getHeight() - (double)myframe.getHeight()) / 2.0);
        myframe.setLocation(x, y);
        myframe.setVisible(true);
    }

    public static String getDefaultSansSerifFontName() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String[] romanLanguages = new String[]{"en", "fr", "it", "de", "sp"};
        boolean useGenericSansSerifFont = false;
        if (!Arrays.asList(romanLanguages).contains(language)) {
            useGenericSansSerifFont = true;
        }
        String fontName = "Arial";
        if (useGenericSansSerifFont) {
            fontName = "SansSerif";
        }
        return fontName;
    }

    public void receiveCurrentState(EMegaWizardState state) {
    }

    public void receiveMessage(IMessage message) {
        System.out.println("message received from GUI " + message);
    }

    public void processEvent(IMegaWizardEvent event) {
        System.out.println("event received from GUI " + event);
        if (event.getState().toString().equalsIgnoreCase(EMegaWizardState.Finished.toString())) {
            System.exit(0);
        } else if (event.getState().toString().equalsIgnoreCase(EMegaWizardState.Canceled.toString())) {
            System.exit(0);
        }
    }
}

