/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.html;

import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.elementclassext.IElementClassCoreInfo;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizard;
import com.altera.megawizard2.MWGUIBaseClass;
import com.altera.megawizard2.html.MWHtmlDocument;
import com.altera.megawizard2.html.MWHtmlEditorKit;
import com.altera.megawizard2.html.MWHtmlViewer;
import com.altera.megawizard2.html.MegaCoreVersionInfo;
import java.awt.Cursor;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLEditorKit;

public class AlteraPCIEMWHtmlViewer
extends MWHtmlViewer
implements HyperlinkListener {
    protected URL m_url = null;
    protected Cursor m_handCursor = new Cursor(12);
    protected HTMLEditorKit m_htmlKit = null;
    protected static String DATASOURCE_KEY = "data_source";
    protected static String HEADER_IMAGE_KEY = "header_image";
    protected static String HEADER_IMAGE_SIZE_KEY = "header_image_size";
    protected static String HEADER_IMAGE_LINK_SECTION = "HEADER_IMAGE_LINK/HTML/IMAGE";
    protected static String CSS = "css";
    protected JFrame m_frame = new JFrame("");
    private MWGUIBaseClass guibaseClass;
    private static int[] version = null;
    ResourceBundle Informations = ResourceBundle.getBundle("com.altera.megacore.pcie.html.AlteraPCIEHIP");

    public JScrollPane initialize(String dataSource, IModule module, MWGUIBaseClass guibaseClass) throws Exception {
        this.guibaseClass = guibaseClass;
        if (this.m_url == null && dataSource != null) {
            URL url = AlteraPCIEMWHtmlViewer.class.getClassLoader().getResource("com/altera/megacore/pcie/html/about_this_core_hip.html");
            this.setURL(url);
        }
        JPanel mypanel = new JPanel();
        this.m_htmlPane = new JEditorPane();
        this.m_htmlKit = new MWHtmlEditorKit();
        this.m_htmlPane.setEditorKit(this.m_htmlKit);
        this.m_htmlPane.setEditable(false);
        this.m_htmlPane.setBackground(mypanel.getBackground());
        MWHtmlDocument doc = (MWHtmlDocument)this.m_htmlKit.createDefaultDocument();
        byte[] cssData = this.getData(AlteraPCIEMWHtmlViewer.class.getClassLoader().getResourceAsStream("com/altera/megacore/pcie/html/mw.css"));
        if (cssData != null) {
            doc.getStyleSheet().loadRules(new StringReader(new String(cssData)), null);
        }
        doc.setBase(this.getURL());
        this.m_htmlKit.read(this.getURL().openStream(), (Document)doc, 0);
        IElementClassCoreInfo coreInfo = null;
        if (module.getElementClass().hasExtension(IElementClassCoreInfo.class)) {
            coreInfo = (IElementClassCoreInfo)module.getElementClass().getExtension(IElementClassCoreInfo.class);
        }
        version = module.getElementClass().getVersion().getNumbers();
        MegaCoreVersionInfo megaCoreVersionInfo = null;
        try {
            if (coreInfo != null) {
                megaCoreVersionInfo = MegaCoreVersionInfo.createVersionInfo((ClassLoader)module.getClass().getClassLoader());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        String orderingCodeList = "";
        try {
            String textToReplace;
            Element el;
            int i;
            String devicefamiliesList = "";
            for (i = 0; i < doc.getDataList().size(); ++i) {
                el = doc.getElement("wiz" + Integer.toString(i));
                if (el == null) continue;
                textToReplace = (String)doc.getDataList().get(i);
                if (textToReplace != null && !textToReplace.equalsIgnoreCase("")) {
                    if (textToReplace.equalsIgnoreCase("MEGACORE/title")) {
                        doc.setOuterHTML(el, module.getElementClass().getDisplayName());
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/build")) {
                        if (megaCoreVersionInfo != null) {
                            doc.setOuterHTML(el, megaCoreVersionInfo.getShortString());
                            continue;
                        }
                        doc.setOuterHTML(el, module.getElementClass().getVersion().getShortString());
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/version")) {
                        if (megaCoreVersionInfo != null) {
                            doc.setOuterHTML(el, megaCoreVersionInfo.getLongString());
                            continue;
                        }
                        doc.setOuterHTML(el, module.getElementClass().getVersion().getLongString());
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/release_date")) {
                        if (megaCoreVersionInfo != null) {
                            doc.setOuterHTML(el, megaCoreVersionInfo.getReleaseDate());
                            continue;
                        }
                        if (module.getElementClass().getVersion().getDate() == null) continue;
                        Date releasedate = module.getElementClass().getVersion().getDate();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(releasedate);
                        String month = AlteraPCIEMWHtmlViewer.getMonth((int)cal.get(2));
                        String year = Integer.toString(cal.get(1));
                        doc.setOuterHTML(el, month + ", " + year);
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/ORDERING_CODES")) {
                        Collection orderingCodes = coreInfo.getOrderingCodes();
                        for (String orderingCode : orderingCodes) {
                            orderingCodeList = orderingCodeList + orderingCode + "<br>";
                        }
                        if (orderingCodeList.equalsIgnoreCase("")) continue;
                        doc.setOuterHTML(el, orderingCodeList.substring(0, orderingCodeList.length() - 4));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/product_id")) {
                        String productIdList = "";
                        Collection productIds = coreInfo.getProductIDs();
                        for (String productId : productIds) {
                            productIdList = productIdList + productId + "<br>";
                        }
                        if (productIdList.equalsIgnoreCase("")) continue;
                        doc.setOuterHTML(el, productIdList.substring(0, productIdList.length() - 4));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/hip_product_id")) {
                        doc.setOuterHTML(el, this.Informations.getString("hip_product_id"));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/vendor")) {
                        doc.setOuterHTML(el, "Altera Corporation");
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/vendor_id")) {
                        doc.setOuterHTML(el, coreInfo.getVendorID());
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/hip_vendor_id")) {
                        doc.setOuterHTML(el, this.Informations.getString("hip_vendor_id"));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/CERTIFICATIONS")) {
                        String certificationList = "";
                        Collection certifications = coreInfo.getCertifications();
                        for (IElementClassCoreInfo.ECertifications certification : certifications) {
                            certificationList = certificationList + this.getDisplyNameForCerttification(certification) + "<br>";
                        }
                        if (certificationList.equalsIgnoreCase("")) continue;
                        doc.setOuterHTML(el, certificationList.substring(0, certificationList.length() - 4));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/HIP_CERTIFICATIONS")) {
                        doc.setOuterHTML(el, this.Informations.getString("HIP_CERTIFICATIONS"));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/opencoreplus")) {
                        if (orderingCodeList.substring(0, orderingCodeList.length() - 4).equalsIgnoreCase("N/A")) {
                            doc.setOuterHTML(el, "N/A");
                            continue;
                        }
                        doc.setOuterHTML(el, coreInfo.isOpenCorePlusSupported() ? "Yes" : "No");
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/SIMULATION_MODELS")) {
                        if (!this.guibaseClass.getToolContext().equals((Object)IMegaWizard.EToolContext.STANDALONE)) continue;
                        doc.setOuterHTML(el, "Altera IP Functional Simulation Models<br>(VHDL/Verilog HDL)");
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/DEVICES")) {
                        Collection devicefamilies = coreInfo.getSupportedDeviceFamilies();
                        ArrayList<IDeviceFamily.EDeviceFamily> vDeviceFamilies = new ArrayList<IDeviceFamily.EDeviceFamily>();
                        for (IElementClassCoreInfo.DeviceSupportInfo devicefamilie : devicefamilies) {
                            for (IDeviceFamily visibledeviceFamily : this.guibaseClass.getAllowedDeviceFamilies()) {
                                if (!visibledeviceFamily.getDeviceFamily().toString().equalsIgnoreCase(devicefamilie.getDeviceFamily().getDeviceFamily().toString()) || devicefamilie.getDeviceFamily().getDeviceFamily().toString().equalsIgnoreCase(IDeviceFamily.EDeviceFamily.STRATIXV.toString())) continue;
                                devicefamiliesList = devicefamiliesList + devicefamilie.getDeviceFamily().getDisplayName() + "<br>";
                                vDeviceFamilies.add(devicefamilie.getDeviceFamily().getDeviceFamily());
                            }
                        }
                        Collections.sort(vDeviceFamilies);
                        if (devicefamiliesList.equalsIgnoreCase("")) continue;
                        doc.setOuterHTML(el, devicefamiliesList.substring(0, devicefamiliesList.length() - 4));
                        continue;
                    }
                    if (textToReplace.equalsIgnoreCase("MEGACORE/HIPDEVICES")) {
                        String[] theList;
                        String hipdevicefamiliesList = "";
                        for (String devicefamily : theList = this.Informations.getString("hip_supported_devicefamilies").split(",")) {
                            hipdevicefamiliesList = hipdevicefamiliesList + devicefamily + "<br>";
                        }
                        doc.setOuterHTML(el, hipdevicefamiliesList.substring(0, hipdevicefamiliesList.length() - 4));
                        continue;
                    }
                    if (!textToReplace.equalsIgnoreCase("yyyy")) continue;
                    GregorianCalendar gc1 = new GregorianCalendar();
                    doc.setOuterHTML(el, Integer.toString(gc1.get(1)));
                    continue;
                }
                Element myel = el;
                if (myel == null) continue;
                doc.remove(el.getParentElement().getStartOffset(), el.getParentElement().getEndOffset() - el.getParentElement().getStartOffset());
            }
            for (i = 0; i < doc.getDataList().size(); ++i) {
                el = doc.getElement("wiz" + Integer.toString(i));
                if (el == null) continue;
                textToReplace = (String)doc.getDataList().get(i) + i;
                Element elmemt = el.getParentElement().getParentElement().getParentElement();
                doc.remove(elmemt.getStartOffset(), elmemt.getEndOffset() - elmemt.getStartOffset());
            }
        }
        catch (Exception ie) {
            ie.printStackTrace(System.err);
        }
        this.m_htmlPane.setDocument((Document)doc);
        this.m_htmlPane.addHyperlinkListener(this);
        JScrollPane scrollPane = new JScrollPane(this.m_htmlPane);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        return scrollPane;
    }

    private String getDisplyNameForCerttification(IElementClassCoreInfo.ECertifications certification) {
        if (certification.equals((Object)IElementClassCoreInfo.ECertifications.I_TESTED)) {
            return "I-Tested";
        }
        if (certification.equals((Object)IElementClassCoreInfo.ECertifications.DSP_BUILDER_READY)) {
            return "DSP Builder Ready";
        }
        if (certification.equals((Object)IElementClassCoreInfo.ECertifications.SOPC_BUILDER_READY)) {
            return "SOPC Builder Ready";
        }
        if (certification.equals((Object)IElementClassCoreInfo.ECertifications.AMPP_APPROVED)) {
            return "AMPP Approved";
        }
        return "";
    }
}

