/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.hdlconstants.sopcFlow;

import com.altera.megacore.pcie.hdlconstants.HDLConstant;
import com.altera.megacore.pcie.hdlconstants.HDLConstantVectorType;
import com.altera.megacore.pcie.hdlconstants.IHDLConstants;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import java.util.Collection;
import java.util.Vector;

public class PCIEAvalonHDLConstants
implements IHDLConstants {
    public final HDLConstant<Integer> cg_pcie_completer_only = new HDLConstant("CB_PCIE_MODE");
    public final HDLConstant<Integer> cg_avalon_s_addr_width = new HDLConstant("CG_AVALON_S_ADDR_WIDTH");
    public final HDLConstant<Integer> cg_common_clock_mode = new HDLConstant("CG_COMMON_CLOCK_MODE");
    public final HDLConstant<Integer> cg_impl_cra_av_slave_port = new HDLConstant("CG_IMPL_CRA_AV_SLAVE_PORT");
    public final HDLConstant<String> intended_device_family = new HDLConstant("INTENDED_DEVICE_FAMILY");
    public final HDLConstant<Integer> cb_a2p_addr_map_num_entries = new HDLConstant("CB_A2P_ADDR_MAP_NUM_ENTRIES");
    public final HDLConstant<Integer> cb_a2p_addr_map_pass_thru_bits = new HDLConstant("CB_A2P_ADDR_MAP_PASS_THRU_BITS");
    public final HDLConstant<Integer> cb_a2p_addr_map_is_fixed = new HDLConstant("CB_A2P_ADDR_MAP_IS_FIXED");
    public final HDLConstant<HDLConstantVectorType> cb_a2p_addr_map_fixed_table = new HDLConstant("CB_A2P_ADDR_MAP_FIXED_TABLE");
    public final HDLConstant<HDLConstantVectorType> cb_p2a_avalon_addr_b0 = new HDLConstant("CB_P2A_AVALON_ADDR_B0");
    public final HDLConstant<HDLConstantVectorType> cb_p2a_avalon_addr_b1 = new HDLConstant("CB_P2A_AVALON_ADDR_B1");
    public final HDLConstant<HDLConstantVectorType> cb_p2a_avalon_addr_b2 = new HDLConstant("CB_P2A_AVALON_ADDR_B2");
    public final HDLConstant<HDLConstantVectorType> cb_p2a_avalon_addr_b3 = new HDLConstant("CB_P2A_AVALON_ADDR_B3");
    public final HDLConstant<HDLConstantVectorType> cb_p2a_avalon_addr_b4 = new HDLConstant("CB_P2A_AVALON_ADDR_B4");
    public final HDLConstant<HDLConstantVectorType> cb_p2a_avalon_addr_b5 = new HDLConstant("CB_P2A_AVALON_ADDR_B5");

    @Override
    public Collection<HDLConstant> getHDLConstant(IPCIECompilerCoreParameters parameter) {
        Vector<HDLConstant> hdlConstants = new Vector<HDLConstant>();
        try {
            this.setHDLConstantValues(parameter);
            hdlConstants.add(this.cg_pcie_completer_only);
            hdlConstants.add(this.cg_avalon_s_addr_width);
            hdlConstants.add(this.cg_common_clock_mode);
            hdlConstants.add(this.cg_impl_cra_av_slave_port);
            hdlConstants.add(this.intended_device_family);
            hdlConstants.add(this.cb_a2p_addr_map_num_entries);
            hdlConstants.add(this.cb_a2p_addr_map_pass_thru_bits);
            hdlConstants.add(this.cb_a2p_addr_map_is_fixed);
            hdlConstants.add(this.cb_a2p_addr_map_fixed_table);
            hdlConstants.add(this.cb_p2a_avalon_addr_b0);
            hdlConstants.add(this.cb_p2a_avalon_addr_b1);
            hdlConstants.add(this.cb_p2a_avalon_addr_b2);
            hdlConstants.add(this.cb_p2a_avalon_addr_b3);
            hdlConstants.add(this.cb_p2a_avalon_addr_b4);
            hdlConstants.add(this.cb_p2a_avalon_addr_b5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hdlConstants;
    }

    private void setHDLConstantValues(IPCIECompilerCoreParameters parameters) throws Exception {
        try {
            if (!parameters.isP_pci_master()) {
                this.cg_pcie_completer_only.setValue(1);
            } else {
                this.cg_pcie_completer_only.setValue(0);
            }
            switch (parameters.getP_avalon_pane_count()) {
                case 1: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size());
                    break;
                }
                case 2: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 1);
                    break;
                }
                case 4: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 2);
                    break;
                }
                case 8: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 3);
                    break;
                }
                case 16: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 4);
                    break;
                }
                case 32: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 5);
                    break;
                }
                case 64: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 6);
                    break;
                }
                case 128: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 7);
                    break;
                }
                case 256: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 8);
                    break;
                }
                case 512: {
                    this.cg_avalon_s_addr_width.setValue(parameters.getP_avalon_pane_size() + 9);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Problem with the Avalon Pane Count");
                }
            }
            if (!parameters.isP_pci_single_clock()) {
                this.cg_common_clock_mode.setValue(0);
            } else {
                this.cg_common_clock_mode.setValue(1);
            }
            if (parameters.isP_pci_impl_cra_av_slave_port()) {
                this.cg_impl_cra_av_slave_port.setValue(1);
            } else {
                this.cg_impl_cra_av_slave_port.setValue(0);
            }
            this.intended_device_family.setValue(parameters.getDeviceFamily().getDisplayName());
            this.cb_a2p_addr_map_num_entries.setValue(parameters.getP_avalon_pane_count());
            this.cb_a2p_addr_map_pass_thru_bits.setValue(parameters.getP_avalon_pane_size());
            if (parameters.isP_avalon_hardwired_address_map()) {
                this.cb_a2p_addr_map_is_fixed.setValue(1);
            } else {
                this.cb_a2p_addr_map_is_fixed.setValue(0);
            }
            StringBuffer fixedTable = new StringBuffer(257);
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_15(), parameters.getP_avalon_hw_pci_address_15_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_14(), parameters.getP_avalon_hw_pci_address_14_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_13(), parameters.getP_avalon_hw_pci_address_13_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_12(), parameters.getP_avalon_hw_pci_address_12_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_11(), parameters.getP_avalon_hw_pci_address_11_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_10(), parameters.getP_avalon_hw_pci_address_10_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_09(), parameters.getP_avalon_hw_pci_address_09_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_08(), parameters.getP_avalon_hw_pci_address_08_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_07(), parameters.getP_avalon_hw_pci_address_07_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_06(), parameters.getP_avalon_hw_pci_address_06_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_05(), parameters.getP_avalon_hw_pci_address_05_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_04(), parameters.getP_avalon_hw_pci_address_04_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_03(), parameters.getP_avalon_hw_pci_address_03_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_02(), parameters.getP_avalon_hw_pci_address_02_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_01(), parameters.getP_avalon_hw_pci_address_01_type()));
            fixedTable.append(this.getAvalon2PCIHardwiredAddress(parameters.getP_avalon_hw_pci_address_00(), parameters.getP_avalon_hw_pci_address_00_type()));
            this.cb_a2p_addr_map_fixed_table.setValue(new HDLConstantVectorType(fixedTable.toString(), HDLConstantVectorType.ERadix.HEX, 1024));
            this.cb_p2a_avalon_addr_b0.setValue(new HDLConstantVectorType(parameters.getActualBAR0AvalonAddress(), HDLConstantVectorType.ERadix.HEX, 32));
            this.cb_p2a_avalon_addr_b1.setValue(new HDLConstantVectorType(parameters.getActualBAR1AvalonAddress(), HDLConstantVectorType.ERadix.HEX, 32));
            this.cb_p2a_avalon_addr_b2.setValue(new HDLConstantVectorType(parameters.getActualBAR2AvalonAddress(), HDLConstantVectorType.ERadix.HEX, 32));
            this.cb_p2a_avalon_addr_b3.setValue(new HDLConstantVectorType(parameters.getActualBAR3AvalonAddress(), HDLConstantVectorType.ERadix.HEX, 32));
            this.cb_p2a_avalon_addr_b4.setValue(new HDLConstantVectorType(parameters.getActualBAR4AvalonAddress(), HDLConstantVectorType.ERadix.HEX, 32));
            this.cb_p2a_avalon_addr_b5.setValue(new HDLConstantVectorType(parameters.getActualBAR5AvalonAddress(), HDLConstantVectorType.ERadix.HEX, 32));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String getAvalon2PCIHardwiredAddress(String pAvalon2PCIHardwiredAddress, IPCIECompilerCoreParameters.EAvalonAddressType pAvalon2PCIHardwiredAddressType) throws IllegalArgumentException {
        String Avalon2PCIHardwiredAddress = "";
        switch (pAvalon2PCIHardwiredAddressType) {
            case Memory32Bit: {
                Avalon2PCIHardwiredAddress = pAvalon2PCIHardwiredAddress.subSequence(2, 17) + "0";
                break;
            }
            case Memory64Bit: {
                Avalon2PCIHardwiredAddress = pAvalon2PCIHardwiredAddress.subSequence(2, 17) + "1";
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)pAvalon2PCIHardwiredAddressType) + " : Value not in range ( 0,1) for method getAvalon2PCIHardwiredAddress()");
            }
        }
        return Avalon2PCIHardwiredAddress;
    }
}

