/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.hdlconstants;

import com.altera.megacore.pcie.hdlconstants.IHDLConstantWithWidth;

public class HDLConstantVectorType
implements IHDLConstantWithWidth {
    private String value;
    private int width;
    private ERadix radix;

    public HDLConstantVectorType(String value, ERadix radix, int width) {
        this.value = value;
        this.radix = radix;
        this.width = width;
    }

    public HDLConstantVectorType(Long value, ERadix radix, int width) {
        this.radix = radix;
        this.width = width;
        switch (this.radix) {
            case DECIMAL: {
                this.value = value.toString();
                break;
            }
            case BINARY: {
                this.value = Long.toBinaryString(value);
                break;
            }
            case HEX: {
                this.value = Long.toHexString(value);
                break;
            }
            default: {
                this.value = String.valueOf(value);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getRadix() {
        return this.radix.getRadix();
    }

    public String toString() {
        return this.getValue();
    }

    public static enum ERadix {
        HEX(1),
        DECIMAL(2),
        BINARY(3);

        private int radix;

        private ERadix(int radix) {
            this.radix = radix;
        }

        public int getRadix() {
            return this.radix;
        }
    }
}

