/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.elementclassext;

import com.altera.entityinterfaces.IElementClass;
import com.altera.entityinterfaces.elementclassext.IElementClassCoreInfo;
import com.altera.entityinterfaces.elementclassext.IElementClassDocumentationInfo;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.megawizard2.html.MegaCoreDocumentationInfo;
import com.altera.megawizard2.html.MegaCoreInfo;
import com.altera.sopcmodel.ensemble.DeviceFamily;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;

public class ElementClassInfo
implements IElementClassCoreInfo,
IElementClassDocumentationInfo {
    List<IDeviceFamily> allDeviceFamilies = null;
    URL mywizardPtfURL = null;
    private IElementClass elementClass = null;
    private IElementClassCoreInfo myCoreInfo = null;
    private File myCoreInstallationDir = null;
    private IElementClassDocumentationInfo myDocInfo = null;

    public ElementClassInfo(IElementClass elementClass) {
        this.elementClass = elementClass;
        this.init();
    }

    private void init() {
        try {
            this.mywizardPtfURL = this.getClass().getClassLoader().getResource("altera/ipbu/pci_express/pci_express.ptf");
            this.allDeviceFamilies = DeviceFamily.getDeviceFamilies();
            this.myCoreInfo = new MegaCoreInfo(this.mywizardPtfURL, this.allDeviceFamilies);
            this.myCoreInstallationDir = MegaCoreDocumentationInfo.getCoreInstallationPath((IElementClass)this.elementClass);
            if (this.myCoreInstallationDir == null) {
                this.myCoreInstallationDir = new File(System.getenv("MEGACORE_ROOT"), "ip_compiler_for_pci_express");
            }
            this.myDocInfo = new MegaCoreDocumentationInfo(this.mywizardPtfURL, this.myCoreInstallationDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection<IElementClassCoreInfo.ECertifications> getCertifications() {
        return this.myCoreInfo.getCertifications();
    }

    public Collection<String> getOrderingCodes() {
        return this.myCoreInfo.getOrderingCodes();
    }

    public Collection<String> getProductIDs() {
        return this.myCoreInfo.getProductIDs();
    }

    public Collection<IElementClassCoreInfo.DeviceSupportInfo> getSupportedDeviceFamilies() {
        return this.myCoreInfo.getSupportedDeviceFamilies();
    }

    public String getVendorID() {
        return this.myCoreInfo.getVendorID();
    }

    public boolean isOpenCorePlusSupported() {
        return this.myCoreInfo.isOpenCorePlusSupported();
    }

    public List<IElementClassDocumentationInfo.IDocumentUrl> getDocumentUrls() {
        return this.myDocInfo.getDocumentUrls();
    }
}

