/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.elementclassext;

import com.altera.entityinterfaces.elementclassext.IElementClassCoreInfo;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.sopcmodel.ensemble.DeviceFamily;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ElementClassCoreInfo
implements IElementClassCoreInfo {
    private Collection<IElementClassCoreInfo.DeviceSupportInfo> supportedDevices = new Vector<IElementClassCoreInfo.DeviceSupportInfo>();

    public ElementClassCoreInfo() {
        this.init();
    }

    private void init() {
        try {
            String supportedDeviceFamily = CoreInfo.SupportedDeviceFamily.toString();
            StringTokenizer tokenizer = new StringTokenizer(supportedDeviceFamily, "|");
            while (tokenizer.hasMoreTokens()) {
                String strDevice = tokenizer.nextToken();
                if (strDevice == null) continue;
                strDevice = strDevice.replaceAll(" ", "");
                IDeviceFamily devFamily = DeviceFamily.getDeviceFamily((String)(strDevice = strDevice.toUpperCase()));
                if (devFamily == null) continue;
                this.supportedDevices.add(new SupportedDeviceInfo(devFamily, IElementClassCoreInfo.DeviceSupportInfo.ESupportTypes.FULLSUPPORT));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Collection<String> getOrderingCodes() {
        return null;
    }

    public String getVendorID() {
        return null;
    }

    public Collection<String> getProductIDs() {
        return null;
    }

    public Collection<IElementClassCoreInfo.ECertifications> getCertifications() {
        return null;
    }

    public Collection<IElementClassCoreInfo.DeviceSupportInfo> getSupportedDeviceFamilies() {
        return this.supportedDevices;
    }

    public boolean isOpenCorePlusSupported() {
        return false;
    }

    class SupportedDeviceInfo
    implements IElementClassCoreInfo.DeviceSupportInfo {
        private IDeviceFamily deviceFamily;
        private IElementClassCoreInfo.DeviceSupportInfo.ESupportTypes supportType;

        SupportedDeviceInfo(IDeviceFamily deviceFamily, IElementClassCoreInfo.DeviceSupportInfo.ESupportTypes supportType) {
            this.deviceFamily = deviceFamily;
            this.supportType = supportType;
        }

        public IDeviceFamily getDeviceFamily() {
            return this.deviceFamily;
        }

        public IElementClassCoreInfo.DeviceSupportInfo.ESupportTypes getSupportType() {
            return this.supportType;
        }

        public void setDeviceFamily(IDeviceFamily deviceFamily) {
            this.deviceFamily = deviceFamily;
        }

        public void setSupportType(IElementClassCoreInfo.DeviceSupportInfo.ESupportTypes supportType) {
            this.supportType = supportType;
        }
    }

    public static enum CoreInfo {
        SupportedDeviceFamily;

        private String value = this.name();

        private CoreInfo() {
            Properties coreInfoProp = new Properties();
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("ElementClassCoreInfo.info");
                coreInfoProp.load(is);
                is.close();
                this.value = coreInfoProp.getProperty(this.name());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.value;
        }
    }
}

