/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.context;

import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.megacore.pcie.context.IContext;
import com.altera.megacore.pcie.context.states.IContextState;
import com.altera.megacore.pcie.context.states.PCIENativeState;
import com.altera.megacore.pcie.context.states.PCIESOPCState;
import com.altera.megacore.pcie.context.states.PCIEState;
import com.altera.megacore.pcie.hdlconstants.HDLConstant;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.parametercustomizers.IParameterDescriptorCustomizer;
import com.altera.megacore.pcie.model.validators.IValidator;
import java.util.Collection;
import java.util.List;

public class Context
implements IContext {
    private IContextState ethernetState = null;
    private IContext.EContext mycontext = null;

    public Context(IPCIECompilerCoreParameters parameters) {
        this.ethernetState = this.getState(parameters);
    }

    public IContextState getState() {
        return this.ethernetState;
    }

    @Override
    public IContext.EContext getContext() {
        if (this.mycontext != null) {
            return this.mycontext;
        }
        return IContext.EContext.SOPCContext;
    }

    @Override
    public IParameterDescriptorCustomizer getParameterDescriptorCustomizer() {
        return this.getState().getParameterDescriptorCustomizer();
    }

    @Override
    public List<IConnectionPoint> getConnectionPoints() {
        return this.getState().getConnectionPoints();
    }

    @Override
    public String getHDLModuleName() {
        return this.getState().getHDLModuleName();
    }

    @Override
    public Collection<HDLConstant> getHDLConstants() {
        return this.getState().getHDLConstants();
    }

    @Override
    public IValidator getModelValidator() {
        return this.getState().getModelValidator();
    }

    private IContextState getState(IPCIECompilerCoreParameters parameter) {
        PCIEState contextState = null;
        IContext.EContext currentContext = IContext.EContext.NativeContext;
        try {
            currentContext = this.getContext();
            switch (currentContext) {
                case SOPCContext: {
                    contextState = new PCIESOPCState(parameter);
                    break;
                }
                case NativeContext: {
                    contextState = new PCIENativeState(parameter);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return contextState;
    }

    public boolean hasExtension(Class clazz) {
        return this.getExtension(clazz) != null;
    }

    public <T> T getExtension(Class<T> clazz) {
        return (T)this.getState().getExtension(clazz);
    }

    @Override
    public void setContext(IContext.EContext context) {
        this.mycontext = context;
    }
}

