/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.connections.ports;

import com.altera.entityinterfaces.IPort;
import com.altera.sopcmodel.clock.Clock;
import com.altera.sopcmodel.interrupt.Interrupt;
import com.altera.sopcmodel.util.Port;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;

public abstract class PCIEPorts {
    protected PCIEPorts() {
    }

    public List<Port> getDeclaredPorts() {
        Field[] ports = this.getClass().getFields();
        Vector<Port> listPorts = new Vector<Port>(ports.length);
        for (Field port : ports) {
            if (!port.getType().getName().equals(Port.class.getName())) continue;
            try {
                listPorts.add((Port)port.get(this));
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (listPorts.size() > 0) {
            return listPorts;
        }
        return null;
    }

    public static synchronized <T extends PCIEPorts> T create(Class<T> clazz) {
        PCIEPorts ethernetPorts = null;
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            ethernetPorts = (PCIEPorts)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (T)ethernetPorts;
    }

    public static class PCICRASlavePorts
    extends PCIEPorts {
        public final Port CraAddress_i = Port.create((String)"CraAddress_i", (String)"address", (IPort.Direction)IPort.Direction.Input, (int)12);
        public final Port CraBeginTransfer_i = Port.create((String)"CraBeginTransfer_i", (String)"begintransfer", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port CraByteEnable_i = Port.create((String)"CraByteEnable_i", (String)"byteenable", (IPort.Direction)IPort.Direction.Input, (int)4);
        public final Port CraChipSelect_i = Port.create((String)"CraChipSelect_i", (String)"chipselect", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port CraRead_i = Port.create((String)"CraRead", (String)"read", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port CraReadData_o = Port.create((String)"CraReadData_o", (String)"readdata", (IPort.Direction)IPort.Direction.Output, (int)32);
        public final Port CraResetRequest_o = Port.create((String)"CraResetRequest_o", (String)"resetrequest_n", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port CraWaitRequest_o = Port.create((String)"CraWaitRequest_o", (String)"waitrequest", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port CraWrite_i = Port.create((String)"CraWrite", (String)"write", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port CraWriteData_i = Port.create((String)"CraWriteData_i", (String)"writedata", (IPort.Direction)IPort.Direction.Input, (int)32);

        protected PCICRASlavePorts() {
        }
    }

    public static class PCIIRQPorts
    extends PCIEPorts {
        public final Port RxmIrq_i = Port.create((String)"RxmIrq_i", (String)Interrupt.IRQ, (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port RxmIrqNum_i = Port.create((String)"RxmIrqNum_i", (String)"irqnumber", (IPort.Direction)IPort.Direction.Input, (int)6);
        public final Port CraIrq_o = Port.create((String)"CraIrq_o", (String)Interrupt.IRQ, (IPort.Direction)IPort.Direction.Output, (int)1);
    }

    public static class PCIERxMasterPorts
    extends PCIEPorts {
        public final Port RxmAddress_o = Port.create((String)"RxmAddress_o", (String)"address", (IPort.Direction)IPort.Direction.Output, (int)32);
        public final Port RxmByteEnable_o = Port.create((String)"RxmByteEnable_o", (String)"byteenable", (IPort.Direction)IPort.Direction.Output, (int)8);
        public final Port RxmRead_o = Port.create((String)"RxmRead_o", (String)"read", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port RxmReadData_i = Port.create((String)"RxmReadData_i", (String)"readdata", (IPort.Direction)IPort.Direction.Input, (int)64);
        public final Port RxmWaitRequest_i = Port.create((String)"RxmWaitRequest_i", (String)"waitrequest", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port RxmWrite_o = Port.create((String)"RxmWrite_o", (String)"write", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port RxmWriteData_o = Port.create((String)"RxmWriteData_o", (String)"writedata", (IPort.Direction)IPort.Direction.Output, (int)64);
        public final Port RxmBurstCount_o = Port.create((String)"RxmBurstCount_o", (String)"burstcount", (IPort.Direction)IPort.Direction.Output, (int)10);
        public final Port RxmReadDataValid_i = Port.create((String)"RxmReadDataValid_i", (String)"readdatavalid", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port RxmResetRequest_o = Port.create((String)"RxmResetRequest_o", (String)"resetrequest", (IPort.Direction)IPort.Direction.Output, (int)1);

        protected PCIERxMasterPorts() {
        }
    }

    public static class PCIETxPorts
    extends PCIEPorts {
        public final Port TxsAddress_i = Port.create((String)"TxsAddress_i", (String)"address", (IPort.Direction)IPort.Direction.Input, (int)17);
        public final Port TxBeginBurstTransfer_i = Port.create((String)"TxBeginBurstTransfer_i", (String)"beginbursttransfer", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port TxBeginTransfer_i = Port.create((String)"TxBeginTransfer_i", (String)"begintransfer", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port TxsBurstCount_i = Port.create((String)"TxsBurstCount_i", (String)"burstcount", (IPort.Direction)IPort.Direction.Input, (int)10);
        public final Port TxsByteEnable_i = Port.create((String)"TxsByteEnable_i", (String)"byteenable", (IPort.Direction)IPort.Direction.Input, (int)8);
        public final Port TxsChipSelect_i = Port.create((String)"TxsChipSelect_i", (String)"chipselect", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port TxsRead_i = Port.create((String)"TxsRead_i", (String)"read", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port TxsReadData_o = Port.create((String)"TxsReadData_o", (String)"readdata", (IPort.Direction)IPort.Direction.Output, (int)64);
        public final Port TxsReadDataValid_o = Port.create((String)"TxsReadDataValid_o", (String)"readdatavalid", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port TxResetRequest_o = Port.create((String)"TxResetRequest_o", (String)"resetrequest_n", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port TxsWaitRequest_o = Port.create((String)"TxsWaitRequest_o", (String)"waitrequest", (IPort.Direction)IPort.Direction.Output, (int)1);
        public final Port TxsWrite_i = Port.create((String)"TxsWrite_i", (String)"write", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port TxsWriteData_i = Port.create((String)"TxsWriteData_i", (String)"writedata", (IPort.Direction)IPort.Direction.Input, (int)64);

        protected PCIETxPorts() {
        }
    }

    public static class PCI64BitCommonPorts
    extends PCIEPorts {
        public final Port clk = Port.create((String)"Clk_i", (String)"export", (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port reset_n = Port.create((String)"reset_n", (String)Clock.RESET_N, (IPort.Direction)IPort.Direction.Input, (int)1);

        protected PCI64BitCommonPorts() {
        }
    }

    public static class PCIAvalonClock
    extends PCIEPorts {
        public final Port AvlClk_i = Port.create((String)"AvlClk_i", (String)Clock.CLOCK, (IPort.Direction)IPort.Direction.Input, (int)1);
        public final Port rstn = Port.create((String)"Rstn_i", (String)Clock.RESET_N, (IPort.Direction)IPort.Direction.Input, (int)1);

        protected PCIAvalonClock() {
        }
    }
}

