/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.connections.factories;

import altera.ipbu.pci_express.MVCConstants;
import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.IPort;
import com.altera.megacore.pcie.connections.IPCIEConnectionFactory;
import com.altera.megacore.pcie.connections.builders.PCIEConnectionPointBuilder;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.sopcmodel.avalon.AvalonConnectionPoint;
import com.altera.sopcmodel.avalon.AvalonMasterConnectionPoint;
import com.altera.sopcmodel.avalon.AvalonSlaveConnectionPoint;
import com.altera.sopcmodel.beanelement.BeanConnectionPoint;
import com.altera.sopcmodel.clock.ClockConnectionPoint;
import com.altera.sopcmodel.clock.ClockEndConnectionPoint;
import com.altera.sopcmodel.extensions.IAutoConnector;
import com.altera.sopcmodel.interrupt.InterruptConnectionPoint;
import com.altera.sopcmodel.util.Port;
import com.altera.sopcmodel.wire.WireConnectionPoint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PCIESOPCConnectionPointsFactory
implements IPCIEConnectionFactory,
IAutoConnector {
    PCIEConnectionPointBuilder builder;
    private static final int PM_ADDRESS_GROUP = 1;
    AvalonMasterConnectionPoint avalonBAR0MasterConnectionPoint = AvalonMasterConnectionPoint.create();
    AvalonMasterConnectionPoint avalonBAR1MasterConnectionPoint = AvalonMasterConnectionPoint.create();
    AvalonMasterConnectionPoint avalonBAR2MasterConnectionPoint = AvalonMasterConnectionPoint.create();
    AvalonMasterConnectionPoint avalonBAR3MasterConnectionPoint = AvalonMasterConnectionPoint.create();
    AvalonMasterConnectionPoint avalonBAR4MasterConnectionPoint = AvalonMasterConnectionPoint.create();
    AvalonMasterConnectionPoint avalonBAR5MasterConnectionPoint = AvalonMasterConnectionPoint.create();
    WireConnectionPoint wireConnectionPoint = WireConnectionPoint.create();
    ClockConnectionPoint pcieClockConnectionPoint = ClockConnectionPoint.createClockOutput((String)"pcie_core_clk", (String)"pcie_core_clk", null);
    AvalonSlaveConnectionPoint avalonControlConnectionPoint = AvalonSlaveConnectionPoint.create();
    AvalonSlaveConnectionPoint avalonTXConnectionPoint = AvalonSlaveConnectionPoint.create();
    ClockConnectionPoint avalonClockConnectionPoint = ClockConnectionPoint.createClockInput((String)"avalon_clk", (String)"AvlClk_i", (String)"reset_n");
    InterruptConnectionPoint craIRQConnectionPoint = InterruptConnectionPoint.createInterruptor((String)"CraIrq", (IConnectionPoint)this.avalonControlConnectionPoint);
    InterruptConnectionPoint pmIrqConnectionPoint = InterruptConnectionPoint.createInterruptee((String)"PmIrq_i", (int)1, (IConnectionPoint)this.avalonBAR0MasterConnectionPoint);
    InterruptConnectionPoint RxmIrqConnectionPoint = InterruptConnectionPoint.createInterruptee((String)"RxmIrq_i", (int)1, (IConnectionPoint)this.avalonBAR0MasterConnectionPoint);
    InterruptConnectionPoint RxmNumIrqConnectionPoint = InterruptConnectionPoint.createInterruptee((String)"RxmIrq", (int)1, (IConnectionPoint)this.avalonBAR0MasterConnectionPoint);
    InterruptConnectionPoint irqConnectionPoint = this.RxmIrqConnectionPoint;
    InterruptConnectionPoint irqNumConnectionPoint = this.RxmNumIrqConnectionPoint;
    ClockEndConnectionPoint cal_blk_ClockConnectionPoint = ClockEndConnectionPoint.create((String)"cal_blk_clk", (String)"cal_blk_clk", null);
    Document dom = null;
    IPCIECompilerCoreParameters.ELaneOptions lanes = null;
    String phy_interface = null;
    String phy_type = null;
    String test_out_width = null;
    String IPType = null;

    public PCIESOPCConnectionPointsFactory() {
        this.builder = new PCIEConnectionPointBuilder();
    }

    @Override
    public List<IConnectionPoint> buildConnectionPoints(IPCIECompilerCoreParameters parameters) {
        LinkedList<IConnectionPoint> connectionPoints = new LinkedList<IConnectionPoint>();
        this.buildClockConnectionPoint(parameters, connectionPoints);
        ClockConnectionPoint clkConnectionPoint = this.getClockConnectionPoint(parameters);
        this.buildMasterConnectionPoint(parameters, clkConnectionPoint, connectionPoints);
        if (parameters.isP_pci_impl_cra_av_slave_port()) {
            this.buildAvalonCRASlaveConnectionPoint(parameters, clkConnectionPoint);
            this.buildAvalonCRAIRQConnectionPoint(parameters, clkConnectionPoint);
            connectionPoints.add((IConnectionPoint)this.avalonControlConnectionPoint);
            connectionPoints.add((IConnectionPoint)this.craIRQConnectionPoint);
            connectionPoints.add((IConnectionPoint)this.irqNumConnectionPoint);
        } else if (parameters.getP_pcie_avalon_mm_lite() == 1) {
            connectionPoints.add((IConnectionPoint)this.irqConnectionPoint);
        }
        if (parameters.isP_pci_master()) {
            this.buildAvalonTxSlaveConnectionPoint(parameters, clkConnectionPoint);
            connectionPoints.add((IConnectionPoint)this.avalonTXConnectionPoint);
        }
        this.buildWireConnectionPoint(parameters);
        connectionPoints.add((IConnectionPoint)this.wireConnectionPoint);
        return connectionPoints;
    }

    void buildMasterConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint avalonClockConnectionPoint, Collection<IConnectionPoint> connectionPoints) {
        boolean hasNpm = false;
        boolean isUsed = false;
        boolean isPrefetchable = false;
        AvalonMasterConnectionPoint masterConnectionPoint = null;
        AvalonMasterConnectionPoint cpForIrq = null;
        for (int barIndex = 0; barIndex < 6; ++barIndex) {
            switch (barIndex) {
                case 0: {
                    isUsed = parameters.isP_pcie_bar_used_bar_0();
                    isPrefetchable = parameters.isP_pci_bar_0_prefetchable();
                    masterConnectionPoint = this.avalonBAR0MasterConnectionPoint;
                    break;
                }
                case 1: {
                    isUsed = parameters.isP_pcie_bar_used_bar_1();
                    isPrefetchable = parameters.isP_pci_bar_1_prefetchable();
                    masterConnectionPoint = this.avalonBAR1MasterConnectionPoint;
                    if (!PCIESOPCConnectionPointsFactory.isBAR64Bit(0, parameters)) break;
                    isUsed = false;
                    break;
                }
                case 2: {
                    isUsed = parameters.isP_pcie_bar_used_bar_2();
                    isPrefetchable = parameters.isP_pci_bar_2_prefetchable();
                    masterConnectionPoint = this.avalonBAR2MasterConnectionPoint;
                    break;
                }
                case 3: {
                    isUsed = parameters.isP_pcie_bar_used_bar_3();
                    isPrefetchable = parameters.isP_pci_bar_3_prefetchable();
                    masterConnectionPoint = this.avalonBAR3MasterConnectionPoint;
                    if (!PCIESOPCConnectionPointsFactory.isBAR64Bit(2, parameters)) break;
                    isUsed = false;
                    break;
                }
                case 4: {
                    isUsed = parameters.isP_pcie_bar_used_bar_4();
                    isPrefetchable = parameters.isP_pci_bar_4_prefetchable();
                    masterConnectionPoint = this.avalonBAR4MasterConnectionPoint;
                    break;
                }
                case 5: {
                    isUsed = parameters.isP_pcie_bar_used_bar_5();
                    isPrefetchable = parameters.isP_pci_bar_5_prefetchable();
                    masterConnectionPoint = this.avalonBAR5MasterConnectionPoint;
                    if (!PCIESOPCConnectionPointsFactory.isBAR64Bit(4, parameters)) break;
                    isUsed = false;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!isUsed) continue;
            if (isPrefetchable) {
                this.buildPrefetchableMasterConnectionPoint(parameters, avalonClockConnectionPoint, masterConnectionPoint, barIndex, PCIESOPCConnectionPointsFactory.isBAR64Bit(barIndex, parameters));
                if (barIndex == 0) {
                    cpForIrq = masterConnectionPoint;
                }
            } else {
                this.buildNonPrefetchableMasterConnectionPoint(parameters, avalonClockConnectionPoint, masterConnectionPoint, barIndex, PCIESOPCConnectionPointsFactory.isBAR64Bit(barIndex, parameters));
                if (!hasNpm || barIndex == 0) {
                    cpForIrq = masterConnectionPoint;
                }
                hasNpm = true;
            }
            connectionPoints.add((IConnectionPoint)masterConnectionPoint);
        }
        this.buildAvalonIRQNumConnectionPoint(parameters, avalonClockConnectionPoint, cpForIrq);
        this.irqNumConnectionPoint = this.RxmNumIrqConnectionPoint;
        if (parameters.getP_pcie_avalon_mm_lite() == 1) {
            this.buildAvalonPMIRQConnectionPoint(parameters, avalonClockConnectionPoint, cpForIrq);
            this.irqConnectionPoint = this.pmIrqConnectionPoint;
        }
    }

    synchronized void buildPrefetchableMasterConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint, AvalonMasterConnectionPoint masterConnectionPoint, int barNumber, boolean is64BitBar) {
        if (is64BitBar && (barNumber == 0 || barNumber == 2 || barNumber == 4)) {
            masterConnectionPoint.setName("bar" + Integer.toString(barNumber + 1) + "_" + Integer.toString(barNumber) + "_" + "Prefetchable");
        } else {
            masterConnectionPoint.setName("bar" + Integer.toString(barNumber) + "_" + "Prefetchable");
        }
        masterConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        masterConnectionPoint.setModule((IModule)parameters.getModuleCore());
        masterConnectionPoint.setDoStreamReads(false);
        masterConnectionPoint.setDoStreamWrites(false);
        masterConnectionPoint.setInterleaveBursts(false);
        masterConnectionPoint.setMaxAddressWidth(32);
        masterConnectionPoint.setAddressGroup(1);
        for (IPort port : masterConnectionPoint.getPorts()) {
            masterConnectionPoint.removePort(port);
        }
        this.builder.addRxMasterPorts((BeanConnectionPoint)masterConnectionPoint, parameters);
    }

    synchronized void buildNonPrefetchableMasterConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint, AvalonMasterConnectionPoint masterConnectionPoint, int barNumber, boolean is64BitBar) {
        if (is64BitBar && (barNumber == 0 || barNumber == 2 || barNumber == 4)) {
            masterConnectionPoint.setName("bar" + Integer.toString(barNumber + 1) + "_" + Integer.toString(barNumber) + "_" + "Non_Prefetchable");
        } else {
            masterConnectionPoint.setName("bar" + Integer.toString(barNumber) + "_" + "Non_Prefetchable");
        }
        masterConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        masterConnectionPoint.setModule((IModule)parameters.getModuleCore());
        masterConnectionPoint.setDoStreamReads(false);
        masterConnectionPoint.setDoStreamWrites(false);
        masterConnectionPoint.setInterleaveBursts(false);
        masterConnectionPoint.setMaxAddressWidth(32);
        masterConnectionPoint.setAddressGroup(1);
        for (IPort port : masterConnectionPoint.getPorts()) {
            masterConnectionPoint.removePort(port);
        }
        this.builder.addRxMasterPorts((BeanConnectionPoint)masterConnectionPoint, parameters);
    }

    synchronized void buildAvalonIRQNumConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint, AvalonMasterConnectionPoint masterConnectionPoint) {
        this.RxmNumIrqConnectionPoint.setName("RxmIrq");
        this.RxmNumIrqConnectionPoint.setAssociatedAddressablePoint((IConnectionPoint)masterConnectionPoint);
        this.RxmNumIrqConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        this.RxmNumIrqConnectionPoint.setModule((IModule)parameters.getModuleCore());
        this.RxmNumIrqConnectionPoint.setIrqScheme(InterruptConnectionPoint.EIrqScheme.PRIORITY_ENCODED);
        for (IPort port : this.RxmNumIrqConnectionPoint.getPorts()) {
            this.RxmNumIrqConnectionPoint.removePort(port);
        }
        this.builder.addIRQNumPort((BeanConnectionPoint)this.RxmNumIrqConnectionPoint, parameters);
        this.builder.addIRQPort((BeanConnectionPoint)this.RxmNumIrqConnectionPoint, parameters);
    }

    synchronized void buildAvalonPMIRQConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint, AvalonMasterConnectionPoint masterConnectionPoint) {
        this.pmIrqConnectionPoint.setName("PmIrq_i");
        this.pmIrqConnectionPoint.setAssociatedAddressablePoint((IConnectionPoint)masterConnectionPoint);
        this.pmIrqConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        this.pmIrqConnectionPoint.setModule((IModule)parameters.getModuleCore());
        for (IPort port : this.pmIrqConnectionPoint.getPorts()) {
            this.pmIrqConnectionPoint.removePort(port);
        }
        this.builder.addIRQPort((BeanConnectionPoint)this.pmIrqConnectionPoint, parameters);
    }

    synchronized void buildWireConnectionPoint(IPCIECompilerCoreParameters parameters) {
        boolean firstTime = false;
        if (this.lanes == null || this.phy_interface == null || this.phy_type == null) {
            this.lanes = parameters.getP_pcie_number_of_lanes();
            this.phy_interface = parameters.getP_pcie_phy_interface();
            this.phy_type = parameters.getP_pcie_phy();
            this.test_out_width = parameters.getP_pcie_test_out_width();
            this.IPType = parameters.getP_pcie_enable_hip().equals("1") ? "HIP" : "SIP";
            firstTime = true;
        }
        String decoded_phy_name = null;
        decoded_phy_name = parameters.getP_pcie_phy().equalsIgnoreCase("Custom") ? "x" : parameters.getP_pcie_phy();
        if (!(this.lanes.toString().equalsIgnoreCase(parameters.getP_pcie_number_of_lanes().toString()) && this.phy_interface.equalsIgnoreCase(parameters.getP_pcie_phy_interface()) && this.phy_type.equalsIgnoreCase(decoded_phy_name) && this.test_out_width.equalsIgnoreCase(parameters.getP_pcie_test_out_width()) && this.IPType.equalsIgnoreCase(parameters.getP_pcie_enable_hip().equals("1") ? "HIP" : "SIP") && !firstTime)) {
            this.lanes = parameters.getP_pcie_number_of_lanes();
            this.phy_interface = parameters.getP_pcie_phy_interface();
            this.test_out_width = parameters.getP_pcie_test_out_width();
            String string = this.IPType = parameters.getP_pcie_enable_hip().equals("1") ? "HIP" : "SIP";
            this.phy_type = parameters.getP_pcie_phy().equalsIgnoreCase("Stratix II GX") || parameters.getP_pcie_phy().equalsIgnoreCase("Arria GX") ? "Stratix II GX" : (parameters.getP_pcie_phy().equalsIgnoreCase("Stratix IV GX") ? "Stratix IV GX" : (parameters.getP_pcie_phy().equalsIgnoreCase("Stratix GX") ? "Stratix GX" : (parameters.getP_pcie_phy().equalsIgnoreCase("Arria II GX") ? "Arria II GX" : (parameters.getP_pcie_phy().equalsIgnoreCase("Cyclone IV GX") ? "Cyclone IV GX" : (parameters.getP_pcie_phy().equalsIgnoreCase("HardCopy IV GX") ? "HardCopy IV GX" : "x")))));
            try {
                this.wireConnectionPoint.setName("exported_connection");
                this.wireConnectionPoint.setModule((IModule)parameters.getModuleCore());
                for (IPort port : this.wireConnectionPoint.getPorts()) {
                    this.wireConnectionPoint.removePort(port);
                }
                String LANES = "";
                String PHY_INTERFACE = "";
                String PHY_TYPE = "";
                String IP_TYPE = "";
                InputStream inStream = null;
                JarFile jarFile = new JarFile(this.getCoreInstallationPath());
                String szFilename = "altera/ipbu/pci_express/" + MVCConstants.getResourceString("PCIE_Exported_Ports_File");
                inStream = jarFile.getInputStream(jarFile.getEntry(szFilename));
                this.parseXmlFile(inStream, false);
                Element docEle = this.dom.getDocumentElement();
                NodeList nl = docEle.getElementsByTagName("data");
                if (nl != null && nl.getLength() > 0) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element el = (Element)nl.item(i);
                        LANES = el.getAttribute("Lanes");
                        PHY_INTERFACE = el.getAttribute("PhyInterface");
                        PHY_TYPE = el.getAttribute("Family");
                        IP_TYPE = el.getAttribute("IPType");
                        if (!LANES.equalsIgnoreCase(this.lanes.toString().substring(1)) || !PHY_INTERFACE.equalsIgnoreCase(this.phy_interface) || !PHY_TYPE.equalsIgnoreCase(this.phy_type) || !IP_TYPE.equals(this.IPType)) continue;
                        NamedNodeMap attrs = el.getAttributes();
                        int numAttrs = attrs.getLength();
                        for (int ii = 0; ii < numAttrs; ++ii) {
                            Attr attr = (Attr)attrs.item(ii);
                            int width = 1;
                            String attrName = attr.getNodeName();
                            String attrValue = attr.getNodeValue();
                            if (attrValue.startsWith("test_out")) {
                                width = parameters.getP_pcie_test_out_width().equalsIgnoreCase("9 bits") ? 9 : (parameters.getP_pcie_test_out_width().equalsIgnoreCase("512 bits") ? 512 : (parameters.getP_pcie_test_out_width().equalsIgnoreCase("64 bits") ? 64 : 0));
                                if (width <= 0) continue;
                                this.wireConnectionPoint.addPort(Port.create((String)"test_out", (String)"export", (IPort.Direction)IPort.Direction.Output, (int)width));
                                continue;
                            }
                            if (attrValue.indexOf("[") != -1) {
                                String buswidthExpression = attrValue.substring(attrValue.indexOf("[") + 1, attrValue.indexOf("]"));
                                String msb = buswidthExpression.substring(0, buswidthExpression.indexOf("."));
                                String lsb = buswidthExpression.substring(buswidthExpression.lastIndexOf(".") + 1);
                                width = Integer.parseInt(msb) - Integer.parseInt(lsb) + 1;
                                attrValue = attrValue.substring(0, attrValue.indexOf("["));
                            }
                            if (attrName.equalsIgnoreCase("Lanes") || attrName.equalsIgnoreCase("PhyInterface") || attrName.equalsIgnoreCase("Family") || attrName.equalsIgnoreCase("IPType")) continue;
                            if (attrName.substring(0, 5).equalsIgnoreCase("input")) {
                                this.wireConnectionPoint.addPort(Port.create((String)attrValue, (String)"export", (IPort.Direction)IPort.Direction.Input, (int)width));
                                continue;
                            }
                            this.wireConnectionPoint.addPort(Port.create((String)attrValue, (String)"export", (IPort.Direction)IPort.Direction.Output, (int)width));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    synchronized void buildAvalonCRASlaveConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint) {
        this.avalonControlConnectionPoint.setName("Control_Register_Access");
        this.avalonControlConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        this.avalonControlConnectionPoint.setModule((IModule)parameters.getModuleCore());
        this.avalonControlConnectionPoint.setAddressAlignment(AvalonConnectionPoint.AddressAlignment.DYNAMIC);
        this.avalonControlConnectionPoint.setReadLatency(0);
        this.avalonControlConnectionPoint.setReadWaitTime(1);
        this.avalonControlConnectionPoint.setWriteWaitTime(1);
        for (IPort port : this.avalonControlConnectionPoint.getPorts()) {
            this.avalonControlConnectionPoint.removePort(port);
        }
        this.builder.addCRAPorts((BeanConnectionPoint)this.avalonControlConnectionPoint, parameters);
    }

    synchronized void buildAvalonCRAIRQConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint) {
        this.craIRQConnectionPoint.setName("CraIrq");
        this.craIRQConnectionPoint.setAssociatedAddressablePoint((IConnectionPoint)this.avalonControlConnectionPoint);
        this.craIRQConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        this.craIRQConnectionPoint.setModule((IModule)parameters.getModuleCore());
        List iports = this.craIRQConnectionPoint.getPorts();
        for (IPort port : iports) {
            this.craIRQConnectionPoint.removePort(port);
        }
        this.builder.addCRAIRQPort((BeanConnectionPoint)this.craIRQConnectionPoint, parameters);
    }

    synchronized void buildAvalonTxSlaveConnectionPoint(IPCIECompilerCoreParameters parameters, ClockConnectionPoint clockConnectionPoint) {
        this.avalonTXConnectionPoint.setName("Tx_Interface");
        this.avalonTXConnectionPoint.setAssociatedClockReset((IConnectionPoint)clockConnectionPoint);
        this.avalonTXConnectionPoint.setModule((IModule)parameters.getModuleCore());
        this.avalonTXConnectionPoint.setAddressAlignment(AvalonConnectionPoint.AddressAlignment.DYNAMIC);
        long addressSpan = (long)Math.pow(2.0, parameters.getP_avalon_pane_size()) * (long)parameters.getP_avalon_pane_count();
        this.avalonTXConnectionPoint.setAddressSpan(BigInteger.valueOf(addressSpan));
        this.avalonTXConnectionPoint.setInterleaveBursts(false);
        this.avalonTXConnectionPoint.setMaximumPendingReadTransactions(parameters.getP_pcie_tag_supported());
        this.avalonTXConnectionPoint.setReadLatency(0);
        this.avalonTXConnectionPoint.setReadWaitTime(1);
        this.avalonTXConnectionPoint.setWriteWaitTime(1);
        for (IPort port : this.avalonTXConnectionPoint.getPorts()) {
            this.avalonTXConnectionPoint.removePort(port);
        }
        this.builder.addTxPorts((BeanConnectionPoint)this.avalonTXConnectionPoint, parameters);
    }

    synchronized void buildClockConnectionPoint(IPCIECompilerCoreParameters parameters, Collection<IConnectionPoint> connectionPoints) {
        if (parameters.isP_pci_single_clock()) {
            this.pcieClockConnectionPoint.setName("pcie_core_clk");
            this.pcieClockConnectionPoint.setModule((IModule)parameters.getModuleCore());
            ClockConnectionPoint.setClockRateKnown((IConnectionPoint)this.pcieClockConnectionPoint, (boolean)true);
            if (parameters.getP_pcie_internal_clock().equalsIgnoreCase("62.5 MHz")) {
                ClockConnectionPoint.setClockRate((IConnectionPoint)this.pcieClockConnectionPoint, (long)62500000L);
            } else {
                ClockConnectionPoint.setClockRate((IConnectionPoint)this.pcieClockConnectionPoint, (long)125000000L);
            }
            this.pcieClockConnectionPoint.addExtension((Object)this, IAutoConnector.class);
            connectionPoints.add((IConnectionPoint)this.pcieClockConnectionPoint);
        }
        this.avalonClockConnectionPoint.setName("avalon_clk");
        this.avalonClockConnectionPoint.setModule((IModule)parameters.getModuleCore());
        connectionPoints.add((IConnectionPoint)this.avalonClockConnectionPoint);
        if (parameters.getP_pcie_phy().equalsIgnoreCase("Stratix II GX") || parameters.getP_pcie_phy().equalsIgnoreCase("Arria GX") || parameters.getP_pcie_phy().equalsIgnoreCase("Stratix IV GX") || parameters.getP_pcie_phy().equalsIgnoreCase("Arria II GX") || parameters.getP_pcie_phy().equalsIgnoreCase("Cyclone IV GX") || parameters.getP_pcie_phy().equalsIgnoreCase("HardCopy IV GX")) {
            this.cal_blk_ClockConnectionPoint.setName("cal_blk_clk");
            this.cal_blk_ClockConnectionPoint.setModule((IModule)parameters.getModuleCore());
            connectionPoints.add((IConnectionPoint)this.cal_blk_ClockConnectionPoint);
        }
    }

    synchronized ClockConnectionPoint getClockConnectionPoint(IPCIECompilerCoreParameters parameters) {
        return this.avalonClockConnectionPoint;
    }

    private static boolean isBAR64Bit(int i, IPCIECompilerCoreParameters parameters) {
        switch (i) {
            case 0: {
                return parameters.getP_pcie_bar_type_bar_0().substring(0, 2).equalsIgnoreCase("64");
            }
            case 1: {
                return parameters.getP_pcie_bar_type_bar_1().substring(0, 2).equalsIgnoreCase("64");
            }
            case 2: {
                return parameters.getP_pcie_bar_type_bar_2().substring(0, 2).equalsIgnoreCase("64");
            }
            case 3: {
                return parameters.getP_pcie_bar_type_bar_3().substring(0, 2).equalsIgnoreCase("64");
            }
            case 4: {
                return parameters.getP_pcie_bar_type_bar_4().substring(0, 2).equalsIgnoreCase("64");
            }
            case 5: {
                return parameters.getP_pcie_bar_type_bar_5().substring(0, 2).equalsIgnoreCase("64");
            }
        }
        return false;
    }

    protected String getCoreInstallationPath() {
        String strMyLocation = null;
        try {
            strMyLocation = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        strMyLocation = strMyLocation.replace("file:", "");
        if (strMyLocation.indexOf(".jar") > 0) {
            File myLocation = new File(strMyLocation);
            if (!myLocation.exists()) {
                return null;
            }
            return myLocation.toString();
        }
        String megacoreRoot = System.getenv("MEGACORE_ROOT");
        return megacoreRoot;
    }

    private void parseXmlFile(InputStream sInput, boolean bValidate) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setValidating(bValidate);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new MyErrorHandler());
            this.dom = db.parse(sInput);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean shouldConnect(IConnectionPoint from, IConnectionPoint to) {
        if (from == to) {
            return false;
        }
        if (!from.isStart()) {
            return false;
        }
        if (to.isStart()) {
            return false;
        }
        return from.getType().equals(to.getType());
    }

    class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            System.out.println("error  : " + e.toString());
        }

        @Override
        public void fatalError(SAXParseException e) {
            System.out.println("fatalError  : " + e.toString());
        }

        @Override
        public void warning(SAXParseException e) {
            System.out.println("warning  : " + e.toString());
        }
    }
}

