/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.connections.customconnections;

import com.altera.entityinterfaces.IPort;
import com.altera.megacore.pcie.connections.customconnections.ICustomConnection;
import com.altera.megacore.pcie.connections.ports.PCIEPorts;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.sopcmodel.util.Port;
import java.util.HashMap;
import java.util.Map;

public class SOPCCustomConnection
implements ICustomConnection {
    private IPCIECompilerCoreParameters parameters;
    private static SOPCCustomConnection instance = new SOPCCustomConnection();
    private static final Map<String, String> mapClockCustomConnection = new HashMap<String, String>();

    private SOPCCustomConnection() {
    }

    private void init(IPCIECompilerCoreParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getCustomConnection(IPort port) {
        boolean bSingleClock = this.parameters.isP_pci_single_clock();
        String customConnection = port.getName();
        if (bSingleClock && mapClockCustomConnection.containsKey(customConnection)) {
            customConnection = mapClockCustomConnection.get(customConnection);
        }
        return customConnection;
    }

    public static ICustomConnection getInstance(IPCIECompilerCoreParameters parameter) {
        instance.init(parameter);
        return instance;
    }

    static {
        Port pciClk = PCIEPorts.create(PCIEPorts.PCI64BitCommonPorts.class).clk;
        Port avlClk = PCIEPorts.create(PCIEPorts.PCIAvalonClock.class).AvlClk_i;
        mapClockCustomConnection.put(pciClk.getName(), avlClk.getName());
    }
}

