/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie.connections.builders;

import com.altera.entityinterfaces.IPort;
import com.altera.megacore.pcie.connections.ports.PCIEPorts;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.sopcmodel.beanelement.BeanConnectionPoint;
import com.altera.sopcmodel.clock.Clock;
import com.altera.sopcmodel.util.Port;

public class PCIEConnectionPointBuilder {
    private PCIEPorts.PCI64BitCommonPorts common64bitPorts = PCIEPorts.create(PCIEPorts.PCI64BitCommonPorts.class);
    private PCIEPorts.PCIERxMasterPorts RxPorts = PCIEPorts.create(PCIEPorts.PCIERxMasterPorts.class);
    private PCIEPorts.PCIETxPorts TxPorts = PCIEPorts.create(PCIEPorts.PCIETxPorts.class);
    private PCIEPorts.PCICRASlavePorts craPorts = PCIEPorts.create(PCIEPorts.PCICRASlavePorts.class);
    private PCIEPorts.PCIAvalonClock avalonClockPorts = PCIEPorts.create(PCIEPorts.PCIAvalonClock.class);
    private PCIEPorts.PCIIRQPorts irqPorts = PCIEPorts.create(PCIEPorts.PCIIRQPorts.class);

    public void addAvalonClockInterface(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        connnectionPoint.addPort(this.avalonClockPorts.AvlClk_i);
    }

    public void addPCIClockInterface(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        connnectionPoint.addPort(Port.create((String)"pcie_core_clk", (String)Clock.CLOCK, (IPort.Direction)IPort.Direction.Output, (int)1));
    }

    public void addAvalonResetInterface(BeanConnectionPoint connnectionPoint) {
        connnectionPoint.addPort(this.common64bitPorts.reset_n);
    }

    public void addIRQPort(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        connnectionPoint.addPort(this.irqPorts.RxmIrq_i);
    }

    public void addIRQNumPort(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        connnectionPoint.addPort(this.irqPorts.RxmIrqNum_i);
    }

    public void addRxMasterPorts(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        connnectionPoint.addPort(this.RxPorts.RxmAddress_o);
        if (!(parameters.getP_pcie_avalon_mm_lite() == 1)) {
            connnectionPoint.addPort(this.RxPorts.RxmBurstCount_o);
        }
        if (parameters.getP_pcie_avalon_mm_lite() == 1) {
            this.RxPorts.RxmByteEnable_o.setWidth(4);
            connnectionPoint.addPort(this.RxPorts.RxmByteEnable_o);
        } else {
            connnectionPoint.addPort(this.RxPorts.RxmByteEnable_o);
        }
        connnectionPoint.addPort(this.RxPorts.RxmRead_o);
        if (parameters.getP_pcie_avalon_mm_lite() == 1) {
            this.RxPorts.RxmReadData_i.setWidth(32);
            connnectionPoint.addPort(this.RxPorts.RxmReadData_i);
        } else {
            connnectionPoint.addPort(this.RxPorts.RxmReadData_i);
        }
        connnectionPoint.addPort(this.RxPorts.RxmReadDataValid_i);
        connnectionPoint.addPort(this.RxPorts.RxmWaitRequest_i);
        connnectionPoint.addPort(this.RxPorts.RxmWrite_o);
        if (parameters.getP_pcie_avalon_mm_lite() == 1) {
            this.RxPorts.RxmWriteData_o.setWidth(32);
            connnectionPoint.addPort(this.RxPorts.RxmWriteData_o);
        } else {
            connnectionPoint.addPort(this.RxPorts.RxmWriteData_o);
        }
        connnectionPoint.addPort(this.RxPorts.RxmResetRequest_o);
    }

    private boolean hasNonPrefetchableMaster(IPCIECompilerCoreParameters parameters) {
        return parameters.isP_pcie_bar_used_bar_0() && !parameters.isP_pci_bar_0_prefetchable() || parameters.isP_pcie_bar_used_bar_1() && !parameters.isP_pci_bar_1_prefetchable() || parameters.isP_pcie_bar_used_bar_2() && !parameters.isP_pci_bar_2_prefetchable() || parameters.isP_pcie_bar_used_bar_3() && !parameters.isP_pci_bar_3_prefetchable() || parameters.isP_pcie_bar_used_bar_4() && !parameters.isP_pci_bar_4_prefetchable() || parameters.isP_pcie_bar_used_bar_5() && !parameters.isP_pci_bar_5_prefetchable();
    }

    public void addTxPorts(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        if (parameters.isP_pci_master()) {
            connnectionPoint.addPort(this.TxPorts.TxsChipSelect_i);
            int i_Cg_Avalon_S_Addr_Width = 0;
            switch (parameters.getP_avalon_pane_count()) {
                case 1: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size();
                    break;
                }
                case 2: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 1;
                    break;
                }
                case 4: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 2;
                    break;
                }
                case 8: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 3;
                    break;
                }
                case 16: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 4;
                    break;
                }
                case 32: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 5;
                    break;
                }
                case 64: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 6;
                    break;
                }
                case 128: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 7;
                    break;
                }
                case 256: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 8;
                    break;
                }
                case 512: {
                    i_Cg_Avalon_S_Addr_Width = parameters.getP_avalon_pane_size() + 9;
                    break;
                }
            }
            this.TxPorts.TxsByteEnable_i.setWidth(8);
            this.TxPorts.TxsReadData_o.setWidth(64);
            this.TxPorts.TxsWriteData_i.setWidth(64);
            this.TxPorts.TxsAddress_i.setWidth(i_Cg_Avalon_S_Addr_Width - 3);
            connnectionPoint.addPort(this.TxPorts.TxsByteEnable_i);
            connnectionPoint.addPort(this.TxPorts.TxsReadData_o);
            connnectionPoint.addPort(this.TxPorts.TxsWriteData_i);
            connnectionPoint.addPort(this.TxPorts.TxsAddress_i);
            connnectionPoint.addPort(this.TxPorts.TxsRead_i);
            connnectionPoint.addPort(this.TxPorts.TxsWrite_i);
            connnectionPoint.addPort(this.TxPorts.TxsReadDataValid_o);
            connnectionPoint.addPort(this.TxPorts.TxsWaitRequest_o);
            connnectionPoint.addPort(this.TxPorts.TxsBurstCount_i);
        }
    }

    public void addCRAPorts(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        if (parameters.isP_pci_impl_cra_av_slave_port()) {
            connnectionPoint.addPort(this.craPorts.CraChipSelect_i);
            this.craPorts.CraAddress_i.setLowerBound(2);
            connnectionPoint.addPort(this.craPorts.CraAddress_i);
            connnectionPoint.addPort(this.craPorts.CraByteEnable_i);
            connnectionPoint.addPort(this.craPorts.CraRead_i);
            connnectionPoint.addPort(this.craPorts.CraReadData_o);
            connnectionPoint.addPort(this.craPorts.CraWrite_i);
            connnectionPoint.addPort(this.craPorts.CraWriteData_i);
            connnectionPoint.addPort(this.craPorts.CraWaitRequest_o);
        }
    }

    public void addCRAIRQPort(BeanConnectionPoint connnectionPoint, IPCIECompilerCoreParameters parameters) {
        connnectionPoint.addPort(this.irqPorts.CraIrq_o);
    }
}

