/*
 * Decompiled with CFR 0.152.
 */
package com.altera.megacore.pcie;

import com.altera.entityinterfaces.IConnectionPoint;
import com.altera.entityinterfaces.IElementClass;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.IParameterDescriptor;
import com.altera.entityinterfaces.elementclassext.IElementClassCoreInfo;
import com.altera.entityinterfaces.elementclassext.IElementClassDocumentationInfo;
import com.altera.entityinterfaces.elementext.IValidateWithFlags;
import com.altera.entityinterfaces.message.EMessageID;
import com.altera.entityinterfaces.message.EMessageLevel;
import com.altera.entityinterfaces.message.IMessage;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.entityinterfaces.moduleext.IDeviceFamily;
import com.altera.entityinterfaces.moduleext.IElementValidateWithParent;
import com.altera.entityinterfaces.moduleext.IModuleGenerateHDL;
import com.altera.entityinterfaces.moduleext.IModuleSetInitialParameterValues;
import com.altera.entityinterfaces.moduleext.ISetDeviceFamily;
import com.altera.entityinterfaces.moduleext.megawizard.IMegaWizard;
import com.altera.megacore.pcie.AlteraPCIECompilerClass;
import com.altera.megacore.pcie.AlteraPCIESystemEditor;
import com.altera.megacore.pcie.context.Context;
import com.altera.megacore.pcie.context.IContext;
import com.altera.megacore.pcie.model.ICoreParameter;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.PCIECompilerCoreParameters;
import com.altera.megacore.pcie.model.validators.PCIEValidateWithSOPCParent;
import com.altera.megacore.pcie.qip.QipExtension;
import com.altera.megacore.pcie.serializer.ElementGeneratePTF;
import com.altera.megacore.pcie.serializer.ModuleGenerateHDL;
import com.altera.megacore.pcie.ui.PCIEMegaWizardGUI;
import com.altera.megawizard2.extensions.IMegawizardGenerateQmegawizFiles;
import com.altera.megawizard2.extensions.MegawizardGenerateQmegawizFiles;
import com.altera.sopcmodel.beanelement.BeanElement;
import com.altera.sopcmodel.beanelement.BeanElementAnnotation;
import com.altera.sopcmodel.ensemble.DeviceFamily;
import com.altera.sopcmodel.extensions.IConnectable;
import com.altera.sopcmodel.extensions.IModuleGenerateFromIPTB2;
import com.altera.sopcmodel.extensions.IModuleProvideQipFiles;
import com.altera.sopcmodel.ptf.IElementGeneratePTF;
import com.altera.sopcmodel.ptf.IModuleImportPTF;
import com.altera.sopcmodel.util.IModuleGenerateFromIPTB;
import com.altera.sopcmodel.util.ISetQuartusProjectInfo;
import com.altera.sopcmodel.util.ISystemEditor;
import com.altera.sopcmodel.util.Message;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

@BeanElementAnnotation.Name(value="altera_avalon_pcie_compiler")
@BeanElementAnnotation.DisplayName(value="IP Compiler for PCI Express")
@BeanElementAnnotation.Version(value="8.0")
public class AlteraPCIECompiler
implements IModule,
ISetDeviceFamily,
IModuleSetInitialParameterValues,
IConnectable,
IMegawizardGenerateQmegawizFiles,
IValidateWithFlags {
    private PCIECompilerCoreParameters parameters;
    private String name;
    private IElementClass elementClass;
    private List<PropertyChangeListener> changeListeners = null;
    private IContext context;
    private List<IConnectionPoint> connectionPoints = null;
    private ModuleGenerateHDL hdlGenerator = null;
    private PCIEMegaWizardGUI ui = null;
    private static final Map<String, Method> mapGetters = new HashMap<String, Method>();
    private static final Map<String, Method> mapSetters = new HashMap<String, Method>();
    private static final Collection<String> derivedParameters = new Vector<String>();
    private MegawizardGenerateQmegawizFiles qmegawizExtension = null;
    private AlteraPCIESystemEditor systemEditor;
    private IDeviceFamily selectedParentDeviceFamily = DeviceFamily.getDeviceFamily((IDeviceFamily.EDeviceFamily)IDeviceFamily.EDeviceFamily.NONE);
    private static boolean isNewVariation = true;

    public static boolean isNewVariation() {
        return isNewVariation;
    }

    public AlteraPCIECompiler(AlteraPCIECompilerClass clazz) {
        this.elementClass = clazz;
        this.parameters = new PCIECompilerCoreParameters(null);
        this.parameters.setModuleCore(this);
        this.context = new Context(this.parameters);
        this.qmegawizExtension = new MegawizardGenerateQmegawizFiles((IModule)this);
        this.init();
    }

    public void init() {
        this.changeListeners = new Vector<PropertyChangeListener>();
        this.setName("ip_compiler_for_pci_express");
    }

    public List<IConnectionPoint> getConnectionPoints() {
        return this.context.getConnectionPoints();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IModuleGenerateHDL getGenerator() {
        return this.getExtension(IModuleGenerateHDL.class);
    }

    public IElementClass getElementClass() {
        return this.elementClass;
    }

    public Collection<IParameterDescriptor> getParameterDescriptors() {
        List pds = this.parameters.getParameterDescriptors();
        return pds;
    }

    public void setValue(String parameterName, Object parameterValue) {
        Object oldValue = this.getValue(parameterName, Object.class);
        Method setter = mapSetters.get(parameterName);
        try {
            setter.invoke((Object)this.parameters, parameterValue);
            this.fireChangeEvent(parameterName, oldValue, parameterValue);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setValueString(String parameterName, String parameterValue) {
        if (derivedParameters.contains(parameterName)) {
            return;
        }
        if (parameterName.equalsIgnoreCase("p_pcie_altgx_keyParameters_used")) {
            HashMap<String, String> keyParameters = new HashMap<String, String>();
            keyParameters.clear();
            parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
            String[] parts = parameterValue.split(", ");
            for (int i = 0; i < parts.length; ++i) {
                String[] entry = parts[i].split("=");
                keyParameters.put(entry[0], entry[1]);
            }
            this.parameters.setP_pcie_altgx_keyParameters_used(keyParameters);
        } else {
            this.parameters.setValueString(parameterName, parameterValue);
        }
        Object oldValue = this.getValue(parameterName, Object.class);
        this.fireChangeEvent(parameterName, oldValue, parameterValue);
        isNewVariation = false;
    }

    public <T> T getValue(String parameterName, Class<T> clazz) {
        Method getter = mapGetters.get(parameterName);
        try {
            Object objReturn = getter.invoke((Object)this.parameters, null);
            if (clazz.isPrimitive()) {
                return (T)objReturn;
            }
            return clazz.cast(objReturn);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getValueString(String parameterName) {
        return this.parameters.getValueString(parameterName);
    }

    public boolean validate(IMessageLogger logger) {
        boolean result = true;
        return result &= this.parameters.validate(logger);
    }

    private IContext getContext() {
        return this.context;
    }

    public <T> T getExtension(Class<T> clazz) {
        if (clazz.isAssignableFrom(IMegaWizard.class)) {
            PCIEMegaWizardGUI ui = new PCIEMegaWizardGUI();
            ui.init(this);
            return clazz.cast((Object)ui);
        }
        if (clazz.isAssignableFrom(IModule.class)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(ISetDeviceFamily.class)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(IModuleSetInitialParameterValues.class)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(IConnectable.class)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(IValidateWithFlags.class)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(BeanElement.class)) {
            return clazz.cast(this.parameters);
        }
        if (clazz.isAssignableFrom(ICoreParameter.class)) {
            return clazz.cast(this.parameters);
        }
        if (clazz.isAssignableFrom(ISetQuartusProjectInfo.class)) {
            if (this.hdlGenerator == null) {
                this.hdlGenerator = new ModuleGenerateHDL(this);
            }
            return clazz.cast(this.hdlGenerator);
        }
        if (clazz.isAssignableFrom(IModuleGenerateFromIPTB.class)) {
            if (this.hdlGenerator == null) {
                this.hdlGenerator = new ModuleGenerateHDL(this);
            }
            return clazz.cast(this.hdlGenerator);
        }
        if (clazz.isAssignableFrom(IModuleGenerateFromIPTB2.class)) {
            if (this.hdlGenerator == null) {
                this.hdlGenerator = new ModuleGenerateHDL(this);
            }
            return clazz.cast(this.hdlGenerator);
        }
        if (clazz.isAssignableFrom(IModuleGenerateHDL.class)) {
            if (this.hdlGenerator == null) {
                this.hdlGenerator = new ModuleGenerateHDL(this);
            }
            return clazz.cast(this.hdlGenerator);
        }
        if (clazz.isAssignableFrom(IElementGeneratePTF.class)) {
            ElementGeneratePTF ptfGenerator = new ElementGeneratePTF(this);
            return clazz.cast(ptfGenerator);
        }
        if (clazz.isAssignableFrom(IElementValidateWithParent.class)) {
            PCIEValidateWithSOPCParent validator = new PCIEValidateWithSOPCParent(this.parameters);
            return clazz.cast(validator);
        }
        if (clazz.isAssignableFrom(IContext.class)) {
            return clazz.cast(this.context);
        }
        if (this.getContext().hasExtension(clazz)) {
            return clazz.cast(this.getContext().getExtension(clazz));
        }
        if (this.getElementClass().hasExtension(clazz)) {
            return clazz.cast(this.getElementClass().getExtension(clazz));
        }
        if (clazz.isAssignableFrom(ISystemEditor.class)) {
            this.systemEditor = AlteraPCIESystemEditor.create();
            return clazz.cast(this.systemEditor);
        }
        if (clazz.isAssignableFrom(IModuleProvideQipFiles.class)) {
            QipExtension qipExtension = new QipExtension(this);
            return clazz.cast(qipExtension);
        }
        if (clazz.isAssignableFrom(IMegawizardGenerateQmegawizFiles.class)) {
            return clazz.cast(this);
        }
        return null;
    }

    public boolean hasExtension(Class clazz) {
        if (clazz.isAssignableFrom(IValidateWithFlags.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IMegaWizard.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModule.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(BeanElement.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(ICoreParameter.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModuleGenerateFromIPTB.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModuleGenerateFromIPTB2.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModuleGenerateHDL.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IElementGeneratePTF.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModuleImportPTF.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IElementClassCoreInfo.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IElementClassDocumentationInfo.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IElementValidateWithParent.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(ISetDeviceFamily.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IContext.class)) {
            return true;
        }
        if (this.getContext().hasExtension(clazz)) {
            return true;
        }
        if (this.getElementClass().hasExtension(clazz)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModuleSetInitialParameterValues.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IConnectable.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(ISystemEditor.class)) {
            return true;
        }
        if (clazz.isAssignableFrom(IModuleProvideQipFiles.class)) {
            return true;
        }
        return clazz.isAssignableFrom(IMegawizardGenerateQmegawizFiles.class);
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.removeChangeListener(listener);
        this.changeListeners.add(listener);
        this.parameters.removeChangeListener(listener);
        this.parameters.addChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.changeListeners.remove(listener);
        this.parameters.removeChangeListener(listener);
    }

    protected final void fireChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            PropertyChangeEvent pe = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (PropertyChangeListener listener : this.changeListeners) {
                listener.propertyChange(pe);
            }
        }
    }

    public void setDeviceFamily(IDeviceFamily family) {
        if (!family.getDeviceFamily().toString().equals(this.selectedParentDeviceFamily.getDeviceFamily().toString())) {
            this.selectedParentDeviceFamily = family;
            if (isNewVariation) {
                if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.STRATIXIIGX.toString())) {
                    this.setValue("p_pcie_phy", "Stratix II GX");
                    this.setValue("p_pcie_enable_hip", "0");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.STRATIXGX.toString())) {
                    this.setValue("p_pcie_phy", "Stratix GX");
                    this.setValue("p_pcie_enable_hip", "0");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.STRATIXIIGXLITE.toString())) {
                    this.setValue("p_pcie_phy", "Arria GX");
                    this.setValue("p_pcie_enable_hip", "0");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.STRATIXIV.toString())) {
                    this.setValue("p_pcie_phy", "Stratix IV GX");
                    this.setValue("p_pcie_enable_hip", "1");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.ARRIAIIGZ.toString())) {
                    this.setValue("p_pcie_phy", "Arria II GZ");
                    this.setValue("p_pcie_enable_hip", "1");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.STRATIXV.toString())) {
                    this.setValue("p_pcie_phy", "Stratix V GX");
                    this.setValue("p_pcie_enable_hip", "1");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.HARDCOPYIV.toString())) {
                    this.setValue("p_pcie_phy", "HardCopy IV GX");
                    this.setValue("p_pcie_enable_hip", "1");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.ARRIAII.toString())) {
                    this.setValue("p_pcie_phy", "Arria II GX");
                    this.setValue("p_pcie_enable_hip", "1");
                } else if (family.getDeviceFamily().toString().equals(IDeviceFamily.EDeviceFamily.STINGRAY.toString())) {
                    this.setValue("p_pcie_phy", "Cyclone IV GX");
                    this.setValue("p_pcie_enable_hip", "1");
                } else {
                    this.setValue("p_pcie_phy", "Custom");
                    this.setValue("p_pcie_enable_hip", "0");
                }
            }
            this.setValue("deviceFamily", family);
        }
    }

    public IDeviceFamily getDeviceFamily() {
        return this.selectedParentDeviceFamily;
    }

    public void setInitialParameterValues(IModuleSetInitialParameterValues.EToolContext tool) {
        IContext myContext = this.getExtension(IContext.class);
        if (tool.equals((Object)IModuleSetInitialParameterValues.EToolContext.STANDALONE)) {
            myContext.setContext(IContext.EContext.NativeContext);
            this.setValue("p_pcie_underSOPCBuilder", false);
            this.setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST);
        } else {
            myContext.setContext(IContext.EContext.SOPCContext);
            this.setValue("p_pcie_underSOPCBuilder", true);
            this.setValue("p_pcie_app_signal_interface", (Object)IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonMM);
        }
    }

    public AlteraPCIESystemEditor getPCIESystemEditor() {
        return this.systemEditor;
    }

    public boolean isConnectable(IConnectionPoint from, IConnectionPoint to) {
        if (from == to) {
            return false;
        }
        if (this.parameters.isP_pci_single_clock()) {
            if (from.getType().equals("clock") && to.getType().equals("clock") && from.getModule() == to.getModule()) {
                return true;
            }
            if (from.getType().equals(to.getType()) && from.getName().equalsIgnoreCase("pcie_core_clk") || to.getName().equalsIgnoreCase("pcie_core_clk")) {
                return true;
            }
            if (from.getType().equals(to.getType()) && from.getName().equalsIgnoreCase("cal_blk_clk") || to.getName().equalsIgnoreCase("cal_blk_clk")) {
                return true;
            }
            if (from.getType().equals(to.getType()) && !from.getType().equals("clock") && !to.getType().equals("clock")) {
                return true;
            }
        } else if (from.getType().equals(to.getType())) {
            return true;
        }
        return false;
    }

    protected String getCoreLibDir() {
        String strMyLocation = null;
        try {
            strMyLocation = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        strMyLocation = strMyLocation.replace("file:", "");
        if (strMyLocation.indexOf(".jar") > 0) {
            File myLocation = new File(strMyLocation);
            if (!myLocation.exists()) {
                return null;
            }
            File fCoreLibIPToolBench = new File(myLocation.getParent());
            return fCoreLibIPToolBench.getParent();
        }
        String megacoreRoot = null;
        String os = System.getProperty("os.name").toLowerCase();
        megacoreRoot = os.startsWith("linux") || os.startsWith("sunos") ? "/tools/megacore/7.1/latest-linux/linux" : "c:/altera/71/ip";
        return megacoreRoot;
    }

    public boolean executeCommand(String szQuartusCmd, File ipSerdesFile, File outputDirectory, String outputLanguage, IMessageLogger logger, Map<String, String> keyParameters, boolean isNewVariant, boolean debug, File outputFile) {
        boolean result;
        if (debug) {
            System.out.println("The PCIe command line passed to qmegawiz is : " + szQuartusCmd + " " + ipSerdesFile);
        }
        if (result = this.qmegawizExtension.executeCommand(szQuartusCmd, ipSerdesFile, outputDirectory, outputLanguage, logger, keyParameters, isNewVariant, debug, null)) {
            this.parameters.setP_pcie_altgx_keyParameters_used(keyParameters);
        }
        return result;
    }

    public String getCommandtoRun() {
        String sLanes = this.getValueString("p_pcie_number_of_lanes").equals("x8") ? "8" : (this.getValueString("p_pcie_number_of_lanes").equals("x4") ? "4" : (this.getValueString("p_pcie_number_of_lanes").equals("x2") ? "2" : "1"));
        String cmdString = " LOCKDOWN_EXCL=PCIE ";
        if ("Stratix IV GX".equals(this.getValueString("p_pcie_phy")) || "Stratix IV GX ES".equals(this.getValueString("p_pcie_phy")) || "Arria II GX".equals(this.getValueString("p_pcie_phy")) || "Arria II GZ".equals(this.getValueString("p_pcie_phy")) || "Cyclone IV GX".equals(this.getValueString("p_pcie_phy")) || "HardCopy IV GX".equals(this.getValueString("p_pcie_phy"))) {
            if (this.getValueString("p_pcie_enable_hip").equalsIgnoreCase("1")) {
                if ("Stratix IV GX ES".equals(this.getValueString("p_pcie_phy")) && this.getValueString("p_pcie_rate").equals("Gen2 (5.0 Gbps)") && sLanes.equals("8")) {
                    cmdString = cmdString + "IP_MODE=PCIE_HIP_8 number_of_channels=8 ";
                    cmdString = cmdString + "-wiz_override=\"enable_pcie_gen2_x8_es=true,pcie_sw_width=1,gxb_powerdown_width=1,cmu_rateswitchin,pcie_sw,pll_inclk_slave,gxb_powerdown,rx_digitalreset_port_width=1,rx_digitalreset,tx_digitalreset_port_width=1,tx_digitalreset,rx_analogreset\" ";
                } else {
                    cmdString = cmdString + "IP_MODE=PCIE_HIP_8 ";
                }
                cmdString = cmdString + "gxb_analog_power=AUTO tx_analog_power=AUTO elec_idle_infer_enable=false tx_allow_polarity_inversion=false rx_cdrctrl_enable=true " + ("Arria II GX".equals(this.getValueString("p_pcie_phy")) && this.getValueString("p_pcie_number_of_lanes").equals("x8") ? "reconfig_togxb_port_width=4 reconfig_fromgxb_port_width=34 " : "") + ("Arria II GX".equals(this.getValueString("p_pcie_phy")) && this.getValueString("p_pcie_number_of_lanes").equals("x4") ? "reconfig_togxb_port_width=4 reconfig_fromgxb_port_width=17 " : "") + ("Arria II GX".equals(this.getValueString("p_pcie_phy")) && this.getValueString("p_pcie_number_of_lanes").equals("x1") ? "reconfig_togxb_port_width=4 reconfig_fromgxb_port_width=17 " : "") + "hip_tx_clkout rx_elecidleinfersel fixedclk " + ("Cyclone IV GX".equals(this.getValueString("p_pcie_phy")) ? "" : "rx_signaldetect rateswitchbaseclock tx_pipemargin tx_pipedeemph rateswitch reconfig_dprio_mode=1 reconfig_clk reconfig_fromgxb reconfig_togxb ") + "enable_0ppm=" + (this.getValueString("p_pcie_rate_match_fifo").toString().equals("true") ? "false " : "true ") + "pll_powerdown ";
            } else {
                if ("Cyclone IV GX".equals(this.getValueString("p_pcie_phy"))) {
                    cmdString = cmdString + " ";
                    return cmdString;
                }
                cmdString = cmdString + "reconfig_dprio_mode=1 ";
                cmdString = cmdString + "gxb_analog_power=AUTO tx_analog_power=AUTO fixedclk reconfig_clk reconfig_fromgxb reconfig_togxb enable_0ppm=" + (this.getValueString("p_pcie_rate_match_fifo").toString().equals("true") ? "false " : "true ") + "pll_powerdown ";
            }
            cmdString = this.getValueString("p_pcie_rate").equals("Gen2 (5.0 Gbps)") ? cmdString + " rx_use_double_data_mode=false tx_use_double_data_mode=false rx_channel_width=8 tx_channel_width=8 rx_dwidth_factor=1 tx_dwidth_factor=1 rx_dataout tx_datain tx_ctrlenable rx_ctrldetect rx_patterndetect rx_syncstatus " : cmdString + " ";
            cmdString = this.getValueString("p_pcie_txrx_clock").equals("125 MHz") ? cmdString + " input_clock_frequency=125 " : cmdString + " ";
            cmdString = cmdString + " OPTIONAL_FILES=\"NONE\" ";
        } else {
            cmdString = cmdString + "enable_fast_recovery_pci_mode=" + (this.getValueString("p_pcie_enable_fast_recovery").equals("1") ? "true" : "false") + " ";
            cmdString = cmdString + " OPTIONAL_FILES=\"SIM_NETLIST\" ";
        }
        cmdString = cmdString + "intended_device_family=" + ("Stratix IV GX".equals(this.getValueString("p_pcie_phy")) || "Stratix IV GX ES".equals(this.getValueString("p_pcie_phy")) ? "\"stratixiv\" " : ("Arria II GZ".equals(this.getValueString("p_pcie_phy")) ? "\"stratixiv\" " : ("HardCopy IV GX".equals(this.getValueString("p_pcie_phy")) ? "\"hardcopyiv\" " : ("Arria II GX".equals(this.getValueString("p_pcie_phy")) ? "\"arriaii\" " : ("Cyclone IV GX".equals(this.getValueString("p_pcie_phy")) ? "\"cycloneiv\" " : "\"stratixiigx\" "))))) + "starting_channel_number=" + this.getValueString("p_pcie_channel_number") + " ";
        if ("HardCopy IV GX".equals(this.getValueString("p_pcie_phy"))) {
            cmdString = cmdString + "intended_device_speed_grade=3 ";
        }
        if ("Cyclone IV GX".equals(this.getValueString("p_pcie_phy"))) {
            cmdString = cmdString + "rx_signal_detect_valid_threshold=14 rx_signal_detect_threshold=3 ";
        }
        return cmdString;
    }

    public File getIPSerdesFile() {
        return new File(this.getCoreLibDir() + "/" + this.resolveIPSerdesFile());
    }

    public File getIPSerdesFile(File coreLibDir) {
        return new File(coreLibDir.getAbsolutePath() + "/" + this.resolveIPSerdesFile());
    }

    private String resolveIPSerdesFile() {
        String sLanes;
        String ipSerdesFile = null;
        String string = this.getValueString("p_pcie_number_of_lanes").equals("x8") ? "8" : (this.getValueString("p_pcie_number_of_lanes").equals("x4") ? "4" : (sLanes = this.getValueString("p_pcie_number_of_lanes").equals("x2") ? "2" : "1"));
        if ("Stratix IV GX ES".equals(this.getValueString("p_pcie_phy")) && this.getValueString("p_pcie_rate").equals("Gen2 (5.0 Gbps)") && sLanes.equals("8")) {
            ipSerdesFile = "altpcie_serdes_4sgx_x4d_gen2_08p.v";
        } else if ("Stratix IV GX".equals(this.getValueString("p_pcie_phy")) || "Stratix IV GX ES".equals(this.getValueString("p_pcie_phy")) || "Arria II GZ".equals(this.getValueString("p_pcie_phy")) || "Arria II GX".equals(this.getValueString("p_pcie_phy")) || "Cyclone IV GX".equals(this.getValueString("p_pcie_phy")) || "HardCopy IV GX".equals(this.getValueString("p_pcie_phy"))) {
            ipSerdesFile = "altpcie_serdes_" + ("Stratix IV GX".equals(this.getValueString("p_pcie_phy")) || "Stratix IV GX ES".equals(this.getValueString("p_pcie_phy")) || "Arria II GZ".equals(this.getValueString("p_pcie_phy")) || "HardCopy IV GX".equals(this.getValueString("p_pcie_phy")) ? "4s" : ("Cyclone IV GX".equals(this.getValueString("p_pcie_phy")) ? "3c" : "2a")) + "gx_x" + sLanes + "d_gen" + (this.getValueString("p_pcie_rate").equals("Gen2 (5.0 Gbps)") ? "2" : "1") + (this.getValueString("p_pcie_enable_hip").equalsIgnoreCase("1") ? "_08p.v" : "_16p.v");
        } else if ("Stratix II GX".equals(this.getValueString("p_pcie_phy")) || "Arria GX".equals(this.getValueString("p_pcie_phy"))) {
            ipSerdesFile = "altpcie_serdes_2sgx_x" + sLanes + "d_10000.v";
        }
        return ipSerdesFile;
    }

    public Map<String, String> getKeyParameters() {
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("p_pcie_number_of_lanes", this.parameters.getValueString("p_pcie_number_of_lanes"));
        myMap.put("p_pcie_rate", this.parameters.getValueString("p_pcie_rate"));
        myMap.put("p_pcie_phy", this.parameters.getValueString("p_pcie_phy"));
        myMap.put("p_pcie_enable_hip", this.parameters.getValueString("p_pcie_enable_hip"));
        myMap.put("p_pcie_txrx_clock", this.parameters.getValueString("p_pcie_txrx_clock"));
        return myMap;
    }

    public boolean PerformCleanUp(boolean deleteAll) {
        return this.qmegawizExtension.PerformCleanUp(deleteAll);
    }

    public boolean forceUpdate(boolean bforceUpdate) {
        this.qmegawizExtension.forceUpdate(bforceUpdate);
        return true;
    }

    public boolean validate(IMessageLogger logger, Set<IValidateWithFlags.Flag> flags) {
        if (flags.contains(IValidateWithFlags.Flag.MERLIN)) {
            EMessageID messageID = EMessageID.ValidationRelated;
            Message m = Message.create((EMessageID)messageID);
            m.setLevel(EMessageLevel.Error);
            m.setObjectName(this.parameters.getModuleCore().getName());
            m.setProblemDescription("\"PCI Express Compiler\" is not supported under Qsys.");
            logger.receiveMessage((IMessage)m);
        }
        return false;
    }

    static {
        try {
            PropertyDescriptor[] reflectedProperties;
            for (PropertyDescriptor pd : reflectedProperties = Introspector.getBeanInfo(PCIECompilerCoreParameters.class, 3).getPropertyDescriptors()) {
                Annotation[] ann;
                Method setter;
                Method getter = pd.getReadMethod();
                if (getter != null) {
                    mapGetters.put(pd.getName(), getter);
                }
                if ((setter = pd.getWriteMethod()) == null) continue;
                mapSetters.put(pd.getName(), setter);
                for (Annotation an : ann = setter.getAnnotations()) {
                    if (an.annotationType() != BeanElementAnnotation.Derived.class) continue;
                    derivedParameters.add(pd.getName());
                }
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }
}

