/*
 * Decompiled with CFR 0.152.
 */
package altera.ipbu.pci_express;

import altera.ipbu.flowbase.SharedObjectsInterface;
import altera.ipbu.flowbase.controls.WLabel;
import altera.ipbu.flowbase.controls.WPanel;
import altera.ipbu.flowbase.netlist.NetlistPrivate;
import altera.ipbu.flowbase.netlist.model.MVCModel;
import altera.ipbu.flowbase.netlist.model.ModelBaseClass;
import altera.ipbu.flowbase.netlist.model.ModelListener;
import altera.ipbu.pci_express.MVCConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;

public class RxBuffer
extends WPanel
implements ModelListener {
    protected ModelBaseClass m_model = null;
    protected int m_num_vc;
    public WPanel pcie_rx_buffer_panel;
    private WPanel pcie_bottom_panel;
    protected SharedObjectsInterface OBJBASE = null;
    protected Hashtable hstPCIAvalon;
    private String m_avalon_hardwired_address_map;
    private WLabel m_postedHeaderCreditLabel;
    private WLabel m_postedHeaderCreditValue;
    private WLabel m_postedHeaderCreditUsedSpace;
    private WLabel m_postedDataCreditLabel;
    private WLabel m_postedDataCreditValue;
    private WLabel m_postedDataCreditUsedSpace;
    private WLabel m_nonpostedHeaderCreditLabel;
    private WLabel m_nonpostedHeaderCreditValue;
    private WLabel m_nonpostedHeaderCreditUsedSpace;
    private WLabel m_completionHeaderCreditLabel;
    private WLabel m_completionHeaderCreditValue;
    private WLabel m_completionHeaderCreditUsedSpace;
    private WLabel m_completionDataCreditLabel;
    private WLabel m_completionDataCreditValue;
    private WLabel m_completionDataCreditUsedSpace;
    private WLabel m_Line_Label;
    private WLabel m_totalHeaderCreditsLabel;
    private WLabel m_totalHeaderCreditsValue;
    private WLabel m_totalRxBufferSpaceLabel;
    private WLabel m_totalRxBufferSpaceValue;

    public RxBuffer(MVCModel model, int num_vc) {
        this.m_model = model;
        this.m_num_vc = num_vc;
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() throws Exception {
        BoxLayout mainLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(mainLayout);
        WLabel setSizeLabel = new WLabel("88888");
        setSizeLabel.setText("88888");
        setSizeLabel.setBorder(BorderFactory.createEtchedBorder());
        WLabel setUsedSpaceLabel = new WLabel("11000 Bytes ");
        setUsedSpaceLabel.setText("11000 Bytes ");
        setUsedSpaceLabel.setBorder(BorderFactory.createEtchedBorder());
        this.pcie_rx_buffer_panel = new WPanel();
        NetlistPrivate param_target_performance_preset = this.m_model.getPrivate("p_pcie_target_performance_preset");
        this.pcie_rx_buffer_panel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints myLayoutConstraints = null;
        myLayoutConstraints = new GridBagConstraints();
        myLayoutConstraints.gridx = 0;
        myLayoutConstraints.gridy = 0;
        myLayoutConstraints.weightx = 0.1;
        myLayoutConstraints.weighty = 0.1;
        myLayoutConstraints.anchor = 17;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_postedHeaderCreditLabel = new WLabel(MVCConstants.getResourceString("PCIE_Posted_Header_Credit") + "   ");
        this.pcie_rx_buffer_panel.add((Component)this.m_postedHeaderCreditLabel, (Object)myLayoutConstraints);
        String value = "16";
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_postedHeaderCreditValue = new WLabel(value);
        this.m_postedHeaderCreditValue.setText(value);
        this.m_postedHeaderCreditValue.setPreferredSize(setSizeLabel.getPreferredSize());
        this.pcie_rx_buffer_panel.add((Component)this.m_postedHeaderCreditValue, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 2;
        this.pcie_rx_buffer_panel.add((Component)new WLabel(""), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_postedHeaderCreditUsedSpace = new WLabel(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_postedHeaderCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_postedHeaderCreditUsedSpace.setPreferredSize(new Dimension(this.m_postedHeaderCreditUsedSpace.getPreferredSize().width + setUsedSpaceLabel.getPreferredSize().width, setUsedSpaceLabel.getPreferredSize().height));
        this.pcie_rx_buffer_panel.add((Component)this.m_postedHeaderCreditUsedSpace, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 0;
        ++myLayoutConstraints.gridy;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_postedDataCreditLabel = new WLabel(MVCConstants.getResourceString("PCIE_Posted_Data_Credit") + "   ");
        this.pcie_rx_buffer_panel.add((Component)this.m_postedDataCreditLabel, (Object)myLayoutConstraints);
        value = "16";
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_postedDataCreditValue = new WLabel(value);
        this.m_postedDataCreditValue.setText(value);
        this.m_postedDataCreditValue.setPreferredSize(setSizeLabel.getPreferredSize());
        this.pcie_rx_buffer_panel.add((Component)this.m_postedDataCreditValue, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 2;
        this.pcie_rx_buffer_panel.add((Component)new WLabel(""), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_postedDataCreditUsedSpace = new WLabel(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_postedDataCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_postedDataCreditUsedSpace.setPreferredSize(new Dimension(this.m_postedDataCreditUsedSpace.getPreferredSize().width + setUsedSpaceLabel.getPreferredSize().width, setUsedSpaceLabel.getPreferredSize().height));
        this.pcie_rx_buffer_panel.add((Component)this.m_postedDataCreditUsedSpace, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 0;
        ++myLayoutConstraints.gridy;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_nonpostedHeaderCreditLabel = new WLabel(MVCConstants.getResourceString("PCIE_Non_Posted_Header_Credit") + "   ");
        this.pcie_rx_buffer_panel.add((Component)this.m_nonpostedHeaderCreditLabel, (Object)myLayoutConstraints);
        value = "16";
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_nonpostedHeaderCreditValue = new WLabel(value);
        this.m_nonpostedHeaderCreditValue.setText(value);
        this.m_nonpostedHeaderCreditValue.setPreferredSize(setSizeLabel.getPreferredSize());
        this.pcie_rx_buffer_panel.add((Component)this.m_nonpostedHeaderCreditValue, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 2;
        this.pcie_rx_buffer_panel.add((Component)new WLabel(""), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_nonpostedHeaderCreditUsedSpace = new WLabel(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_nonpostedHeaderCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_nonpostedHeaderCreditUsedSpace.setPreferredSize(new Dimension(this.m_nonpostedHeaderCreditUsedSpace.getPreferredSize().width + setUsedSpaceLabel.getPreferredSize().width, setUsedSpaceLabel.getPreferredSize().height));
        this.pcie_rx_buffer_panel.add((Component)this.m_nonpostedHeaderCreditUsedSpace, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 0;
        ++myLayoutConstraints.gridy;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_completionHeaderCreditLabel = new WLabel(MVCConstants.getResourceString("PCIE_Completion_Header_Credit") + "   ");
        this.pcie_rx_buffer_panel.add((Component)this.m_completionHeaderCreditLabel, (Object)myLayoutConstraints);
        value = "16";
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_completionHeaderCreditValue = new WLabel(value);
        this.m_completionHeaderCreditValue.setText(value);
        this.m_completionHeaderCreditValue.setPreferredSize(setSizeLabel.getPreferredSize());
        this.pcie_rx_buffer_panel.add((Component)this.m_completionHeaderCreditValue, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 2;
        this.pcie_rx_buffer_panel.add((Component)new WLabel(""), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_completionHeaderCreditUsedSpace = new WLabel(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_completionHeaderCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_completionHeaderCreditUsedSpace.setPreferredSize(new Dimension(this.m_completionHeaderCreditUsedSpace.getPreferredSize().width + setUsedSpaceLabel.getPreferredSize().width, setUsedSpaceLabel.getPreferredSize().height));
        this.pcie_rx_buffer_panel.add((Component)this.m_completionHeaderCreditUsedSpace, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 0;
        ++myLayoutConstraints.gridy;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_completionDataCreditLabel = new WLabel(MVCConstants.getResourceString("PCIE_Completion_Data_Credit") + "   ");
        this.pcie_rx_buffer_panel.add((Component)this.m_completionDataCreditLabel, (Object)myLayoutConstraints);
        value = "16";
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_completionDataCreditValue = new WLabel(value);
        this.m_completionDataCreditValue.setText(value);
        this.m_completionDataCreditValue.setPreferredSize(setSizeLabel.getPreferredSize());
        this.pcie_rx_buffer_panel.add((Component)this.m_completionDataCreditValue, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 2;
        this.pcie_rx_buffer_panel.add((Component)new WLabel(""), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 0);
        this.m_completionDataCreditUsedSpace = new WLabel(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_completionDataCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   ");
        this.m_completionDataCreditUsedSpace.setPreferredSize(new Dimension(this.m_completionDataCreditUsedSpace.getPreferredSize().width + setUsedSpaceLabel.getPreferredSize().width, setUsedSpaceLabel.getPreferredSize().height));
        this.pcie_rx_buffer_panel.add((Component)this.m_completionDataCreditUsedSpace, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 0;
        ++myLayoutConstraints.gridy;
        myLayoutConstraints.gridwidth = 5;
        myLayoutConstraints.fill = 2;
        myLayoutConstraints.insets = new Insets(15, 5, 0, 10);
        this.m_Line_Label = new WLabel(" ");
        this.m_Line_Label.setBorder(BorderFactory.createEtchedBorder());
        this.m_Line_Label.setPreferredSize(new Dimension(100, 2));
        this.pcie_rx_buffer_panel.add((Component)this.m_Line_Label, (Object)myLayoutConstraints);
        this.pcie_bottom_panel = new WPanel();
        this.pcie_bottom_panel.setLayout((LayoutManager)new GridBagLayout());
        ++myLayoutConstraints.gridy;
        GridBagConstraints theLayoutConstraints = null;
        theLayoutConstraints = new GridBagConstraints();
        theLayoutConstraints.anchor = 17;
        theLayoutConstraints.gridwidth = 5;
        theLayoutConstraints.fill = 1;
        value = MVCConstants.getResourceString("PCIE_Total_Header_Credits") + "888888";
        theLayoutConstraints.insets = new Insets(5, 0, 5, 0);
        this.m_totalHeaderCreditsValue = new WLabel(value);
        this.m_totalHeaderCreditsValue.setText(value);
        this.m_totalHeaderCreditsValue.setPreferredSize(this.m_totalHeaderCreditsValue.getPreferredSize());
        this.pcie_bottom_panel.add((Component)this.m_totalHeaderCreditsValue, (Object)theLayoutConstraints);
        theLayoutConstraints.insets = new Insets(5, 0, 5, 0);
        this.m_totalRxBufferSpaceValue = new WLabel(MVCConstants.getResourceString("PCIE_Total_Rx_Buffer_Space") + "11000 Bytes ");
        this.m_totalRxBufferSpaceValue.setText(MVCConstants.getResourceString("PCIE_Total_Rx_Buffer_Space") + "11000 Bytes ");
        this.m_totalRxBufferSpaceValue.setPreferredSize(this.m_totalRxBufferSpaceValue.getPreferredSize());
        this.pcie_bottom_panel.add((Component)this.m_totalRxBufferSpaceValue, (Object)theLayoutConstraints);
        theLayoutConstraints.gridx = 0;
        this.pcie_rx_buffer_panel.add((Component)this.pcie_bottom_panel, (Object)theLayoutConstraints);
        this.add((Component)this.pcie_rx_buffer_panel);
        this.m_model.addModelListener((ModelListener)this);
        this.modelUpdated(this.m_model);
    }

    public void populateRxBufferData() {
        try {
            String str = this.m_model.getPrivate("p_pcie_posted_header_credit_vc" + this.m_num_vc).getValue().toString();
            this.m_postedHeaderCreditValue.setText("  " + this.m_model.getPrivate("p_pcie_posted_header_credit_vc" + this.m_num_vc).getValue().toString());
            str = this.m_model.getPrivate("p_pcie_posted_header_used_space_vc" + this.m_num_vc).getValue().toString();
            this.m_postedHeaderCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   " + MVCConstants.getNormalizedSize(Long.parseLong(this.m_model.getPrivate("p_pcie_posted_header_used_space_vc" + this.m_num_vc).getValue())));
            this.m_postedDataCreditValue.setText("  " + this.m_model.getPrivate("p_pcie_posted_data_credit_vc" + this.m_num_vc).getValue().toString());
            this.m_postedDataCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   " + MVCConstants.getNormalizedSize(Long.parseLong(this.m_model.getPrivate("p_pcie_posted_data_used_space_vc" + this.m_num_vc).getValue())));
            this.m_nonpostedHeaderCreditValue.setText("  " + this.m_model.getPrivate("p_pcie_nonposted_header_credit_vc" + this.m_num_vc).getValue().toString());
            this.m_nonpostedHeaderCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   " + MVCConstants.getNormalizedSize(Long.parseLong(this.m_model.getPrivate("p_pcie_nonposted_header_used_space_vc" + this.m_num_vc).getValue())));
            this.m_completionHeaderCreditValue.setText("  " + this.m_model.getPrivate("p_pcie_completion_header_credit_vc" + this.m_num_vc).getValue().toString());
            this.m_completionHeaderCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   " + MVCConstants.getNormalizedSize(Long.parseLong(this.m_model.getPrivate("p_pcie_completion_header_used_space_vc" + this.m_num_vc).getValue())));
            this.m_completionDataCreditValue.setText("  " + this.m_model.getPrivate("p_pcie_completion_data_credit_vc" + this.m_num_vc).getValue().toString());
            this.m_completionDataCreditUsedSpace.setText(MVCConstants.getResourceString("PCIE_Used_Space") + "   " + MVCConstants.getNormalizedSize(Long.parseLong(this.m_model.getPrivate("p_pcie_completion_data_used_space_vc" + this.m_num_vc).getValue())));
            str = this.m_model.getPrivate("p_pcie_total_header_credit_vc" + this.m_num_vc).getValue().toString();
            this.m_totalHeaderCreditsValue.setText(MVCConstants.getResourceString("PCIE_Total_Header_Credits") + this.m_model.getPrivate("p_pcie_total_header_credit_vc" + this.m_num_vc).getValue().toString());
            String szRxBufferSize = null;
            double dRemainder = Math.IEEEremainder(Double.parseDouble(this.m_model.getPrivate("p_pcie_rx_buffer_size_vc" + this.m_num_vc).getValue().toString()), Math.pow(2.0, 10.0));
            szRxBufferSize = dRemainder == 0.0 ? Math.round((float)((double)Long.parseLong(this.m_model.getPrivate("p_pcie_rx_buffer_size_vc" + this.m_num_vc).getValue().toString()) / Math.pow(2.0, 10.0))) + " KBytes" : MVCConstants.getNormalizedSize(Long.parseLong(this.m_model.getPrivate("p_pcie_rx_buffer_size_vc" + this.m_num_vc).getValue().toString()));
            this.m_totalRxBufferSpaceValue.setText(MVCConstants.getResourceString("PCIE_Total_Rx_Buffer_Space") + szRxBufferSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void modelUpdated(ModelBaseClass model) {
        try {
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

