/*
 * Decompiled with CFR 0.152.
 */
package altera.ipbu.pci_express;

import altera.ipbu.flowbase.SharedObjectsInterface;
import altera.ipbu.flowbase.controls.WLabel;
import altera.ipbu.flowbase.controls.WPanel;
import altera.ipbu.flowbase.exceptions.OutOfRangeException;
import altera.ipbu.flowbase.netlist.model.MVCModel;
import altera.ipbu.flowbase.netlist.model.ModelBaseClass;
import altera.ipbu.flowbase.netlist.model.ModelListener;
import altera.ipbu.flowbase.netlist.model.WriteablePropertyInterface;
import altera.ipbu.pci_express.MVCConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.MaskFormatter;

public class PCIRegisters
extends WPanel
implements FocusListener,
ModelListener,
ActionListener,
KeyListener {
    protected int curZone = 0;
    protected ModelBaseClass m_model = null;
    private WPanel pci_read_only_reg_panel;
    protected SharedObjectsInterface OBJBASE = null;
    protected Hashtable hstPCIAvalon;
    private String m_avalon_hardwired_address_map;
    private WLabel m_vendorIDLabel;
    private WLabel m_classCode;
    private WLabel m_deviceIDLabel;
    private WLabel m_revisionIDLabel;
    private WLabel m_subSysvendorIDLabel;
    private WLabel m_subSysIDLabel;
    private JFormattedTextField m_vendorIDText;
    private JFormattedTextField m_classCodeText;
    private JFormattedTextField m_deviceIDText;
    private JFormattedTextField m_revisionIDText;
    private JFormattedTextField m_subSysvendorIDText;
    private JFormattedTextField m_subSysIDText;

    public PCIRegisters(MVCModel model) {
        super((LayoutManager)new GridLayout(1, 0));
        this.m_model = model;
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() throws Exception {
        BoxLayout mainLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(mainLayout);
        this.pci_read_only_reg_panel = new WPanel();
        TitledBorder tb2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MVCConstants.getResourceString("PCI_Read_Only_Registers.Title"));
        tb2.setTitleFont(this.getFont());
        this.pci_read_only_reg_panel.setBorder((Border)tb2);
        this.pci_read_only_reg_panel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints myLayoutConstraints = null;
        myLayoutConstraints = new GridBagConstraints();
        myLayoutConstraints.gridx = 0;
        myLayoutConstraints.gridy = 0;
        myLayoutConstraints.weighty = 0.1;
        myLayoutConstraints.anchor = 17;
        this.pci_read_only_reg_panel.setBorder((Border)BorderFactory.createCompoundBorder(this.pci_read_only_reg_panel.getBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.m_deviceIDLabel = new WLabel(MVCConstants.getResourceString("PCI_Read_Only_Register_1"));
        this.pci_read_only_reg_panel.add((Component)this.m_deviceIDLabel, (Object)myLayoutConstraints);
        JTextField setSizeTextField = new JTextField("0xDDDDDDD");
        String value = this.m_model.getPrivate("p_pcie_device_id").getValue();
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        myLayoutConstraints.fill = 2;
        this.m_deviceIDText = new JFormattedTextField(this.createFormatter("0xHHHH"));
        this.m_deviceIDText.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_deviceIDText.setText(value);
        this.m_deviceIDText.addFocusListener(this);
        this.m_deviceIDText.addKeyListener(this);
        this.pci_read_only_reg_panel.add((Component)this.m_deviceIDText, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 2;
        this.pci_read_only_reg_panel.add((Component)new WLabel("                  "), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.fill = 0;
        this.m_classCode = new WLabel(MVCConstants.getResourceString("PCI_Read_Only_Register_2"));
        this.pci_read_only_reg_panel.add((Component)this.m_classCode, (Object)myLayoutConstraints);
        value = this.m_model.getPrivate("p_pcie_class_code").getValue();
        myLayoutConstraints.gridx = 4;
        myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        myLayoutConstraints.fill = 2;
        this.m_classCodeText = new JFormattedTextField(this.createFormatter("0xHHHHHH"));
        this.m_classCodeText.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_classCodeText.setText(value);
        this.m_classCodeText.addFocusListener(this);
        this.m_classCodeText.addKeyListener(this);
        this.pci_read_only_reg_panel.add((Component)this.m_classCodeText, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 5;
        this.pci_read_only_reg_panel.add((Component)new WLabel("                  "), (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 6;
        myLayoutConstraints.fill = 0;
        this.m_subSysIDLabel = new WLabel(MVCConstants.getResourceString("PCI_Read_Only_Register_3"));
        this.pci_read_only_reg_panel.add((Component)this.m_subSysIDLabel, (Object)myLayoutConstraints);
        value = this.m_model.getPrivate("p_pcie_subsystem_device_id").getValue();
        myLayoutConstraints.gridx = 7;
        myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        myLayoutConstraints.fill = 2;
        this.m_subSysIDText = new JFormattedTextField(this.createFormatter("0xHHHH"));
        this.m_subSysIDText.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_subSysIDText.setText(value);
        this.m_subSysIDText.addFocusListener(this);
        this.m_subSysIDText.addKeyListener(this);
        this.pci_read_only_reg_panel.add((Component)this.m_subSysIDText, (Object)myLayoutConstraints);
        ++myLayoutConstraints.gridy;
        myLayoutConstraints.insets = new Insets(0, 0, 0, 0);
        myLayoutConstraints.gridx = 0;
        myLayoutConstraints.fill = 0;
        this.m_vendorIDLabel = new WLabel(MVCConstants.getResourceString("PCI_Read_Only_Register_4"));
        this.pci_read_only_reg_panel.add((Component)this.m_vendorIDLabel, (Object)myLayoutConstraints);
        value = this.m_model.getPrivate("p_pcie_vendor_id").getValue();
        myLayoutConstraints.gridx = 1;
        myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        myLayoutConstraints.fill = 2;
        this.m_vendorIDText = new JFormattedTextField(this.createFormatter("0xHHHH"));
        this.m_vendorIDText.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_vendorIDText.setText(value);
        this.m_vendorIDText.addFocusListener(this);
        this.m_vendorIDText.addKeyListener(this);
        this.pci_read_only_reg_panel.add((Component)this.m_vendorIDText, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 3;
        myLayoutConstraints.fill = 0;
        this.m_revisionIDLabel = new WLabel(MVCConstants.getResourceString("PCI_Read_Only_Register_5"));
        this.pci_read_only_reg_panel.add((Component)this.m_revisionIDLabel, (Object)myLayoutConstraints);
        value = this.m_model.getPrivate("p_pcie_revision_id").getValue();
        myLayoutConstraints.gridx = 4;
        myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        myLayoutConstraints.fill = 2;
        this.m_revisionIDText = new JFormattedTextField(this.createFormatter("0xHH"));
        this.m_revisionIDText.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_revisionIDText.setText(value);
        this.m_revisionIDText.addFocusListener(this);
        this.m_revisionIDText.addKeyListener(this);
        this.pci_read_only_reg_panel.add((Component)this.m_revisionIDText, (Object)myLayoutConstraints);
        myLayoutConstraints.gridx = 6;
        myLayoutConstraints.fill = 0;
        this.m_subSysvendorIDLabel = new WLabel(MVCConstants.getResourceString("PCI_Read_Only_Register_6"));
        this.pci_read_only_reg_panel.add((Component)this.m_subSysvendorIDLabel, (Object)myLayoutConstraints);
        value = this.m_model.getPrivate("p_pcie_subsystem_vendor_id").getValue();
        myLayoutConstraints.gridx = 7;
        myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        myLayoutConstraints.fill = 2;
        this.m_subSysvendorIDText = new JFormattedTextField(this.createFormatter("0xHHHH"));
        this.m_subSysvendorIDText.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_subSysvendorIDText.setText(value);
        this.m_subSysvendorIDText.addFocusListener(this);
        this.m_subSysvendorIDText.addKeyListener(this);
        this.pci_read_only_reg_panel.add((Component)this.m_subSysvendorIDText, (Object)myLayoutConstraints);
        this.add((Component)this.pci_read_only_reg_panel);
        this.m_model.addModelListener((ModelListener)this);
        this.modelUpdated(this.m_model);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        JFormattedTextField textComp = (JFormattedTextField)keyEvent.getSource();
        int keyCode = keyEvent.getKeyCode();
        if (keyCode == 127) {
            try {
                if (textComp.getCaretPosition() > 2 && textComp.getCaretPosition() <= textComp.getText().length()) {
                    int icat = textComp.getCaretPosition();
                    textComp.setCaretPosition(icat - 1);
                }
            }
            catch (Exception e) {
                System.out.println(" exception in delete ");
                e.printStackTrace();
            }
        }
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public void modelUpdated(ModelBaseClass model) {
        try {
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void populateRegisters() {
        try {
            String value = this.m_model.getPrivate("p_pcie_device_id").getValue();
            this.m_deviceIDText.setText(value);
            value = this.m_model.getPrivate("p_pcie_class_code").getValue();
            this.m_classCodeText.setText(value);
            value = this.m_model.getPrivate("p_pcie_subsystem_device_id").getValue();
            this.m_subSysIDText.setText(value);
            value = this.m_model.getPrivate("p_pcie_vendor_id").getValue();
            this.m_vendorIDText.setText(value);
            value = this.m_model.getPrivate("p_pcie_revision_id").getValue();
            this.m_revisionIDText.setText(value);
            value = this.m_model.getPrivate("p_pcie_subsystem_vendor_id").getValue();
            this.m_subSysvendorIDText.setText(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object myWCheckBox = null;
        try {
            this.validate();
        }
        catch (Exception e) {
            myWCheckBox.setSelected(true);
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.m_vendorIDText.removeFocusListener(this);
        this.m_classCodeText.removeFocusListener(this);
        this.m_deviceIDText.removeFocusListener(this);
        this.m_revisionIDText.removeFocusListener(this);
        this.m_subSysvendorIDText.removeFocusListener(this);
        this.m_subSysIDText.removeFocusListener(this);
        this.m_vendorIDText.setText(this.setValue("p_pcie_vendor_id", this.m_vendorIDText.getText(), this.m_vendorIDLabel.getText()));
        this.m_classCodeText.setText(this.setValue("p_pcie_class_code", this.m_classCodeText.getText(), this.m_classCode.getText()));
        this.m_deviceIDText.setText(this.setValue("p_pcie_device_id", this.m_deviceIDText.getText(), this.m_deviceIDLabel.getText()));
        this.m_revisionIDText.setText(this.setValue("p_pcie_revision_id", this.m_revisionIDText.getText(), this.m_revisionIDLabel.getText()));
        this.m_subSysvendorIDText.setText(this.setValue("p_pcie_subsystem_vendor_id", this.m_subSysvendorIDText.getText(), this.m_subSysvendorIDLabel.getText()));
        this.m_subSysIDText.setText(this.setValue("p_pcie_subsystem_device_id", this.m_subSysIDText.getText(), this.m_subSysIDLabel.getText()));
        this.m_vendorIDText.addFocusListener(this);
        this.m_classCodeText.addFocusListener(this);
        this.m_deviceIDText.addFocusListener(this);
        this.m_revisionIDText.addFocusListener(this);
        this.m_subSysvendorIDText.addFocusListener(this);
        this.m_subSysIDText.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setValue(String name, String inputVal, String description) {
        String returnvalue;
        block8: {
            returnvalue = inputVal;
            String oldvalue = "";
            try {
                oldvalue = this.m_model.getPrivate(name).getValue();
                if (!inputVal.trim().equals("0x")) {
                    if (inputVal.toString().charAt(0) != '0' || inputVal.toString().charAt(1) != 'x' && inputVal.toString().charAt(1) != 'X') {
                        inputVal = "0x" + inputVal.toString();
                    }
                    inputVal = inputVal.replaceAll("\\s", "");
                    ((WriteablePropertyInterface)this.m_model.getPrivate(name)).setValue(inputVal.trim());
                    returnvalue = this.m_model.getPrivate(name).getValue();
                    break block8;
                }
                returnvalue = oldvalue;
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog((Component)((Object)this), iae.getMessage().replaceAll(name, description), "Error", 0);
                returnvalue = oldvalue;
            }
            catch (OutOfRangeException ore) {
                JOptionPane.showMessageDialog((Component)((Object)this), ore.getMessage().replaceAll(name, description), "Error", 0);
                returnvalue = oldvalue;
            }
            catch (Exception e) {
                e.printStackTrace();
                returnvalue = oldvalue;
            }
        }
        return returnvalue;
    }
}

