/*
 * Decompiled with CFR 0.152.
 */
package altera.ipbu.pci_express;

import altera.ipbu.flowbase.StaticValues;
import altera.ipbu.flowbase.exceptions.EntryNotFoundException;
import altera.ipbu.flowbase.netlist.NetlistIntegerPrivate;
import altera.ipbu.flowbase.netlist.NetlistPrivate;
import altera.ipbu.flowbase.netlist.NetlistPrivateInterface;
import altera.ipbu.flowbase.netlist.legacy.NetlistWriteablePrivateInterface;
import altera.ipbu.flowbase.netlist.model.MVCModel;
import altera.ipbu.flowbase.netlist.model.WriteablePropertyInterface;
import altera.ipbu.flowbase.plugin.BasePluginWorkerObject;
import altera.ipbu.pci_express.MVCConstants;
import com.altera.entityinterfaces.IModule;
import com.altera.entityinterfaces.message.IMessageLogger;
import com.altera.megacore.pcie.AlteraPCIECompiler;
import com.altera.megacore.pcie.model.IPCIECompilerCoreParameters;
import com.altera.megawizard2.extensions.IMegawizardGenerateQmegawizFiles;
import com.altera.sopcmodel.util.MessageLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PCIETestbenchPlugin
extends BasePluginWorkerObject {
    protected Vector m_perlLibs = new Vector();
    protected Process m_perlProcess = null;
    protected Process m_tclProcess = null;

    protected void plugin_start() throws Exception {
        NetlistPrivateInterface npi = this.PRIVATES().getPluginPrivateSection("simgen_enable");
        boolean bDoTestbench = true;
        String szHDLType = npi.getStringValue("language", this.FLOW_MANAGER().getHdlType());
        if (this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX") || this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX CVP")) {
            NetlistPrivate NoSimgenPrivate = new NetlistPrivate("enabled", "0");
            ((NetlistWriteablePrivateInterface)npi).addModifyPrivate(NoSimgenPrivate);
        }
        if (!szHDLType.equalsIgnoreCase("VHDL")) {
            szHDLType = "Verilog";
        }
        NetlistPrivateInterface npi_sim = this.PRIVATES().getPluginPrivateSection("simgen");
        NetlistPrivate filenamePrivate = new NetlistPrivate("filename", StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_core"), (String)szHDLType));
        ((NetlistWriteablePrivateInterface)npi_sim).addModifyPrivate(filenamePrivate);
        if (bDoTestbench) {
            String sPHYName;
            int exitVal;
            StreamGobbler outputGobbler;
            int nStratixGX;
            String Family;
            int nTl_Selection;
            int nMax_pload;
            int nLanes;
            File projectDir = new File(this.FLOW_MANAGER().getProjectDirectory());
            int n = this.MODEL().getPrivate("p_pcie_number_of_lanes").getValue().equals("x8") ? 8 : (this.MODEL().getPrivate("p_pcie_number_of_lanes").getValue().equals("x4") ? 4 : (nLanes = this.MODEL().getPrivate("p_pcie_number_of_lanes").getValue().equals("x2") ? 2 : 1));
            int n2 = this.MODEL().getPrivate("p_pcie_max_payload_size").getValue().equals("128 Bytes") ? 128 : (this.MODEL().getPrivate("p_pcie_max_payload_size").getValue().equals("256 Bytes") ? 256 : (this.MODEL().getPrivate("p_pcie_max_payload_size").getValue().equals("512 Bytes") ? 512 : (this.MODEL().getPrivate("p_pcie_max_payload_size").getValue().equals("1 KByte") ? 1024 : (nMax_pload = this.MODEL().getPrivate("p_pcie_max_payload_size").getValue().equals("2 KBytes") ? 2048 : 128))));
            int n3 = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_master").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_impl_cra_av_slave_port").getValue().equalsIgnoreCase("true") ? 1 : (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_master").getValue().equalsIgnoreCase("false") && this.MODEL().getPrivate("p_pci_impl_cra_av_slave_port").getValue().equalsIgnoreCase("false") ? 2 : (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_master").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_impl_cra_av_slave_port").getValue().equalsIgnoreCase("false") ? 3 : (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_master").getValue().equalsIgnoreCase("false") && this.MODEL().getPrivate("p_pci_impl_cra_av_slave_port").getValue().equalsIgnoreCase("true") ? 4 : (this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST.name()) ? 6 : (this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST128.name()) ? 7 : (this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.TLBypass.name()) ? 8 : (nTl_Selection = this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256.name()) ? 9 : 0)))))));
            int nTest_out_width = this.MODEL().getPrivate("p_pcie_test_out_width").getValue().equalsIgnoreCase("None") ? 0 : (this.MODEL().getPrivate("p_pcie_test_out_width").getValue().equalsIgnoreCase("9 bits") ? 9 : (this.MODEL().getPrivate("p_pcie_test_out_width").getValue().equalsIgnoreCase("64 bits") ? 64 : (this.MODEL().getPrivate("p_pcie_test_out_width").getValue().equalsIgnoreCase("128 bits") ? 128 : 512)));
            int cg_avalon_s_addr_width = 20;
            if (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") && this.MODEL().getPrivate("p_pci_master").getValue().equalsIgnoreCase("true")) {
                switch (Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_count").getValue())) {
                    case 1: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue());
                        break;
                    }
                    case 2: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 1;
                        break;
                    }
                    case 4: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 2;
                        break;
                    }
                    case 8: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 3;
                        break;
                    }
                    case 16: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 4;
                        break;
                    }
                    case 32: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 5;
                        break;
                    }
                    case 64: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 6;
                        break;
                    }
                    case 128: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 7;
                        break;
                    }
                    case 256: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 8;
                        break;
                    }
                    case 512: {
                        cg_avalon_s_addr_width = Integer.parseInt(this.MODEL().getPrivate("p_avalon_pane_size").getValue()) + 9;
                        break;
                    }
                    default: {
                        cg_avalon_s_addr_width = 0;
                    }
                }
            }
            try {
                Family = "\"" + this.PRIVATES().getPrivate("devicefamily").getValue() + "\"";
                Family = "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Stratix IV" : ("Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Arria II GZ" : ("Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Arria II" : ("Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Cyclone IV GX" : "Stratix IV")));
            }
            catch (Exception e) {
                Family = "Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Stratix IV" : ("Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Arria II GZ" : ("Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Arria II" : ("Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "Cyclone IV GX" : "Stratix IV")));
            }
            System.out.println("**** -> Set Device Family to " + Family);
            String[] cmdArray = nLanes == 1 ? new String[38] : new String[37];
            cmdArray[0] = this.FLOW_MANAGER().getPerlExe();
            cmdArray[1] = "-I";
            cmdArray[2] = this.FLOW_MANAGER().getCoreDirectory();
            cmdArray[3] = "-I";
            cmdArray[4] = this.FLOW_MANAGER().getQuartusRootDir() + File.separator + "sopc_builder" + File.separator + "bin";
            cmdArray[5] = "-I";
            cmdArray[6] = this.FLOW_MANAGER().getQuartusRootDir() + File.separator + "sopc_builder" + File.separator + "bin" + File.separator + "europa";
            cmdArray[7] = "-I";
            cmdArray[8] = this.FLOW_MANAGER().getQuartusRootDir() + File.separator + "sopc_builder" + File.separator + "bin" + File.separator + "perl_lib";
            cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_wrapper_pipen1b.pl";
            if (nLanes == 1) {
                cmdArray[18] = "--chk_io=" + ("0".equals(this.MODEL().getPrivate("p_pcie_chk_io").getValue()) ? "0" : "1");
                cmdArray[19] = "--lanerev=" + ("0".equals(this.MODEL().getPrivate("p_pcie_lanerev").getValue()) ? "0" : "1");
                cmdArray[20] = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") ? "--simple_dma=1" : "--simple_dma=" + this.MODEL().getPrivate("p_pcie_enable_simple_dma").getValue();
                cmdArray[21] = "--tags=" + this.MODEL().getPrivate("p_pcie_tag_supported").getValue();
                cmdArray[22] = "--max_pload=" + nMax_pload;
                cmdArray[23] = "--family=" + Family.replaceAll(" ", "_");
                cmdArray[24] = "--tl_selection=" + nTl_Selection;
                cmdArray[25] = "--CG_AVALON_S_ADDR_WIDTH=" + Integer.toString(cg_avalon_s_addr_width - 3);
                cmdArray[26] = Integer.parseInt(this.MODEL().getPrivate("p_pcie_completion_header_credit_vc0").getValue()) == 0 ? "--cplh_cred=4" : "--cplh_cred=" + this.MODEL().getPrivate("p_pcie_completion_header_credit_vc0").getValue();
                cmdArray[27] = Integer.parseInt(this.MODEL().getPrivate("p_pcie_completion_data_credit_vc0").getValue()) == 0 ? "--cpld_cred=16" : "--cpld_cred=" + this.MODEL().getPrivate("p_pcie_completion_data_credit_vc0").getValue();
                cmdArray[28] = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") ? "--common_clk_mode=" + (this.MODEL().getPrivate("p_pci_single_clock").getValue().toString().equalsIgnoreCase("true") ? "1" : "0") : "--common_clk_mode=0";
                cmdArray[29] = "--test_out_width=" + nTest_out_width;
                cmdArray[30] = "--hip=" + this.MODEL().getPrivate("p_pcie_enable_hip").getValue();
                cmdArray[31] = "--crc_fwd=" + this.MODEL().getPrivate("p_pcie_use_crc_forwarding").getValue();
                cmdArray[32] = "--rp=" + (this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Root Port") ? "1" : (this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Endpoint / Root Port") ? "2" : "0"));
                cmdArray[33] = "--gen2_rate=" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "1" : "0");
                cmdArray[34] = "--ko_cpl_spc_vc=" + this.getCompletionBufferSizeHIP();
                cmdArray[35] = "--enable_hip_dprio=" + ("Enable".equals(this.MODEL().getPrivate("p_enable_pcie_hip_dprio").getValue()) ? "1" : "0");
                cmdArray[36] = "--s4gxes=" + ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "1" : "0");
                cmdArray[37] = "--ast_lite=" + this.MODEL().getPrivate("p_pcie_avalon_mm_lite").getValue();
            } else {
                cmdArray[17] = "--chk_io=" + ("0".equals(this.MODEL().getPrivate("p_pcie_chk_io").getValue()) ? "0" : "1");
                cmdArray[18] = "--lanerev=" + ("0".equals(this.MODEL().getPrivate("p_pcie_lanerev").getValue()) ? "0" : "1");
                cmdArray[19] = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") ? "--simple_dma=1" : "--simple_dma=" + this.MODEL().getPrivate("p_pcie_enable_simple_dma").getValue();
                cmdArray[20] = "--tags=" + this.MODEL().getPrivate("p_pcie_tag_supported").getValue();
                cmdArray[21] = "--max_pload=" + nMax_pload;
                cmdArray[22] = "--family=" + Family.replaceAll(" ", "_");
                cmdArray[23] = "--tl_selection=" + nTl_Selection;
                cmdArray[24] = "--CG_AVALON_S_ADDR_WIDTH=" + Integer.toString(cg_avalon_s_addr_width - 3);
                cmdArray[25] = Integer.parseInt(this.MODEL().getPrivate("p_pcie_completion_header_credit_vc0").getValue()) == 0 ? "--cplh_cred=4" : "--cplh_cred=" + this.MODEL().getPrivate("p_pcie_completion_header_credit_vc0").getValue();
                cmdArray[26] = Integer.parseInt(this.MODEL().getPrivate("p_pcie_completion_data_credit_vc0").getValue()) == 0 ? "--cpld_cred=16" : "--cpld_cred=" + this.MODEL().getPrivate("p_pcie_completion_data_credit_vc0").getValue();
                cmdArray[27] = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") ? "--common_clk_mode=" + (this.MODEL().getPrivate("p_pci_single_clock").getValue().toString().equalsIgnoreCase("true") ? "1" : "0") : "--common_clk_mode=0";
                cmdArray[28] = "--test_out_width=" + nTest_out_width;
                cmdArray[29] = "--hip=" + this.MODEL().getPrivate("p_pcie_enable_hip").getValue();
                cmdArray[30] = "--crc_fwd=" + this.MODEL().getPrivate("p_pcie_use_crc_forwarding").getValue();
                cmdArray[31] = "--rp=" + (this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Root Port") ? "1" : (this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Endpoint / Root Port") ? "2" : "0"));
                cmdArray[32] = "--gen2_rate=" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "1" : "0");
                cmdArray[33] = "--ko_cpl_spc_vc=" + this.getCompletionBufferSizeHIP();
                cmdArray[34] = "--enable_hip_dprio=" + ("Enable".equals(this.MODEL().getPrivate("p_enable_pcie_hip_dprio").getValue()) ? "1" : "0");
                cmdArray[35] = "--s4gxes=" + ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "1" : "0");
                cmdArray[36] = "--ast_lite=" + this.MODEL().getPrivate("p_pcie_avalon_mm_lite").getValue();
            }
            int n4 = "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 9 : ("Stratix V GX CVP".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 8 : ("Stratix V GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 7 : (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1") ? 6 : ("Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 6 : ("Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 6 : ("HardCopy IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 6 : ("Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 6 : ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 6 : ("Stratix GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 0 : ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? 2 : ("8 bit DDR".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) || "8 bit DDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? 3 : ("8 bit SDR".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) || "8 bit SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? 4 : (nStratixGX = "8 bit DDR/SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? 5 : 1)))))))))))));
            String szRefClkCode = "100 MHz".equals(this.MODEL().getPrivate("p_pcie_txrx_clock").getValue()) ? "0" : ("125 MHz".equals(this.MODEL().getPrivate("p_pcie_txrx_clock").getValue()) ? "1" : ("156.25 MHz".equals(this.MODEL().getPrivate("p_pcie_txrx_clock").getValue()) ? "2" : "3"));
            int nTxClk = "8 bit DDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) || "8 bit SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) || "8 bit DDR/SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) || "16 bit SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? 1 : 0;
            int nVCs = ((NetlistIntegerPrivate)this.MODEL().getPrivate("p_pcie_virutal_channels")).getIntegerValue();
            int ntlp_clk_in = "125 MHz".equals(this.MODEL().getPrivate("p_pcie_internal_clock").getValue()) ? 0 : ("62.5 MHz".equals(this.MODEL().getPrivate("p_pcie_internal_clock").getValue()) ? 1 : 2);
            cmdArray[10] = "--phy=" + nStratixGX;
            cmdArray[11] = "--lanes=" + nLanes;
            cmdArray[12] = "--refclk=" + szRefClkCode;
            cmdArray[13] = "--vc=" + nVCs;
            cmdArray[14] = "--language=" + (szHDLType.equals("VHDL") ? "vhdl" : "verilog");
            cmdArray[15] = "--variation=" + this.FLOW_MANAGER().getNetlistTop();
            cmdArray[16] = "--txclk=" + nTxClk;
            if (nLanes == 1) {
                cmdArray[17] = "--tlp_clk_freq=" + ntlp_clk_in;
            }
            this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
            StreamGobbler errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler2 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler2.start();
            int exitVal2 = this.m_perlProcess.waitFor();
            System.out.println("ExitValue: " + exitVal2);
            if (exitVal2 != 0) {
                System.out.println("**** -> Exit Value = " + exitVal2);
                throw new Exception("e_var_example_pipen1b.pl Failed to execute !!!!");
            }
            cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_testbench.pl";
            this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
            errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
            outputGobbler2 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler2.start();
            exitVal2 = this.m_perlProcess.waitFor();
            System.out.println("ExitValue: " + exitVal2);
            if (exitVal2 != 0) {
                System.out.println("**** -> Exit Value = " + exitVal2);
                throw new Exception("e_var_testbench.pl Failed to execute !!!!");
            }
            if (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("false")) {
                cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_pipen1b.pl";
                String cmd = "";
                for (int i = 0; i < cmdArray.length; ++i) {
                    cmd = cmd + cmdArray[i];
                }
                System.out.println("**** -> cmd = " + cmd);
                this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
                StreamGobbler errorGobbler2 = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
                outputGobbler = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
                errorGobbler2.start();
                outputGobbler.start();
                exitVal = this.m_perlProcess.waitFor();
                System.out.println("ExitValue: " + exitVal);
                if (exitVal != 0) {
                    System.out.println("**** -> Exit Value = " + exitVal);
                    throw new Exception("europa_patch.pl Failed to execute !!!!");
                }
                cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_top.pl";
                cmdArray[10] = "--phy=" + nStratixGX;
                cmdArray[11] = "--lanes=" + nLanes;
                cmdArray[12] = "--refclk=" + szRefClkCode;
                cmdArray[13] = "--vc=" + nVCs;
                cmdArray[14] = "--language=" + (szHDLType.equals("VHDL") ? "vhdl" : "verilog");
                cmdArray[15] = "--variation=" + this.FLOW_MANAGER().getNetlistTop();
                cmdArray[16] = "--txclk=" + nTxClk;
                if (nLanes == 1) {
                    cmdArray[17] = "--tlp_clk_freq=" + ntlp_clk_in;
                }
                this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
                errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
                outputGobbler2 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
                errorGobbler.start();
                outputGobbler2.start();
                exitVal2 = this.m_perlProcess.waitFor();
                System.out.println("ExitValue: " + exitVal2);
                if (exitVal2 != 0) {
                    System.out.println("**** -> Exit Value = " + exitVal2);
                    throw new Exception("e_var_example_top.pl Failed to execute !!!!");
                }
                cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_icm.pl";
                cmdArray[10] = "--phy=" + nStratixGX;
                cmdArray[11] = "--lanes=" + nLanes;
                cmdArray[12] = "--refclk=" + szRefClkCode;
                cmdArray[13] = "--vc=" + nVCs;
                cmdArray[14] = "--language=" + (szHDLType.equals("VHDL") ? "vhdl" : "verilog");
                cmdArray[15] = "--variation=" + this.FLOW_MANAGER().getNetlistTop();
                cmdArray[16] = "--txclk=" + nTxClk;
                cmdArray[17] = "--family=" + Family.replaceAll(" ", "_");
                if (nLanes == 1) {
                    cmdArray[18] = "--tlp_clk_freq=" + ntlp_clk_in;
                }
                this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
                errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
                outputGobbler2 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
                errorGobbler.start();
                outputGobbler2.start();
                exitVal2 = this.m_perlProcess.waitFor();
                System.out.println("ExitValue: " + exitVal2);
                if (exitVal2 != 0) {
                    System.out.println("**** -> Exit Value = " + exitVal2);
                    throw new Exception("e_var_icm.pl Failed to execute !!!!");
                }
            }
            String sVendor = "TI XIO1100".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "TI" : ("Genesys Logic GL9714".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "GL" : ("NXP PX1011A".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "PX" : "ALTR"));
            String[] mycmdArray = nLanes == 1 ? new String[29] : new String[28];
            mycmdArray[0] = this.FLOW_MANAGER().getPerlExe();
            mycmdArray[1] = "-I";
            mycmdArray[2] = this.FLOW_MANAGER().getCoreDirectory();
            mycmdArray[3] = "-I";
            mycmdArray[4] = this.FLOW_MANAGER().getQuartusRootDir() + File.separator + "sopc_builder" + File.separator + "bin";
            mycmdArray[5] = "-I";
            mycmdArray[6] = this.FLOW_MANAGER().getQuartusRootDir() + File.separator + "sopc_builder" + File.separator + "bin" + File.separator + "europa";
            mycmdArray[7] = "-I";
            mycmdArray[8] = this.FLOW_MANAGER().getQuartusRootDir() + File.separator + "sopc_builder" + File.separator + "bin" + File.separator + "perl_lib";
            mycmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "iotiming_tcl.pl";
            mycmdArray[10] = "--phy=" + nStratixGX;
            mycmdArray[11] = "--lanes=" + nLanes;
            mycmdArray[12] = "--refclk=" + szRefClkCode;
            mycmdArray[13] = "--vc=" + nVCs;
            mycmdArray[14] = "--language=" + (szHDLType.equals("VHDL") ? "vhdl" : "verilog");
            mycmdArray[15] = "--variation=" + this.FLOW_MANAGER().getNetlistTop();
            mycmdArray[16] = "--txclk=" + nTxClk;
            if (nLanes == 1) {
                mycmdArray[18] = "--tlp_clk_freq=" + ntlp_clk_in;
                mycmdArray[17] = "--vendor=" + sVendor;
                mycmdArray[19] = "--chk_io=" + ("0".equals(this.MODEL().getPrivate("p_pcie_chk_io").getValue()) ? "0" : "1");
                mycmdArray[20] = "--lanerev=" + ("0".equals(this.MODEL().getPrivate("p_pcie_lanerev").getValue()) ? "0" : "1");
                mycmdArray[21] = "--tl_selection=" + nTl_Selection;
                mycmdArray[22] = "--family=" + Family.replaceAll(" ", "_");
                mycmdArray[23] = "--test_out_width=" + nTest_out_width;
                mycmdArray[24] = "--rmfifo=" + this.MODEL().getPrivate("p_pcie_rate_match_fifo").getValue();
                mycmdArray[25] = "--fast_recovery=" + this.MODEL().getPrivate("p_pcie_enable_fast_recovery").getValue();
                mycmdArray[26] = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") ? "--avalon_clock=" + (this.MODEL().getPrivate("p_pci_single_clock").getValue().toString().equalsIgnoreCase("true") ? "none" : this.MODEL().getPrivate("clockSource").getValue().toString()) : "--avalon_clock=none";
                mycmdArray[27] = "--hip=" + this.MODEL().getPrivate("p_pcie_enable_hip").getValue();
                mycmdArray[28] = "--gen2_rate=" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "1" : "0");
            } else {
                mycmdArray[17] = "--vendor=" + sVendor;
                mycmdArray[18] = "--chk_io=" + ("0".equals(this.MODEL().getPrivate("p_pcie_chk_io").getValue()) ? "0" : "1");
                mycmdArray[19] = "--lanerev=" + ("0".equals(this.MODEL().getPrivate("p_pcie_lanerev").getValue()) ? "0" : "1");
                mycmdArray[20] = "--tl_selection=" + nTl_Selection;
                mycmdArray[21] = "--family=" + Family.replaceAll(" ", "_");
                mycmdArray[22] = "--test_out_width=" + nTest_out_width;
                mycmdArray[23] = "--rmfifo=" + this.MODEL().getPrivate("p_pcie_rate_match_fifo").getValue();
                mycmdArray[24] = "--fast_recovery=" + this.MODEL().getPrivate("p_pcie_enable_fast_recovery").getValue();
                mycmdArray[25] = this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("true") ? "--avalon_clock=" + (this.MODEL().getPrivate("p_pci_single_clock").getValue().toString().equalsIgnoreCase("true") ? "none" : this.MODEL().getPrivate("clockSource").getValue().toString()) : "--avalon_clock=none";
                mycmdArray[26] = "--hip=" + this.MODEL().getPrivate("p_pcie_enable_hip").getValue();
                mycmdArray[27] = "--gen2_rate=" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "1" : "0");
            }
            this.m_perlProcess = Runtime.getRuntime().exec(mycmdArray, null, projectDir);
            StreamGobbler errorGobbler3 = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
            outputGobbler = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
            errorGobbler3.start();
            outputGobbler.start();
            exitVal = this.m_perlProcess.waitFor();
            System.out.println("ExitValue: " + exitVal);
            if (exitVal != 0) {
                System.out.println("**** -> Exit Value = " + exitVal);
                throw new Exception("iotiming_tcl.pl Failed to execute !!!!");
            }
            String mycmd = "";
            for (int i = 0; i < mycmdArray.length; ++i) {
                mycmd = mycmd + mycmdArray[i];
            }
            System.out.println("**** -> mycmd = " + mycmd);
            String[] tclcmdArray = new String[16];
            String tcl_os = System.getProperty("os.name").toLowerCase();
            if (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("false")) {
                tclcmdArray[0] = this.FLOW_MANAGER().getQuartusBinDir() + File.separator + "quartus_sh";
                tclcmdArray[1] = "-t";
                tclcmdArray[2] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "pcie_setup_proj.tcl";
                tclcmdArray[3] = Family;
                tclcmdArray[4] = this.FLOW_MANAGER().getNetlistTop();
                String string = tclcmdArray[5] = szHDLType.equals("VHDL") ? "vhdl" : "verilog";
                tclcmdArray[6] = nLanes == 8 ? "8" : (nLanes == 4 ? "4" : "1");
                tclcmdArray[7] = "125 MHz".equals(this.MODEL().getPrivate("p_pcie_internal_clock").getValue()) ? "125" : "62.5";
                tclcmdArray[8] = this.FLOW_MANAGER().getCoreDirectory() + "/../../lib";
                tclcmdArray[9] = "1";
                tclcmdArray[10] = this.MODEL().getPrivate("p_pcie_rate_match_fifo").getValue();
                tclcmdArray[11] = "Gen2 (5.0 Gbps)".equals(this.MODEL().getPrivate("p_pcie_rate").getValue()) ? "1" : "0";
                tclcmdArray[12] = this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Root Port") || this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Endpoint / Root Port") ? "1" : "0";
                tclcmdArray[13] = this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST.name()) ? "1" : "0";
                tclcmdArray[14] = this.FLOW_MANAGER().getQuartusRootDir();
                tclcmdArray[15] = this.MODEL().getPrivate("p_pcie_enable_hip").getValue();
                String tclcmd = "";
                for (int kk = 0; kk < tclcmdArray.length; ++kk) {
                    tclcmd = tclcmd + tclcmdArray[kk] + " ";
                }
                System.out.println("**** -> tclcmd = " + tclcmd);
                this.m_tclProcess = Runtime.getRuntime().exec(tclcmdArray, null, projectDir);
                StreamGobbler errorGobbler4 = new StreamGobbler(this.m_tclProcess.getErrorStream(), "ERROR");
                StreamGobbler outputGobbler3 = new StreamGobbler(this.m_tclProcess.getInputStream(), "OUTPUT");
                errorGobbler4.start();
                outputGobbler3.start();
                int exitVal3 = this.m_tclProcess.waitFor();
                System.out.println("ExitValue: " + exitVal3);
                if (exitVal3 != 0) {
                    System.out.println("**** -> Exit Value = " + exitVal3);
                    throw new Exception("pcie_setup_proj.tcl Failed to execute !!!!");
                }
            }
            boolean altgx_already_generated = false;
            try {
                altgx_already_generated = this.MODEL().getPrivate("altgx_generated").getValue().equals("1");
            }
            catch (EntryNotFoundException e) {
                // empty catch block
            }
            if (((MVCModel)this.MODEL()).getIModule() != null && !altgx_already_generated) {
                IModule m_module = ((MVCModel)this.MODEL()).getIModule();
                MessageLogger logger = MessageLogger.create((boolean)this.FLOW_MANAGER().isDebugMode());
                if (m_module.hasExtension(IMegawizardGenerateQmegawizFiles.class)) {
                    boolean newVariant = false;
                    String outputDirectory = null;
                    String outputLanguage = null;
                    outputDirectory = projectDir.getAbsolutePath();
                    m_module.setName(this.FLOW_MANAGER().getNetlistTop());
                    outputLanguage = szHDLType.equals("VHDL") ? "vhdl" : "verilog";
                    IMegawizardGenerateQmegawizFiles qmegawizFilesExtension = (IMegawizardGenerateQmegawizFiles)m_module.getExtension(IMegawizardGenerateQmegawizFiles.class);
                    if (qmegawizFilesExtension != null && !this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX") && !this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX CVP")) {
                        qmegawizFilesExtension.executeCommand(qmegawizFilesExtension.getCommandtoRun() + "-silent ", ((AlteraPCIECompiler)qmegawizFilesExtension).getIPSerdesFile(new File(this.OBJBASE().getFlowManager().getLibDirectory())), new File(outputDirectory), outputLanguage, (IMessageLogger)logger, qmegawizFilesExtension.getKeyParameters(), newVariant, this.FLOW_MANAGER().isDebugMode(), null);
                    }
                }
            }
            try {
                ((WriteablePropertyInterface)this.MODEL().getPrivate("altgx_generated")).setValue("0");
            }
            catch (EntryNotFoundException e) {
                // empty catch block
            }
            File refTopFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_top"), (String)szHDLType));
            File testbenchDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/common/testbench");
            File realTestbenchDir = new File(this.FLOW_MANAGER().getOutputDirectory(), this.FLOW_MANAGER().getNetlistTop() + "/common/testbench");
            File icmDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/common/incremental_compile_module");
            File realicmDir = new File(this.FLOW_MANAGER().getOutputDirectory(), this.FLOW_MANAGER().getNetlistTop() + "/common/incremental_compile_module");
            File refQsf = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_top.qsf");
            File refSdc = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_top.sdc");
            File refQpf = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_top.qpf");
            File varSdc = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + ".sdc");
            this.copy(refSdc, varSdc);
            File refTbFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_testbench"), (String)szHDLType));
            if (!testbenchDir.exists()) {
                testbenchDir.mkdirs();
            }
            if (!icmDir.exists() & this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("false")) {
                icmDir.mkdirs();
            }
            JarFile jarFile = this.APP_RESOURCE().getJarFileObject(this.FLOW_MANAGER().getCoreDirectory() + "/" + this.FLOW_MANAGER().getCoreName() + ".jar");
            String szTBPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/common/testbench/";
            String szICMPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/common/incremental_compile_module/";
            if (jarFile != null) {
                Enumeration<JarEntry> enumer = jarFile.entries();
                while (enumer.hasMoreElements()) {
                    String szFileName;
                    JarEntry jarEntry = enumer.nextElement();
                    if (jarEntry.getName().startsWith(szTBPrefix)) {
                        szFileName = StaticValues.getFullFileName((String)jarEntry.getName());
                        if (szFileName == null || szFileName.trim().length() <= 0) continue;
                        File file = new File(realTestbenchDir, szFileName);
                        StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(testbenchDir.getAbsolutePath() + "/" + szFileName));
                        continue;
                    }
                    if (!(this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("false") & jarEntry.getName().startsWith(szICMPrefix)) || (szFileName = StaticValues.getFullFileName((String)jarEntry.getName())) == null || szFileName.trim().length() <= 0) continue;
                    File file2 = new File(realicmDir, szFileName);
                    StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(icmDir.getAbsolutePath() + "/" + szFileName));
                }
            }
            File europaVariationFile = new File(projectDir, StaticValues.getDesignFileName((String)this.FLOW_MANAGER().getNetlistTop(), (String)szHDLType));
            europaVariationFile.renameTo(new File(projectDir, StaticValues.getDesignFileName((String)"pcie_phy_support", (String)szHDLType)));
            if (this.MODEL().getPrivate("p_pcie_underSOPCBuilder").getValue().equalsIgnoreCase("false")) {
                File simpleDMADir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/simple_dma");
                File simpleDMATBDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/simple_dma/testbench");
                if (this.MODEL().getPrivate("p_pcie_enable_simple_dma").getValue().equalsIgnoreCase("1")) {
                    if (!simpleDMADir.exists()) {
                        simpleDMADir.mkdirs();
                        simpleDMATBDir.mkdirs();
                    }
                    File myexampleTopFile = new File(simpleDMADir, refTopFile.getName());
                    this.copy(refTopFile, myexampleTopFile);
                    File myQsfFile = new File(simpleDMADir, refQsf.getName());
                    this.copy(refQsf, myQsfFile);
                    File myQpfFile = new File(simpleDMADir, refQpf.getName());
                    this.copy(refQpf, myQpfFile);
                    File myTbFile = new File(simpleDMATBDir, refTbFile.getName());
                    this.copy(refTbFile, myTbFile);
                    File europapipen1bFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_pipen1b"), (String)szHDLType));
                    File myexamplepipen1bFile = new File(simpleDMADir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_pipen1b"), (String)szHDLType));
                    this.copy(europapipen1bFile, myexamplepipen1bFile);
                    europapipen1bFile.delete();
                }
                File icmFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_icm"), (String)szHDLType));
                File myicmFile = new File(icmDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_icm"), (String)szHDLType));
                this.copy(icmFile, myicmFile);
                if (this.MODEL().getPrivate("p_pcie_enable_simple_dma").getValue().equalsIgnoreCase("1")) {
                    File simlistFile;
                    File realSimpleDMATestbenchDir;
                    File srcFile;
                    jarFile = this.APP_RESOURCE().getJarFileObject(this.FLOW_MANAGER().getCoreDirectory() + "/" + this.FLOW_MANAGER().getCoreName() + ".jar");
                    String szPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/example_simple_dma";
                    szTBPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/example_simple_dma/testbench";
                    if (jarFile != null) {
                        Enumeration<JarEntry> enumer = jarFile.entries();
                        while (enumer.hasMoreElements()) {
                            String szFileName;
                            JarEntry jarEntry = enumer.nextElement();
                            if (jarEntry.getName().startsWith(szTBPrefix)) {
                                szFileName = StaticValues.getFullFileName((String)jarEntry.getName());
                                if (szFileName == null || szFileName.trim().length() <= 0) continue;
                                StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(simpleDMATBDir.getAbsolutePath() + "/" + szFileName));
                                continue;
                            }
                            if (!jarEntry.getName().startsWith(szPrefix) || (szFileName = StaticValues.getFullFileName((String)jarEntry.getName())) == null || szFileName.trim().length() <= 0) continue;
                            StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(simpleDMADir.getAbsolutePath() + "/" + szFileName));
                        }
                    }
                    if ((srcFile = new File(realSimpleDMATestbenchDir = new File(this.FLOW_MANAGER().getOutputDirectory(), this.FLOW_MANAGER().getNetlistTop() + "/example_simple_dma/testbench"), szHDLType.equals("VHDL") ? "altpcietb_bfm_driver.vhd" : "altpcietb_bfm_driver.v")).exists()) {
                        File archiveDir = new File(realSimpleDMATestbenchDir, "archive");
                        this.PerformBackup(srcFile, archiveDir, szHDLType);
                    }
                    if ((simlistFile = new File(simpleDMATBDir, "sim_filelist")).exists()) {
                        FileInputStream fileIn = new FileInputStream(simlistFile);
                        byte[] data = new byte[(int)simlistFile.length()];
                        fileIn.read(data);
                        fileIn.close();
                        String szWrapperPipen1bFile = "../../../" + StaticValues.getDesignFileName((String)this.FLOW_MANAGER().getNetlistTop(), (String)szHDLType) + StaticValues.NL;
                        String szSimgenFile = "";
                        if (this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX") || this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX CVP")) {
                            if (szHDLType.equalsIgnoreCase("VHDL")) {
                                szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + "_core.vhd" + StaticValues.NL;
                                File simlistFileVerilogCosim = new File(simpleDMATBDir, "sim_filelist_verilog_cosim");
                                String szSimgenFileVerilog = "";
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_pipe_native.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_emsip_adapter.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/altera_xcvr_functions.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_native.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pma.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pcs.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pcs_ch.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_rx_pma.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_tx_pma.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_tx_pma_ch.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_avmm.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_pcs_aggregate_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_rx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_tx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen1_2_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen3_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_aux_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_cdr_refclk_select_mux_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_int_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_deser_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_cgb_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_ser_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_refclk_divider_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/altpcie_hip_256_pipen1b.v" + StaticValues.NL;
                                FileOutputStream fileOutCosim = new FileOutputStream(simlistFileVerilogCosim);
                                fileOutCosim.write(szSimgenFileVerilog.getBytes());
                                fileOutCosim.close();
                            } else {
                                szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + "_core.v" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_pipe_native.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_emsip_adapter.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/altera_xcvr_functions.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_native.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pma.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pcs.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pcs_ch.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_rx_pma.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_tx_pma.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_tx_pma_ch.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_avmm.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_pcs_aggregate_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_rx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_tx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen1_2_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen3_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_aux_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_cdr_refclk_select_mux_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_int_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_deser_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_cgb_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_ser_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_refclk_divider_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/altpcie_hip_256_pipen1b.v" + StaticValues.NL;
                            }
                        } else {
                            szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + (szHDLType.equalsIgnoreCase("VHDL") ? "_core.vho" : "_core.vo") + StaticValues.NL;
                        }
                        String szserdesFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + (szHDLType.equalsIgnoreCase("VHDL") ? ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "_serdes.vho" : "_serdes.vhd") : ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "_serdes.vo" : "_serdes.v")) + StaticValues.NL;
                        String szrootportFile = "../../common/testbench/altpcietb_bfm_rpvar_64b_x8_" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "gen2_" : "gen1_") + (szHDLType.equalsIgnoreCase("VHDL") ? "pipen1b.vho" : "pipen1b.vo") + StaticValues.NL;
                        String szRefTopFile = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_top"), (String)szHDLType) + StaticValues.NL;
                        String var_testbenchFile = "./" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_testbench"), (String)szHDLType) + StaticValues.NL;
                        String var_example_pipen1b = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_pipen1b"), (String)szHDLType) + StaticValues.NL;
                        String var_plus = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType) + StaticValues.NL;
                        String var_rs_hip = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType) + StaticValues.NL;
                        String var_icm = "../../common/incremental_compile_module/" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_icm"), (String)szHDLType) + StaticValues.NL;
                        FileOutputStream fileOut = new FileOutputStream(simlistFile);
                        fileOut.write(szRefTopFile.getBytes());
                        fileOut.write(szWrapperPipen1bFile.getBytes());
                        fileOut.write(szSimgenFile.getBytes());
                        if ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "HardCopy IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                            fileOut.write(szserdesFile.getBytes());
                        }
                        fileOut.write(szrootportFile.getBytes());
                        fileOut.write(var_testbenchFile.getBytes());
                        fileOut.write(var_example_pipen1b.getBytes());
                        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1") & this.MODEL().getPrivate("p_pcie_enable_simple_dma").getValue().equalsIgnoreCase("0")) {
                            fileOut.write(var_plus.getBytes());
                            fileOut.write(var_rs_hip.getBytes());
                        }
                        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("0")) {
                            fileOut.write(var_icm.getBytes());
                        }
                        fileOut.write(data);
                        fileOut.close();
                    }
                    File dst = File.createTempFile("tb_result", "txt");
                    if (simlistFile.exists()) {
                        this.updateFile(simlistFile, dst, 1);
                    }
                    this.updateFile(new File(simpleDMATBDir, "runtb.do"), dst, 1);
                    this.setFilePermission(new File(simpleDMATBDir, "runtb.sh"));
                    this.setFilePermission(new File(simpleDMATBDir, "runtb_vcs.sh"));
                    this.setFilePermission(new File(simpleDMATBDir, "runtb_nc.sh"));
                }
                if (this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Root Port") || this.MODEL().getPrivate("p_pcie_port_type").getValue().equals("Endpoint / Root Port")) {
                    this.DoRootPortPrecessing(cmdArray, nLanes, nMax_pload, projectDir, nStratixGX, nTxClk, nVCs, szRefClkCode, ntlp_clk_in, tclcmdArray);
                    refTopFile.delete();
                    icmFile.delete();
                    refQsf.delete();
                    refQpf.delete();
                } else {
                    File simlistFile;
                    cmdArray[9] = this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("0") ? this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_pipen1b.pl" : this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_pipen1b_ez.pl";
                    if (nLanes == 1) {
                        cmdArray[20] = "--simple_dma=0";
                        cmdArray[21] = "--tags=" + this.MODEL().getPrivate("p_pcie_tag_supported").getValue();
                        cmdArray[22] = "--max_pload=" + nMax_pload;
                    } else {
                        cmdArray[19] = "--simple_dma=0";
                        cmdArray[20] = "--tags=" + this.MODEL().getPrivate("p_pcie_tag_supported").getValue();
                        cmdArray[21] = "--max_pload=" + nMax_pload;
                    }
                    this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
                    StreamGobbler errorGobbler5 = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
                    StreamGobbler outputGobbler4 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
                    errorGobbler5.start();
                    outputGobbler4.start();
                    int exitVal4 = this.m_perlProcess.waitFor();
                    System.out.println("ExitValue: " + exitVal4);
                    if (exitVal4 != 0) {
                        System.out.println("**** -> Exit Value = " + exitVal4);
                        throw new Exception("e_var_example_pipen1b.pl Failed to execute !!!!");
                    }
                    cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_top.pl";
                    cmdArray[10] = "--phy=" + nStratixGX;
                    cmdArray[11] = "--lanes=" + nLanes;
                    cmdArray[12] = "--refclk=" + szRefClkCode;
                    cmdArray[13] = "--vc=" + nVCs;
                    cmdArray[14] = "--language=" + (szHDLType.equals("VHDL") ? "vhdl" : "verilog");
                    cmdArray[15] = "--variation=" + this.FLOW_MANAGER().getNetlistTop();
                    cmdArray[16] = "--txclk=" + nTxClk;
                    if (nLanes == 1) {
                        cmdArray[17] = "--tlp_clk_freq=" + ntlp_clk_in;
                    }
                    if (nLanes == 1) {
                        cmdArray[20] = "--simple_dma=0";
                    } else {
                        cmdArray[19] = "--simple_dma=0";
                    }
                    this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
                    errorGobbler5 = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
                    outputGobbler4 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
                    errorGobbler5.start();
                    outputGobbler4.start();
                    exitVal4 = this.m_perlProcess.waitFor();
                    System.out.println("ExitValue: " + exitVal4);
                    if (exitVal4 != 0) {
                        System.out.println("**** -> Exit Value = " + exitVal4);
                        throw new Exception("e_var_example_top.pl Failed to execute !!!!");
                    }
                    cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_testbench.pl";
                    this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
                    errorGobbler5 = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
                    outputGobbler4 = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
                    errorGobbler5.start();
                    outputGobbler4.start();
                    exitVal4 = this.m_perlProcess.waitFor();
                    System.out.println("ExitValue: " + exitVal4);
                    if (exitVal4 != 0) {
                        System.out.println("**** -> Exit Value = " + exitVal4);
                        throw new Exception("e_var_testbench.pl Failed to execute !!!!");
                    }
                    tclcmdArray[9] = "0";
                    this.m_tclProcess = Runtime.getRuntime().exec(tclcmdArray, null, projectDir);
                    errorGobbler5 = new StreamGobbler(this.m_tclProcess.getErrorStream(), "ERROR");
                    outputGobbler4 = new StreamGobbler(this.m_tclProcess.getInputStream(), "OUTPUT");
                    errorGobbler5.start();
                    outputGobbler4.start();
                    exitVal4 = this.m_tclProcess.waitFor();
                    System.out.println("ExitValue: " + exitVal4);
                    if (exitVal4 != 0) {
                        System.out.println("**** -> Exit Value = " + exitVal4);
                        throw new Exception("pcie_setup_proj.tcl Failed to execute !!!!");
                    }
                    File chainingDMADir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/chaining_dma");
                    File chainingDMATBDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/chaining_dma/testbench");
                    if (!chainingDMADir.exists()) {
                        chainingDMADir.mkdirs();
                        chainingDMATBDir.mkdirs();
                    }
                    File refChTopFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top"), (String)szHDLType));
                    File refChQsf = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.qsf");
                    File refChSdc = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.sdc");
                    File refChQpf = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.qpf");
                    File refChTbFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_chaining_testbench"), (String)szHDLType));
                    File myexampleTopFile1 = new File(chainingDMADir, refChTopFile.getName());
                    this.copy(refChTopFile, myexampleTopFile1);
                    File myChQsfFile = new File(chainingDMADir, refChQsf.getName());
                    this.copy(refChQsf, myChQsfFile);
                    File refChSdcExampleSrc = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example.sdc");
                    if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                        File refChSdcExampleDest = new File(chainingDMADir, refChSdcExampleSrc.getName());
                        this.copy(refChSdcExampleSrc, refChSdcExampleDest);
                    }
                    File myChQpfFile = new File(chainingDMADir, refChQpf.getName());
                    this.copy(refChQpf, myChQpfFile);
                    File myChTbFile = new File(chainingDMATBDir, refChTbFile.getName());
                    this.copy(refChTbFile, myChTbFile);
                    File europaChpipen1bFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_pipen1b"), (String)szHDLType));
                    File myexampleChpipen1bFile = new File(chainingDMADir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_pipen1b"), (String)szHDLType));
                    this.copy(europaChpipen1bFile, myexampleChpipen1bFile);
                    File europaChpipen1bPlusFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType));
                    if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                        File myexampleChpipen1bPlusFile = new File(chainingDMADir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType));
                        this.copy(europaChpipen1bPlusFile, myexampleChpipen1bPlusFile);
                    }
                    File europaChpipen1bRsHipFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType));
                    if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                        File myexampleChpipen1bRsHipFile = new File(chainingDMADir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType));
                        this.copy(europaChpipen1bRsHipFile, myexampleChpipen1bRsHipFile);
                    }
                    jarFile = this.APP_RESOURCE().getJarFileObject(this.FLOW_MANAGER().getCoreDirectory() + "/" + this.FLOW_MANAGER().getCoreName() + ".jar");
                    String szPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/example_chaining_dma";
                    szTBPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/example_chaining_dma/testbench";
                    if (jarFile != null) {
                        Enumeration<JarEntry> enumer = jarFile.entries();
                        while (enumer.hasMoreElements()) {
                            String szFileName;
                            JarEntry jarEntry = enumer.nextElement();
                            if (jarEntry.getName().startsWith(szTBPrefix)) {
                                boolean nAST256;
                                szFileName = StaticValues.getFullFileName((String)jarEntry.getName());
                                if (szFileName == null || szFileName.trim().length() <= 0) continue;
                                boolean bl = nAST256 = this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256.name());
                                if (szFileName.indexOf(".") != -1 && szFileName.substring(0, szFileName.indexOf(".")).equalsIgnoreCase("altpcietb_bfm_driver_chaining") && !nAST256 || szFileName.indexOf(".") != -1 && szFileName.substring(0, szFileName.indexOf(".")).equalsIgnoreCase("altpcietb_bfm_driver_downstream") && nAST256) {
                                    File realchainingDMATestbenchDir = new File(this.FLOW_MANAGER().getOutputDirectory(), this.FLOW_MANAGER().getNetlistTop() + "_examples/chaining_dma/testbench");
                                    File srcFile = new File(realchainingDMATestbenchDir, szHDLType.equals("VHDL") && nAST256 ? "altpcietb_bfm_driver_downstream.vhd" : (nAST256 ? "altpcietb_bfm_driver_downstream.v" : (szHDLType.equals("VHDL") ? "altpcietb_bfm_driver_chaining.vhd" : "altpcietb_bfm_driver_chaining.v")));
                                    if (srcFile.exists()) continue;
                                    StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(chainingDMATBDir.getAbsolutePath() + "/" + szFileName));
                                    continue;
                                }
                                StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(chainingDMATBDir.getAbsolutePath() + "/" + szFileName));
                                continue;
                            }
                            if (!jarEntry.getName().startsWith(szPrefix) || (szFileName = StaticValues.getFullFileName((String)jarEntry.getName())) == null || szFileName.trim().length() <= 0) continue;
                            StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(chainingDMADir.getAbsolutePath() + "/" + szFileName));
                        }
                    }
                    if ((simlistFile = new File(chainingDMATBDir, "sim_filelist")).exists()) {
                        FileInputStream fileIn = new FileInputStream(simlistFile);
                        byte[] data = new byte[(int)simlistFile.length()];
                        fileIn.read(data);
                        fileIn.close();
                        String szWrapperPipen1bFile = "../../../" + StaticValues.getDesignFileName((String)this.FLOW_MANAGER().getNetlistTop(), (String)szHDLType) + StaticValues.NL;
                        String szSimgenFile = "";
                        if (this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX") || this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX CVP")) {
                            if (szHDLType.equalsIgnoreCase("VHDL")) {
                                szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + "_core.vhd" + StaticValues.NL;
                                File simlistFileVerilogCosim = new File(chainingDMATBDir, "sim_filelist_verilog_cosim");
                                String szSimgenFileVerilog = "";
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_pipe_native.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_emsip_adapter.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/altera_xcvr_functions.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_native.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pma.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pcs.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pcs_ch.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_rx_pma.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_tx_pma.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_tx_pma_ch.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_avmm.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_pcs_aggregate_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_rx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_tx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen1_2_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen3_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_aux_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_cdr_refclk_select_mux_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_int_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_deser_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_cgb_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_ser_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_refclk_divider_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/altpcie_hip_256_pipen1b.v" + StaticValues.NL;
                                FileOutputStream fileOutCosim = new FileOutputStream(simlistFileVerilogCosim);
                                fileOutCosim.write(szSimgenFileVerilog.getBytes());
                                fileOutCosim.close();
                            } else {
                                szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + "_core.v" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_pipe_native.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_emsip_adapter.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/altera_xcvr_functions.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_native.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pma.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pcs.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pcs_ch.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_rx_pma.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_tx_pma.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_tx_pma_ch.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_avmm.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_pcs_aggregate_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_rx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_tx_pcs_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_rx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_tx_if_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen1_2_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen3_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_aux_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_cdr_refclk_select_mux_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_int_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_deser_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_buf_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_cgb_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_ser_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_refclk_divider_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                                szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/altpcie_hip_256_pipen1b.v" + StaticValues.NL;
                            }
                        } else {
                            szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + (szHDLType.equalsIgnoreCase("VHDL") ? "_core.vho" : "_core.vo") + StaticValues.NL;
                        }
                        if (szHDLType.equalsIgnoreCase("Verilog")) {
                            szSimgenFile = this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256.name()) ? szSimgenFile + "./altpcietb_bfm_driver_downstream.v" + StaticValues.NL : szSimgenFile + "./altpcietb_bfm_driver_chaining.v" + StaticValues.NL;
                        }
                        String szserdesFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + (szHDLType.equalsIgnoreCase("VHDL") ? ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "_serdes.vho" : "_serdes.vhd") : ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "_serdes.vo" : "_serdes.v")) + StaticValues.NL;
                        String szrootportFile = "../../common/testbench/altpcietb_bfm_rpvar_64b_x8_" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "gen2_" : "gen1_") + (szHDLType.equalsIgnoreCase("VHDL") ? "pipen1b.vho" : "pipen1b.vo") + StaticValues.NL;
                        String szRefTopFile = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top"), (String)szHDLType) + StaticValues.NL;
                        String var_testbenchFile = "./" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_chaining_testbench"), (String)szHDLType) + StaticValues.NL;
                        String var_example_pipen1b = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_pipen1b"), (String)szHDLType) + StaticValues.NL;
                        String var_plus = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType) + StaticValues.NL;
                        String var_rs_hip = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType) + StaticValues.NL;
                        String var_icm = "../../common/incremental_compile_module/" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_icm"), (String)szHDLType) + StaticValues.NL;
                        FileOutputStream fileOut = new FileOutputStream(simlistFile);
                        fileOut.write(szRefTopFile.getBytes());
                        fileOut.write(szWrapperPipen1bFile.getBytes());
                        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                            fileOut.write(var_plus.getBytes());
                            fileOut.write(var_rs_hip.getBytes());
                        }
                        fileOut.write(szSimgenFile.getBytes());
                        if ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "HardCopy IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                            fileOut.write(szserdesFile.getBytes());
                        }
                        fileOut.write(szrootportFile.getBytes());
                        fileOut.write(var_testbenchFile.getBytes());
                        fileOut.write(var_example_pipen1b.getBytes());
                        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("0")) {
                            fileOut.write(var_icm.getBytes());
                        }
                        fileOut.write(data);
                        fileOut.close();
                    }
                    File dst = File.createTempFile("tb_result", "txt");
                    if (simlistFile.exists()) {
                        this.updateFile(simlistFile, dst, 0);
                    }
                    this.updateFile(new File(chainingDMATBDir, "runtb.do"), dst, 0);
                    if (simpleDMATBDir.exists()) {
                        this.updateFile(new File(simpleDMATBDir, "runtb.do"), dst, 1);
                    }
                    this.setFilePermission(new File(chainingDMATBDir, "runtb.sh"));
                    this.setFilePermission(new File(chainingDMATBDir, "runtb_vcs.sh"));
                    this.setFilePermission(new File(chainingDMATBDir, "runtb_nc.sh"));
                    this.updateFile(new File(chainingDMATBDir, "runtb_vcs.sh"), dst, 0);
                    this.updateFile(new File(chainingDMATBDir, "runtb_nc.sh"), dst, 0);
                    if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                        refChSdcExampleSrc.delete();
                        europaChpipen1bPlusFile.delete();
                        europaChpipen1bRsHipFile.delete();
                    }
                    refChTopFile.delete();
                    europaChpipen1bFile.delete();
                    refChQsf.delete();
                    refChSdc.delete();
                    refChQpf.delete();
                    refChTbFile.delete();
                    refTopFile.delete();
                    icmFile.delete();
                    refQsf.delete();
                    refQpf.delete();
                }
            } else {
                File sopcDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/sopc");
                File sopcTBDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/sopc/testbench");
                if (!sopcDir.exists()) {
                    sopcDir.mkdirs();
                    sopcTBDir.mkdirs();
                }
                File mysopcTbFile = new File(sopcTBDir, refTbFile.getName());
                this.copy(refTbFile, mysopcTbFile);
                jarFile = this.APP_RESOURCE().getJarFileObject(this.FLOW_MANAGER().getCoreDirectory() + "/" + this.FLOW_MANAGER().getCoreName() + ".jar");
                String szPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/sopc";
                szTBPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/sopc/testbench";
                if (jarFile != null) {
                    Enumeration<JarEntry> enumer = jarFile.entries();
                    while (enumer.hasMoreElements()) {
                        String szFileName;
                        JarEntry jarEntry = enumer.nextElement();
                        if (jarEntry.getName().startsWith(szTBPrefix)) {
                            szFileName = StaticValues.getFullFileName((String)jarEntry.getName());
                            if (szFileName == null || szFileName.trim().length() <= 0) continue;
                            if (szFileName.indexOf(".") != -1 && szFileName.substring(0, szFileName.indexOf(".")).equalsIgnoreCase("altpcietb_bfm_driver")) {
                                File realSOPCTestbenchDir = new File(this.FLOW_MANAGER().getOutputDirectory(), this.FLOW_MANAGER().getNetlistTop() + "_examples/sopc/testbench");
                                File srcFile = new File(realSOPCTestbenchDir, szHDLType.equals("VHDL") ? "altpcietb_bfm_driver.vhd" : "altpcietb_bfm_driver.v");
                                if (srcFile.exists()) continue;
                                StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(sopcTBDir.getAbsolutePath() + "/" + szFileName));
                                continue;
                            }
                            StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(sopcTBDir.getAbsolutePath() + "/" + szFileName));
                            continue;
                        }
                        if (!jarEntry.getName().startsWith(szPrefix) || (szFileName = StaticValues.getFullFileName((String)jarEntry.getName())) == null || szFileName.trim().length() <= 0) continue;
                        StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(sopcTBDir.getAbsolutePath() + "/" + szFileName));
                    }
                }
            }
            File exampleTopTclFile = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_top.tcl");
            File varTclFile = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + ".tcl");
            this.copy(exampleTopTclFile, varTclFile);
            exampleTopTclFile.delete();
            refSdc.delete();
            refTbFile.delete();
            String string = "Stratix GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "gx" : ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "gx2" : ("TI XIO1100".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "ti" : ("NXP PX1011A".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "px" : (sPHYName = "Genesys Logic GL9714".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "gl" : "cu"))));
            String sInterfaceType = "16 bit SDR".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "sdr" : ("16 bit SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "sdt" : ("8 bit DDR".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "ddr" : ("8 bit DDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "ddt" : ("8 bit SDR".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "s8r" : ("8 bit SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "s8t" : ("8 bit DDR/SDR w/TxClk".equals(this.MODEL().getPrivate("p_pcie_phy_interface").getValue()) ? "dst" : ""))))));
            String nNumLanes = this.MODEL().getPrivate("p_pcie_number_of_lanes").getValue().trim();
            String sBlockName = sPHYName + sInterfaceType + "_" + nNumLanes + "_vc" + nVCs;
            File source = new File(projectDir, MVCConstants.getResourceString("PCIE_Protocol_Planner_File"));
            File destination = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + ".ppx");
            source.renameTo(destination);
            FileWriter lineWriter = new FileWriter(new File(projectDir.getAbsolutePath(), this.FLOW_MANAGER().getNetlistTop() + ".ppf"), false);
            lineWriter.write("<?xml version=\"1.0\"?>" + StaticValues.NL);
            lineWriter.write("<pinplan blockname=\"pcie_block\" fileref=\"./" + this.FLOW_MANAGER().getNetlistTop() + ".ppx" + "\"" + " variation_name=\"" + this.FLOW_MANAGER().getNetlistTop() + "\" megafunction_name=\"IP Compiler for PCI Express\" />" + StaticValues.NL);
            lineWriter.flush();
            lineWriter.close();
        }
        this.m_perlProcess = null;
    }

    private void copyFilesFromInstallToProject(String sourceDir, String desinationDir) throws IOException {
        String dirName = desinationDir + "-library";
        String projectDir = this.FLOW_MANAGER().getProjectDirectory();
        File projLibDir = new File(projectDir, dirName);
        File libDir = new File(sourceDir);
        FilenameFilter libFilesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith("v")) {
                    return true;
                }
                if (name.endsWith("vhd")) {
                    return true;
                }
                if (name.endsWith("tdf")) {
                    return true;
                }
                if (name.endsWith("inc")) {
                    return true;
                }
                return name.endsWith("ocp");
            }
        };
        File[] files = libDir.listFiles(libFilesFilter);
        if (files.length > 0) {
            projLibDir.mkdir();
            for (File file : files) {
                this.copy(file, new File(projLibDir, file.getName()));
            }
        }
    }

    private void DoRootPortPrecessing(String[] cmdArray, int nLanes, int nMax_pload, File projectDir, int nStratixGX, int nTxClk, int nVCs, String szRefClkCode, int ntlp_clk_in, String[] tclcmdArray) throws Exception {
        File simlistFile;
        NetlistPrivateInterface npi = this.PRIVATES().getPluginPrivateSection("simgen_enable");
        String szHDLType = npi.getStringValue("language", this.FLOW_MANAGER().getHdlType());
        if (!szHDLType.equalsIgnoreCase("VHDL")) {
            szHDLType = "Verilog";
        }
        String tcl_os = System.getProperty("os.name").toLowerCase();
        cmdArray[9] = this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("0") ? this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_pipen1b.pl" : this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_pipen1b_ez.pl";
        if (nLanes == 1) {
            cmdArray[20] = "--simple_dma=0";
            cmdArray[21] = "--tags=" + this.MODEL().getPrivate("p_pcie_tag_supported").getValue();
            cmdArray[22] = "--max_pload=" + nMax_pload;
        } else {
            cmdArray[19] = "--simple_dma=0";
            cmdArray[20] = "--tags=" + this.MODEL().getPrivate("p_pcie_tag_supported").getValue();
            cmdArray[21] = "--max_pload=" + nMax_pload;
        }
        this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
        StreamGobbler errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
        StreamGobbler outputGobbler = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = this.m_perlProcess.waitFor();
        System.out.println("ExitValue: " + exitVal);
        if (exitVal != 0) {
            System.out.println("**** -> Exit Value = " + exitVal);
            throw new Exception("e_var_example_pipen1b.pl Failed to execute !!!!");
        }
        cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_example_top.pl";
        cmdArray[10] = "--phy=" + nStratixGX;
        cmdArray[11] = "--lanes=" + nLanes;
        cmdArray[12] = "--refclk=" + szRefClkCode;
        cmdArray[13] = "--vc=" + nVCs;
        cmdArray[14] = "--language=" + (szHDLType.equals("VHDL") ? "vhdl" : "verilog");
        cmdArray[15] = "--variation=" + this.FLOW_MANAGER().getNetlistTop();
        cmdArray[16] = "--txclk=" + nTxClk;
        if (nLanes == 1) {
            cmdArray[17] = "--tlp_clk_freq=" + ntlp_clk_in;
        }
        if (nLanes == 1) {
            cmdArray[20] = "--simple_dma=0";
        } else {
            cmdArray[19] = "--simple_dma=0";
        }
        this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
        errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
        outputGobbler = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        exitVal = this.m_perlProcess.waitFor();
        System.out.println("ExitValue: " + exitVal);
        if (exitVal != 0) {
            System.out.println("**** -> Exit Value = " + exitVal);
            throw new Exception("e_var_example_top.pl Failed to execute !!!!");
        }
        cmdArray[9] = this.FLOW_MANAGER().getCoreDirectory() + File.separator + "e_var_testbench.pl";
        this.m_perlProcess = Runtime.getRuntime().exec(cmdArray, null, projectDir);
        errorGobbler = new StreamGobbler(this.m_perlProcess.getErrorStream(), "ERROR");
        outputGobbler = new StreamGobbler(this.m_perlProcess.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        exitVal = this.m_perlProcess.waitFor();
        System.out.println("ExitValue: " + exitVal);
        if (exitVal != 0) {
            System.out.println("**** -> Exit Value = " + exitVal);
            throw new Exception("e_var_testbench.pl Failed to execute !!!!");
        }
        tclcmdArray[9] = "0";
        this.m_tclProcess = Runtime.getRuntime().exec(tclcmdArray, null, projectDir);
        errorGobbler = new StreamGobbler(this.m_tclProcess.getErrorStream(), "ERROR");
        outputGobbler = new StreamGobbler(this.m_tclProcess.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        exitVal = this.m_tclProcess.waitFor();
        System.out.println("ExitValue: " + exitVal);
        if (exitVal != 0) {
            System.out.println("**** -> Exit Value = " + exitVal);
            throw new Exception("pcie_setup_proj.tcl Failed to execute !!!!");
        }
        File RoopPortDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/root_port");
        File RootPortTBDir = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_examples/root_port/testbench");
        if (!RoopPortDir.exists()) {
            RoopPortDir.mkdirs();
            RootPortTBDir.mkdirs();
        }
        File refChTopFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_rp_top"), (String)szHDLType));
        File refChQsf = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_rp_top.qsf");
        File refChSdc = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_rp_top.sdc");
        File refChQpf = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example_rp_top.qpf");
        File myexampleTopFile1 = new File(RoopPortDir, refChTopFile.getName());
        this.copy(refChTopFile, myexampleTopFile1);
        File myChQsfFile = new File(RoopPortDir, refChQsf.getName());
        this.copy(refChQsf, myChQsfFile);
        File refChSdcExampleSrc = new File(projectDir, this.FLOW_MANAGER().getNetlistTop() + "_example.sdc");
        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
            File refChSdcExampleDest = new File(RoopPortDir, refChSdcExampleSrc.getName());
            this.copy(refChSdcExampleSrc, refChSdcExampleDest);
        }
        File myChQpfFile = new File(RoopPortDir, refChQpf.getName());
        this.copy(refChQpf, myChQpfFile);
        File refChTbFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rp_testbench"), (String)szHDLType));
        File myChTbFile = new File(RootPortTBDir, refChTbFile.getName());
        this.copy(refChTbFile, myChTbFile);
        File europaChpipen1bFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_rp_pipen1b"), (String)szHDLType));
        File myexampleChpipen1bFile = new File(RoopPortDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_rp_pipen1b"), (String)szHDLType));
        this.copy(europaChpipen1bFile, myexampleChpipen1bFile);
        File europaChpipen1bPlusFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType));
        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
            File myexampleChpipen1bPlusFile = new File(RoopPortDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType));
            this.copy(europaChpipen1bPlusFile, myexampleChpipen1bPlusFile);
        }
        File europaChpipen1bRsHipFile = new File(projectDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType));
        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
            File myexampleChpipen1bRsHipFile = new File(RoopPortDir, StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType));
            this.copy(europaChpipen1bRsHipFile, myexampleChpipen1bRsHipFile);
        }
        JarFile jarFile = this.APP_RESOURCE().getJarFileObject(this.FLOW_MANAGER().getCoreDirectory() + "/" + this.FLOW_MANAGER().getCoreName() + ".jar");
        String szPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/example_root_port";
        String szTBPrefix = "altera/ipbu/pci_express/" + szHDLType.toLowerCase() + "/example_root_port/testbench";
        if (jarFile != null) {
            Enumeration<JarEntry> enumer = jarFile.entries();
            while (enumer.hasMoreElements()) {
                String szFileName;
                JarEntry jarEntry = enumer.nextElement();
                if (jarEntry.getName().startsWith(szTBPrefix)) {
                    szFileName = StaticValues.getFullFileName((String)jarEntry.getName());
                    if (szFileName == null || szFileName.trim().length() <= 0) continue;
                    if (szFileName.indexOf(".") != -1 && szFileName.substring(0, szFileName.indexOf(".")).equalsIgnoreCase("altpcietb_bfm_driver_rp")) {
                        File realchainingDMATestbenchDir = new File(this.FLOW_MANAGER().getOutputDirectory(), this.FLOW_MANAGER().getNetlistTop() + "_examples/root_port/testbench");
                        File srcFile = new File(realchainingDMATestbenchDir, szHDLType.equals("VHDL") ? "altpcietb_bfm_driver_rp.vhd" : "altpcietb_bfm_driver_rp.v");
                        if (srcFile.exists()) continue;
                        StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(RootPortTBDir.getAbsolutePath() + "/" + szFileName));
                        continue;
                    }
                    StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(RootPortTBDir.getAbsolutePath() + "/" + szFileName));
                    continue;
                }
                if (!jarEntry.getName().startsWith(szPrefix) || (szFileName = StaticValues.getFullFileName((String)jarEntry.getName())) == null || szFileName.trim().length() <= 0) continue;
                StaticValues.serializeBuffer((byte[])this.APP_RESOURCE().getResourceFromJar(jarEntry.getName()), (String)(RoopPortDir.getAbsolutePath() + "/" + szFileName));
            }
        }
        if ((simlistFile = new File(RootPortTBDir, "sim_filelist")).exists()) {
            FileInputStream fileIn = new FileInputStream(simlistFile);
            byte[] data = new byte[(int)simlistFile.length()];
            fileIn.read(data);
            fileIn.close();
            String szWrapperPipen1bFile = "../../../" + StaticValues.getDesignFileName((String)this.FLOW_MANAGER().getNetlistTop(), (String)szHDLType) + StaticValues.NL;
            String szSimgenFile = "";
            if (this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX") || this.MODEL().getPrivate("p_pcie_phy").getValue().toString().equals("Stratix V GX CVP")) {
                if (szHDLType.equalsIgnoreCase("VHDL")) {
                    szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + "_core.vhd" + StaticValues.NL;
                    File simlistFileVerilogCosim = new File(RootPortTBDir, "sim_filelist_verilog_cosim");
                    String szSimgenFileVerilog = "";
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_pipe_native.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_emsip_adapter.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/altera_xcvr_functions.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_native.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pma.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pcs.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_pcs_ch.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_rx_pma.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_tx_pma.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_tx_pma_ch.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/sv_xcvr_avmm.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_rx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_tx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_pcs_aggregate_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_rx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_tx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_rx_if_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_tx_if_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen1_2_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen3_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_aux_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_cdr_refclk_select_mux_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_int_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_buf_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_deser_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_buf_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_cgb_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_ser_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_refclk_divider_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFileVerilog = szSimgenFileVerilog + "../../../ip_compiler_for_pci_express-library/altpcie_hip_256_pipen1b.v" + StaticValues.NL;
                    FileOutputStream fileOutCosim = new FileOutputStream(simlistFileVerilogCosim);
                    fileOutCosim.write(szSimgenFileVerilog.getBytes());
                    fileOutCosim.close();
                } else {
                    szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + "_core.v" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_pipe_native.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_emsip_adapter.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/altera_xcvr_functions.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_native.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pma.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pcs.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_pcs_ch.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_rx_pma.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_tx_pma.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_tx_pma_ch.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/sv_xcvr_avmm.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_rx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_10g_tx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_pcs_aggregate_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_rx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_8g_tx_pcs_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_common_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_rx_if_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_hi_tx_if_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen1_2_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pipe_gen3_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_aux_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_cdr_refclk_select_mux_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_int_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_buf_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_rx_deser_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_buf_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_cgb_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_pma_tx_ser_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_refclk_divider_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_rx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pcs_pma_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/stratixv_hssi_tx_pld_pcs_interface_rbc.sv" + StaticValues.NL;
                    szSimgenFile = szSimgenFile + "../../../ip_compiler_for_pci_express-library/altpcie_hip_256_pipen1b.v" + StaticValues.NL;
                }
            } else {
                szSimgenFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + (szHDLType.equalsIgnoreCase("VHDL") ? "_core.vho" : "_core.vo") + StaticValues.NL;
            }
            String szserdesFile = "../../../" + this.FLOW_MANAGER().getNetlistTop() + (szHDLType.equalsIgnoreCase("VHDL") ? ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "_serdes.vho" : "_serdes.vhd") : ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) ? "_serdes.vo" : "_serdes.v")) + StaticValues.NL;
            String szrootportFile = "../../common/testbench/altpcietb_bfm_rpvar_64b_x8_" + (this.MODEL().getPrivate("p_pcie_rate").getValue().equals("Gen2 (5.0 Gbps)") ? "gen2_" : "gen1_") + (szHDLType.equalsIgnoreCase("VHDL") ? "pipen1b.vho" : "pipen1b.vo") + StaticValues.NL;
            String var_testbenchFile = "./" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rp_testbench"), (String)szHDLType) + StaticValues.NL;
            String var_example_pipen1b = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_example_rp_pipen1b"), (String)szHDLType) + StaticValues.NL;
            String var_plus = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_plus"), (String)szHDLType) + StaticValues.NL;
            String var_rs_hip = "../" + StaticValues.getDesignFileName((String)(this.FLOW_MANAGER().getNetlistTop() + "_rs_hip"), (String)szHDLType) + StaticValues.NL;
            FileOutputStream fileOut = new FileOutputStream(simlistFile);
            fileOut.write(szWrapperPipen1bFile.getBytes());
            fileOut.write(szSimgenFile.getBytes());
            if ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "HardCopy IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                fileOut.write(szserdesFile.getBytes());
            }
            fileOut.write(szrootportFile.getBytes());
            fileOut.write(var_testbenchFile.getBytes());
            fileOut.write(var_example_pipen1b.getBytes());
            if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                fileOut.write(var_plus.getBytes());
                fileOut.write(var_rs_hip.getBytes());
            }
            fileOut.write(data);
            fileOut.close();
        }
        File dst = File.createTempFile("tb_result", "txt");
        if (simlistFile.exists()) {
            this.updateFile(simlistFile, dst, 2);
        }
        if (szHDLType.equalsIgnoreCase("VHDL")) {
            PCIETestbenchPlugin.deleteDirectory(RootPortTBDir);
        } else {
            this.updateFile(new File(RootPortTBDir, "runtb.do"), dst, 2);
            this.setFilePermission(new File(RootPortTBDir, "runtb.sh"));
            this.setFilePermission(new File(RootPortTBDir, "runtb_vcs.sh"));
            this.setFilePermission(new File(RootPortTBDir, "runtb_nc.sh"));
            this.updateFile(new File(RootPortTBDir, "runtb_vcs.sh"), dst, 0);
            this.updateFile(new File(RootPortTBDir, "runtb_nc.sh"), dst, 0);
        }
        if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
            europaChpipen1bPlusFile.delete();
            europaChpipen1bRsHipFile.delete();
            refChSdcExampleSrc.delete();
        }
        europaChpipen1bFile.delete();
        refChTopFile.delete();
        refChQsf.delete();
        refChSdc.delete();
        refChQpf.delete();
        refChTbFile.delete();
    }

    protected static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    PCIETestbenchPlugin.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    protected void append(String szResourceName, OutputStream writer) throws Exception {
        File inFile;
        byte[] data = this.APP_RESOURCE().getResourceFromJar(szResourceName);
        if (data == null && (inFile = new File(szResourceName)).exists()) {
            FileInputStream inStream = new FileInputStream(inFile);
            data = new byte[(int)inFile.length()];
            inStream.read(data);
            inStream.close();
        }
        if (data == null) {
            throw new FileNotFoundException(szResourceName + " not found!");
        }
        writer.write(data);
        writer.write(StaticValues.NL.getBytes());
        writer.write(StaticValues.NL.getBytes());
    }

    protected void plugin_initialize() throws Exception {
        File quartusRootDir = new File(this.OBJBASE().getFlowManager().getQuartusRootDir());
        if (quartusRootDir == null || !quartusRootDir.exists() || !new File(this.FLOW_MANAGER().getQuartusBinDir()).exists()) {
            System.err.println("ERROR: Unable to find valid Quartus Prime root directory, this will impact testbench generation.");
        }
        try {
            String device_family = "";
            String param_phy = this.MODEL().getPrivate("p_pcie_phy").getValue().toString();
            String quartus_device_family = this.PRIVATES().getPrivate("devicefamily").getValue();
            device_family = param_phy.equals("Stratix GX") ? "Stratix GX" : (param_phy.equals("Stratix II GX") || param_phy.equals("Arria GX") ? "Stratix II GX" : quartus_device_family);
            NetlistPrivateInterface npi = this.PRIVATES().getPluginPrivateSection("simgen");
            ((NetlistWriteablePrivateInterface)npi).addModifyPrivate(new NetlistPrivate("family", device_family, null, 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void plugin_prepare() throws Exception {
        NetlistPrivateInterface npi = this.PRIVATES().getPluginPrivateSection("simgen_enable");
        String szHDLType = npi.getStringValue("language", this.FLOW_MANAGER().getHdlType());
        if (!szHDLType.equalsIgnoreCase("VHDL")) {
            szHDLType = "Verilog";
        }
        if (szHDLType.equalsIgnoreCase("VHDL")) {
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + ".vhd", "This VHDL file instantiates the parameterized MegaCore for PCI Express function and the logic required to support the specific PHY selected. It is used for both simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_core.cmp", "This file provides the VHDL component declaration for the MegaCore function variation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_core.vhd", "This VHDL file configures the MegaCore for PCI Express function with the parameters specified. It is used for compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_core.vho", "This VHDL file is the parameterized IP Functional Simulation model of the MegaCore function. It is used for simulation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples", "This directory contains  example design and testbench files for PCI Express.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma", "This directory contains the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_dma_descriptor.vhd", "This VHDL file contains the altpcie_dma_descriptor entity that retrieves DMA read or write descriptors from the root port memory and stores them in a descriptor FIFO. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_dma_dt.vhd", "This VHDL file contains the altpcie_dma_dt entity that arbitrates between PCI Express packets issued by the altpcie_dma_prg_reg, altpcie_read_dma_requester, altpcie_write_dma_requester and altpcie_dma_descriptor entities. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_dma_prg_reg.vhd", "This VHDL file implements the descriptor header table registers. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_rc_slave.vhd", "This VHDL file contains the altpcie_rc_slave entity that is used by the host software application to retrieve the DMA Performance counter values and directly access the Endpoint memory. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_read_dma_requester.vhd", "This VHDL file contains the altpcie_read_dma_requester entity that manages DMA read data transfer from the Root Complex memory to the Endpoint memory. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_write_dma_requester.vhd", "This VHDL file contains the altpcie_write_dma_requester entity that manages DMA write data transfer from the Endpoint memory to the Root Complex memory. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcierd_example_app_chaining.vhd", "This VHDL file contains the altpcierd_example_app_chaining entity that is the top level application layer of the chaining DMA example design. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | init_ram.hex", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in simulation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | init_ram.mif", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in compilation in the Quartus Prime software. ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench", "This directory contains files required for simulation of the chaining DMA example design and testbench.");
            if (this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256.name())) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | altpcietb_bfm_driver_downstream.vhd", "This VHDL file contains the altpcietb_bfm_driver_downstream entity that drives the testing of the chaining DMA example design. This file is used in simulation.");
            } else {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | altpcietb_bfm_driver_chaining.vhd", "This VHDL file contains the altpcietb_bfm_driver_chaining entity that drives the testing of the chaining DMA example design. This file is used in simulation.");
            }
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | init_ram.hex", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in simulation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | init_ram.mif", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in compilation in the Quartus Prime software. ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | runtb.bat", "This Windows batch file launches the simulation of the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | runtb.do", "This Modelsim simulator TCL script file launches the simulation of the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | runtb.sh", "This shell script file launches the simulation of the chaining DMA example design and testbench. ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | sim_filelist", "This file is used for simulation of the chaining DMA example design. It contains the list of all the files necessary for compilation in the simulator.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | " + this.FLOW_MANAGER().getNetlistTop() + "_chaining_testbench.vhd", "This VHDL file implements the top level of the testbench for the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_pipen1b.vhd", "This VHDL file instantiates the chaining DMA example application layer and the MegaCore for PCI Express function variation. It is used for simulation and compilation in the Quartus Prime software.");
            if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_plus.vhd", "This VHDL file instantiates the MegaCore for PCI Express function variation and the reset circuit. The ALTGX_RECONFIG megafunction is also added to this module when the device family requires transceiver offset cancellation. It is used for simulation and compilation in the Quartus Prime software.");
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_rs_hip.vhd", "This VHDL file implements the HIP reset circuit. It is used for simulation and compilation in the Quartus Prime software.");
            }
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.qpf", "This is the Quartus Prime project file used for compiling the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.qsf", "This is the Quartus Prime settings file used for compiling the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + ".sdc", "This is the Quartus Prime TimeQuest Timing Analyzer constraint file.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.tcl", "This is a Quartus Prime TCL script used for applying Classic Timing Analyzer timing constraints to the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.vhd", "This VHDL file instantiates the entire chaining DMA example design. It is used for compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | common", "This directory contains files required for simulation..");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | common | testbench", "This directory contains files required for simulation. These files implement the common BFM and Testbench routines that are described in Chapter 5 of the User Guide for the MegaCore for PCI Express.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module", "This directory contains files for the incremental compile module. These files are required for simulation and compilation of the simple DMA and chaining DMA example designs");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_fifo.vhd", "This VHDL file contains the altpcierd_icm_fifo entity. This is an altera FIFO which is used in the incremental compile module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_fifo_lkahd.vhd", "This VHDL file contains the altpcierd_icm_fifo_lkahd entity that provides a look-ahead FIFO which is used in the incremental compile module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_msibridge.vhd", "This VHDL file contains the altpcierd_icm_msibridge entity that implements bridging of the application's msi streaming interface to the core's msi interface . This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_npbypassctl.vhd", "This VHDL file contains the altpcierd_icm_npbypassctl entity that implements the controls for bypassing of Non-Posted requests. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_rx.vhd", "This VHDL file contains the altpcierd_icm_rx entity that instantiates an interface FIFO and the altpcierd_icm_rxbridge module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_rxbridge.vhd", "This VHDL file contains the altpcierd_icm_rxbridge entity that implements bridging of the application's rx streaming interface to the core's rx interface. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_sideband.vhd", "This VHDL file contains the altpcierd_icm_sideband entity that contains boundary registers for the core's sideband signals. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_top.vhd", "This VHDL file contains the altpcierd_icm_top entity. This is the top level module for the incremental compile module. It contains the altpcierd_icm_rx, altpcierd_tx, altpcierd_sideband modules. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_tx.vhd", "This VHDL file contains the altpcierd_icm_tx entity that instantiates an interface FIFO, the altpcierd_msi_bridge and altpcierd_icm_txbridge_withbypass modules. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_tx_pktordering.vhd", "This VHDL file contains the altpcierd_icm_tx_pktordering entity that implements packet reordering for bypassing of non-posted requests (npbypass). It contains the npbypass Fifos and the altpcierd_npbypassctl module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_txbridge.vhd", "This VHDL file contains the altpcierd_icm_txbridge entity that implements bridging of the application's tx streaming interface to the core's tx interface. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_txbridge_withbypass.vhd", "This VHDL file contains the altpcierd_icm_txbridge_withbypass entity which instantiates the altpcierd_icm_tx_pktordering and altpcierd_icm_txbridge modules. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | " + this.FLOW_MANAGER().getNetlistTop() + "_icm.vhd", "This VHDL file contains the VAR_icm entity that instantiates the altpcierd_icm_top and the VAR modules. This file is used for simulation and compilation in the Quartus Prime software.");
            if ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "HardCopy IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_serdes.vhd", "Variation file from the ALT2GXB Megafunction.This file contains the on-chip transceiver settings for PCI Express.");
            }
            if ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "HardCopy IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_serdes.vhd", "Variation file from the ALTGXB Megafunction.This file contains the on-chip transceiver settings for PCI Express.");
            }
        } else {
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + ".v", "This Verilog HDL file instantiates the parameterized MegaCore for PCI Express function and the logic required to support the specific PHY selected. It is used for both simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_core.v", "This Verilog HDL file configures the MegaCore for PCI Express function with the parameters specified. It is used for compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_core.vo", "This Verilog HDL file is the parameterized IP Functional Simulation model of the MegaCore function. It is used for simulation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples", "This directory contains example design and testbench files.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma", "This directory contains the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_dma_descriptor.v", "This Verilog HDL file contains the altpcie_dma_descriptor module that retrieves DMA read or write descriptors from the root port memory and stores them in a descriptor FIFO. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_dma_dt.v", "This Verilog HDL file contains the altpcie_dma_dt module that arbitrates between PCI Express packets issued by the altpcie_dma_prg_reg, altpcie_read_dma_requester, altpcie_write_dma_requester and altpcie_dma_descriptor modules. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_dma_prg_reg.v", "This Verilog HDL file implements the descriptor header table registers. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_rc_slave.v", "This Verilog HDL file contains the altpcie_rc_slave module that is used by the host software application to retrieve the DMA Performance counter values and directly access the Endpoint memory. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_read_dma_requester.v", "This Verilog HDL file contains the altpcie_read_dma_requester module that manages DMA read data transfer from the Root Complex memory to the Endpoint memory. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcie_write_dma_requester.v", "This Verilog HDL file contains the altpcie_write_dma_requester module that manages DMA write data transfer from the Endpoint memory to the Root Complex memory. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | altpcierd_example_app_chaining.v", "This Verilog HDL file contains the altpcierd_example_app_chaining module that is the top level application layer of the chaining DMA example design. It is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | init_ram.hex", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in simulation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | init_ram.mif", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in compilation in the Quartus Prime software. ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench", "This directory contains files required for simulation of the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | altpcie_dma_dt_cst_sim.v", "This Verilog HDL file contains constants used in the testbench for the chaining DMA example design. It is used in simulation.");
            if (this.MODEL().getPrivate("p_pcie_app_signal_interface").getValue().equals(IPCIECompilerCoreParameters.EAppSignalInterfaceOptions.AvalonST256.name())) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | altpcietb_bfm_driver_downstream.v", "This Verilog HDL file contains the altpcietb_bfm_driver_downstream module that drives the testing of the chaining DMA example design. This file is used in simulation.");
            } else {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | altpcietb_bfm_driver_chaining.v", "This Verilog HDL file contains the altpcietb_bfm_driver_chaining module that drives the testing of the chaining DMA example design. This file is used in simulation.");
            }
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | init_ram.hex", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in simulation.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | init_ram.mif", "This memory initialization file is used to initialize the endpoint memory buffer to a ramp. This file is used in compilation in the Quartus Prime software. ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | runtb.bat", "This Windows batch file launches the simulation of the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | runtb.do", "This Modelsim simulator TCL script file launches the simulation of the chaining DMA example design and testbench.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | runtb.sh", "This shell script file launches the simulation of the chaining DMA example design and testbench. ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | sim_filelist", "This file is used for simulation of the chaining DMA example design. It contains the list of all the files necessary for compilation in the simulator.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | testbench | " + this.FLOW_MANAGER().getNetlistTop() + "_chaining_testbench.v", "This Verilog HDL file implements the top level of the testbench for the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_pipen1b.v", "This Verilog HDL file instantiates the chaining DMA example application layer and the variation. It is used for simulation and compilation in the Quartus Prime software.");
            if (this.MODEL().getPrivate("p_pcie_enable_hip").getValue().equalsIgnoreCase("1")) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_plus.v", "This Verilog HDL file instantiates the variation and the reset circuit. The ALTGX_RECONFIG megafunction is also added to this module when the device family requires transceiver offset cancellation. It is used for simulation and compilation in the Quartus Prime software.");
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_rs_hip.v", "This Verilog file implements the HIP reset circuit. It is used for simulation and compilation in the Quartus Prime software.");
            }
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.qpf", "This is the Quartus Prime project file used for compiling the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.qsf", "This is the Quartus Prime settings file used for compiling the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + ".sdc", "This is the Quartus Prime TimeQuest Timing Analyzer constraint file.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.tcl", "This is a Quartus Prime TCL script used for applying Classic Timing Analyzer timing constraints to the chaining DMA example design.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | chaining_dma | " + this.FLOW_MANAGER().getNetlistTop() + "_example_chaining_top.v", "This Verilog HDL file instantiates the entire chaining DMA example design. It is used for compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | common", "This directory contains files required for simulation..");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | common | testbench", "This directory contains files required for simulation. These files implement the common BFM and Testbench routines that are described in Chapter 5 of the User Guide.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module", "This directory contains files for the incremental compile module. These files are required for simulation and compilation of the simple DMA and chaining DMA example designs");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_defines.v", "This Verilog HDL file contains global defines used in the incremental_compile_module files and in the ");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_fifo.v", "This Verilog HDL file contains the altpcierd_icm_fifo module. This is an altera FIFO which is used in the incremental compile module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_fifo_lkahd.v", "This Verilog HDL file contains the altpcierd_icm_fifo_lkahd module that provides a look-ahead FIFO which is used in the incremental compile module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_msibridge.v", "This Verilog HDL file contains the altpcierd_icm_msibridge module that implements bridging of the application's msi streaming interface to the core's msi interface . This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_npbypassctl.v", "This Verilog HDL file contains the altpcierd_icm_npbypassctl module that implements the controls for bypassing of Non-Posted requests. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_rx.v", "This Verilog HDL file contains the altpcierd_icm_rx module that instantiates an interface FIFO and the altpcierd_icm_rxbridge module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_rxbridge.v", "This Verilog HDL file contains the altpcierd_icm_rxbridge module that implements bridging of the application's rx streaming interface to the core's rx interface. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_sideband.v", "This Verilog HDL file contains the altpcierd_icm_sideband module that contains boundary registers for the core's sideband signals. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_top.v", "This Verilog HDL file contains the altpcierd_icm_top module. This is the top level module for the incremental compile module. It contains the altpcierd_icm_rx, altpcierd_tx, altpcierd_sideband modules. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_tx.v", "This Verilog HDL file contains the altpcierd_icm_tx module that instantiates an interface FIFO, the altpcierd_msi_bridge and altpcierd_icm_txbridge_withbypass modules. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_tx_pktordering.v", "This Verilog HDL file contains the altpcierd_icm_tx_pktordering module that implements packet reordering for bypassing of non-posted requests (npbypass). It contains the npbypass Fifos and the altpcierd_npbypassctl module. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_txbridge.v", "This Verilog HDL file contains the altpcierd_icm_txbridge module that implements bridging of the application's tx streaming interface to the core's tx interface. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | altpcierd_icm_txbridge_withbypass.v", "This Verilog HDL file contains the altpcierd_icm_txbridge_withbypass module which instantiates the altpcierd_icm_tx_pktordering and altpcierd_icm_txbridge modules. This file is used for simulation and compilation in the Quartus Prime software.");
            this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_examples | incremental_compile_module | " + this.FLOW_MANAGER().getNetlistTop() + "_icm.v", "This Verilog HDL file contains the VAR_icm module that instantiates the altpcierd_icm_top and the VAR modules. This file is used for simulation and compilation in the Quartus Prime software.");
            if ("Stratix II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_serdes.v", "Variation file from the ALT2GXB Megafunction.This file contains the on-chip transceiver settings for PCI Express.");
            }
            if ("Stratix IV GX ES".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Cyclone IV GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GZ".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Arria II GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + "_serdes.v", "Variation file from the ALTGXB Megafunction.This file contains the on-chip transceiver settings for PCI Express.");
            }
        }
        this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + ".ppx", MVCConstants.getResourceString("PCIE_Pin_Planner_Master.Description").replaceAll("<variation_name>", this.FLOW_MANAGER().getNetlistTop()));
        this.PLUGIN_MANAGER().addGenerateTimeFile(this.FLOW_MANAGER().getNetlistTop() + ".ppf", MVCConstants.getResourceString("PCIE_Pin_Planner_User_Variation.Description"));
    }

    protected void plugin_uninitialize() throws Exception {
        NetlistPrivateInterface npi = this.PRIVATES().getPluginPrivateSection("simgen_enable");
        String szHDLType = npi.getStringValue("language", this.FLOW_MANAGER().getHdlType());
        if (!szHDLType.equalsIgnoreCase("VHDL")) {
            szHDLType = "Verilog";
        }
        File europaVariationFile = new File(this.FLOW_MANAGER().getOutputDirectory(), StaticValues.getDesignFileName((String)"pcie_phy_support", (String)szHDLType));
        europaVariationFile.delete();
    }

    private String getCompletionBufferSizeHIP() throws Exception {
        int CHUS;
        String temp = null;
        BigInteger biConf = new BigInteger("0");
        if (this.MODEL().getPrivate("p_pcie_use_crc_forwarding").getValue().equals("1")) {
            CHUS = Integer.valueOf(this.MODEL().getPrivate("p_pcie_completion_header_used_space_vc0").getValue()) / 16;
            int CDUS = Integer.valueOf(this.MODEL().getPrivate("p_pcie_completion_data_used_space_vc0").getValue()) / 16;
            BigInteger biVal = new BigInteger(Integer.toString(CDUS));
            biVal = biVal.shiftLeft(8);
            biConf = biConf.or(biVal);
            biVal = new BigInteger(Integer.toString(CHUS));
            biConf = biConf.or(biVal);
        } else {
            CHUS = Integer.valueOf(this.MODEL().getPrivate("p_pcie_completion_header_used_space_vc0").getValue()) / 16;
            int CDUS = Integer.valueOf(this.MODEL().getPrivate("p_pcie_completion_data_used_space_vc0").getValue()) / 16;
            BigInteger biVal = new BigInteger(Integer.toString(CDUS));
            biVal = biVal.shiftLeft(8);
            biConf = biConf.or(biVal);
            biVal = new BigInteger(Integer.toString(CHUS));
            biConf = biConf.or(biVal);
        }
        temp = PCIETestbenchPlugin.pad(biConf.toString(2), -20, "0");
        BigInteger result = new BigInteger(temp, 2);
        if (result.intValue() == 0) {
            result = result.or(new BigInteger("FFFFF", 16));
        }
        return result.toString(16);
    }

    protected static String pad(Object str, int padlen, String pad) {
        String padding = new String();
        int len = Math.abs(padlen) - str.toString().length();
        if (len < 1) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            padding = padding + pad;
        }
        return padlen < 0 ? padding + str : str + padding;
    }

    private String getIpDir() {
        String path = null;
        try {
            path = this.FLOW_MANAGER().getQuartusBinDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        path = path + "/../../ip/altera";
        return path;
    }

    protected void plugin_stop() {
        try {
            if (this.m_perlProcess != null) {
                this.m_perlProcess.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFile(File src, File dst, int SimpleDMA) throws IOException {
        if (src.exists()) {
            LineNumberReader lineReader = null;
            lineReader = new LineNumberReader(new FileReader(src));
            FileWriter lineWriter = new FileWriter(dst, false);
            String line = null;
            try {
                String extension = src.getAbsoluteFile().toString().substring(src.getAbsoluteFile().toString().length() - 3);
                while ((line = lineReader.readLine()) != null) {
                    if (this.getModifiedLine(line, "altpcietb_top_x4_pipen1b")) {
                        if (SimpleDMA == 1) {
                            lineWriter.write(line.replaceAll("altpcietb_top_x4_pipen1b", this.FLOW_MANAGER().getNetlistTop() + "_testbench") + "\n");
                        } else if (SimpleDMA == 2) {
                            lineWriter.write(line.replaceAll("altpcietb_top_x4_pipen1b", this.FLOW_MANAGER().getNetlistTop() + "_rp_testbench") + "\n");
                        } else {
                            lineWriter.write(line.replaceAll("altpcietb_top_x4_pipen1b", this.FLOW_MANAGER().getNetlistTop() + "_chaining_testbench") + "\n");
                        }
                    } else if (this.getModifiedLine(line, "PCIE_JAVA_STR_RPL_TOP")) {
                        lineWriter.write(line.replaceAll("PCIE_JAVA_STR_RPL_TOP", this.FLOW_MANAGER().getNetlistTop()) + "\n");
                    } else if (this.getModifiedLine(line, "PCIE_BUILD_PATH_TO_QUARTUS_ROOTDIR")) {
                        File quartusRootDir = new File(this.OBJBASE().getFlowManager().getQuartusRootDir());
                        if (quartusRootDir != null && quartusRootDir.exists()) {
                            lineWriter.write(line.replaceAll("PCIE_BUILD_PATH_TO_QUARTUS_ROOTDIR", quartusRootDir.getAbsolutePath().replaceAll("\\\\", "/")) + "\n");
                        } else {
                            lineWriter.write(line + "\n");
                        }
                    } else if (this.getModifiedLine(line, "PCIE_USE_NCRYPT_MODEL_VALUE")) {
                        if ("Stratix V GX".equals(this.MODEL().getPrivate("p_pcie_phy").getValue()) || "Stratix V GX CVP".equals(this.MODEL().getPrivate("p_pcie_phy").getValue())) {
                            lineWriter.write(line.replaceAll("PCIE_USE_NCRYPT_MODEL_VALUE", "1\n"));
                        } else {
                            lineWriter.write(line.replaceAll("PCIE_USE_NCRYPT_MODEL_VALUE", "0\n"));
                        }
                    } else {
                        lineWriter.write(line + "\n");
                    }
                    lineWriter.flush();
                }
                this.copy(dst, src);
                lineReader.close();
                lineWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean getModifiedLine(String line, String pattern) {
        boolean returnvalue = false;
        Pattern regexp = Pattern.compile(pattern);
        Matcher matcher = regexp.matcher("");
        try {
            matcher.reset(line);
            if (matcher.find()) {
                returnvalue = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnvalue;
    }

    private void copy(File src, File dst) throws IOException {
        if (src.exists()) {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private void setFilePermission(File file) {
        Object path = null;
        String os = System.getProperty("os.name").toLowerCase();
        String sFile = file.getPath();
        if (!os.startsWith("windows") && (os.equals("linux") || os.equals("sunos"))) {
            try {
                Runtime.getRuntime().exec("chmod 777 " + sFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void PerformBackup(File srcFile, File archiveDir, String szHDLType) {
        int highest_backup_num = 0;
        String sVersion = "0";
        if (!archiveDir.exists()) {
            archiveDir.mkdir();
            sVersion = "1";
        } else {
            String[] altpcietb_bfm_driver_files = archiveDir.list();
            for (int i = 0; i < altpcietb_bfm_driver_files.length; ++i) {
                if (szHDLType.equalsIgnoreCase("VHDL")) {
                    if (altpcietb_bfm_driver_files[i].length() > 24 && altpcietb_bfm_driver_files[i].substring(0, 24).equalsIgnoreCase("altpcietb_bfm_driver.vhd")) {
                        sVersion = altpcietb_bfm_driver_files[i].substring(25);
                    }
                } else if (altpcietb_bfm_driver_files[i].length() > 22 && altpcietb_bfm_driver_files[i].substring(0, 22).equalsIgnoreCase("altpcietb_bfm_driver.v")) {
                    sVersion = altpcietb_bfm_driver_files[i].substring(23);
                }
                try {
                    if (highest_backup_num == 0) {
                        highest_backup_num = Integer.parseInt(sVersion);
                        continue;
                    }
                    highest_backup_num = Integer.parseInt(sVersion) > highest_backup_num ? Integer.parseInt(sVersion) : highest_backup_num;
                    continue;
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
            }
        }
        File destFile = new File(archiveDir, (szHDLType.equals("VHDL") ? "altpcietb_bfm_driver.vhd" : "altpcietb_bfm_driver.v") + "." + Integer.toString(highest_backup_num + 1));
        try {
            this.copy(srcFile, destFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

