/*
 * Decompiled with CFR 0.152.
 */
package altera.ipbu.pci_express;

import altera.ipbu.flowbase.controls.WLabel;
import altera.ipbu.flowbase.controls.WPanel;
import altera.ipbu.flowbase.controls.WTextField;
import altera.ipbu.flowbase.netlist.NetlistPrivate;
import altera.ipbu.flowbase.netlist.model.DiscreteRange;
import altera.ipbu.flowbase.netlist.model.MVCModel;
import altera.ipbu.flowbase.netlist.model.ModelBaseClass;
import altera.ipbu.flowbase.netlist.model.ModelListener;
import altera.ipbu.flowbase.netlist.model.WriteablePropertyInterface;
import altera.ipbu.pci_express.FixedTableCellRenderer;
import altera.ipbu.pci_express.GroupableTableHeader;
import altera.ipbu.pci_express.MVCConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;

public class PCIEBars
extends WPanel
implements ModelListener {
    private boolean DEBUG = true;
    private boolean temp = true;
    HeaderRenderer renderer = new HeaderRenderer();
    HeaderRenderer table_header_renderer = new HeaderRenderer();
    CustomTableCellRenderer custome_renderer = new CustomTableCellRenderer();
    protected JTable table;
    protected MVCModel m_model = null;
    protected static Hashtable hstPCIAvalon;
    protected String m_pci_bar_0_type;
    protected String m_pci_bar_0_size;
    protected String m_pci_bar_1_type;
    protected String m_pci_bar_1_size;
    protected String m_pci_bar_2_type;
    protected String m_pci_bar_2_size;
    protected String m_pci_bar_3_type;
    protected String m_pci_bar_3_size;
    protected String m_pci_bar_4_type;
    protected String m_pci_bar_4_size;
    protected String m_pci_bar_5_type;
    protected String m_pci_bar_5_size;
    protected String m_pci_exp_rom_type;
    protected String m_pci_exp_rom_size;
    private String m_row_col;
    private String m_value;

    public PCIEBars(MVCModel model) {
        super((LayoutManager)new GridLayout(1, 0));
        this.m_model = model;
        this.table = new JTable(new MyTableModel()){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new GroupableTableHeader(this.columnModel);
            }

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                PCIEBars.this.m_row_col = "";
                PCIEBars.this.m_value = "";
                if (this.editCellAt(row, column)) {
                    this.getEditorComponent().requestFocusInWindow();
                }
            }

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                Component editor = this.getEditorComponent();
                if (editor != null && editor instanceof JTextComponent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                return result;
            }
        };
        this.populateTableData();
        this.table.setSurrendersFocusOnKeystroke(true);
        this.initColumnSizes(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.m_model.addModelListener(this);
    }

    private void initColumnSizes(JTable table) {
        MyTableModel model = (MyTableModel)table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int rowHeight = 0;
        WTextField wtextfield = new WTextField();
        rowHeight = wtextfield.getPreferredSize().height;
        table.setRowHeight(rowHeight);
        this.table_header_renderer.setFont(this.getFont());
        this.table_header_renderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.table_header_renderer.setHorizontalAlignment(0);
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setResizingAllowed(false);
        Object[] longValues = model.longValues;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int j = 0; j < table.getRowCount(); ++j) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                if (i == 0) {
                    table.getColumnModel().getColumn(i).setCellRenderer(this.renderer);
                    this.renderer.setForegroundColor(UIManager.getColor("TableHeader.foreground"));
                    this.renderer.setBackgroundColor(UIManager.getColor("TableHeader.background"));
                    this.renderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    this.renderer.setHorizontalAlignment(0);
                    this.renderer.setFont(this.getFont());
                } else {
                    table.getColumnModel().getColumn(i).setCellRenderer(this.custome_renderer);
                    this.custome_renderer.setHorizontalAlignment(0);
                }
                column = table.getColumnModel().getColumn(i);
                comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, j, i);
                headerWidth = comp.getPreferredSize().width;
                comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, longValues[i], false, false, j, i);
                cellWidth = comp.getPreferredSize().width;
                if (this.DEBUG) {
                    System.out.println("Initializing width of column " + i + ". " + "headerWidth = " + headerWidth + "; cellWidth = " + cellWidth);
                }
                switch (i) {
                    case 0: {
                        column.setPreferredWidth(10);
                        break;
                    }
                    case 1: {
                        column.setPreferredWidth(300);
                        break;
                    }
                    case 2: {
                        column.setPreferredWidth(125);
                        break;
                    }
                    case 3: {
                        column.setPreferredWidth(125);
                        break;
                    }
                    case 4: {
                        column.setPreferredWidth(45);
                        break;
                    }
                    case 5: {
                        column.setPreferredWidth(155);
                        break;
                    }
                }
                column.sizeWidthToFit();
            }
        }
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredSize().width, 7 * rowHeight));
    }

    public void setUpBARTypeColumn(JTable table, TableColumn column, int row) {
        try {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            MyTableModel myTableModel = (MyTableModel)table.getModel();
            String num_BAR = myTableModel.getValueAt(row, 0).toString().trim().substring(myTableModel.getValueAt(row, 0).toString().trim().length() - 1);
            NetlistPrivate param_bar_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + num_BAR);
            if (param_bar_type.hasRange()) {
                DiscreteRange range = (DiscreteRange)param_bar_type.getRange();
                String[] items = range.getValidValues();
                for (int i = 0; i < items.length; ++i) {
                    comboBox.addItem(items[i]);
                }
            }
            comboBox.setSelectedItem(param_bar_type.getValue());
            DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
            listRenderer.setHorizontalAlignment(2);
            comboBox.setRenderer(listRenderer);
            column.setCellEditor(new DefaultCellEditor(comboBox));
            FixedTableCellRenderer combo_renderer = new FixedTableCellRenderer();
            combo_renderer.setHorizontalAlignment(0);
            combo_renderer.setFont(this.getFont());
            column.setCellRenderer(combo_renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpBARType_FirstRow(JTable table, TableColumn column, int row) {
        try {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            String value = "";
            MyTableModel myTableModel = (MyTableModel)table.getModel();
            String num_BAR = myTableModel.getValueAt(row, 0).toString().trim().substring(myTableModel.getValueAt(row, 0).toString().trim().length() - 1);
            NetlistPrivate param_bar_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + num_BAR);
            if (param_bar_type.hasRange()) {
                DiscreteRange range = (DiscreteRange)param_bar_type.getRange();
                String[] items = range.getValidValues();
                for (int i = 0; i < items.length; ++i) {
                    comboBox.addItem(items[i]);
                }
            }
            comboBox.setSelectedItem(param_bar_type.getValue());
            DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
            listRenderer.setHorizontalAlignment(2);
            comboBox.setRenderer(listRenderer);
            column.setCellEditor(new DefaultCellEditor(comboBox));
            FixedTableCellRenderer combo_renderer = new FixedTableCellRenderer();
            combo_renderer.setHorizontalAlignment(0);
            combo_renderer.setFont(this.getFont());
            column.setCellRenderer(combo_renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpExpROMTypeColumn(JTable table, TableColumn column) {
        try {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            comboBox.addItem("Enable");
            comboBox.addItem("Disable");
            NetlistPrivate param_exp_rom_bar_used = this.m_model.getPrivate("p_pcie_exp_rom_bar_used");
            comboBox.setSelectedItem(param_exp_rom_bar_used.getValue());
            DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
            listRenderer.setHorizontalAlignment(2);
            comboBox.setRenderer(listRenderer);
            column.setCellEditor(new DefaultCellEditor(comboBox));
            FixedTableCellRenderer combo_renderer = new FixedTableCellRenderer();
            combo_renderer.setHorizontalAlignment(0);
            combo_renderer.setFont(this.getFont());
            column.setCellRenderer(combo_renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpBARSizeColumn(JTable table, TableColumn column, int row) {
        try {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            MyTableModel myTableModel = (MyTableModel)table.getModel();
            String num_BAR = myTableModel.getValueAt(row, 0).toString().trim().substring(myTableModel.getValueAt(row, 0).toString().trim().length() - 1);
            NetlistPrivate param_bar_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + num_BAR);
            if (param_bar_size.hasRange()) {
                DiscreteRange range = (DiscreteRange)param_bar_size.getRange();
                String[] items = range.getValidValues();
                for (int i = 0; i < items.length; ++i) {
                    comboBox.addItem(items[i]);
                }
            }
            comboBox.setSelectedItem(param_bar_size.getValue());
            DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
            listRenderer.setHorizontalAlignment(2);
            comboBox.setRenderer(listRenderer);
            column.setCellEditor(new DefaultCellEditor(comboBox));
            FixedTableCellRenderer combo_renderer = new FixedTableCellRenderer();
            combo_renderer.setHorizontalAlignment(0);
            combo_renderer.setFont(this.getFont());
            column.setCellRenderer(combo_renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpExpRomBarSizesColumn(JTable table, TableColumn column, int row) {
        try {
            MyTableModel TableModel2 = (MyTableModel)table.getModel();
            Object myValue = TableModel2.getValueAt(row, 1);
            JComboBox<Object> comboBox = new JComboBox<Object>();
            NetlistPrivate param_exp_rom_bar_size = this.m_model.getPrivate("p_pcie_exp_rom_bar_size");
            if (param_exp_rom_bar_size.hasRange()) {
                DiscreteRange range = (DiscreteRange)param_exp_rom_bar_size.getRange();
                String[] items = range.getValidValues();
                for (int i = 0; i < items.length; ++i) {
                    comboBox.addItem(items[i]);
                }
            }
            comboBox.setSelectedItem(param_exp_rom_bar_size.getValue());
            DefaultListCellRenderer listRenderer = new DefaultListCellRenderer();
            listRenderer.setHorizontalAlignment(2);
            comboBox.setRenderer(listRenderer);
            column.setCellEditor(new DefaultCellEditor(comboBox));
            FixedTableCellRenderer combo_renderer = new FixedTableCellRenderer();
            combo_renderer.setHorizontalAlignment(0);
            combo_renderer.setFont(this.getFont());
            column.setCellRenderer(combo_renderer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
            formatter.setInvalidCharacters("");
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public void populateTableData() {
        try {
            this.m_row_col = "";
            this.m_value = "";
            int i = 0;
            if (this.m_model.getPrivate("p_pcie_bar_used_bar_" + i).getValue().toString().equalsIgnoreCase("1")) {
                this.m_pci_bar_0_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + i).getValue().toString();
                this.m_pci_bar_0_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + i).getValue().toString();
            }
            if (this.m_model.getPrivate("p_pcie_bar_used_bar_" + ++i).getValue().toString().equalsIgnoreCase("1")) {
                this.m_pci_bar_1_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + i).getValue().toString();
                this.m_pci_bar_1_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + i).getValue().toString();
            } else {
                this.m_pci_bar_1_type = "Select Type to Enable";
                this.m_pci_bar_1_size = "";
            }
            if (this.m_model.getPrivate("p_pcie_bar_used_bar_" + ++i).getValue().toString().equalsIgnoreCase("1")) {
                this.m_pci_bar_2_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + i).getValue().toString();
                this.m_pci_bar_2_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + i).getValue().toString();
            } else {
                this.m_pci_bar_2_type = this.m_pci_bar_1_type.equalsIgnoreCase("Select Type to Enable") || this.m_pci_bar_1_type.equalsIgnoreCase("") ? "" : "Select Type to Enable";
                this.m_pci_bar_2_size = "";
            }
            if (this.m_model.getPrivate("p_pcie_bar_used_bar_" + ++i).getValue().toString().equalsIgnoreCase("1")) {
                this.m_pci_bar_3_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + i).getValue().toString();
                this.m_pci_bar_3_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + i).getValue().toString();
            } else {
                this.m_pci_bar_3_type = this.m_pci_bar_2_type.equalsIgnoreCase("Select Type to Enable") || this.m_pci_bar_2_type.equalsIgnoreCase("") ? "" : "Select Type to Enable";
                this.m_pci_bar_3_size = "";
            }
            if (this.m_model.getPrivate("p_pcie_bar_used_bar_" + ++i).getValue().toString().equalsIgnoreCase("1")) {
                this.m_pci_bar_4_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + i).getValue().toString();
                this.m_pci_bar_4_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + i).getValue().toString();
            } else {
                this.m_pci_bar_4_type = this.m_pci_bar_3_type.equalsIgnoreCase("Select Type to Enable") || this.m_pci_bar_3_type.equalsIgnoreCase("") ? "" : "Select Type to Enable";
                this.m_pci_bar_4_size = "";
            }
            if (this.m_model.getPrivate("p_pcie_bar_used_bar_" + ++i).getValue().toString().equalsIgnoreCase("1")) {
                this.m_pci_bar_5_type = this.m_model.getPrivate("p_pcie_bar_type_bar_" + i).getValue().toString();
                this.m_pci_bar_5_size = this.m_model.getPrivate("p_pcie_bar_size_bar_" + i).getValue().toString();
            } else {
                this.m_pci_bar_5_type = this.m_pci_bar_4_type.equalsIgnoreCase("Select Type to Enable") || this.m_pci_bar_4_type.equalsIgnoreCase("") ? "" : "Select Type to Enable";
                this.m_pci_bar_5_size = "";
            }
            this.m_pci_exp_rom_type = this.m_model.getPrivate("p_pcie_exp_rom_bar_used").getValue().toString();
            if (this.m_pci_exp_rom_type.equalsIgnoreCase("1")) {
                this.m_pci_exp_rom_type = "Enabled";
                this.m_pci_exp_rom_size = this.m_model.getPrivate("p_pcie_exp_rom_bar_size").getValue().toString();
            } else {
                this.m_pci_exp_rom_type = "Select to Enable";
                this.m_pci_exp_rom_size = "";
            }
            if (this.table != null) {
                if (this.m_pci_bar_0_type.equalsIgnoreCase("64-bit Prefetchable Memory") || this.m_pci_bar_0_type.equalsIgnoreCase("Not supported Non-prefetchable 64 bit bar please remove")) {
                    if (this.m_pci_bar_2_type.equalsIgnoreCase("64-bit Prefetchable Memory") || this.m_pci_bar_2_type.equalsIgnoreCase("Not supported Non-prefetchable 64 bit bar please remove")) {
                        if (this.m_pci_bar_4_type.equalsIgnoreCase("64-bit Prefetchable Memory") || this.m_pci_bar_4_type.equalsIgnoreCase("Not supported Non-prefetchable 64 bit bar please remove")) {
                            MyTableModel model = (MyTableModel)this.table.getModel();
                            model.data[0][0] = "1:0";
                            model.data[0][1] = this.m_pci_bar_0_type;
                            model.data[0][2] = this.m_pci_bar_0_size;
                            model.data[1][0] = "3:2";
                            model.data[1][1] = this.m_pci_bar_2_type;
                            model.data[1][2] = this.m_pci_bar_2_size;
                            model.data[2][0] = "5:4";
                            model.data[2][1] = this.m_pci_bar_4_type;
                            model.data[2][2] = this.m_pci_bar_4_size;
                            model.data[3][0] = "N/A";
                            model.data[3][1] = "";
                            model.data[3][2] = "";
                            model.data[4][0] = "N/A";
                            model.data[4][1] = "";
                            model.data[4][2] = "";
                            model.data[5][0] = "N/A";
                            model.data[5][1] = "";
                            model.data[5][2] = "";
                            model.data[6][0] = "EXP ROM";
                            model.data[6][1] = this.m_pci_exp_rom_type;
                            model.data[6][2] = this.m_pci_exp_rom_size;
                        } else {
                            MyTableModel model = (MyTableModel)this.table.getModel();
                            model.data[0][0] = "1:0";
                            model.data[0][1] = this.m_pci_bar_0_type;
                            model.data[0][2] = this.m_pci_bar_0_size;
                            model.data[1][0] = "3:2";
                            model.data[1][1] = this.m_pci_bar_2_type;
                            model.data[1][2] = this.m_pci_bar_2_size;
                            model.data[2][0] = "4";
                            model.data[2][1] = this.m_pci_bar_4_type;
                            model.data[2][2] = this.m_pci_bar_4_size;
                            model.data[3][0] = "5";
                            model.data[3][1] = this.m_pci_bar_5_type;
                            model.data[3][2] = this.m_pci_bar_5_size;
                            model.data[4][0] = "N/A";
                            model.data[4][1] = "";
                            model.data[4][2] = "";
                            model.data[5][0] = "N/A";
                            model.data[5][1] = "";
                            model.data[5][2] = "";
                            model.data[6][0] = "EXP ROM";
                            model.data[6][1] = this.m_pci_exp_rom_type;
                            model.data[6][2] = this.m_pci_exp_rom_size;
                        }
                    } else if (this.m_pci_bar_4_type.equalsIgnoreCase("64-bit Prefetchable Memory") || this.m_pci_bar_4_type.equalsIgnoreCase("Not supported Non-prefetchable 64 bit bar please remove")) {
                        MyTableModel model = (MyTableModel)this.table.getModel();
                        model.data[0][0] = "1:0";
                        model.data[0][1] = this.m_pci_bar_0_type;
                        model.data[0][2] = this.m_pci_bar_0_size;
                        model.data[1][0] = "2";
                        model.data[1][1] = this.m_pci_bar_2_type;
                        model.data[1][2] = this.m_pci_bar_2_size;
                        model.data[2][0] = "3";
                        model.data[2][1] = this.m_pci_bar_3_type;
                        model.data[2][2] = this.m_pci_bar_3_size;
                        model.data[3][0] = "5:4";
                        model.data[3][1] = this.m_pci_bar_4_type;
                        model.data[3][2] = this.m_pci_bar_4_size;
                        model.data[4][0] = "N/A";
                        model.data[4][1] = "";
                        model.data[4][2] = "";
                        model.data[5][0] = "N/A";
                        model.data[5][1] = "";
                        model.data[5][2] = "";
                        model.data[6][0] = "EXP ROM";
                        model.data[6][1] = this.m_pci_exp_rom_type;
                        model.data[6][2] = this.m_pci_exp_rom_size;
                    } else {
                        MyTableModel model = (MyTableModel)this.table.getModel();
                        model.data[0][0] = "1:0";
                        model.data[0][1] = this.m_pci_bar_0_type;
                        model.data[0][2] = this.m_pci_bar_0_size;
                        model.data[1][0] = "2";
                        model.data[1][1] = this.m_pci_bar_2_type;
                        model.data[1][2] = this.m_pci_bar_2_size;
                        model.data[2][0] = "3";
                        model.data[2][1] = this.m_pci_bar_3_type;
                        model.data[2][2] = this.m_pci_bar_3_size;
                        model.data[3][0] = "4";
                        model.data[3][1] = this.m_pci_bar_4_type;
                        model.data[3][2] = this.m_pci_bar_4_size;
                        model.data[4][0] = "5";
                        model.data[4][1] = this.m_pci_bar_5_type;
                        model.data[4][2] = this.m_pci_bar_5_size;
                        model.data[5][0] = "N/A";
                        model.data[5][1] = "";
                        model.data[5][2] = "";
                        model.data[6][0] = "EXP ROM";
                        model.data[6][1] = this.m_pci_exp_rom_type;
                        model.data[6][2] = this.m_pci_exp_rom_size;
                    }
                } else if (this.m_pci_bar_2_type.equalsIgnoreCase("64-bit Prefetchable Memory") || this.m_pci_bar_2_type.equalsIgnoreCase("Not supported Non-prefetchable 64 bit bar please remove")) {
                    if (this.m_pci_bar_4_type.equalsIgnoreCase("64-bit Prefetchable Memory")) {
                        MyTableModel model = (MyTableModel)this.table.getModel();
                        model.data[0][0] = "0";
                        model.data[0][1] = this.m_pci_bar_0_type;
                        model.data[0][2] = this.m_pci_bar_0_size;
                        model.data[1][0] = "1";
                        model.data[1][1] = this.m_pci_bar_1_type;
                        model.data[1][2] = this.m_pci_bar_1_size;
                        model.data[2][0] = "3:2";
                        model.data[2][1] = this.m_pci_bar_2_type;
                        model.data[2][2] = this.m_pci_bar_2_size;
                        model.data[3][0] = "5:4";
                        model.data[3][1] = this.m_pci_bar_4_type;
                        model.data[3][2] = this.m_pci_bar_4_size;
                        model.data[4][0] = "N/A";
                        model.data[4][1] = "";
                        model.data[4][2] = "";
                        model.data[5][0] = "N/A";
                        model.data[5][1] = "";
                        model.data[5][2] = "";
                        model.data[6][0] = "EXP ROM";
                        model.data[6][1] = this.m_pci_exp_rom_type;
                        model.data[6][2] = this.m_pci_exp_rom_size;
                    } else {
                        MyTableModel model = (MyTableModel)this.table.getModel();
                        model.data[0][0] = "0";
                        model.data[0][1] = this.m_pci_bar_0_type;
                        model.data[0][2] = this.m_pci_bar_0_size;
                        model.data[1][0] = "1";
                        model.data[1][1] = this.m_pci_bar_1_type;
                        model.data[1][2] = this.m_pci_bar_1_size;
                        model.data[2][0] = "3:2";
                        model.data[2][1] = this.m_pci_bar_2_type;
                        model.data[2][2] = this.m_pci_bar_2_size;
                        model.data[3][0] = "4";
                        model.data[3][1] = this.m_pci_bar_4_type;
                        model.data[3][2] = this.m_pci_bar_4_size;
                        model.data[4][0] = "5";
                        model.data[4][1] = this.m_pci_bar_5_type;
                        model.data[4][2] = this.m_pci_bar_5_size;
                        model.data[5][0] = "N/A";
                        model.data[5][1] = "";
                        model.data[5][2] = "";
                        model.data[6][0] = "EXP ROM";
                        model.data[6][1] = this.m_pci_exp_rom_type;
                        model.data[6][2] = this.m_pci_exp_rom_size;
                    }
                } else if (this.m_pci_bar_4_type.equalsIgnoreCase("64-bit Prefetchable Memory") || this.m_pci_bar_4_type.equalsIgnoreCase("Not supported Non-prefetchable 64 bit bar please remove")) {
                    MyTableModel model = (MyTableModel)this.table.getModel();
                    model.data[0][0] = "0";
                    model.data[0][1] = this.m_pci_bar_0_type;
                    model.data[0][2] = this.m_pci_bar_0_size;
                    model.data[1][0] = "1";
                    model.data[1][1] = this.m_pci_bar_1_type;
                    model.data[1][2] = this.m_pci_bar_1_size;
                    model.data[2][0] = "2";
                    model.data[2][1] = this.m_pci_bar_2_type;
                    model.data[2][2] = this.m_pci_bar_2_size;
                    model.data[3][0] = "3";
                    model.data[3][1] = this.m_pci_bar_3_type;
                    model.data[3][2] = this.m_pci_bar_3_size;
                    model.data[4][0] = "5:4";
                    model.data[4][1] = this.m_pci_bar_4_type;
                    model.data[4][2] = this.m_pci_bar_4_size;
                    model.data[5][0] = "N/A";
                    model.data[5][1] = "";
                    model.data[5][2] = "";
                    model.data[6][0] = "EXP ROM";
                    model.data[6][1] = this.m_pci_exp_rom_type;
                    model.data[6][2] = this.m_pci_exp_rom_size;
                } else {
                    MyTableModel model = (MyTableModel)this.table.getModel();
                    model.data[0][0] = "0";
                    model.data[0][1] = this.m_pci_bar_0_type;
                    model.data[0][2] = this.m_pci_bar_0_size;
                    model.data[1][0] = "1";
                    model.data[1][1] = this.m_pci_bar_1_type;
                    model.data[1][2] = this.m_pci_bar_1_size;
                    model.data[2][0] = "2";
                    model.data[2][1] = this.m_pci_bar_2_type;
                    model.data[2][2] = this.m_pci_bar_2_size;
                    model.data[3][0] = "3";
                    model.data[3][1] = this.m_pci_bar_3_type;
                    model.data[3][2] = this.m_pci_bar_3_size;
                    model.data[4][0] = "4";
                    model.data[4][1] = this.m_pci_bar_4_type;
                    model.data[4][2] = this.m_pci_bar_4_size;
                    model.data[5][0] = "5";
                    model.data[5][1] = this.m_pci_bar_5_type;
                    model.data[5][2] = this.m_pci_bar_5_size;
                    model.data[6][0] = "EXP ROM";
                    model.data[6][1] = this.m_pci_exp_rom_type;
                    model.data[6][2] = this.m_pci_exp_rom_size;
                }
            }
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void modelUpdated(ModelBaseClass model) {
        try {
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String UpdateModel(int row, int col, String value) {
        String returnvalue;
        block13: {
            System.out.println("PCIBAR Into UpdateModel, int row,  int col, String value  : " + row + "\t:\t" + col + "\t:\t" + value);
            returnvalue = "FAILED";
            String newvalue = "FAILED";
            try {
                String pciAvalonPageSize = "";
                boolean selected_pci_addr_width = false;
                String num_BAR = "";
                if (row < 6) {
                    MyTableModel myTableModel = (MyTableModel)this.table.getModel();
                    num_BAR = myTableModel.getValueAt(row, 0).toString().trim().substring(myTableModel.getValueAt(row, 0).toString().trim().length() - 1);
                    String p_pcie_bar_used_bar_n = "p_pcie_bar_used_bar_" + num_BAR;
                    if (col == 1) {
                        String p_pcie_bar_type_bar_n = "p_pcie_bar_type_bar_" + num_BAR;
                        ((WriteablePropertyInterface)this.m_model.getPrivate(p_pcie_bar_type_bar_n)).setValue(value);
                        returnvalue = "SUCCESS";
                    }
                    if (col == 2 && this.m_model.getPrivate(p_pcie_bar_used_bar_n).getValue().equalsIgnoreCase("1")) {
                        String p_pcie_bar_size_bar_n = "p_pcie_bar_size_bar_" + num_BAR;
                        ((WriteablePropertyInterface)this.m_model.getPrivate(p_pcie_bar_size_bar_n)).setValue(value);
                        returnvalue = "SUCCESS";
                    }
                    break block13;
                }
                if (col == 1) {
                    if (value.equalsIgnoreCase("Enable")) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_exp_rom_bar_used")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_exp_rom_bar_used")).setValue("0");
                    }
                } else if (col == 2) {
                    ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_exp_rom_bar_size")).setValue(value);
                }
                returnvalue = "SUCCESS";
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                returnvalue = "FAILED";
            }
            catch (Exception e) {
                e.printStackTrace();
                returnvalue = "FAILED";
            }
        }
        return returnvalue;
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{MVCConstants.getResourceString("PCIE_BARS.Column1"), MVCConstants.getResourceString("PCIE_BARS.Column2"), MVCConstants.getResourceString("PCIE_BARS.Column3")};
        Object[][] data;
        public final Object[] longValues;

        MyTableModel() {
            this.data = new Object[][]{{"0", PCIEBars.this.m_pci_bar_0_type, PCIEBars.this.m_pci_bar_0_size}, {"1", PCIEBars.this.m_pci_bar_1_type, PCIEBars.this.m_pci_bar_1_size}, {"2", PCIEBars.this.m_pci_bar_2_type, PCIEBars.this.m_pci_bar_2_size}, {"3", PCIEBars.this.m_pci_bar_3_type, PCIEBars.this.m_pci_bar_3_size}, {"4", PCIEBars.this.m_pci_bar_4_type, PCIEBars.this.m_pci_bar_4_size}, {"5", PCIEBars.this.m_pci_bar_5_type, PCIEBars.this.m_pci_bar_5_size}, {"EXP-ROM", PCIEBars.this.m_pci_exp_rom_type, PCIEBars.this.m_pci_exp_rom_size}};
            this.longValues = new Object[]{MVCConstants.getResourceString("PCIE_BARS.Column1"), MVCConstants.getResourceString("PCIE_BARS.Column2"), MVCConstants.getResourceString("PCIE_BARS.Column3")};
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            if (col == 1 && row < 1) {
                PCIEBars.this.setUpBARType_FirstRow(PCIEBars.this.table, PCIEBars.this.table.getColumnModel().getColumn(1), row);
                return true;
            }
            if (row == 6 && col == 1) {
                PCIEBars.this.setUpExpROMTypeColumn(PCIEBars.this.table, PCIEBars.this.table.getColumnModel().getColumn(1));
                return true;
            }
            if (row == 6 && col == 2) {
                if (this.getValueAt(row, 1) == "Select to Enable") {
                    return false;
                }
                PCIEBars.this.setUpExpRomBarSizesColumn(PCIEBars.this.table, PCIEBars.this.table.getColumnModel().getColumn(2), row);
                return true;
            }
            if (col != 1 && this.getValueAt(row, 1) == "Select Type to Enable") {
                return false;
            }
            if (row > 0 && (this.getValueAt(row - 1, 1) == "Select Type to Enable" || this.getValueAt(row - 1, 1) == "")) {
                return false;
            }
            if (this.getValueAt(row, 0) == "N/A") {
                return false;
            }
            PCIEBars.this.setUpBARTypeColumn(PCIEBars.this.table, PCIEBars.this.table.getColumnModel().getColumn(1), row);
            PCIEBars.this.setUpBARSizeColumn(PCIEBars.this.table, PCIEBars.this.table.getColumnModel().getColumn(2), row);
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (PCIEBars.this.DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            PCIEBars.this.UpdateModel(row, col, value.toString());
            PCIEBars.this.populateTableData();
            PCIEBars.this.repaint();
            this.fireTableCellUpdated(row, col);
            if (PCIEBars.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }

    class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            MyTableModel TableModel2 = (MyTableModel)table.getModel();
            Object myValue = TableModel2.getValueAt(row, column - 1);
            this.setEnabled(true);
            this.setToolTipText(value.toString());
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }

    public class HeaderRenderer
    extends WLabel
    implements TableCellRenderer {
        private Color fgColor = UIManager.getColor("TableHeader.foreground");
        private Color bgColor = UIManager.getColor("TableHeader.background");
        private Border border = UIManager.getBorder("TableHeader.cellBorder");

        public HeaderRenderer() {
            this.setOpaque(true);
        }

        public void setForegroundColor(Color fgColor) {
            this.fgColor = fgColor;
        }

        public Color getForegroundColor() {
            return this.fgColor;
        }

        public void setBackgroundColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        public Color getBackgroundColor() {
            return this.bgColor;
        }

        public void setBorder(Border border) {
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            HeaderRenderer label = this;
            label.setText(value == null ? "" : " " + value.toString());
            label.setForeground(this.getForegroundColor());
            label.setBackground(this.getBackgroundColor());
            label.setBorder(this.getBorder());
            WTextField wtextfield = new WTextField();
            int rowHeight = wtextfield.getPreferredSize().height;
            label.setPreferredSize(new Dimension(label.getPreferredSize().width, rowHeight));
            this.setEnabled(table == null || table.isEnabled());
            return label;
        }
    }
}

