/*
 * Decompiled with CFR 0.152.
 */
package altera.ipbu.pci_express;

import altera.ipbu.flowbase.SharedObjectsInterface;
import altera.ipbu.flowbase.controls.WCheckBox;
import altera.ipbu.flowbase.controls.WLabel;
import altera.ipbu.flowbase.controls.WPanel;
import altera.ipbu.flowbase.controls.WizardPanelInterface;
import altera.ipbu.flowbase.exceptions.OutOfRangeException;
import altera.ipbu.flowbase.netlist.NetlistBooleanPrivate;
import altera.ipbu.flowbase.netlist.NetlistPrivate;
import altera.ipbu.flowbase.netlist.NetlistPrivateInterface;
import altera.ipbu.flowbase.netlist.model.DiscreteRange;
import altera.ipbu.flowbase.netlist.model.MVCModel;
import altera.ipbu.flowbase.netlist.model.ModelBaseClass;
import altera.ipbu.flowbase.netlist.model.ModelListener;
import altera.ipbu.flowbase.netlist.model.WriteablePropertyInterface;
import altera.ipbu.pci_express.MVCConstants;
import altera.ipbu.pci_express.PCIRegisters;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.MaskFormatter;

public class CapabilitiesPanel
extends WPanel
implements WizardPanelInterface,
ModelListener,
ActionListener,
FocusListener {
    protected SharedObjectsInterface OBJBASE = null;
    protected MVCModel m_model = null;
    protected GridBagConstraints myLayoutConstraints = null;
    private PCIRegisters pcie_ro_registers;
    private WPanel pcie_parent_panel;
    private WPanel pcie_general_capabilities_panel;
    private WPanel pcie_device_capabilities_panel;
    private WPanel pcie_wrapper_panel;
    private WPanel pcie_msi_capabilities_panel;
    private WPanel pcie_slot_capabilities_panel;
    private WCheckBox m_commonclk_chk;
    private WCheckBox m_adv_error_reporting_chk;
    private WCheckBox m_ecrc_chk;
    private WCheckBox m_ecrc_generation_chk;
    private WLabel m_link_port_number_label;
    private JFormattedTextField m_link_port_number_txt;
    private WLabel m_device_number_label;
    private JFormattedTextField m_device_number_txt;
    private WLabel m_tags_supported_label;
    private JComboBox m_tags_supported_combo;
    private WCheckBox m_power_indicator;
    private WCheckBox m_attention_indicator;
    private WCheckBox m_attention_button;
    private WLabel m_msi_message_requested_label;
    private JComboBox m_msi_message_requested_combo;
    private WCheckBox m_msi_message_64bits_address_capable;
    private WCheckBox m_msi_per_vector_masking;
    private WCheckBox m_slot_registers;

    public void setWizardPrivates(NetlistPrivateInterface netPrvt) {
    }

    public boolean onFinish() {
        return true;
    }

    public void onCancel() {
    }

    public void onUpdate() {
        this.m_commonclk_chk.removeActionListener((ActionListener)this);
        this.m_adv_error_reporting_chk.removeActionListener((ActionListener)this);
        this.m_ecrc_chk.removeActionListener((ActionListener)this);
        this.m_ecrc_generation_chk.removeActionListener((ActionListener)this);
        this.m_link_port_number_txt.removeFocusListener(this);
        this.m_tags_supported_combo.removeActionListener(this);
        this.m_power_indicator.removeActionListener((ActionListener)this);
        this.m_attention_indicator.removeActionListener((ActionListener)this);
        this.m_attention_button.removeActionListener((ActionListener)this);
        this.m_msi_message_requested_combo.removeActionListener(this);
        this.m_msi_message_64bits_address_capable.removeActionListener((ActionListener)this);
        this.modelUpdated(this.m_model);
        this.pcie_ro_registers.populateRegisters();
        this.m_commonclk_chk.addActionListener((ActionListener)this);
        this.m_adv_error_reporting_chk.addActionListener((ActionListener)this);
        this.m_ecrc_chk.addActionListener((ActionListener)this);
        this.m_ecrc_generation_chk.addActionListener((ActionListener)this);
        this.m_link_port_number_txt.addFocusListener(this);
        this.m_tags_supported_combo.addActionListener(this);
        this.m_power_indicator.addActionListener((ActionListener)this);
        this.m_attention_indicator.addActionListener((ActionListener)this);
        this.m_attention_button.addActionListener((ActionListener)this);
        this.m_msi_message_requested_combo.addActionListener(this);
        this.m_msi_message_64bits_address_capable.addActionListener((ActionListener)this);
    }

    public void onWizardPageKeyEvent(int keyCode) {
    }

    public WPanel getPanel() {
        return this;
    }

    public void initialize() throws Exception {
        this.m_model = (MVCModel)this.OBJBASE.getModel();
        BoxLayout mainLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(mainLayout);
        this.pcie_ro_registers = new PCIRegisters(this.m_model);
        this.add((Component)((Object)this.pcie_ro_registers));
        this.pcie_parent_panel = new WPanel();
        this.pcie_parent_panel.setLayout((LayoutManager)new GridBagLayout());
        this.pcie_general_capabilities_panel = new WPanel();
        TitledBorder tb1 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MVCConstants.getResourceString("PCIE_General_Capabilities.Title"));
        tb1.setTitleFont(this.getFont());
        this.pcie_general_capabilities_panel.setBorder((Border)tb1);
        this.pcie_general_capabilities_panel.setLayout((LayoutManager)new GridBagLayout());
        this.myLayoutConstraints = new GridBagConstraints();
        this.myLayoutConstraints.gridx = 0;
        this.myLayoutConstraints.gridy = 0;
        this.myLayoutConstraints.weightx = 1.0;
        this.myLayoutConstraints.weighty = 1.0;
        this.myLayoutConstraints.anchor = 17;
        this.m_commonclk_chk = new WCheckBox(MVCConstants.getResourceString("PCIE_Common_Clock"), false);
        this.m_commonclk_chk.setActionCommand(MVCConstants.getResourceString("PCIE_Common_Clock"));
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        this.pcie_general_capabilities_panel.add((Component)this.m_commonclk_chk, (Object)this.myLayoutConstraints);
        this.m_adv_error_reporting_chk = new WCheckBox(MVCConstants.getResourceString("PCIE_Error_Reporting"), false);
        this.m_adv_error_reporting_chk = new WCheckBox(MVCConstants.getResourceString("PCIE_Error_Reporting"), false);
        this.m_adv_error_reporting_chk.setActionCommand(MVCConstants.getResourceString("PCIE_Error_Reporting"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        this.pcie_general_capabilities_panel.add((Component)this.m_adv_error_reporting_chk, (Object)this.myLayoutConstraints);
        this.m_ecrc_chk = new WCheckBox(MVCConstants.getResourceString("PCIE_ECRC_Check"), false);
        this.m_ecrc_chk.setActionCommand(MVCConstants.getResourceString("PCIE_ECRC_Check"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 25, 0, 0);
        this.pcie_general_capabilities_panel.add((Component)this.m_ecrc_chk, (Object)this.myLayoutConstraints);
        this.m_ecrc_generation_chk = new WCheckBox(MVCConstants.getResourceString("PCIE_ECRC_Generation"), false);
        this.m_ecrc_generation_chk.setActionCommand(MVCConstants.getResourceString("PCIE_ECRC_Generation"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 25, 0, 0);
        this.pcie_general_capabilities_panel.add((Component)this.m_ecrc_generation_chk, (Object)this.myLayoutConstraints);
        this.m_link_port_number_label = new WLabel(MVCConstants.getResourceString("PCIE_Link_Port_Number"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(10, 10, 0, 0);
        this.pcie_general_capabilities_panel.add((Component)this.m_link_port_number_label, (Object)this.myLayoutConstraints);
        JTextField setSizeTextField = new JTextField("0xDDD");
        String value = this.m_model.getPrivate("p_pcie_link_port_number").getValue();
        this.myLayoutConstraints.insets = new Insets(10, this.m_link_port_number_label.getPreferredSize().width + 30, 0, 0);
        this.m_link_port_number_txt = new JFormattedTextField(this.createFormatter("0xHH"));
        this.m_link_port_number_txt.setPreferredSize(setSizeTextField.getPreferredSize());
        this.m_link_port_number_txt.setText(value);
        this.pcie_general_capabilities_panel.add((Component)this.m_link_port_number_txt, (Object)this.myLayoutConstraints);
        this.pcie_device_capabilities_panel = new WPanel();
        TitledBorder tb2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MVCConstants.getResourceString("PCIE_Device_Capabilities.Title"));
        tb2.setTitleFont(this.getFont());
        this.pcie_device_capabilities_panel.setBorder((Border)tb2);
        this.pcie_device_capabilities_panel.setLayout((LayoutManager)new GridBagLayout());
        this.myLayoutConstraints = null;
        this.myLayoutConstraints = new GridBagConstraints();
        this.myLayoutConstraints.gridx = 0;
        this.myLayoutConstraints.gridy = 0;
        this.myLayoutConstraints.weightx = 1.0;
        this.myLayoutConstraints.weighty = 1.0;
        this.myLayoutConstraints.anchor = 17;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        this.m_tags_supported_label = new WLabel(MVCConstants.getResourceString("PCIE_Tags_Supported"));
        this.pcie_device_capabilities_panel.add((Component)this.m_tags_supported_label, (Object)this.myLayoutConstraints);
        this.myLayoutConstraints.insets = new Insets(0, this.m_tags_supported_label.getPreferredSize().width + 30, 0, 10);
        int[] sValues = MVCConstants.TAG_OPTIONS;
        Vector<String> vValues = new Vector<String>(sValues.length);
        for (int i = 0; i < sValues.length; ++i) {
            vValues.addElement("    " + sValues[i] + "    ");
        }
        this.m_tags_supported_combo = new JComboBox(vValues);
        this.m_tags_supported_combo.setActionCommand(MVCConstants.getResourceString("PCIE_Tags_Supported"));
        this.pcie_device_capabilities_panel.add((Component)this.m_tags_supported_combo, (Object)this.myLayoutConstraints);
        this.m_power_indicator = new WCheckBox(MVCConstants.getResourceString("PCIE_Power_Indicator"), false);
        this.m_power_indicator.setActionCommand(MVCConstants.getResourceString("PCIE_Power_Indicator"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        this.m_attention_indicator = new WCheckBox(MVCConstants.getResourceString("PCIE_Attention_Indicator"), false);
        this.m_attention_indicator.setActionCommand(MVCConstants.getResourceString("PCIE_Attention_Indicator"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        this.m_attention_button = new WCheckBox(MVCConstants.getResourceString("PCIE_Attention_Button"), false);
        this.m_attention_button.setActionCommand(MVCConstants.getResourceString("PCIE_Attention_Button"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        WLabel dummy_label_0 = new WLabel("\t");
        this.pcie_device_capabilities_panel.add((Component)dummy_label_0, (Object)this.myLayoutConstraints);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        WLabel dummy_label_1 = new WLabel("\t");
        this.pcie_device_capabilities_panel.add((Component)dummy_label_1, (Object)this.myLayoutConstraints);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        WLabel dummy_label_2 = new WLabel("\t");
        this.pcie_device_capabilities_panel.add((Component)dummy_label_2, (Object)this.myLayoutConstraints);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 10, 0, 0);
        WLabel dummy_label_3 = new WLabel("\t");
        this.pcie_device_capabilities_panel.add((Component)dummy_label_3, (Object)this.myLayoutConstraints);
        this.pcie_wrapper_panel = new WPanel();
        this.pcie_wrapper_panel.setLayout((LayoutManager)new GridBagLayout());
        this.myLayoutConstraints = new GridBagConstraints();
        this.myLayoutConstraints.gridx = 0;
        this.myLayoutConstraints.gridy = 0;
        this.myLayoutConstraints.weightx = 1.0;
        this.myLayoutConstraints.weighty = 1.0;
        this.myLayoutConstraints.anchor = 17;
        this.pcie_msi_capabilities_panel = new WPanel();
        TitledBorder tb3 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MVCConstants.getResourceString("PCIE_MSI_Capabilities.Title"));
        tb3.setTitleFont(this.getFont());
        this.pcie_msi_capabilities_panel.setBorder((Border)tb3);
        this.pcie_msi_capabilities_panel.setLayout((LayoutManager)new GridBagLayout());
        this.myLayoutConstraints = null;
        this.myLayoutConstraints = new GridBagConstraints();
        this.myLayoutConstraints.gridx = 0;
        this.myLayoutConstraints.gridy = 0;
        this.myLayoutConstraints.weightx = 1.0;
        this.myLayoutConstraints.weighty = 1.0;
        this.myLayoutConstraints.anchor = 17;
        this.myLayoutConstraints.insets = new Insets(5, 10, 0, 0);
        this.m_msi_message_requested_label = new WLabel(MVCConstants.getResourceString("PCIE_MSI_Message_Requested"));
        this.pcie_msi_capabilities_panel.add((Component)this.m_msi_message_requested_label, (Object)this.myLayoutConstraints);
        this.myLayoutConstraints.insets = new Insets(5, this.m_msi_message_requested_label.getPreferredSize().width + 30, 0, 0);
        int[] sValues2 = MVCConstants.MSI_MESSAGE_OPTIONS;
        Vector<String> vValues2 = new Vector<String>(sValues2.length);
        for (int i = 0; i < sValues2.length; ++i) {
            vValues2.addElement("    " + sValues2[i] + "    ");
        }
        this.m_msi_message_requested_combo = new JComboBox(vValues2);
        this.m_msi_message_requested_combo.setActionCommand(MVCConstants.getResourceString("PCIE_MSI_Message_Requested"));
        this.pcie_msi_capabilities_panel.add((Component)this.m_msi_message_requested_combo, (Object)this.myLayoutConstraints);
        this.m_msi_message_64bits_address_capable = new WCheckBox(MVCConstants.getResourceString("PCIE_MSI_Message_64bits"), false);
        this.m_msi_message_64bits_address_capable.setActionCommand(MVCConstants.getResourceString("PCIE_MSI_Message_64bits"));
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(0, 5, 0, 0);
        this.pcie_msi_capabilities_panel.add((Component)this.m_msi_message_64bits_address_capable, (Object)this.myLayoutConstraints);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(6, 10, 0, 0);
        WLabel dummy_label0 = new WLabel("\t");
        this.pcie_msi_capabilities_panel.add((Component)dummy_label0, (Object)this.myLayoutConstraints);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(6, 10, 0, 0);
        WLabel dummy_label1 = new WLabel("\t");
        this.pcie_msi_capabilities_panel.add((Component)dummy_label1, (Object)this.myLayoutConstraints);
        ++this.myLayoutConstraints.gridy;
        this.myLayoutConstraints.insets = new Insets(7, 10, 0, 0);
        WLabel dummy_label2 = new WLabel("\t");
        this.pcie_msi_capabilities_panel.add((Component)dummy_label2, (Object)this.myLayoutConstraints);
        GridBagConstraints theLayoutConstraints = new GridBagConstraints();
        theLayoutConstraints.gridx = 0;
        theLayoutConstraints.gridy = 0;
        theLayoutConstraints.weightx = 1.0;
        theLayoutConstraints.weighty = 1.0;
        theLayoutConstraints.anchor = 11;
        theLayoutConstraints.fill = 1;
        this.pcie_wrapper_panel.add((Component)this.pcie_msi_capabilities_panel, (Object)theLayoutConstraints);
        GridBagConstraints parentLayoutConstraints = new GridBagConstraints();
        parentLayoutConstraints.gridx = 0;
        parentLayoutConstraints.gridy = 0;
        parentLayoutConstraints.weightx = 1.0;
        parentLayoutConstraints.weighty = 1.0;
        parentLayoutConstraints.anchor = 17;
        parentLayoutConstraints.fill = 1;
        this.pcie_parent_panel.add((Component)this.pcie_general_capabilities_panel, (Object)parentLayoutConstraints);
        ++parentLayoutConstraints.gridx;
        this.pcie_parent_panel.add((Component)this.pcie_device_capabilities_panel, (Object)parentLayoutConstraints);
        ++parentLayoutConstraints.gridx;
        this.pcie_parent_panel.add((Component)this.pcie_wrapper_panel, (Object)parentLayoutConstraints);
        this.add((Component)this.pcie_parent_panel);
        this.OBJBASE.getModel().addModelListener((ModelListener)this);
        this.modelUpdated(this.OBJBASE.getModel());
        this.m_commonclk_chk.addActionListener((ActionListener)this);
        this.m_adv_error_reporting_chk.addActionListener((ActionListener)this);
        this.m_ecrc_chk.addActionListener((ActionListener)this);
        this.m_ecrc_generation_chk.addActionListener((ActionListener)this);
        this.m_link_port_number_txt.addFocusListener(this);
        this.m_tags_supported_combo.addActionListener(this);
        this.m_power_indicator.addActionListener((ActionListener)this);
        this.m_attention_indicator.addActionListener((ActionListener)this);
        this.m_attention_button.addActionListener((ActionListener)this);
        this.m_msi_message_requested_combo.addActionListener(this);
        this.m_msi_message_64bits_address_capable.addActionListener((ActionListener)this);
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public void uninitialize() throws Exception {
        this.OBJBASE.getModel().removeModelListener((ModelListener)this);
    }

    public void setSharedObjects(SharedObjectsInterface share) {
        this.OBJBASE = share;
    }

    public Object getNextGenerationObject(String id) {
        return this;
    }

    public String getName() {
        return MVCConstants.getResourceString("Capabilities.text", "System Settings");
    }

    public void modelUpdated(ModelBaseClass model) {
        try {
            NetlistBooleanPrivate param_link_common_clock = (NetlistBooleanPrivate)model.getPrivate("p_pcie_link_common_clock");
            boolean btemp = param_link_common_clock.getBooleanValue();
            if (param_link_common_clock.getBooleanValue()) {
                this.m_commonclk_chk.setSelected(true);
            } else {
                this.m_commonclk_chk.setSelected(false);
            }
            this.m_commonclk_chk.setEnabled(param_link_common_clock.isEnabled());
            NetlistBooleanPrivate param_advanced_error_reporting = (NetlistBooleanPrivate)model.getPrivate("p_pcie_advanced_error_reporting");
            if (param_advanced_error_reporting.getBooleanValue()) {
                this.m_adv_error_reporting_chk.setSelected(true);
            } else {
                this.m_adv_error_reporting_chk.setSelected(false);
            }
            this.m_adv_error_reporting_chk.setEnabled(param_advanced_error_reporting.isEnabled());
            NetlistBooleanPrivate param_ecrc_check = (NetlistBooleanPrivate)model.getPrivate("p_pcie_ecrc_check");
            if (param_ecrc_check.getBooleanValue()) {
                this.m_ecrc_chk.setSelected(true);
            } else {
                this.m_ecrc_chk.setSelected(false);
            }
            this.m_ecrc_chk.setEnabled(param_ecrc_check.isEnabled());
            NetlistBooleanPrivate param_ecrc_generation = (NetlistBooleanPrivate)model.getPrivate("p_pcie_ecrc_generation");
            if (param_ecrc_generation.getBooleanValue()) {
                this.m_ecrc_generation_chk.setSelected(true);
            } else {
                this.m_ecrc_generation_chk.setSelected(false);
            }
            this.m_ecrc_generation_chk.setEnabled(param_ecrc_generation.isEnabled());
            NetlistPrivate param_link_port_number = this.m_model.getPrivate("p_pcie_link_port_number");
            this.m_link_port_number_txt.setText(param_link_port_number.getValue());
            this.m_link_port_number_txt.setEnabled(param_link_port_number.isEnabled());
            JComboBox jcmbBox = null;
            NetlistPrivate param_tags_supported = model.getPrivate("p_pcie_tag_supported");
            if (param_tags_supported.hasRange()) {
                DiscreteRange range = (DiscreteRange)param_tags_supported.getRange();
                Component[] components = this.pcie_device_capabilities_panel.getComponents();
                for (int i = 0; !(i >= components.length || components[i] instanceof JComboBox && (jcmbBox = (JComboBox)components[i]).getActionCommand().equals(MVCConstants.getResourceString("PCIE_Tags_Supported"))); ++i) {
                }
                jcmbBox.removeAllItems();
                String[] items = range.getValidValues();
                for (int i = 0; i < items.length; ++i) {
                    jcmbBox.addItem("    " + items[i] + "    ");
                }
            }
            jcmbBox.setSelectedItem("    " + param_tags_supported.getValue() + "    ");
            jcmbBox.setEnabled(param_tags_supported.isEnabled());
            NetlistBooleanPrivate param_power_indicator = (NetlistBooleanPrivate)model.getPrivate("p_pcie_power_indicator");
            if (param_power_indicator.getBooleanValue()) {
                this.m_power_indicator.setSelected(true);
            } else {
                this.m_power_indicator.setSelected(false);
            }
            this.m_power_indicator.setEnabled(param_power_indicator.isEnabled());
            NetlistBooleanPrivate param_attention_indicator = (NetlistBooleanPrivate)model.getPrivate("p_pcie_attention_indicator");
            if (param_attention_indicator.getBooleanValue()) {
                this.m_attention_indicator.setSelected(true);
            } else {
                this.m_attention_indicator.setSelected(false);
            }
            this.m_attention_indicator.setEnabled(param_attention_indicator.isEnabled());
            NetlistBooleanPrivate param_attention_button = (NetlistBooleanPrivate)model.getPrivate("p_pcie_attention_button");
            if (param_attention_button.getBooleanValue()) {
                this.m_attention_button.setSelected(true);
            } else {
                this.m_attention_button.setSelected(false);
            }
            this.m_attention_button.setEnabled(param_attention_button.isEnabled());
            NetlistPrivate param_msi_message_requested = model.getPrivate("p_pcie_msi_message_requested");
            if (param_msi_message_requested.hasRange()) {
                DiscreteRange range = (DiscreteRange)param_msi_message_requested.getRange();
                Component[] components = this.pcie_msi_capabilities_panel.getComponents();
                for (int i = 0; !(i >= components.length || components[i] instanceof JComboBox && (jcmbBox = (JComboBox)components[i]).getActionCommand().equals(MVCConstants.getResourceString("PCIE_MSI_Message_Requested"))); ++i) {
                }
                jcmbBox.removeAllItems();
                String[] items = range.getValidValues();
                for (int i = 0; i < items.length; ++i) {
                    jcmbBox.addItem("    " + items[i] + "    ");
                }
            }
            jcmbBox.setSelectedItem("    " + param_msi_message_requested.getValue() + "    ");
            jcmbBox.setEnabled(param_msi_message_requested.isEnabled());
            NetlistBooleanPrivate param_msi_message_64bits = (NetlistBooleanPrivate)model.getPrivate("p_pcie_msi_message_64bits_address_capable");
            if (param_msi_message_64bits.getBooleanValue()) {
                this.m_msi_message_64bits_address_capable.setSelected(true);
            } else {
                this.m_msi_message_64bits_address_capable.setSelected(false);
            }
            btemp = param_msi_message_64bits.isEnabled();
            this.m_msi_message_64bits_address_capable.setEnabled(param_msi_message_64bits.isEnabled());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        WCheckBox myWCheckBox = null;
        try {
            if (this.m_model.isNotifying()) {
                return;
            }
            NetlistPrivate myTestPrivate = null;
            String actionCommand = ae.getActionCommand();
            if (actionCommand.equals(MVCConstants.getResourceString("PCIE_Common_Clock"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_link_common_clock");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_link_common_clock")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_link_common_clock")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_Error_Reporting"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_advanced_error_reporting");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_advanced_error_reporting")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_advanced_error_reporting")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_ECRC_Check"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_ecrc_check");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_ecrc_check")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_ecrc_check")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_ECRC_Generation"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_ecrc_generation");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_ecrc_generation")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_ecrc_generation")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_Tags_Supported"))) {
                JComboBox jcmbBox = null;
                jcmbBox = (JComboBox)ae.getSource();
                int selectedIndex = jcmbBox.getSelectedIndex();
                if (selectedIndex != -1 && (myTestPrivate = this.m_model.getPrivate("p_pcie_tag_supported")) != null) {
                    ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_tag_supported")).setValue(jcmbBox.getSelectedItem().toString().trim());
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_Power_Indicator"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_power_indicator");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_power_indicator")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_power_indicator")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_Attention_Indicator"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_attention_indicator");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_attention_indicator")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_attention_indicator")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_Attention_Button"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_attention_button");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_attention_button")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_attention_button")).setValue("0");
                    }
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_MSI_Message_Requested"))) {
                JComboBox jcmbBox = null;
                jcmbBox = (JComboBox)ae.getSource();
                int selectedIndex = jcmbBox.getSelectedIndex();
                if (selectedIndex != -1 && (myTestPrivate = this.m_model.getPrivate("p_pcie_msi_message_requested")) != null) {
                    ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_msi_message_requested")).setValue(jcmbBox.getSelectedItem().toString().trim());
                }
            } else if (actionCommand.equals(MVCConstants.getResourceString("PCIE_MSI_Message_64bits"))) {
                myWCheckBox = (WCheckBox)ae.getSource();
                myTestPrivate = this.m_model.getPrivate("p_pcie_msi_message_64bits_address_capable");
                if (myTestPrivate != null) {
                    if (myWCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_msi_message_64bits_address_capable")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)this.m_model.getPrivate("p_pcie_msi_message_64bits_address_capable")).setValue("0");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.m_link_port_number_txt.removeFocusListener(this);
        this.m_link_port_number_txt.setText(this.setValue("p_pcie_link_port_number", this.m_link_port_number_txt.getText(), this.m_link_port_number_label.getText()));
        this.m_link_port_number_txt.addFocusListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setValue(String name, String inputVal, String description) {
        String returnvalue;
        block8: {
            returnvalue = inputVal;
            String oldvalue = "";
            try {
                oldvalue = this.m_model.getPrivate(name).getValue();
                if (!inputVal.trim().equals("0x")) {
                    if (inputVal.toString().charAt(0) != '0' || inputVal.toString().charAt(1) != 'x' && inputVal.toString().charAt(1) != 'X') {
                        inputVal = "0x" + inputVal.toString();
                    }
                    inputVal = inputVal.replaceAll("\\s", "");
                    ((WriteablePropertyInterface)this.m_model.getPrivate(name)).setValue(inputVal.trim());
                    returnvalue = this.m_model.getPrivate(name).getValue();
                    break block8;
                }
                returnvalue = oldvalue;
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog((Component)((Object)this), iae.getMessage().replaceAll(name, description), "Error", 0);
                returnvalue = oldvalue;
            }
            catch (OutOfRangeException ore) {
                JOptionPane.showMessageDialog((Component)((Object)this), ore.getMessage().replaceAll(name, description), "Error", 0);
                returnvalue = oldvalue;
            }
            catch (Exception e) {
                e.printStackTrace();
                returnvalue = oldvalue;
            }
        }
        return returnvalue;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

