/*
 * Decompiled with CFR 0.152.
 */
package altera.ipbu.pci_express;

import altera.ipbu.flowbase.netlist.NetlistBooleanPrivate;
import altera.ipbu.flowbase.netlist.NetlistPrivate;
import altera.ipbu.flowbase.netlist.model.MVCModel;
import altera.ipbu.flowbase.netlist.model.ModelBaseClass;
import altera.ipbu.flowbase.netlist.model.ModelListener;
import altera.ipbu.flowbase.netlist.model.WriteablePropertyInterface;
import altera.ipbu.pci_express.MVCConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.border.TitledBorder;

public class ALT2GXBDialog
extends JDialog
implements ModelListener {
    private static final long serialVersionUID = 1L;
    private static final String m_dialogTitle = MVCConstants.getResourceString("PCIE_ALT2GXB_Config.Title");
    private MVCModel m_model = null;
    private JCheckBox m_enable_fast_recovery;
    private JCheckBox m_rate_match_fifo;
    private boolean original_enable_fast_recovery_value;
    private boolean original_rate_match_fifo_value;

    public ALT2GXBDialog(Frame m_parent, MVCModel model) throws HeadlessException {
        super(m_parent, m_dialogTitle, true);
        this.m_model = model;
        JPanel m_mainPanel = new JPanel();
        m_mainPanel.setLayout(new BoxLayout(m_mainPanel, 1));
        m_mainPanel.add(new FastRecoveryPanel());
        m_mainPanel.add(new RateMatchPanel());
        m_mainPanel.add(new ButtonPanel());
        this.init();
        this.m_model.addModelListener(this);
        this.modelUpdated(this.m_model);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                new CancelAction().actionPerformed(new ActionEvent(this, 101, "fireCalcel"));
            }
        });
        this.getContentPane().add(m_mainPanel);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)d.getWidth() / 2;
        int y = 0;
        this.setLocation(x, y);
        this.pack();
    }

    private void init() {
        try {
            NetlistBooleanPrivate param_enable_fast_recovery = (NetlistBooleanPrivate)this.m_model.getPrivate("p_pcie_enable_fast_recovery");
            this.original_enable_fast_recovery_value = param_enable_fast_recovery.getBooleanValue();
            NetlistBooleanPrivate param_rate_match_fifo = (NetlistBooleanPrivate)this.m_model.getPrivate("p_pcie_rate_match_fifo");
            this.original_rate_match_fifo_value = param_rate_match_fifo.getBooleanValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.init();
    }

    public void modelUpdated(ModelBaseClass model) {
        try {
            NetlistBooleanPrivate param_enable_fast_recovery = (NetlistBooleanPrivate)model.getPrivate("p_pcie_enable_fast_recovery");
            if (param_enable_fast_recovery.getBooleanValue()) {
                this.m_enable_fast_recovery.setSelected(true);
            } else {
                this.m_enable_fast_recovery.setSelected(false);
            }
            this.m_enable_fast_recovery.setEnabled(param_enable_fast_recovery.isEnabled());
            NetlistBooleanPrivate param_rate_match_fifo = (NetlistBooleanPrivate)model.getPrivate("p_pcie_rate_match_fifo");
            if (param_rate_match_fifo.getBooleanValue()) {
                this.m_rate_match_fifo.setSelected(true);
            } else {
                this.m_rate_match_fifo.setSelected(false);
            }
            this.m_rate_match_fifo.setEnabled(param_rate_match_fifo.isEnabled());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class FinishAction
    implements ActionListener {
        FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.err.println("finish action fired...");
            ALT2GXBDialog.this.getRootPane().getParent().setVisible(false);
        }
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                System.err.println("cancel action fired...");
                if (ALT2GXBDialog.this.original_enable_fast_recovery_value) {
                    ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_enable_fast_recovery")).setValue("1");
                } else {
                    ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_enable_fast_recovery")).setValue("0");
                }
                if (ALT2GXBDialog.this.original_rate_match_fifo_value) {
                    ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_rate_match_fifo")).setValue("1");
                } else {
                    ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_rate_match_fifo")).setValue("0");
                }
                ALT2GXBDialog.this.getRootPane().getParent().setVisible(false);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    private class ButtonPanel
    extends JPanel {
        private JButton m_cancelBtn;
        private JButton m_acceptBtn;

        ButtonPanel() {
            TitledBorder tb1 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
            this.setBorder(tb1);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 5, 5, 5), this.getBorder()), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
            this.m_cancelBtn = new JButton();
            this.m_cancelBtn.setText("Cancel");
            this.m_cancelBtn.addActionListener(new CancelAction());
            this.m_acceptBtn = new JButton();
            this.m_acceptBtn.setText("Finish");
            this.m_acceptBtn.addActionListener(new FinishAction());
            this.add(this.m_cancelBtn);
            this.add(this.m_acceptBtn);
        }
    }

    private class RateMatchPanel
    extends JPanel
    implements ActionListener {
        RateMatchPanel() {
            GridBagConstraints myLayoutConstraints = null;
            this.setLayout(new GridBagLayout());
            myLayoutConstraints = new GridBagConstraints();
            myLayoutConstraints.gridx = 0;
            myLayoutConstraints.gridy = 0;
            myLayoutConstraints.weightx = 1.0;
            myLayoutConstraints.weighty = 1.0;
            myLayoutConstraints.anchor = 17;
            TitledBorder tb1 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
            this.setBorder(tb1);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.getBorder()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            ALT2GXBDialog.this.m_rate_match_fifo = new JCheckBox(MVCConstants.getResourceString("PCIE_ALT2GXB_RM_Fifo"), false);
            ALT2GXBDialog.this.m_rate_match_fifo.addActionListener(this);
            ++myLayoutConstraints.gridy;
            this.add((Component)ALT2GXBDialog.this.m_rate_match_fifo, myLayoutConstraints);
            JTextArea myTextPaneLabel = new JTextArea(9, 23);
            myTextPaneLabel.setLineWrap(true);
            myTextPaneLabel.setWrapStyleWord(true);
            myTextPaneLabel.setEditable(false);
            LookAndFeel.installBorder(myTextPaneLabel, "Label.border");
            LookAndFeel.installColorsAndFont(myTextPaneLabel, "Label.background", "Label.foreground", "Label.font");
            myTextPaneLabel.setText(MVCConstants.getResourceString("PCIE_ALT2GXB_RM_Fifo_Text"));
            ++myLayoutConstraints.gridy;
            this.add((Component)myTextPaneLabel, myLayoutConstraints);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                JCheckBox myCheckBox = (JCheckBox)ae.getSource();
                NetlistPrivate thisPrivate = ALT2GXBDialog.this.m_model.getPrivate("p_pcie_rate_match_fifo");
                if (thisPrivate != null) {
                    if (myCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_rate_match_fifo")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_rate_match_fifo")).setValue("0");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class FastRecoveryPanel
    extends JPanel
    implements ActionListener {
        FastRecoveryPanel() {
            GridBagConstraints myLayoutConstraints = null;
            this.setLayout(new GridBagLayout());
            myLayoutConstraints = new GridBagConstraints();
            myLayoutConstraints.gridx = 0;
            myLayoutConstraints.gridy = 0;
            myLayoutConstraints.weightx = 1.0;
            myLayoutConstraints.weighty = 1.0;
            myLayoutConstraints.anchor = 17;
            TitledBorder tb1 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
            this.setBorder(tb1);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.getBorder()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            ++myLayoutConstraints.gridy;
            ALT2GXBDialog.this.m_enable_fast_recovery = new JCheckBox(MVCConstants.getResourceString("PCIE_ALT2GXB_Fast_Recovery"), false);
            ALT2GXBDialog.this.m_enable_fast_recovery.addActionListener(this);
            this.add((Component)ALT2GXBDialog.this.m_enable_fast_recovery, myLayoutConstraints);
            JTextArea myTextPaneLabel = new JTextArea(6, 23);
            myTextPaneLabel.setLineWrap(true);
            myTextPaneLabel.setWrapStyleWord(true);
            myTextPaneLabel.setEditable(false);
            LookAndFeel.installBorder(myTextPaneLabel, "Label.border");
            LookAndFeel.installColorsAndFont(myTextPaneLabel, "Label.background", "Label.foreground", "Label.font");
            myTextPaneLabel.setText(MVCConstants.getResourceString("PCIE_ALT2GXB_Fast_Recovery_Text"));
            ++myLayoutConstraints.gridy;
            this.add((Component)myTextPaneLabel, myLayoutConstraints);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                JCheckBox myCheckBox = (JCheckBox)ae.getSource();
                NetlistPrivate thisPrivate = ALT2GXBDialog.this.m_model.getPrivate("p_pcie_enable_fast_recovery");
                if (thisPrivate != null) {
                    if (myCheckBox.isSelected()) {
                        ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_enable_fast_recovery")).setValue("1");
                    } else {
                        ((WriteablePropertyInterface)ALT2GXBDialog.this.m_model.getPrivate("p_pcie_enable_fast_recovery")).setValue("0");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

