# (C) 2001-2023 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.



#**************************************************************
# Create input reference Clocks
#**************************************************************
create_clock -name "pll_refclk0" -period "156.25 MHz" [get_ports "pll_refclk0"]
create_clock -name "reg_clk"    -period "100 MHz"   [get_ports "reg_clk"]
#create_clock -name "iopll_refclk"    -period "100 MHz"   [get_ports "iopll_refclk"]
 
 
 
#create_clock -period "125 MHz" -name {clk_125} [get_ports clk_125]
#create_clock -period "644.53125 MHz" -name {refclk_10g} [get_ports refclk_10g]
 
# derive_pll_clocks -create_base_clocks
derive_clock_uncertainty
 
#**************************************************************
# Set False Path for alt_mge_reset_synchronizer
#**************************************************************
set reset_sync_aclr_counter 0
set reset_sync_clrn_counter 0
set reset_sync_aclr_collection [get_pins -compatibility_mode -nocase -nowarn *alt_mge_reset_synchronizer:*|alt_mge_reset_synchronizer_int_chain*|aclr]
set reset_sync_clrn_collection [get_pins -compatibility_mode -nocase -nowarn *alt_mge_reset_synchronizer:*|alt_mge_reset_synchronizer_int_chain*|clrn]
 
foreach_in_collection reset_sync_aclr_pin $reset_sync_aclr_collection {
    set reset_sync_aclr_counter [expr $reset_sync_aclr_counter + 1]
}
 
foreach_in_collection reset_sync_clrn_pin $reset_sync_clrn_collection {
    set reset_sync_clrn_counter [expr $reset_sync_clrn_counter + 1]
}
 
if {$reset_sync_aclr_counter > 0} {
    set_false_path -to [get_pins -compatibility_mode -nocase *alt_mge_reset_synchronizer:*|alt_mge_reset_synchronizer_int_chain*|aclr]
}
 
if {$reset_sync_clrn_counter > 0} {
    set_false_path -to [get_pins -compatibility_mode -nocase *alt_mge_reset_synchronizer:*|alt_mge_reset_synchronizer_int_chain*|clrn]
}
 
set_clock_groups -asynchronous -group reg_clk -group pll_refclk0
set_clock_groups -asynchronous -group reg_clk -group {alt_mge_multi_channel|core_iopll|altera_iopll_0_outclk0}
set_clock_groups -asynchronous -group {alt_mge_multi_channel|u_channel|u1|altera_eth_tse_0|i_nd_native_phyip_0|tx_clkout2|ch23} -group {alt_mge_multi_channel|core_iopll|altera_iopll_0_outclk0}
#set_clock_groups -asynchronous -group {f_top|alt_e25_f_0|dut|f_xcvr_25g|tx_clkout2|ch7} -group {f_top|alt_e25_f_0|dut|f_xcvr_25g|rx_clkout2|ch7}
#set_clock_groups -asynchronous -group {f_top|alt_e25_f_0|dut|f_xcvr_25g|rx_clkout|ch7} -group {f_top|alt_e25_f_0|dut|f_xcvr_25g|tx_clkout|ch7}
 
# False path to 1588 traffic controller (this variant does not support 1588 in 17.1)
#set_false_path -from [get_registers {ETH_TRAFFIC_CTRL_PAIR_CHANNEL[*].eth_traffic_controller|eth_1588_traffic_controller_u0|*}]
#set_false_path -to [get_registers {ETH_TRAFFIC_CTRL_PAIR_CHANNEL[*].eth_traffic_controller|eth_1588_traffic_controller_u0|*}]
 
# add constraint for JTAG
create_clock -name altera_reserved_tck [get_ports {altera_reserved_tck}] -period 16MHz  
if { [string equal quartus_fit \$::TimeQuestInfo(nameofexecutable)] } { set_max_delay -to [get_ports { altera_reserved_tdo } ] 0 }
set_clock_groups -asynchronous -group {altera_reserved_tck}
set_clock_groups -asynchronous -group {reg_clk}
