# Copyright(c) 2020 - 2020 Intel Corporation
# For licensing information, see the file 'LICENSE' in the root folder

# Current version of pysv_fpga package
# (only edit inside the quotes of the next line, which must be the first line)
__version__ = '0.1.0'


# __version__ must be the first real line, for the setup.py convention


"""
version file; also a script that reports version and path of the carbyn package

Usage:   python -m pysv_fpga.version
"""
import os


class Info(object):
    """
     Simple version info about a python package, according to a version.py file
     convention.

     The convention is to instantiate this class inside a version.py file
     that sits in the top dir of the package, like so:

         info = Info(__version__, __file__)
    """

    def __init__(self, version, version_file):
        """
        Initialize package version info

        :param version: the version string of the package
        :param version_file: the location of the version.py file (or any file
            that sits in the top dir of the package)

        Example, in a version.py file:

            info = Info(__version__, __file__)
        """
        self.name = os.path.basename(os.path.dirname(os.path.abspath(
            version_file)))
        self.version = version
        self.location = os.path.dirname(os.path.abspath(version_file))

    def __repr__(self):
        return ('{name: "%s", version: "%s", location: "%s"}'
                % (self.name, self.version, self.location))

    def __str__(self):
        info_str = "%s %s   (%s)" % (self.name, self.version, self.location)
        return info_str


info = Info(__version__, __file__)


if __name__ == '__main__':
    import sys
    sys.stdout.write(str(info))
    sys.stdout.write("\n")
