import os, sys, re
import namednodes
import namednodes.accesses
from namednodes.discoveries.socket import SocketDiscovery

__thisdir__ = os.path.dirname(os.path.abspath(__file__))

class ProjectFPGADiscovery(SocketDiscovery):
    devices = {}
    available_devices = {}

    socket_def = namednodes.GetComponentFromFile(os.path.join(__thisdir__, "blank_socket.lmdb"))
    known_devtypes = {
            'whr_toolkit':{'module':'pysv_fpga.ptile',
                           'method':'add_whr_toolkit'},
            'gdr_eth_toolkit':{'module':'pysv_fpga.ftile',
                           'method':'add_gdr_eth_toolkit'},
        }

    def __init__(self, *args, **kwargs):
        # typical discovery initialization
        super(ProjectFPGADiscovery, self).__init__(*args, **kwargs)

    def register_device(self, path, devtype, service_type='master'):
        if devtype not in self.known_devtypes:
            raise Exception('Unknown device tyupe %s'%devtype)
        self.devices[path] = (devtype, service_type)
        self.get_all(refresh=True, stop_on_error=True)
        return self.available_devices[path]

    def find_all(self):
        '''
        Create fpga objects based on what is registered
        '''
        fpgas = {}
        for path, (devtype, service_type) in self.devices.items():
            match = re.search('/devices/(?P<fpga>[^/]*).*', path)
            fpga_identifier = match.groupdict()['fpga']
            if fpga_identifier not in fpgas:
                fpgas[fpga_identifier] = fpga = self.socket_def.create('fpga%d'%len(fpgas))
                fpga.access_classes['AccessField'] = namednodes.accesses.register.AccessField
            else:
                fpga = fpgas[fpga_identifier]

            import importlib
            module = importlib.import_module( self.known_devtypes[devtype]['module'] )
            method = getattr(module, self.known_devtypes[devtype]['method'])
            self.available_devices[path] = method(fpga, path, service_type)

        # Convert sockets to list
        fpgas = list(fpgas.values())

        return fpgas
