import importlib
import namednodes
namednodes.settings.LMDB_FORCE_RO = True

from . import fpga_discovery
# so that we don't accidently reregister if some other project calls back to our init
_registered = False

def init(force=False):
    # if we have already run and no one is debugging/forcing this, do not proceed
    global _registered
    if _registered and not force:
        return
    # make sure we don't come through here twice
    _registered = True

    # Tell namednodes not to override components.socket
    # This allows us to combine Components and namednodes in the same session
    import namednodes.discoveries.socket
    namednodes.discoveries.socket.SocketDiscovery.override_components_socket = False

    import namednodes.discovery
    namednodes.discovery.register("fpga", fpga_discovery.ProjectFPGADiscovery())
