#!/usr/bin/env python
import sys as _sys

server=None

def quit():
    global server
    if server:
        server.shutdown_flag.set()
    raise SystemExit

def main():
    import os
    import importlib
    import namednodes

    global server

    import __main__
    __main__.sv = namednodes.sv
    __main__.quit = quit

    from pysv_fpga.commands.general import Commands
    __main__.commands = Commands()

    package = os.path.abspath(__file__).split(os.sep)[-2]
    rpcserver = importlib.import_module('%s.rpcserver'%package)
    server = rpcserver.Server()
    server.start()

    namednodes.settings.PROJECT = package

    print('Exit using "quit()" to close server')
    os.environ['PYTHONINSPECT'] = 'pysv'

if __name__ == "__main__":
    try:
        main()
    except SystemExit:
        input("Error....Press Enter to close window")
        _sys.exit(1)
    except:
        import traceback
        traceback.print_exc()
        input("Error....Press Enter to close window")
        _sys.exit(2)
