#!/usr/bin/env python
##############################################################################
# INTEL CONFIDENTIAL
# Copyright 2005 2006 Intel Corporation All Rights Reserved.
#
# The source code contained or described herein and all documents related
# to the source code (Material) are owned by Intel Corporation or its
# suppliers or licensors. Title to the Material remains with Intel Corp-
# oration or its suppliers and licensors. The Material may contain trade
# secrets and proprietary and confidential information of Intel Corpor-
# ation and its suppliers and licensors, and is protected by worldwide
# copyright and trade secret laws and treaty provisions. No part of the
# Material may be used, copied, reproduced, modified, published, uploaded,
# posted, transmitted, distributed, or disclosed in any way without
# Intel's prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellect-
# ual property right is granted to or conferred upon you by disclosure or
# delivery of the Materials, either expressly, by implication, inducement,
# estoppel or otherwise. Any license under such intellectual property
# rights must be express and approved by Intel in writing.
##############################################################################

"""
    INTEL CONFIDENTIAL - DO NOT RE-DISTRUBUTE
    Copyright 2010 Intel Corporation All Rights Reserved.

    CVS/SVN information:
        $Author$
        $Revision$
        $Date$
        $Log: whrPhyMargin.py,v $
"""

###############################################################################
##                                                                            #
##      imports & general module setup                                        #
##                                                                            #
###############################################################################

from __future__ import print_function
from __future__ import division

import pysv_fpga.ptile.whrPhy as w
w._quiet=True
w._initStubMode=False
w.main()

import string
import sys

from time import time
from math import ceil
from math import floor
from time import sleep
from time import strftime
from copy import deepcopy
from namednodes.utils.bitmanip import bits

_log = w._log
_log.setFile(str.replace(str(sys.argv[0]), ".py", "") + ".log")
rpcHdr = []

###############################################################################
##                                                                            #
##      global variables: lambda functions                                    #
##                                                                            #
###############################################################################

## formula contains variable 'x'; replace 'x' w/ 'value' then eval
_formula        = lambda value, formula: eval(formula.replace("x", str(value))) # nosec (evaluation of internally defined, semi-static string)

###############################################################################
##                                                                            #
##      global variables: program controlled                                  #
##                                                                            #
###############################################################################

_maskDict   = {  "u":{ 9.6:[ 9.0, 20.0],
                      10.4:[ 9.0, 20.0],
                      11.2:[ 9.0, 20.0]},
                 "p":{ 2.5:[ 9.0, 20.0],
                       5.0:[ 9.0, 20.0],
                       8.0:[ 9.0, 20.0],
                      16.0:[ 9.0, 20.0]}}

_tmpVocList= ["dseh","dsel"]

###############################################################################
##                                                                            #
##      function definitions                                                  #
##                                                                            #
###############################################################################

def findEye(tile, portId, lane=None, laneMask=None, laneList=None, eyeType="+", vocList=_tmpVocList, dwell=w._dwell, state=None, startTime=None, logSuffix="", offset=None, offsetL=None, offsetR=None, offsetU=None, offsetD=None, showPlot=None, skipInit=False, showProg=True, msg="", fastAcq=True, fastAcqBuffer=10, normPlot=True, logResults=True, logfile=None, logHdr=True, txEqList=None, plotAllPointsTested=False, plotStats=True, getRxStats=True, testName=None, baudRate=None, loopCnt=None, returnResults=None, hdrSuffix="", dataSuffix="", plotColorId=None, numPlotColors=None, plotLabel=None, laneRev=None, vcoStepSize=1, vocStepSize=1, boardId=None, xAxis=None, yAxis=None, debug=False, contCal=False, contAdapt=False, subTitle="", returnRpcData=True):
    if w._debug: w._showFunctionInfo(sys._getframe(0))

    from time import ctime
    from math import log
    from datetime import timedelta
    from random import normalvariate
    global rpcHdr

###############################################################################
##                                                                            #
##  command options deprecated / hardcoded to simplify initial code debug:    #
##  options that are commented below remain as existing user command options  #
##                                                                            #
###############################################################################
#                                                                             #
    sampler = 0                                                               #
    pattern = None                                                            #
    patt0 = None                                                              #
    patt1 = None                                                              #
    patt2 = None                                                              #
    patt3 = None                                                              #
    prbs = None                                                               #
    initLinkLayer = False                                                     #
    otherLanesQuiet = False                                                   #
    autoinv = True                                                            #
    ssa = False                                                               #
    eyeMon = False                                                            #
    distType = "pdf"                                                          #
    ctle = None                                                               #
    psa = None                                                                #
    ssaCommitter = "DefaultCSVCommitter"                                      #
    clearEparams = False                                                      #
    slv = None                                                                #
    slvPortId = None                                                          #
    thruConfig = False                                                        #
    pherrCorrection = False                                                   #
    vocDict = None                                                            #
    logAllSteps = True                                                        #
    setupSlave = False                                                        #
    tryEvenOdd = False                                                        #
    activeLaneMask = None                                                     #
    initLaneMask = None                                                       #
    disablePmStates = True                                                    #
    jitterMode = False                                                        #
    offsetMode = False                                                        #
    getStatistics = False                                                     #
    recipeId = None                                                           #
    userMask = None                                                           #
    retrainLink = False                                                       #
    ssc = False                                                               #
    offsetCnt = 250                                                           #
#                                                                             #
###############################################################################

    w._startTime = startTime

    strtTime = time()

    if laneMask!=None and w.isString(laneMask)==True:
        laneMask = w.xlateLaneMask(tile, portId, laneMaskStr=laneMask)

    mode = w._getMode(portId)
    port = w._getPortNum(portId)

    if laneList==None:
        laneList = w.getLaneList(tile, portId, lane, laneMask, type="byPort")

    w._ssa = ssa

    state = w.getLtssmStateType(tile, portId) if state==None else state

    if prbs==None:
        prbs = True if pattern==None else False

    if lane!=None and laneMask!=None:                                                                           ## lane takes precedence over laneMask
        laneMask=None

    if laneMask==None:
        laneMask = w.getPortMask(tile=tile, portId=portId, lane=lane, type="byPort")
    elif laneMask!=None:
        laneMask = laneMask & w.getPortMask(tile=tile, portId=portId, type="byPort")                            ## truncate laneMask to max width of port

    whrPhyRev       = None if ssa==True else w.getModuleInfo(w)["$Revision"][1]                                 ## meta data
    whrPhyMarginRev = None if ssa==True else w.getModuleInfo(sys.modules[__name__])["$Revision"][1]             ## meta data

    portId          = portId.lower()
    state           = state.lower()
    eyeType         = eyeType.lower()
    distType        = distType.lower()
    minVco          = w._rxLoopDict["vco"][0][0]
    maxVco          = w._rxLoopDict["vco"][0][1]
    minVoc          = w._rxCalDict[vocList[0]][0]
    maxVoc          = w._rxCalDict[vocList[0]][1]
    vcoDirList      = [1,-1]
    vocDirList      = [1,-1]
    loopCnt         = w._loopCnt if loopCnt==None else loopCnt
    usrBaudRate     = baudRate
    strtBaudRate    = w.getBaudRate(tile, portId)
    maxBerRate      = 1e-5


    if state=="l0" and len(laneList)>1:
        errStr = "ERROR(0): a single lane must be defined when LTSSM state is \'l0\'"
        raise whrPhyMarginError(errStr)

    if offset!=None and eyeType in ("+","-","|","."):
        offsetL = abs(offset) if offset!=None and eyeType not in ["|"] else None
        offsetR = abs(offset) if offset!=None and eyeType not in ["|"] else None
        offsetU = abs(offset) if offset!=None and eyeType not in ["-"] else None
        offsetD = abs(offset) if offset!=None and eyeType not in ["-"] else None

    if eyeType in ("o","+","|") or (eyeType=="." and (offsetU not in [None,0] or offsetD not in [None,0])):     ## do not touch voc for timing-only tests
        doNotTouchVoc = False
    else:
        doNotTouchVoc = True

    lanesPerPort = len(w.getLaneList(tile, portId, lane=None))

    if laneRev==None:                                                                                           ## hardcode exists mainly for findEyeRepeat & findEyeMargin functions in case prior run clobbered link
        laneRev = w.getLaneReversal(tile, portId) if w._access!="stub" else True

    if laneRev==None:
        print("WARNING: could not determine lane reversal.")

    if txEqList!=None:
        txLaneMask = w.flipBits(laneMask, lanesPerPort) if laneRev==True else laneMask                          ## get txLaneMask for upstream Tx lanes

    forceRetrainLink = False                                                                                    ## used mainly to control verbose option in call to trainLink
    txStateValExp = []
    if state=="test":
        if w._getMode(portId)=="u":
            txStateValExp = [17,31]
        elif w._getMode(portId)=="p":
            txStateValExp = [ 3,27]
    elif state=="l0":
        if w._getMode(portId)=="u":
            txStateValExp = [15,14]
        elif w._getMode(portId)=="p":
            txStateValExp = [17,13,15,16]

        if skipInit!=True:

            strtRxCalCont = w.getRxCalContinuous(tile, portId, lane, laneMask, returnDict=True)
            w.setRxCalContinuous(tile, portId, lane, laneMask, value=contCal)
            strtRxAdaptCont = w.getRxAdaptContinuous(tile, portId, lane, laneMask, returnDict=True)
            w.setRxAdaptContinuous(tile, portId, lane, laneMask, value=contAdapt)
    
            if w._getMode(portId)=="u":

                for (tmpTile, tmpPortId) in ((tile, portId), (slv, slvPortId)):
                    if (tmpTile!=None and tmpPortId!=None):

                        strtTl0c = int(tmpTile.upi_phy.ph_tl0c_op.tl0c)
                        strtMpa  = int(tmpTile.upi_link.ll_lcl.max_phy_abort)
                        strtMr   = int(tmpTile.upi_link.ll_lcl.max_retry)
                        resetD   = int(tmpTile.upi_phy.ph_ctr1.cenablephyresetd)
                        resetW   = int(tmpTile.upi_phy.ph_ctr1.cenablephyresetw)
                        resetDis = int(tmpTile.upi_phy.ph_ctr1.crxresetdis)

                        tmpTile.upi_phy.ph_tl0c_op.tl0c = 0
                        tmpTile.upi_link.ll_lcl.max_phy_abort = 3
                        tmpTile.upi_link.ll_lcl.max_retry = 15
                        tmpTile.upi_phy.ph_ctr1.cenablephyresetd = 0
                        tmpTile.upi_phy.ph_ctr1.cenablephyresetw = 0
                        tmpTile.upi_phy.ph_ctr1.crxresetdis = 1

                for (tmpTile, tmpPortId) in ((tile, portId), (slv, slvPortId)):
                    if (tmpTile!=None and tmpPortId!=None):
                        w.setPhyInit(tmpTile, tmpPortId, value=1)


        w.setPhyInit(tile, portId, value=0)

    initTxEq = None
    if (txEqList!=None and (w.isList(txEqList) or w.isDict(txEqList))):
        initTxEq = w.getPcieRemoteTxEq(tile, portId, lane=None, laneMask=txLaneMask, returnDict=True)

    tmpTxEq  = None
    if (txEqList!=None and (w.isList(txEqList) or w.isDict(txEqList))):                                                     ## set by "findEyeTxEq"; treat as "manual" eparam in lb.pattern
        tmpTxEq = {}
        for i in laneList:
            tmpTxEq[i] = txEqList[i] if w.isDict(txEqList) else txEqList                                                    ## build txEq dictionary referenced to Tx lanes

    if retrainLink==True or forceRetrainLink==True or txEqList!=None:
        w.trainLink(tile, portId, txEqList=txEqList)

    if baudRate==None:
        baudRate    = w.getBaudRate(tile, portId)

    sampList = [0]

    rxStatsHdrStr   = w.getRxStats(tile, portId, lane=laneList[0], returnHdr=True, getCal=getRxStats, getLoop=getRxStats, loopCnt=loopCnt, returnMean=bool(not(getStatistics)))
    rxStatsHdrList  = rxStatsHdrStr[:-1].replace(" ","").split("\t")                                            ## remove trailing tab
    rxStatsStrInit  = "" if rxStatsHdrStr=="" else "-1\t"*len(rxStatsHdrList)

    tmpDict1 = {"vcoAtMaxVoc":-1,         "vcoL":-1,         "vcoR":-1,        "dwell":-1,        "state":-1,
                    "errCntU":-1,      "errCntD":-1,      "errCntL":-1,      "errCntR":-1,      "loopCnt":-1,
                     "uiCntL":-1,       "uiCntR":-1,       "uiCntU":-1,       "uiCntD":-1,          "ult":-1,
                        "rds":-1,          "tds":-1,     "recipeId":-1,          "fom":-1,      "baseFom":-1,
                  "startTime":-1,      "endTime":-1,     "testTime":-1,     "initTime":-1,    "totalTime":-1,
                    "strtVco":-1,     "strtVcoL":-1,     "strtVcoR":-1,      "vocClip":-1,      "vcoClip":-1,
                       "vocL":-1,         "vocR":-1,          "idv":-1,      "boardId":-1,         "sris":-1,
                  "biosRcRev":-1,        "tempj":-1,        "voltj":-1,           "vp":-1,          "vph":-1,
                   "stepping":-1,       "whrPhy":-1, "whrPhyMargin":-1, "whrPhyRecipe":-1,          "ssc":-1,
                 "refErrEven":-1,    "refErrOdd":-1,   "remoteTxEq":-1,   "vdacDrange":-1,   "vdacPrange":-1,
                 "errSlcMode":-1,     "refLdVal":-1,   "rxStatsStr":rxStatsStrInit}

    samp = {}
    for j in sampList: 
        samp[j]=deepcopy(tmpDict1)

    eyeDict = {}
    for i in laneList: 
        eyeDict[i]=deepcopy(samp)

    findEyeKeys = list(eyeDict[laneList[0]][sampList[0]].keys())
    findEyeKeys.remove("rxStatsStr")
    findEyeKeys.sort()

    if (logResults==True and ssa==False):
        if logfile==None:
            tmpStr = "findEyeMonitor" if eyeMon==True else "findEye"

            logSuffix = "_state-%s"%state + logSuffix if (state not in logSuffix) else logSuffix                ## prepend state to logSuffix

            tmpPartId = "" if tile._partId==tile._tileName else "-%s"%tile._partId
            if len(laneList)==1:
                tmpfile = "%s_%s_Rx-%s_%s-%s_%0.1f_L%02d%s.tsv"%(strftime("%y%m%d_%H%M%S"), tmpStr, tile._tileName, portId, tmpPartId, baudRate, laneList[0], logSuffix)
            else:
                tmpfile = "%s_%s_Rx-%s_%s-%s_%0.1f%s.tsv"%(strftime("%y%m%d_%H%M%S"), tmpStr, tile._tileName, portId, tmpPartId, baudRate, logSuffix)

            if w._cds==True: _log.cdsInit(activity="SMV", delimiter="\t", commitWhenFileSetNone=w._cdsNoFileSet, logToFile=True)

            _log.setFile(tmpfile, overwrite=False)
            _log.setFileLevel("INFO")
            _log.setFileFormat("simple")

        if logHdr==True:
            hdrStr1 = "vcoStep\ttile\tportId\tlane"

            vocHdrStr = ""
            for tmpVoc in vocList:
                vocHdrStr += "\t%s\t%s"%(tmpVoc+"U",tmpVoc+"D")

            hdrStr2 = "partId\tbaudRate\tvco%s\tuiCntU\tuiCntD\terrCntU\terrCntD"%vocHdrStr
            hdrStr3 = str(findEyeKeys)[2:-2].replace("', '", "\t")

            if showProg==True: 
                w.showProgress(type=None)

            hdrStr = "%s\t%s"%(hdrStr1, hdrStr2)
            print(hdrStr)
            _log.info("%s\t%s\t%s\t%s%s"%(hdrStr1, hdrStr2, hdrStr3, rxStatsHdrStr, hdrSuffix))
            rpcHdr = hdrStr.split("\t")

    errStr=""

    pvtTemp = 123
    pvtVolt = 4.56
    strtTimeStr = ctime(strtTime).split()[3]
    rpcDataResult = {}

    for i in laneList:                                                                                          ## pre-load eyeDict dictionary w/ meta data
        for j in sampList:
            #import pdb; pdb.set_trace()
            eyeDict[i][j]["state"]      = state
            eyeDict[i][j]["stepping"]   = tile._stepping
            eyeDict[i][j]["pvtTemp"]    = pvtTemp
            eyeDict[i][j]["pvtVolt"]    = pvtVolt
            eyeDict[i][j]["fom"]        = w.getRxAdaptFom(tile, portId, i)
            eyeDict[i][j]["baseFom"]    = w.getRxAdaptBaseFom(tile, portId, i)
            eyeDict[i][j]["vdacDrange"] = w.getRxVdacDrangeSel(tile, portId, i)
            eyeDict[i][j]["vdacPrange"] = w.getRxVdacPrangeSel(tile, portId, i)
            eyeDict[i][j]["refErrEven"] = w.getRxAdaptRefErr(tile, portId, i, sampler="even")
            eyeDict[i][j]["refErrOdd"]  = w.getRxAdaptRefErr(tile, portId, i, sampler="odd")
            eyeDict[i][j]["errSlcMode"] = w.getRxAdaptErrorSlicerMode(tile, portId, i)
            eyeDict[i][j]["refLdVal"]   = w.getRxRefLdVal(tile, portId, i)
            eyeDict[i][j]["vp"]         = w.getPwrSupplyVoltage(tile, portId, i, supply="vp")
            eyeDict[i][j]["vph"]        = w.getPwrSupplyVoltage(tile, portId, i, supply="vph")
            eyeDict[i][j]["startTime"]  = strtTimeStr
            eyeDict[i][j]["loopCnt"]    = loopCnt
            eyeDict[i][j]["dwell"]      = dwell

            if w._getMode=="p":
                eyeDict[i][j]["remoteTxEq"] = w.getPcieRemoteTxEq(tile, portId, lane=i)

            if ssa==False and w._access not in ("svos","ccb","tssa"):
                eyeDict[i][j]["whrPhy"]         = whrPhyRev
                eyeDict[i][j]["whrPhyMargin"]   = whrPhyMarginRev
                eyeDict[i][j]["boardId"]        = boardId

            for tmpVoc in vocList:
                eyeDict[i][j][tmpVoc]            = {}
                eyeDict[i][j][tmpVoc]["strtVoc"] = int(w.getVoc(tile, portId, lane=i, voc=tmpVoc, getCalValue=True))
                eyeDict[i][j][tmpVoc]["vocU"]    = -1  #<<
                eyeDict[i][j][tmpVoc]["vocD"]    = -1  #<<
                eyeDict[i][j][tmpVoc]["vcoAtMaxVoc"] = -1

    if logResults==True and ssa==True:
        ssaDict = {"laneList":laneList, "eyeType":eyeType, "getCal":getCal, "getLoop":getLoop, "otherLanesQuiet":otherLanesQuiet, "prbs":prbs, "autoinv":autoinv, "initTxEq":initTxEq, "testTxEq":testTxEq, "initCtle":initCtle, "testCtle":testCtle}
        writer = setupSsa(tile=tile, portId=portId, baudRate=baudRate, logSuffix=logSuffix, ssaDict=ssaDict, funcName="findEye", ssaCommitter=ssaCommitter, testName=testName)

    firmwareEnabled = w.getFsmOverrideEnable(tile, portId, lane=lane, laneMask=laneMask, returnDict=True)

    for i in laneList:
        if firmwareEnabled[i]==0:
            w.disableFirmware(tile, portId, lane=i)

    #try:
    if True: # CLCASTRO REMOVE
        txState = w.getLtssmState(tile, portId)
        tmpBaudRate = w.getBaudRate(tile, portId)

        if txState not in txStateValExp and w._access!="stub":
            errStr = "\nERROR (1): Tx:%s_%s (%s) did not train to \'%s\' (state=\'%s\').  Restart platform and try again.\n"%(tile._tileName, portId, tile._partId, w._ltssmDict[mode][txStateValExp[0]][0], w._ltssmDict[mode][txState][0])
            raise whrPhyMarginError(errStr)
        elif ((baudRate==None and tmpBaudRate!=strtBaudRate) or (baudRate!=None and tmpBaudRate!=baudRate)) and w._access!="stub":
            errStr = "\nERROR (2): Tx:%s_%s (%s) trained baudRate (%4.1f) does not match target baudRate (%4.1f).  Restart platform and try again.\n"%(tile._tileName, portId, tile._partId, tmpBaudRate, baudRate)
            raise whrPhyMarginError(errStr)

        rds = w.getRxLaneStatus(tile, portId, returnStr=True)
        tds = w.getTxLaneStatus(tile, portId, returnStr=True)

        for i in laneList:                                                                                      ## initialization loop
            if showProg==True:
                tmpMsg = "... initializing Rx AFE setup (%s_%s, lane=%2d)"%(tile._tileName, portId, i)
                w.showProgress(laneList.index(i), type="time", msg=tmpMsg)

            if getRxStats==True and (logResults==True or returnResults==True or (txEqList!=None and (w.isList(txEqList) or w.isDict(txEqList))) or (len(laneList)==1 and showPlot==True and plotStats==True)):
                rxStatsDict = w.getRxStats(tile, portId, lane=i, getCal=True, getLoop=True, loopCnt=loopCnt, returnMean=bool(not(getStatistics)), showProg=showProg, returnDict=True)

                rxStatsStr = ""
                for hdr in rxStatsHdrList:
                    if "_mean" in hdr:
                        rxStatsStr += "%s\t"%(rxStatsDict[i][hdr[0:hdr.find("_mean")]][0])
                    elif "_min" in hdr:
                        rxStatsStr += "%s\t"%(rxStatsDict[i][hdr[0:hdr.find("_min")]][1])
                    elif "_max" in hdr:
                        rxStatsStr += "%s\t"%(rxStatsDict[i][hdr[0:hdr.find("_max")]][2])
                    elif "_stdev" in hdr:
                        rxStatsStr += "%s\t"%(rxStatsDict[i][hdr[0:hdr.find("_stdev")]][3])
                    elif "_cnt" in hdr:
                        rxStatsStr += "%s\t"%(rxStatsDict[i][hdr[0:hdr.find("_cnt")]][4])
                    else:
                        rxStatsStr += "%s\t"%(rxStatsDict[i][hdr])

                for j in sampList:
                    eyeDict[i][j]["rxStatsStr"] = rxStatsStr
            else:
                rxStatsDict = w.getRxStats(tile, portId, lane=i, loop="vco", loopCnt=loopCnt, returnMean=bool(not(getStatistics)), showProg=showProg, returnDict=True)

            for j in sampList:
                eyeDict[i][j]["rds"] = rds
                eyeDict[i][j]["tds"] = tds
                tmpVco = rxStatsDict[i]["vco"]

                eyeDict[i][j]["strtVco"]    = tmpVco if w.isNumber(tmpVco) else int(round(tmpVco[0],0))
                eyeDict[i][j]["strtVcoL"]   = tmpVco if w.isNumber(tmpVco) else tmpVco[1]
                eyeDict[i][j]["strtVcoR"]   = tmpVco if w.isNumber(tmpVco) else tmpVco[2]
                eyeDict[i][j]["vcoL"]       = -1
                eyeDict[i][j]["vcoR"]       = -1

        totVcoSteps = {}
        for i in laneList:
            for j in sampList:
                totVcoSteps[i] = deepcopy(0)
                eyeDict[i][j]["initTime"] = int(time() - strtTime)                                              ## in seconds

        txState = w.getLtssmState(tile, portId)
        tmpBaudRate = w.getBaudRate(tile, portId)

        if txState not in txStateValExp and w._access!="stub":
            errStr = "\nERROR(3): Tx:%s_%s (%s) did not train to \'%s\' (state=\'%s\').  Restart platform and try again.\n"%(tile._tileName, portId, tile._partId, w._ltssmDict[mode][txStateValExp[0]][0], w._ltssmDict[mode][txState][0])
            raise whrPhyMarginError(errStr)
        elif ((baudRate==None and tmpBaudRate!=strtBaudRate) or (baudRate!=None and tmpBaudRate!=baudRate)) and w._access!="stub":
            errStr = "\nERROR(4): Tx:%s_%s (%s) trained baudRate (%4.1f) does not match target baudRate (%4.1f).  Restart platform and try again.\n"%(tile._tileName, portId, tile._partId, tmpBaudRate, baudRate)
            raise whrPhyMarginError(errStr)

        for j in sampList:
            if showProg==True:
                w.showProgress(type=None)
                w.showProgress(None, type="time", msg=msg)

                if logResults==True and len(sampList)>1 and j==sampList[1] and ssa==False:
                    print()

                tmpMsg = "... start of margin test for %s_%s"%(tile._tileName, portId)
                w.showProgress(None, type="time", msg=tmpMsg)

            for vcoDir in vcoDirList:
                vocMid      = {}                                                                                ## midPoint voc value between upper/lower edges of eye
                vocNxt      = {}
                tmpFastAcq  = {}
                for i in laneList:
                    vocMid[i]   = {}
                    vocNxt[i]   = {}
                    for tmpVoc in vocList:
                        vocMid[i][tmpVoc]   = -1
                        vocNxt[i][tmpVoc]   = {1:-1, -1:-1}

                    tmpFastAcq[i] = fastAcq & (eyeType=="o")

                vcoDone     = {}                                                                                ## vcoDone=False while stepping, True at edge of eye, None after data is logged
                vcoClip     = {}                                                                                ## vcoDone=False while stepping, True at edge of eye, None after data is logged
                for i in laneList:
                    vcoDone[i] = False
                    vcoClip[i] = False

                    for tmpVoc in vocList:
                        vocMid[i][tmpVoc]       = eyeDict[i][j][tmpVoc]["strtVoc"]
                        vocNxt[i][tmpVoc][ 1]   = eyeDict[i][j][tmpVoc]["strtVoc"]
                        vocNxt[i][tmpVoc][-1]   = eyeDict[i][j][tmpVoc]["strtVoc"]

                vcoSkipList = []
                if offsetR!=None and offsetR>0 and vcoDir==1:
                    vcoSkipList = list(range(vcoDir*1,vcoDir*offsetR,vcoDir*vcoStepSize))
                elif offsetL!=None and offsetL>0 and vcoDir==-1:
                    vcoSkipList = list(range(vcoDir*1,vcoDir*offsetL,vcoDir*vcoStepSize))

                maxVcoRange = vcoDir*((maxVco-minVco)//2)
                strtVcoOffset = 0 if vcoDir==1 else -1
                tmpOffsetList = list(range(strtVcoOffset, maxVcoRange, vcoDir*vcoStepSize))
                vcoOffsetList = [a for a in tmpOffsetList if a not in vcoSkipList]

                for vcoOffset in vcoOffsetList:
                    vocVal  = {}
                    errCnt  = {}
                    uiCnt   = {}
                    vcoVal  = {}
                    for i in laneList:
                        vocVal[i] = {}
                        for tmpVoc in vocList:
                            vocVal[i][tmpVoc] = {1:vocNxt[i][tmpVoc][1], -1:vocNxt[i][tmpVoc][-1]}

                        errCnt[i]   = {1:-1, -1:-1}
                        uiCnt[i]    = {1:-1, -1:-1}
                        vcoVal[i]   = -1

                    for i in laneList:
                        clearedVcoErrCntr = False
                        if vcoDone[i]==False:
                            w.clearErrCnt(tile, portId, lane=i); w.clearErrCnt(tile, portId, lane=i)

                            clearedVcoErrCntr = True
                            vcoVal[i] = eyeDict[i][j]["strtVco"] + vcoOffset                                    ## get calculated vco value
                            w.stepVco(tile, portId, lane=i, value=vcoOffset, showProg=showProg)
                            if w._access!="stub": w.sleep(dwell)
                            if eyeType in ["+","-"] and vcoOffset!=vcoOffsetList[0]:
                                w.stepVco(tile, portId, lane=i, value=0)                                        ## move back to center

                    for vocDir in vocDirList:
                        vocDone = {}
                        vocClip = {}
                        for i in laneList:
                            vocDone[i] = {}
                            vocClip[i] = {}
                            for tmpVoc in vocList:
                                vocDone[i][tmpVoc] = False
                                vocClip[i][tmpVoc] = False

                        vocSkipList = []
                        if offsetU!=None and offsetU>0 and vocDir==1:
                            vocSkipList = list(range(0,vocDir*offsetU,vocDir*vocStepSize))
                        elif offsetD!=None and offsetD>0 and vocDir==-1:
                            vocSkipList = list(range(0,vocDir*offsetD,vocDir*vocStepSize))

                        strtVocOffset = 0 if vocDir==1 else -1
                        maxVocRange = vocDir*(maxVoc-minVoc+1)
                        tmpOffsetList = list(range(strtVocOffset, maxVocRange, vocDir*vocStepSize))
                        vocOffsetList = [a for a in tmpOffsetList if a not in vocSkipList]

                        for vocOffset in vocOffsetList:
                            txState = w.getLtssmState(tile, portId)
                            tmpBaudRate = w.getBaudRate(tile, portId)
                            if txState not in txStateValExp and w._access!="stub":
                                errStr = "\nERROR (5): Rx:%s_%s (%s) is not in \'%s\' (\'%s\').  Restart platform and try again."%(tile._tileName, portId, tile._partId, w._ltssmDict[mode][txStateValExp[0]][0], w._ltssmDict[mode][txState][0])
                                raise whrPhyMarginError(errStr)
                            elif ((baudRate==None and tmpBaudRate!=strtBaudRate) or (baudRate!=None and tmpBaudRate!=baudRate)) and w._access!="stub":
                                errStr = "\nERROR(6): Tx:%s_%s (%s) trained baudRate (%4.1f) does not match target baudRate (%4.1f).  Restart platform and try again.\n"%(tile._tileName, portId, tile._partId, tmpBaudRate, baudRate)
                                raise whrPhyMarginError(errStr)

                            for i in laneList:
                                if not any(vocDone[i].values()):
                                    if doNotTouchVoc==False:
                                        if eyeType=="+" and (vcoOffset!=vcoOffsetList[0] or (vcoDir==-1 and vcoOffset==vcoOffsetList[0])):
                                            pass
                                        elif eyeType=="." and (offsetU!=None or offsetD!=None) and (vcoOffset!=vcoOffsetList[0] or (vcoDir==-1 and vcoOffset==vcoOffsetList[0])):
                                            pass
                                        elif eyeType=="-":
                                            pass
                                        else:
                                            if clearedVcoErrCntr==False:
                                                w.clearErrCnt(tile, portId, lane=i); w.clearErrCnt(tile, portId, lane=i)
                                            for tmpVoc in vocList:
                                                vocVal[i][tmpVoc][vocDir] = vocNxt[i][tmpVoc][vocDir] + vocOffset   ## calculate voc value

                                                offset1 = vocVal[i][tmpVoc][vocDir] - eyeDict[i][j][tmpVoc]["strtVoc"]
                                                offset2 = max(0, offset1-vocDir*vocStepSize) if vocDir==1 else min(0, offset1-vocDir*vocStepSize)

                                                w.stepVoc(tile, portId, lane=i, voc=tmpVoc, value=offset1, showProg=showProg)
                                                if w._access!="stub": w.sleep(dwell)
                                                w.stepVoc(tile, portId, lane=i, voc=tmpVoc, value=offset2)      ## move back away from edge by vocStepSize

                                            clearedVcoErrCntr = False

                            for i in laneList:
                                if not any(vocDone[i].values()):
                                    if w._access=="stub":
                                        strtVoc = eyeDict[i][j][vocList[0]]["strtVoc"]
                                        strtVco = eyeDict[i][j]["strtVco"]
                                        tmpVocVal = vocVal[i][vocList[0]][vocDir]
                                        tmpVcoVal = vcoVal[i]
    
                                        errCnt[i][vocDir]   =  w.stubGetErrCnt(tile, portId, lane=i, vco=tmpVcoVal, voc=tmpVocVal, strtVco=strtVco, strtVoc=strtVoc, dwell=dwell, baudRate=baudRate, vcoDir=vcoDir, ctle=ctle, txEq=txEqList) ##CLCASTRO REPLACED TO 0
                                        uiCnt[i][vocDir]    = int(dwell * (baudRate * 1000000000) * (1.0 if state=="l0" else (1.0 + normalvariate(0,0.05))))

                                    elif rds[lanesPerPort-i-1]=="0":                                            ## force lane failure if lane not in rds
                                        errCnt[i][vocDir] = 999

                                    else:
                                        errCnt[i][vocDir] = w.getErrCnt(tile, portId, lane=i)
                                        uiCnt[i][vocDir]  = int(dwell * (baudRate * 1000000000))

                            if plotAllPointsTested==True or ssa==True:                                          ## log / plot all tested vco/voc points
                                for i in laneList:
                                    tmpVoc = vocList[0]
                                    if vocDone[i][tmpVoc]==False and vcoDone[i]==False and errCnt[i][vocDir]==0:
                                        tmpStrtVco  = eyeDict[i][j]["strtVco"]
                                        tmpStrtVcoL = eyeDict[i][j]["strtVcoL"]
                                        tmpStrtVcoR = eyeDict[i][j]["strtVcoR"]
                                        tmpStrtVoc  = eyeDict[i][j][tmpVoc]["strtVoc"]
                                        tmpVcoVal   = vcoVal[i]                                                 ## get calculated vco value
                                        tmpVocVal   = vocVal[i][tmpVoc][vocDir]                                 ## get calculated vco value

                                        (adjVco, adjVocU, adjVocD, adjStrtVco, adjVcoL, adjVcoR, adjStrtVoc, adjVocM) = normEyeData(tmpVcoVal, tmpVocVal, tmpVocVal, strtVco=tmpStrtVco, vcoL=tmpStrtVcoL, vcoR=tmpStrtVcoR, strtVoc=tmpStrtVoc, vcoDir=vcoDir, normPlot=normPlot)

                                        if ssa==True:                                                           ## log / plot all tested vco/voc points if ssa=True
                                            timeStr = strftime("%m/%d/%y %H:%M:%S")
                                            writer.WriteRow(strftime("%m/%d/%y"),strftime("%H:%M:%S"),totVcoSteps[i],"Wharf_Rock","%s"%tile._tileName,portId,mode,baudRate,i,j,tmpVcoVal,tmpVocVal,uiCnt[i][vocDir],errCnt[i][vocDir],timeStr,loopCnt,eyeDict[i][j]["strtVco"],eyeDict[i][j]["strtVoc"],adjVco,adjVocU,"NOVALUE","NOVALUE","NOVALUE","NOVALUE","NOVALUE","NOVALUE","NOVALUE","NOVALUE","NOVALUE")

                            for i in laneList:
                                if not any(vocDone[i].values()):

                                    for tmpVoc in vocList:
                                        if eyeType==".":                                                        ## 1st point tested in this vocDir for eyeType="." (pointTest)
                                            vocDone[i][tmpVoc] = True
                                        elif eyeType=="-":
                                            vocDone[i][tmpVoc] = True
                                        elif eyeType=="+" and (vcoOffset!=vcoOffsetList[0] or vcoDir==-1):
                                            vocDone[i][tmpVoc] = True
                                        elif errCnt[i][vocDir]>0:                                               ## lane has failed 1st time in this vocDir
                                            vocDone[i][tmpVoc] = True
                                        elif (vocDir== 1 and vocVal[i][tmpVoc][vocDir]+vocStepSize>maxVoc):     ## voc has reached max allowable voc value
                                            vocDone[i][tmpVoc] = True
                                        elif (vocDir==-1 and vocVal[i][tmpVoc][vocDir]-vocStepSize<minVoc):     ## voc has reached min allowable voc value
                                            vocDone[i][tmpVoc] = True

                                    if any(vocDone[i].values())==True:                                          ## if any tmpVoc samplers are showing vocDone==True
                                        for tmpVoc in vocList:
                                            if eyeType==".":
                                                nxtVocOffset = 0                                                ## step voc back to strtVoc
                                            else:
                                                nxtVocOffset = vocNxt[i][tmpVoc][vocDir] + vocOffsetList[0] - eyeDict[i][j][tmpVoc]["strtVoc"]  ## step voc back to starting point for this vocDir if vocDone

                                            w.stepVoc(tile, portId, lane=i, voc=tmpVoc, value=nxtVocOffset)

                                            if vcoOffset==vcoOffsetList[0] and vcoDir==1:
                                                if vocDir==1:
                                                    eyeDict[i][j][tmpVoc]["vocU"] = vocVal[i][tmpVoc][vocDir]   ## vocU recorded at initial sampling vco
                                                elif vocDir==-1:
                                                    if vocVal[i][tmpVoc][vocDir]==-1:
                                                        eyeDict[i][j][tmpVoc]["vocD"] = 0                       ## failed at first voc step down (strtVocOffset=-1); adjust vocD margin to reflect 0
                                                    else:
                                                        eyeDict[i][j][tmpVoc]["vocD"] = vocVal[i][tmpVoc][vocDir]   ## vocD recorded at initial sampling vco

                                            if vocVal[i][tmpVoc][vocDir]+vocDir*vocStepSize>maxVoc and errCnt[i][vocDir]==0:    ## indicate VOC clipping if maxVoc or minVoc reached and errCnt=0
                                                vocClip[i][tmpVoc] = True
                                                if vcoDir==1 and vcoVal[i]==eyeDict[i][j]["strtVco"]:           ## eyeDict variable 'vocClip' valid only at 'strtVco'
                                                    eyeDict[i][j]["vocClip"] = True
                                            elif vocVal[i][tmpVoc][vocDir]+vocDir*vocStepSize<minVoc and errCnt[i][vocDir]==0:  ## indicate VOC clipping if maxVoc or minVoc reached and errCnt=0
                                                vocClip[i][tmpVoc] = True
                                                if vcoDir==1 and vcoVal[i]==eyeDict[i][j]["strtVco"]:           ## eyeDict variable 'vocClip' valid only at 'strtVco'
                                                    eyeDict[i][j]["vocClip"] = True

                                            if vcoDir==1 and vcoVal[i]==eyeDict[i][j]["strtVco"] and errCnt[i][vocDir]==0:  ## eyeDict variable 'vocClip' valid only at 'strtVco'
                                                if vocVal[i][tmpVoc][vocDir]+vocDir*vocStepSize>maxVoc:
                                                    eyeDict[i][j]["vocClip"] = True                             ## indicate VOC clipping if maxVoc or minVoc reached at strtVco
                                                elif vocVal[i][tmpVoc][vocDir]+vocDir*vocStepSize<minVoc:
                                                    eyeDict[i][j]["vocClip"] = True                             ## indicate VOC clipping if maxVoc or minVoc reached at strtVco

                                    if vcoDir==1 and vcoOffset==0:
                                        if vocDir==1:
                                            eyeDict[i][j]["errCntU"] = errCnt[i][vocDir]
                                            eyeDict[i][j]["uiCntU"]  = uiCnt[i][vocDir]
                                        else:
                                            eyeDict[i][j]["errCntD"] = errCnt[i][vocDir]
                                            eyeDict[i][j]["uiCntD"]  = uiCnt[i][vocDir]

                            if eyeType=="o":
                                for i in laneList:
                                    if tmpFastAcq[i]==True and vocOffset==vocOffsetList[0] and errCnt[i][vocDir]>0:
                                        tmpFastAcq[i] = False                                                   ## disable tmpFastAcq for remaining vcoDir if 1st voc step failed at this vcoOffset

                            if debug==True:
                                for i in laneList:
                                    (fg,bg,fgI,bgI) = ("green","black",True,False)

                                    w.printc("\rlane:%2d vco:%2d  "%(i,vcoVal[i]),fg,bg,fgI,bgI)                ## DEBUG PRINT
                                    vcoDoneStr = "~"*int(vcoDone[i]) if vcoDone[i]!=None else "N"
                                    w.printc("%1s"%(vcoDoneStr),fg,bg,fgI,bgI)                                  ## DEBUG PRINT
                                    w.printc("%1s"%("-"*int(any(vocDone[i].values()))),fg,bg,fgI,bgI)           ## DEBUG PRINT
                                    w.printc("%1s"%("x"*int(bool(errCnt[i][vocDir]))),fg,bg,fgI,bgI)            ## DEBUG PRINT
                                    w.printc("%1s"%("^"*int(tmpFastAcq[i])),fg,bg,fgI,bgI)                      ## DEBUG PRINT
                                    w.printc("%1s"%("~"*int(any(vocClip[i].values()))),fg,bg,fgI,bgI)           ## DEBUG PRINT

                                    for tmpVoc in vocList:
                                        w.printc("%s:%3d  "%(tmpVoc, vocVal[i][tmpVoc][vocDir]),fg,bg,fgI,bgI)  ## DEBUG PRINT
                                        w.printc("vocMid:%3d  "%(vocMid[i][tmpVoc]),fg,bg,fgI,bgI)              ## DEBUG PRINT
                                        w.printc("vocNxt:%3d  "%(vocNxt[i][tmpVoc][vocDir]),fg,bg,fgI,bgI)      ## DEBUG PRINT
                                        storedVoc = w._vocValOvrdDict[tile._fpgaNum][tile._tileNum][portId][i][tmpVoc]
                                        w.printc("_voc:%3d  "%(storedVoc),fg,bg,fgI,bgI)                        ## DEBUG PRINT

                                    w.printc("totVcoSteps:%3d  "%(totVcoSteps[i]),fg,bg,fgI,bgI)                ## DEBUG PRINT
                                    w.printc("vcoOffset:%3d  "%(vcoOffset),fg,bg,fgI,bgI)                       ## DEBUG PRINT
                                    w.printc("vocOffset:%4d  "%(vocOffset),fg,bg,fgI,bgI)                       ## DEBUG PRINT
                                    w.printc("errCnt:%6d"%(errCnt[i][vocDir]),fg,bg,fgI,bgI)                    ## DEBUG PRINT

                                    if offsetL!=None: w.printc("  offsetL:%2d"%(offsetL),fg,bg,fgI,bgI)         ## DEBUG PRINT
                                    if offsetR!=None: w.printc("  offsetR:%2d"%(offsetR),fg,bg,fgI,bgI)         ## DEBUG PRINT
                                    if offsetU!=None: w.printc("  offsetU:%2d"%(offsetU),fg,bg,fgI,bgI)         ## DEBUG PRINT
                                    if offsetD!=None: w.printc("  offsetD:%2d"%(offsetD),fg,bg,fgI,bgI)         ## DEBUG PRINT
                                    print()

                                if len(laneList)>1:
                                    print()

                            breakVocStepLoop=False
                            if len(laneList)==len([True for i in laneList if any(vocDone[i].values())]):        ## if vocDone=True for all lanes then break vocStep loop
                                breakVocStepLoop=True
                            elif eyeType=="-":
                                breakVocStepLoop=True
                            elif eyeType=="+":
                                if vcoOffset!=vcoOffsetList[0]:
                                    breakVocStepLoop=True
                                elif vcoOffset==vcoOffsetList[0] and vcoDir==-1:
                                    breakVocStepLoop=True
                            elif eyeType==".":                                                                  ## pointTest:
                                if vcoOffset!=vcoOffsetList[0] or vcoDir==-1:
                                    breakVocStepLoop=True
                            elif eyeType=="o":
                                pass

                            if breakVocStepLoop==True:
                                break

                        breakVocDirLoop=False
                        if eyeType=="-":
                            breakVocDirLoop=True
                        elif eyeType=="+":                                                                      ## do not step voc if eyeType is - or + (and not on vcoOffset=0)
                            if vcoOffset!=vcoOffsetList[0]:
                                breakVocDirLoop=True
                            elif vcoOffset==vcoOffsetList[0] and vcoDir==-1:
                                breakVocDirLoop=True
                        elif eyeType==".":
                            if vcoOffset!=vcoOffsetList[0] or vcoDir==-1:                                                       ## pointTest: only valid for voltage and/or timing tests (not full eye)
                                breakVocDirLoop=True
                            elif offsetD!=None and offsetD==0:                                                  ## pointTest: offsetD=0
                                breakVocDirLoop=True

                        if breakVocDirLoop==True:
                            for i in laneList:
                                if errCnt[i][-vocDir]==-1:
                                    errCnt[i][-vocDir] = errCnt[i][vocDir]
                                if uiCnt[i][-vocDir]==-1:
                                    uiCnt[i][-vocDir]  = uiCnt[i][vocDir]

                                for tmpVoc in vocList:
                                    if vocVal[i][tmpVoc][1]-vocVal[i][tmpVoc][-1]>eyeDict[i][j][tmpVoc]["vocU"]-eyeDict[i][j][tmpVoc]["vocD"]:
                                        eyeDict[i][j]["vcoAtMaxVoc"] = max(eyeDict[i][j]["vcoAtMaxVoc"], vcoVal[i])
                            break

                    for i in laneList:
                        if vcoDone[i]==False:
                            if eyeType==".":
                                if vcoDir==1 and offsetR!=None and offsetR==0:                                  ## pointTest at origin
                                    vcoDone[i] = True

                                elif vcoDir==-1 and offsetL!=None and offsetL==0:                               ## pointTest at origin
                                    vcoDone[i] = True
                                elif (vcoOffset!=0 or vcoDir==-1):                                              ## 1st point tested in this vcoDir
                                    vcoDone[i] = True
                            elif vcoVal[i]+vcoDir*vcoStepSize>maxVco or vcoVal[i]+vcoDir*vcoStepSize<minVco:    ## vcoClip==True
                                vcoDone[i] = True
                            elif eyeType=="o":
                                deltaVocList = [abs(c-d) for [c,d] in [list(vocVal[i][tmpVoc].values()) for tmpVoc in vocList]]
                                if vocStepSize*2 > min(deltaVocList):                                           ## force convergence of voc at left/right edge of eye if vocU/vocD delta is 1 or less
                                    vcoDone[i] = True
                                elif (uiCnt[i][ 1]!=0 and errCnt[i][ 1]//uiCnt[i][ 1]>=maxBerRate) or \
                                     (uiCnt[i][-1]!=0 and errCnt[i][-1]//uiCnt[i][-1]>=maxBerRate):             ## force convergence of voc at left/right edge of eye if errCntU/errCntD>=maxErrCnt (implies steep slope on left/right edge of eye)
                                    vcoDone[i] = True
                            elif eyeType=="|":                                                                  ## do not step vco for vertical margin test
                                vcoDone[i] = True
                            elif eyeType=="-" and (errCnt[i][1]>0 or errCnt[i][-1]>0):                          ## vco has failed at left/right edge of eye (for eyeType -)
                                vcoDone[i] = True
                            elif eyeType=="+" and (errCnt[i][1]>0 or errCnt[i][-1]>0) and (vcoOffset!=vcoOffsetList[0] or vcoDir==-1):  ## vco has failed at left/right edge of eye (for eyeType +)
                                vcoDone[i] = True

                        if vcoDone[i]==True:
                            if eyeType=="|":
                                eyeDict[i][j]["vcoL"] = eyeDict[i][j]["strtVco"]
                                eyeDict[i][j]["vcoR"] = eyeDict[i][j]["strtVco"]
                            else:
                                if eyeType!="|" and (jitterMode==False and offsetMode==False):
                                    w.stepVco(tile, portId, lane=i, value=0)                                    ## upon fail, step vco back to original starting point

                                if eyeType=="o":
                                    deltaVocList = [abs(c-d) for [c,d] in [list(vocVal[i][tmpVoc].values()) for tmpVoc in vocList]]
                                    if vocStepSize*2 > min(deltaVocList):                                       ## force convergence of voc at left/right edge of eye if vocU/vocD delta is 1 or less
                                        errCnt[i][ 1] = max(errCnt[i][1],errCnt[i][-1])
                                        errCnt[i][-1] = max(errCnt[i][1],errCnt[i][-1])
                                        for tmpVoc in vocList:
                                            tmpVal = int(vocVal[i][tmpVoc][-1] + (vocVal[i][tmpVoc][1] - vocVal[i][tmpVoc][-1])/2.0) 
                                            vocVal[i][tmpVoc][ 1] = tmpVal
                                            vocVal[i][tmpVoc][-1] = tmpVal
                                    elif (uiCnt[i][ 1]!=0 and errCnt[i][ 1]//uiCnt[i][ 1]>=maxBerRate) or \
                                         (uiCnt[i][-1]!=0 and errCnt[i][-1]//uiCnt[i][-1]>=maxBerRate):         ## force convergence of voc at left/right edge of eye if errCntU/errCntD>=maxErrCnt (implies steep slope on left/right edge of eye)
                                        errCnt[i][ 1] = max(errCnt[i][1],errCnt[i][-1])
                                        errCnt[i][-1] = max(errCnt[i][1],errCnt[i][-1])
                                        for tmpVoc in vocList:
                                            tmpVal = int(vocVal[i][tmpVoc][-1] + (vocVal[i][tmpVoc][1] - vocVal[i][tmpVoc][-1])/2.0) 
                                            vocVal[i][tmpVoc][ 1] = tmpVal
                                            vocVal[i][tmpVoc][-1] = tmpVal

                                if vcoDir==1:
                                    for tmpVoc in vocList:
                                        eyeDict[i][j][tmpVoc]["vocR"] = vocVal[i][tmpVoc][vcoDir]               ## record voc value at right edge

                                    eyeDict[i][j]["errCntR"]    = errCnt[i][1]
                                    eyeDict[i][j]["uiCntR"]     = uiCnt[i][1]
                                    eyeDict[i][j]["vcoR"]       = vcoVal[i]
                                else:
                                    for tmpVoc in vocList:
                                        eyeDict[i][j][tmpVoc]["vocL"] = vocVal[i][tmpVoc][vcoDir]               ## record voc value at left edge

                                    eyeDict[i][j]["errCntL"]    = errCnt[i][-1]
                                    eyeDict[i][j]["uiCntL"]     = uiCnt[i][-1]
                                    if vcoVal[i]==-1:
                                        eyeDict[i][j]["vcoL"]   = 0                                             ## failed at first vco step left (strtVcoOffset=-1); adjust vcoL margin to reflect 0
                                    else:
                                        eyeDict[i][j]["vcoL"]   = vcoVal[i]

                            if errCnt[i][1]==0 or errCnt[i][-1]==0:
                                if vcoVal[i]+vcoDir*vcoStepSize>maxVco:
                                    vcoClip[i] = True
                                    eyeDict[i][j]["vcoClip"] = True
                                elif vcoVal[i]+vcoDir*vcoStepSize<minVco:
                                    vcoClip[i] = True
                                    eyeDict[i][j]["vcoClip"] = True

                    if showProg==True and logResults==True:
                        w.showProgress(type=None)

                    for i in laneList:                                                                          ## log output results
                        if logResults==True or returnRpcData==True:
                            if vcoDone[i]!=None and (logAllSteps==True or errCnt[i][1]>0 or errCnt[i][-1]>0):
                                if ssa==False: 
                                    dataStr1 = "%2d\t%s\t%s\t"%(totVcoSteps[i], tile._tileName, portId)

                                    print("%s\t"%dataStr1, end=' ')

                                    vocValStr = ""
                                    for tmpVoc in vocList:
                                        vocValStr += "\t%6d\t%6d"%(vocVal[i][tmpVoc][1],vocVal[i][tmpVoc][-1])

                                    dataStr2 = "\t%s\t%4.1f\t%6d%s\t%10.2E\t%10.2E\t%8d\t%7d\t"%(tile._partId,baudRate,vcoVal[i],vocValStr,uiCnt[i][1],uiCnt[i][-1],errCnt[i][1],errCnt[i][-1])

                                    dataStr3 = ""
                                    for key in findEyeKeys:
                                        dataStr3 += "%s\t"%eyeDict[i][j][key]

                                    if any(vocClip[i].values())==True or vcoClip[i]==True:
                                        print("", end=' ')
                                        w.printc("%2d"%i, "yellow", "yellow", True, False)                      ## color-code lane number "yellow" if vocClip
                                    elif vcoDone[i]==True and eyeType!="." and (errCnt[i][1]>0 and errCnt[i][-1]>0):
                                        print("", end=' ')
                                        w.printc("%2d"%i, "grey", "red", True, False)                           ## color-code lane number "red" if vcoDone=True
                                    else:
                                        print("%2d"%(i), end=' ')
                                    print("%s"%dataStr2)
                                    rpcDataStr = "%s\t%2d\t%s"%(dataStr1,i, dataStr2)
                                    rpcData = rpcDataStr.split("\t")
                                    rpcData = [x for x in rpcData  if (x != "")]
                                    rpcDataResult[totVcoSteps[i]] = {}
                                    for rpcStep, key in enumerate(rpcHdr):
                                        rpcDataResult[totVcoSteps[i]][key] = rpcData[rpcStep]

                                    dataStr4 = "%s"%(eyeDict[i][sampList[0]]["rxStatsStr"])

                                    if w.isList(dataSuffix):                                                    ## list of strings, numbers and/or lane-indexed dictionaries
                                        tmpDataSuffix = ""
                                        for a in range(len(dataSuffix)):
                                            if w.isDict(dataSuffix[a]) and i in list(dataSuffix[a].keys()):         ## dictionary keys should be lane numbers
                                                tmpDataSuffix += "%s\t"%dataSuffix[a][i]
                                            else:
                                                tmpDataSuffix += "%s\t"%dataSuffix[a]
                                    else:
                                        tmpDataSuffix = dataSuffix

                                    _log.info("%s%2d%s%s%s%s", dataStr1, i, dataStr2, dataStr3, dataStr4, tmpDataSuffix)

                                elif ssa==True:
                                    timeStr = strftime("%m/%d/%y %H:%M:%S")

                                    [ndfe1,ndfe2,ndfe3,ndfe4,ndfe5,ndfe6,ndfe7,ndfe8] = [(dfe*1.6) / (rxVrefDict[i]*2.5) for dfe in dfeDict[i] if dfe!=None] if rxVrefDict[i]>0 else [0,0,0,0,0,0,0,0]

                                    tmpStrtVco  = eyeDict[i][j]["strtVco"]
                                    tmpVcoL = eyeDict[i][j]["strtVcoL"]
                                    tmpVcoR = eyeDict[i][j]["strtVcoR"]
                                    tmpStrtVoc  = eyeDict[i][j]["strtVoc"]

                                    (adjVco, adjVocU, adjVocD, tmpStrtVco, adjVcoL, adjVcoR, tmpStrtVoc, adjVocM) = normEyeData(vcoVal[i], vocVal[i][tmpVoc][1], vocVal[i][tmpVoc][-1], strtVco=tmpStrtVco, vcoL=tmpVcoL, vcoR=tmpVcoR, strtVoc=tmpStrtVoc, vocM=None, vcoDir=vcoDir, normPlot=normPlot)

                                    writer.WriteRow(strftime("%m/%d/%y"), strftime("%H:%M:%S"), totVcoSteps[i], "Wharf_Rock", "tile%d"%tile._tileName, portId, mode, baudRate, i, vcoVal[i], vocVal[ 1][i], uiCnt[i][ 1], errCnt[i][ 1], timeStr, loopCnt, eyeDict[i][j]["strtVco"], eyeDict[i][j]["strtVoc"], adjVco, adjVocU, ndfe1, ndfe2, ndfe3, ndfe4, ndfe5, ndfe6, ndfe7, ndfe8, attenDict[i])
                                    writer.WriteRow(strftime("%m/%d/%y"), strftime("%H:%M:%S"), totVcoSteps[i], "Wharf_Rock", "tile%d"%tile._tileName, portId, mode, baudRate, i, vcoVal[i], vocVal[-1][i], uiCnt[i][-1], errCnt[i][-1], timeStr, loopCnt, eyeDict[i][j]["strtVco"], eyeDict[i][j]["strtVoc"], adjVco, adjVocD, ndfe1, ndfe2, ndfe3, ndfe4, ndfe5, ndfe6, ndfe7, ndfe8, attenDict[i])

                                totVcoSteps[i]+=1

                        plotPoints = False

                        if vcoDone[i]==True:
                            vcoDone[i]=None                                                                     ## vcoDone[i]=None indicates margin activity is complete for lane=i for this vcoDir

                    if eyeType=="o":
                        for i in laneList:
                            if vcoDone[i]==False:
                                for tmpVoc in vocList:
                                    if any(vocClip[i].values())==True:                                          ## step voc to mid-point of last vco step on failure or end of voc range
                                        vocMid[i][tmpVoc] = eyeDict[i][j][tmpVoc]["strtVoc"]
                                    else:
                                        vocMid[i][tmpVoc] = int(vocVal[i][tmpVoc][-1] + 0.5*(vocVal[i][tmpVoc][1] - vocVal[i][tmpVoc][-1]))

                                for tmpVoc in vocList:
                                    if tmpFastAcq[i]==True:
                                        for tmpVocDir in vcoDirList:
                                            nextVal = vocVal[i][tmpVoc][tmpVocDir] - (tmpVocDir*fastAcqBuffer)
    
                                            if tmpVocDir==1 and nextVal<vocMid[i][tmpVoc]:
                                                vocNxt[i][tmpVoc][tmpVocDir] = vocMid[i][tmpVoc]
                                            elif tmpVocDir==-1 and nextVal>vocMid[i][tmpVoc]:
                                                vocNxt[i][tmpVoc][tmpVocDir] = vocMid[i][tmpVoc]
                                            elif nextVal in range(minVoc,maxVoc+1):
                                                vocNxt[i][tmpVoc][tmpVocDir] = nextVal
                                            else:
                                                vocNxt[i][tmpVoc][tmpVocDir] = vocMid[i][tmpVoc]
                                    else:
                                        vocNxt[i][tmpVoc][ 1] = vocMid[i][tmpVoc]
                                        vocNxt[i][tmpVoc][-1] = vocMid[i][tmpVoc]

                    for i in laneList:
                        if any(vocDone[i].values())==True:                                                      ## step voc to mid-point of last tested vco step if vocDone
                            for tmpVoc in vocList:
                                nxtVocOffset = vocNxt[i][tmpVoc][-vocDir]-eyeDict[i][j][tmpVoc]["strtVoc"]
                                w.stepVoc(tile, portId, lane=i, voc=tmpVoc, value=nxtVocOffset)

                    if len(laneList)==len([None for i in laneList if vcoDone[i]==None]):                        ## if vcoDone=None for all lanes then break vocStep loop
                        if logResults==True and showProg==True and logAllSteps==True and vcoDir==1 and ssa==False:
                            if len(laneList)>1 or (len(laneList)==1 and eyeType in ["+","-","|","o"]):
                                print()
                        break
                    elif eyeType=="|":
                        break
                    elif vcoOffset==maxVcoRange-vcoDir:                                                         ## margin greather than maxVcoRange; mainly for "masterSlave" mode
                        break

                    if len(laneList)>1 and logResults==True and showProg==True and logAllSteps==True and ssa==False:
                        print()

                if doNotTouchVoc==False:
                    for i in laneList:
                        for tmpVoc in vocList:
                            w.stepVoc(tile, portId, lane=i, voc=tmpVoc, value=0)                                ## step VOC back to center

                if eyeType=="|":
                    break
                elif eyeType==".":
                    if vcoDir==1 and offsetL!=None and offsetL==0:
                        break

            if eyeType!="|" and (jitterMode==False and offsetMode==False):
                for i in laneList:
                    w.stepVco(tile, portId, lane=i, value=0)                                                    ## move back to center

        if ssa==True and not((logResults==False and returnResults==None) or returnResults==True):
            return writer
    try:
        pass
    except whrPhyMarginError as e:
        if w._ssa==True: 
            raise
        else:
            if txEqList!=None:
                w.printc("\n%s\n"%(e),"grey","red",True,False,srchStr="ERROR")

    except KeyboardInterrupt:
        raise

    except:
        raise

    finally:
        if eyeDict[laneList[0]][sampList[0]]["strtVco"]!=-1:                                                    ## check that initialization loop was started above
            if showProg==True and logResults==True:
                tmpMsg = "... performing clean-up operations (%s_%s)"%(tile._tileName, portId)
                w.showProgress(None, type="time", msg=tmpMsg)

            if (state=="test" and pattern!=None) or (patt0!=None and patt1!=None and patt2!=None and patt3!=None):
                w.setReutPattBuff(tile, portId, buffSel=0, prbs=True)                                           ## reset pattern buffer to PRBS

                if slv!=None and slvPortId!=None:
                    if w._changeVp==True and slv!=w._tile: w.changeItpViewPoint(slv)
                    w.setRxLoopStatus(slv, slvPortId, laneMask=slvRxLaneMask, loop=None, status="cl", showProg=showProg)    ## close loops on slave device after all tile's sending PRBS
                    if w._changeVp==True and tile!=w._tile: w.changeItpViewPoint(tile)

            for i in laneList:
                if doNotTouchVoc==False:
                    for tmpVoc in vocList:
                        w.stepVoc(tile, portId, lane=i, voc=tmpVoc, value=0)                                    ## step VOC back to center

                w.stepVco(tile, portId, lane=i, value=0)                                                        ## move VCO back to center

            if logResults==True and logfile==None:
                _log.setFile(None)

            if state=="l0" and skipInit!=True:
                for i in laneList:
                    w.setRxCalContinuous(tile, portId, i, value=strtRxCalCont[i])
                    w.setRxAdaptContinuous(tile, portId, i, value=strtRxAdaptCont[i])
    
                if w._getMode(portId)=="u":
                    tile.upi_phy.ph_tl0c_op.tl0c            = strtTl0c
                    tile.upi_link.ll_lcl.max_phy_abort      = strtMpa
                    tile.upi_link.ll_lcl.max_retry          = strtMr
                    tile.upi_phy.ph_ctr1.cenablephyresetd   = resetD     
                    tile.upi_phy.ph_ctr1.cenablephyresetw   = resetW     
                    tile.upi_phy.ph_ctr1.crxresetdis        = resetDis 

            for i in laneList:
                w.clearErrCnt(tile, portId, lane=i)

            w.setPhyInit(tile, portId, value=1)

        if showProg==True:
            w.showProgress(type=None)
            if logResults==True and ssa==False:
                w.showProgress(None, type="time", msg=msg)
                print()

        endTime = time()
        for i in laneList:
            for j in sampList:
                eyeDict[i][j]["testTime"]   = int(endTime - strtTime)                                           ## seconds
                eyeDict[i][j]["totalTime"]  = int(endTime - w._startTime) if w._startTime!=None else 0          ## seconds
                eyeDict[i][j]["endTime"]    = ctime(endTime).split()[3]                                         ## hh:mm:ss

        for i in laneList:
            if firmwareEnabled[i]==0:
                w.enableFirmware(tile, portId, lane=i)

        if (returnRpcData==True):
            return (eyeDict, rpcDataResult)

        if (logResults==False and returnResults==None) or returnResults==True:
            return(eyeDict)

def findEyeMargin(tile, portId, lane=None, laneMask=None, laneList=None, eyeType="+", vocList=_tmpVocList, dwell=w._dwell, state=None, startTime=None, logSuffix="", skipInit=False, showProg=True, msg="", offset=None, offsetL=None, offsetR=None, offsetU=None, offsetD=None, showPlot=None, normPlot=True, yAxis=None, logResults=True, logfile=None, logHdr=True, getRxStats=True, returnResults=None, hdrSuffix="", dataSuffix="", laneRev=None, vcoStepSize=1, vocStepSize=1, boardId=None, debug=False, contCal=False, contAdapt=False, returnRpcData=True):
    if w._debug: w._showFunctionInfo(sys._getframe(0))

###############################################################################
##                                                                            #
##  command options deprecated / hardcoded to simplify initial code debug:    #
##  options that are commented below remain as existing user command options  #
##                                                                            #
###############################################################################
#                                                                             #
    setupSlave = False                                                        #
#                                                                             #
###############################################################################

    w._startTime = startTime

    if laneMask!=None and w.isString(laneMask)==True:
        laneMask = w.xlateLaneMask(tile, portId, laneMaskStr=laneMask)

    if laneList==None:
        laneList = w.getLaneList(tile, portId, lane, laneMask, type="byPort")


    maxVoc  = w._rxCalDict["dseh"][1]
    portId  = portId.lower()

    if eyeType=="o":
        eyeType="+"

    if state==None:
        if w._access not in ("itpii","stub"):
            state="l0"
        else:
            state="test"

    if (returnRpcData == True):
        (eyeDict, rpcDataResult) = findEye(tile, portId, lane=lane, laneMask=laneMask, laneList=laneList, eyeType=eyeType, vocList=vocList, dwell=dwell, state=state, startTime=startTime, logSuffix=None,      skipInit=skipInit, showProg=showProg, msg=msg, offset=offset, offsetL=offsetL, offsetR=offsetR, offsetU=offsetU, offsetD=offsetD, normPlot=normPlot, logResults=False, logHdr=True, returnResults=True, laneRev=laneRev, vcoStepSize=vcoStepSize, vocStepSize=vocStepSize, boardId=boardId, debug=debug, contCal=contCal, contAdapt=contAdapt, returnRpcData=returnRpcData)
    else:
        eyeDict = findEye(tile, portId, lane=lane, laneMask=laneMask, laneList=laneList,
                                           eyeType=eyeType, vocList=vocList, dwell=dwell, state=state,
                                           startTime=startTime, logSuffix=None, skipInit=skipInit, showProg=showProg,
                                           msg=msg, offset=offset, offsetL=offsetL, offsetR=offsetR, offsetU=offsetU,
                                           offsetD=offsetD, normPlot=normPlot, logResults=False, logHdr=True,
                                           returnResults=True, laneRev=laneRev, vcoStepSize=vcoStepSize,
                                           vocStepSize=vocStepSize, boardId=boardId, debug=debug, contCal=contCal,
                                           contAdapt=contAdapt, returnRpcData=returnRpcData)

    baudRate = w.getBaudRate(tile, portId)

    sampList = [0]


    if eyeDict!=None:
        findEyeKeys = list(eyeDict[laneList[0]][sampList[0]].keys())
        findEyeKeys.remove("rxStatsStr")

        for tmpVoc in vocList:
            findEyeKeys.remove(tmpVoc)

        findEyeKeys.sort()

        if logfile!=None or logResults==True:
            if logfile==None:
                logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix
                tmpPartId = "" if tile._partId==tile._tileName else "-%s"%tile._partId
                logfile = "%s_%s_Rx-%s_%s%s_%0.1f%s.tsv"%(strftime("%y%m%d_%H%M%S"),sys._getframe(0).f_code.co_name,tile._tileName,portId,tmpPartId,baudRate,logSuffix)

                if w._cds==True: _log.cdsInit(activity="SMV", delimiter="\t", commitWhenFileSetNone=w._cdsNoFileSet, logToFile=True)

            _log.setFile(logfile, overwrite=False)
            _log.setFileLevel("INFO")
            _log.setFileFormat("simple")

            if logHdr==True:
                hdrStr1 = "tile\tportId\tlane\tsampler\tpartId\tbaudRate"
                hdrStr2 = "marginL\tmarginR\tvcoCenter\tmarginU\tmarginD\tvocCenter\teyeWidth\teyeHeight"
                hdrStr3 = "minMarginT\tminMarginV"
                hdrStr4 = str(findEyeKeys)[2:-2].replace("', '", "\t")
                rxStatsHdrStr = w.getRxStats(tile, portId, lane=laneList[0], returnHdr=True, getCal=getRxStats, getLoop=getRxStats, loopCnt=1)

                if showProg==True: w.showProgress(type=None)

                print("%s\t%s"%(hdrStr1, hdrStr2))
                _log.info("%s\t%s\t%s\t%s%s%s%s"%(hdrStr1, hdrStr2, hdrStr3, hdrStr4, "\t" if rxStatsHdrStr!="" else "", rxStatsHdrStr, hdrSuffix))


        for i in laneList:
            for j in sampList:
                vcoL        = eyeDict[i][j]["vcoL"]
                vcoR        = eyeDict[i][j]["vcoR"]
                strtVco     = eyeDict[i][j]["strtVco"]
                marginL     = strtVco - vcoL
                marginR     = vcoR - strtVco

                marginU = 999
                marginD = 999
                for tmpVoc in vocList:
                    vocU    = eyeDict[i][j][tmpVoc]["vocU"]
                    vocD    = eyeDict[i][j][tmpVoc]["vocD"]
                    strtVoc = eyeDict[i][j][tmpVoc]["strtVoc"]
                    marginU = min(marginU, max(0, vocU - strtVoc))                                              ## vocU = -1 if findEye fails to train
                    marginD = min(marginD, max(0, strtVoc - vocD))                                              ## vocD = -1 if findEye fails to train

                eyeWidth    = marginL + marginR
                eyeHeight   = marginU + marginD
                minMarginT  = min(marginL, marginR)
                minMarginV  = min(marginU, marginD)
                vcoCenter   = 0 if eyeWidth==0  else round(100 * (marginL / float(eyeWidth)),  0)
                vocCenter   = 0 if eyeHeight==0 else round(100 * (marginU / float(eyeHeight)), 0)

                if (logResults==False and returnResults==None) or returnResults==True:
                    eyeDict[i][j]["marginL"]    = marginL
                    eyeDict[i][j]["marginR"]    = marginR
                    eyeDict[i][j]["marginU"]    = marginU
                    eyeDict[i][j]["marginD"]    = marginD
                    eyeDict[i][j]["eyeWidth"]   = eyeWidth
                    eyeDict[i][j]["eyeHeight"]  = eyeHeight
                    eyeDict[i][j]["minMarginT"] = minMarginT
                    eyeDict[i][j]["minMarginV"] = minMarginV
                    eyeDict[i][j]["vcoCenter"]  = vcoCenter
                    eyeDict[i][j]["vocCenter"]  = vocCenter

                elif logResults==True:
                    if showProg==True:
                        w.showProgress(type=None)

                    dataStr1 = "%s\t%s\t%2d\t%2d\t%s\t%4.1f"%(tile._tileName, portId, i, j, tile._partId, baudRate)
                    dataStr2 = "%3d\t%3d\t%3d\t%3d\t%3d\t%3d\t%3d\t%3d"%(marginL, marginR, vcoCenter, marginU, marginD, vocCenter, eyeWidth, eyeHeight)
                    print("%s\t%s"%(dataStr1, dataStr2))

                    dataStr3 = "%3d\t%3d"%(minMarginT, minMarginV)
                    dataStr4 = ""
                    for key in findEyeKeys:
                        if key not in _tmpVocList:
                            dataStr4 += "%s\t"%eyeDict[i][j][key]

                    tmpDataSuffix = ""
                    if w.isList(dataSuffix):                                                                    ## list of strings, numbers and/or lane-indexed dictionaries
                        for a in range(len(dataSuffix)):
                            if w.isDict(dataSuffix[a]) and i in list(dataSuffix[a].keys()):                         ## dictionary keys should be lane numbers
                                tmpDataSuffix += "%s\t"%dataSuffix[a][i]
                            else:
                                tmpDataSuffix += "%s\t"%dataSuffix[a]
                    else:
                        tmpDataSuffix = dataSuffix

                    _log.info("%s\t%s\t%s\t%s%s%s"%(dataStr1, dataStr2, dataStr3, dataStr4, eyeDict[i][j]["rxStatsStr"], tmpDataSuffix))

    if showProg==True and (len(laneList)>1 or (state=="l0" and laneList[0]==w.getLaneList(tile, portId)[-1])):
        w.showProgress(type=None)
        w.showProgress(None, type="time")
        print()

    if logResults==True and logfile==None:
        _log.setFile(None)

    if (returnRpcData==True):
        return (eyeDict, rpcDataResult)

    if (logResults==False and returnResults==None) or returnResults==True:
        return(eyeDict)

def findEyeRepeat(tile=None, portId=None, lane=None, laneMask=None, laneList=None, eyeType="+", vocList=_tmpVocList, dwell=w._dwell, state=None, startTime=None, logSuffix="", skipInit=False, showProg=True, msg="", showPlot=None, normPlot=True, logResults=True, logfile=None, logHdr=True, plotAllPointsTested=False, getRxStats=True, testName="findEyeMargin", returnResults=None, hdrSuffix="", dataSuffix="", laneRev=None, vcoStepSize=1, vocStepSize=1, offset=None, offsetL=None, offsetR=None, offsetU=None, offsetD=None, boardId="", xAxis=None, yAxis=None, debug=False, trialCnt=5, strtCnt=1, portIdList=None, contCal=False, contAdapt=False, showTestHeader=True, mode=None, subTitle="", returnRpcData=True):
    if w._debug: w._showFunctionInfo(sys._getframe(0))

    w._startTime = startTime

###############################################################################
##                                                                            #
##  command options deprecated / hardcoded to simplify initial code debug:    #
##  options that are commented below remain as existing user command options  #
##                                                                            #
###############################################################################
#                                                                             #
    setupSlave = False                                                        #
#                                                                             #
###############################################################################

    if eyeType=="o":
        testName = "findEye"

    baudRate = w.getBaudRate(tile, portId)

    tileList = w._tileList if tile==None else [tile]

    if logfile!=None or logResults==True:
        if logfile==None:
            logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix

            if tile!=None and portId!=None:
                tmpBaudRate = w.getBaudRate(tile, portId) if baudRate==None else baudRate
                tmpPartId = "" if tile._partId==tile._tileName else "-%s"%tile._partId
                logfile = "%s_%s_Rx-%s_%s%s_%0.1f_%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), sys._getframe(0).f_code.co_name, tile._tileName, portId, tmpPartId, tmpBaudRate, boardId, logSuffix)
            elif tile==None and portId!=None:
                logfile = "%s_%s_Rx-%s_%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), sys._getframe(0).f_code.co_name, portId, boardId, logSuffix)
            elif tile!=None and portId==None:
                tmpPartId = "" if tile._partId==tile._tileName else "-%s"%tile._partId
                logfile = "%s_%s_Rx-%s%s_%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), sys._getframe(0).f_code.co_name, tile._tileName, tmpPartId, boardId, logSuffix)
            else:
                logfile = "%s_%s_%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), sys._getframe(0).f_code.co_name, boardId, logSuffix)

            logfile = logfile.replace("_.",".")

        if w._cds==True: _log.cdsInit(activity="SMV", delimiter="\t", commitWhenFileSetNone=w._cdsNoFileSet, logToFile=True)

        _log.setFile(logfile, overwrite=False)
        _log.setFileLevel("INFO")
        _log.setFileFormat("simple")

    firstTime = True
    for trial in range(strtCnt, strtCnt+trialCnt):

        if w.isString(dataSuffix)==True or w.isNumber(dataSuffix)==True:
            tmpHdrSuffix = "%s\t%s\t%s"%("trial", "testName", hdrSuffix)
            tmpDataSuffix = "%d\t%s\t%s"%(trial, testName, dataSuffix)
        elif w.isList(dataSuffix)==True:                                                                        ## list of strings, numbers and/or lane-indexed dictionaries
            tmpHdrSuffix = "%s\t%s\t%s"%("trial", "testName", hdrSuffix)
            tmpDataSuffix = deepcopy(dataSuffix)
            tmpDataSuffix.insert(0,testName,trial)

        for tmpTile in tileList:
            if portIdList==None:
                portIdList = [portId] if portId!=None else w.getPortIdList(tmpTile, mode=mode)

            for tmpPortId in portIdList:

                tmpState = w.getLtssmStateType(tmpTile, tmpPortId) if state==None else state
                tmpBaudRate = max(w._baudRateDict[w._getMode(tmpPortId)].values()) if (baudRate!=None and w.isString(baudRate)==True and baudRate.lower()=="max") else baudRate
                tstLaneMask = w.xlateLaneMask(tmpTile, tmpPortId, laneMaskStr=laneMask) if (laneMask!=None and w.isString(laneMask)==True) else laneMask

                tmpSuffix = ("_%s%s_%s"%(boardId, logSuffix, trial)).replace("__","_")
                if showTestHeader==True:
                    w.printc("(%s) %s_%s%s: %s\n"%(testName, tmpTile._tileName, tmpPortId, tmpSuffix, dataSuffix.replace("\t","_")), "yellow", "black", True, False)

                runCnt      = 1
                runRange    = list(range(runCnt)) if (tmpState!="l0") else w.getLaneList(tmpTile, tmpPortId, lane, tstLaneMask, type="byPort")
                perLane     = True if tmpState=="l0" else False
                results = {}
                for i in runRange:                                                                              ## runRange=laneList for perLane testing
                    if logHdr!=False:
                        logHdr = True if (tmpTile==tileList[0] and tmpPortId==portIdList[0] and trial==strtCnt and i==runRange[0]) else False

                    tmpLane = lane if perLane==False else i
                    tmpLaneMask = tstLaneMask

                    if testName=="findEye":
                        results[i] = findEye(tmpTile, tmpPortId, lane=tmpLane, laneMask=tmpLaneMask, laneList=laneList, eyeType=eyeType, vocList=vocList, dwell=dwell, state=tmpState, startTime=startTime, logSuffix=tmpSuffix, skipInit=skipInit, showProg=showProg, msg="", showPlot=showPlot, offset=offset, offsetL=offsetL, offsetR=offsetR, offsetU=offsetU, offsetD=offsetD, normPlot=normPlot, logResults=logResults, logfile=logfile, logHdr=logHdr, plotAllPointsTested=plotAllPointsTested, getRxStats=getRxStats, testName=testName, hdrSuffix=tmpHdrSuffix, dataSuffix=tmpDataSuffix, laneRev=laneRev, vcoStepSize=vcoStepSize, vocStepSize=vocStepSize, boardId=boardId, xAxis=xAxis, yAxis=yAxis, debug=debug, contCal=contCal, contAdapt=contAdapt, subTitle=subTitle,returnResults=returnResults, returnRpcData=returnRpcData)
                    elif testName=="findEyeMargin":
                        results[i] = findEyeMargin(tmpTile, tmpPortId, lane=tmpLane, laneMask=tmpLaneMask, laneList=laneList, eyeType=eyeType, vocList=vocList, dwell=dwell, state=tmpState, startTime=startTime, logSuffix=tmpSuffix, skipInit=skipInit, showProg=showProg, msg="", showPlot=showPlot, offset=offset, offsetL=offsetL, offsetR=offsetR, offsetU=offsetU, offsetD=offsetD, normPlot=normPlot, logResults=logResults, logfile=logfile, logHdr=logHdr, getRxStats=getRxStats, hdrSuffix=tmpHdrSuffix, dataSuffix=tmpDataSuffix, laneRev=laneRev, vcoStepSize=vcoStepSize, vocStepSize=vocStepSize, boardId=boardId, debug=debug, contCal=contCal, contAdapt=contAdapt,returnResults=returnResults , returnRpcData=returnRpcData)
                    else:
                        print("ERROR testName not defined")
                        raise

    if logResults==True:
        _log.setFile(None)

    if returnResults==True or returnRpcData==True:
        return results

def normEyeData(vco=None, vocU=None, vocD=None, strtVco=None, vcoL=None, vcoR=None, strtVoc=None, vocM=None, vcoDir=1, normPlot=True):
    if w._debug: w._showFunctionInfo(sys._getframe(0))

    adjVco  = (vco-strtVco)  if (normPlot==True and strtVco!=None and vco !=None) else vco
    adjVcoL = (strtVco-vcoL) if (normPlot==True and strtVco!=None and vcoL!=None) else vcoL
    adjVcoR = (strtVco-vcoR) if (normPlot==True and strtVco!=None and vcoR!=None) else vcoR

    adjVocU = (vocU-strtVoc) if (normPlot==True and strtVoc!=None and vocU!=None) else vocU
    adjVocD = (vocD-strtVoc) if (normPlot==True and strtVoc!=None and vocD!=None) else vocD
    adjVocM = (vocM-strtVoc) if (normPlot==True and strtVoc!=None and vocM!=None) else vocM

    adjStrtVco  = 0 if (normPlot==True and strtVco!=None) else strtVco
    adjStrtVoc  = 0 if (normPlot==True and strtVoc!=None) else strtVoc

    return(adjVco, adjVocU, adjVocD, adjStrtVco, adjVcoL, adjVcoR, adjStrtVoc, adjVocM)

class whrPhyMarginError(Exception):
    if w._ssa==True:
        def __str__(self):
            return self.args

