#!/usr/bin/env python
##############################################################################
# INTEL CONFIDENTIAL
# Copyright 2005 2006 Intel Corporation All Rights Reserved.
#
# The source code contained or described herein and all documents related
# to the source code (Material) are owned by Intel Corporation or its
# suppliers or licensors. Title to the Material remains with Intel Corp-
# oration or its suppliers and licensors. The Material may contain trade
# secrets and proprietary and confidential information of Intel Corpor-
# ation and its suppliers and licensors, and is protected by worldwide
# copyright and trade secret laws and treaty provisions. No part of the
# Material may be used, copied, reproduced, modified, published, uploaded,
# posted, transmitted, distributed, or disclosed in any way without
# Intel's prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellect-
# ual property right is granted to or conferred upon you by disclosure or
# delivery of the Materials, either expressly, by implication, inducement,
# estoppel or otherwise. Any license under such intellectual property
# rights must be express and approved by Intel in writing.
##############################################################################

"""
    INTEL CONFIDENTIAL - DO NOT RE-DISTRUBUTE
    Copyright 2010 Intel Corporation All Rights Reserved.

    CVS/SVN information:
        $Author: dagreene $
        $Revision: 905146 $
        $Date: 2020-04-24 14:00:50 -0700 (Fri, 24 Apr 2020) $
        $Log: whrPhy.py $
"""

###############################################################################
##                                                                            #
##      imports & general module setup                                        #
##                                                                            #
###############################################################################

from __future__ import print_function
from __future__ import division
from __future__ import unicode_literals

import os as _os
import sys as _sys
import string as _string
import traceback as _traceback
import namednodes as _namednodes

from math   import log
from math   import ceil
from math   import floor
from time   import time
from time   import sleep
from time   import strftime
from copy   import deepcopy
from random import random
from random import randint
from random import choice
from namednodes.utils.bitmanip import bits

#try:
#   import pysvtools.cdcEvTools.cdsApi as cdsApi
#   _log = cdsApi.getLogger(_sys.argv[0])
#except ImportError:
#   import svtools.logging.toolbox as tools
#   _log = tools.getLogger(_sys.argv[0])
    
#import pysv_fpga.ptile.dummy_logger as dumbo
from .dummy_logger import DummyLogger
_log = DummyLogger()

_log.setFile(str.replace(str(_sys.argv[0]), ".py", "") + ".log")

###############################################################################
##                                                                            #
##      global variables: lambda functions                                    #
##                                                                            #
###############################################################################

_getMode            = lambda portId: None if portId==None else portId[0].lower()
_getPortNum         = lambda portId: None if portId==None else int(portId[1:])
_getQuadNum         = lambda tile,portId,lane: None if lane==None else _getTileLane(tile,portId,lane)//4
_getQuadLane        = lambda tile,portId,lane: None if lane==None else _getTileLane(tile,portId,lane)%4
_getFrange          = lambda strt,stop,step,mult: [a/float(mult) for a in range(int(strt*mult),int(stop*mult),int(step*mult))]
_getTileList        = lambda tile=None: [c for d in [list(_tileDict[b].values()) for b in [a for a in list(_tileDict.keys())]] for c in d] if tile==None else [_tileDict[tile._fpgaNum][tile._tileNum]]
_getSign            = lambda var: 1 if var>=0 else -1
_getTileLane        = lambda tile,portId, lane: _getTileStopLane(tile,portId)-lane if getLaneReversal(tile,portId) else _getTileStrtLane(tile,portId)+lane
_getPortWidth       = lambda tile,portId: abs(_getTileStrtLane(tile,portId) - _getTileStopLane(tile,portId))+1
_getTileStrtLane    = lambda tile,portId: _tileConfigDict[tile._fpgaNum][tile._tileNum][portId.lower()]["tileStrtLane"]
_getTileStopLane    = lambda tile,portId: _tileConfigDict[tile._fpgaNum][tile._tileNum][portId.lower()]["tileStopLane"]

###############################################################################
##                                                                            #
##      global variables: user controlled                                     #
##                                                                            #
###############################################################################

_access         = None
_subAccess      = None
_debug          = None
_quiet          = None
_showTopCallOnly= False
_printColor     = True
_callDepth      = 0
_showStatus     = False
_broadcast      = False
_initStubMode   = True                                                                                          ## stub mode only
_stubStateType  = None                                                                                          ## stub mode only
_randomizeStub  = True                                                                                          ## stub mode only
_randomizePorts = True                                                                                          ## stub mode only
_incFigure      = True
_showAllPlots   = None
_closeAllPlots  = False                                                                                         ## mainly used during lengthy regressions
_saveAllPlots   = True                                                                                          ## mainly used during lengthy regressions
_savePlotDict   = True
_startTime      = None
_cds            = False                                                                                         ## _cds=True will log data to CDS database as well as text file
_cdsNoFileSet   = True
_refClk         = 100.0
_mpll           = "a"
_dwell          = 0.100
_tabStop        = 4
_showWarnings   = True
_regression     = False
_useStatusRegs  = True
_pyVersion      = _sys.version_info[0]

###############################################################################
##                                                                            #
##      function prefix (and color convention when _debug=True)               #
##                                                                            #
###############################################################################

_colorDict  = {  "get": {"fg":"grey",   "bg":"black",   "fgInt":True,  "bgInt":True },
                 "set": {"fg":"grey",   "bg":"red",     "fgInt":False, "bgInt":False},
                "find": {"fg":"grey",   "bg":"green",   "fgInt":True,  "bgInt":False},
                 "log": {"fg":"grey",   "bg":"magenta", "fgInt":True,  "bgInt":True },
               "reset": {"fg":"grey",   "bg":"yellow",  "fgInt":True,  "bgInt":False},
                "show": {"fg":"grey",   "bg":"green",   "fgInt":True,  "bgInt":False},
               "watch": {"fg":"grey",   "bg":"green",   "fgInt":True,  "bgInt":False},
               "clear": {"fg":"grey",   "bg":"black",   "fgInt":False, "bgInt":False},
              "unlock": {"fg":"grey",   "bg":"magenta", "fgInt":True,  "bgInt":True },
                "init": {"fg":"yellow", "bg":"red",     "fgInt":True,  "bgInt":False},
                "plot": {"fg":"grey",   "bg":"cyan",    "fgInt":True,  "bgInt":False},
                "stub": {"fg":"grey",   "bg":"blue",    "fgInt":True,  "bgInt":True },
                 "run": {"fg":"grey",   "bg":"green",   "fgInt":True,  "bgInt":True },
               "other": {"fg":"grey",   "bg":"grey",    "fgInt":True,  "bgInt":False}}

_colorList  = ["black", "blue", "green", "cyan", "red", "magenta", "yellow", "grey"]

###############################################################################
##                                                                            #
##      global variables: program controlled                                  #
##                                                                            #
###############################################################################

_tileName       = "whr"
_delIfNotTile   = True
_redCover       = True
_plotDict       = {}
_fpgaList       = []
_tileList       = []
_tileDict       = {}
_tileConfigDict = {}
_vocValOvrdDict = {}
_stubDict       = {}
_loopCnt        = 0
_maxLoopCnt     = None
_fs             = 40.0
_lf             = 14.0
_ssa            = False
_errVal         = 0xfeedface
_figure         = 0
_modeDict       = {"u":"upi", "p":"pcie"}

_txList         = ["vboost", "iboost", "[cm1,c0,cp1]"] 

_txDict         = {"vboost":[0,5], "iboost":[ 0,15],  "[cm1,c0,cp1]":[None,None]} 
            
_vocList        = ["pheh", "phoh", "phel", "phol", "dseh", "dsel", 
                   "dsoh", "dsol",  "bpe",  "bpo",  "ese",  "eso"]      

_vocDict        = {"pheh":12, "phoh":13, "phel":14, "phol":15, "dseh":16, "dsel":17,
                   "dsoh":18, "dsol":19,  "bpe":20,  "bpo":21,  "ese":22,  "eso":23}        

_rxCalList      = ["attc", "ctle", "vgac", "vcoc"] + _vocList

_rxCalDict      = {"attc":[0,255], "ctle":[0,255], "vgac":[0,255], "vcoc":[0, 64], "pheh":[0,255], 
                   "phoh":[0,255], "phel":[0,255], "phol":[0,255], "dseh":[0,255], "dsel":[0,255], 
                   "dsoh":[0,255], "dsol":[0,255],  "bpe":[0,255],  "bpo":[0,255],  "ese":[0,255],  "eso":[0,255]}

_rxLoopList     = [  "att", "ctleb", "ctlep",
                     "vco",  "vga1",  "vga2",  "dfe1",
                    "dfe2",  "dfe3",  "dfe4",  "dfe5"]

_rxLoopDict     = {  "att":([   0,   7],"a"), "ctleb":([   0,  31],"b"), "ctlep":([   0,   3],"p"),
                     "vco":([   0,  47],"c"),  "vga1":([   0,   7],"v"),  "vga2":([   0,   7],"x"),  "dfe1":([-128, 127],"1"),
                    "dfe2":([ -64,  63],"2"),  "dfe3":([ -64,  63],"3"),  "dfe4":([ -64,  63],"4"),  "dfe5":([ -64,  63],"5")}

_tileLaneMapDict = {"u":{"x20":{"u0":[ 0,19]}},
                    "p":{"x16":{"p0":[ 0,15]}, 
                          "x8":{"p0":[ 0, 7], 
                                "p1":[ 8,15]},
                          "x4":{"p0":[ 4, 7], 
                                "p1":[ 8,11], 
                                "p2":[ 0, 3], 
                                "p3":[12,15]}}}

_pcieBifDict    = { "p0":{0x0:[16], 0x1:[8,8], 0x2:[4,4,4,4]}}

_rxReqSigDict   = { "setRxAdaptSel":            "rxX_adapt_sel",                                    
                    "setCdrVcoFreqBand":        "rxX_cdr_vco_freqband",
                    "setCdrVcoStepCtrl":        "rxX_cdr_vco_step_ctrl",
                    "setCdrVcoTempCompEnable":  "rxX_cdr_vco_temp_comp_en",
                    "setRxDeltaIq":             "rxX_delta_iq",
                    "setDfeBypass":             "rxX_dfe_bypass",
                    "setAtt":                   "rxX_eq_att_lvl",
                    "setCtleBoost":             "rxX_eq_ctle_boost",
                    "setCtlePole":              "rxX_eq_ctle_pole",
                    "setDfe":                   "rxX_eq_dfe_tap1",
                    "setVga1Gain":              "rxX_eq_vga1_gain",
                    "setVga2Gain":              "rxX_eq_vga2_gain",
                    "setRxLanePowerDown":       "rxX_lpd",
                    None:                       "rxX_margin_iq",                                        
                    "setRxMisc":                "rxX_misc",
                    "setTxPstate":              "rxX_pstate",
                    "setRxRate":                "rxX_rate",
                    "setRxRefLdVal":            "rxX_ref_ld_val",
                    "setRxReq":                 "rxX_req",
                    "setRxVcoLdVal":            "rxX_vco_ld_val",
                    "setRxWidth":               "rxX_width"}

_txReqSigDict   = { "setDetRxReq":              "txX_detrx_req",                                    
                    "setTxLanePowerDown":       "txX_lpd",
                    None:                       "txX_master_mplla_state",                                   
                    None:                       "txX_master_mpllb_state",                   
                    None:                       "txX_mpll_en",                              
                    "setTxMpllbSel":            "txX_mpllb_sel",
                    "setTxPstate":              "txX_pstate",
                    "setTxRate":                "txX_rate",
                    "setTxReq":                 "txX_req",
                    "setTxWidth":               "txX_width"}

_ltssmDict      = {"u":{None:["UNKNOWN",            [  "grey",     "red", False, False],  "unknown"],
                     0:["Reset.P",                  [  "grey",     "red",  True,  True],    "reset"],
                     1:["Reset.S",                  [  "grey",     "red",  True,  True],    "reset"],
                     2:["Reset.C",                  [  "grey",     "red",  True,  True],    "reset"],
                     3:["Detect.Rx",                [  "grey",     "red",  True,  True],    "train"],
                     4:["Tx.Cal",                   [  "grey",     "red",  True,  True],    "train"],
                     5:["Detect.Tx",                [  "grey",     "red",  True,  True],    "train"],
                     6:["Polling",                  [  "grey",     "red",  True,  True],    "train"],
                     8:["Config.LinkWidth",         [  "grey",     "red",  True,  True],    "train"],
                     9:["Config.FlitLock",          [  "grey",     "red",  True,  True],    "train"],
                    10:["L1",                       [  "grey",   "black",  True,  True],       "l0"],
                    12:["L0pe",                     [  "grey",   "green", False,  True],       "l0"],
                    13:["L0p",                      [  "grey",   "green",  True, False],       "l0"],
                    14:["L0c",                      [  "grey",   "green",  True,  True],       "l0"],
                    15:["L0",                       [  "grey",   "green",  True, False],       "l0"],
                    16:["Loopback.PatternMaster",   [ "black",    "cyan", False,  True],     "test"],
                    17:["Loopback.PatternSlave",    [ "black",    "cyan", False,  True],     "test"],
                    18:["Loopback.MarkerMaster",    [ "black",    "cyan", False,  True],     "test"],
                    19:["Loopback.MarkerSlave",     [ "black",    "cyan", False,  True],     "test"],
                    31:["Compliance",               [ "black",    "cyan", False,  True],     "test"]},
                   "p":{None:["UNKNOWN",            [  "grey",     "red", False, False],  "unknown"],
                     0:["Detect_quiet",             [  "grey",     "red",  True,  True],    "train"],
                     1:["Detect_act",               [  "grey",     "red",  True,  True],    "train"],
                     2:["Poll_active",              [  "grey",     "red",  True,  True],    "train"],
                     3:["Poll_compliance",          [  "grey",     "red",  True,  True],    "train"],
                     4:["Poll_config",              [  "grey",     "red",  True,  True],    "train"],
                     5:["Pre_detect_quiet",         [  "grey",     "red",  True,  True],    "train"],
                     6:["Detect_wait",              [  "grey",     "red",  True,  True],    "train"],
                     7:["Cfg_linkwd_start",         [  "grey",     "red",  True,  True],    "train"],
                     8:["Cfg_linkwd_acept",         [  "grey",     "red",  True,  True],    "train"],
                     9:["Cfg_lanenum_wai",          [  "grey",     "red",  True,  True],    "train"],
                    10:["Cfg_lanenum_acept",        [  "grey",     "red",  True,  True],    "train"],
                    11:["Cfg_complete",             [  "grey",     "red",  True,  True],    "train"],
                    12:["Cfg_idle",                 [  "grey",     "red",  True,  True], "recovery"],
                    13:["Rcvry_lock",               [  "grey",  "yellow",  True, False], "recovery"],
                    14:["Rcvry_speed",              [  "grey",  "yellow",  True, False], "recovery"],
                    15:["Rcvry_rcvrcfg",            [  "grey",  "yellow",  True, False], "recovery"],
                    16:["Rcvry_idle",               [  "grey",  "yellow",  True, False],       "l0"],
                    17:["L0",                       [  "grey",   "green",  True, False],       "l0"],
                    18:["L0s",                      [  "grey",   "green",  True, False],       "l0"],
                    19:["L123_send_eidle",          [  "grey",   "black",  True,  True],       "l0"],
                    20:["L1_idle",                  [  "grey",   "black",  True,  True],       "l0"],
                    21:["L2_idle",                  [  "grey",   "black",  True,  True],       "l0"],
                    22:["L2_wake",                  [  "grey",   "black",  True,  True],       "l0"],
                    23:["Disabled_entry",           [  "grey",  "yellow",  True, False], "disabled"],
                    24:["Disabled_idle",            [  "grey",  "yellow",  True, False], "disabled"],
                    25:["Disabled",                 [  "grey",  "yellow",  True, False],     "test"],
                    26:["Lpbk_entry",               [ "black",    "cyan", False, True ],     "test"],
                    27:["Lpbk_active",              [ "black",    "cyan", False, True ],     "test"],
                    28:["Lpbk_exit",                [ "black",    "cyan", False, True ],     "test"],
                    29:["Lpbk_exit_timeout",        [ "black",    "cyan", False, True ],     "test"],
                    30:["Hot_reset_entry",          [  "grey",  "yellow",  True, False],    "reset"],
                    31:["Hot_reset",                [  "grey",  "yellow",  True, False],    "reset"],
                    32:["Rcvry_eq0",                [  "grey",  "yellow",  True, False],    "adapt"],
                    33:["Rcvry_eq1",                [  "grey",  "yellow",  True, False],    "adapt"],
                    34:["Rcvry_eq2",                [  "grey",  "yellow",  True, False],    "adapt"],
                    35:["Rcvry_eq3",                [  "grey",  "yellow",  True, False],    "adapt"]}}

_hwModeDict     = {                                                                                 
                    0x00:{"mode":None, "topo":"x0",  "baudRate": 0.0, "attrib":None},       
                    0x01:{"mode":"p",  "topo":"x16", "baudRate":16.0, "attrib":"ep"},       
                    0x02:{"mode":"p",  "topo":"x16", "baudRate": 8.0, "attrib":"ep"},       
                    0x03:{"mode":"p",  "topo":"x16", "baudRate":16.0, "attrib":"rp"},       
                    0x04:{"mode":"p",  "topo":"x8",  "baudRate":16.0, "attrib":"ep"},       
                    0x05:{"mode":"p",  "topo":"x8",  "baudRate": 8.0, "attrib":"ep"},       
                    0x06:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x07:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x08:{"mode":"p",  "topo":"x4",  "baudRate":16.0, "attrib":"rp"},       
                    0x09:{"mode":"p",  "topo":"x4",  "baudRate": 8.0, "attrib":"rp"},       
                    0x0A:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x0B:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x0C:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x0D:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x0E:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x0F:{"mode":None, "topo":None,  "baudRate":None, "attrib":None},       
                    0x10:{"mode":"u",  "topo":"x20", "baudRate":11.2, "attrib":"fast"},     
                    0x11:{"mode":"u",  "topo":"x20", "baudRate":10.4, "attrib":"fast"},     
                    0x12:{"mode":"u",  "topo":"x20", "baudRate": 9.6, "attrib":"fast"},     
                    0x13:{"mode":"u",  "topo":"x20", "baudRate":11.2, "attrib":"slow"},     
                    0x14:{"mode":"u",  "topo":"x20", "baudRate":10.4, "attrib":"slow"},     
                    0x15:{"mode":"u",  "topo":"x20", "baudRate": 9.6, "attrib":"slow"}}     

_cfgTopoDict    = {                                                                                 
                    0:{"mode":"p",  "topo":"x16"},                                                      
                    1:{"mode":"p",  "topo": "x8"},                                                      
                    2:{"mode":"p",  "topo": "x4"},                                                      
                    3:{"mode":"u",  "topo":"x20"},                                                      
                    4:{"mode":None, "topo":None},                                                       
                    5:{"mode":None, "topo":None},                                                       
                    6:{"mode":None, "topo":None},                                                       
                    7:{"mode":None, "topo":None},                                                       
                    8:{"mode":None, "topo":None},                                                       
                    9:{"mode":None, "topo":None}}                                                       

_cfgFuncDict    = {                                                                                 
                    0:{"mode":None, "baudRate":None},
                    1:{"mode":"p",  "baudRate": 2.5},   
                    2:{"mode":"p",  "baudRate": 5.0},                                                       
                    3:{"mode":"p",  "baudRate": 8.0},                                                   
                    4:{"mode":"p",  "baudRate":16.0},                                                   
                    5:{"mode":"u",  "baudRate": 9.6},
                    6:{"mode":"u",  "baudRate":10.4},
                    7:{"mode":"u",  "baudRate":11.2}}

_phyRecipeDict  = {                                                                                 
                    "txX_misc":                         {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setTxMisc(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "txX_rate":                         {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    1, 5.0:    0, 8.0:    1, 16.0:    0}, "func":"'setTxRate(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "txX_mpllb_sel":                    {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    1, 16.0:    1}, "func":"'setTxMpllbSel(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "txX_width":                        {"u":{9.6:    2, 10.4:    2, 11.2:    2}, "p":{2.5:    3, 5.0:    3, 8.0:    2, 16.0:    2}, "func":"'setTxWidth(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "txX_vboost_en":                    {"u":{9.6:    1, 10.4:    1, 11.2:    1}, "p":{2.5:    1, 5.0:    1, 8.0:    1, 16.0:    1}, "func":"'setTxVboostEnable(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "txX_iboost_lvl":                   {"u":{9.6:    9, 10.4:    9, 11.2:    9}, "p":{2.5:   15, 5.0:   15, 8.0:   15, 16.0:   15}, "func":"'setTxIboost(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_rate":                         {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    2, 5.0:    1, 8.0:    0, 16.0:    0}, "func":"'setRxRate(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_eq_ctle_pole":                 {"u":{9.6:    2, 10.4:    2, 11.2:    2}, "p":{2.5:    0, 5.0:    0, 8.0:    2, 16.0:    2}, "func":"'setCtlePole(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_eq_ctle_boost":                {"u":{9.6:   12, 10.4:   12, 11.2:   12}, "p":{2.5:   18, 5.0:   14, 8.0:   12, 16.0:   16}, "func":"'setCtleBoost(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_los_threshold":                {"u":{9.6:    4, 10.4:    4, 11.2:    4}, "p":{2.5:    4, 5.0:    4, 8.0:    4, 16.0:    4}, "func":"'setRxLosThreshold(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_cdr_vco_step_ctrl":            {"u":{9.6:    1, 10.4:    1, 11.2:    0}, "p":{2.5:    1, 5.0:    1, 8.0:    1, 16.0:    0}, "func":"'setCdrVcoStepCtrl(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_cdr_vco_temp_comp_en":         {"u":{9.6:    1, 10.4:    1, 11.2:    1}, "p":{2.5:    1, 5.0:    1, 8.0:    1, 16.0:    0}, "func":"'setCdrVcoTempCompEnable(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_misc":                         {"u":{9.6:   18, 10.4:   18, 11.2:   18}, "p":{2.5:   22, 5.0:   20, 8.0:   18, 16.0:   17}, "func":"'setRxMisc(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_width":                        {"u":{9.6:    2, 10.4:    2, 11.2:    2}, "p":{2.5:    3, 5.0:    3, 8.0:    2, 16.0:    2}, "func":"'setRxWidth(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_div16p5_clk_en":               {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setRxDiv16p5ClkEnable(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_cdr_ssc_en":                   {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setCdrSscEnable(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_los_lfps_en":                  {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setRxLosLfpsEnable(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_dfe_bypass":                   {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    1, 5.0:    1, 8.0:    0, 16.0:    0}, "func":"'setDfeBypass(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_eq_att_lvl":                   {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setAtt(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_eq_vga1_gain":                 {"u":{9.6:    5, 10.4:    5, 11.2:    5}, "p":{2.5:    4, 5.0:    4, 8.0:    5, 16.0:    5}, "func":"'setVga1Gain(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_eq_vga2_gain":                 {"u":{9.6:    5, 10.4:    5, 11.2:    5}, "p":{2.5:    4, 5.0:    4, 8.0:    5, 16.0:    5}, "func":"'setVga2Gain(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_eq_dfe_tap1":                  {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:   10}, "func":"'setDfe(tile, portId, lane=%d, tapNum=1, value=%d)'%(lane, val)"},
                    "rxX_cdr_vco_freqband":             {"u":{9.6:    1, 10.4:    1, 11.2:    1}, "p":{2.5:    1, 5.0:    1, 8.0:    1, 16.0:    2}, "func":"'setCdrVcoFreqBand(tile, portId, lane=%d, value=%d)'%(lane,val)"},
                    "rxX_term_acdc":                    {"u":{9.6:    1, 10.4:    1, 11.2:    1}, "p":{2.5:    1, 5.0:    1, 8.0:    1, 16.0:    1}, "func":"'setRxTermAcDc(tile, portId, lane=%d, value=%d)'%(lane,val)"},
                    "rxX_delta_iq":                     {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    3}, "func":"'setRxDeltaIq(tile, portId, lane=%d, value=%d)'%(lane,val)"},
                    "rxX_adapt_sel":                    {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    1}, "func":"'setRxAdaptSel(tile, portId, lane=%d, value=%d)'%(lane,val)"},
                    "rxX_adapt_mode":                   {"u":{9.6:    3, 10.4:    3, 11.2:    3}, "p":{2.5:    0, 5.0:    0, 8.0:    1, 16.0:    0}, "func":"'setRxAdaptMode(tile, portId, lane=%d, value=%d)'%(lane,val)"},
                    "ref_clk_div2_en":                  {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setClkDiv2Enable(tile, portId, value=%d)'%(val)"},
                    "ref_clk_mpll{a,b}_div2_en":        {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    1, 16.0:    1}, "func":"'setRefClkMpllDiv2Enable(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_div8_clk_en":            {"u":{9.6:    1, 10.4:    1, 11.2:    1}, "p":{2.5:    0, 5.0:    0, 8.0:    1, 16.0:    1}, "func":"'setMpllDiv8ClkEnable(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_div10_clk_en":           {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    1, 5.0:    1, 8.0:    0, 16.0:    0}, "func":"'setMpllDiv10ClkEnable(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mplla_div16p5_clk_en":             {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllaDiv16p5ClkEnable(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_tx_clk_div":             {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    1, 5.0:    1, 8.0:    0, 16.0:    0}, "func":"'setMpllTxClkDiv(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_div_clk_en":             {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllDivClkEnable(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_div_multiplier":         {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllDivMultiplier(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_ssc_en":                 {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllSscEnable(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_ssc_clk_sel":            {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllSscClkSel(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_ssc_freq_cnt_peak":      {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:  102, 5.0:  102, 8.0:   81, 16.0:   81}, "func":"'setMpllSscFreqCntPeak(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_ssc_freq_cnt_init":      {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:   37, 5.0:   37, 8.0:   96, 16.0:   96}, "func":"'setMpllSscFreqCntInit(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_ssc_up_spread":          {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllSscUpSpread(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "mpll{a,b}_fracn_ctrl":             {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllFracnCtrl(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "bs_tx_lowswing":                   {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setBsTxLowSwing(tile, portId, value=%d)'%(val)"},
                    "bs_rx_bigswing":                   {"u":{9.6:    1, 10.4:    1, 11.2:    1}, "p":{2.5:    1, 5.0:    1, 8.0:    1, 16.0:    1}, "func":"'setBsRxBigSwing(tile, portId, value=%d)'%(val)"},
                    "mpll{a,b}_multiplier":             {"u":{9.6:   24, 10.4:   26, 11.2:   28}, "p":{2.5:   25, 5.0:   25, 8.0:   80, 16.0:   80}, "func":"'setMpllMultiplier(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "tx_vboost_lvl":                    {"u":{9.6:    5, 10.4:    5, 11.2:    5}, "p":{2.5:    5, 5.0:    5, 8.0:    5, 16.0:    5}, "func":"'setTxVboost(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "mpll{a,b}_bandwidth":              {"u":{9.6:41002, 10.4:41000, 11.2:40987}, "p":{2.5:41458, 5.0:41458, 8.0:41015, 16.0:41015}, "func":"'setMpllBandwidth(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "rx_vref_ctrl":                     {"u":{9.6:   17, 10.4:   17, 11.2:   17}, "p":{2.5:   17, 5.0:   17, 8.0:   17, 16.0:   17}, "func":"'setRxVrefCtrl(tile, portId, value=%d)'%(val)"},
                    "sup_misc":                         {"u":{9.6:    5, 10.4:    5, 11.2:    5}, "p":{2.5:    5, 5.0:    5, 8.0:    5, 16.0:    5}, "func":"'setSupMisc(tile, portId, value=%d)'%(val)"},
                    "rxX_ref_ld_val":                   {"u":{9.6:   28, 10.4:   26, 11.2:   24}, "p":{2.5:   27, 5.0:   27, 8.0:   34, 16.0:   17}, "func":"'setRxRefLdVal(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "rxX_vco_ld_val":                   {"u":{9.6: 1344, 10.4: 1352, 11.2: 1344}, "p":{2.5: 1350, 5.0: 1350, 8.0: 1360, 16.0: 1360}, "func":"'setRxVcoLdVal(tile, portId, lane=%d, value=%d)'%(lane, val)"},
                    "bs_rx_level":                      {"u":{9.6:   11, 10.4:   11, 11.2:   11}, "p":{2.5:   11, 5.0:   11, 8.0:   11, 16.0:   11}, "func":"'setBsRxLevel(tile, portId, value=%d)'%(val)"},
                    "mpll{a,b}_recal_bank_sel":         {"u":{9.6:    0, 10.4:    0, 11.2:    0}, "p":{2.5:    0, 5.0:    0, 8.0:    0, 16.0:    0}, "func":"'setMpllRecalBankSel(tile, portId, mpll=\"%s\", value=%d)'%(mpll,val)"},
                    "rxX_cdr_ppm_max":                  {"u":{9.6:   18, 10.4:   18, 11.2:   18}, "p":{2.5:   18, 5.0:   18, 8.0:   18, 16.0:   18}, "func":"'setCdrPpmMax(tile, portId, lane=%d, value=%d)'%(lane, val)"}}

_pattDict       = {  0: {"pattern": None   , "comment": "disabled"},                            
                     1: {"pattern":"prbs31", "comment": "x31 + x28 + 1"},
                     2: {"pattern":"prbs23", "comment": "x23 + x18 + 1"},
                     3: {"pattern":"prbs23", "comment": "x23 + x21 + x16 + x8 + x5 + x2 + 1"},
                     4: {"pattern":"prbs16", "comment": "x16 + x5 + x4 + x3 + 1"},
                     5: {"pattern":"prbs15", "comment": "x15 + x14 + 1"},
                     6: {"pattern":"prbs11", "comment": "x11 + x9 + 1"},
                     7: {"pattern":"prbs9" , "comment": "x9 + x5 + 1"},
                     8: {"pattern":"prbs7" , "comment": "x7 + x6 + 1"},
                     9: {"pattern":"patt_a", "comment": "fixed word (pat0)"},
                    10: {"pattern":"patt_b", "comment": "DC balanced word (pat0, ~pat0)"},
                    11: {"pattern":"patt_c", "comment": "fixed pattern (000, pat0, 3ff, ~pat0"}}

_upiPtvDict     = { "slow":{ "ntdt":12,  "ntdr": 1,  "trdb": 3,   "trs": 3,   "trc": 4,   "ttc": 4},
                    "fast":{ "ntdt":12,  "ntdr": 1,  "trdb": 3,   "trs": 3,   "trc": 8,   "ttc": 4}}

_upiStvDict     = { "slow":{"trcst": 3, "ttcst": 3, "ttdst": 4, "trdst": 0, "tplst": 6, "tclst": 4, "tcfst": 4, "tlmst": 0},
                    "fast":{"trcst":10, "ttcst": 9, "ttdst": 4, "trdst": 0, "tplst":10, "tclst": 4, "tcfst": 4, "tlmst": 0}}

_pollDict       = { "rx_ack":       "getRxAck",
                    "tx_ack":       "getTxAck",
                    "rx_adapt_ack": "getRxAdaptAck",
                    "rx_los":       "getRxLos",
                    "rx_valid":     "getRxDataValid"}

###############################################################################
##                                                                            #
##      initialization, setup & discovery functions                           #
##                                                                            #
###############################################################################

def setTileConfig(tile, mode="p", topo="x16", baudRate=16.0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    for topoKey in list(_cfgTopoDict.keys()):
        if mode==_cfgTopoDict[topoKey]["mode"] and topo==_cfgTopoDict[topoKey]["topo"]:
            break

    for funcKey in list(_cfgFuncDict.keys()):
        if mode==_cfgFuncDict[funcKey]["mode"] and baudRate==_cfgFuncDict[funcKey]["baudRate"]:
            break

    if _access in ["stub"] and _subAccess=="snpstc":
        qrange = list(range(1))
    else:
        qrange = list(range(4)) if mode=="p" else list(range(5))

    for q in qrange:
        tile.getbypath("phy_quad%d"%q).phytop_misc_ctrl_0.cfg_topology  = topoKey
        tile.getbypath("phy_quad%d"%q).phytop_misc_ctrl_0.cfg_func_mode = funcKey

    setTileConfigDictGlobal(tile)

def getTileConfig(tile, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    topoKey = tile.phy_quad0.phytop_misc_ctrl_0.cfg_topology
    funcKey = tile.phy_quad0.phytop_misc_ctrl_0.cfg_func_mode

    mode = _cfgTopoDict[topoKey]["mode"]
    topo = _cfgTopoDict[topoKey]["topo"]
    baudRate = _cfgFuncDict[funcKey]["baudRate"]

    if returnDict==True:
        return({"mode":mode, "topo":topo, "baudRate":baudRate})
    else:
        return(mode, topo, baudRate)

def setTileTopo(tile, topo="x16"):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    topoDict = {0:"x16", 1:"x8", 2:"x4", 3:"x20"}                                                               
    topoDictRev = {a:b for b,a in list(topoDict.items())}

    avmmCnt = 16 // int(topo[1:])

    for avmm in range(avmmCnt):
        try:
            tile.getbypath("pcie_avmm%d"%avmm).hip_ctrl.k_device_width = topoDictRev[topo]                  
        except:
            pass

def getTileTopo(tile):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    topoDict = {0:"x16", 1:"x8", 2:"x4", 3:"x20"}

    try:
        return(topoDict[tile.pcie_avmm0.hip_ctrl.k_device_width])                                               
    except:
        return(topoDict[3])                                                                                 

def setTileConfigDictGlobal(tile=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    global _tileConfigDict
    global _vocValOvrdDict

    tileList = _getTileList(tile)

    if tile==None:
        _tileConfigDict = {}
    else:
        _tileConfigDict[tile._fpgaNum][tile._tileNum] = {}

    for tmpTile in tileList:
        (mode, topo, baudRate) = getTileConfig(tmpTile)

        fpgaNum = tmpTile._fpgaNum
        tileNum = tmpTile._tileNum

        if fpgaNum not in _tileConfigDict:
            _tileConfigDict[fpgaNum] = {}

        if tileNum not in _tileConfigDict[fpgaNum]:
            _tileConfigDict[fpgaNum][tileNum] = {}

        if fpgaNum not in _vocValOvrdDict:
            _vocValOvrdDict[fpgaNum] = {}

        if tileNum not in _vocValOvrdDict[fpgaNum]:
            _vocValOvrdDict[fpgaNum][tileNum] = {}

        if _access in ["stub"] and _subAccess=="snpstc":
            lanesPerPort = 4
            lanesPerTile = 4
        else:
            lanesPerPort = int(topo[1:])
            lanesPerTile = 20 if mode=="u" else 16

        if lanesPerPort==0:
            continue

        numPorts = lanesPerTile // lanesPerPort
        portIdList = []
        for portNum in range(numPorts):
            portIdList.append(mode + str(portNum))

        for tmpPortId in portIdList:
            _tileConfigDict[fpgaNum][tileNum][tmpPortId]                    = {}
            _tileConfigDict[fpgaNum][tileNum][tmpPortId]["topo"]            = topo
            _tileConfigDict[fpgaNum][tileNum][tmpPortId]["baudRate"]        = baudRate
            _tileConfigDict[fpgaNum][tileNum][tmpPortId]["tileStrtLane"]    = _tileLaneMapDict[_getMode(tmpPortId)][topo][tmpPortId][0]
            _tileConfigDict[fpgaNum][tileNum][tmpPortId]["tileStopLane"]    = _tileLaneMapDict[_getMode(tmpPortId)][topo][tmpPortId][1]
            _tileConfigDict[fpgaNum][tileNum][tmpPortId]["root"]            = "" if _getMode(tmpPortId)=="u" else getPciePortType(tmpTile, tmpPortId, returnStr=True)

            _vocValOvrdDict[fpgaNum][tileNum][tmpPortId] = {}
            for i in getLaneList(tmpTile, tmpPortId, type="byPort"):
                _vocValOvrdDict[fpgaNum][tileNum][tmpPortId][i] = {}
                for tmpVco in _vocList:
                    _vocValOvrdDict[fpgaNum][tileNum][tmpPortId][i][tmpVco] = None

def getLaneList(tile=None, portId=None, lane=None, laneMask=None, type="byPort"):                               ## byQuad, byTile, byPort
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from math import log

    if type not in ["byPort", "byQuad", "byTile"]:
        return

    portId = portId.lower() if portId!=None else portId

    tileStrtLane = 0
    laneList = []
    if tile!=None and portId!=None:
        fpgaNum = tile._fpgaNum
        tileNum = tile._tileNum

        if portId not in _tileConfigDict[fpgaNum][tile._tileNum]:
            if _showWarnings:
                printc("\nWARNING: portId (\'%s\') not found on %s\n"%(portId, tile._tileName),"grey","yellow",True,False,srchStr="WARNING")
                return([])

        tileStrtLane = _getTileStrtLane(tile, portId)
        tileStopLane = _getTileStopLane(tile, portId)

        if lane!=None:
            if lane+tileStrtLane in range(tileStrtLane, tileStopLane+1):
                laneList = [lane+tileStrtLane]
        elif laneMask!=None:
            if isString(laneMask)==True:
                laneMask = xlateLaneMask(tile, portId, laneMaskStr=laneMask)

            portMask = getPortMask(tile=tile, portId=portId)
            laneMask = (laneMask & portMask) << tileStrtLane
        else:
            laneList = [a for a in range(tileStrtLane, tileStopLane+1)]

    if laneList==[] and laneMask!=None and laneMask!=0:
        numBits = int(log(laneMask,2)) + 1
        laneList = [a for a in range(numBits) if bits(laneMask,a,1)==1]

    if type=="byPort":
        laneList = [i-tileStrtLane for i in laneList]
    elif type=="byQuad":
        laneList = [_getQuadLane(tile,portId,i) for i in laneList]
    elif type=='byTile' and getLaneReversal(tile, portId): 
        laneList.reverse()

    return(laneList)

def getQuadList(tile, portId, lane=None, laneMask=None, type="byTile"):                                         ## byTile, byPort
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if type not in ["byPort", "byQuad", "byTile"]:
        return

    laneList = getLaneList(tile, portId, lane, laneMask, type)

    tmpList = [a//4 for a in laneList]
    quadList = list(set(tmpList))

    return(quadList)

def getPortMask(tile, portId, lane=None, laneMask=None, laneList=None, type="byPort"): 
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if type not in ["byPort", "byQuad", "byTile"]:
        return

    portId = portId.lower() if portId!=None else portId

    portMask = 0

    strtLane = _getTileStrtLane(tile, portId)
    stopLane = _getTileStopLane(tile, portId)

    if (tile!=None and portId!=None) and (lane==None and laneMask==None and laneList==None):
        if portId not in list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()):
            return(0)

        for i in range(strtLane, stopLane+1):
            portMask |= 1<<i

    elif lane!=None:
        portMask |= 1<<(lane+strtLane)

    elif laneMask!=None:
        if isString(laneMask)==True:
            laneMask = xlateLaneMask(tile, portId, laneMaskStr=laneMask)

        portMask = laneMask << strtLane

    elif laneList!=None:
        laneList = [a+strtLane for a in laneList]
        for i in laneList:
            portMask |= 1<<i

    clrMask = 0
    for j in range(strtLane,stopLane+1):
        clrMask = bits(clrMask, j, 1, 1)

    portMask = portMask & clrMask

    if type=="byPort":
        portMask = portMask >> strtLane

    return(portMask)

def xlateLaneMask(tile, portId, laneMaskStr="even"):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if laneMaskStr not in ["even","odd"]:
        return

    portId = portId.lower() if portId!=None else portId
    laneMaskStr = laneMaskStr.lower() if laneMaskStr!=None else laneMaskStr

    topo         = _tileConfigDict[tile._fpgaNum][tile._tileNum][portId.lower()]["topo"]
    lanesPerPort = int(topo[1:])

    laneMask = 0
    for i in range(lanesPerPort):
        laneMask |= 1<<i if (laneMaskStr=="even" and i%2==0) or (laneMaskStr=="odd" and i%2==1) else 0<<i

    return(laneMask)


def getLaneMask(tile, portId, lane=None, laneList=None, type="byTile"):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if type not in ["byPort", "byQuad", "byTile"]:
        return

    portId = portId.lower() if portId!=None else portId

    laneMask = 0

    strtLane = _getTileStrtLane(tile, portId)
    stopLane = _getTileStopLane(tile, portId)

    if (tile!=None and portId!=None) and (lane==None and laneList==None):
        for i in range(strtLane, stopLane+1):
            laneMask |= 1<<i

    elif lane==None and laneList!=None:
        laneList = [a+strtLane for a in laneList]
        for i in laneList:
            laneMask |= 1<<i

    elif lane!=None:
        laneMask |= 1<<(lane+strtLane)

    if type=="byPort":
        laneMask = laneMask >> strtLane

    return(laneMask)


def getPortIdList(tile, portId=None, mode=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    portId = portId.lower() if portId!=None else portId

    portIdList=[]
    if portId!=None:
        if portId in list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()):
            portIdList = [portId]
    elif mode!=None:
        portIdList = [a for a in list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()) if a[0]==mode.lower()]
    else:
        portIdList = list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys())

    if len(portIdList)>1:
        portIdList.sort(key=lambda a: int(a[1:]))                                                               ## sort by port number
        portIdList.sort(key=lambda a: (a[0]))                                                                   ## sort by port 1st letter

    return(portIdList)

###############################################################################
##                                                                            #
##      PHY status & control functions                                        #
##                                                                            #
###############################################################################
def setPhyRecipe(tile, portId=None, lane=None, laneMask=None, showProg=True, debug=False, mode=None, topo=None, baudRate=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if (portId==None and lane==None and laneMask==None) and (mode!=None and topo!=None and baudRate!=None):
        setTileConfig(tile, mode=mode, topo=topo, baudRate=baudRate)

    portIdList = [portId] if portId!=None else getPortIdList(tile)
    (mode, topo, baudRate) = getTileConfig(tile)

    origLane     = lane                                                                         
    origLaneMask = laneMask

    for portId in portIdList:
        laneList = getLaneList(tile, portId, origLane, origLaneMask, type="byPort")
    
        if showProg==True:
            completedWrites = 0
            numRecipeItems = len(list(_phyRecipeDict.keys()))
            numRecipeItemsWithLane = 0
            for key in list(_phyRecipeDict.keys()):
                if "lane" in _phyRecipeDict[key]["func"]:
                    numRecipeItemsWithLane += 1
    
            totalWrites = numRecipeItemsWithLane*len(laneList) + (numRecipeItems-numRecipeItemsWithLane)*max(1,int(len(laneList)//4))
    
        mpll = "b" if int(_phyRecipeDict["txX_mpllb_sel"][mode][baudRate])==1 else "a"
    
        for key in list(_phyRecipeDict.keys()):
            val  = int(_phyRecipeDict[key][mode][baudRate])
            func = _phyRecipeDict[key]["func"]
            
            if func==None:
                continue
    
            for lane in laneList:
                tmpStr = eval(func)     # nosec (interpolation of internally defined, semi-static string to form a function call)

                if debug: print(tmpStr)
                exec(tmpStr)            # nosec (using prepared above string to call a function)
    
                if showProg==True:
                    completedWrites += 1
                    msg = "[writing PHY recipe (%s %s): %3d/%3d - %5.1f%%]"%(tile.name, portId, completedWrites, totalWrites, (completedWrites/float(totalWrites))*100.0)
                    showProgress(stepNum=completedWrites, totalSteps=totalWrites, msg=msg, type="time")
    
                if "lane" not in tmpStr:
                    break

            if debug: print()

        if not(_access=="stub" and _subAccess=="offline"):
            setRxReq(tile, portId, origLane, origLaneMask, value=1)
            if not pollBit(tile, portId, lane, bitName="rx_ack", value=1):
                if input("Do you want to continue? ") in ["n","N","no","NO"]: return
            setRxReq(tile, portId, origLane, origLaneMask, value=0)
    
            setTxReq(tile, portId, origLane, origLaneMask, value=1)
            if not pollBit(tile, portId, lane, bitName="tx_ack", value=1):
                if input("Do you want to continue? ") in ["n","N","no","NO"]: return
            setTxReq(tile, portId, origLane, origLaneMask, value=0)

def getPcieSpecPresets(presetId=None, txSwing=1.0, fs=None):                                                
    if _debug: _showFunctionInfo(_sys._getframe(0))

    pciePresetDict = {   "p0":{"pre":0.00, "pst":6.02, "cm1": 0.000, "cp1": 0.250, "va/vd":1.000, "vb/vd":0.500, "vc/vd":0.500},
                         "p1":{"pre":0.00, "pst":3.74, "cm1": 0.000, "cp1": 0.167, "va/vd":1.000, "vb/vd":0.668, "vc/vd":0.668},
                         "p2":{"pre":0.00, "pst":4.44, "cm1": 0.000, "cp1": 0.200, "va/vd":1.000, "vb/vd":0.600, "vc/vd":0.600},
                         "p3":{"pre":0.00, "pst":2.50, "cm1": 0.000, "cp1": 0.125, "va/vd":1.000, "vb/vd":0.750, "vc/vd":0.750},
                         "p4":{"pre":0.00, "pst":0.00, "cm1": 0.000, "cp1": 0.000, "va/vd":1.000, "vb/vd":1.000, "vc/vd":1.000},
                         "p5":{"pre":1.94, "pst":0.00, "cm1": 0.100, "cp1": 0.000, "va/vd":0.800, "vb/vd":0.800, "vc/vd":1.000},
                         "p6":{"pre":2.50, "pst":0.00, "cm1": 0.125, "cp1": 0.000, "va/vd":0.750, "vb/vd":0.750, "vc/vd":1.000},
                         "p7":{"pre":3.52, "pst":6.02, "cm1": 0.100, "cp1": 0.200, "va/vd":0.800, "vb/vd":0.400, "vc/vd":0.600},
                         "p8":{"pre":3.52, "pst":3.52, "cm1": 0.125, "cp1": 0.125, "va/vd":0.750, "vb/vd":0.500, "vc/vd":0.750},
                         "p9":{"pre":3.74, "pst":0.00, "cm1": 0.166, "cp1": 0.000, "va/vd":0.668, "vb/vd":0.668, "vc/vd":1.000},
                        "p10":{"pre":0.00, "pst":9.12, "cm1": 0.000, "cp1": 0.325, "va/vd":0.000, "vb/vd":0.000, "vc/vd":0.000}}

    if (isString(presetId) and presetId[0]!="p") or isNumber(presetId):
        presetId = "p"+str(presetId)

    if presetId==None:
        presetIdList = list(pciePresetDict.keys())
        presetIdList.sort()
    else:
        presetIdList = [presetId]

    fs = (_fs if fs==None else fs) * txSwing

    txEqDict = {}
    for tmpPresetId in presetIdList:
        cm1 = -1* int(round((pciePresetDict[tmpPresetId]["cm1"]) * fs, 0))
        cp1 = -1* int(round((pciePresetDict[tmpPresetId]["cp1"]) * fs, 0))
        c0  = int(fs - abs(cm1) - abs(cp1))
        txEqDict[tmpPresetId] = [cm1,c0,cp1]

    if presetId==None:
        return(txEqDict)
    else:
        return(txEqDict[presetId])

def setTxEqBoost(tile, portId, lane=None, laneMask=None, boost=3.5, preToPostRatio=0.5, txSwing=1.0, returnTaps=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    portId = portId.lower() if portId!=None else portId

    fs = _fs * txSwing

    c0       = int(round((fs/(10**(float(boost)/20)) + fs) / 2.0, 0))
    numSteps = int(round(fs,0) - c0 + 1)
    cm1      = int(preToPostRatio * (numSteps-1))
    cp1      = int(round(fs,0) - abs(cm1) - abs(c0))

    if returnTaps==True:
        return([cm1, c0, cp1])
    else:
        setTxEq(tile, portId, lane, laneMask, txEqList=[cm1,c0,cp1], txSwing=txSwing)

def setTxSwing(tile, portId, lane=None, laneMask=None, value=1.0, txEqList=None, fs=None, returnTaps=False):        
    if _debug: _showFunctionInfo(_sys._getframe(0))

    portId = portId.lower() if portId!=None else portId
    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    fs = (_fs if fs==None else fs)
    value = float(value)

    for i in laneList:
        tmpEqList = getTxEq(tile, portId, i) if txEqList==None else txEqList

        [cm1, c0, cp1] = [tmpEqList[0], tmpEqList[1], tmpEqList[2]]

        if (cm1==None or c0==None or cp1==None):
            return([_errVal,_errVal,_errVal])

        oldSwing = getTxSwing(tile, portId, i, txEqList=tmpEqList, fs=fs)

        if oldSwing>=0:
            newCm1 = -int((abs(cm1)/oldSwing)*value)
            newC0  =  int(round((c0 /oldSwing)*value, 0))
            newCp1 = -int(round(fs*value,0) - abs(newCm1) - abs(newC0))

            if newC0>fs:
                kbInput = input("\nWARNING: pre/post shoot balance will not be maintained.  Do you want to continue? (\'y\' or \'n\'): ")
                if kbInput=="" or kbInput[0].lower()=="n":
                    return()
                newC0  = fs
                newCm1 = newCp1 = 0

    if returnTaps==True:
        return([newCm1, newC0, newCp1])
    else:
        setTxEq(tile, portId, i, txEqList=[newCm1,newC0,newCp1])

def getTxSwing(tile=None, portId=None, lane=None, laneMask=None, returnDict=False, txEqList=None, fs=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    portId = portId.lower() if portId!=None else portId
    fs = (_fs if fs==None else fs)

    if txEqList!=None:
        [cm1, c0, cp1] = [txEqList[0], txEqList[1], txEqList[2]]
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        data = {}
        for i in laneList:
            data[i] = deepcopy([None])
            [cm1, c0, cp1] = getTxEq(tile, portId, i)

            if (cm1==None or c0==None or cp1==None):
                return(None)

            data[i] = round((abs(cm1) + abs(c0) + abs(cp1)) / float(fs), 2)

    if txEqList!=None:
        return(round((abs(cm1) + abs(c0) + abs(cp1)) / float(fs), 2))
    else:
        if len(laneList)==1 and returnDict==False:
            return(data[i])
        else:
            return(data)

def getBaudRate(tile, portId, lane=None, laneMask=None, returnDict=False):                      
    if _debug: _showFunctionInfo(_sys._getframe(0))

    lane = 0 if lane==None else lane

    txRateDict   = {0:1.000, 1:0.500, 2:0.250, 3:0.125, 7:0.100}                                                
    txClkDivDict = {0:1.000, 1:0.500, 2:0.250, 3:1.000}                                                         

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data = {}
    for i in laneList:
        txRate              = getTxRate(tile, portId, lane=i)                                                   
        mpllbSel            = "b" if getTxMpllbSel(tile, portId, lane=i)==1 else "a"                            
        mpllMultiplier      = getMpllMultiplier(tile, portId, mpll=mpllbSel)
        refClkMpllDiv2En    = getRefClkMpllDiv2Enable(tile, portId, mpll=mpllbSel)
        mpllTxClkDiv        = getMpllTxClkDiv(tile, portId, mpll=mpllbSel)

        tmpVal  = _refClk * mpllMultiplier * 4.0
        tmpVal  = tmpVal / float(txRate+1)
        tmpVal  = tmpVal if refClkMpllDiv2En==0 else tmpVal/2.0
        tmpVal  = tmpVal / float(mpllTxClkDiv+1)
        tmpVal  = tmpVal / 1000.0
        data[i] = tmpVal

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def calcTxVswing(tile, portId, lane=None, laneMask=None, returnDict=False):                     
    if _debug: _showFunctionInfo(_sys._getframe(0))

    vptxX = 0.9
    vbg   = 0.8

    vb = getTxVboost(tile, portId, lane, laneMask, returnDict=True)
    ib = getTxIboost(tile, portId, lane, laneMask, returnDict=True)

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data = {}
    for i in laneList:
        data[i] = vptxX + (1/16.0) * (1 + ib[i]) * (4 * (vbg * (vb[i] + 6) / 32.0) - vptxX) 

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def calcTxEqVswingLevels(tile, portId, lane=None, laneMask=None, returnDict=False):             
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data = {}
    for i in laneList:
        data[i] = {}

        (cm1,c0,cp1) = getTxEq(tile, portId, i)
        vSwing = calcTxVswing(tile, portId, i)

        data[i]["pre"] = vSwing * (c0 + abs(cm1) - abs(cp1))/float(_fs)
        data[i]["pst"] = vSwing * (c0 - abs(cm1) + abs(cp1))/float(_fs)
        data[i]["dc"]  = vSwing * (c0 - abs(cm1) - abs(cp1))/float(_fs)
        data[i]["max"] = vSwing * (c0 + abs(cm1) + abs(cp1))/float(_fs)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

###############################################################################
##                                                                            #
##      PHY recipe functions in general order of table in PHYTOP_HAS (p16)    #
##                                                                            #
###############################################################################

def setTxMisc(tile, portId, lane=None, laneMask=None, value=None):                              
    if _debug: _showFunctionInfo(_sys._getframe(0))
    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_misc.tx_misc_ovrd_val = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_misc.tx_misc_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_misc.tx_misc_ovrd_val = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_misc.tx_misc_ovrd_en = 1 if value!=None else 0

def setTxRate(tile, portId, lane=None, laneMask=None, value=None):                              
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.rate = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.rate = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0

def getTxRate(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.rate)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_0.rate)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setTxMpllbSel(tile, portId, lane=None, laneMask=None, value=None):                          
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.mpllb_sel = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.mpllb_sel = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0

def getTxMpllbSel(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.mpllb_sel)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_0.mpllb_sel)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setTxWidth(tile, portId, lane=None, laneMask=None, value=None):                             
    if _debug: _showFunctionInfo(_sys._getframe(0))

#   0: 8-bit
#   1: 10-bit
#   2: 16-bit
#   3: 20-bit

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.width = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.width = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0

def setTxVboostEnable(tile, portId, lane=None, laneMask=None, value=None):                      
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_1.vboost_en = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_1.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.vboost_en = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.en = 1 if value!=None else 0

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vboost", value)

def setTxVboost(tile, portId, lane=None, laneMask=None, value=None):                            
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, lane, laneMask, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_lvl_ovrd_in.tx_vboost_lvl = int(value)
        tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_lvl_ovrd_in.tx_vboost_lvl_en = 1 if value!=None else 0

    setTxVboostEnable(tile, portId, lane, laneMask, value=(1 if isNumber(value) else None))

def getTxVboost(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data = {}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).dig_lvl_ovrd_in.tx_vboost_lvl_en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).dig_lvl_ovrd_in.tx_vboost_lvl)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).dig_lvl_asic_in.tx_vboost_lvl)

    if len(data)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setTxIboost(tile, portId, lane=None, laneMask=None, value=None):                            
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_1.iboost_lvl = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_1.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.iboost_lvl = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.en = 1 if value!=None else 0

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "iboost", value)

def getTxIboost(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    txIboostDict = {0:  819, 1:  838,  2:  856,  3:  875,  4:  894,  5:  913,  6:  931,  7:  950,           
                    8:  969, 9:  988, 10: 1006, 11: 1025, 12: 1044, 13: 1063, 14: 1081, 15: 1100}

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:

        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.iboost_lvl)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_1.iboost_lvl)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "iboost")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setTxEq(tile, portId, lane=None, laneMask=None, txEqList=None, txSwing=1.0, writeUpiPhy=False, writeBios=False):    
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from math import log10

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    fs = _fs * txSwing
    lf = _lf * txSwing

    if txEqList==None:
        if txSwing<1.0:
            txEqList = getTxEq(tile, portId, lane=0)                                                    
        else:
            return

    cm1 = abs(txEqList[0])
    c0  = abs(txEqList[1])
    cp1 = abs(txEqList[2])

    if txSwing<1.0 and (None not in [cm1,c0,cp1]):
        [cm1,c0,cp1] = setTxSwing(tile, portId, lane, laneMask, value=txSwing, txEqList=[cm1,c0,cp1], returnTaps=True)

    if None not in [cm1,c0,cp1]:
        if abs(c0) + abs(cm1) + abs(cp1) > fs:
            kbInput = input("\nWARNING: Tap settings do not meet fs=%d requirement - [%2d,%2d,%2d].  Do you want to continue? (\'y\' or \'n\'): "%(fs,cm1,c0,cp1))
            if kbInput=="" or kbInput[0].lower()=="n": return
        elif abs(c0) - abs(cm1) - abs(cp1) < lf:
            kbInput = input("\nWARNING: Tap settings do not meet lf=%d requirement - [%2d,%2d,%2d].  Do you want to continue? (\'y\' or \'n\'): "%(lf,cm1,c0,cp1))
            if kbInput=="" or kbInput[0].lower()=="n": return
        elif abs(cp1) > 15:                                                                         
            kbInput = input("\nWARNING: max allowable value (ie, 15) for pstCursor tap exceeded (ie, cp1=%d).  Do you want to continue? (\'y\' or \'n\'): "%(cp1))
            if kbInput=="" or kbInput[0].lower()=="n": return
        elif abs(cp1) > 10:                                                                         
            kbInput = input("\nWARNING: max allowable value (ie, 15) for preCursor tap exceeded (ie, cm1=%d).  Do you want to continue? (\'y\' or \'n\'): "%(cm1))
            if kbInput=="" or kbInput[0].lower()=="n": return

    if writeUpiPhy==True:
        if writeBios==True:
            addrDict = tile.upi_phy.whr_ph_adapt.getaddress()
            print("regName\toffset\tnumBits\tsize\tdefault\tvalue\tcomment")
            comment = "# [cm1=%s, c0=%d, cp1=%d] %5.2fdB"%(cm1, c0, cp1, 20*log10(abs(float(-cm1+c0-cp1)/float(cm1+c0+cp1))))

        for i in laneList:
            deemph_wr   = 1
            deemph_sel  = i+1
            rxeqeval    = 1
            tx_deemph   = abs(cp1)<<12 | abs(c0)<<6 | abs(cm1)

            regVal = deemph_wr<<31 | deemph_sel<<26 | rxeqeval<<25 | tx_deemph
            tile.upi_phy.whr_ph_adapt = regVal

            if writeBios==True:
                print("%s\t%d\t%d\t%d\t0x%08x\t0x%08x\t%s"%(addrDict["original_name"], addrDict["addressOffset"], addrDict["numbits"], addrDict["size"], addrDict["default"], regVal, comment))

    else:
        if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
            if cm1!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_2.tx_pre_cursor  = cm1
            tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_2.pre_ovrd_en  = 1 if cm1!=None else 0
    
            if c0!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_1.tx_main_cursor = c0
            tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_1.main_ovrd_en = 1 if c0!=None else 0
    
            if cp1!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_2.tx_post_cursor = cp1
            tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_2.post_ovrd_en  = 1 if cp1!=None else 0
        else:
            fractionalBits = 2
            for i in laneList:
                if cm1!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.tx_pre_cursor  = cm1 << fractionalBits
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.pre_ovrd_en  = 1 if cm1!=None else 0
    
                if c0!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.tx_main_cursor = c0
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.main_ovrd_en = 1 if c0!=None else 0
    
                if cp1!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.tx_post_cursor = cp1 << fractionalBits
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.post_ovrd_en = 1 if cp1!=None else 0

def getTxEq(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    fractionalBits = 2
    data={}
    for i in laneList:
        data[i] = deepcopy([None, None, None])

        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.pre_ovrd_en)==1):
            data[i][0] = -1 * int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.tx_pre_cursor) >> fractionalBits
        else:
            data[i][0] = -1 * int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_2.tx_pre_cursor) >> fractionalBits

        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.main_ovrd_en)==1):
            data[i][1] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_1.tx_main_cursor)
        else:
            data[i][1] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_1.tx_main_cursor)

        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.post_ovrd_en)==1):
            data[i][2] = -1 * int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_2.tx_post_cursor) >> fractionalBits
        else:
            data[i][2] = -1 * int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_2.tx_post_cursor) >> fractionalBits

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setPcieLocalTxEq(tile, portId, lane=None, laneMask=None, baudRate=None, txEqList=None, enable=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not yet implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    baudRate = baudRate if baudRate!=None else getBaudRate(tile, portId)

    if _getMode(portId)=="p":
        for i in laneList:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_lane_sel = i
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_rate_sel = 1 if baudRate==16.0 else 0

            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control2_reg.force_local_tx_coef_enable   = int(enable) if txEqList!=None else 0
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control2_reg.force_local_tx_pre_cursor    = abs(int(txEqList[0])) if txEqList!=None else 0
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control2_reg.force_local_tx_cursor        = abs(int(txEqList[1])) if txEqList!=None else int(_fs)
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control2_reg.force_local_tx_post_cursor   = abs(int(txEqList[2])) if txEqList!=None else 0

def setPcieRemoteTxEq(tile, portId, lane=None, laneMask=None, baudRate=None, txEqList=None, enable=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not yet implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    baudRate = baudRate if baudRate!=None else getBaudRate(tile, portId)

    if _getMode(portId)=="p":
        for i in laneList:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_lane_sel = i
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_rate_sel = 1 if baudRate==16.0 else 0

            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control3_reg.force_remote_tx_coef_enable  = int(enable) if txEqList!=None else 0
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control3_reg.force_remote_tx_pre_cursor   = abs(int(txEqList[0])) if txEqList!=None else 0
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control3_reg.force_remote_tx_cursor       = abs(int(txEqList[1])) if txEqList!=None else int(_fs)
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control3_reg.force_remote_tx_post_cursor  = abs(int(txEqList[2])) if txEqList!=None else 0

def getPcieRemoteTxEq(tile, portId, lane=None, laneMask=None, baudRate=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not yet implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    baudRate = baudRate if baudRate!=None else getBaudRate(tile, portId)

    if _getMode(portId)=="p":
        data = {}
        for i in laneList:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_lane_sel = i
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_rate_sel = 1 if baudRate==16.0 else 0
    
            data[i] = deepcopy([None, None, None])

            if i==laneList[0]:                                                                      
                data[i][0] = -int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_status3_reg.eq_remote_pre_cursor)
                data[i][1] =  int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_status3_reg.eq_remote_cursor)
                data[i][2] = -int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_status3_reg.eq_remote_post_cursor)
    
            data[i][0] = -int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_status3_reg.eq_remote_pre_cursor)
            data[i][1] =  int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_status3_reg.eq_remote_cursor)
            data[i][2] = -int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_status3_reg.eq_remote_post_cursor)
    
    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setPciePresetRequestVector(tile, portId, lane=None, laneMask=None, baudRate=None, value=0x3FF):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    baudRate = baudRate if baudRate!=None else getBaudRate(tile, portId)

    upDnStr = "usp" if getPciePortType(tile, portId, returnStr=True)=="ep" else "dsp"

    if _getMode(portId)=="p":
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_rate_sel = 1 if baudRate==16.0 else 0
    
        for i in laneList:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_lane_sel = i
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).gen3_eq_control_off.gen3_eq_pset_req_vec = value

def setPciePreset(tile, portId, lane=None, laneMask=None, baudRate=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    baudRate = baudRate if baudRate!=None else getBaudRate(tile, portId)

    upDnStr = "usp" if getPciePortType(tile, portId, returnStr=True)=="ep" else "dsp"

    if _getMode(portId)=="p":
        for i in laneList:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_eq_control1_reg.eq_lane_sel = i

            if baudRate==16.0:
                tile.getbypath("%s.pl16g_cap_off_%02xh_reg"%(getPcieRegPrefix(tile, portId),32+(i//4)*4)).writefield("%s_16g_tx_preset%d"%(upDnStr,i), value)
            else:
                tile.getbypath("%s.pcie_cap_off_%02xh_reg"%(getPcieRegPrefix(tile, portId),12+(i//2)*4)).writefield("%s_tx_preset%d"%(upDnStr,i), value)

def trainLink(tile, portId, linkWidth=None, baudRate=None, remoteTxEqList=None, localTxEqList=None, presetList=[], feedbackMode="fom", verbose=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        resetPhyLayer(tile, portId)

    elif _getMode(portId)=="p":
        pcieBaudDict = {2.5:1, 5.0:2, 8.0:3, 16.0:4}

        tmpBaudRate = getBaudRate(tile, portId)
        baudRate = baudRate if baudRate!=None else getBaudRate(tile, portId)

        clearErrCnt(tile, portId)

        laneList = list(range(linkWidth)) if linkWidth!=None else getLaneList(tile, portId, type="byPort")
        tmpLaneMask = getLaneMask(tile, portId, lane=None, laneList=laneList, type="byPort")

        if linkWidth!=None:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).multi_lane_control_off.upconfigure_support = 1
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).multi_lane_control_off.target_link_width = linkWidth
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).multi_lane_control_off.direct_link_width_change = 1

            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).port_link_ctrl_off.link_capable = (2*linkWidth)-1
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).gen2_ctrl_off.num_of_lanes = linkWidth

            sleep(0.050)

        if baudRate!=tmpBaudRate:
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).link_control2_link_status2_reg.pcie_cap_hw_auto_speed_disable = 1

        if localTxEqList!=None or remoteTxEqList!=None:
            if localTxEqList!=None and isList(localTxEqList) and len(localTxEqList)==3:
                setPcieLocalTxEq(tile, portId, laneMask=tmpLaneMask, baudRate=baudRate, txEqList=localTxEqList)

            if remoteTxEqList!=None and isList(remoteTxEqList) and len(remoteTxEqList)==3:
                setPcieRemoteTxEq(tile, portId, laneMask=tmpLaneMask, baudRate=baudRate, txEqList=remoteTxEqList)
                tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).gen3_eq_control_off.gen3_eq_fb_mode = 0
        else:
            if presetList!=[]:
                reqVector = 0
                for preset in presetList:
                    reqVector = bits(reqVector,preset,1,1)

                setPciePresetRequestVector(tile, portId, baudRate=baudRate, value=reqVector)

            setPcieLocalTxEq(tile, portId, laneMask=tmpLaneMask, baudRate=baudRate, txEqList=None)
            setPcieRemoteTxEq(tile, portId, laneMask=tmpLaneMask, baudRate=baudRate, txEqList=None)
            tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).gen3_eq_control_off.gen3_eq_fb_mode = 0 if feedbackMode=="dir" else 1

        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).link_control3_reg.perform_eq = 1
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).link_control2_link_status2_reg.pcie_cap_target_link_speed = pcieBaudDict[baudRate]

        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).link_control_link_status_reg.pcie_cap_retrain_link = 1
        sleep(0.025)

    if verbose==True: showStatus(tile, portId, shortForm=True)

def setRxRate(tile, portId, lane=None, laneMask=None, value=None):              
    if _debug: _showFunctionInfo(_sys._getframe(0))

#   0: baud
#   1: baud/2
#   2: baud/4
#   3: baud/8

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.rate = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.rate = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0

def setCtlePole(tile, portId, lane=None, laneMask=None, value=None):                
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_eq_ovrd_in_2.rx_eq_ctle_pole_ovrd_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_2.rx_eq_ctle_pole_ovrd_val = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctlep", value)
def getCtlePole(tile, portId, lane=None, laneMask=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    if loopCnt!=None:
        data = getRxLoop(tile, portId, lane, laneMask, "ctlep", loopCnt, showProg, returnMean, returnDict)

    else:
        data={}
        for i in laneList:


            if _useStatusRegs==True:
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_adptctl_ctle_status.ctle_pole_adpt_code)
            else:
                gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_ctle%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).ctle_pole_adpt_val)
    
            if (_access=="stub" and _subAccess=="offline"):
                data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctlep")

    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)
def setCtleBoost(tile, portId, lane=None, laneMask=None, value=None):               
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_eq_ovrd_in_2.rx_eq_ctle_boost_ovrd_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_2.rx_eq_ctle_boost_ovrd_val = int(value)
            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctleb", value)
def getCtleBoost(tile, portId, lane=None, laneMask=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    if loopCnt!=None:
        data = getRxLoop(tile, portId, lane, laneMask, "ctleb", loopCnt, showProg, returnMean, returnDict)

    else:
        ditherBits = 5
        data={}
        for i in laneList:


            if _useStatusRegs==True:
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_adptctl_ctle_status.ctle_boost_adpt_code) >> ditherBits
            else:
                gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_ctle%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).ctle_boost_adpt_val) >> ditherBits
    
            if (_access=="stub" and _subAccess=="offline"):
                data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctleb")
    
    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)

def getRxAdaptRefErr(tile, portId, lane=None, laneMask=None, loopCnt=None, sampler="even", returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    ditherBits = 5
    data={}
    for i in laneList:

        gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_ref_err%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).readfield("rx_adpt_ref_err_%s%s"%(sampler.lower(),gen4Suffix)))

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctleb")
    
    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)

def getRxAdaptErrorSlicerMode(tile, portId, lane=None, laneMask=None, loopCnt=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    ditherBits = 5
    data={}
    for i in laneList:

        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_rx_adpt_err_slc_mode.rx_adpt_err_slc_mode)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctleb")
    
    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)

def setRxLos(tile, portId, lane=None, laneMask=None, value=None):                   
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_out_0.los = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_out_0.en_ctl = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_out_0.los = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_out_0.en_ctl = 1 if value!=None else 0

def getRxLos(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_out_0.en_ctl)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_out_0.los)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_asic_out_0.los)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setRxLosThreshold(tile, portId, lane=None, laneMask=None, value=None):                  
    if _debug: _showFunctionInfo(_sys._getframe(0))
    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_3.los_thrshld = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_3.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_3.los_thrshld = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_3.en = 1 if value!=None else 0

def setCdrVcoStepCtrl(tile, portId, lane=None, laneMask=None, value=None):                          
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_1.rx_cdr_vco_step_ctrl = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.rx_cdr_vco_step_ctrl = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.en = 1 if value!=None else 0

def setCdrVcoTempCompEnable(tile, portId, lane=None, laneMask=None, value=None):                    
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_1.rx_cdr_vco_temp_comp_en = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.rx_cdr_vco_temp_comp_en = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.en = 1 if value!=None else 0

def setRxMisc(tile, portId, lane=None, laneMask=None, value=None):                              
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_misc.rx_misc_ovrd_val = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_misc.rx_misc_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_misc.rx_misc_ovrd_val = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_misc.rx_misc_ovrd_en = 1 if value!=None else 0

def setRxWidth(tile, portId, lane=None, laneMask=None, value=None):                 
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.width = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.width = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0

def setRxDiv16p5ClkEnable(tile, portId, lane=None, laneMask=None, value=None):                      
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.div16p5_clk_en = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.div16p5_clk_en = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0

def setCdrSscEnable(tile, portId, lane=None, laneMask=None, value=None):                            
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_3.cdr_ssc_en = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_3.cdr_ssc_en = int(value)

def setRxLosLfpsEnable(tile, portId, lane=None, laneMask=None, value=None):                         
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.ana_rx_misc_ovrd.ovrd_rx_los_lfps_en = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).ana_rx_misc_ovrd.ovrd_rx_los_lfps_en = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).ana_rx_misc_ovrd.rx_los_lfps_en_reg = 1 if value!=None else 0

def setDfeBypass(tile, portId, lane=None, laneMask=None, value=False):                      
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ctl_ovrd_out.rx_ana_dfe_bypass_n = int(value)   
        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ctl_ovrd_out.rx_ctl_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ctl_ovrd_out.rx_ana_dfe_bypass_n = int(value)       ## dwc_16g_phy_tsmc16ffc_databook (p142)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ctl_ovrd_out.rx_ctl_ovrd_en = 1 if value!=None else 0

def getRxDataValid(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):           
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_asic_out_0.valid)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setAtt(tile, portId, lane=None, laneMask=None, value=None):                                         
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):

        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_att_lvl_ovrd_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:

            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_att_lvl_ovrd_val = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "att", value)
def getAtt(tile, portId, lane=None, laneMask=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if loopCnt!=None:
        data = getRxLoop(tile, portId, lane, laneMask, "vga1", loopCnt, showProg, returnMean, returnDict)

    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        ditherBits = 5
        data={}
        for i in laneList:

            if _useStatusRegs==True:
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_adptctl_att_status.att_adpt_code) >> ditherBits
            else:
                gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_att%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).att_adpt_val) >> ditherBits

            if (_access=="stub" and _subAccess=="offline"):
                data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "att")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)
def setVga1(tile, portId, lane=None, laneMask=None, value=None):                                        
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):

        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_vga1_gain_ovrd_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:

            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_vga1_gain_ovrd_val = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vga1", value)
def getVga1(tile, portId, lane=None, laneMask=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if loopCnt!=None:
        data = getRxLoop(tile, portId, lane, laneMask, "vga1", loopCnt, showProg, returnMean, returnDict)

    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        ditherBits = 6
        data={}
        for i in laneList:

            if _useStatusRegs==True:
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_adptctl_vga_status.vga_adpt_code) >> ditherBits
            else:
                gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_vga%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).vga_adpt_val) >> ditherBits
        
            if (_access=="stub" and _subAccess=="offline"):
                data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vga1")

    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)
def setVga2(tile, portId, lane=None, laneMask=None, value=None):                                        
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):

        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_vga2_gain_ovrd_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:

            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_vga2_gain_ovrd_val = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vga2", value)
def getVga2(tile, portId, lane=None, laneMask=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if loopCnt!=None:
        data = getRxLoop(tile, portId, lane, laneMask, "vga2", loopCnt, showProg, returnMean, returnDict)

    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        ditherBits = 6
        data={}
        for i in laneList:

            if _useStatusRegs==True:
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_adptctl_vga_status.vga_adpt_code) >> ditherBits
            else:
                gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_vga%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).vga_adpt_val) >> ditherBits
    
            if (_access=="stub" and _subAccess=="offline"):
                data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vga2")

    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)
def setVga1Gain(tile, portId, lane=None, laneMask=None, value=None):                                    
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_eq_in_0.eq_vga1_gain = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_eq_in_1.eq_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_eq_in_0.eq_vga1_gain = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_eq_in_1.eq_ovrd_en = 1 if value!=None else 0

def setVga2Gain(tile, portId, lane=None, laneMask=None, value=None):                                    
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_eq_in_0.eq_vga2_gain = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_eq_in_1.eq_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_eq_in_0.eq_vga2_gain = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_eq_in_1.eq_ovrd_en = 1 if value!=None else 0


def setDfe(tile, portId, lane=None, laneMask=None, tapNum=None, value=None):                            
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if tapNum!=None:
            if value!=None: tile.getbypath("phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_eq_in_%d"%(int(tapNum/2.0)+1)).writefield("eq_dfe_tap%d"%tapNum, int(tmpVal))
            tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_eq_in_1.eq_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if tapNum!=None:
                if tapNum==1:
                    if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_2.rx_eq_dfe_tap1_ovrd_val = int(value)

                if (_access=="stub" and _subAccess=="offline"):
                    stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "dfe%d"%tapNum, value)
def getDfe(tile, portId, lane=None, laneMask=None, tapNum=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    if loopCnt!=None:
        data = getRxLoop(tile, portId, lane, laneMask, "dfe%d"%tapNum, loopCnt, showProg, returnMean, returnDict)

    else:
        ditherBits = 5
        data = {}
        for i in laneList:

            if tapNum!=None:
                if _useStatusRegs==True:
                    numBits = int(tile.getbypath("phy_quad%d.syn_phy.lane%d.dig_rx_adptctl_dfe_tap%d_status.dfe_tap%d_adpt_code"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),tapNum,tapNum)).numbits) - ditherBits
                    tmpVal  = int(tile.getbypath("phy_quad%d.syn_phy.lane%d.dig_rx_adptctl_dfe_tap%d_status"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),tapNum)).readfield("dfe_tap%d_adpt_code"%tapNum)) >> ditherBits

                else:
                    gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
                    numBits = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_dfe_tap%d%s.dfe_tap%d_adpt_val"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),tapNum,gen4Suffix,tapNum)).numbits) - ditherBits
                    tmpVal  = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adpt_dfe_tap%d%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),tapNum, gen4Suffix)).readfield("dfe_tap%d_adpt_val"%tapNum)) >> ditherBits

                if tapNum==1:
                    data[i] = tmpVal if tmpVal<2**(numBits-1) else (tmpVal-2**numBits)                      ## value stored as 2's comp
                else:
                    data[i] = tmpVal - 64
    
            if (_access=="stub" and _subAccess=="offline"):
                data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "dfe%d"%tapNum)

    if len(laneList)==1 and returnDict==False:
        if loopCnt==None:
            return(data[i])
        else:
            return(data)
    else:
        return(data)
def setCdrVcoFreqBand(tile, portId, lane=None, laneMask=None, value=None):                              
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_1.rx_cdr_vco_freqband_1_0 = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.rx_cdr_vco_freqband_1_0 = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.en = 1 if value!=None else 0

def setRxTermAcDc(tile, portId, lane=None, laneMask=None, value=None):                                  
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_3.term_acdc = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_3.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_3.term_acdc = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_3.en = 1 if value!=None else 0

def setRxDeltaIq(tile, portId, lane=None, laneMask=None, value=None):                                   
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_6.rx_delta_iq_ovrd = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_6.rx_delta_iq_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_6.rx_delta_iq_ovrd = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_6.rx_delta_iq_ovrd_en = 1 if value!=None else 0

def setRxAdaptSel(tile, portId, lane=None, laneMask=None, value=None):                              
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.rx_adapt_sel_ovrd = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.rx_adapt_sel_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.rx_adapt_sel_ovrd = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.rx_adapt_sel_ovrd_en = 1 if value!=None else 0

def setRxAdaptMode(tile, portId, lane=None, laneMask=None, value=None):                                 
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.rx_adapt_mode = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.rx_adapt_mode_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.rx_adapt_mode = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.rx_adapt_mode_ovrd_en = 1 if value!=None else 0

def setRxAdaptReq(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.adapt_req = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.adapt_req_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.adapt_req = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.adapt_req_ovrd_en = 1 if value!=None else 0

def getRxAdaptAck(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_adapt_ack.rx_adapt_ack)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setRxAdaptContinuous(tile, portId, lane=None, laneMask=None, value=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_ate_ovrd_in_2.adapt_cont = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_ate_ovrd_in_2.cont_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.adapt_cont = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.cont_ovrd_en = 1 if value!=None else 0


def getRxAdaptContinuous(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.cont_ovrd_en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.adapt_cont)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_pcs_in.adapt_cont)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setRxCalContinuous(tile, portId, lane=None, laneMask=None, value=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_ate_ovrd_in_2.offcan_cont = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_ate_ovrd_in_2.cont_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.offcan_cont = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.cont_ovrd_en = 1 if value!=None else 0

def getRxCalContinuous(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.cont_ovrd_en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_ate_ovrd_in_2.offcan_cont)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_pcs_in.offcan_cont)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setClkDiv2Enable(tile, portId, value=None):                                                         
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_refclk_ovrd_in.ref_clk_div2_en = int(value)

def setRefClkMpllDiv2Enable(tile, portId, mpll=_mpll, value=None):                                      
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).writefield("ref_clk_mpll%s_div2_en"%(mpll), int(value))
        tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en = 1 if value!=None else 0

def getRefClkMpllDiv2Enable(tile, portId, mpll=_mpll, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, lane=0, type="byTile")

    data = {}
    for q in quadList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en)==1):
            data[q] = int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).readfield("ref_clk_mpll%s_div2_en"%(mpll)))
        else:
            data[q] = int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_asic_in_0"%(q,mpll)).readfield("ref_clk_mpll%s_div2_en"%(mpll)))

    if len(data)==1 and returnDict==False:
        return(data[q])
    else:
        return(data)

def setMpllDiv8ClkEnable(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).writefield("mpll%s_div8_clk_en"%(mpll), int(value))
        tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en = 1 if value!=None else 0

def setMpllDiv10ClkEnable(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).writefield("mpll%s_div10_clk_en"%(mpll), int(value))
        tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en = 1 if value!=None else 0

def setMpllaDiv16p5ClkEnable(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_mplla_ovrd_in_0.mplla_div16p5_clk_en = int(value)

def setMpllTxClkDiv(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).writefield("mpll%s_tx_clk_div"%(mpll), int(value))
        tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en = 1 if value!=None else 0

def getMpllTxClkDiv(tile, portId, mpll=_mpll, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, lane=0, type="byTile")

    data = {}
    for q in quadList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en)==1):
            data[q] = int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).readfield("mpll%s_tx_clk_div"%(mpll)))
        else:
            data[q] = int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_asic_in_0"%(q,mpll)).readfield("mpll%s_tx_clk_div"%(mpll)))

    if len(data)==1 and returnDict==False:
        return(data[q])
    else:
        return(data)

def setMpllDivClkEnable(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_mplla_b_div_clk_ovrd_in.writefield("mpll%s_div_clk_en"%(mpll), int(value))

def setMpllDivMultiplier(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_mplla_b_div_clk_ovrd_in.writefield("mpll%s_div_multiplier"%(mpll), int(value))

def setMpllSscEnable(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_1"%(q,mpll)).writefield("mpll%s_ssc_en"%(mpll), int(value))

def setMpllSscClkSel(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_1"%(q,mpll)).writefield("mpll%s_ssc_clk_sel"%(mpll), int(value))

def setMpllSscFreqCntPeak(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_3"%(q,mpll)).writefield("mpll%s_ssc_freq_cnt_peak"%(mpll), int(value))

def setMpllSscFreqCntInit(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_2"%(q,mpll)).writefield("mpll%s_ssc_freq_cnt_init"%(mpll), int(value))

def setMpllSscUpSpread(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_1"%(q,mpll)).writefield("mpll%s_ssc_up_spread"%(mpll), int(value))

def setMpllFracnCtrl(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_1"%(q,mpll)).writefield("mpll%s_fracn_ctrl"%(mpll), int(value))

def setBsTxLowSwing(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_cmn_clk_ctrl_3.cfg_ext_bs_tx_lowswing = int(value)

def setBsRxBigSwing(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_cmn_clk_ctrl_3.cfg_ext_bs_rx_bigswing = int(value)

def setMpllMultiplier(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).writefield("mpll%s_multiplier"%(mpll), int(value))
        tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en = 1 if value!=None else 0

def getMpllMultiplier(tile, portId, mpll=_mpll, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, lane=0, type="byTile")

    data = {}
    for q in quadList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).ovrd_en)==1):
            data[q] = int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_0"%(q,mpll)).readfield("mpll%s_multiplier"%(mpll)))
        else:
            data[q] = int(tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_asic_in_0"%(q,mpll)).readfield("mpll%s_multiplier"%(mpll)))

    if len(data)==1 and returnDict==False:
        return(data[q])
    else:
        return(data)
def setMpllBandwidth(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))
    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup.dig_mpll%s_ovrd_in_4"%(q,mpll)).writefield("mpll%s_bandwidth"%(mpll), int(value))

def setRxVrefCtrl(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_lvl_ovrd_in.rx_vref_ctrl = int(value)
        tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_lvl_ovrd_in.rx_vref_ctrl_en = 1 if value!=None else 0

def setSupMisc(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_sup_ovrd_misc.sup_misc_ovrd_val = int(value)
        tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_sup_ovrd_misc.sup_misc_ovrd_en = 1 if value!=None else 0

def setRxRefLdVal(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_1.rx_ref_ld_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.rx_ref_ld_val = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.en = 1 if value!=None else 0

def getRxRefLdVal(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_1.rx_ref_ld_val)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_cdr_vco_asic_in_0.rx_ref_ld_val)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setRxVcoLdVal(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_2.rx_vco_ld_val = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_2.rx_vco_ld_val = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_2.en = 1 if value!=None else 0

def setBsRxLevel(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_lane_rx_ctrl_5.cfg_ext_bs_rx_level = int(value)

def setMpllRecalBankSel(tile, portId, mpll=_mpll, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_cmn_clk_ctrl_6.writefield("cfg_ext_mpll%s_recal_bank_sel"%(mpll), int(value))
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_cmn_clk_ctrl_6.writefield("cfg_ext_mpll%s_recal_bank_sel_ovrd_en"%(mpll), 1)

def setCdrPpmMax(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.rx_cdr_ppm_max_ovrd = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_5.rx_cdr_ppm_max_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.rx_cdr_ppm_max_ovrd = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_5.rx_cdr_ppm_max_ovrd_en = 1 if value!=None else 0


###############################################################################
##                                                                            #
##      other PMA parameters                                                  #
##                                                                            #
###############################################################################
def setRxLanePowerDown(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.lpd = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.lpd = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0

def setTxLanePowerDown(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.lpd = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.lpd = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0

def setAttCal(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_aon_afe_att_idac_ofst.afe_att_idac_ofst = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_afe_att_idac_ofst.afe_att_idac_ofst = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "attc", value)

def getAttCal(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_afe_att_idac_ofst.afe_att_idac_ofst)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "attc")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setCtleCal(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_aon_afe_ctle_idac_ofst.afe_ctle_idac_ofst = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_afe_ctle_idac_ofst.afe_ctle_idac_ofst = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctle", value)

def getCtleCal(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_afe_ctle_idac_ofst.afe_ctle_idac_ofst)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "ctle")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setVga1Cal(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_aon_afe_vga1_idac_ofst.afe_vga1_idac_ofst = int(value)
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_afe_vga1_idac_ofst.afe_vga1_idac_ofst = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vgac", value)

def getVga1Cal(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_afe_vga1_idac_ofst.afe_vga1_idac_ofst)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vgac")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setVoc(tile, portId, lane=None, laneMask=None, voc=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if voc not in _vocList or value==None: 
        return(None)

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_dac_ctrl_ovrd.rx_cal_dac_ctrl_ovrd = 1
        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_dac_ctrl_sel.rx_ana_cal_dac_ctrl_sel = _vocDict[voc]
        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_dac_ctrl.rx_ana_cal_dac_ctrl = int(value)

        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ana_cal_dac_ctrl_en.dac_ctrl_self_clear_disable = 1

        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ana_cal_dac_ctrl_en.rx_ana_cal_dac_ctrl_en = 1
        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ana_cal_dac_ctrl_en.rx_ana_cal_dac_ctrl_en = 0

        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_dac_ctrl_sel.rx_ana_cal_dac_ctrl_sel = 0
        tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_dac_ctrl_ovrd.rx_cal_dac_ctrl_ovrd = 0

    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        if tile._fpgaNum not in _vocValOvrdDict:
            setTileConfigDictGlobal(tile)

        for i in laneList:
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_dac_ctrl_ovrd.rx_cal_dac_ctrl_ovrd = 1
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_dac_ctrl_sel.rx_ana_cal_dac_ctrl_sel = _vocDict[voc]
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_dac_ctrl.rx_ana_cal_dac_ctrl = int(value)

            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ana_cal_dac_ctrl_en.rx_ana_cal_dac_ctrl_en = 1
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ana_cal_dac_ctrl_en.rx_ana_cal_dac_ctrl_en = 0

            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_dac_ctrl_sel.rx_ana_cal_dac_ctrl_sel = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_dac_ctrl_ovrd.rx_cal_dac_ctrl_ovrd = 0


            _vocValOvrdDict[tile._fpgaNum][tile._tileNum][portId.lower()][i][voc] = int(value)

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i, voc, int(value))

def getVoc(tile, portId, lane=None, laneMask=None, voc=None, returnDict=False, getCalValue=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    voc = voc.lower() if voc!=None else voc

    if voc not in _vocList: return(None)

    if tile._fpgaNum not in _vocValOvrdDict:
        setTileConfigDictGlobal(tile)

    data={}
    for i in laneList:

        if _vocValOvrdDict[tile._fpgaNum][tile._tileNum][portId.lower()][i][voc]!=None and getCalValue!=True:
            data[i] = _vocValOvrdDict[tile._fpgaNum][tile._tileNum][portId.lower()][i][voc]

        elif (_access=="stub" and _subAccess=="offline") and getCalValue!=True:
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), voc)

        else:
            if   voc=="pheh":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_phase_even_vdac_ofst.dfe_phase_even_vdac_ofst)
            elif voc=="phoh":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_phase_odd_vdac_ofst.dfe_phase_odd_vdac_ofst)
            elif voc=="phel":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_phase_even_low_vdac_ofst.dfe_phase_even_low_vdac_ofst)
            elif voc=="phol":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_phase_odd_low_vdac_ofst.dfe_phase_odd_low_vdac_ofst)
            elif voc=="dseh":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_data_even_high_vdac_ofst.dfe_data_even_high_vdac_ofst)
            elif voc=="dsel":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_data_even_low_vdac_ofst.dfe_data_even_low_vdac_ofst)
            elif voc=="dsoh":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_data_odd_high_vdac_ofst.dfe_data_odd_high_vdac_ofst)
            elif voc=="dsol":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_data_odd_low_vdac_ofst.dfe_data_odd_low_vdac_ofst)
            elif voc== "bpe":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_bypass_even_vdac_ofst.dfe_bypass_even_vdac_ofst)
            elif voc== "bpo":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_bypass_odd_vdac_ofst.dfe_bypass_odd_vdac_ofst)
            elif voc== "ese":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_error_even_vdac_ofst.dfe_error_even_vdac_ofst)
            elif voc== "eso":
                data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_dfe_error_odd_vdac_ofst.dfe_error_odd_vdac_ofst)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def stepVoc(tile, portId, lane=None, laneMask=None, voc=None, value=None, showProg=False, debug=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if (voc not in _vocList or value==None): return

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    for i in laneList:
        calVoc  = getVoc(tile, portId, lane=i, voc=voc, getCalValue=True)
        dfe1    = 0 if(_access=="stub" and _subAccess=="offline") else getDfe(tile, portId, lane=i, tapNum=1)
        sign    = 1 if voc[-1]=="h" else -1
        newVoc  = calVoc+(sign*dfe1)+value

        if debug==True:
            print("BBBBBB:  voc: %s  calVoc: %4d  value; %4d  dfe1:  %4d  sign: %4d  newVoc: %4d"%(voc, calVoc, value, dfe1, sign, newVoc))

        if showProg==True:
            tmpMsg = "... stepping VOC (%s_%s, lane=%2d, %4s=%3d)"%(tile._tileName, portId, i, voc, value)
            showProgress(laneList.index(i), type="time", msg=tmpMsg)

        setVoc(tile, portId, lane=i, voc=voc, value=newVoc)

def getVcoCal(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    ditherBits = 5
    data={}
    for i in laneList:
        if tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_vco_ovrd_out_0.rx_cdr_freq_tune_ovrd_en==1:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_vco_ovrd_out_0.rx_ana_cdr_freq_tune)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_vcocal_rx_vco_stat_0.rx_ana_cdr_freq_tune) >> ditherBits

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vcoc")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setVco(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    for i in laneList:
        setIqPhaseAdjust(tile, portId, i, value=value)

        if (_access=="stub" and _subAccess=="offline"):
            stubAccess(tile, portId, i, "vco", value)

def getVco(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    data = getIqPhaseAdjust(tile, portId, lane, laneMask, returnDict, showProg)
    return(data)

def stepVco(tile, portId, lane=None, laneMask=None, value=None, showProg=False, debug=False, returnStatus=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    value = 0 if value==None else value

    pmux_code_space = list(range(8)) + list(reversed(list(range(8))))

    tmpList1        = pmux_code_space + pmux_code_space + pmux_code_space                                       ##        [ 0, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 2, 1, 0]

    tmpList2        = [int(8*floor(a//8)) for a in list(reversed(list(range(48))))]                                 ##        [40,40,40,40,40,40,40,40,32,32,32,32,32,32,32,32,24,24,24,24,24,24,24,24,16,16,16,16,16,16,16,16, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0]
    pmix_code_space = [a+b for (a,b) in zip(tmpList1,tmpList2)]                                                 ##        [40,41,42,43,44,45,46,47,39,38,37,36,35,34,33,32,24,25,26,27,28,29,30,31,23,22,21,20,19,18,17,16, 8, 9,10,11,12,13,14,15, 7, 6, 5, 4, 3, 2, 1, 0]

    step_code_space = [(a*7)+b for a in range(6) for b in range(8)]                                             ##        [ 0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9,10,11,12,13,14,14,15,16,17,18,19,20,21,21,22,23,24,25,26,27,28,28,29,30,31,32,33,34,35,35,36,37,38,39,40,41,42]

    iq_code_space   = [0] + [(a*7)+1+a+b for a in range(6) for b in range(7)]                                   ##        [ 0, 1, 2, 3, 4, 5, 6, 7,    9,10,11,12,13,14,15,   17,18,19,20,21,22,23,   25,26,27,28,29,30,31,   33,34,35,36,37,38,39,   41,42,43,44,45,46,47]

    for i in laneList:  

        iq_code     = getIqCode(tile, portId, i)

        step_code   = step_code_space[iq_code]

        step_code_margin    = step_code + value

        iq_code_margin = iq_code_space[step_code_margin]

        incdec = -1 if iq_code > iq_code_margin else 1

        if debug==True:
            print("value: %3d  iq_code; %3d  step_code: %3d  step_code_margin: %3d  iq_code_margin %3d  incdec: %3d"%(value, iq_code, step_code, step_code_margin, iq_code_margin, incdec))

        if showProg==True:
            tmpMsg = "... stepping VCO (%s_%s, lane=%2d,  vco=%3d)"%(tile._tileName, portId, i, value)
            showProgress(laneList.index(i), type="time", msg=tmpMsg)

#       % ------------------------------------------------------------------------
#       % WALK PMIX >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#       % ------------------------------------------------------------------------

        if iq_code==iq_code_margin:
            if debug==True:
                print("\t\t000000  iq_code:  %3d  pmix_code_space[iq_code]: %3d"%(iq_code, pmix_code_space[iq_code]))
            setVco(tile, portId, i, value=pmix_code_space[iq_code])

        else:
            while (iq_code != iq_code_margin):

                iq_code = iq_code + incdec

                if returnStatus==True and ((iq_code+1) not in pmix_code_space):
                    return(False)

                if debug==True:
                    print("\t\t111111  iq_code:  %3d  pmix_code_space[iq_code+1]: %3d"%(iq_code, pmix_code_space[iq_code+1]))

                setVco(tile, portId, i, value=pmix_code_space[iq_code])

        if (_access=="stub" and _subAccess=="offline"):
            tmpVco = getVco(tile, portId, i)
            stubAccess(tile, portId, i, "vco", value=tmpVco+value)

        if returnStatus==True:
            return(True)

def getIqCode(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_rx_phsadj_lin.rx_phsadj_lin)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setIqPhaseAdjust(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: 
            tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ana_phase_adjust_clk.phase_adjust_self_clear_disable = 0
            tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ana_iq_phase_adjust.rx_ana_iq_phase_adjust = int(value)
            tile.phy_broadcast.syn_phy.lanex.dig_ana_rx_ana_phase_adjust_clk.rx_ana_iq_phase_adjust_clk = 1
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: 
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ana_phase_adjust_clk.phase_adjust_self_clear_disable = 0
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ana_iq_phase_adjust.rx_ana_iq_phase_adjust = int(value)
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ana_phase_adjust_clk.rx_ana_iq_phase_adjust_clk = 1

def getIqPhaseAdjust(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_ana_iq_phase_adjust.rx_ana_iq_phase_adjust)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "vco")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setTxPstate(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))
    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.pstate = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.pstate = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "txPstate", value)

def getTxPstate(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:

        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.pstate)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_0.pstate)

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "txPstate")

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setRxPstate(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.pstate = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.pstate = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0

            if (_access=="stub" and _subAccess=="offline"):
                stubAccess(tile, portId, i-_getTileStrtLane(tile, portId), "rxPstate", value)

def setPcieLaneSelect(tile, portId, lane):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p" and lane!=None:
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_status_l1lane_reg.lane_select = lane

def setPciePortType(tile, portId, root=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    global _tileConfigDict

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p":
        quadList = getQuadList(tile, portId, type="byTile")

        tile.getbypath("pcie_avmm%d"%(quadList[0])).hip_ctrl.k_device_type = int(root)
        _tileConfigDict[tile._fpgaNum][tile._tileNum][portId.lower()]["root"] = int(root)

def getPciePortType(tile, portId, returnStr=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if hasattr(tile,"pcie_ep%d"%_getPortNum(portId)):
        return("ep")
    elif hasattr(tile,"pcie_rp%d"%_getPortNum(portId)):
        return("rp")
    else:
        return(None)

def getPcieRegPrefix(tile, portId):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p":
        epRpStr = getPciePortType(tile, portId, returnStr=True)
        
        pciePortStr = "pcie_%s%d"%(epRpStr,_getPortNum(portId)) + (".pf0" if epRpStr=="ep" else "")

        return(pciePortStr)

def getSnpsSramRecordingAddress(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_sram_rec_addr.sram_rec_addr)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def getSnpsSramRecordingIteration(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_aon_sram_rec_iter.sram_rec_iter)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setPhyReset(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))
    quadList = getQuadList(tile, portId, lane, laneMask, type="byTile")

    for q in quadList:
        tile.getbypath("phy_quad%d.syn_phy.sup"%(q)).dig_asic_in.phy_reset = int(value)

def setTxReset(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.reset = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.reset = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0

def setRxReset(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_pcs_xf_rx_ovrd_in_1.reset_ovrd_val = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_pcs_xf_rx_ovrd_in_1.reset_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_1.reset_ovrd_val = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_1.reset_ovrd_en = 1 if value!=None else 0

def setRxDataEn(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.data_en = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.data_en = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_in_0.en = 1 if value!=None else 0

def getPwrSupplyVoltage(tile, portId, lane=None, laneMask=None, supply="vp", returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if supply not in ["vp","vph","vph/2"]:
        return(None)

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:

        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_rtune_ctrl.rt_atb = 1
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_rtune_ctrl.rt_sel_atbp = 1
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_rtune_ctrl.rt_en_frcon = 1

        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_0 = 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_1 = 1 if supply=="vph"   else 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_2 = 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_3 = 1 if supply=="vp"    else 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_4 = 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_5 = 1 if supply=="vph/2" else 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).ana_switch_pwr_meas.atb_switch_6 = 0

        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).dig_rtune_debug.type_ = 0
        tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).dig_rtune_debug.man_tune = 1
        tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).ana_tx_vboost.atb_s_enable = 1

        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.sup"%(_getQuadNum(tile,portId,i))).dig_rtune_stat.stat) / 1000.0
        tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).ana_tx_vboost.atb_s_enable = 0

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def getRxStats(tile, portId, lane=None, laneMask=None, returnStr=False, delimiter="\t", returnHdr=False, loopCnt=None, cal=None, getCal=True, loop=None, getLoop=True, returnDict=False, showProg=False, returnMean=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    loopCnt = _loopCnt if loopCnt==None else loopCnt

    loop = loop.lower() if loop!=None else loop

    loopList = []
    if (getLoop==True and cal==None) or loop!=None:
        if loop==None:
            loopList = _rxLoopList
            loopList.sort()
        else:
            loopList = [loop]

    calList = []
    if (getCal==True and loop==None) or cal!=None:
        if cal==None:
            calList = _rxCalList
            calList.sort()
        else:
            calList = [cal.lower()]

    rxList=[]
    if getLoop==True:
        rxList.extend(loopList)

    if getCal==True:
        rxList.extend(calList)

    if rxList==[] and (returnStr==False and returnHdr==False):
        return(None)

    tmpDict = {}
    for a in rxList:
        tmpDict[a] = deepcopy([None,None,None,None,None]) if (loopCnt not in [0,1] and returnMean==False) else deepcopy(None)

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    rxDict = {}
    for i in laneList:
        rxDict[i] = deepcopy(tmpDict)

    for param in list(rxDict[laneList[0]].keys()):
        for i in laneList:
            if getLoop==True and param in _rxLoopList:
                rxDict[i][param] = getRxLoop(tile, portId, i, loop=param, loopCnt=loopCnt, showProg=showProg)
            elif getCal==True and param in _rxCalList:
                rxDict[i][param] = getRxCal(tile, portId, i, cal=param)

    if loopCnt not in [0,1] and returnMean==True:
        for i in laneList:
            for a in rxList:
                if isList(rxDict[i][a]) and returnMean==True and rxDict[i][a]!=[]:
                    rxDict[i][a] = int(round(rxDict[i][a][0], 0))

    if returnStr==True or returnHdr==True:
        tmpStr={}
        for i in laneList:
            if i not in tmpStr:
                tmpStr[i] = ""

            for a in rxList:
                if isNumber(rxDict[i][a]):
                    if returnHdr==True:
                        tmpStr[i] +="%5s%s"%(a, delimiter)
                    else:
                        tmpStr[i] +="%5d%s"%(rxDict[i][a], delimiter)
                elif isList(rxDict[i][a]):
                    if returnHdr==True:
                        tmpStr[i] +="%6s%s%6s%s%6s%s%6s%s%6s%s"%(a+"_mean",delimiter,a+"_min",delimiter,a+"_max",delimiter,a+"_stdev",delimiter,a+"_cnt",delimiter)
                    else:
                        tmpStr[i] +="%5.2f%s%5d%s%5d%s%5.2f%s%4d%s"%(rxDict[i][a][0],delimiter,rxDict[i][a][1],delimiter,rxDict[i][a][2],delimiter,rxDict[i][a][3],delimiter,rxDict[i][a][4],delimiter)

        if len(laneList)==1 and returnDict==False:
            return(tmpStr[i])
        else:
            return(tmpStr)
    else:
        if len(laneList)==1 and returnDict==False:
            return(rxDict[i])
        else:
            return(rxDict)

def getTxStats(tile, portId, lane=None, laneMask=None, returnStr=False, delimiter="\t", returnHdr=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    txList = _txList
    txList.sort()

    tmpDict = {}
    for a in txList:
        tmpDict[a] = deepcopy([None])

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    txDict = {}
    for i in laneList:
        txDict[i] = deepcopy(tmpDict)

    if returnHdr==False:
        for i in laneList:
            for param in _txList:
                txDict[i][param] = getTxParam(tile, portId, i, param=param)

    if returnStr==True or returnHdr==True:
        tmpStr=""
        for i in laneList:
            for a in txList:
                if returnHdr==True:
                    tmpStr +="%6s%s"%(a.lower(),delimiter)
                else:
                    if isList(txDict[i][a]):
                        tmpStr +="%4s%s"%(txDict[i][a],delimiter)
                    else:
                        tmpStr +="%4d%s"%(txDict[i][a],delimiter)
        return(tmpStr)
    else:
        if len(laneList)==1 and returnDict==False:
            return(txDict[i])
        else:
            return(txDict)

def setTxParam(tile, portId, lane=None, laneMask=None, showProg=False, param=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if param!=None:
        param = param.lower()

        if showProg==True and lane!=None:
            msg = "... setting Tx param values for:     %-6s (%s-%s, lane=%2s, value=%3s)"%(param, tile._tileName, portId, lane, value)
            showProgress(type="time", msg=msg)

        if param!=None and param in _txList:
            if param=="vboost":
                setTxVboost(tile, portId, lane, laneMask, value=value)
            elif param=="iboost":
                setTxIboost(tile, portId, lane, laneMask, value=value)
            elif param=="[cm1,c0,cp1]":
                setTxEq(tile, portId, lane, laneMask, txEqList=value)
        else:
            print("\nERROR: (%s) param=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, param))
            data = _errVal
        
        if showProg==True and lane!=None:
            showProgress(type=None)

def getTxParam(tile, portId, lane=None, laneMask=None, showProg=False, param=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if param!=None:
        param = param.lower()

        if showProg==True and lane!=None:
            msg = "... setting Tx param values for:     %-6s (%s-%s, lane=%2s, value=%3s)"%(param, tile._tileName, portId, lane, value)
            showProgress(type="time", msg=msg)

        if param!=None and param in _txList:
            if param=="vboost":
                data = getTxVboost(tile, portId, lane, laneMask)
            elif param=="iboost":
                data = getTxIboost(tile, portId, lane, laneMask)
            elif param=="swing":
                data = getTxSwing(tile, portId, lane, laneMask)
            elif param=="[cm1,c0,cp1]":
                data = getTxEq(tile, portId, lane, laneMask)
        else:
            print("\nERROR: (%s) param=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, param))
            data = _errVal
        
        return(data)

def setRxLoop(tile, portId, lane=None, laneMask=None, showProg=False, loop=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if loop!=None:
        loop = loop.lower()

        if showProg==True and lane!=None:
            msg = "... setting Rx loop values for:     %-6s (%s_%s, lane=%2s, value=%3s)"%(loop, tile._tileName, portId, lane, value)
            showProgress(type="time", msg=msg)

        if loop!=None and loop in _rxLoopList:
            if loop=="att":
                setAtt(tile, portId, lane, laneMask, value=value)
            elif loop=="ctleb":
                setCtleBoost(tile, portId, lane, laneMask, value=value)
            elif loop=="ctlep":
                setCtlePole(tile, portId, lane, laneMask, value=value)
            elif loop=="dfe1":
                setDfe(tile, portId, lane, laneMask, tapNum=1, value=value)
            elif loop=="dfe2":
                setDfe(tile, portId, lane, laneMask, tapNum=2, value=value)
            elif loop=="dfe3":
                setDfe(tile, portId, lane, laneMask, tapNum=3, value=value)
            elif loop=="dfe4":
                setDfe(tile, portId, lane, laneMask, tapNum=4, value=value)
            elif loop=="dfe5":
                setDfe(tile, portId, lane, laneMask, tapNum=5, value=value)
            elif loop=="vco":
                setVco(tile, portId, lane, laneMask, value=value)
            elif loop=="vga1":
                setVga1(tile, portId, lane, laneMask, value=value)
            elif loop=="vga2":
                setVga2(tile, portId, lane, laneMask, value=value)
        else:
            print("ERROR: (%s) loop=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, loop))
            data = _errVal
        
        if showProg==True and lane!=None:
            showProgress(type=None)

def getRxLoop(tile, portId, lane=None, laneMask=None, loop=None, loopCnt=None, showProg=False, returnMean=True, returnDict=False, returnNumList=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if loop==None:
        return
    elif loop not in _rxLoopList:
        print("ERROR: (%s) loop=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, loop))
        return(_errVal)

    loop        = loop.lower()
    loopCnt     = 1 if (loopCnt==0 or loopCnt==None) else loopCnt
    laneList    = getLaneList(tile, portId, lane, laneMask, type="byPort")
    tmpLoopCnt  = 1000*abs(loopCnt) if loopCnt<0 else loopCnt

    data = {}
    for i in laneList:
        tmpList = []
        for a in range(1, tmpLoopCnt+1):
            if _ssa!=True and tmpLoopCnt not in [0,1] and showProg==True:
                msg = "... reading Rx loop statistics for \'%-5s\': (%s-%s, lane=%2s, loopCnt=%3d)"%(loop, tile._tileName, portId, lane, a)
                showProgress(type="time", msg=msg)

            tmpVal = None
            if loop=="att":
                tmpVal = getAtt(tile, portId, i)
            elif loop=="ctleb":
                tmpVal = getCtleBoost(tile, portId, i)
            elif loop=="ctlep":
                tmpVal = getCtlePole(tile, portId, i)
            elif loop[:-1]=="dfe":
                tmpVal = getDfe(tile, portId, i, tapNum=int(loop[-1]))
            elif loop=="vco":
                tmpVal = getVco(tile, portId, i)
            elif loop=="vga1":
                tmpVal = getVga1(tile, portId, i)
            elif loop=="vga2":
                tmpVal = getVga2(tile, portId, i)

            if tmpVal!=None:
                tmpList.append(tmpVal)

                if loopCnt<0 and chkSampleSizeDone(tmpList)==True:
                    break

        data[i] = tmpList[0] if tmpLoopCnt==1 else tmpList

    if returnNumList==False:
        for i in laneList:
            if isList(data[i])==True and len(data[i])>1:
                minVal  = min(data[i])
                maxVal  = max(data[i])
                avgVal  = mean(data[i])
                stdDev  = stdev(data[i])
                cnt     = len(data[i])
                if showProg==True:
                    showProgress(type=None)
    
                data[i] = avgVal if returnMean==True else [avgVal, int(minVal), int(maxVal), stdDev, cnt]

    if showProg==True:
        showProgress(type=None)

    if len(laneList)==1 and returnDict==False:
        if isNumber(data[i]):
            return(int(round(data[i],0)))
        else:
            return(data[i])
    else:
        return(data)

def getRxLoopOverride(tile, portId, lane=None, laneMask=None, loop=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    loop        = loop.lower()

    if loop==None:
        return
    elif loop not in _rxLoopList:
        print("ERROR: (%s) loop=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, loop))
        return(_errVal)

    data = {}
    for i in laneList:

        if loop=="att":
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_ovrd_en)
        elif loop=="ctleb":
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_ovrd_en)
        elif loop=="ctlep":
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_ovrd_en)
        elif loop=="dfe1":
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_ovrd_en)
        elif loop=="dfe2":
            data[i] = 0
        elif loop=="dfe3":
            data[i] = 0
        elif loop=="dfe4":
            data[i] = 0
        elif loop=="dfe5":
            data[i] = 0
        elif loop=="vco":
            data[i] = 0
        elif loop=="vga1":
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_ovrd_en)
        elif loop=="vga2":
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_eq_ovrd_in_1.rx_eq_ovrd_en)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def getRxAdaptDone(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        gen4Suffix = "_b1" if getBaudRate(tile,portId)==16.0 else ""
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d.dig_aon_rx_adapt_done%s"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i),gen4Suffix)).readfield("rx_adapt_done%s"%gen4Suffix))

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setRxCal(tile, portId, lane=None, laneMask=None, cal=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if cal!=None:
        cal = cal.lower()

        if cal in _vocList:
            setVoc(tile, portId, lane, laneMask, voc=cal, value=value)

        elif (cal!=None and value!=None) and cal in _rxCalList:
            if cal=="att":
                setAttCal(tile, portId, lane, laneMask, value=value)
            elif cal=="ctle":
                setCtleCal(tile, portId, lane, laneMask, value=value)
            elif cal=="vga1":
                setVga1Cal(tile, portId, lane, laneMask, value=value)

        else:
            print("ERROR: (%s) cal=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, cal))
            data = _errVal

def getRxCal(tile, portId, lane=None, laneMask=None, cal=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if cal!=None:
        cal = cal.lower()

        if cal in _vocList:
            data = getVoc(tile, portId, lane, laneMask, voc=cal)

        elif cal!=None and cal in _rxCalList:
            cal=cal.lower()
            if cal=="attc":
                data = getAttCal(tile, portId, lane, laneMask)
            elif cal=="ctle":
                data = getCtleCal(tile, portId, lane, laneMask)
            elif cal=="vgac":
                data = getVga1Cal(tile, portId, lane, laneMask)
            elif cal=="vcoc":
                data = getVcoCal(tile, portId, lane, laneMask)

        else:
            print("ERROR: (%s) cal=\'%s\' not found"%(_sys._getframe(0).f_code.co_name, cal))
            data = _errVal
        
        return(data)

def setRxToTxLoopback(tile, portId, lane=None, laneMask=None, enable=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))
    if _broadcast==True and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1:
        tile.phy_broadcast.syn_phy.lanex.dig_asic_lane_ovrd_in.lane_tx2rx_ser_lb = 0
        tile.phy_broadcast.syn_phy.lanex.dig_asic_lane_ovrd_in.lane_rx2tx_par_lb = int(bool(enable))
        tile.phy_broadcast.syn_phy.lanex.dig_asic_lane_ovrd_in.en = 1 if enable!=None else 0

    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_lane_ovrd_in.lane_tx2rx_ser_lb = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_lane_ovrd_in.lane_rx2tx_par_lb = int(bool(enable))
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_lane_ovrd_in.en = 1 if enable!=None else 0

def setTxToRxLoopback(tile, portId, lane=None, laneMask=None, enable=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1:
        tile.phy_broadcast.syn_phy.lanex.dig_asic_lane_ovrd_in.lane_rx2tx_par_lb = 0
        tile.phy_broadcast.syn_phy.lanex.dig_asic_lane_ovrd_in.lane_tx2rx_ser_lb = int(bool(enable))
        tile.phy_broadcast.syn_phy.lanex.dig_asic_lane_ovrd_in.en = 1 if enable!=None else 0

    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_lane_ovrd_in.lane_rx2tx_par_lb = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_lane_ovrd_in.lane_tx2rx_ser_lb = int(bool(enable))
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_lane_ovrd_in.en = 1 if enable!=None else 0

def setLoopbackMode(tile, portId, lane=None, laneMask=None, lbMode="rx2tx", enable=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if lbMode=="rx2tx":
        setRxToTxLoopback(tile, portId, lane=lane, laneMask=laneMask, enable=enable)
    elif lbMode=="tx2rx":
        setTxToRxLoopback(tile, portId, lane=lane, laneMask=laneMask, enable=enable)

def setTxBertPattern(tile, portId, lane=None, laneMask=None, prbs="prbs31", patt=0x155, width=20):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    prbs = prbs.lower() if prbs!=None else prbs

    for mode in list(_pattDict.keys()):
        if _pattDict[mode]["pattern"]==prbs.lower():
            break

    if "prbs" not in _pattDict[mode]:
        patt = 0 if patt==None else (patt & 0x3FF)

    if _broadcast==True and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1:
        if mode in [9,10,11]:
            tile.phy_broadcast.syn_phy.lanex.dig_tx_lbert_ctl.pat0 = patt

        tile.phy_broadcast.syn_phy.lanex.dig_tx_lbert_ctl.mode = 0
        tile.phy_broadcast.syn_phy.lanex.dig_tx_lbert_ctl.mode = mode
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if mode in [9,10,11]:
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_tx_lbert_ctl.pat0 = patt

            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_tx_lbert_ctl.mode = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_tx_lbert_ctl.mode = mode

def setRxBertPattern(tile, portId, lane=None, laneMask=None, prbs="prbs31", patt=0x155, width=20):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    prbs = prbs.lower() if prbs!=None else prbs

    for mode in list(_pattDict.keys()):
        if _pattDict[mode]["pattern"]==prbs:
            break

    if "prbs" not in _pattDict[mode]:
        patt = 0 if patt==None else (patt & 0x3FF)

    if _broadcast==True and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1:
        if mode in [9,10,11]:
            tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.pat0 = patt

        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.mode = 0
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.mode = mode
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if mode in [9,10,11]:
                tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.pat0 = patt

            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.mode = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.mode = mode

def setBertPattern(tile, portId, lane=None, laneMask=None, prbs="prbs31", patt=0x155, width=20):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    setRxBertPattern(tile, portId, lane, laneMask, prbs, patt, width)
    setTxBertPattern(tile, portId, lane, laneMask, prbs, patt, width)

def syncRxBert(tile, portId, lane=None, laneMask=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1:
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.sync = 0
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.sync = 1
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.sync = 0
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.sync = 1
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_ctl.sync = 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.sync = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.sync = 1
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.sync = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.sync = 1
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_ctl.sync = 0

def getRxBertErrCnt(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        errCnt = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_err.count)
        ovr = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_err.ov14)

        if ovr==1:
            errCnt = ((errCnt+1) << 7) - 1

        data[i] = errCnt if errCnt!=2**15-1 else _errVal

        if (_access=="stub" and _subAccess=="offline"):
            data[i] = stubGetErrCnt(tile, portId)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def clearRxBertErrCnt(tile, portId, lane=None, laneMask=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))
    if _broadcast==True and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1:
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_err.count = 1
        tile.phy_broadcast.syn_phy.lanex.dig_rx_lbert_err.ov14 = 1
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_err.count = 0
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_lbert_err.ov14 = 0

def setSramBypass(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, lane, laneMask, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_misc_ctl_stat_0.cfg_sram_bypass = int(value)

def enableFirmware(tile, portId, lane=None, laneMask=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    setFsmOverrideEnable(tile, portId, lane, laneMask, value=0)

def disableFirmware(tile, portId, lane=None, laneMask=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    setFsmOverrideEnable(tile, portId, lane, laneMask, value=1)

def setFsmOverrideEnable(tile, portId, lane=None, laneMask=None, value=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        tile.phy_broadcast.syn_phy.rawlanex.dig_fsm_fsm_ovrd_ctl.fsm_ovrd_en = value
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_fsm_fsm_ovrd_ctl.fsm_ovrd_en = value

def getFsmOverrideEnable(tile, portId, lane=None, laneMask=None, returnDict=False, showProg=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_fsm_fsm_ovrd_ctl.fsm_ovrd_en)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

###############################################################################
##                                                                            #
##      general device setup & control                                        #
##                                                                            #
###############################################################################

def initTileInfo(idList=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    tileList = _tileList

    if _redCover==True and _quiet!=True and idList==None:
        if (("_partId" not in list(_tileDict[0].values())[0].__dict__) or list(_tileDict[0].values())[0]._partId==""):
            if idList==None or idList==() or len(idList)<len(tileList):
                print("\nEnter \'partId\' for:")

    for tile in tileList:
        if idList!=None and len(idList)>tile._tileNum and idList[tile._tileNum]!=None:
            tile.__dict__["_partId"] = idList[tile._tileNum]
        elif "_partId" not in tile.__dict__ or tile._partId=="":
            partId = tile._tileName
            if _redCover==True and _quiet!=True:
                partId = input("\t%s: "%tile._tileName)
            tile.__dict__["_partId"] = partId

        if "_stepping" not in tile.__dict__ or tile._stepping=="":
            tile.__dict__["_stepping"] = "A0"

def resetPhy(tile, portId, lane=None, laneMask=None, ph1=True, ph2=True, mode=None, topo=None, baudRate=None, setRecipe=False, showProg=False, rxPstate=0, txPstate=0): 
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if ph1==True:
        if all(cmdOption!=None for cmdOption in [mode,topo,baudRate]):
            setTileConfig(tile, mode=mode, topo=topo, baudRate=baudRate)
    
        setPhyReset(tile, portId, lane, laneMask, value=1)

        if not(_access=="stub" and _subAccess=="offline"):
            if not pollBit(tile, portId, lane, laneMask, bitName="rx_ack", value=1):
                if input("Do you want to continue? ") in ["n","N","no","NO"]: return
            if not pollBit(tile, portId, lane, laneMask, bitName="tx_ack", value=1):
                if input("Do you want to continue? ") in ["n","N","no","NO"]: return

        setRxReset(tile, portId, lane, laneMask, value=1)
        setTxReset(tile, portId, lane, laneMask, value=1)
        setRxReq(tile, portId, lane, laneMask, value=0)
        setTxReq(tile, portId, lane, laneMask, value=0)
        setDetRxReq(tile, portId, lane, laneMask, value=0)
        setRxPstate(tile, portId, lane, laneMask, value=rxPstate)
        setTxPstate(tile, portId, lane, laneMask, value=txPstate)
    
        if setRecipe==True:
            setPhyRecipe(tile, portId, lane, laneMask, showProg=showProg)

    if ph2==True:
        setRxReq(tile, portId, lane, laneMask, value=1)
        setTxReq(tile, portId, lane, laneMask, value=1)
        setPhyReset(tile, portId, lane, laneMask, value=0)
        setRxReset(tile, portId, lane, laneMask, value=0)
        setTxReset(tile, portId, lane, laneMask, value=0)
        setRefClkEn(tile, portId, value=1)
    
        if not(_access=="stub" and _subAccess=="offline"):
            if not pollBit(tile, portId, lane, laneMask, bitName="rx_ack", value=0):
                if input("Do you want to continue? ") in ["n","N","no","NO"]: return
            if not pollBit(tile, portId, lane, laneMask, bitName="tx_ack", value=0):
                if input("Do you want to continue? ") in ["n","N","no","NO"]: return

        setRxReq(tile, portId, lane, laneMask, value=0)
        setTxReq(tile, portId, lane, laneMask, value=0)

def setRefClkEn(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    quadList = getQuadList(tile, portId, lane=0, type="byTile")

    for q in quadList:
        if value!=None: tile.getbypath("phy_quad%d"%(q)).phy_misc_ctl_stat_1.cfg_ref_clk_en_ovrd = int(value)
        tile.getbypath("phy_quad%d"%(q)).phy_misc_ctl_stat_1.cfg_ref_clk_en = 1 if value!=None else 0

def setTxReq(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.req = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.req = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1

def setRxReq(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):

        if value!=None: tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_1.req_ovrd_val = int(value)
        tile.phy_broadcast.syn_phy.rawlanex.dig_pcs_xf_rx_ovrd_in_1.req_ovrd_en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:

            if value!=None: tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_1.req_ovrd_val = int(value)
            tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_ovrd_in_1.req_ovrd_en = 1 if value!=None else 0


def getTxAck(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_out.en_tx_ack)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_out.tx_ack)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_out.tx_ack)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def getRxAck(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_out_0.en_ctl)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_ovrd_out_0.ack)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_rx_asic_out_0.ack)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def setDetRxReq(tile, portId, lane=None, laneMask=None, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _broadcast==True and (lane==None and laneMask==None and len(list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()))==1):
        if value!=None: tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.detect_rx_req = int(value)
        tile.phy_broadcast.syn_phy.lanex.dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0
    else:
        laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

        for i in laneList:
            if value!=None: tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.detect_rx_req = int(value)
            tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en = 1 if value!=None else 0


def getDetRxReq(tile, portId, lane=None, laneMask=None, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        if (int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.en)==1):
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_ovrd_in_0.detect_rx_req)
        else:
            data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_asic_tx_asic_in_0.detect_rx_req)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

###############################################################################
##                                                                            #
##      UPI-specific functions                                                #
##                                                                            #
###############################################################################
def setCompliance(cpu, portId, master=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        if master==True:
            setInitMode(cpu, portId, value=3)
        else:
            setInitMode(cpu, portId, value=2)

    elif _getMode(portId)=="p":
        if master==True:
            setInitMode(cpu, portId, value=4)
        else:
            setInitMode(cpu, portId, value=5)

def setPhyInit(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        if value!=None: tile.upi_phy.ph_ctr1.cinitbegin = value

        if _access!="stub" and value==1: sleep(0.025)

    elif _getMode(portId)=="p":
        pass

def getPhyInit(tile, portId):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        phyInit = int(tile.upi_phy.ph_ctr1.cinitbegin)
    elif _getMode(portId)=="p":
        if _showWarnings:
            printc("\nWARNING: \'%s\' not implemented for PCIE\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")

        phyInit = None

    return(phyInit)

def setInitMode(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        if value!=None: tile.upi_phy.ph_ctr1.cinit = int(value)
    elif _getMode(portId)=="p":
        if _showWarnings:
            printc("\nWARNING: \'%s\' not implemented for PCIE\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")

def resetPhyLayer(tile, portId, verbose=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        tile.upi_phy.ph_ctr1.cpreset = 1

    elif _getMode(portId)=="p":
        if _showWarnings:
            printc("\nWARNING: \'%s\' not implemented for PCIE\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")

    if _access!="stub": sleep(0.025)

def setUpiLinkSpeed(tile, portId, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        if value!=None: tile.upi_phy.ph_ctr1.copspeed = value

        if (_access=="stub" and _subAccess=="offline"):
            stubAccess(tile, portId, None, "linkSpeed", value)

def getUpiLinkSpeed(tile, portId, verbose=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    speedDict = {0:"slow", 1:"fast", None:None}

    if _getMode(portId)=="u":
        linkSpeed = int(tile.upi_phy.ph_cis.sopspeed)

        if (_access=="stub" and _subAccess=="offline"):
            data = stubAccess(tile, portId, None, "linkSpeed")

        if verbose==True:
            return(speedDict[linkSpeed])
        else:
            return(linkSpeed)

def getPolarityInversion(tile, portId, lane=None, laneMask=None, returnDict=False, returnStr=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    if _getMode(portId)=="u":
        data = int(tile.upi_phy.ph_yis.srxpolinv)
    elif _getMode(portId)=="p":
        if _showWarnings:
            printc("\nWARNING: \'%s\' not implemented for PCIE\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")

        data = 0

    if len(laneList)==1 and returnDict==False and returnStr==False:
        return(bits(data, laneList[0], 1))
    elif returnStr==True:
        lanesPerPort = len(getLaneList(tile, portId))
        tmpStr = ""
        for i in range(lanesPerPort-1, -1, -1):
            tmpStr += "+" if bits(data, i,1)==0 else "-"
        return(tmpStr)
    else:
        return(data)

def getRxLaneStatus(tile, portId, lane=None, laneMask=None, returnDict=False, returnStr=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    portMask = getPortMask(tile=tile, portId=portId, type="byPort")

    if _getMode(portId)=="u":
        data = ((tile.upi_phy.ph_rds.srxlanedropped)^portMask) & portMask
        data = data >> _getTileStrtLane(tile, portId)

    elif _getMode(portId)=="p":
        data = 0
        for i in laneList:
            setPcieLaneSelect(tile, portId, i)

            if (_access=="stub" and _subAccess=="offline"):
                data = int((1) << i) | data
            else:
                data = int((tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_status_l1lane_reg.pipe_detect_lane) << i) | data

        data = data & portMask

    if len(laneList)==1 and returnDict==False and returnStr==False:
        return(bits(data,laneList[0],1))
    elif returnStr==True:
        lanesPerPort = len(getLaneList(tile, portId))
        dataStr = ""
        for i in range(lanesPerPort-1, -1, -1):
            dataStr += str(bits(data, i,1))
        return(dataStr)
    else:
        return(data)

def getTxLaneStatus(tile, portId, lane=None, laneMask=None, returnDict=False, returnStr=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    portMask = getPortMask(tile=tile, portId=portId, type="byPort")

    if _getMode(portId)=="u":
        data = (int(tile.upi_phy.ph_tds.stxlanedropped)^portMask) & portMask
        data = data >> _getTileStrtLane(tile, portId)

    elif _getMode(portId)=="p":
        data = 0
        for i in laneList:
            setPcieLaneSelect(tile, portId, i)

            if (_access=="stub" and _subAccess=="offline"):
                data = int((0) << i) | data
            else:
                data |= (int(not(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_status_l1lane_reg.pipe_txelecidle)) << i)

        data = data & portMask

    if len(laneList)==1 and returnDict==False and returnStr==False:
        return(bits(data,laneList[0],1))
    elif returnStr==True:
        lanesPerPort = len(getLaneList(tile, portId))
        dataStr = ""
        for i in range(lanesPerPort-1, -1, -1):
            dataStr += str(bits(data, i,1))
        return(dataStr)
    else:
        return(data)

def getLaneReversal(tile, portId):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    status=None
    if _getMode(portId)=="u":
        status = bool(int(tile.upi_phy.ph_cis.srxlanerev))

    elif _getMode(portId)=="p":
        status = bool(int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).sd_status_l1ltssm_reg.lane_reversal))

    return(status)

def getLtssmState(tile, portId, returnStr=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    data = None
    if _getMode(portId)=="u":
        data = int(tile.upi_phy.ph_css.stxstate)

    elif _getMode(portId)=="p":
        data = int(bits(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).pl_debug0_off.deb_reg_0, 0, 6))

    if (_access=="stub" and _subAccess=="offline"):
        data = stubAccess(tile, portId, None, "ltssmState")

    if returnStr==True:
        return(_ltssmDict[_getMode(portId)][data][0])
    else:
        return(data)

def getLtssmStateType(tile, portId, stateVal=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if stateVal==None:
        stateVal = getLtssmState(tile, portId)

    return("%s"%(_ltssmDict[_getMode(portId)][stateVal][2]))

def getErrCnt(tile, portId, lane=None, laneMask=None, stateVal=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    stateCat = getLtssmStateType(tile, portId, stateVal=stateVal)

    if stateCat in ["test"]:
        errCnt = getRxBertErrCnt(tile, portId, lane, laneMask)
    elif stateCat in ["l0"]:
        errCnt = getCrcErrCnt(tile, portId)
    else:
        errCnt = _errVal

    return(errCnt)

def clearErrCnt(tile, portId, lane=None, laneMask=None, stateVal=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    stateCat = getLtssmStateType(tile, portId, stateVal=stateVal)

    if stateCat in ["test"]:
        clearRxBertErrCnt(tile, portId, lane, laneMask)
    elif stateCat in ["l0"]:
        clearCrcErrCnt(tile, portId)

def getCrcErrCnt(tile, portId, lane=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        errCnt = int(tile.upi_link.whr_upi_num_crc_err.cntr)

    elif _getMode(portId)=="p":
        setPcieEventCounter(tile, portId, groupNum=1, eventNum=6)
        enablePcieEventCounter(tile, portId)
        errCnt = getPcieEventCounter(tile, portId, lane, groupNum=1, eventNum=6)

        if (_access=="stub" and _subAccess=="offline"):
            errCnt = stubGetErrCnt(tile, portId)

    return(errCnt)

def clearCrcErrCnt(tile, portId, lane=0):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _getMode(portId)=="u":
        tile.upi_link.whr_upi_dbg_ctrl_0.clr_rx_dbg_cnt = 1

    elif _getMode(portId)=="p":
        clearPcieEventCounter(tile, portId, lane, groupNum=1, eventNum=6)

def setPcieEventCounter(tile, portId, lane=0, groupNum=1, eventNum=6, enableVal=7):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p":
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_event_select = ((groupNum & 0xF)<<8) | (eventNum & 0xFF)
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_enable       = 7

def getPcieEventCounter(tile, portId, lane=0, groupNum=1, eventNum=6, enableVal=7):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p":
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_event_select = ((groupNum & 0xF)<<8) | (eventNum & 0xFF)
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_lane_select  = 0 if lane==None else int(lane)
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_enable       = 7

        return(int(tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_data_reg.event_counter_data))

def clearPcieEventCounter(tile, portId, lane=0, groupNum=1, eventNum=6):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p":
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_event_select = ((groupNum & 0xF)<<8) | (eventNum & 0xFF)
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_lane_select  = 0 if lane==None else int(lane)
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_clear        = 3
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_enable       = 7

def enablePcieEventCounter(tile, portId):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if _showWarnings and _getMode(portId)=="u":
        printc("\nWARNING: \'%s\' not implemented for UPI\n"%(_sys._getframe(0).f_code.co_name),"grey","yellow",True,False,srchStr="WARNING")
        return

    if _getMode(portId)=="p":
        tile.getbypath("%s"%getPcieRegPrefix(tile, portId)).event_counter_control_reg.event_counter_enable       = 7

###############################################################################
##                                                                            #
##      misc support functions                                                #
##                                                                            #
###############################################################################
def getTrackingInfo(moduleName=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    cmdDict = { "set":  [0,0,[]],
                "get":  [0,0,[]],
                "plot": [0,0,[]],
                "show": [0,0,[]],
                "watch":[0,0,[]],
                "find": [0,0,[]],
                "run":  [0,0,[]],
                "misc": [0,0,[]],
                "all":  [0,0,[]],
                "stub": [0,0,[]]}

    if moduleName==None:
        frame       = _sys._getframe(0)
        filePath    = frame.f_code.co_filename
    else:
        moduleName  = moduleName.replace(".py","") if moduleName.find(".py")>0 else moduleName
        moduleList  = list(_sys.modules.keys())
        tmpList     = [a for a in moduleList if moduleName in a]
        for importPath in tmpList:
            if moduleName in importPath.split("."):
                break
        tmpStr      = repr(_sys.modules[importPath])
        filePath    = tmpStr.split()[-1].replace("'","").replace(">","")

    fileName    = filePath.split("\\")[-1].replace(".pyc",".py")
    dirName     = filePath[:filePath.find(fileName)]
    moduleName  = fileName.replace(".py","")

    cmdList = list(cmdDict.keys())

    filePtr = open(dirName + fileName)
    fileTxt = filePtr.read().split("\n")

    lineNum = 0
    for line in fileTxt[0:-1]:
        if "def " in line[0:8]:
            funcName = line[line.find("def ")+4 : line.find("(")]

            if "__" in funcName:
                continue

            for cmd in cmdList:
                if cmd in funcName:
                    if line[:4]=="def ":
                        cmdDict[cmd][0] += 1
                    else:
                        cmdDict[cmd][1] += 1
                        priority = line[1:line.find("def")]
                        cmdDict[cmd][2].append(priority + funcName)
                    break

            if any(a in funcName for a in cmdList)==False:
                if line[:4]=="def ":
                    cmdDict["misc"][0] += 1
                else:
                    cmdDict["misc"][1] += 1
                    priority = line[1:line.find("def")]
                    cmdDict["misc"][2].append(priority + funcName)

            if line[:4]=="def ":
                cmdDict["all"][0] += 1
                cmdDict["all"][2].append(funcName)
            else:
                priority = line[1:line.find("def")]
                if priority!="Z":
                    cmdDict["all"][1] += 1
                cmdDict["all"][2].append(funcName)
            
        lineNum += 1

    return(cmdDict)

def getModuleInfo(moduleName=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    docStringDict = {"$Author":[None,None], "$Revision":[None,None], "$Date":[None,None], "$Log":[None,None]}

    docString = __doc__ if moduleName==None else moduleName.__doc__

    for key in list(docStringDict.keys()):
        docStringDict[key][0] = docString.rfind(key)

        if docStringDict[key][0]!=-1:
            array = docString[docStringDict[key][0]:].split()
            if key=="$Date":
                docStringDict[key][1] = array[1] + " @ " + array[2]
            else:
                docStringDict[key][1] = array[1]

    return(docStringDict)

def getPrbsPattern(type="prbs7", seed=0x1, showProg=None, invert=False, tapList=None, showBinary=False, pattLength=32):
    """
    prbs23  tap=5, seed=0x01        # 8,388,607-bit PRBS pattern
    prbs7   tap=6, seed=0x40        #   127-bit PRBS training sequence

    options:
        length   [1:23]
        tap      [1:23]
        seed     [1:0x7FFFFF]

    returns:
        list     comprised of 32-bit elements representing PRBS pattern
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    prbsDict = { "prbs3": [2],
                 "prbs4": [3],
                 "prbs5": [3],
                 "prbs6": [5],
                 "prbs7": [6],
                 "prbs8": [6,5,4],
                 "prbs9": [5],
                "prbs10": [7],
                "prbs11": [9],
                "prbs12": [6,4,1],
                "prbs13": [4,3,1],
                "prbs14": [5,3,1],
                "prbs15": [14],
                "prbs16": [5,4,3],
                "prbs17": [14],
                "prbs18": [11],
                "prbs19": [6,2,1],
                "prbs20": [17],
                "prbs21": [19],
                "prbs22": [21],
                "prbs23": [18],
                "prbs31": [28]}

    type = type.lower() if type!=None else type

    if type!=None and type in list(prbsDict.keys()):
        tapList = prbsDict[type]
        lfsrLen = int(type.replace("prbs",""))

    showProg = True if (showProg==None and lfsrLen>=20) else showProg

    if tapList==None:
        tapList=[tap]

    mask = 0
    for i in range(lfsrLen):
        mask += 1<<i

    lfsrVal = seed = seed & mask
    prbs = [0]
    prbsLen = 2**lfsrLen - 1

    for i in range(1, prbsLen+1):
        lsb  = bits(lfsrVal,0,1)

        tmpVal = lsb
        for tap in tapList:
            tmpVal  = bits(lfsrVal,tap,1) ^ tmpVal
        msb = tmpVal

        prbs[len(prbs)-1] = bits(prbs[len(prbs)-1], i%pattLength, 1, lsb)
        lfsrVal = (msb<<lfsrLen-1) | (lfsrVal>>1)

        if showProg==True:
            if i==1 or int(100*i//(prbsLen))>int(100*(i-1)//(prbsLen)):
                showProgress(i, prbsLen, type="both")

        if lfsrVal==seed or i%pattLength==pattLength-1:
            if lfsrVal==seed:
                break
            prbs.append(0)

    if invert==False:
        tmpPrbs = deepcopy(prbs)
        tmpPrbs.reverse()
        for a in range(len(tmpPrbs)):
            prbs[a] = flipBits(tmpPrbs[a], pattLength)

    if showBinary==True:
        strtBuff = "    "
        printHeader(strtVal=31, stopVal=0, strtBuff=strtBuff, underLine=True)
        for a in prbs:
            print("%s%s\t[0x%0X]"%(strtBuff, dec2bin(a, pattLength), a))
    else:
        return(prbs)

def flipBits(value, numBits=None):
    """Return reverse bit-order of value

    options:
        value       whole number integer
        numBits     whole number integer

    return:         whole number integer
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if value!=0:
        from math import log

    if value==0:
        revData = 0
    else:
        if value==None:
            value = 2**numBits-1
    
        if numBits==None:
            numBits = int(roundUp(log(value,2)+1, 1))
    
        revData=0
        for i in range(numBits):
            tmp_bit = bits(value, i, 1)
            revData = bits(revData, numBits-1-i, 1, tmp_bit)

    return(revData)

def dec2bin(value, numBits=None, showHdr=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    sign = "-" if value<0 else ""
    binStr = bin(abs(value))[2:]

    if numBits!=None:
        if showHdr==True:
            printHeader(strtVal=numBits-1, stopVal=0, strtBuff=" ")

        if numBits>len(binStr):
            binStr = "0"*(numBits-len(binStr)) + binStr
        elif numBits<len(binStr):
            binStr = binStr[len(binStr)-numBits:]

    return(sign+binStr)

def bin2dec(binStr="1010"):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    binStr = binStr.replace("'","")
    binStr = binStr.replace("b","")
    binStr = binStr.replace("_","")
    return(int(binStr,2))

def str2hex(hexStr="0xabcd"):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    hexlist = {"0":0,"1":1,"2":2,"3":3,"4":4,"5":5,"6":6,"7":7,"8":8,"9":9,"A":10,"B":11,"C":12,"D":13,"E":14,"F":15}

    tmpVal=None
    if isString(hexStr)==True:
        hexStr = hexStr.replace("0x","")
        hexStr = hexStr.replace(" ","")
        hexStr = hexStr.upper()

        tmpVal = 0
        for i in range(len(hexStr)-1,-1,-1):
            if i==0 and hexStr[i]=="-":
                tmpVal *= -1
            else:
                tmpVal=tmpVal+hexlist[hexStr[i]]*(16**(len(hexStr)-i-1))
    elif isNumber(hexStr):
        tmpVal=hexStr

    return(tmpVal)

def erf(value):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from math import exp

    a1 =  0.254829592
    a2 = -0.284496736
    a3 =  1.421413741
    a4 = -1.453152027
    a5 =  1.061405429
    p  =  0.3275911

    sign = _getSign(value)
    value = abs(value)

    t = 1.0/(1.0 + p*value)
    y = 1.0 - ((a1*t) + (a2*t**2) + (a3*t**3) + (a4*t**4) + (a5*t**5)) * exp(-value**2)

    return(sign*value*y)

def erfc(value):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    return(1 - erf(value))

def erfc_inv(value=1e-14):
    """
    inverse complementary error function
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from math import log10
    from math import sqrt
    from math import pi

    slope       =  1.098334677
    intercept   = -0.434818447

    Q = (2 * (1/sqrt(2)) * sqrt((log10(2/(pi*value**2)) - log10(log10(2/(pi*value**2))))))
    return(Q*slope + intercept)

def ber2q(ber=1e-14, transitionDensity=0.5):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    try:
        from scipy import sqrt          
    except ImportError:
        from svtools import ipip; ipip._setup_proxy(); ipip.pip('install scipy'); from scipy import sqrt

    from scipy.special import erfinv

    return(sqrt(2) * erfinv(1-ber/transitionDensity))

def q2ber(q=7.65073, transitionDensity=0.5):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    try:
        from scipy import sqrt          
    except ImportError:
        from svtools import ipip; ipip._setup_proxy(); ipip.pip('install scipy'); from scipy import sqrt

    from scipy.special import erf
    return((1-erf(q/sqrt(2))) * transitionDensity)

def printHeader(strtVal=0, stopVal=None, numSteps=None, stepSize=None, stepList=None, msg="", logfile=None, logSuffix="", strtBuff=None, timeStamp=False, underLine=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from time import ctime

    maxWidth = 128                                                                                              ## max number of display columns

    if stepList==None:
        if strtVal!=None and stopVal!=None:
            if stepSize==None:

                stepSign = _getSign(stopVal-strtVal)
                stepSize = (1 if abs(stopVal-strtVal)<maxWidth else int(roundUp(abs(stopVal-strtVal+stepSign)/float(maxWidth),1))) * stepSign

            numSteps = int(abs((stopVal-strtVal)//stepSize)) + 1

        if numSteps==None:
            numSteps = maxWidth

        if stepSize==None:
            stepSize = (int(numSteps//(maxWidth+1)) + 1)

        if strtVal!=None and stopVal==None:
            stopVal = (strtVal + numSteps*stepSize - stepSize)

        if strtVal==None and stopVal!=None:
            strtVal = (stopVal - numSteps*stepSize + stepSize)

    elif isList(stepList):
        strtVal  = stepList[0]
        stopVal  = stepList[-1]
        numSteps = len(stepList)

    if stepList==None:
        numRows = max(len(str(abs(strtVal))), len(str(abs(stopVal)+1)))
    else:
        numRows = len(str(max(stepList)))

    stepCntRange = list(range(0, numSteps, 1))

    if logfile!=None:
        _log.setFile(logfile, overwrite=False)
        _log.setFileLevel("INFO")
        _log.setFileFormat("simple")

    if timeStamp==True:
        timeStr = ctime(time())
        _log.result("\n%s"%timeStr)

    if strtBuff==None:
        strtBuff = " "*5

    for j in range(numRows, -1, -1):
        tmpStr = strtBuff

        for i in stepCntRange:
            if stepList==None:
                stepVal = strtVal+(i*stepSize)
            else:
                stepVal = stepList[i]

            if j==numRows and (strtVal<0 or stopVal<0):
                if stepVal<0:
                    tmpStr += "-"
                elif stepVal==0:
                    tmpStr += " "
                else:
                    tmpStr += "+"
            elif abs(stepVal)>=10**j:
                tmpStr += str(int(abs(stepVal)//(10**j)%10))
            elif j==0 and stepVal==0:
                tmpStr += "0"
            else:
                tmpStr += " "

        if j==numRows and strtVal>=0 and stopVal>=0:
            pass
        elif j>=1:
            _log.result("%s"%(tmpStr))
        else:
            _log.result("%s\t%s"%(tmpStr,msg))

    if underLine==True:
        _log.result("%s%s"%(strtBuff, "-"*numSteps))

def mean(numList):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if numList==[] or numList==None:
        return(None)
    elif min(numList)==0 and max(numList)==0 and len(numList)>0:
        return(0)
    else:
        return(sum(numList)/float(len(numList)))

def stdev(numList):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if numList==[] or numList==None:
        return(None)

    avgVal = mean(numList)

    tmpVal = 0
    for i in range(len(numList)):
        tmpVal += (numList[i]-avgVal)**2

    if len(numList)==1:
        return(0)
    else:
        return((tmpVal//(len(numList)-1))**(0.5))

def getRandomNumber(mean=None, stdev=None, minVal=None, maxVal=None, returnInt=True, randomize=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from random import normalvariate
    from random import uniform

    if mean!=None and stdev!=None:
        if randomize==True:
            tmpVal = normalvariate(mean, stdev)
            if minVal!=None: tmpVal = max(tmpVal, minVal)
            if maxVal!=None: tmpVal = min(tmpVal, maxVal)
        elif randomize==False:
            tmpVal = mean

    elif minVal!=None and maxVal!=None:
        if randomize==True:
            tmpVal = uniform(minVal, maxVal)    # nosec (not used for security/cryptographic purposes)
        elif randomize==False:
            tmpVal = (maxVal-minVal)//2

    else:
        tmpVal = uniform(0, 1)      # nosec (not used for security/cryptographic purposes)
        if returnInt==True: tmpVal *= 100

    if returnInt==True:
        return(int(round(tmpVal,0)))
    else:
        return(tmpVal)

def getRandomStats(mu, sigma, loopCnt=1000, returnNumList=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from random import normalvariate

    loopCnt = _loopCnt if loopCnt==None else loopCnt
    numList = [normalvariate(mu, sigma) for a in range(loopCnt)]

    avgVal  = mean(numList)
    minVal  = min(numList)
    maxVal  = max(numList)
    stdDev  = stdev(numList)

    if returnNumList==False:
        return([avgVal, minVal, maxVal, stdDev])
    else:
        return(numList)

def roundTo(value, multiple=1):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    tmpMult = round(value / float(multiple))
    return(multiple * tmpMult)

def roundUp(value, multiple=1):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    tmpMult = ceil(value / float(multiple))
    return(multiple * tmpMult)

def isNumber(a):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    return(isinstance(a, (int, float, complex)))

def isList(a):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    return(isinstance(a, (list)))

def isDict(a):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    return(isinstance(a, (dict)))

def isString(a):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    return(isinstance(a, (str)))

def sumList(numList):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    sum = 0
    for a in numList:
        sum += a
    return(sum)

def printc(text=None, fg=None, bg=None, fgIntensity=False, bgIntensity=True, srchStr=None, srchStrList=[]):
    if _printColor==True and _access not in ["tssa"]:
        colorDict = {"black":0,  "red":1, "green":2, "yellow":3, "blue":4, "magenta":5,   "cyan":6, "grey":7}

        fgColor = 0
        bgColor = 0
        if srchStr==None and srchStrList==[]:
            if fg!=None: fgColor = colorDict[fg] + (30 if not fgIntensity else 90)
            if bg!=None: bgColor = colorDict[bg] + (40 if not bgIntensity else 100)

        srchStrList = srchStr.split("*") if srchStr!=None else srchStrList

        if text!=None:
            tmpText = text

            if srchStrList==[] or any(a in tmpText for a in srchStrList)==False:
                print(("\033[1;{};{}m{}{}\033[0m").format(fgColor, bgColor, "\u0008", text), end=' ')
            else:
                srchStrFoundDict = {}

                if len(srchStrList)==1:
                    strt = -1
                    tmpSrchStr = srchStrList[0]
                    while tmpText.find(tmpSrchStr, strt+1)>=0:
                        if tmpText.find(tmpSrchStr, strt+1)>=0:
                            srchStrFoundDict[tmpText.find(tmpSrchStr, strt+1)] = tmpSrchStr
                            strt = tmpText.find(tmpSrchStr, strt+1)
                else:
                    for tmpSrchStr in srchStrList:
                        if tmpText.find(tmpSrchStr)>=0:
                            srchStrFoundDict[tmpText.find(tmpSrchStr)] = tmpSrchStr

                tmpList = list(srchStrFoundDict.keys())
                tmpList.sort()

                srchStrFoundList = []
                for i in tmpList:
                    srchStrFoundList.append(srchStrFoundDict[i])

                for tmpSrchStr in srchStrFoundList:
                    if tmpText=="":
                        break

                    strt = tmpText.find(tmpSrchStr)
                    stop = tmpText.find(tmpSrchStr)+len(tmpSrchStr)
    
                    strA = tmpText[:strt]
                    strB = tmpText[strt:stop]
                    strC = tmpText[-len(tmpText)+stop:] if len(tmpText)!=stop else ""

                    tmpText = strC

                    if strt>0:
                        printc(strA)
    
                    printc(strB,fg,bg,fgIntensity,bgIntensity)

                printc(strC)
    else:
        print("%s"%text, end=' ')

def beep(frequency=800, beepDuration=0.200, beepsPerSecond=20, numBeeps=1):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from winsound import Beep

    for a in range(numBeeps):
        Beep(int(frequency), int(beepDuration*1000))
        sleep(1/float(beepsPerSecond))

def sleep(sleepTime, showProg=False, msg=""):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from time import sleep
    from datetime import timedelta

    if showProg==True:

        stopTime = time() + sleepTime
        while time() < stopTime:
            tmpMsg = " ... " + msg if msg!="" else msg
            showProgress(stepNum=int(time()), type="time", msg=tmpMsg, showSsa=False)
            sleep(0.5)
    else:
        sleep(sleepTime)

def adjustNumList(numList, adjustWrap=True, wrapValue=128):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if adjustWrap==True and len(numList)>1:
        numList.sort()
        l1 = list(range(0, 8))
        l2 = list(range(wrapValue-8, wrapValue))
        if any(a in l1 for a in set(numList))==True and any(a in l2 for a in set(numList))==True:
            for m in range(16, wrapValue, 16):
                l3 = [a for a in numList if a in range(m)]
                l4 = [a for a in numList if a in range(m,wrapValue)]
                if m>max(l3) and m<min(l4) and min(l4)-max(l3)>16:
                    l5 = [a-wrapValue for a in l4]
                    numList = l5 + l3
                    break

    return(numList)

def chkSampleSizeDone(numList, roundTo=10, adjNumList=False, errorBound=1, confLevel=0.99):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if adjNumList==True:
        numList = adjustNumList(numList, adjustWrap=True, wrapValue=128)

    done=False
    a = len(numList)
    if a>=roundTo and a%roundTo==0:
        s = stdev(numList)
        alpha = 1 - confLevel
        z = erfc_inv(alpha/2.0)
        n = int((z * s // errorBound)**2)
        done = True if n<=a else False

    return(done)

###############################################################################
##                                                                            #
##      show & watch functions                                                #
##                                                                            #
###############################################################################
def showProgress(stepNum=None, totalSteps=None, type="time", msg="", showSsa=True):
    """Show progress indicator (bar, percent, or both) on screen

    option(s):
        stepNum       current step number (can be + or -)
        totalSteps    total number of steps
        type
          "bar"       shows 80-char progress bar
          "num"       shows number as sent to function
          "both"      shows number & progress bar
          "time"      shows time (w/ pinwheel)
          "pinwheel"  shows revolving pinwheel
          None        clears line
        msg           string message to post-pend to end of line

    example:          for i in range(10):
                         showProgress(i,9,"both")
                         sleep(1)

    returns:          None
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from time import ctime
    from datetime import timedelta

    if _ssa==True and showSsa==True and type!=None:
        from ssa.util import ssa_log, LogLevel, LogType

    chrList = ["|","/","-","\\"]

    if totalSteps!=None:
        if stepNum>totalSteps:
            stepNum=totalSteps

        progNum = int(round((stepNum*100)//totalSteps))

    if type==None and _access not in ["svos", "tssa"]:
        printStr = "\r%s\r"%(120*" ")
    elif type=="both":
        progNum = int(round(progNum // 2))
        progbar = "%s%s%s"%(((58+len(msg)) * "\u0008"),(progNum * "\u00B2"),((50-progNum) * "\u00B1"))
        printStr = "\r%s %3d%% %s"%(progbar.encode("latin-1"),progNum*2,msg)
    elif type=="bar":
        progNum = int(round(progNum // 2))
        progbar = "%s%s%s"%(((52+len(msg)) * "\u0008"),(progNum * "\u00B2"),((50-progNum) * "\u00B1"))
        printStr = "\r%s %s"%(progbar.encode("latin-1"),msg)
    elif type=="num":
        printStr = "\r%3d%% %s\r"%(progNum, msg)
    elif type==None:
        printStr = "\r%s\r"%(80*" ")
    elif type=="time":
        if _startTime==None:
            tmpStr = ctime(time())
            timeStr = tmpStr.split(" ")[3]
        else:
            timeStr = str(timedelta(0, int(time() - _startTime)))

        if stepNum==None:
            printStr = "\r %s  %s %s"%(" ",timeStr,msg)
        else:
            printStr = "\r %s  %s %s"%(chrList[stepNum%4],timeStr,msg)

    elif type=="pinwheel":
        printStr = "\r %s   %s"%(chrList[stepNum%4], msg)

    if _ssa!=True:
        print(printStr, end='')
    elif _ssa==True and showSsa==True and type!=None:
        ssa_log(printStr, "Public", LogLevel.Normal, LogType.Information)

    if _debug: print()

def showStatus(tile=None, portId=None, lane=None, laneMask=None, mode=None, rxTx=None, logResults=False, logSuffix="", shortForm=False):

    boolDict = {1:True, 0:False, None:""}

    if portId!=None: portId = portId.lower()

    if mode!=None:
        mode = mode.lower()

    if rxTx!=None:
        rxTx = rxTx.lower()

    if logSuffix!="":
        logResults=True

    logfile=None
    if logResults==True or logSuffix!="":
        logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix
        if tile!=None:
            logfile = "%s_%s_%s_%s-%s%s.log"%(strftime("%y%m%d_%H%M%S"), _sys._getframe(0).f_code.co_name, tile._tileName, portId, tile._partId, logSuffix)
        else:
            logfile = "%s_%s_%s.log"%(strftime("%y%m%d_%H%M%S"), _sys._getframe(0).f_code.co_name,logSuffix)
        _log.setFile(logfile)
        _log.setFileLevel("RESULT")
        _log.setFileFormat("simple")
        _log.result("%s"%strftime("%m/%d/%y %H:%M:%S"))

    if portId!=None:
        setTileConfigDictGlobal()

    try:
        if portId==None or shortForm==True:
            tileList = _getTileList(tile)

            for tmpTile in tileList:
                if portId==None or shortForm!=True:
                    print()

                portIdList = getPortIdList(tmpTile, portId=portId, mode=mode)

                for tmpPortId in portIdList:

                    if tmpPortId not in list(_tileConfigDict[tmpTile._fpgaNum][tmpTile._tileNum].keys()):
                        continue

                    if tmpTile._tileNum==0 and _getPortNum(tmpPortId)==0 and portId==None:
                        print("fpga%d %s"%(tmpTile._fpgaNum, "-"*119))

                    tileStr     = "%s-%-3s"%(tmpTile._tileName, tmpPortId)
                    stepStr     = "(%s)"%tmpTile._stepping
                    linkSpeed   = getUpiLinkSpeed(tmpTile, tmpPortId, verbose=True)
                    txStat      = getTxLaneStatus(tmpTile, tmpPortId, returnStr=True)
                    rxStat      = getRxLaneStatus(tmpTile, tmpPortId, returnStr=True)
                    portType    = "" if _getMode(tmpPortId)=="u" else getPciePortType(tmpTile, tmpPortId, returnStr=True)
                    laneRev     = getLaneReversal(tmpTile, tmpPortId)
                    laneRevStr  = " LaneRev: %s"%laneRev if laneRev in [True, False] else ""
                    stateVal    = getLtssmState(tmpTile, tmpPortId) # nosec (evaluation of internally defined, semi-static string)
                    stateStr    = _ltssmDict[_getMode(tmpPortId)][stateVal][0]
                    stateClr    = _ltssmDict[_getMode(tmpPortId)][stateVal][1]
                    tmpBaud     = getBaudRate(tmpTile, tmpPortId)
                    spaceStr    = (26-len(stateStr)) * " "

                    if logfile!=None or _printColor==False:
                        _log.result("%s %s %6.2f - Tx: %2d (%s)%s  %4s  %20s %20s %s%s"%(tileStr, stepStr, tmpBaud, stateVal, stateStr, spaceStr, linkSpeed if _getMode(tmpPortId)=="u" else portType, txStat, rxStat, portType, laneRevStr))

                    elif ((_getMode(tmpPortId)=="p" and stateVal in [0,30]) or (_getMode(tmpPortId)=="u" and stateVal in [0,1,2])):
                        printc("%s %s %6.2f - Tx: %2d (%s)%s  %4s   %20s %20s %s%s\n"%(tileStr, stepStr, tmpBaud, stateVal, stateStr, spaceStr, linkSpeed if _getMode(tmpPortId)=="u" else portType, txStat, rxStat, portType, laneRevStr), "black", "black", True, False)

                    else:
                        print("%s"%(tileStr), end=' ')
                        print("%s"%(stepStr), end=' ')

                        if (_getMode(tmpPortId)=="p" and tmpBaud!=16.0) or (_getMode(tmpPortId)=="u" and tmpBaud!=10.4):
                            print(" \b", end=' ')
                            printc("%6.2f"%tmpBaud,"grey","yellow",True,False)
                        else:
                            print("%6.2f"%tmpBaud, end=' ')

                        print("- Tx: %2d "%(stateVal), end=' ')

                        errCnt = getErrCnt(tmpTile,tmpPortId)
                        if (isNumber(errCnt) and errCnt>0) or (isDict(errCnt) and sum(errCnt.values())>0):
                            printc("(%s)"%stateStr,"grey","red",True,False)
                        else:
                            (fg,bg,fgI,bgI) = _ltssmDict[_getMode(tmpPortId)][stateVal][1]
                            printc("(%s)"%stateStr,fg,bg,fgI,bgI)

                        printc("%s %4s   "%(spaceStr,linkSpeed if _getMode(tmpPortId)=="u" else portType),"grey","yellow",True,False,srchStr="slow")
                        printc("%20s %20s %s"%(txStat,rxStat,laneRevStr),"grey","red",True,False,srchStr="0")
                        print()

        elif tile!=None:
            if portId.lower() not in list(_tileConfigDict[tile._fpgaNum][tile._tileNum].keys()):
                return

            _log.result("partId:    \t\'%s\'"%tile._partId)
            _log.result("baudRate:  \t%s Gb/s"%getBaudRate(tile, portId))

            if _getMode(portId)=="u":
                linkSpeed = getUpiLinkSpeed(tile, portId, verbose=True)
                if logfile!=None or linkSpeed=="fast" or _printColor==False:
                    _log.result("LinkSpeed:    \t%s"%linkSpeed)
                else:
                    print("LinkSpeed:    \t", end=' ')
                    printc(" %s\n"%linkSpeed,"grey","yellow",True,False,srchStr="slow")

                stateVal = getLtssmState(tile, portId)
                stateStr = _ltssmDict[_getMode(portId)][stateVal][0]
                _log.result("LTSSM state:  \t%s"%stateStr)

            if rxTx=="tx" or rxTx==None:
                _log.result("\nTx: %s"%("-"*34))
                _log.result("\t%s Tx Values %s"%("-"*(5*len(_txList)-5), "-"*(5*len(_txList)-6)))
                showTxStats(tile, portId, lane, laneMask, logfile=logfile)

            if rxTx=="rx" or rxTx==None:
                _log.result("\nRx: %s"%("-"*122))

                _log.result("\t%s Rx Cal Values %s"%("-"*(4*len(_rxCalList)-9), "-"*(4*len(_rxCalList)-8)))
                showRxCalStats(tile, portId, lane, laneMask, logResults=logResults, logfile=logfile, logSuffix=logSuffix, showProg=True)

                _log.result("\n\t%s Rx Loop Values %s"%("-"*(4*len(_rxLoopList)-9), "-"*(4*len(_rxLoopList)-9)))
                showRxLoopStats(tile, portId, lane, laneMask, logResults=logResults, logfile=logfile, logSuffix=logSuffix, showProg=True)

            lanesPerPort = len(getLaneList(tile, portId))
            printHeader(strtVal=lanesPerPort-1, numSteps=lanesPerPort, stepSize=-1, logfile=logfile, strtBuff=" "*17)

            txStat = getTxLaneStatus(tile, portId, returnStr=True)
            rxStat = getRxLaneStatus(tile, portId, returnStr=True)

            if rxTx=="tx" or rxTx==None:
                if logfile!=None or _printColor==False:
                    _log.result("Tx Lane Status:  %s"%txStat)
                else:
                    print("Tx Lane Status:  ", end=' ')
                    printc("%s\n"%txStat,"grey","red",True,False,srchStr="0")

            if rxTx=="rx" or rxTx==None:
                if logfile!=None or _printColor==False:
                    _log.result("Rx Lane Status:  %s\tLaneReversal=%s"%(rxStat,boolDict[getLaneReversal(tile,portId)]))
                else:
                    print("\bRx Lane Status:  ", end=' ')
                    printc(rxStat,"grey","red",True,False,srchStr="0")
                    print("\tLaneReversal=%s"%(boolDict[getLaneReversal(tile,portId)]))

                if _getMode(portId)=="u":
                    showPolarityInversion(tile, portId, logfile=logfile)

    except KeyboardInterrupt:
        print()

    if shortForm!=True:
        print()

    _log.setFile(None)

def getTxEqOptions(strtCursor=None, stopCursor=None, stepCursor=None, cursorList=None, fs=_fs, txSwing=1.0, filterType="hpf"):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    filterType = filterType.lower()
    filterDict = {"hpf":-1, "lpf":1}

    fs = (_fs if fs==None else fs)
    if cursorList==None:
        if strtCursor==None and stopCursor==None:
            strtCursor = int(fs*txSwing)
            stopCursor = int(0.60*fs)
        elif strtCursor!=None and stopCursor==None:
            stopCursor = strtCursor

        stepCursor = stepCursor if stepCursor!=None else _getSign(strtCursor-stopCursor)
        cursorList = [a for a in range(strtCursor, stopCursor-stepCursor, -stepCursor)]

    txEqDict = {}
    for c0 in cursorList:
        txEqDict[c0] = {}

        if c0>fs*txSwing:
            printc("\nWARNING: cursor value (%2d) is larger than fs (%2d).\n"%(c0,fs*txSwing),"grey","yellow",True,False,srchStr="WARNING")

        numSteps = int(round(fs*txSwing,0) - c0 + 1)

        for i in range(numSteps):
            cm1 = filterDict[filterType] * i
            cp1 = filterDict[filterType] * int(round(fs*txSwing,0)-abs(cm1)-abs(c0))

            if cm1+c0+cp1==0:
                continue

            txEqDict[c0][abs(cm1)] = [cm1, c0, cp1]

    return(txEqDict)

def getTxEqBoostLevels(cm1, c0, cp1):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from math import log10

    pre   = 20*log10(abs(float(-abs(cm1)+abs(c0)+abs(cp1)) / float(abs(cm1)+abs(c0)+abs(cp1))))
    boost = 20*log10(abs(float(-abs(cm1)+abs(c0)-abs(cp1)) / float(abs(cm1)+abs(c0)+abs(cp1))))
    pst   = 20*log10(abs(float( abs(cm1)+abs(c0)-abs(cp1)) / float(abs(cm1)+abs(c0)+abs(cp1))))

    return(pre, boost, pst)

def showRxLoopStats(tile, portId, lane=None, laneMask=None, loop=None, loopCnt=None, logResults=False, logfile=None, overWrite=False, logSuffix="", logJmpFormat=False, hdrSuffix="", dataSuffix="", logHdr=True, showProg=False, returnMean=True, startTime=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if logResults==True and logfile==None:
        logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix
        logfile = "%s_%s_%s_%s-%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), _sys._getframe(0).f_code.co_name,tile._tileName, portId, tile._partId, logSuffix)

    showRxStats(tile, portId, lane, laneMask, loopCnt, logResults=logResults, logfile=logfile, cal=None, getCal=False, loop=loop, getLoop=True, overWrite=overWrite, logSuffix=logSuffix, logJmpFormat=logJmpFormat, hdrSuffix=hdrSuffix, dataSuffix=dataSuffix, logHdr=logHdr, showProg=showProg, returnMean=returnMean, startTime=startTime)

def showRxCalStats(tile, portId, lane=None, laneMask=None, cal=None, loopCnt=1, logResults=False, logfile=None, overWrite=False, logSuffix="", logJmpFormat=False, dataSuffix="", hdrSuffix="", logHdr=True, showProg=False, returnMean=True, startTime=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if logResults==True and logfile==None:
        logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix
        logfile = "%s_%s_%s_%s-%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), _sys._getframe(0).f_code.co_name, tile._tileName, portId, tile._partId, logSuffix)

    showRxStats(tile, portId, lane, laneMask, loopCnt=loopCnt, logResults=logResults, logfile=logfile, cal=cal, getCal=True, loop=None, getLoop=False, overWrite=overWrite, logSuffix=logSuffix, logJmpFormat=logJmpFormat, hdrSuffix=hdrSuffix, dataSuffix=dataSuffix, logHdr=logHdr, showProg=showProg, returnMean=returnMean, startTime=startTime)

def showRxStats(tile, portId, lane=None, laneMask=None, loopCnt=None, logResults=False, logfile=None, cal=None, getCal=True, loop=None, getLoop=True, overWrite=False, logSuffix="", logJmpFormat=False, hdrSuffix="", dataSuffix="", logHdr=True, showProg=False, returnMean=True, startTime=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    global _startTime

    _startTime = startTime

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")
    loopCnt  = _loopCnt if loopCnt==None else loopCnt
    loop     = loop.lower() if loop!=None else loop

    clrDict  = {0:[None,None,None,None], 1:["yellow","blue",True,False], 2:["grey","magenta",True,False]}

    closeLog = True if logfile==None else False

    if (logfile!=None or logJmpFormat==True) and logResults==False:
        logResults=True

    if logResults==True:
        if logfile==None:
            logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix
            logfile = "%s_%s_%s_%s-%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), _sys._getframe(0).f_code.co_name, tile._tileName, portId, tile._partId, logSuffix)

        if _cds==True: _log.cdsInit(activity="WhrPhyStats", delimiter="\t", commitWhenFileSetNone=_cdsNoFileSet, logToFile=True)

        _log.setFile(logfile, overwrite=overWrite)
        _log.setFileLevel("INFO")
        _log.setFileFormat("simple")

    rxDict = getRxStats(tile, portId, lane, laneMask, returnStr=False, delimiter="\t", returnHdr=False, loopCnt=loopCnt, cal=cal, getCal=getCal, loop=loop, getLoop=getLoop, returnDict=True, showProg=showProg, returnMean=returnMean)

    if rxDict==None:
        if logResults==True:
            _log.setFile(None)
        return

    if loopCnt not in [0,1]:
        tmpDict = {}
        for i in laneList:
            for key in list(rxDict[i].keys()):
                if i not in tmpDict:
                    tmpDict[i] = {}

                if isList(rxDict[i][key]):
                    tmpDict[i][key + "_mean"]   = rxDict[i][key][0]
                    tmpDict[i][key + "_min"]    = rxDict[i][key][1]
                    tmpDict[i][key + "_max"]    = rxDict[i][key][2]
                    tmpDict[i][key + "_stdev"]  = rxDict[i][key][3]
                    tmpDict[i][key + "_cnt"]    = rxDict[i][key][4]
                else:
                    tmpDict[i][key] = rxDict[i][key]

        rxDict = tmpDict

    rxList = list(rxDict[laneList[0]].keys())
    rxList.sort()

    if logJmpFormat==True:
        baudRate = getBaudRate(tile, portId)

    if logHdr==True:
        if logJmpFormat==True:
            hdrStr="tile\tportId\tlane\tpartId\tbaudRate"
        else:
            hdrStr="%6s"%"lane"

        for param in rxList:
            hdrStr += "\t%6s"%param

        _log.result("%s\t%s"%(hdrStr, hdrSuffix))

    for i in laneList:
        tmpStr = "%6d"%i if logJmpFormat==False else "%s\t%s\t%2d\t%s\t%3.1f"%(tile._tileName, portId, i, tile._partId, baudRate)

        (fg,bg,fgI,bgI) = ("grey","red",True,False) if getRxAdaptDone(tile, portId, lane=i)==0 else (None,None,None,None)

        if logResults==False:
            printc("%s"%tmpStr,fg,bg,fgI,bgI,srchStr="%d"%i)

        for param in rxList:
            if logResults==True or _printColor==False:
                tmpStr += "\t%6.2f"%(rxDict[i][param]) if "_mean" in param or "_stdev" in param else "\t%6d"%(rxDict[i][param])
            else:
                (fg,bg,fgI,bgI) = (None,None,None,None)

                if param in list(_rxCalDict.keys()):
                    minVal = _rxCalDict[param][0]
                    maxVal = _rxCalDict[param][1]
                elif param in list(_rxLoopDict.keys()):
                    minVal = _rxLoopDict[param][0][0]
                    maxVal = _rxLoopDict[param][0][1]

                vRange = abs(maxVal-minVal)/10.0
                midVal = abs(maxVal-minVal)/2.0
                lBound = midVal - vRange
                uBound = midVal + vRange

                if param in list(_rxLoopDict.keys()) and getRxLoopOverride(tile, portId, i, loop=param)==1:
                    (fg,bg,fgI,bgI) = ("grey","yellow",True,False)
                elif rxDict[i][param]==minVal or rxDict[i][param]==maxVal:
                    (fg,bg,fgI,bgI) = ("grey","magenta",True,False)
                print("\t \b", end=' ')
                printc("%6d"%rxDict[i][param],fg,bg,fgI,bgI)

        if logResults==True:
            _log.result("%s\t%s"%(tmpStr, dataSuffix))
        else:
            print()

    if logResults==True and closeLog==True:
        _log.setFile(None)

def showTxStats(tile, portId, lane=None, laneMask=None, logResults=False, logfile=None, logSuffix=""):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    closeLog = True if logfile==None else False

    if logResults==True or logfile!=None or logSuffix!="":
        if logfile==None:
            logSuffix = "_" + logSuffix if (logSuffix!="" and logSuffix[0]!="_") else logSuffix
            logfile = "%s_%s_%s_%s-%s%s.tsv"%(strftime("%y%m%d_%H%M%S"), _sys._getframe(0).f_code.co_name, tile._tileName, portId, tile._partId, logSuffix)
        _log.setFile(logfile)
        _log.setFileLevel("INFO")
        _log.setFileFormat("simple")

    hdrStr = getTxStats(tile, portId, lane=laneList[0], returnStr=True, delimiter="\t", returnHdr=True)
    tmpDict = getTxStats(tile, portId, lane, returnStr=False, delimiter="\t", returnHdr=False)

    txDict = {}
    if lane!=None:
        txDict[lane] = tmpDict
    else:
        txDict = tmpDict

    txList = list(txDict[laneList[0]].keys())
    txList.sort()

    _log.result("%6s\t%6s"%("lane", hdrStr.lower()))
    for i in laneList:
        tmpStr = "\r%6d"%i
        for a in txList:
            if txDict[i][a]!=None:
                if a=="[cm1,c0,cp1]":
                    tmpStr += "\t[%2d, %2d, %2d]"%(txDict[i][a][0],txDict[i][a][1],txDict[i][a][2])
                else:
                    tmpStr += "\t%6d"%(txDict[i][a])
            else:
                tmpStr += "\t%s"%(txDict[i][a])

        if logfile!=None or getTxLaneStatus(tile, portId, i)==1:
            _log.result("%s"%tmpStr)
        else:
            printc("%s\n"%tmpStr,"yellow","black",False,False)

    if logfile!=None:
        _log.result("")

def showPolarityInversion(tile, portId, logfile=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if getPolarityInversion(tile, portId)==None:
        return

    if logfile!=None:
        _log.setFile(logfile)
        _log.setFileLevel("INFO")
        _log.setFileFormat("simple")

    lanesPerPort = len(getLaneList(tile, portId))
    tmpStr  = getPolarityInversion(tile, portId, lane=None, returnStr=True)
    rdsStr  = getRxLaneStatus(tile, portId, returnStr=True)

    for i in range(len(rdsStr)):
        if rdsStr[i]=="0":
            tmpStr = tmpStr[:i] + "." + tmpStr[i+1:]

    if logfile!=None or _printColor==False:
        _log.result("  Polarity Inv:  %s"%(tmpStr))
    else:
        print("  Polarity Inv:  ", end=' ')
        printc("%s\n"%tmpStr,"grey","blue",True,False,srchStr="-")

def showWaveform(value=None, pattLength=32, showProg=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    outDict = {0:[], 1:[]}
    chrDict = {0:{"11":196, "00": 32, "10":191, "01":218},
               1:{"11": 32, "00":196, "10":192, "01":217}}

    binStr=None
    if value==None:
        pattList = getPrbsPattern(type="prbs7", pattLength=pattLength, showProg=showProg)
        binStr = dec2bin(pattList[0],pattLength) + \
                 dec2bin(pattList[1],pattLength) + \
                 dec2bin(pattList[2],pattLength) + \
                 dec2bin(pattList[3],pattLength)

    if binStr==None:
        if isNumber(value):
            binStr = dec2bin(value, pattLength)
        elif isString(value):
            binStr = value

    prevBit = "0"
    for bit in binStr:
        for lineNum in [0,1]:
            outDict[lineNum].append(chrDict[lineNum][prevBit+bit])
        prevBit = bit

    for lineNum in [0,1]:
        for a in range(len(outDict[lineNum])):
            chrStr = "%s"%chr(outDict[lineNum][a])
            print("\b%s"%(chrStr.encode("latin-1")), end=' ')
        print()

    print("%s - 0x%x"%(binStr, bin2dec(binStr)))

###############################################################################
##                                                                            #
##      algorithmic functions                                                 #
##                                                                            #
###############################################################################
def pollBit(tile, portId, lane=None, laneMask=None, bitName="rx_ack", value=1, pollTime=0.050, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if bitName not in list(_pollDict.keys()):
        printc("\nWARNING: \'%s\' not foundin _pollDict\n"%(bitName),"grey","yellow",True,False,srchStr="WARNING")
        return

    origLane     = lane
    origLaneMask = laneMask

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    if not(_access=="stub" and _subAccess=="offline"):
        data={}
        for lane in laneList:
            func = "%s(tile, portId, lane=%d)"%(_pollDict[bitName], lane)

            timeout = time() + pollTime
            while eval(func)==value^1 and time()<timeout:   # nosec (evaluation of internally defined, semi-static string)
                sleep(0.010)
    
            data[lane] = eval(func)     # nosec (evaluation of internally defined, semi-static string)

            if  data[lane]==value^1:
                printc("WARNING: '%s' failed: lane%2d %8s=%d not received'\n"%(_sys._getframe(0).f_code.co_name,lane,bitName,value),"grey","yellow",True,False,srchStr="WARNING")

        if len(laneList)==1 and returnDict==False:
            return(not(data[lane]^value))
        else:
            return(data)

def getRxAdaptFom(tile, portId, lane=None, laneMask=None, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_pcs_xf_rx_adapt_fom.rx_adapt_fom)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)


def getRxAdaptBaseFom(tile, portId, lane=None, laneMask=None, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.rawlane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_rx_ctl_rx_adapt_startup_fom.rx_adapt_startup_fom)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)


def getRxVdacDrangeSel(tile, portId, lane=None, laneMask=None, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_vdac_range_sel.rx_ana_cal_vdac_derange_sel)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

def getRxVdacPrangeSel(tile, portId, lane=None, laneMask=None, showProg=False, returnDict=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, lane, laneMask, type="byPort")

    data={}
    for i in laneList:
        data[i] = int(tile.getbypath("phy_quad%d.syn_phy.lane%d"%(_getQuadNum(tile,portId,i),_getQuadLane(tile,portId,i))).dig_ana_rx_vdac_range_sel.rx_ana_cal_vdac_prange_sel)

    if len(laneList)==1 and returnDict==False:
        return(data[i])
    else:
        return(data)

###############################################################################
##                                                                            #
##      Quartus SOF programming                                               #
##                                                                            #
###############################################################################
def openFile(fileOpen=1, defExt=".txt", fileName="*.txt", flags=0, filter="Text Files (*.txt)|*.txt|All Files (*.*)|*.*|"):
    """
    fileOpen : int A flag indicating if the Dialog is a FileOpen or FileSave dialog.
    defExt=None : string The default file extension for saved files. If None, no extension is supplied.
    fileName=None : string The initial filename that appears in the filename edit box. If None, no filename initially appears.
    flags=win32con.OFN_HIDEREADONLY|win32con.OFN_OVERWRITEPROMPT : int The flags for the dialog. See the API documentation for full details.
    filter=None : string A series of string pairs that specify filters you can apply to the file. If you specify file filters, only selected files will appear in the Files list box. The first string in the string pair describes the filter; the second string indicates the file extension to use. Multiple extensions may be specified using ';' as the delimiter. The string ends with two '|' characters. May be None.
    parent=None : PyCWnd The parent or owner window of the dialog.
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    import win32ui

    path = win32ui.CreateFileDialog(fileOpen, defExt, fileName, flags, filter)
    path.DoModal()

    return(path.GetPathName())

###############################################################################
##                                                                            #
##      stub mode functions                                                   #
##                                                                            #
###############################################################################
def stubInit(tile=None, mode=None, topo=None, baudRate=None, root=True):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from random import randint
    from random import choice

    global _stubDict

    tileList = _getTileList(tile)

    for tmpTile in tileList:
        if _randomizePorts==True:
            cfgTopoKey = randint(0,len(list(_cfgTopoDict.keys()))-1)        # nosec (not used for security/cryptographic purposes)
            while (_cfgTopoDict[cfgTopoKey]["mode"]==None):
                cfgTopoKey = randint(0,len(list(_cfgTopoDict.keys()))-1)    # nosec (not used for security/cryptographic purposes)

            tmpMode = _cfgTopoDict[cfgTopoKey]["mode"]
            tmpTopo = _cfgTopoDict[cfgTopoKey]["topo"]
            
            cfgFuncKey = randint(0,len(list(_cfgFuncDict.keys()))-1)        # nosec (not used for security/cryptographic purposes)
            while (_cfgFuncDict[cfgFuncKey]["mode"]==None or _cfgFuncDict[cfgFuncKey]["mode"]!=tmpMode):
                cfgFuncKey = randint(0,len(list(_cfgFuncDict.keys()))-1)    # nosec (not used for security/cryptographic purposes)

            tmpBaudRate = _cfgFuncDict[cfgFuncKey]["baudRate"]
        
        elif tile!=None and mode!=None and topo!=None and baudRate!=None and root!=None:
            tmpMode = mode
            tmpTopo = topo
            tmpBaudRate = baudRate
        else:
            if tmpTile==tileList[0]:
                (cfgTopoKey, cfgFuncKey) = (0, 4 if _randomizeStub==False else choice([1,2,3,4]))   # nosec (not used for security/cryptographic purposes)
            elif tmpTile==tileList[1]:
                (cfgTopoKey, cfgFuncKey) = (1, 3 if _randomizeStub==False else choice([1,2,3,4]))   # nosec (not used for security/cryptographic purposes)
            elif tmpTile==tileList[2]:
                (cfgTopoKey, cfgFuncKey) = (3, 6 if _randomizeStub==False else choice([5,6,7]))     # nosec (not used for security/cryptographic purposes)
            else:
                (cfgTopoKey, cfgFuncKey) = (2, 2 if _randomizeStub==False else choice([1,2,3,4]))   # nosec (not used for security/cryptographic purposes)
            
            tmpMode = _cfgTopoDict[cfgTopoKey]["mode"]
            tmpTopo = _cfgTopoDict[cfgTopoKey]["topo"]
            tmpBaudRate = _cfgFuncDict[cfgFuncKey]["baudRate"]

        setTileConfig(tmpTile, mode=tmpMode, topo=tmpTopo, baudRate=tmpBaudRate)
        setTileTopo(tmpTile, topo=tmpTopo)

    if tile==None:
        _stubDict = {}

    for tmpTile in tileList:
        fpgaNum = tmpTile._fpgaNum
        tileNum = tmpTile._tileNum

        if fpgaNum not in _stubDict:
            _stubDict[fpgaNum] = {}

        if tileNum not in _stubDict[fpgaNum]:
            _stubDict[fpgaNum][tileNum] = {}

        portIdList = getPortIdList(tmpTile)
        for tmpPortId in portIdList:
            laneList = getLaneList(tmpTile, tmpPortId, type="byPort")

            if _getMode(tmpPortId)=="p":
                tmpTopo = getTileTopo(tmpTile)

                if _randomizePorts==True and tmpTopo=="x16":
                    tmpRoot = choice([True, False])     # nosec (not used for security/cryptographic purposes)
                elif tile!=None and mode!=None and topo!=None and baudRate!=None and root!=None:
                    tmpRoot = root
                else:
                    if tmpTopo in ["x4","x16"]:
                        tmpRoot = True
                    elif tmpTopo=="x8":
                        tmpRoot = False
    
                setPciePortType(tmpTile, tmpPortId, root=tmpRoot)

            (tmpMode, tmpTopo, tmpBaudRate) = getTileConfig(tmpTile)

            if _quiet!=True:
                print("\rInitializing \'whrPhy\' stub mode for whr_%d-%s (%4.1f) ..."%(tileNum, tmpPortId, tmpBaudRate), end=' ')

            if tmpPortId not in _stubDict[fpgaNum][tileNum]:
                _stubDict[fpgaNum][tileNum][tmpPortId] = {}

                tmpDict = {}
                for cal in _rxCalList:
                    tmpDict[cal] = [None,None]

                for loop in _rxLoopList:
                    tmpDict[loop] = [None,None]

                for param in _txList:
                    tmpDict[param] = [None,None]

                for i in laneList:
                    _stubDict[fpgaNum][tileNum][tmpPortId][i] = deepcopy(tmpDict)
                    _stubDict[fpgaNum][tileNum][tmpPortId][i]["txPstate"] = [0, randint(0,3)]   # nosec (not used for security/cryptographic purposes)
                    _stubDict[fpgaNum][tileNum][tmpPortId][i]["rxPstate"] = [0, randint(0,3)]   # nosec (not used for security/cryptographic purposes)

            if _getMode(tmpPortId)=="u":
                linkSpeed  = 1 if _randomizeStub==False else choice([0,1])  # nosec (not used for security/cryptographic purposes)
                setUpiLinkSpeed(tmpTile, tmpPortId, value=linkSpeed)
                if _stubStateType!=None:
                    ltssmState = 15 if _stubStateType=="l0" else 17
                else:
                    ltssmState = 15 if _randomizeStub==False else choice([14,15,17,31]) # nosec (not used for security/cryptographic purposes)
            else:
                linkSpeed  = None
                if _stubStateType!=None:
                    ltssmState = 17 if _stubStateType=="l0" else 27
                else:
                    ltssmState = 17 if _randomizeStub==False else choice([17,27])       # nosec (not used for security/cryptographic purposes)

            _stubDict[fpgaNum][tileNum][tmpPortId]["ltssmState"] = ltssmState
            _stubDict[fpgaNum][tileNum][tmpPortId]["linkSpeed"]  = linkSpeed

            stubInitAfeValues(tmpTile, tmpPortId)
            stubInitEyeParams(tmpTile, tmpPortId)
            setPhyRecipe(tmpTile, tmpPortId)

    print()

def stubInitAfeValues(tile, portId):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    from math import log10
    from random import uniform

    global _stubDict

    laneList = getLaneList(tile, portId, type="byPort")

    fpgaNum = tile._fpgaNum
    tileNum = tile._tileNum

    if portId!=None:
        portId = portId.lower()

    for i in laneList:
        for cal in _rxCalList:
            minVal      = _rxCalDict[cal][0]
            maxVal      = _rxCalDict[cal][1]
            valRange    = abs(maxVal-minVal)
            stdDev      = valRange/log10(valRange)/20.0
            if cal in _vocList:
                strtVal = getRandomNumber(minVal=0.40*maxVal, maxVal=0.60*maxVal, randomize=_randomizeStub)     ## randomly place starting location
            else:
                strtVal = int(valRange/2.0)                                                                     ## midpoint value

            _stubDict[fpgaNum][tileNum][portId][i][cal][1] = "getRandomNumber(%3d, %2.1f, %3d, %3d, randomize=%s)"%(strtVal, stdDev, minVal, maxVal, _randomizeStub)

        for loop in _rxLoopList:                                                                                ## initialize loop values
            minVal      = _rxLoopDict[loop][0][0]
            maxVal      = _rxLoopDict[loop][0][1]
            valRange    = abs(maxVal-minVal)
            stdDev      = valRange/log10(valRange)/20.0
            if loop=="vco":
                strtVal = int(((i+4)/float(len(laneList)+5)) * valRange)
            elif loop[:3]=="dfe":
                tapNum  = int(loop[3:])
                strtVal = (tapNum+1) * valRange//7                                                              ## arbitrarily spread by tapNum
            else:
                strtVal = int(valRange/2.0)                                                                     ## midpoint value

            _stubDict[fpgaNum][tileNum][portId][i][loop][1] = "getRandomNumber(%3d, %2.1f, %3d, %3d, randomize=%s)"%(strtVal, stdDev, minVal, maxVal, _randomizeStub)

        for param in _txList:                                                                                   ## initialize tx params
            if param not in "[cm1,c0,cp1]":
                minVal      = _txDict[param][0]
                maxVal      = _txDict[param][1]
                valRange    = abs(maxVal-minVal)
                stdDev      = 0.10 * valRange
                strtVal     = int(valRange/2.0)                                                                 ## midpoint value

                _stubDict[fpgaNum][tileNum][portId][i][param][1] = "getRandomNumber(%3d, %2.1f, %3d, %3d, randomize=%s)"%(strtVal, stdDev, minVal, maxVal, _randomizeStub)

    for i in laneList:                                                                                          ## initialize w/ normalvariate random data
        for key in list(_stubDict[fpgaNum][tileNum][portId][i].keys()):
            if key not in "[[cm1,c0,cp1],txPstate,rxPstate]":
                _stubDict[fpgaNum][tileNum][portId][i][key][0] = eval("%s"%_stubDict[fpgaNum][tileNum][portId][i][key][1])  # nosec (evaluation of internally defined, semi-static string)

    for i in laneList:
        for cal in _rxCalList:                                                                                  ## initialize values in _rxCalList
            setRxCal(tile, portId, i, cal=cal, value=_stubDict[fpgaNum][tileNum][portId][i][cal][0])

        for loop in _rxLoopList:                                                                                ## initialize values in _rxLoopList
            setRxLoop(tile, portId, i, loop=loop, value=_stubDict[fpgaNum][tileNum][portId][i][loop][0])

        for param in _txList:                                                                                   ## initialize values in _txList
            if param=="[cm1,c0,cp1]":
                boost   = 3.5 if _randomizeStub==False else uniform(3.5, 6.0)       # nosec (not used for security/cryptographic purposes)
                pre2pst = 0.5 if _randomizeStub==False else uniform(0.2, 0.5)       # nosec (not used for security/cryptographic purposes)
                swing   = 1.0 if _randomizeStub==False else randint(7, 10)/10.0     # nosec (not used for security/cryptographic purposes)
    
                txEqList = setTxEqBoost(tile, portId, i, boost=boost, preToPostRatio=pre2pst, txSwing=swing, returnTaps=True)
                _stubDict[fpgaNum][tileNum][portId][i]["[cm1,c0,cp1]"][0] = txEqList
                setTxEq(tile, portId, i, txEqList = txEqList)
            else:
                setTxParam(tile, portId, i, param=param, value=_stubDict[fpgaNum][tileNum][portId][i][param][0])

def stubInitEyeParams(tile, portId):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    laneList = getLaneList(tile, portId, type="byPort")

    fpgaNum = tile._fpgaNum
    tileNum = tile._tileNum

    (tmpMode, tmpTopo, tmpBaudRate) = getTileConfig(tile)

    EW          = (_rxLoopDict["vco"][0][1]- _rxLoopDict["vco"][0][0]) * 0.60                                   ## eyeWidth  (x% of available vco steps)
    EH          = (_rxCalDict["dseh"][1]   - _rxCalDict["dseh"][0])    * 0.30                                   ## eyeHeight (x% of available voc steps)
    msmntErr    = 0 if _randomizeStub==False else 0.25                                                          ## run-to-run variation (sigma)
    numLanes    = len(laneList)
    midLane     = (numLanes-1) / 2.0

    for i in laneList:
        if "eye" not in _stubDict[fpgaNum][tileNum][portId][i]:
            _stubDict[fpgaNum][tileNum][portId][i]["eye"] = {}

        xOffset = [0, "uniform(-0.010*EW, 0.010*EW)"]                                                           ## in vco steps (lane to lane vco sampling offset varation)
        yOffset = [0, "uniform(-0.010*EH, 0.010*EH)"]                                                           ## in voc steps (lane to lane voc sampling offset varation)
        dj      = 0 if _randomizeStub==False else ((0.5 if tmpMode=="p" else 0.0) + (0.30*tmpBaudRate))         ## in vco steps (dj proportional to baudRate)
        rjSigma = 0 if _randomizeStub==False else 0.2 + (abs(i-midLane)/(numLanes*2.0))                         ## in vco steps (determines Q-slope; enables variation by dwell; varies by lane)

        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["width"]      = EW
        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["height"]     = EH
        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["xOffset"]    = xOffset
        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["yOffset"]    = yOffset
        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["dj"]         = dj
        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["rjSigma"]    = rjSigma
        _stubDict[fpgaNum][tileNum][portId][i]["eye"]["msmntErr"]   = msmntErr

def stubGetErrCnt(tile, portId, lane=None, vco=None, voc=None, strtVco=None, strtVoc=None, dwell=None, baudRate=None, vcoDir=1, ctle=None, txEq=None, eyeMon=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    if lane==None:
        from time import localtime
        ## generate error every 10sec
        return(randint(1,10) if (localtime().tm_sec%10)==0 else 0)  # nosec (not used for security/cryptographic purposes)

    from math import log
    from math import sqrt
    from random import normalvariate
    from random import uniform

    portId = portId.lower()

    fpgaNum = tile._fpgaNum
    tileNum = tile._tileNum

    EW          = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["width"]
    EH          = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["height"]
    tmpXOffset  = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["xOffset"]
    tmpYOffset  = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["yOffset"]
    dj          = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["dj"]
    rjSigma     = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["rjSigma"]
    msmntErr    = _stubDict[fpgaNum][tileNum][portId][lane]["eye"]["msmntErr"]

    xOffset = tmpXOffset[0] if _randomizeStub==False else eval(tmpXOffset[1])   # nosec (evaluation of internally defined, semi-static string)
    yOffset = tmpYOffset[0] if _randomizeStub==False else eval(tmpYOffset[1])   # nosec (evaluation of internally defined, semi-static string)

    if ctle!=None:
        mp = (_rxLoopDict["ctlep"][1] - _rxLoopDict["ctlep"][0]) / 2.0
        EW  = EW - (abs(ctle-mp) * EW) * 0.025                                                                  ## adjust EW as function of ctle midpoint
        EH  = EH - (abs(ctle-mp) * EH) * 0.025                                                                  ## adjust EH as function of ctle midpoint

    if txEq!=None and isList(txEq) and len(txEq)==3:
        EW  = EW - (abs(c0-(0.75*_fs)) * EW) * 0.010                                                            ## adjust EW as function of filter boost (arbitrary target c0=75%*_fs)
        EH  = EH - (abs(c0-(0.75*_fs)) * EH) * 0.010                                                            ## adjust EH as function of filter boost (arbitrary target c0=75%*_fs)
        xOffset = xOffset + ((0.5 - float(cp1)//(cm1+cp1)) * EW) * 0.20                                         ## adjust vco centering as function of cm1 / cp1 ratio

    adjVco      = vco - strtVco + xOffset
    adjVoc      = voc - strtVoc + yOffset

    uiCnt       = dwell * (baudRate * 1e9)
    qScale      = ber2q(1/float(uiCnt))
    tj          = 2.0 * qScale * rjSigma + normalvariate(dj, msmntErr)                                          ## calculate total jitter (dj randomized by msmntErr)

    adjTmargin  = max(2, EW - (tj * 1.0)) / 2.0
    adjVmargin  = max(2, EH - (tj * 1.5)) / 2.0

    xRatio      = (adjVco**2) / (adjTmargin**2)
    yRatio      = (adjVoc**2) / (adjVmargin**2)

    if eyeMon==True:
        if xRatio + yRatio < 0.8:                                                                               ## start showing errors at 0.8
                                                                                                                ## randomize center of eye for eyeMon=True
            errCnt  = uniform(0, 0.25)  # nosec (not used for security/cryptographic purposes)
        else:
            errCnt  = min(1, (xRatio + yRatio - 0.8))                                                           ## scale percent of errors past edge of eye
    else:
        if xRatio + yRatio < 1.0:                                                                               ## inside ellipse (ie, pass)
            errCnt  = 0
        else:
            tmpQ    = qScale - (0 if rjSigma==0 else (1/rjSigma) * (max(0, (abs(adjVco)-adjTmargin)) + max(0, (abs(adjVoc)-adjVmargin))))
            tmpBer  = q2ber(tmpQ)
            errCnt  = max(1, int(round(tmpBer * uiCnt, 0)))

    return(errCnt)

def stubAccess(tile, portId, lane, param, value=None):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    global _stubDict

    portId  = portId.lower()
    fpgaNum = tile._fpgaNum
    tileNum = tile._tileNum

    if lane==None and param in _stubDict[fpgaNum][tileNum][portId]:
        if value==None:                                                                                         ## read (portId-level) operation
            if _stubDict[fpgaNum][tileNum][portId]!=None:
                readVal = eval("%s"%(_stubDict[fpgaNum][tileNum][portId][param]))   # nosec (evaluation of internally defined, semi-static string)
        elif value!=None:                                                                                       ## write (portId-level) operation
            if param in _stubDict[fpgaNum][tileNum][portId]:
                _stubDict[fpgaNum][tileNum][portId][param] = value

    if lane!=None and param in _stubDict[fpgaNum][tileNum][portId][lane]:
        if value==None:                                                                                         ## read (lane-level) operation
            if _stubDict[fpgaNum][tileNum][portId]!=None:
                if param in _rxCalList or param=="vco":
                    readVal = eval("%s"%(_stubDict[fpgaNum][tileNum][portId][lane][param][0]))  # nosec (evaluation of internally defined, semi-static string)
                elif param in _rxLoopList:
                    readVal = eval("%s"%(_stubDict[fpgaNum][tileNum][portId][lane][param][1]))  # nosec (evaluation of internally defined, semi-static string)
                else:
                    readVal = eval("%s"%(_stubDict[fpgaNum][tileNum][portId][lane][param][0]))  # nosec (evaluation of internally defined, semi-static string)
        elif value!=None:                                                                                       ## write (lane-level) operation
            if param in _stubDict[fpgaNum][tileNum][portId][lane]:
                _stubDict[fpgaNum][tileNum][portId][lane][param][0] = value

    if value==None:
        return(readVal)

###############################################################################
##                                                                            #
##      code debug & regression coverage tools                                #
##                                                                            #
###############################################################################

def _showFunctionInfo(frame):
    global _debug

    callDepth   = len(_traceback.format_stack()) - 3 - (2*_callDepth)

    if _showTopCallOnly==True and callDepth>_callDepth:
        return

    funcName = frame.f_code.co_name
    varList  = frame.f_code.co_varnames
    varDict  = frame.f_locals

    if [a for a in funcName if a.isupper()]==[]:
        prefix  = funcName
    else:
        prefix  = funcName[:funcName.index([a for a in funcName if a.isupper()][0])]

    if "stub" in funcName:
        grpName = "stub"
    elif prefix in list(_colorDict.keys()):
        grpName = prefix
    else:
        grpName = "other"

    fg      = _colorDict[grpName]["fg"]
    bg      = _colorDict[grpName]["bg"]
    fgInt   = _colorDict[grpName]["fgInt"]
    bgInt   = _colorDict[grpName]["bgInt"]

    if "Vco" in funcName:                                               ## special color override
       (fg,bg,fgInt,bgInt) = ("grey","green", True,False)
    elif "Voc" in funcName:
       (fg,bg,fgInt,bgInt) = ("grey", "cyan", True,False)

    optStr = ""
    for var in varList:
        if var not in list(varDict.keys()):
            break

        if isinstance(varDict[var], _namednodes.components.socket_comp.SocketComponent):
            optStr += "%s, "%varDict[var].name
        elif isinstance(varDict[var], _namednodes.registers.RegisterComponent):
            optStr += "%s, "%varDict[var]._tileName
        elif varDict[var]==():
            optStr += "(), "
        elif isinstance(varDict[var], (tuple)):
            optStr += "%s, "%(varDict[var],)
        else:
            optStr += "%5s, "%varDict[var]

    optStr += ")"
    optStr = optStr.replace(", )",")")

    print("\r%s"%("  "*callDepth), end=' ')
    printc("%s%s(%s"%(funcName, " "*(40-(len(funcName)+(2*callDepth))),optStr),fg,bg,fgInt,bgInt)
    print()

    if _showStatus==True and funcName!="showStatus":
        if "tile" in list(varDict.keys()) and "portId" in list(varDict.keys()) and varDict["tile"]!=None:
            _debug=False
            tile = varDict["tile"]
            eval("showStatus(tile, \'%s\', shortForm=True)"%(varDict["portId"]))    # nosec (evaluation of internally defined, semi-static string)
            _debug=True

def getTracer():
    """
    example:
        tracer = x.getTracer()
        tracer.run("test(whr_0, 'p1')")
        x.writeTracerFile(tracer)
        x.readTracerFile("uniphy.uniPhy.cover")
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    import trace
    ignoreDirs = ["C:\\Python27\\Scripts", "C:\\Python27\\Lib\\site-packages", "C:\\PthonSV\\fpga_common\\toolext"]
    ignoreMods = ["namednodes", "random", "logging", "matplotlib", "numpy"]

    tracer = trace.Trace(ignoredirs=ignoreDirs, ignoremods=ignoreMods, trace=0, count=1)
    return(tracer)

def writeTracerFile(tracer):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    result = tracer.results()
    result.write_results(show_missing=True, coverdir=".")

def readTracerFile(coverFile, debug=False):
    if _debug: _showFunctionInfo(_sys._getframe(0))

    inFilePtr = open(coverFile, "r")
    inFileTxt = inFilePtr.read().split("\n")

    outFile = coverFile.replace("cover","diff") + ".py"
    outFilePtr = open(outFile, "w")

    execCnt     = 0
    noExecCnt   = 0
    lineNum     = 1
    outFileTxt  = []
    funcSection = False

    for inLine in inFileTxt:
        if debug==True:
            print("[%5d] - %s"%(lineNum, inLine))

        outLine=""
        if inLine[0:7]=="       ":
            outLine = inLine[7:]                                                                                ## remove 7 spaces at start-of-line
        elif inLine[0:11]==">>>>>> def " or inLine[0:11]=="    1: def ":
            if funcSection==False: funcSection=True
            outLine = inLine[7:]                                                                                ## remove >>>>>> (or '     1:') at start-of-line for def statements
        elif inLine[0:7]==">>>>>> " or inLine[0:7]=="    1: ":
            if funcSection==False:
                outLine = inLine[7:]                                                                            ## remove >>>>>> at start-of-line
            elif funcSection==True:
                outLine = inLine
                noExecCnt += 1
        elif inLine.find(": ") in range(0,10):                                                                  ## remove number at start-of-line
            outLine = inLine[inLine.find(": ")+2:]
            if funcSection==True: execCnt += 1
        else:
            outLine = inLine

        outLine = outLine.replace("        ","\t")
        outFileTxt.append(outLine)
        lineNum += 1

    if debug==True:
        print(execCnt)
        print(noExecCnt)
        print(execCnt + noExecCnt)

    print("line coverage: %3.0f%%"%((100*execCnt) / float(execCnt+noExecCnt)))

    outFilePtr.write("\n".join(outFileTxt))
    outFilePtr.close()
    inFilePtr.close()

###############################################################################
##                                                                            #
##      main function                                                         #
##                                                                            #
###############################################################################

def main(*xargs, **kwargs):
    """ finds, initializes & instantiates object(s) w/in current namespace

    options:
          *xargs   comma-separated string names for discovered tile's
        **kwargs   list of variable/value assignments (ex, _quiet=True, writeDefaults=True, _randomizeStub=True, _randomizePorts=True)

    example:   main("A","B", writeDefaults=True)

    returns:   None
    """
    if _debug: _showFunctionInfo(_sys._getframe(0))

    import __main__
    #import svtools.common.baseaccess as baseaccess

    global _access
    global _subAccess
    global _tileList
    global _fpgaList
    global _tileDict
    global _tileConfigDict
    global _stubDict
    global _initStubMode
    global _randomizeStub
    global _randomizePorts

    #for (key, value) in list(kwargs.items()):                                                                           ## initialize global variables input via command option
    #    if key[0]=="_":
    #        exec("global %s"%key)
    #        if value in [True,False,None]:
    #            exec("%s = %s"%(key, value), globals())
    #        else:
    #            exec("%s = \'%s\'"%(key, value), globals())
    #            

    if _quiet!=True:
        modInfo = getModuleInfo()
        print("%s (v%s) committed by %s on %s"%(modInfo["$Log"][1],modInfo["$Revision"][1],modInfo["$Author"][1],modInfo["$Date"][1]))

    _access = "systemconsole"
    #if _access==None:
    #   _access = baseaccess.getaccess()
    #   if _access in ["stub"]:
    #       _subAccess = baseaccess.CFG.project.stub_subaccess

        # import socket as _socket
        # _hostId = _socket.gethostname().lower()

    if (_access=="stub" and _subAccess=="offline"):
        _initStubMode = kwargs["_initStubMode"] if "_initStubMode" in kwargs else True

    _fpgaList = [fpga for fpga in list(_namednodes.sv.fpga.getAll()) if "fpga" in fpga.name]                    ## create global list of fpga objects

    _tileList = []
    for fpga in _fpgaList:                                                                                      ## build _tileList manually
        if [subComp for subComp in fpga.getSubComponents() if _tileName in subComp]==[]:
            continue
        _tileList += [tile for tile in list(fpga.whrs)]                                                         ## append to global list of tile objects

    if _showWarnings==True and _tileList==[]:
        printc("\nWARNING: no \'%s\' tiles were discovered in this topology.  Program device and try again.\n"%(_tileName),"grey","yellow",True,False,srchStr="WARNING")

    _tileDict = {}
    for fpga in _fpgaList:
        fpgaNum = int(fpga.name[-1])

        for subComp in list(fpga.sub_components.values()):
            if subComp in _tileList:
                if fpgaNum not in _tileDict:
                    _tileDict[fpgaNum] = {}

                if fpgaNum not in _tileConfigDict:
                    _tileConfigDict[fpgaNum] = {}

                tile    = subComp
                preFix  = tile.name[:tile.name.find("_")+1]
                pstFix  = tile.name[tile.name.find("_")+1:]
                tileNum = _tileList.index(tile)                                                                 ## reflects order of discovery
                tileQid = pstFix

                _tileConfigDict[fpgaNum][tileNum] = {}
                _tileDict[fpgaNum][tileNum] = tile

                if (_access in ["stub"] and _subAccess=="snpstc") and tileNum>0:
                    del(fpga.tile.sub_components[tile._tileName])
                else:
                    tile.__dict__["_tileName"] = preFix + str(fpgaNum) + str(tileQid)                           ## insert fpgaNum into tile name
                    tile.__dict__["_tileQid"]  = tileQid
                    tile.__dict__["_tileNum"]  = tileNum
                    tile.__dict__["_fpgaNum"]  = fpgaNum
                    setattr(__main__, "%s"%tile._tileName, tile)                                                ## make objects avaialble to interactive prompt

    if (_access=="stub" and _subAccess=="offline") and _initStubMode==True:
        if _quiet!=True: print()

        writeDefaults = kwargs["writeDefaults"] if "writeDefaults" in kwargs else False

        if writeDefaults==True:
            tmpCompList = ["pcie_ep0","pcie_ep1","pcie_rp2","pcie_rp3","upi_link","upi_link","upi_phy","phy_quad0","phy_quad1","phy_quad2","phy_quad3","phy_quad4"]

            for fpga in _fpgaList:
                if "fpga" not in fpga.name:
                    continue

                fpgaNum = int(fpga.name[-1])

                for tileNum in list(_tileDict[fpgaNum].keys()):
                    tile = _tileDict[fpgaNum][tileNum]
                    for tmpComp in tmpCompList:
                        if _quiet!=True:
                            print("\rPreloading \'%s.%s\' default register values ..."%(tile._tileName, tmpComp), end=' ')
                        exec("tile.%s.writedefaults(recursive=False)"%tmpComp)  # nosec
                        # Justification for a waiver: this a way to execute a "writedefaults" method for each sub-component.

        stubInit()

    initTileInfo(xargs)
    setTileConfigDictGlobal()

    if _initStubMode==True:
        _initStubMode=False

if __name__=="__main__":
    main()

class whrPhyTestError(Exception):
    if _debug==True:
        printc(Exception,"yellow","blue",True,True)
